grammar C7;

file : record* ;
record: selectors ':' '\n'
      | selectors ':' keyspec OPERATOR value ';' '\n'?
      | keyspec OPERATOR value ';' '\n'?
      | SINGLELINE_COMMENT '\n'?;
// Key Side
selectors: selector ('.' selector)*;
selector: IDENTIFIER | '*';
keyspec: namespace ':' keys;
namespace: IDENTIFIER;
keys: IDENTIFIER;
// Value side
value: BOOL | INT | STRING | NUMBER | DURATION;

// other

BOOL: 'true' | 'True' | 'TRUE' | 'false' | 'False' | 'FALSE';
IDENTIFIER: [a-zA-Z][a-zA-Z0-9\-_]*;
OPERATOR: '=';
NUMBER : '-'? INT ('.' [0-9] +)?;
DURATION : NUMBER DURATION_TYPE;
DURATION_TYPE : 'ms' | 's' | 'm' | 'h';
INT : [0-9]+;
STRING: '"' .*? '"' ;
SINGLELINE_COMMENT : '//' ~('\r' | '\n')*;
WS: [ \t\n]+ -> skip;