package main

import (
	"code.justin.tv/amzn/C7-go/internal/specfile"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"os"
	"path"
)

func main() {
	fmt.Println("c7-config-validation-test-generator")

	if len(os.Args) != 4 {
		log.Fatal("usage: c7-config-validation-test-generator specfile outfile c7file")
	}

	specfileName := os.Args[1]
	outfileName := os.Args[2]

	bytes, err := ioutil.ReadFile(specfileName)
	if err != nil {
		log.Fatalf("Error reading specfile %s: %s", specfileName, err)
	}

	var specs []*specfile.Spec
	err = json.Unmarshal(bytes, &specs)
	if err != nil {
		log.Fatalf("Error processing specfile: %s", err)
	}

	// Validate Specs before processing
	for _, spec := range specs {
		if err := spec.Validate(); err != nil {
			log.Fatalf("Error validating: %s", err)
		}
	}

	// Create file for tests
	dirname := path.Dir(outfileName)
	if err = os.MkdirAll(dirname, 0755); err != nil {
		log.Fatalf("Error creating directory %s: %s", dirname, err)
	}

	packageName := path.Base(dirname) + "_test"

	f, err := os.Create(outfileName)
	if err != nil {
		fmt.Errorf("Error creating file %s: %s", outfileName, err)
	}

	// Default the c7 file
	configFile := os.Args[3]

	// Generate
	specfile.OutputSpecTests(packageName, specs, f, configFile)
}
