package resolvers

import (
	"io/ioutil"
	"os"
	"path/filepath"

	"strings"

	"code.justin.tv/amzn/C7-go/c7"
)

// ResolveFilesWithExtension walks a directory tree and loads all files with the given extension
//   dir: the directory to walk
//   extension: the extension to look for
func ResolveFilesWithExtension(dir string, extension string) (*c7.C7Set, error) {
	set := c7.NewC7Set()

	err := filepath.Walk(dir, func(path string, f os.FileInfo, err error) error {
		if f.IsDir() {
			return nil
		}

		if !strings.HasSuffix(path, extension) {
			return nil
		}

		buf, err := ioutil.ReadFile(path)
		if err != nil {
			return err
		}

		newSet, err := c7.Parse(string(buf))
		if err != nil {
			return err
		}

		err = set.Merge(newSet)
		if err != nil {
			return err
		}

		return nil
	})

	return set, err
}

// ResolveFile loads a config from a file or gives an error
func ResolveFile(file string) (*c7.C7Set, error) {
	buf, err := ioutil.ReadFile(file)
	if err != nil {
		return nil, err
	}
	set, err := c7.Parse(string(buf))
	if err != nil {
		return nil, err
	}

	return set, nil
}
