// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/CensusTwirp/twirp.proto

/*
Package twitch_fulton_cbt_census is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/CensusTwirp/twirp.proto
*/
package twitch_fulton_cbt_census

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ================
// Census Interface
// ================

type Census interface {
	// Shared Questions
	GetCensusQuestionnaire(context.Context, *GetCensusQuestionnaireRequest) (*GetCensusQuestionnaireResponse, error)

	// User-Only Questions
	OptOutFromCensus(context.Context, *OptOutFromCensusRequest) (*OptOutFromCensusResponse, error)

	SubmitCensusQuestionnaire(context.Context, *SubmitCensusQuestionnaireRequest) (*SubmitCensusQuestionnaireResponse, error)

	// Management-Only Questions
	SetCensusQuestionnaire(context.Context, *SetCensusQuestionnaireRequest) (*SetCensusQuestionnaireResponse, error)

	SetLocalization(context.Context, *SetLocalizationRequest) (*SetLocalizationResponse, error)

	SetCensusTranslations(context.Context, *SetCensusTranslationsRequest) (*SetCensusTranslationsResponse, error)
}

// ======================
// Census Protobuf Client
// ======================

type censusProtobufClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewCensusProtobufClient creates a Protobuf client that implements the Census interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewCensusProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Census {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + CensusPathPrefix
	urls := [6]string{
		prefix + "GetCensusQuestionnaire",
		prefix + "OptOutFromCensus",
		prefix + "SubmitCensusQuestionnaire",
		prefix + "SetCensusQuestionnaire",
		prefix + "SetLocalization",
		prefix + "SetCensusTranslations",
	}

	return &censusProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *censusProtobufClient) GetCensusQuestionnaire(ctx context.Context, in *GetCensusQuestionnaireRequest) (*GetCensusQuestionnaireResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "GetCensusQuestionnaire")
	out := new(GetCensusQuestionnaireResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusProtobufClient) OptOutFromCensus(ctx context.Context, in *OptOutFromCensusRequest) (*OptOutFromCensusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "OptOutFromCensus")
	out := new(OptOutFromCensusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusProtobufClient) SubmitCensusQuestionnaire(ctx context.Context, in *SubmitCensusQuestionnaireRequest) (*SubmitCensusQuestionnaireResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "SubmitCensusQuestionnaire")
	out := new(SubmitCensusQuestionnaireResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusProtobufClient) SetCensusQuestionnaire(ctx context.Context, in *SetCensusQuestionnaireRequest) (*SetCensusQuestionnaireResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "SetCensusQuestionnaire")
	out := new(SetCensusQuestionnaireResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusProtobufClient) SetLocalization(ctx context.Context, in *SetLocalizationRequest) (*SetLocalizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "SetLocalization")
	out := new(SetLocalizationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusProtobufClient) SetCensusTranslations(ctx context.Context, in *SetCensusTranslationsRequest) (*SetCensusTranslationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "SetCensusTranslations")
	out := new(SetCensusTranslationsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==================
// Census JSON Client
// ==================

type censusJSONClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewCensusJSONClient creates a JSON client that implements the Census interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewCensusJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Census {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + CensusPathPrefix
	urls := [6]string{
		prefix + "GetCensusQuestionnaire",
		prefix + "OptOutFromCensus",
		prefix + "SubmitCensusQuestionnaire",
		prefix + "SetCensusQuestionnaire",
		prefix + "SetLocalization",
		prefix + "SetCensusTranslations",
	}

	return &censusJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *censusJSONClient) GetCensusQuestionnaire(ctx context.Context, in *GetCensusQuestionnaireRequest) (*GetCensusQuestionnaireResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "GetCensusQuestionnaire")
	out := new(GetCensusQuestionnaireResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusJSONClient) OptOutFromCensus(ctx context.Context, in *OptOutFromCensusRequest) (*OptOutFromCensusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "OptOutFromCensus")
	out := new(OptOutFromCensusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusJSONClient) SubmitCensusQuestionnaire(ctx context.Context, in *SubmitCensusQuestionnaireRequest) (*SubmitCensusQuestionnaireResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "SubmitCensusQuestionnaire")
	out := new(SubmitCensusQuestionnaireResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusJSONClient) SetCensusQuestionnaire(ctx context.Context, in *SetCensusQuestionnaireRequest) (*SetCensusQuestionnaireResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "SetCensusQuestionnaire")
	out := new(SetCensusQuestionnaireResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusJSONClient) SetLocalization(ctx context.Context, in *SetLocalizationRequest) (*SetLocalizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "SetLocalization")
	out := new(SetLocalizationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *censusJSONClient) SetCensusTranslations(ctx context.Context, in *SetCensusTranslationsRequest) (*SetCensusTranslationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithMethodName(ctx, "SetCensusTranslations")
	out := new(SetCensusTranslationsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =====================
// Census Server Handler
// =====================

type censusServer struct {
	Census
	hooks *twirp.ServerHooks
}

func NewCensusServer(svc Census, hooks *twirp.ServerHooks) TwirpServer {
	return &censusServer{
		Census: svc,
		hooks:  hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *censusServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// CensusPathPrefix is used for all URL paths on a twirp Census server.
// Requests are always: POST CensusPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const CensusPathPrefix = "/twirp/twitch.fulton.cbt.census.Census/"

func (s *censusServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.cbt.census")
	ctx = ctxsetters.WithServiceName(ctx, "Census")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.cbt.census.Census/GetCensusQuestionnaire":
		s.serveGetCensusQuestionnaire(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.cbt.census.Census/OptOutFromCensus":
		s.serveOptOutFromCensus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.cbt.census.Census/SubmitCensusQuestionnaire":
		s.serveSubmitCensusQuestionnaire(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.cbt.census.Census/SetCensusQuestionnaire":
		s.serveSetCensusQuestionnaire(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.cbt.census.Census/SetLocalization":
		s.serveSetLocalization(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.cbt.census.Census/SetCensusTranslations":
		s.serveSetCensusTranslations(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *censusServer) serveGetCensusQuestionnaire(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCensusQuestionnaireJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCensusQuestionnaireProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *censusServer) serveGetCensusQuestionnaireJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCensusQuestionnaire")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCensusQuestionnaireRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCensusQuestionnaireResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.GetCensusQuestionnaire(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCensusQuestionnaireResponse and nil error while calling GetCensusQuestionnaire. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveGetCensusQuestionnaireProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCensusQuestionnaire")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCensusQuestionnaireRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCensusQuestionnaireResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.GetCensusQuestionnaire(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCensusQuestionnaireResponse and nil error while calling GetCensusQuestionnaire. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveOptOutFromCensus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveOptOutFromCensusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveOptOutFromCensusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *censusServer) serveOptOutFromCensusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OptOutFromCensus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OptOutFromCensusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OptOutFromCensusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.OptOutFromCensus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OptOutFromCensusResponse and nil error while calling OptOutFromCensus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveOptOutFromCensusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "OptOutFromCensus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(OptOutFromCensusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *OptOutFromCensusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.OptOutFromCensus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OptOutFromCensusResponse and nil error while calling OptOutFromCensus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveSubmitCensusQuestionnaire(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSubmitCensusQuestionnaireJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSubmitCensusQuestionnaireProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *censusServer) serveSubmitCensusQuestionnaireJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SubmitCensusQuestionnaire")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SubmitCensusQuestionnaireRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SubmitCensusQuestionnaireResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.SubmitCensusQuestionnaire(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitCensusQuestionnaireResponse and nil error while calling SubmitCensusQuestionnaire. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveSubmitCensusQuestionnaireProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SubmitCensusQuestionnaire")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SubmitCensusQuestionnaireRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SubmitCensusQuestionnaireResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.SubmitCensusQuestionnaire(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SubmitCensusQuestionnaireResponse and nil error while calling SubmitCensusQuestionnaire. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveSetCensusQuestionnaire(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetCensusQuestionnaireJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetCensusQuestionnaireProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *censusServer) serveSetCensusQuestionnaireJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetCensusQuestionnaire")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetCensusQuestionnaireRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetCensusQuestionnaireResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.SetCensusQuestionnaire(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetCensusQuestionnaireResponse and nil error while calling SetCensusQuestionnaire. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveSetCensusQuestionnaireProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetCensusQuestionnaire")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetCensusQuestionnaireRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetCensusQuestionnaireResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.SetCensusQuestionnaire(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetCensusQuestionnaireResponse and nil error while calling SetCensusQuestionnaire. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveSetLocalization(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetLocalizationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetLocalizationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *censusServer) serveSetLocalizationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetLocalization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetLocalizationRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetLocalizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.SetLocalization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetLocalizationResponse and nil error while calling SetLocalization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveSetLocalizationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetLocalization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetLocalizationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetLocalizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.SetLocalization(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetLocalizationResponse and nil error while calling SetLocalization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveSetCensusTranslations(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetCensusTranslationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetCensusTranslationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *censusServer) serveSetCensusTranslationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetCensusTranslations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetCensusTranslationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetCensusTranslationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.SetCensusTranslations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetCensusTranslationsResponse and nil error while calling SetCensusTranslations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) serveSetCensusTranslationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetCensusTranslations")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetCensusTranslationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetCensusTranslationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Census.SetCensusTranslations(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetCensusTranslationsResponse and nil error while calling SetCensusTranslations. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *censusServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *censusServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *censusServer) PathPrefix() string {
	return CensusPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1407 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xdd, 0x6e, 0xdb, 0xc6,
	0x12, 0x3e, 0xd4, 0x9f, 0xad, 0x51, 0x8e, 0xcd, 0x6c, 0x1c, 0x9b, 0xd1, 0x49, 0x1c, 0x85, 0xe7,
	0x1c, 0x54, 0x48, 0x5a, 0x39, 0x51, 0x7f, 0x12, 0x24, 0xbd, 0xa8, 0x6c, 0xd1, 0x8e, 0x10, 0x47,
	0x4a, 0x48, 0x3a, 0x81, 0x83, 0x02, 0x04, 0x4d, 0x6d, 0x64, 0xb6, 0x14, 0xc9, 0x70, 0x57, 0x76,
	0x9c, 0x27, 0x28, 0x10, 0x14, 0xe8, 0x45, 0xef, 0x0b, 0xf4, 0x2d, 0x8a, 0xf6, 0xa2, 0xe8, 0xab,
	0xb4, 0x2f, 0xd1, 0xbb, 0x62, 0xc9, 0xa5, 0x2c, 0x51, 0xa6, 0x25, 0x1b, 0x49, 0x6e, 0x0c, 0xee,
	0xcc, 0x7e, 0xbb, 0xb3, 0xdf, 0xec, 0x37, 0xb3, 0x32, 0xdc, 0xb2, 0xbc, 0x2e, 0xae, 0x7d, 0x33,
	0x20, 0xd4, 0x76, 0x6b, 0xf4, 0x60, 0xcd, 0xec, 0xbf, 0x71, 0xd7, 0x36, 0xb0, 0x4b, 0x06, 0x44,
	0x3f, 0xb4, 0x03, 0x7f, 0x8d, 0xb2, 0xbf, 0x35, 0x3f, 0xf0, 0xa8, 0x87, 0x24, 0x7a, 0x68, 0x53,
	0x6b, 0xbf, 0xf6, 0x72, 0xe0, 0x50, 0xcf, 0xad, 0x59, 0x7b, 0xb4, 0x66, 0x85, 0x53, 0xcb, 0xd7,
	0x7b, 0x9e, 0xd7, 0x73, 0xf0, 0x5a, 0x38, 0x6f, 0x6f, 0xf0, 0x72, 0x8d, 0xda, 0x7d, 0x4c, 0xa8,
	0xd9, 0xe7, 0x50, 0xf9, 0x1e, 0xac, 0x74, 0x7c, 0xda, 0x19, 0xd0, 0xcd, 0xc0, 0xeb, 0x47, 0xeb,
	0xab, 0xf8, 0xd5, 0x00, 0x13, 0x8a, 0xae, 0x01, 0x58, 0xfb, 0xa6, 0xeb, 0x62, 0xc7, 0xb0, 0xbb,
	0x92, 0x50, 0x11, 0xaa, 0x45, 0xb5, 0xc8, 0x2d, 0xad, 0xae, 0xfc, 0xb7, 0x00, 0xd2, 0x24, 0x94,
	0xf8, 0x9e, 0x4b, 0xf0, 0x14, 0x2c, 0x5a, 0x81, 0xb9, 0x01, 0xc1, 0x01, 0xf3, 0x65, 0x42, 0x5f,
	0x81, 0x0d, 0x5b, 0x5d, 0x86, 0xb3, 0x89, 0x41, 0x06, 0x96, 0x85, 0x09, 0x91, 0xb2, 0x15, 0xa1,
	0x3a, 0xaf, 0x16, 0x6d, 0xa2, 0x45, 0x06, 0xf4, 0x15, 0x2c, 0x1c, 0xda, 0x8e, 0x63, 0x04, 0xb8,
	0xef, 0x1d, 0x60, 0xc3, 0xa4, 0x52, 0xae, 0x22, 0x54, 0x4b, 0xf5, 0x72, 0x2d, 0x3a, 0x67, 0x2d,
	0x3e, 0x67, 0x4d, 0x8f, 0xcf, 0xa9, 0x5e, 0x60, 0x08, 0x35, 0x04, 0x34, 0x28, 0x6a, 0x02, 0xe0,
	0x20, 0xf0, 0x02, 0x83, 0x1e, 0xf9, 0x58, 0xca, 0x57, 0x84, 0xea, 0x42, 0xfd, 0xff, 0xb5, 0x34,
	0xfe, 0x6a, 0xd1, 0xb1, 0x14, 0x86, 0x50, 0x8b, 0x21, 0x50, 0x3f, 0xf2, 0xb1, 0xbc, 0x09, 0x85,
	0x86, 0x4b, 0x0e, 0x71, 0x80, 0x16, 0x20, 0x33, 0x3c, 0x60, 0xc6, 0xee, 0x22, 0x04, 0x39, 0x8a,
	0x5f, 0x53, 0x7e, 0xac, 0xf0, 0x1b, 0x49, 0x30, 0xe7, 0x05, 0x5d, 0xdb, 0x35, 0x9d, 0xf0, 0x44,
	0x79, 0x35, 0x1e, 0xca, 0x9f, 0xc1, 0x42, 0xb4, 0xce, 0x90, 0xb8, 0x19, 0xd6, 0x93, 0x7f, 0xc8,
	0xc0, 0xa5, 0xa7, 0x2c, 0x45, 0xb6, 0xe7, 0x3e, 0xb7, 0xe9, 0x7e, 0xb4, 0x04, 0x41, 0x37, 0xe1,
	0x22, 0xb1, 0xf6, 0x71, 0xdf, 0x34, 0x0e, 0x70, 0x40, 0x6c, 0xcf, 0x3d, 0xe6, 0x7e, 0x31, 0x72,
	0x3c, 0x8b, 0xec, 0xad, 0x2e, 0xdf, 0x27, 0x33, 0xb1, 0x4f, 0x76, 0x24, 0x6e, 0x0d, 0x4a, 0x66,
	0xb8, 0x74, 0x44, 0x56, 0x2e, 0x24, 0xab, 0x3e, 0x8d, 0xac, 0x38, 0xb2, 0x28, 0x2a, 0x46, 0x97,
	0x0a, 0xe6, 0xf0, 0x7b, 0x94, 0x8c, 0xfc, 0x18, 0x19, 0xe8, 0x3e, 0xcc, 0x45, 0xf3, 0x88, 0x54,
	0xa8, 0x64, 0xab, 0xa5, 0x7a, 0x25, 0x7d, 0x2b, 0xce, 0x5a, 0x0c, 0x90, 0xbf, 0x17, 0xe0, 0xda,
	0x16, 0xa6, 0xe3, 0x11, 0xb8, 0xa6, 0x1d, 0xe0, 0xf8, 0x36, 0xdf, 0x80, 0x0b, 0x96, 0x37, 0x70,
	0x69, 0x70, 0x64, 0x30, 0x69, 0x71, 0x5e, 0x4a, 0xdc, 0xb6, 0xe1, 0x75, 0x31, 0xe3, 0xcf, 0xc6,
	0xf4, 0xa5, 0xe1, 0x98, 0x6e, 0x6f, 0x60, 0xf6, 0xb0, 0x41, 0xcd, 0x1e, 0xa7, 0x68, 0x91, 0x39,
	0xb6, 0xb9, 0x5d, 0x37, 0x7b, 0x89, 0x0b, 0x9e, 0x4d, 0x8a, 0xe3, 0x37, 0x01, 0x56, 0xd3, 0xe2,
	0xe1, 0x99, 0x7e, 0xc7, 0x01, 0x3d, 0x82, 0xe2, 0x2b, 0xbe, 0x0f, 0x13, 0x0e, 0xe3, 0xef, 0x93,
	0x74, 0xfe, 0x4e, 0xb8, 0x3e, 0xea, 0x31, 0x5e, 0x7e, 0x0d, 0x17, 0x37, 0xbc, 0xbe, 0xef, 0x60,
	0x8a, 0xbb, 0xf1, 0xd4, 0x89, 0xab, 0xa9, 0x81, 0xc8, 0xaf, 0x47, 0xc0, 0xcf, 0x44, 0xa4, 0x4c,
	0xb8, 0x71, 0x75, 0x6a, 0xe2, 0x38, 0x40, 0x5d, 0x34, 0xc7, 0xc6, 0x44, 0xfe, 0x2b, 0x0b, 0x15,
	0x6d, 0xb0, 0xd7, 0xb7, 0x3f, 0x60, 0x2e, 0xab, 0xc0, 0xe5, 0xc1, 0x65, 0x33, 0x4c, 0x68, 0xd2,
	0x9c, 0xc8, 0x7a, 0x2e, 0x59, 0xd6, 0xbe, 0x86, 0x4b, 0x56, 0x4c, 0x9b, 0x71, 0x9c, 0x8d, 0x7c,
	0x48, 0xca, 0xad, 0x53, 0x84, 0x93, 0xe4, 0x5a, 0x45, 0x56, 0xd2, 0x44, 0xd0, 0x1a, 0x2c, 0x85,
	0xc5, 0xcf, 0xf3, 0xa9, 0x61, 0xbb, 0x86, 0xe9, 0x9a, 0xce, 0x11, 0xb1, 0x99, 0x58, 0x58, 0x95,
	0xbc, 0xc8, 0x7c, 0x1d, 0x9f, 0xb6, 0xdc, 0x06, 0x77, 0xa0, 0xcf, 0x61, 0x65, 0x14, 0xd0, 0xc5,
	0x07, 0xd8, 0xf1, 0xfc, 0x3e, 0x76, 0xa9, 0x34, 0x17, 0x62, 0x96, 0x86, 0x98, 0xe6, 0xb1, 0x2f,
	0xb9, 0x4f, 0x80, 0x09, 0x36, 0x03, 0x6b, 0x5f, 0x9a, 0x4f, 0xec, 0xa3, 0x72, 0x07, 0xba, 0x03,
	0x97, 0x47, 0x01, 0x7d, 0x33, 0xf8, 0x16, 0x53, 0xdb, 0xed, 0x49, 0xc5, 0x10, 0x81, 0x86, 0x88,
	0xc7, 0xb1, 0x47, 0xfe, 0x5d, 0x80, 0x1b, 0xa7, 0xa4, 0xf9, 0xfd, 0x76, 0x91, 0xf1, 0x1e, 0x90,
	0x3b, 0x67, 0x0f, 0x68, 0xc2, 0x7f, 0x53, 0x15, 0x3e, 0x70, 0xe8, 0x8c, 0x5d, 0xf4, 0xcf, 0x1c,
	0xfc, 0xef, 0xf4, 0x65, 0x38, 0x17, 0x0f, 0xa0, 0x14, 0x60, 0xcb, 0x0b, 0xba, 0xb8, 0xcb, 0xfa,
	0x9e, 0x30, 0xb5, 0xef, 0x41, 0x3c, 0xbd, 0x41, 0xd1, 0x75, 0x28, 0x99, 0xbe, 0x1f, 0xb7, 0x05,
	0xce, 0x16, 0x98, 0xbe, 0xcf, 0x1b, 0xc2, 0x84, 0xa2, 0xb2, 0x33, 0x2a, 0x2a, 0x37, 0xb3, 0xa2,
	0xf2, 0xb3, 0x28, 0xaa, 0x30, 0xa3, 0xa2, 0xe6, 0xde, 0xaf, 0xa2, 0xe6, 0xcf, 0xa1, 0xa8, 0xe2,
	0x39, 0x14, 0x05, 0x67, 0x56, 0x54, 0x29, 0x4d, 0x51, 0xe8, 0x3f, 0x50, 0x8c, 0x12, 0xce, 0x78,
	0xbc, 0x10, 0xf2, 0x38, 0x1f, 0x19, 0x5a, 0x5d, 0xf9, 0x57, 0x01, 0xae, 0x69, 0x1f, 0xb2, 0x3d,
	0xbe, 0xd3, 0x6e, 0xf4, 0x93, 0x00, 0xab, 0x1a, 0x9e, 0x56, 0x29, 0x46, 0x14, 0x2f, 0x24, 0x15,
	0xff, 0x31, 0x20, 0x82, 0xe9, 0xf0, 0x02, 0x19, 0xe1, 0xb1, 0xc2, 0xd8, 0xf3, 0xaa, 0x48, 0x30,
	0x8d, 0x17, 0xdd, 0x60, 0x76, 0x74, 0x1b, 0x96, 0xa2, 0xfa, 0x90, 0x98, 0x1f, 0x3d, 0xde, 0x50,
	0xe8, 0x1b, 0x43, 0xc8, 0x7f, 0x08, 0xb0, 0xac, 0x61, 0xba, 0xed, 0x59, 0xa6, 0x63, 0xbf, 0x31,
	0xc3, 0x0b, 0xc7, 0x89, 0x4d, 0x76, 0xcd, 0x32, 0xcc, 0x3b, 0x9e, 0x15, 0x4e, 0xe1, 0xe4, 0x0d,
	0xc7, 0x68, 0x19, 0x0a, 0xec, 0xdb, 0x89, 0xf5, 0xc7, 0x47, 0x2c, 0x39, 0xd8, 0xed, 0x39, 0x36,
	0xd9, 0x37, 0xc2, 0x47, 0x5a, 0xa4, 0xba, 0x12, 0xb7, 0xe9, 0xec, 0xad, 0xf6, 0x11, 0x2c, 0xd2,
	0xc0, 0x74, 0x89, 0x63, 0x32, 0xa5, 0x84, 0xb3, 0x22, 0xc5, 0x2d, 0x1c, 0x9b, 0x75, 0xfe, 0x18,
	0xb5, 0x3c, 0x37, 0x9c, 0x10, 0xa9, 0x2d, 0x1e, 0xca, 0x0f, 0x61, 0x65, 0xe2, 0x0c, 0x29, 0xaf,
	0xd2, 0x71, 0xba, 0x33, 0x09, 0xba, 0xe5, 0xdb, 0x70, 0x75, 0x98, 0x2f, 0x9d, 0x6f, 0xcf, 0x32,
	0x19, 0x73, 0x22, 0x42, 0x76, 0x10, 0x38, 0x7c, 0x3d, 0xf6, 0x29, 0xbf, 0x18, 0xb9, 0x9f, 0xe3,
	0x88, 0xd9, 0x12, 0x5c, 0x86, 0xf9, 0xf8, 0x11, 0x12, 0xb3, 0x1a, 0x8f, 0x6f, 0xfe, 0x9c, 0x81,
	0xd2, 0x48, 0x0d, 0x47, 0x2b, 0x70, 0x69, 0xa7, 0xfd, 0xa8, 0xdd, 0x79, 0xde, 0x36, 0x14, 0x55,
	0xed, 0xa8, 0x86, 0xa6, 0x37, 0x74, 0x45, 0xfc, 0x17, 0x5a, 0x84, 0xd2, 0x7a, 0xa3, 0x69, 0xa8,
	0xca, 0xd3, 0x1d, 0x45, 0xd3, 0x45, 0x01, 0xfd, 0x1b, 0x8a, 0x9b, 0x1d, 0x75, 0xbd, 0xd5, 0x6c,
	0x2a, 0x6d, 0x31, 0x83, 0x10, 0x2c, 0x6c, 0x29, 0x1d, 0x43, 0x55, 0x34, 0x5d, 0x6d, 0x6d, 0xe8,
	0x4a, 0x53, 0xcc, 0xa2, 0x65, 0x40, 0x9b, 0x8d, 0xd6, 0xb6, 0xd2, 0x34, 0xf4, 0x8e, 0xb1, 0xa5,
	0xe8, 0xc6, 0x8e, 0xa6, 0xa8, 0x62, 0x1e, 0x5d, 0x81, 0xcb, 0xc7, 0xf6, 0x67, 0x8a, 0xda, 0xda,
	0xdc, 0x8d, 0x5c, 0x80, 0x64, 0x58, 0x3d, 0xd1, 0x65, 0xac, 0xb7, 0x54, 0xfd, 0x61, 0xb3, 0xb1,
	0x2b, 0x2e, 0xa1, 0x55, 0x28, 0x4f, 0xcc, 0x09, 0xa3, 0x6a, 0x75, 0xda, 0x9a, 0xb8, 0x8a, 0xae,
	0x82, 0x34, 0xe1, 0x6f, 0xb4, 0xb5, 0xe7, 0x8a, 0xaa, 0x89, 0x55, 0x16, 0xd4, 0x93, 0x8e, 0xa6,
	0x1b, 0xda, 0x8e, 0xfa, 0x4c, 0xd9, 0x35, 0xa2, 0x99, 0x62, 0x9d, 0x05, 0xc5, 0x4d, 0x9d, 0x27,
	0xba, 0xd1, 0xd9, 0xd1, 0x63, 0xd7, 0x97, 0x37, 0x75, 0x90, 0xd2, 0x9e, 0xef, 0xa3, 0x84, 0x45,
	0x7b, 0x18, 0xfa, 0xee, 0x13, 0x46, 0x18, 0x40, 0x41, 0x6b, 0xb5, 0xb7, 0xb6, 0x15, 0x51, 0x40,
	0x45, 0xc8, 0x3f, 0xde, 0xd9, 0xd6, 0x5b, 0x62, 0x06, 0xcd, 0x43, 0x6e, 0x53, 0x55, 0x14, 0x31,
	0x5b, 0xff, 0xa5, 0x00, 0x85, 0x68, 0x59, 0xf4, 0x56, 0x80, 0xe5, 0x93, 0x1b, 0x1d, 0xba, 0x9b,
	0x5e, 0x19, 0x4e, 0x7d, 0xd3, 0x97, 0xef, 0x9d, 0x1d, 0xc8, 0xaf, 0xd3, 0x11, 0x88, 0xc9, 0xdf,
	0xae, 0xe8, 0x4e, 0xfa, 0x6a, 0x29, 0x3f, 0x91, 0xcb, 0xf5, 0xb3, 0x40, 0xf8, 0xd6, 0x3f, 0x0a,
	0x70, 0x25, 0xf5, 0xe9, 0x83, 0xee, 0xa7, 0xaf, 0x38, 0xed, 0x59, 0x5c, 0x7e, 0x70, 0x2e, 0x2c,
	0x0f, 0xeb, 0x6d, 0x54, 0xc2, 0xce, 0x98, 0x1f, 0xed, 0xbc, 0xf9, 0x99, 0x52, 0xcf, 0x0f, 0x60,
	0x31, 0x51, 0x8b, 0xd0, 0xed, 0x53, 0x17, 0x3b, 0xa1, 0xf4, 0x96, 0xef, 0x9c, 0x01, 0xc1, 0xf7,
	0xfd, 0x4e, 0x80, 0xcb, 0x27, 0x16, 0x22, 0xf4, 0xc5, 0x0c, 0x67, 0x39, 0xa1, 0xd6, 0x95, 0xef,
	0x9e, 0x19, 0x17, 0x85, 0xb2, 0x5e, 0x7e, 0x91, 0xfa, 0x6f, 0x9d, 0xbd, 0x42, 0xf8, 0xde, 0xfb,
	0xf4, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa7, 0xf3, 0x88, 0x3a, 0x26, 0x12, 0x00, 0x00,
}
