// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/CorleoneTwirp/twirp.proto

/*
Package CorleoneTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/CorleoneTwirp/consts.proto
	code.justin.tv/amzn/CorleoneTwirp/twirp.proto
*/
package CorleoneTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ==================
// Corleone Interface
// ==================

type Corleone interface {
	// CloneOfferWithPromotionID clones the given Offer and sets Promotion ID.
	CloneOfferWithPromotionID(context.Context, *CloneOfferWithPromotionIDRequest) (*CloneOfferWithPromotionIDResponse, error)

	// GetOffers retrieves all Offers available for a TPLR and client (web, ios, android) matching provided tags.
	GetOffers(context.Context, *GetOffersRequest) (*GetOffersResponse, error)

	// GetOffersEligibility retrieves the eligibility for each Offer matching the given parameters for a given user.
	GetOffersEligibility(context.Context, *GetOffersEligibilityRequest) (*GetOffersEligibilityResponse, error)

	// BatchGetOffersEligibility retrieves the eligibility for each Offer matching the given parameters for a given user,
	// batching calls to TPLRs that share EligibilityURIs.
	BatchGetOffersEligibility(context.Context, *BatchGetOffersEligibilityRequest) (*BatchGetOffersEligibilityResponse, error)

	// GetOfferByID retrieves an Offer Document represented by an ID.
	GetOfferByID(context.Context, *GetOfferByIDRequest) (*GetOfferByIDResponse, error)

	// GetTPLRs retrieves all TPLRs.
	GetTPLRs(context.Context, *GetTPLRsRequest) (*GetTPLRsResponse, error)

	// GetOfferWithEligibility retrieves an offer with the eligibility for a given user.
	GetOfferWithEligibility(context.Context, *GetOfferWithEligibilityRequest) (*GetOfferWithEligibilityResponse, error)
}

// ========================
// Corleone Protobuf Client
// ========================

type corleoneProtobufClient struct {
	client HTTPClient
	urls   [7]string
	opts   twirp.ClientOptions
}

// NewCorleoneProtobufClient creates a Protobuf client that implements the Corleone interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewCorleoneProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Corleone {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + CorleonePathPrefix
	urls := [7]string{
		prefix + "CloneOfferWithPromotionID",
		prefix + "GetOffers",
		prefix + "GetOffersEligibility",
		prefix + "BatchGetOffersEligibility",
		prefix + "GetOfferByID",
		prefix + "GetTPLRs",
		prefix + "GetOfferWithEligibility",
	}

	return &corleoneProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *corleoneProtobufClient) CloneOfferWithPromotionID(ctx context.Context, in *CloneOfferWithPromotionIDRequest) (*CloneOfferWithPromotionIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "CloneOfferWithPromotionID")
	out := new(CloneOfferWithPromotionIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneProtobufClient) GetOffers(ctx context.Context, in *GetOffersRequest) (*GetOffersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetOffers")
	out := new(GetOffersResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneProtobufClient) GetOffersEligibility(ctx context.Context, in *GetOffersEligibilityRequest) (*GetOffersEligibilityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetOffersEligibility")
	out := new(GetOffersEligibilityResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneProtobufClient) BatchGetOffersEligibility(ctx context.Context, in *BatchGetOffersEligibilityRequest) (*BatchGetOffersEligibilityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetOffersEligibility")
	out := new(BatchGetOffersEligibilityResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneProtobufClient) GetOfferByID(ctx context.Context, in *GetOfferByIDRequest) (*GetOfferByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetOfferByID")
	out := new(GetOfferByIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneProtobufClient) GetTPLRs(ctx context.Context, in *GetTPLRsRequest) (*GetTPLRsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetTPLRs")
	out := new(GetTPLRsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneProtobufClient) GetOfferWithEligibility(ctx context.Context, in *GetOfferWithEligibilityRequest) (*GetOfferWithEligibilityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetOfferWithEligibility")
	out := new(GetOfferWithEligibilityResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================
// Corleone JSON Client
// ====================

type corleoneJSONClient struct {
	client HTTPClient
	urls   [7]string
	opts   twirp.ClientOptions
}

// NewCorleoneJSONClient creates a JSON client that implements the Corleone interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewCorleoneJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Corleone {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + CorleonePathPrefix
	urls := [7]string{
		prefix + "CloneOfferWithPromotionID",
		prefix + "GetOffers",
		prefix + "GetOffersEligibility",
		prefix + "BatchGetOffersEligibility",
		prefix + "GetOfferByID",
		prefix + "GetTPLRs",
		prefix + "GetOfferWithEligibility",
	}

	return &corleoneJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *corleoneJSONClient) CloneOfferWithPromotionID(ctx context.Context, in *CloneOfferWithPromotionIDRequest) (*CloneOfferWithPromotionIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "CloneOfferWithPromotionID")
	out := new(CloneOfferWithPromotionIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneJSONClient) GetOffers(ctx context.Context, in *GetOffersRequest) (*GetOffersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetOffers")
	out := new(GetOffersResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneJSONClient) GetOffersEligibility(ctx context.Context, in *GetOffersEligibilityRequest) (*GetOffersEligibilityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetOffersEligibility")
	out := new(GetOffersEligibilityResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneJSONClient) BatchGetOffersEligibility(ctx context.Context, in *BatchGetOffersEligibilityRequest) (*BatchGetOffersEligibilityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetOffersEligibility")
	out := new(BatchGetOffersEligibilityResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneJSONClient) GetOfferByID(ctx context.Context, in *GetOfferByIDRequest) (*GetOfferByIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetOfferByID")
	out := new(GetOfferByIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneJSONClient) GetTPLRs(ctx context.Context, in *GetTPLRsRequest) (*GetTPLRsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetTPLRs")
	out := new(GetTPLRsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *corleoneJSONClient) GetOfferWithEligibility(ctx context.Context, in *GetOfferWithEligibilityRequest) (*GetOfferWithEligibilityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithMethodName(ctx, "GetOfferWithEligibility")
	out := new(GetOfferWithEligibilityResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// Corleone Server Handler
// =======================

type corleoneServer struct {
	Corleone
	hooks *twirp.ServerHooks
}

func NewCorleoneServer(svc Corleone, hooks *twirp.ServerHooks) TwirpServer {
	return &corleoneServer{
		Corleone: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *corleoneServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// CorleonePathPrefix is used for all URL paths on a twirp Corleone server.
// Requests are always: POST CorleonePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const CorleonePathPrefix = "/twirp/twitch.payments.corleone.Corleone/"

func (s *corleoneServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.payments.corleone")
	ctx = ctxsetters.WithServiceName(ctx, "Corleone")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.payments.corleone.Corleone/CloneOfferWithPromotionID":
		s.serveCloneOfferWithPromotionID(ctx, resp, req)
		return
	case "/twirp/twitch.payments.corleone.Corleone/GetOffers":
		s.serveGetOffers(ctx, resp, req)
		return
	case "/twirp/twitch.payments.corleone.Corleone/GetOffersEligibility":
		s.serveGetOffersEligibility(ctx, resp, req)
		return
	case "/twirp/twitch.payments.corleone.Corleone/BatchGetOffersEligibility":
		s.serveBatchGetOffersEligibility(ctx, resp, req)
		return
	case "/twirp/twitch.payments.corleone.Corleone/GetOfferByID":
		s.serveGetOfferByID(ctx, resp, req)
		return
	case "/twirp/twitch.payments.corleone.Corleone/GetTPLRs":
		s.serveGetTPLRs(ctx, resp, req)
		return
	case "/twirp/twitch.payments.corleone.Corleone/GetOfferWithEligibility":
		s.serveGetOfferWithEligibility(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *corleoneServer) serveCloneOfferWithPromotionID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCloneOfferWithPromotionIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCloneOfferWithPromotionIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *corleoneServer) serveCloneOfferWithPromotionIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CloneOfferWithPromotionID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CloneOfferWithPromotionIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CloneOfferWithPromotionIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.CloneOfferWithPromotionID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CloneOfferWithPromotionIDResponse and nil error while calling CloneOfferWithPromotionID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveCloneOfferWithPromotionIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CloneOfferWithPromotionID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CloneOfferWithPromotionIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CloneOfferWithPromotionIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.CloneOfferWithPromotionID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CloneOfferWithPromotionIDResponse and nil error while calling CloneOfferWithPromotionID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetOffers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetOffersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOffersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *corleoneServer) serveGetOffersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOffers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetOffersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOffersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetOffers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOffersResponse and nil error while calling GetOffers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetOffersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOffers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetOffersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOffersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetOffers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOffersResponse and nil error while calling GetOffers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetOffersEligibility(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetOffersEligibilityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOffersEligibilityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *corleoneServer) serveGetOffersEligibilityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOffersEligibility")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetOffersEligibilityRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOffersEligibilityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetOffersEligibility(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOffersEligibilityResponse and nil error while calling GetOffersEligibility. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetOffersEligibilityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOffersEligibility")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetOffersEligibilityRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOffersEligibilityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetOffersEligibility(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOffersEligibilityResponse and nil error while calling GetOffersEligibility. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveBatchGetOffersEligibility(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBatchGetOffersEligibilityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBatchGetOffersEligibilityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *corleoneServer) serveBatchGetOffersEligibilityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetOffersEligibility")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BatchGetOffersEligibilityRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchGetOffersEligibilityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.BatchGetOffersEligibility(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchGetOffersEligibilityResponse and nil error while calling BatchGetOffersEligibility. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveBatchGetOffersEligibilityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetOffersEligibility")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BatchGetOffersEligibilityRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchGetOffersEligibilityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.BatchGetOffersEligibility(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchGetOffersEligibilityResponse and nil error while calling BatchGetOffersEligibility. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetOfferByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetOfferByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOfferByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *corleoneServer) serveGetOfferByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOfferByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetOfferByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOfferByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetOfferByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOfferByIDResponse and nil error while calling GetOfferByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetOfferByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOfferByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetOfferByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOfferByIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetOfferByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOfferByIDResponse and nil error while calling GetOfferByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetTPLRs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTPLRsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTPLRsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *corleoneServer) serveGetTPLRsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTPLRs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTPLRsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTPLRsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetTPLRs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTPLRsResponse and nil error while calling GetTPLRs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetTPLRsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTPLRs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTPLRsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTPLRsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetTPLRs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTPLRsResponse and nil error while calling GetTPLRs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetOfferWithEligibility(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetOfferWithEligibilityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOfferWithEligibilityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *corleoneServer) serveGetOfferWithEligibilityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOfferWithEligibility")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetOfferWithEligibilityRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOfferWithEligibilityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetOfferWithEligibility(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOfferWithEligibilityResponse and nil error while calling GetOfferWithEligibility. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) serveGetOfferWithEligibilityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOfferWithEligibility")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetOfferWithEligibilityRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOfferWithEligibilityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Corleone.GetOfferWithEligibility(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOfferWithEligibilityResponse and nil error while calling GetOfferWithEligibility. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *corleoneServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *corleoneServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *corleoneServer) PathPrefix() string {
	return CorleonePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2447 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xdd, 0x72, 0x1b, 0x49,
	0x15, 0x66, 0xf4, 0xaf, 0x23, 0x5b, 0x96, 0xdb, 0x49, 0x56, 0xd1, 0x2e, 0x89, 0x3d, 0xa9, 0x64,
	0x9d, 0x64, 0xa3, 0x2c, 0xde, 0x65, 0x77, 0x93, 0x54, 0x65, 0xb1, 0x25, 0x6d, 0x2c, 0xd6, 0x1b,
	0x3b, 0x63, 0x27, 0x61, 0xb7, 0x80, 0xa9, 0xf6, 0x4c, 0x5b, 0x6e, 0x32, 0x9a, 0xd1, 0xce, 0xb4,
	0x1c, 0x1b, 0xae, 0xa1, 0x8a, 0xa2, 0x8a, 0x2b, 0xee, 0xb8, 0xdd, 0x07, 0x00, 0xde, 0x80, 0x27,
	0x80, 0x1b, 0x8a, 0x02, 0x5e, 0x81, 0x87, 0xa0, 0xfa, 0x6f, 0x34, 0x92, 0x2d, 0xc9, 0x56, 0x72,
	0xc1, 0x8d, 0x4b, 0x7d, 0xfa, 0x9c, 0xd3, 0xdd, 0xe7, 0x7c, 0xe7, 0xa7, 0x7b, 0x0c, 0xf7, 0x9c,
	0xc0, 0x25, 0xf5, 0x5f, 0xf4, 0x23, 0x46, 0xfd, 0x3a, 0x3b, 0xba, 0x8f, 0xbb, 0xbf, 0xf4, 0xef,
	0x37, 0x82, 0xd0, 0x23, 0x81, 0x4f, 0xf6, 0x5e, 0xd3, 0xb0, 0x77, 0x9f, 0xf1, 0xbf, 0xf5, 0x5e,
	0x18, 0xb0, 0x00, 0x55, 0xd9, 0x6b, 0xca, 0x9c, 0xc3, 0x7a, 0x0f, 0x9f, 0x74, 0x89, 0xcf, 0xa2,
	0xba, 0xa3, 0x58, 0x6b, 0xf5, 0xe9, 0x8a, 0x9c, 0xc0, 0x8f, 0x58, 0x24, 0x35, 0xd5, 0xae, 0x77,
	0x82, 0xa0, 0xe3, 0x91, 0xfb, 0x62, 0xb4, 0xdf, 0x3f, 0xb8, 0xcf, 0x68, 0x97, 0x44, 0x0c, 0x77,
	0xd5, 0x52, 0xe6, 0x3f, 0x0c, 0x58, 0x6e, 0x78, 0x81, 0x4f, 0xb6, 0x0f, 0x0e, 0x48, 0xf8, 0x92,
	0xb2, 0xc3, 0x9d, 0x30, 0xe8, 0x06, 0x8c, 0x06, 0x7e, 0xbb, 0x69, 0x91, 0x6f, 0xfb, 0x24, 0x62,
	0xe8, 0x16, 0x2c, 0x44, 0x41, 0x3f, 0x74, 0x88, 0x1d, 0x70, 0x2e, 0x9b, 0xba, 0x55, 0x63, 0xd9,
	0x58, 0x2d, 0x5a, 0xf3, 0x92, 0x2c, 0x64, 0xdb, 0x2e, 0xe7, 0x63, 0x38, 0xec, 0x10, 0x36, 0xe0,
	0x4b, 0x49, 0x3e, 0x49, 0xd6, 0x7c, 0x2b, 0x30, 0xd7, 0xd3, 0xab, 0x70, 0xa6, 0xb4, 0x60, 0x2a,
	0xc5, 0xb4, 0xb6, 0x8b, 0x1e, 0x43, 0xe1, 0xdb, 0x3e, 0xf6, 0x19, 0x65, 0x27, 0xd5, 0xcc, 0xb2,
	0xb1, 0x5a, 0x5a, 0x33, 0xeb, 0xe3, 0xac, 0x52, 0x7f, 0xa6, 0x38, 0xad, 0x58, 0xc6, 0xfc, 0x06,
	0x56, 0x26, 0x1c, 0x2b, 0xea, 0x05, 0x7e, 0x44, 0xd0, 0x0f, 0x21, 0x2b, 0x36, 0x2a, 0x4e, 0x53,
	0x5a, 0xbb, 0x3e, 0x7e, 0x05, 0xa1, 0xc6, 0x92, 0xdc, 0xe6, 0xdf, 0x0c, 0xa8, 0x3c, 0x51, 0xa7,
	0x89, 0xb4, 0x8d, 0xde, 0x85, 0x22, 0xeb, 0x79, 0xa1, 0xed, 0xe3, 0x2e, 0x51, 0xd6, 0x29, 0x70,
	0xc2, 0x53, 0xdc, 0x25, 0x7c, 0xd2, 0xf1, 0x28, 0xf1, 0xd9, 0xc0, 0x24, 0x05, 0x49, 0x68, 0xbb,
	0x68, 0x13, 0x32, 0x0c, 0x77, 0xa2, 0x6a, 0x7a, 0x39, 0xbd, 0x5a, 0x5a, 0xfb, 0x78, 0xfc, 0x26,
	0x46, 0xd7, 0xac, 0xef, 0xe1, 0x4e, 0xd4, 0xf2, 0x59, 0x78, 0x62, 0x09, 0x0d, 0xb5, 0x4f, 0xa1,
	0x18, 0x93, 0x50, 0x05, 0xd2, 0xaf, 0xc8, 0x89, 0xda, 0x0a, 0xff, 0x89, 0x2e, 0x41, 0xf6, 0x08,
	0x7b, 0x7d, 0xa2, 0x76, 0x20, 0x07, 0x0f, 0x53, 0x9f, 0x19, 0xe6, 0x16, 0x2c, 0x26, 0x94, 0x2b,
	0xeb, 0x7c, 0x0a, 0x39, 0x71, 0xde, 0xa8, 0x6a, 0x88, 0x9d, 0x4d, 0x35, 0x8f, 0x62, 0x37, 0xff,
	0x94, 0x86, 0x77, 0x63, 0x75, 0x2d, 0x8f, 0x76, 0xe8, 0x3e, 0xf5, 0xb8, 0x7b, 0xde, 0xd8, 0x54,
	0xbb, 0x43, 0xa6, 0xfa, 0xfc, 0x1c, 0xa6, 0x3a, 0xbd, 0xfc, 0xa8, 0xd5, 0xd0, 0x3b, 0x90, 0xef,
	0x47, 0x12, 0xad, 0x19, 0xb1, 0x5e, 0x8e, 0x0f, 0xdb, 0x2e, 0xdf, 0x8a, 0x4b, 0x8e, 0xa8, 0x43,
	0xf8, 0x54, 0x56, 0x6e, 0x45, 0x12, 0x24, 0x86, 0x9d, 0xa0, 0xcf, 0xd5, 0xd8, 0x3c, 0x26, 0xab,
	0x39, 0x89, 0x61, 0x45, 0x6b, 0x04, 0x2e, 0x41, 0x1f, 0x00, 0xea, 0xd0, 0x03, 0x66, 0x87, 0xc4,
	0xa1, 0x3d, 0x75, 0xa4, 0xa8, 0x9a, 0x5f, 0x4e, 0xaf, 0x16, 0xad, 0x0a, 0x9f, 0xb1, 0xf4, 0x44,
	0xdb, 0x8d, 0xd0, 0x06, 0x40, 0x48, 0xb0, 0x6b, 0xbb, 0xa4, 0xc7, 0x0e, 0xab, 0x85, 0x65, 0x63,
	0xb5, 0xbc, 0x76, 0x63, 0xfc, 0x09, 0x2d, 0x82, 0xdd, 0x26, 0x67, 0xb5, 0x8a, 0xa1, 0xfe, 0x39,
	0x3b, 0x00, 0x4e, 0xe0, 0xbd, 0xb3, 0x4d, 0xa6, 0xb0, 0xf0, 0x35, 0x20, 0xe9, 0x5c, 0x9b, 0x0c,
	0x66, 0x15, 0x2e, 0xee, 0x4c, 0xc1, 0x45, 0x52, 0xdf, 0x62, 0x30, 0xba, 0x84, 0xf9, 0xf7, 0x14,
	0x2c, 0x6f, 0x60, 0xe6, 0x1c, 0x4e, 0x81, 0xcc, 0x00, 0x15, 0xc6, 0x08, 0x2a, 0x12, 0x0e, 0x4c,
	0x8d, 0x77, 0x60, 0x7a, 0x8a, 0x03, 0x33, 0xe7, 0x75, 0x60, 0xf6, 0x5c, 0x0e, 0xcc, 0xcd, 0xe2,
	0x40, 0xd4, 0x84, 0x92, 0x08, 0x8d, 0x1e, 0x0e, 0x71, 0x57, 0x62, 0xa5, 0x34, 0x49, 0xc9, 0xde,
	0xce, 0x96, 0xb5, 0xc3, 0x79, 0x2d, 0xe0, 0x72, 0xe2, 0x67, 0x64, 0x7e, 0x67, 0x40, 0x31, 0x9e,
	0x99, 0x1c, 0x6e, 0xeb, 0x2a, 0xa2, 0x52, 0x62, 0xa5, 0x7b, 0xe7, 0x58, 0xe9, 0xed, 0x65, 0x9d,
	0x5f, 0xc1, 0xca, 0x04, 0xc7, 0x2b, 0xe4, 0xbd, 0x80, 0x45, 0xbe, 0xd9, 0xb3, 0x80, 0x77, 0x7b,
	0xf2, 0x6e, 0x93, 0xda, 0x2a, 0x42, 0x47, 0x12, 0x76, 0xbf, 0x4b, 0xc1, 0xc2, 0x08, 0xd7, 0x64,
	0x4b, 0x3d, 0x19, 0xb2, 0xd4, 0x47, 0xe7, 0x5e, 0xfb, 0x54, 0xbe, 0x39, 0x3b, 0x96, 0xd2, 0x6f,
	0x21, 0x96, 0x66, 0x77, 0xc5, 0x63, 0x58, 0xd2, 0x5e, 0xd8, 0x38, 0x19, 0x14, 0xfe, 0x32, 0xa4,
	0xe2, 0x78, 0x4b, 0xd1, 0xf1, 0x91, 0x66, 0x7e, 0x05, 0x97, 0x86, 0xe5, 0xdf, 0xac, 0xc2, 0x2e,
	0xc2, 0xc2, 0x13, 0xc2, 0xb8, 0x21, 0x75, 0xad, 0x33, 0x37, 0x45, 0xcd, 0x55, 0x24, 0xa5, 0xfd,
	0x63, 0xc8, 0x0a, 0xbf, 0x2a, 0x3c, 0x5c, 0x9b, 0xec, 0x13, 0x4b, 0x32, 0x9b, 0xff, 0x49, 0xc3,
	0x35, 0xbd, 0x59, 0xde, 0x19, 0x9c, 0x91, 0x6e, 0xae, 0x42, 0x61, 0xa4, 0xd3, 0xc9, 0x07, 0xaa,
	0x77, 0x99, 0x58, 0x9f, 0x12, 0xf6, 0x49, 0x8f, 0xcf, 0x44, 0x99, 0x29, 0x99, 0x28, 0x7b, 0xde,
	0x4c, 0x94, 0x1b, 0x93, 0x89, 0x5e, 0x28, 0xa8, 0xca, 0xf4, 0xb1, 0x31, 0xbd, 0x4c, 0x9e, 0x6d,
	0x86, 0x53, 0xc8, 0x7d, 0x0b, 0x25, 0x0a, 0xdd, 0x1c, 0xe9, 0xfd, 0x8a, 0xfc, 0xb0, 0x1b, 0xa9,
	0xaa, 0x31, 0xd4, 0xff, 0xcd, 0x8e, 0xe4, 0x3f, 0x1b, 0x70, 0x7d, 0xec, 0xb1, 0xde, 0x08, 0x95,
	0xe8, 0x25, 0xc8, 0x90, 0x1b, 0x8a, 0xdb, 0x94, 0x50, 0x71, 0x91, 0xb8, 0xad, 0x04, 0x23, 0x14,
	0xf3, 0xaf, 0x19, 0xa8, 0x8c, 0xb2, 0xcd, 0xba, 0xc9, 0xeb, 0x50, 0xa2, 0x3a, 0xb3, 0x78, 0xd2,
	0x3e, 0x05, 0x0b, 0xa8, 0x4a, 0x13, 0x1e, 0x41, 0x57, 0x20, 0x17, 0x12, 0x1c, 0x05, 0xbe, 0x86,
	0xa8, 0x1c, 0xa1, 0x1f, 0xc3, 0xd2, 0x3e, 0xf1, 0xc9, 0x01, 0x65, 0x91, 0x1d, 0x31, 0x1c, 0x32,
	0x9b, 0xdf, 0x15, 0x54, 0xf3, 0x5d, 0xab, 0xcb, 0x8b, 0x44, 0x5d, 0x5f, 0x24, 0xea, 0x7b, 0xfa,
	0x22, 0x61, 0x2d, 0x6a, 0xb1, 0x5d, 0x2e, 0xc5, 0xe9, 0xc8, 0x82, 0x98, 0x68, 0x13, 0xdf, 0x95,
	0x9a, 0xb2, 0x42, 0xd3, 0xad, 0xf1, 0xe7, 0x68, 0xfb, 0x07, 0xd4, 0xa7, 0x8c, 0x70, 0x15, 0xd6,
	0x82, 0x56, 0xd0, 0xf2, 0x5d, 0xa1, 0xf3, 0x05, 0x54, 0xfd, 0x80, 0xc5, 0x27, 0xb3, 0xe5, 0xb6,
	0x07, 0xcd, 0x57, 0x79, 0xed, 0xfb, 0x75, 0x75, 0xf7, 0x79, 0x1a, 0x30, 0x7d, 0x5c, 0x4b, 0x70,
	0xf1, 0x18, 0xb2, 0x2e, 0xfb, 0x67, 0x91, 0x2f, 0xd8, 0xa5, 0x3d, 0x80, 0xf9, 0x5e, 0x3f, 0x74,
	0x0e, 0x71, 0x44, 0x6c, 0x76, 0xd2, 0x23, 0x2a, 0x0a, 0x2e, 0xe9, 0xa5, 0x77, 0xd4, 0xe4, 0xde,
	0x49, 0x8f, 0x58, 0x73, 0xbd, 0xc4, 0x08, 0xad, 0xc1, 0xe5, 0x2e, 0x3e, 0xb6, 0xf5, 0x15, 0xc5,
	0x0e, 0x8e, 0x48, 0x18, 0x52, 0x97, 0x88, 0x10, 0xc8, 0x5a, 0x4b, 0x5d, 0x7c, 0xac, 0x2f, 0x32,
	0xdb, 0x6a, 0x0a, 0xad, 0x82, 0x44, 0x8b, 0x1d, 0x91, 0x28, 0x52, 0x11, 0x03, 0xc2, 0x6d, 0x65,
	0x41, 0xdf, 0x95, 0xe4, 0xb6, 0x6b, 0xfe, 0x2b, 0x07, 0x59, 0x01, 0x84, 0x53, 0x49, 0xfb, 0x91,
	0xaa, 0x6a, 0x2e, 0x66, 0x58, 0xc1, 0x75, 0x5a, 0xa6, 0x14, 0x55, 0xaf, 0x89, 0x19, 0x46, 0x8f,
	0x20, 0xef, 0x51, 0x7e, 0xdb, 0xec, 0x08, 0xb8, 0x94, 0xd6, 0x56, 0xc6, 0x8b, 0x6e, 0x49, 0x46,
	0x4b, 0x4b, 0xa0, 0x5d, 0x98, 0x63, 0xb8, 0x63, 0xef, 0x53, 0xdf, 0xa5, 0x7e, 0x27, 0xaa, 0x66,
	0x44, 0x3e, 0xfa, 0x70, 0x0a, 0x92, 0x79, 0xda, 0xd9, 0x50, 0x22, 0x32, 0xfb, 0x94, 0xd8, 0x80,
	0x82, 0x3e, 0x84, 0x42, 0xcf, 0xc3, 0xec, 0x20, 0x08, 0xbb, 0x02, 0x52, 0x49, 0xe3, 0x2b, 0xba,
	0x30, 0x7e, 0xcc, 0x85, 0xd6, 0xa1, 0x18, 0xa7, 0x16, 0x01, 0x95, 0x89, 0x2d, 0x55, 0x7c, 0x51,
	0xb4, 0x06, 0x52, 0xe8, 0x01, 0x40, 0x22, 0x26, 0xf2, 0x53, 0x63, 0xa2, 0x18, 0xc5, 0xb1, 0xb0,
	0x0e, 0x85, 0x38, 0x04, 0x0a, 0x17, 0x0a, 0x81, 0x3c, 0x51, 0xd0, 0x4f, 0x5e, 0x86, 0x8b, 0x17,
	0xbf, 0x0c, 0xa3, 0x67, 0xb0, 0x20, 0x20, 0xde, 0x0b, 0x83, 0x1e, 0x09, 0x19, 0x25, 0x91, 0x00,
	0x51, 0x69, 0x6d, 0x75, 0x42, 0x69, 0xa0, 0x07, 0x6c, 0x27, 0xe6, 0xb7, 0xca, 0x9d, 0xa1, 0x31,
	0x22, 0x80, 0xe2, 0x48, 0x94, 0x85, 0x8a, 0x6b, 0x2d, 0x09, 0x07, 0x7f, 0x32, 0xcd, 0xc1, 0x3a,
	0x0a, 0x1b, 0x5a, 0x50, 0xba, 0x79, 0x91, 0x8c, 0xd2, 0x6b, 0x8f, 0xa1, 0x32, 0x8a, 0x86, 0x8b,
	0x54, 0x83, 0x5a, 0x13, 0xae, 0x9c, 0xbd, 0xd8, 0x34, 0x2d, 0x85, 0x64, 0x4d, 0xf9, 0x1c, 0xca,
	0xc3, 0xe6, 0x40, 0xf7, 0xa0, 0x28, 0x2c, 0x2a, 0x52, 0x80, 0x21, 0x50, 0x58, 0xd1, 0x28, 0xe4,
	0xac, 0x12, 0x81, 0x1d, 0xf5, 0xcb, 0xac, 0x43, 0x41, 0xbb, 0x85, 0x2f, 0xdc, 0xa5, 0xbe, 0x10,
	0xca, 0x5a, 0xfc, 0xa7, 0xa0, 0xe0, 0x63, 0xb1, 0x2c, 0xa7, 0xe0, 0x63, 0xf3, 0xbb, 0x14, 0x64,
	0x78, 0x20, 0x9e, 0x8a, 0x65, 0x04, 0x19, 0xd1, 0x9c, 0xca, 0x83, 0x8a, 0xdf, 0x3c, 0xa1, 0x33,
	0xe2, 0x63, 0x9f, 0xe9, 0x84, 0x2e, 0x47, 0xe8, 0x7d, 0x58, 0x38, 0xe8, 0x7b, 0x07, 0xd4, 0xf3,
	0xb8, 0x13, 0xec, 0x7e, 0x48, 0x55, 0xe7, 0x51, 0x4e, 0x90, 0x9f, 0x87, 0x14, 0xdd, 0x84, 0x72,
	0x48, 0x8e, 0x02, 0x07, 0x8b, 0x9a, 0xcc, 0xf9, 0x64, 0x07, 0x32, 0x3f, 0xa0, 0x72, 0xb6, 0xf7,
	0x61, 0x21, 0x51, 0xf8, 0x04, 0x9f, 0xbc, 0xf4, 0x96, 0x13, 0x64, 0xce, 0xb8, 0x02, 0x73, 0x5d,
	0xc2, 0x30, 0xcf, 0x37, 0x82, 0x2b, 0x2f, 0xfb, 0x19, 0x4d, 0xe3, 0x2c, 0x37, 0x60, 0xfe, 0x08,
	0x87, 0x14, 0x73, 0xf8, 0x88, 0x56, 0xa5, 0x20, 0xf2, 0xed, 0x9c, 0x26, 0xf2, 0xda, 0xcf, 0x4b,
	0x59, 0xc4, 0x30, 0xa3, 0x8e, 0x64, 0x29, 0x0a, 0x16, 0x90, 0x24, 0xce, 0x60, 0xfe, 0xc5, 0x80,
	0xbc, 0x4a, 0x3a, 0x68, 0x13, 0xe6, 0x9c, 0x43, 0x1c, 0x76, 0x88, 0xdd, 0x0d, 0x5c, 0xe2, 0xa9,
	0xaa, 0x79, 0x73, 0x3c, 0x14, 0x1b, 0x82, 0xfb, 0x2b, 0xce, 0x6c, 0x95, 0x9c, 0xc1, 0x00, 0xfd,
	0x0c, 0x96, 0x1c, 0xec, 0x3b, 0xc4, 0xf3, 0xa4, 0x41, 0x7a, 0x81, 0x47, 0x1d, 0x5d, 0xe8, 0x3f,
	0x98, 0xa0, 0x30, 0x21, 0xb4, 0x23, 0x64, 0x2c, 0xe4, 0x9c, 0xa2, 0x99, 0x3f, 0x87, 0xc5, 0x46,
	0x48, 0x5c, 0xca, 0x12, 0x1b, 0x40, 0x3f, 0x80, 0x4c, 0x02, 0x4a, 0x71, 0x21, 0x3b, 0xc5, 0x28,
	0x70, 0x25, 0x58, 0xb9, 0xdb, 0x71, 0x97, 0x63, 0x5a, 0xec, 0x2c, 0x6d, 0xa9, 0x91, 0xd9, 0x80,
	0xa5, 0xd6, 0x31, 0x23, 0xa1, 0x8f, 0xbd, 0xe4, 0x0a, 0x15, 0x48, 0x47, 0xaf, 0xfa, 0x1a, 0xef,
	0xd1, 0xab, 0x3e, 0xaa, 0x41, 0xa1, 0x17, 0x06, 0x47, 0xd4, 0x25, 0xa1, 0x6e, 0x64, 0xf5, 0xd8,
	0xfc, 0x6f, 0x0a, 0x4a, 0x49, 0xe9, 0x65, 0xde, 0x55, 0x58, 0xc4, 0xe9, 0x87, 0x21, 0x2f, 0x05,
	0x86, 0x88, 0x90, 0x24, 0x89, 0xb7, 0xcc, 0xbd, 0x50, 0x35, 0xb8, 0x52, 0x5b, 0x5e, 0x8c, 0xdb,
	0x2e, 0x6a, 0x43, 0x81, 0xa8, 0x1d, 0xa9, 0x22, 0x32, 0xe1, 0x9e, 0x79, 0xc6, 0xde, 0xad, 0x58,
	0x1c, 0x35, 0x20, 0xe7, 0x08, 0x9b, 0xa8, 0xbe, 0xe4, 0xee, 0x04, 0x77, 0x8c, 0xda, 0xce, 0x52,
	0xa2, 0x3c, 0x9d, 0x52, 0x9f, 0x91, 0xf0, 0x08, 0x7b, 0xaa, 0x29, 0x31, 0x27, 0x65, 0x64, 0xc9,
	0x69, 0xc5, 0x32, 0xe8, 0x47, 0x3c, 0x5e, 0x7c, 0xf2, 0x1a, 0x7b, 0x1a, 0x1b, 0xb2, 0xff, 0xb8,
	0xaa, 0xdd, 0x66, 0xc9, 0x59, 0xe9, 0x70, 0xe1, 0xb2, 0xf9, 0x30, 0x49, 0x52, 0x61, 0x9d, 0xd7,
	0x61, 0x6d, 0xde, 0x82, 0xb2, 0x6e, 0x1c, 0x5e, 0x52, 0xdf, 0x0d, 0x5e, 0xf3, 0x64, 0x74, 0x18,
	0xf4, 0xc5, 0xd5, 0x86, 0x3b, 0x57, 0x0e, 0xcc, 0x7f, 0x1a, 0x80, 0x4e, 0xc3, 0x0c, 0xad, 0x0d,
	0xa1, 0xe7, 0x5a, 0x8c, 0x9e, 0x53, 0x9c, 0x09, 0xf8, 0x3c, 0x83, 0x85, 0xb8, 0x91, 0x79, 0x2d,
	0xd6, 0x54, 0x08, 0x9f, 0x50, 0x13, 0x86, 0xf7, 0x68, 0x95, 0x7b, 0xc3, 0x7b, 0x7e, 0x08, 0x39,
	0xa5, 0x29, 0x7d, 0x6e, 0xab, 0x2a, 0x09, 0xf3, 0xdf, 0x19, 0x28, 0xc6, 0x95, 0x37, 0xd9, 0x75,
	0x18, 0x17, 0xee, 0x3a, 0xa4, 0x71, 0x53, 0xa7, 0x72, 0x66, 0x3a, 0x91, 0x33, 0x93, 0x17, 0xbc,
	0xcc, 0xf0, 0x05, 0xef, 0x01, 0x80, 0x13, 0x12, 0xcc, 0x88, 0x6b, 0x07, 0xbe, 0xc2, 0xc7, 0xc4,
	0x52, 0xaf, 0xb8, 0xb7, 0x47, 0xbb, 0x84, 0xdc, 0xac, 0x5d, 0x42, 0x7e, 0xb6, 0x2e, 0xe1, 0x19,
	0x2c, 0xb8, 0x34, 0x12, 0xc5, 0x58, 0xe3, 0xb2, 0x30, 0xcd, 0xa3, 0x4d, 0x25, 0xa0, 0xf2, 0x55,
	0xd9, 0x1d, 0x1a, 0xa3, 0x2f, 0x61, 0x5e, 0xf4, 0x40, 0xb6, 0x4b, 0xa3, 0x9e, 0x87, 0x75, 0xf7,
	0x71, 0x6b, 0x4a, 0xf7, 0xd4, 0x94, 0xdc, 0x96, 0xbc, 0xe9, 0xa9, 0x91, 0xcc, 0x37, 0x34, 0x08,
	0x79, 0x17, 0x03, 0xa2, 0xd6, 0xc5, 0x63, 0xf4, 0x53, 0x58, 0x4a, 0xd6, 0x96, 0x03, 0xea, 0x31,
	0x12, 0xea, 0x7e, 0x62, 0x42, 0x90, 0x27, 0x2e, 0x4c, 0x5f, 0x08, 0x19, 0x0b, 0x91, 0x51, 0x52,
	0x64, 0xfe, 0x26, 0x05, 0xe5, 0xe1, 0x93, 0xf2, 0x3e, 0x3e, 0x36, 0x56, 0x22, 0x76, 0xe2, 0x56,
	0x52, 0xb3, 0xcb, 0x3e, 0xde, 0x4d, 0x8c, 0xd0, 0x6d, 0xa8, 0x0c, 0xec, 0x4c, 0x42, 0x87, 0xa8,
	0x14, 0x9c, 0xb2, 0x62, 0xfb, 0xef, 0x48, 0x32, 0xaf, 0xac, 0x31, 0x2b, 0x27, 0x44, 0x02, 0x84,
	0x59, 0x2b, 0x5e, 0xbb, 0xc1, 0x89, 0xbc, 0xb2, 0xee, 0x53, 0xcf, 0xa3, 0x7e, 0x87, 0x2b, 0xa4,
	0x81, 0x1b, 0x09, 0x50, 0x66, 0xad, 0xb2, 0x22, 0xef, 0x48, 0x2a, 0x7a, 0x0c, 0x39, 0x27, 0xe8,
	0xf7, 0x62, 0x5c, 0x4e, 0x70, 0xc4, 0x0b, 0xe2, 0xbb, 0x41, 0xd8, 0x10, 0xdc, 0x96, 0x92, 0x32,
	0x29, 0xcc, 0x25, 0xe9, 0xfc, 0x4a, 0x72, 0x1c, 0x05, 0x9e, 0x87, 0x6d, 0xf1, 0x6c, 0x81, 0x19,
	0x0b, 0xe9, 0x7e, 0x9f, 0xe9, 0xc7, 0xaf, 0x25, 0x39, 0xf9, 0x3c, 0x22, 0xe1, 0xba, 0x9e, 0x92,
	0xdd, 0x82, 0xd3, 0x0f, 0xbd, 0x13, 0x5b, 0xed, 0x25, 0xa5, 0xbb, 0x05, 0x41, 0x95, 0xaa, 0xcd,
	0x3f, 0x1a, 0x30, 0x97, 0x04, 0xc3, 0xff, 0x95, 0xc5, 0xcd, 0xbb, 0xb0, 0x78, 0x0a, 0x3a, 0xbc,
	0xa2, 0x4a, 0xe0, 0xa9, 0xe3, 0xab, 0x91, 0xb9, 0x05, 0x05, 0x9d, 0xaf, 0xd0, 0x2a, 0x64, 0xfa,
	0x3e, 0x65, 0xa3, 0x9b, 0xd7, 0xf3, 0xcf, 0x7d, 0xca, 0x2c, 0xc1, 0xc1, 0xb5, 0x79, 0xc4, 0xef,
	0xb0, 0x43, 0xd5, 0xd8, 0xa9, 0x91, 0x69, 0xc3, 0x5c, 0x32, 0x7e, 0x51, 0x1d, 0x32, 0x22, 0xea,
	0x8d, 0xa9, 0xe9, 0x42, 0xf0, 0xa9, 0x0b, 0x3e, 0x55, 0x2a, 0x06, 0x17, 0x7c, 0xad, 0xf4, 0xce,
	0x1e, 0x14, 0xe3, 0x97, 0x17, 0x54, 0x83, 0x2b, 0x56, 0x6b, 0xbd, 0x69, 0x37, 0x5b, 0x3b, 0x7b,
	0x9b, 0xf6, 0xf3, 0xa7, 0xbb, 0x3b, 0xad, 0x46, 0xfb, 0x8b, 0x76, 0xab, 0x59, 0xf9, 0x1e, 0xba,
	0x02, 0x28, 0x31, 0xb7, 0xbb, 0xb9, 0xbe, 0xb5, 0xb5, 0xfd, 0xb2, 0x62, 0xa0, 0x25, 0x58, 0x48,
	0xd0, 0x9b, 0xad, 0xd6, 0x4e, 0x25, 0x75, 0x67, 0x1f, 0x4a, 0x5c, 0x6b, 0x23, 0xf0, 0x19, 0x39,
	0x66, 0xe8, 0x3d, 0xa8, 0x0a, 0x9e, 0xc6, 0xf6, 0xd3, 0xbd, 0xd6, 0x4f, 0xf6, 0x46, 0x34, 0xeb,
	0x55, 0xf5, 0x6c, 0xb3, 0xbd, 0xdb, 0xd8, 0x7e, 0xd1, 0xb2, 0xbe, 0xae, 0x18, 0xe8, 0x2a, 0x5c,
	0x1e, 0x9a, 0x6b, 0x6c, 0xb6, 0x1a, 0x5f, 0x6e, 0x3f, 0xdf, 0xab, 0xa4, 0xd6, 0x7e, 0x9b, 0x87,
	0x82, 0xfe, 0x98, 0x89, 0xfe, 0x60, 0xc0, 0xd5, 0xb1, 0x9f, 0xf0, 0xd0, 0xc3, 0x09, 0x85, 0x7f,
	0xca, 0xe7, 0xcc, 0xda, 0xa3, 0x99, 0x64, 0xd5, 0xdb, 0x91, 0x0b, 0xc5, 0xf8, 0xbd, 0x1a, 0xdd,
	0x39, 0xff, 0xc7, 0xba, 0xda, 0xdd, 0x73, 0xf1, 0xaa, 0x55, 0x7e, 0x6d, 0x0c, 0x1e, 0x54, 0xa3,
	0xa1, 0x57, 0xa1, 0x99, 0xbe, 0x79, 0xd5, 0x3e, 0xb9, 0xa8, 0x98, 0xda, 0x07, 0x77, 0xc2, 0xd8,
	0x37, 0xfa, 0x49, 0x4e, 0x98, 0xf6, 0x45, 0x67, 0x92, 0x13, 0xa6, 0x7f, 0x14, 0xe8, 0xc2, 0x5c,
	0xf2, 0xb9, 0x19, 0xdd, 0x9b, 0x7e, 0xbc, 0xc4, 0xb3, 0x76, 0xad, 0x7e, 0x5e, 0x76, 0xb5, 0x1c,
	0x86, 0x82, 0x7e, 0x7b, 0x46, 0xb7, 0x27, 0xca, 0x26, 0x9f, 0xac, 0x6b, 0x77, 0xce, 0xc3, 0xaa,
	0x96, 0xf8, 0xbd, 0x01, 0xef, 0x8c, 0x79, 0xb6, 0x44, 0x9f, 0xcd, 0xfa, 0x80, 0x5b, 0x7b, 0x30,
	0x83, 0xa4, 0xdc, 0xd0, 0xc6, 0x8d, 0x6f, 0x56, 0xa6, 0xfe, 0xaf, 0xc1, 0x7e, 0x4e, 0x64, 0xa9,
	0x8f, 0xfe, 0x17, 0x00, 0x00, 0xff, 0xff, 0x36, 0xc9, 0x95, 0xc3, 0xe0, 0x20, 0x00, 0x00,
}
