// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/DropsManagementServiceTwirp/twirp.proto

/*
Package DropsManagementServiceTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/DropsManagementServiceTwirp/twirp.proto
*/
package DropsManagementServiceTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ================================
// DropsManagementService Interface
// ================================

type DropsManagementService interface {
	// PutBenefit will Insert or Update a Benefit based on if it already exists or not.
	PutBenefit(context.Context, *PutBenefitRequest) (*PutBenefitResponse, error)

	// DeleteBenefit will Delete a benefit // for Integration tests only
	DeleteBenefit(context.Context, *DeleteBenefitRequest) (*DeleteBenefitResponse, error)

	// PutDrop will Insert or Update a Drop based on if it already exists or not.
	PutDrop(context.Context, *PutDropRequest) (*PutDropResponse, error)

	// DeleteDrop will Delete a drop // for Integration tests only
	DeleteDrop(context.Context, *DeleteDropRequest) (*DeleteDropResponse, error)

	// GetOptOutStatusesByChannelID takes a list of channel IDs and returns a list of all the channels in the supplied
	// list which are opted out of the Drops program
	GetOptOutStatusesByChannelID(context.Context, *GetOptOutStatusesByChannelIDRequest) (*GetOptOutStatusesByChannelIDResponse, error)

	// SetChannelOptOutStatus is used for setting a channel as opt-opt out or removing from opt-out list
	SetChannelOptOutStatus(context.Context, *SetChannelOptOutStatusRequest) (*SetChannelOptOutStatusResponse, error)

	// Called by DRE
	// Used to validate that a "Rule-Match" is supposed to trigger a drop
	// Will initiate user claim flow with DFS if that is the case and create DropInstanceData
	ProcessMatchedRule(context.Context, *ProcessMatchedRuleRequest) (*ProcessMatchedRuleResponse, error)

	// GetBenefit returns the benefits for a given benefitID
	GetBenefits(context.Context, *GetBenefitsRequest) (*GetBenefitsResponse, error)

	// GetBenefits returns the benefits for a given ownerID
	ListBenefitsByOwner(context.Context, *ListBenefitsByOwnerRequest) (*ListBenefitsByOwnerResponse, error)

	// Called by DRE
	// ListActiveDropRules returns the ActiveDropRules for a given gameID
	ListActiveDropRules(context.Context, *ListActiveDropRulesRequest) (*ListActiveDropRulesResponse, error)

	// GetDrop returns the Drops for a given dropID
	GetDrop(context.Context, *GetDropRequest) (*GetDropResponse, error)

	// GetDrop returns the Drops for a given dropID including Benefits and Personalized Settings
	GetDropWithUserMetadata(context.Context, *GetDropWithUserMetadataRequest) (*GetDropWithUserMetadataResponse, error)

	// GetDropByDropInstanceID is called by GQL to resolve Drops from Drop Instance IDs
	// It is user aware and accepts an optional ID for the user making the request
	// This is used as an authorization mechanism to prevent test / internal drops
	// from surfacing in Twilight when they are not authorized to do so.
	GetDropByDropInstanceID(context.Context, *GetDropByDropInstanceIDRequest) (*GetDropByDropInstanceIDResponse, error)

	// ListDropsByGame returns all active Drops for a given gameID
	// Returns the list of all active and upcoming drops for a specific game, regardless of any specific
	// channel's eligibility.
	ListActiveDropsByGame(context.Context, *ListActiveDropsByGameRequest) (*ListActiveDropsByGameResponse, error)

	// ListDropsByGameAndChannel returns all active Drops for a given gameID and channelID
	// This is primarily used to display drops to users on a specific channel. The channel ID is validated
	// against various whitelists to ensure that that specific channel is eligible for each drop currently
	// active for game ID.
	ListActiveDropsByGameAndChannel(context.Context, *ListActiveDropsByGameAndChannelRequest) (*ListActiveDropsByGameAndChannelResponse, error)

	// ListDropsByStatus returns all active and upcoming Drops for a given channel.
	// This is primarily used to show streamers what drops are currently running and which ones are upcoming.
	// The channel ID is validated against various whitelists and then returns all drops which that channel
	// is and will be eligible to participate in at this given moment.
	ListActiveDropsByChannel(context.Context, *ListActiveDropsByChannelRequest) (*ListActiveDropsByChannelResponse, error)

	// ListDropsByStatus returns all active Drops for a given status
	ListDropsByState(context.Context, *ListDropsByStateRequest) (*ListDropsByStateResponse, error)

	// GetDropInstance returns DropInstance given DropInstanceID
	// Drop Instances need to be fetched as a part of the fulfillment process. DFS will get a drop instance
	// to validate whether or not a specific user can claim said drop in DFS>
	GetDropInstance(context.Context, *GetDropInstanceRequest) (*GetDropInstanceResponse, error)

	// DeleteDropInstance will Delete a DropInstance // for Integration tests only
	DeleteDropInstance(context.Context, *DeleteDropInstanceRequest) (*DeleteDropInstanceResponse, error)

	// ListDropInstancesByChannel returns all DropInstances given ChannelID
	ListDropInstancesByChannel(context.Context, *ListDropInstancesByChannelRequest) (*ListDropInstancesByChannelResponse, error)

	// TransitionDropState attempts to transition the drop to the given state and returns an error when the transition is invalid.
	TransitionDropState(context.Context, *TransitionDropStateRequest) (*TransitionDropStateResponse, error)
}

// ======================================
// DropsManagementService Protobuf Client
// ======================================

type dropsManagementServiceProtobufClient struct {
	client HTTPClient
	urls   [21]string
	opts   twirp.ClientOptions
}

// NewDropsManagementServiceProtobufClient creates a Protobuf client that implements the DropsManagementService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewDropsManagementServiceProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) DropsManagementService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + DropsManagementServicePathPrefix
	urls := [21]string{
		prefix + "PutBenefit",
		prefix + "DeleteBenefit",
		prefix + "PutDrop",
		prefix + "DeleteDrop",
		prefix + "GetOptOutStatusesByChannelID",
		prefix + "SetChannelOptOutStatus",
		prefix + "ProcessMatchedRule",
		prefix + "GetBenefits",
		prefix + "ListBenefitsByOwner",
		prefix + "ListActiveDropRules",
		prefix + "GetDrop",
		prefix + "GetDropWithUserMetadata",
		prefix + "GetDropByDropInstanceID",
		prefix + "ListActiveDropsByGame",
		prefix + "ListActiveDropsByGameAndChannel",
		prefix + "ListActiveDropsByChannel",
		prefix + "ListDropsByState",
		prefix + "GetDropInstance",
		prefix + "DeleteDropInstance",
		prefix + "ListDropInstancesByChannel",
		prefix + "TransitionDropState",
	}

	return &dropsManagementServiceProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *dropsManagementServiceProtobufClient) PutBenefit(ctx context.Context, in *PutBenefitRequest) (*PutBenefitResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "PutBenefit")
	out := new(PutBenefitResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) DeleteBenefit(ctx context.Context, in *DeleteBenefitRequest) (*DeleteBenefitResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteBenefit")
	out := new(DeleteBenefitResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) PutDrop(ctx context.Context, in *PutDropRequest) (*PutDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "PutDrop")
	out := new(PutDropResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) DeleteDrop(ctx context.Context, in *DeleteDropRequest) (*DeleteDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDrop")
	out := new(DeleteDropResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) GetOptOutStatusesByChannelID(ctx context.Context, in *GetOptOutStatusesByChannelIDRequest) (*GetOptOutStatusesByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetOptOutStatusesByChannelID")
	out := new(GetOptOutStatusesByChannelIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) SetChannelOptOutStatus(ctx context.Context, in *SetChannelOptOutStatusRequest) (*SetChannelOptOutStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelOptOutStatus")
	out := new(SetChannelOptOutStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) ProcessMatchedRule(ctx context.Context, in *ProcessMatchedRuleRequest) (*ProcessMatchedRuleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ProcessMatchedRule")
	out := new(ProcessMatchedRuleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) GetBenefits(ctx context.Context, in *GetBenefitsRequest) (*GetBenefitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBenefits")
	out := new(GetBenefitsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) ListBenefitsByOwner(ctx context.Context, in *ListBenefitsByOwnerRequest) (*ListBenefitsByOwnerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListBenefitsByOwner")
	out := new(ListBenefitsByOwnerResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) ListActiveDropRules(ctx context.Context, in *ListActiveDropRulesRequest) (*ListActiveDropRulesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropRules")
	out := new(ListActiveDropRulesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) GetDrop(ctx context.Context, in *GetDropRequest) (*GetDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDrop")
	out := new(GetDropResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) GetDropWithUserMetadata(ctx context.Context, in *GetDropWithUserMetadataRequest) (*GetDropWithUserMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDropWithUserMetadata")
	out := new(GetDropWithUserMetadataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) GetDropByDropInstanceID(ctx context.Context, in *GetDropByDropInstanceIDRequest) (*GetDropByDropInstanceIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDropByDropInstanceID")
	out := new(GetDropByDropInstanceIDResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) ListActiveDropsByGame(ctx context.Context, in *ListActiveDropsByGameRequest) (*ListActiveDropsByGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByGame")
	out := new(ListActiveDropsByGameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) ListActiveDropsByGameAndChannel(ctx context.Context, in *ListActiveDropsByGameAndChannelRequest) (*ListActiveDropsByGameAndChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByGameAndChannel")
	out := new(ListActiveDropsByGameAndChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) ListActiveDropsByChannel(ctx context.Context, in *ListActiveDropsByChannelRequest) (*ListActiveDropsByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByChannel")
	out := new(ListActiveDropsByChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) ListDropsByState(ctx context.Context, in *ListDropsByStateRequest) (*ListDropsByStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListDropsByState")
	out := new(ListDropsByStateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) GetDropInstance(ctx context.Context, in *GetDropInstanceRequest) (*GetDropInstanceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDropInstance")
	out := new(GetDropInstanceResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) DeleteDropInstance(ctx context.Context, in *DeleteDropInstanceRequest) (*DeleteDropInstanceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDropInstance")
	out := new(DeleteDropInstanceResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) ListDropInstancesByChannel(ctx context.Context, in *ListDropInstancesByChannelRequest) (*ListDropInstancesByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListDropInstancesByChannel")
	out := new(ListDropInstancesByChannelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceProtobufClient) TransitionDropState(ctx context.Context, in *TransitionDropStateRequest) (*TransitionDropStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "TransitionDropState")
	out := new(TransitionDropStateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==================================
// DropsManagementService JSON Client
// ==================================

type dropsManagementServiceJSONClient struct {
	client HTTPClient
	urls   [21]string
	opts   twirp.ClientOptions
}

// NewDropsManagementServiceJSONClient creates a JSON client that implements the DropsManagementService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewDropsManagementServiceJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) DropsManagementService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + DropsManagementServicePathPrefix
	urls := [21]string{
		prefix + "PutBenefit",
		prefix + "DeleteBenefit",
		prefix + "PutDrop",
		prefix + "DeleteDrop",
		prefix + "GetOptOutStatusesByChannelID",
		prefix + "SetChannelOptOutStatus",
		prefix + "ProcessMatchedRule",
		prefix + "GetBenefits",
		prefix + "ListBenefitsByOwner",
		prefix + "ListActiveDropRules",
		prefix + "GetDrop",
		prefix + "GetDropWithUserMetadata",
		prefix + "GetDropByDropInstanceID",
		prefix + "ListActiveDropsByGame",
		prefix + "ListActiveDropsByGameAndChannel",
		prefix + "ListActiveDropsByChannel",
		prefix + "ListDropsByState",
		prefix + "GetDropInstance",
		prefix + "DeleteDropInstance",
		prefix + "ListDropInstancesByChannel",
		prefix + "TransitionDropState",
	}

	return &dropsManagementServiceJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *dropsManagementServiceJSONClient) PutBenefit(ctx context.Context, in *PutBenefitRequest) (*PutBenefitResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "PutBenefit")
	out := new(PutBenefitResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) DeleteBenefit(ctx context.Context, in *DeleteBenefitRequest) (*DeleteBenefitResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteBenefit")
	out := new(DeleteBenefitResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) PutDrop(ctx context.Context, in *PutDropRequest) (*PutDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "PutDrop")
	out := new(PutDropResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) DeleteDrop(ctx context.Context, in *DeleteDropRequest) (*DeleteDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDrop")
	out := new(DeleteDropResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) GetOptOutStatusesByChannelID(ctx context.Context, in *GetOptOutStatusesByChannelIDRequest) (*GetOptOutStatusesByChannelIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetOptOutStatusesByChannelID")
	out := new(GetOptOutStatusesByChannelIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) SetChannelOptOutStatus(ctx context.Context, in *SetChannelOptOutStatusRequest) (*SetChannelOptOutStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelOptOutStatus")
	out := new(SetChannelOptOutStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) ProcessMatchedRule(ctx context.Context, in *ProcessMatchedRuleRequest) (*ProcessMatchedRuleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ProcessMatchedRule")
	out := new(ProcessMatchedRuleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) GetBenefits(ctx context.Context, in *GetBenefitsRequest) (*GetBenefitsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBenefits")
	out := new(GetBenefitsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) ListBenefitsByOwner(ctx context.Context, in *ListBenefitsByOwnerRequest) (*ListBenefitsByOwnerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListBenefitsByOwner")
	out := new(ListBenefitsByOwnerResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) ListActiveDropRules(ctx context.Context, in *ListActiveDropRulesRequest) (*ListActiveDropRulesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropRules")
	out := new(ListActiveDropRulesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) GetDrop(ctx context.Context, in *GetDropRequest) (*GetDropResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDrop")
	out := new(GetDropResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) GetDropWithUserMetadata(ctx context.Context, in *GetDropWithUserMetadataRequest) (*GetDropWithUserMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDropWithUserMetadata")
	out := new(GetDropWithUserMetadataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) GetDropByDropInstanceID(ctx context.Context, in *GetDropByDropInstanceIDRequest) (*GetDropByDropInstanceIDResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDropByDropInstanceID")
	out := new(GetDropByDropInstanceIDResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) ListActiveDropsByGame(ctx context.Context, in *ListActiveDropsByGameRequest) (*ListActiveDropsByGameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByGame")
	out := new(ListActiveDropsByGameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) ListActiveDropsByGameAndChannel(ctx context.Context, in *ListActiveDropsByGameAndChannelRequest) (*ListActiveDropsByGameAndChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByGameAndChannel")
	out := new(ListActiveDropsByGameAndChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) ListActiveDropsByChannel(ctx context.Context, in *ListActiveDropsByChannelRequest) (*ListActiveDropsByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByChannel")
	out := new(ListActiveDropsByChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) ListDropsByState(ctx context.Context, in *ListDropsByStateRequest) (*ListDropsByStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListDropsByState")
	out := new(ListDropsByStateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) GetDropInstance(ctx context.Context, in *GetDropInstanceRequest) (*GetDropInstanceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "GetDropInstance")
	out := new(GetDropInstanceResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) DeleteDropInstance(ctx context.Context, in *DeleteDropInstanceRequest) (*DeleteDropInstanceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDropInstance")
	out := new(DeleteDropInstanceResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) ListDropInstancesByChannel(ctx context.Context, in *ListDropInstancesByChannelRequest) (*ListDropInstancesByChannelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "ListDropInstancesByChannel")
	out := new(ListDropInstancesByChannelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *dropsManagementServiceJSONClient) TransitionDropState(ctx context.Context, in *TransitionDropStateRequest) (*TransitionDropStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithMethodName(ctx, "TransitionDropState")
	out := new(TransitionDropStateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =====================================
// DropsManagementService Server Handler
// =====================================

type dropsManagementServiceServer struct {
	DropsManagementService
	hooks *twirp.ServerHooks
}

func NewDropsManagementServiceServer(svc DropsManagementService, hooks *twirp.ServerHooks) TwirpServer {
	return &dropsManagementServiceServer{
		DropsManagementService: svc,
		hooks:                  hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *dropsManagementServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// DropsManagementServicePathPrefix is used for all URL paths on a twirp DropsManagementService server.
// Requests are always: POST DropsManagementServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const DropsManagementServicePathPrefix = "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/"

func (s *dropsManagementServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.dropsmanagementservice")
	ctx = ctxsetters.WithServiceName(ctx, "DropsManagementService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/PutBenefit":
		s.servePutBenefit(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/DeleteBenefit":
		s.serveDeleteBenefit(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/PutDrop":
		s.servePutDrop(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/DeleteDrop":
		s.serveDeleteDrop(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/GetOptOutStatusesByChannelID":
		s.serveGetOptOutStatusesByChannelID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/SetChannelOptOutStatus":
		s.serveSetChannelOptOutStatus(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/ProcessMatchedRule":
		s.serveProcessMatchedRule(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/GetBenefits":
		s.serveGetBenefits(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/ListBenefitsByOwner":
		s.serveListBenefitsByOwner(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/ListActiveDropRules":
		s.serveListActiveDropRules(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/GetDrop":
		s.serveGetDrop(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/GetDropWithUserMetadata":
		s.serveGetDropWithUserMetadata(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/GetDropByDropInstanceID":
		s.serveGetDropByDropInstanceID(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/ListActiveDropsByGame":
		s.serveListActiveDropsByGame(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/ListActiveDropsByGameAndChannel":
		s.serveListActiveDropsByGameAndChannel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/ListActiveDropsByChannel":
		s.serveListActiveDropsByChannel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/ListDropsByState":
		s.serveListDropsByState(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/GetDropInstance":
		s.serveGetDropInstance(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/DeleteDropInstance":
		s.serveDeleteDropInstance(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/ListDropInstancesByChannel":
		s.serveListDropInstancesByChannel(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.dropsmanagementservice.DropsManagementService/TransitionDropState":
		s.serveTransitionDropState(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *dropsManagementServiceServer) servePutBenefit(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutBenefitJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutBenefitProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) servePutBenefitJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutBenefit")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutBenefitRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutBenefitResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.PutBenefit(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutBenefitResponse and nil error while calling PutBenefit. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) servePutBenefitProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutBenefit")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PutBenefitRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutBenefitResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.PutBenefit(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutBenefitResponse and nil error while calling PutBenefit. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveDeleteBenefit(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteBenefitJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteBenefitProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveDeleteBenefitJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteBenefit")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteBenefitRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteBenefitResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.DeleteBenefit(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteBenefitResponse and nil error while calling DeleteBenefit. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveDeleteBenefitProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteBenefit")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteBenefitRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteBenefitResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.DeleteBenefit(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteBenefitResponse and nil error while calling DeleteBenefit. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) servePutDrop(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutDropJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutDropProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) servePutDropJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutDropRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.PutDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutDropResponse and nil error while calling PutDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) servePutDropProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PutDropRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.PutDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutDropResponse and nil error while calling PutDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveDeleteDrop(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteDropJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteDropProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveDeleteDropJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteDropRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.DeleteDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteDropResponse and nil error while calling DeleteDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveDeleteDropProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteDropRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.DeleteDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteDropResponse and nil error while calling DeleteDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetOptOutStatusesByChannelID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetOptOutStatusesByChannelIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetOptOutStatusesByChannelIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveGetOptOutStatusesByChannelIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOptOutStatusesByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetOptOutStatusesByChannelIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOptOutStatusesByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetOptOutStatusesByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOptOutStatusesByChannelIDResponse and nil error while calling GetOptOutStatusesByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetOptOutStatusesByChannelIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetOptOutStatusesByChannelID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetOptOutStatusesByChannelIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetOptOutStatusesByChannelIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetOptOutStatusesByChannelID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetOptOutStatusesByChannelIDResponse and nil error while calling GetOptOutStatusesByChannelID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveSetChannelOptOutStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetChannelOptOutStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetChannelOptOutStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveSetChannelOptOutStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelOptOutStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetChannelOptOutStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetChannelOptOutStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.SetChannelOptOutStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetChannelOptOutStatusResponse and nil error while calling SetChannelOptOutStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveSetChannelOptOutStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetChannelOptOutStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetChannelOptOutStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetChannelOptOutStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.SetChannelOptOutStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetChannelOptOutStatusResponse and nil error while calling SetChannelOptOutStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveProcessMatchedRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveProcessMatchedRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveProcessMatchedRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveProcessMatchedRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ProcessMatchedRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ProcessMatchedRuleRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ProcessMatchedRuleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ProcessMatchedRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ProcessMatchedRuleResponse and nil error while calling ProcessMatchedRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveProcessMatchedRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ProcessMatchedRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ProcessMatchedRuleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ProcessMatchedRuleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ProcessMatchedRule(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ProcessMatchedRuleResponse and nil error while calling ProcessMatchedRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetBenefits(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBenefitsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBenefitsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveGetBenefitsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBenefitsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBenefitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBenefitsResponse and nil error while calling GetBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetBenefitsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBenefits")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBenefitsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBenefitsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetBenefits(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBenefitsResponse and nil error while calling GetBenefits. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListBenefitsByOwner(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListBenefitsByOwnerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListBenefitsByOwnerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveListBenefitsByOwnerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListBenefitsByOwner")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListBenefitsByOwnerRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListBenefitsByOwnerResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListBenefitsByOwner(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListBenefitsByOwnerResponse and nil error while calling ListBenefitsByOwner. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListBenefitsByOwnerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListBenefitsByOwner")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListBenefitsByOwnerRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListBenefitsByOwnerResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListBenefitsByOwner(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListBenefitsByOwnerResponse and nil error while calling ListBenefitsByOwner. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListActiveDropRules(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListActiveDropRulesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListActiveDropRulesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveListActiveDropRulesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropRules")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListActiveDropRulesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropRulesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListActiveDropRules(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropRulesResponse and nil error while calling ListActiveDropRules. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListActiveDropRulesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropRules")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListActiveDropRulesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropRulesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListActiveDropRules(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropRulesResponse and nil error while calling ListActiveDropRules. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetDrop(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDropJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDropProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveGetDropJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetDropRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropResponse and nil error while calling GetDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetDropProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDrop")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetDropRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetDrop(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropResponse and nil error while calling GetDrop. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetDropWithUserMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDropWithUserMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDropWithUserMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveGetDropWithUserMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDropWithUserMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetDropWithUserMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropWithUserMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetDropWithUserMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropWithUserMetadataResponse and nil error while calling GetDropWithUserMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetDropWithUserMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDropWithUserMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetDropWithUserMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropWithUserMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetDropWithUserMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropWithUserMetadataResponse and nil error while calling GetDropWithUserMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetDropByDropInstanceID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDropByDropInstanceIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDropByDropInstanceIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveGetDropByDropInstanceIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDropByDropInstanceID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetDropByDropInstanceIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropByDropInstanceIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetDropByDropInstanceID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropByDropInstanceIDResponse and nil error while calling GetDropByDropInstanceID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetDropByDropInstanceIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDropByDropInstanceID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetDropByDropInstanceIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropByDropInstanceIDResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetDropByDropInstanceID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropByDropInstanceIDResponse and nil error while calling GetDropByDropInstanceID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListActiveDropsByGame(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListActiveDropsByGameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListActiveDropsByGameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveListActiveDropsByGameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListActiveDropsByGameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropsByGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListActiveDropsByGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropsByGameResponse and nil error while calling ListActiveDropsByGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListActiveDropsByGameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByGame")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListActiveDropsByGameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropsByGameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListActiveDropsByGame(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropsByGameResponse and nil error while calling ListActiveDropsByGame. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListActiveDropsByGameAndChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListActiveDropsByGameAndChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListActiveDropsByGameAndChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveListActiveDropsByGameAndChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByGameAndChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListActiveDropsByGameAndChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropsByGameAndChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListActiveDropsByGameAndChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropsByGameAndChannelResponse and nil error while calling ListActiveDropsByGameAndChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListActiveDropsByGameAndChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByGameAndChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListActiveDropsByGameAndChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropsByGameAndChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListActiveDropsByGameAndChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropsByGameAndChannelResponse and nil error while calling ListActiveDropsByGameAndChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListActiveDropsByChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListActiveDropsByChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListActiveDropsByChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveListActiveDropsByChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListActiveDropsByChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropsByChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListActiveDropsByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropsByChannelResponse and nil error while calling ListActiveDropsByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListActiveDropsByChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveDropsByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListActiveDropsByChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveDropsByChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListActiveDropsByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveDropsByChannelResponse and nil error while calling ListActiveDropsByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListDropsByState(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListDropsByStateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListDropsByStateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveListDropsByStateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListDropsByState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListDropsByStateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListDropsByStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListDropsByState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListDropsByStateResponse and nil error while calling ListDropsByState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListDropsByStateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListDropsByState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListDropsByStateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListDropsByStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListDropsByState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListDropsByStateResponse and nil error while calling ListDropsByState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetDropInstance(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDropInstanceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDropInstanceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveGetDropInstanceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDropInstance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetDropInstanceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropInstanceResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetDropInstance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropInstanceResponse and nil error while calling GetDropInstance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveGetDropInstanceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDropInstance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetDropInstanceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetDropInstanceResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.GetDropInstance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetDropInstanceResponse and nil error while calling GetDropInstance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveDeleteDropInstance(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteDropInstanceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteDropInstanceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveDeleteDropInstanceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDropInstance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteDropInstanceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteDropInstanceResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.DeleteDropInstance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteDropInstanceResponse and nil error while calling DeleteDropInstance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveDeleteDropInstanceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDropInstance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteDropInstanceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteDropInstanceResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.DeleteDropInstance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteDropInstanceResponse and nil error while calling DeleteDropInstance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListDropInstancesByChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListDropInstancesByChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListDropInstancesByChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveListDropInstancesByChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListDropInstancesByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListDropInstancesByChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListDropInstancesByChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListDropInstancesByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListDropInstancesByChannelResponse and nil error while calling ListDropInstancesByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveListDropInstancesByChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListDropInstancesByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListDropInstancesByChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListDropInstancesByChannelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.ListDropInstancesByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListDropInstancesByChannelResponse and nil error while calling ListDropInstancesByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveTransitionDropState(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveTransitionDropStateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTransitionDropStateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *dropsManagementServiceServer) serveTransitionDropStateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TransitionDropState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TransitionDropStateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TransitionDropStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.TransitionDropState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TransitionDropStateResponse and nil error while calling TransitionDropState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) serveTransitionDropStateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TransitionDropState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(TransitionDropStateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TransitionDropStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DropsManagementService.TransitionDropState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TransitionDropStateResponse and nil error while calling TransitionDropState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *dropsManagementServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *dropsManagementServiceServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *dropsManagementServiceServer) PathPrefix() string {
	return DropsManagementServicePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2192 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x5a, 0x4b, 0x6f, 0xdb, 0xd8,
	0x15, 0x2e, 0xf5, 0xb0, 0xa4, 0x23, 0x3f, 0xe4, 0x9b, 0x97, 0x42, 0xc7, 0x13, 0x97, 0xd3, 0x66,
	0xdc, 0x36, 0xb0, 0x31, 0x9e, 0x06, 0xed, 0xf4, 0x39, 0x96, 0xed, 0x38, 0x4a, 0xfc, 0x1a, 0xca,
	0x6e, 0x32, 0xc5, 0xa0, 0x02, 0x23, 0xde, 0xc4, 0x9c, 0x50, 0xa4, 0x86, 0xf7, 0x32, 0xb1, 0xa7,
	0x68, 0x97, 0xed, 0xaa, 0x0f, 0x14, 0x28, 0xd0, 0x55, 0x81, 0xae, 0x0a, 0xcc, 0xaa, 0x40, 0x81,
	0xa2, 0x5d, 0x75, 0xd5, 0x6d, 0xd1, 0x7f, 0xd0, 0x9f, 0xd0, 0x55, 0xf7, 0x83, 0xfb, 0x20, 0x45,
	0x51, 0xa4, 0x6d, 0x4a, 0xdc, 0x04, 0xe2, 0xb9, 0xf7, 0x7e, 0xe7, 0x71, 0xcf, 0x39, 0xf7, 0x9c,
	0x13, 0xc3, 0x77, 0x7b, 0xae, 0x89, 0xd7, 0x3e, 0xf1, 0x09, 0xb5, 0x9c, 0x35, 0xfa, 0x7a, 0xdd,
	0xe8, 0x7f, 0xe6, 0xac, 0x6f, 0x7b, 0xee, 0x80, 0xec, 0x1b, 0x8e, 0xf1, 0x12, 0xf7, 0xb1, 0x43,
	0x3b, 0xd8, 0x7b, 0x6d, 0xf5, 0xf0, 0xf1, 0x1b, 0xcb, 0x1b, 0xac, 0x53, 0xf6, 0xef, 0xda, 0xc0,
	0x73, 0xa9, 0x8b, 0xee, 0xd3, 0x37, 0x16, 0xed, 0x9d, 0xae, 0xbd, 0xf0, 0x6d, 0xea, 0x3a, 0x6b,
	0xf8, 0xcc, 0xe8, 0x0f, 0x6c, 0xbc, 0x66, 0xb2, 0xe3, 0xfd, 0xf0, 0x38, 0x11, 0xc7, 0xb5, 0xbf,
	0x17, 0xa0, 0xd2, 0xc2, 0x0e, 0x7e, 0x61, 0x51, 0xb4, 0x0c, 0xf0, 0x5c, 0xfc, 0xec, 0x5a, 0x66,
	0x53, 0x59, 0x51, 0x56, 0x6b, 0x7a, 0x4d, 0x52, 0xda, 0x26, 0x42, 0x50, 0x72, 0x8c, 0x3e, 0x6e,
	0x16, 0xf8, 0x02, 0xff, 0x8d, 0x56, 0xa0, 0x6e, 0x62, 0xd2, 0xf3, 0xac, 0x01, 0xb5, 0x5c, 0xa7,
	0x59, 0xe4, 0x4b, 0x51, 0x12, 0xfa, 0x06, 0x2c, 0x62, 0x87, 0x5a, 0xd4, 0xe6, 0x6c, 0xbb, 0xb6,
	0xd5, 0xb7, 0x68, 0xb3, 0xb4, 0xa2, 0xac, 0x96, 0xf5, 0x46, 0x64, 0x61, 0x8f, 0xd1, 0xd1, 0x6d,
	0xa8, 0xba, 0x6f, 0x1c, 0xec, 0x31, 0xfe, 0x65, 0x8e, 0x55, 0xe1, 0xdf, 0x6d, 0x13, 0xdd, 0x83,
	0x05, 0xab, 0x6f, 0xbc, 0xc4, 0x5d, 0x83, 0x10, 0x4c, 0xbb, 0xbe, 0x67, 0x37, 0x67, 0xf8, 0x8e,
	0x39, 0x4e, 0xde, 0x64, 0xd4, 0x13, 0xcf, 0x46, 0x1b, 0x70, 0xc3, 0xc3, 0x9f, 0xfa, 0x96, 0x87,
	0xcd, 0xae, 0xd1, 0xeb, 0xb9, 0x3e, 0x67, 0xea, 0xbc, 0x6a, 0x56, 0xf8, 0xee, 0x6b, 0xc1, 0xe2,
	0xa6, 0x58, 0xdb, 0xb3, 0x9c, 0x57, 0xe8, 0x16, 0x54, 0x5e, 0x1a, 0x7d, 0xcc, 0xb8, 0x56, 0xf9,
	0xae, 0x19, 0xf6, 0xd9, 0x36, 0xd1, 0x12, 0xd4, 0x7a, 0xb6, 0xc5, 0xe4, 0xb6, 0xcc, 0x66, 0x8d,
	0x2f, 0x55, 0x05, 0xa1, 0x6d, 0x6a, 0xbf, 0x57, 0x60, 0x66, 0xb3, 0xc7, 0x95, 0x5c, 0x82, 0x9a,
	0xc1, 0x7f, 0x0d, 0x0d, 0x57, 0x15, 0x84, 0xb6, 0x19, 0xb7, 0x51, 0x61, 0xdc, 0x46, 0x5f, 0x85,
	0xf9, 0x9e, 0x6d, 0x58, 0xfd, 0xae, 0xe9, 0x7b, 0x46, 0x68, 0xc8, 0xb2, 0x3e, 0xc7, 0xa9, 0xdb,
	0x92, 0xc8, 0xb6, 0x99, 0x67, 0x76, 0x17, 0x9f, 0x0d, 0x3c, 0x4c, 0x08, 0xdb, 0x56, 0x12, 0x16,
	0x30, 0xcf, 0xec, 0x9d, 0x90, 0xa8, 0xfd, 0xa7, 0x0c, 0x75, 0xe6, 0x2c, 0x1d, 0xbf, 0xdf, 0x37,
	0xbc, 0x73, 0xa6, 0x1d, 0xbb, 0xfc, 0xa1, 0x68, 0x33, 0xec, 0xb3, 0x6d, 0xb2, 0xfb, 0x26, 0xd4,
	0xf0, 0x68, 0xd7, 0x34, 0xa8, 0xb8, 0xd6, 0xa2, 0x5e, 0xe3, 0x94, 0x6d, 0x83, 0x62, 0x76, 0x19,
	0xd8, 0x31, 0xc5, 0x62, 0x91, 0x2f, 0x56, 0xb0, 0x63, 0xf2, 0xa5, 0x13, 0x28, 0x13, 0xca, 0xe8,
	0x4c, 0x80, 0xf9, 0x8d, 0x1f, 0xae, 0x65, 0xf1, 0xb9, 0xb5, 0x88, 0x70, 0x6b, 0x1d, 0x06, 0xa3,
	0x0b, 0x34, 0xe6, 0x2b, 0xbd, 0x53, 0xc3, 0x71, 0xb0, 0xdd, 0x7d, 0x73, 0x6a, 0x51, 0x6c, 0x5b,
	0x84, 0x36, 0xcb, 0x2b, 0xc5, 0xd5, 0x9a, 0xde, 0x90, 0x0b, 0x4f, 0x03, 0x7a, 0xdc, 0xac, 0x33,
	0xe3, 0x66, 0x8d, 0x7a, 0x53, 0x65, 0xd4, 0x9b, 0x52, 0x6f, 0x3c, 0xd5, 0x7d, 0x6a, 0xe9, 0xee,
	0xb3, 0x04, 0x35, 0x6e, 0x60, 0x1e, 0x1d, 0x75, 0x71, 0xfb, 0x8c, 0x70, 0xc0, 0x22, 0x64, 0x19,
	0x40, 0x08, 0xc1, 0x57, 0x67, 0x45, 0x50, 0x71, 0x0a, 0x5f, 0x4e, 0x70, 0xeb, 0xb9, 0x24, 0xb7,
	0xbe, 0xcb, 0xb4, 0xa5, 0x86, 0x65, 0x13, 0xbe, 0x67, 0x9e, 0xef, 0x01, 0x49, 0x62, 0x1b, 0x96,
	0x01, 0x3e, 0xf5, 0x31, 0xa1, 0x82, 0xcf, 0x82, 0xe0, 0xc3, 0x29, 0x9c, 0x4f, 0xc4, 0xb4, 0xcf,
	0x6d, 0xa3, 0xf7, 0x8a, 0x9b, 0xb6, 0x31, 0x62, 0xda, 0x56, 0x40, 0x67, 0x9b, 0x29, 0x66, 0xc9,
	0xe7, 0x65, 0xe4, 0x1e, 0x16, 0xc5, 0x66, 0xb9, 0x10, 0xde, 0x83, 0xd6, 0x81, 0x32, 0xbf, 0x44,
	0x54, 0x87, 0xca, 0xc9, 0xc1, 0x93, 0x83, 0xc3, 0xa7, 0x07, 0x8d, 0x2f, 0x21, 0x80, 0x99, 0xcd,
	0xad, 0xe3, 0xf6, 0x8f, 0x76, 0x1a, 0x05, 0xb6, 0xb0, 0xf3, 0xec, 0xa8, 0xad, 0xef, 0x6c, 0x37,
	0x8a, 0xa8, 0x0a, 0xa5, 0xe3, 0x9d, 0xce, 0x71, 0xa3, 0x84, 0x66, 0xa1, 0x7a, 0x72, 0xb4, 0x75,
	0xb8, 0xdf, 0x3e, 0xd8, 0x6d, 0x94, 0xd9, 0xd7, 0x76, 0xbb, 0xb3, 0xd9, 0xda, 0xdb, 0xd9, 0x6e,
	0xcc, 0x3c, 0x2e, 0x55, 0xa1, 0x51, 0xd7, 0x2b, 0x16, 0xe9, 0x32, 0x7e, 0xda, 0xff, 0x15, 0x28,
	0x31, 0xaf, 0x41, 0x1d, 0xa8, 0x10, 0xe1, 0x39, 0xdc, 0x97, 0xeb, 0x1b, 0xef, 0x4f, 0xec, 0x7a,
	0x7a, 0x80, 0x84, 0x1e, 0x41, 0xd9, 0xf3, 0x6d, 0x4c, 0x9a, 0x85, 0x95, 0xe2, 0x6a, 0x7d, 0x63,
	0x23, 0x1b, 0xa4, 0xee, 0xdb, 0x58, 0x17, 0x00, 0xe8, 0x00, 0x2a, 0x22, 0xec, 0x49, 0xb3, 0xc8,
	0xb1, 0xbe, 0x99, 0x0d, 0x4b, 0xa4, 0x13, 0x3d, 0x00, 0xd1, 0x3e, 0x81, 0x12, 0x83, 0x67, 0xee,
	0xca, 0x18, 0x44, 0x42, 0x98, 0x7d, 0x5e, 0x29, 0xb7, 0xbc, 0x03, 0x0b, 0xf8, 0x35, 0xcb, 0x60,
	0x3d, 0xd7, 0x31, 0xad, 0x48, 0x96, 0x9e, 0xe7, 0xe4, 0xad, 0x80, 0xaa, 0xfd, 0xb7, 0x00, 0xb3,
	0xcc, 0x3c, 0x6d, 0x87, 0x50, 0xc3, 0xe9, 0x61, 0xb4, 0x0a, 0x0d, 0x91, 0x37, 0x24, 0x61, 0xc8,
	0x7d, 0xde, 0x8c, 0xec, 0x6b, 0x9b, 0xe8, 0x29, 0xcc, 0xf1, 0x9d, 0xc4, 0x31, 0x06, 0xe4, 0xd4,
	0xa5, 0x5c, 0x8e, 0xcc, 0x86, 0x64, 0xcc, 0xf5, 0x59, 0xb6, 0xd8, 0x91, 0x38, 0xd1, 0xd4, 0x55,
	0x8c, 0xa7, 0xae, 0xc0, 0x9d, 0x2d, 0x53, 0xa6, 0xc1, 0x9a, 0xa4, 0xb4, 0x4d, 0x26, 0xba, 0x50,
	0xba, 0x8f, 0x09, 0x61, 0xd1, 0x15, 0xbe, 0x27, 0x42, 0xeb, 0x7d, 0x41, 0x6e, 0x9b, 0xe8, 0x6d,
	0x98, 0x1b, 0xd9, 0x29, 0xf3, 0xc8, 0x6c, 0x74, 0x5b, 0x18, 0xe0, 0xd4, 0xea, 0x63, 0x9e, 0x49,
	0x8a, 0x22, 0xc0, 0x8f, 0xad, 0x3e, 0x1e, 0xf2, 0x22, 0x22, 0xff, 0x0e, 0x73, 0x8a, 0xe0, 0xd5,
	0x11, 0xe4, 0xb6, 0xa9, 0xed, 0x43, 0xe3, 0x84, 0x60, 0x8f, 0xfb, 0x20, 0xa6, 0x2c, 0x8a, 0x08,
	0x7a, 0x1f, 0x6e, 0x5b, 0xa4, 0xeb, 0x13, 0xec, 0x85, 0xe9, 0xa6, 0xe7, 0x3a, 0x0e, 0xee, 0x51,
	0x2c, 0xac, 0x5d, 0xd5, 0x6f, 0x5a, 0x84, 0x1d, 0x93, 0x19, 0x67, 0x2b, 0x58, 0xd5, 0x4c, 0x58,
	0x3c, 0xf2, 0xa9, 0x7c, 0xbc, 0x75, 0xcc, 0x63, 0x1d, 0x1d, 0x42, 0x45, 0xbe, 0xd8, 0x32, 0x40,
	0x1e, 0x64, 0xbb, 0x84, 0x00, 0x2e, 0x40, 0xd1, 0xde, 0x03, 0x14, 0xe5, 0x42, 0x06, 0xae, 0x43,
	0xf0, 0x25, 0xa5, 0x82, 0xf6, 0x00, 0xae, 0x6f, 0x63, 0x1b, 0x53, 0x1c, 0x93, 0xee, 0x92, 0x63,
	0xb7, 0xe0, 0x46, 0xec, 0x98, 0x60, 0xa7, 0x3d, 0x83, 0xf9, 0x23, 0x9f, 0x72, 0x07, 0x91, 0x48,
	0x0f, 0xa1, 0xc4, 0x34, 0x90, 0x4a, 0x4e, 0xe2, 0x69, 0xfc, 0xbc, 0xf6, 0x75, 0x58, 0x08, 0x91,
	0xa5, 0x6e, 0x69, 0xef, 0xa5, 0x76, 0x1f, 0x16, 0x85, 0x78, 0x51, 0x41, 0x52, 0x77, 0x5f, 0x07,
	0x14, 0xdd, 0x2d, 0x35, 0x79, 0x08, 0x6f, 0xef, 0x62, 0x7a, 0x38, 0xa0, 0x87, 0x3e, 0x65, 0x69,
	0xd3, 0x27, 0x98, 0xb4, 0xce, 0xb7, 0xa4, 0xe7, 0x6e, 0x07, 0xa8, 0x77, 0xa1, 0x3e, 0xf4, 0x6f,
	0xd2, 0x54, 0x78, 0xee, 0x85, 0xd0, 0xc1, 0x89, 0xf6, 0x11, 0x7c, 0xe5, 0x62, 0x1c, 0xa9, 0xcc,
	0xbb, 0x70, 0xc3, 0x1d, 0x50, 0x6c, 0x76, 0x5d, 0x9f, 0x76, 0xc7, 0x21, 0x11, 0x5f, 0x3c, 0xf4,
	0xe9, 0xd6, 0x10, 0xfa, 0x39, 0x2c, 0x77, 0x70, 0x40, 0x88, 0x72, 0x88, 0xdc, 0x62, 0x24, 0xf8,
	0x94, 0x78, 0xf0, 0x69, 0x30, 0xe7, 0x0e, 0x28, 0x67, 0x28, 0x8a, 0x84, 0x02, 0x77, 0xe3, 0xba,
	0x1b, 0x42, 0x61, 0x6d, 0x05, 0xde, 0x4a, 0xe3, 0x21, 0x0d, 0xf5, 0xab, 0x02, 0xdc, 0x3e, 0xf2,
	0xdc, 0x1e, 0x26, 0x64, 0xdf, 0xa0, 0xbd, 0x53, 0x6c, 0xf2, 0x44, 0x7b, 0x89, 0xd5, 0x63, 0xb2,
	0x15, 0xe2, 0xb2, 0x8d, 0x85, 0x7b, 0x31, 0x21, 0xdc, 0xef, 0xc1, 0x02, 0xcf, 0xb6, 0x7d, 0xc6,
	0x57, 0x04, 0x7d, 0x89, 0x07, 0xfd, 0x1c, 0x23, 0x73, 0x69, 0x78, 0xe4, 0x47, 0xb2, 0x72, 0x79,
	0x24, 0x2b, 0x27, 0xa5, 0x9f, 0x99, 0xc4, 0xf4, 0x93, 0x94, 0x3c, 0x2a, 0x89, 0xc9, 0xe3, 0x21,
	0xa8, 0x49, 0xe6, 0x90, 0xd7, 0x7c, 0xe5, 0x5c, 0xcd, 0xe2, 0x79, 0x17, 0x07, 0xf1, 0x4c, 0xd2,
	0x02, 0xb3, 0x38, 0x1a, 0x98, 0x2f, 0xe0, 0xda, 0xc8, 0x21, 0xc9, 0x75, 0x24, 0xd9, 0x14, 0x73,
	0x48, 0x36, 0xdf, 0x02, 0x75, 0xcf, 0x22, 0x21, 0xa3, 0xd6, 0xf9, 0x21, 0x2b, 0x94, 0x02, 0x21,
	0xa3, 0xf5, 0x9c, 0x32, 0x52, 0xcf, 0x69, 0x03, 0x58, 0x4a, 0x3c, 0x28, 0x05, 0xfd, 0x10, 0xaa,
	0x92, 0x05, 0x99, 0x4e, 0xd2, 0x10, 0x46, 0x7b, 0x20, 0x44, 0x65, 0x2f, 0xf6, 0x6b, 0x11, 0xe2,
	0xac, 0x02, 0x88, 0xf8, 0x67, 0x50, 0x5f, 0x2a, 0xd1, 0xfa, 0x52, 0xfb, 0x99, 0x10, 0x74, 0xec,
	0x98, 0x14, 0xf4, 0x27, 0xb0, 0x68, 0xf0, 0xa5, 0x2e, 0xbf, 0x4e, 0x51, 0x96, 0x28, 0x13, 0x97,
	0x25, 0x0b, 0xc6, 0x28, 0x1f, 0xed, 0x6b, 0x30, 0xbf, 0x8b, 0xe9, 0x95, 0xf2, 0xd7, 0x47, 0xb0,
	0x10, 0x6e, 0x95, 0xd2, 0xe5, 0x95, 0x74, 0x9f, 0xc1, 0x5b, 0x12, 0xfa, 0xa9, 0x45, 0x4f, 0xd9,
	0xe3, 0xb6, 0x8f, 0xa9, 0x61, 0x1a, 0xd4, 0x98, 0x32, 0xbe, 0xb5, 0xcf, 0x0b, 0x70, 0x37, 0x15,
	0x3a, 0x5f, 0x2d, 0x46, 0x9c, 0xaa, 0x90, 0x8b, 0x53, 0x21, 0x1b, 0x10, 0x2f, 0x05, 0x44, 0x35,
	0x25, 0x6b, 0x04, 0x9e, 0xa3, 0xea, 0x1b, 0x3f, 0xc8, 0x06, 0x1e, 0xaf, 0x34, 0xf4, 0x86, 0x1f,
	0xa3, 0x68, 0x67, 0xe1, 0x35, 0xb4, 0xce, 0xa3, 0x95, 0xdf, 0xf0, 0x19, 0xba, 0x7a, 0x09, 0x78,
	0x1f, 0x90, 0x27, 0x0e, 0xb1, 0xae, 0x81, 0x2b, 0x11, 0xde, 0x4f, 0x63, 0xb8, 0xc2, 0xa4, 0x6a,
	0x9b, 0x9a, 0x15, 0xde, 0xd2, 0x38, 0xe7, 0x9c, 0x7d, 0x0d, 0xc3, 0x9d, 0xd1, 0x80, 0x23, 0xad,
	0xf3, 0x5d, 0xa3, 0x8f, 0x2f, 0x8b, 0xd4, 0xcc, 0x1a, 0x2d, 0xa7, 0xb0, 0x91, 0xfa, 0x3c, 0x82,
	0x32, 0x17, 0x76, 0xb2, 0x68, 0xe6, 0x0a, 0x09, 0x00, 0xed, 0xd7, 0x0a, 0xdc, 0x4b, 0xe4, 0xb5,
	0xe9, 0x98, 0xf2, 0x45, 0xbd, 0x54, 0xb9, 0x4b, 0x9e, 0xc9, 0x64, 0xdd, 0x8b, 0x29, 0xba, 0x13,
	0x78, 0xe7, 0x52, 0x79, 0x72, 0xb7, 0xc2, 0x3a, 0xdc, 0x62, 0x4c, 0x25, 0x3b, 0x31, 0x46, 0x90,
	0x5a, 0x5f, 0x0f, 0xa6, 0x13, 0x42, 0x67, 0xf1, 0xa1, 0x99, 0xd0, 0x1c, 0x3f, 0x90, 0xbb, 0x58,
	0x0e, 0xdc, 0x1d, 0xb3, 0x45, 0xec, 0x52, 0x2e, 0x29, 0x9f, 0xb2, 0xf9, 0x9d, 0x0d, 0x2b, 0xe9,
	0xfc, 0x72, 0xd7, 0xee, 0x63, 0xb8, 0x29, 0xe3, 0x36, 0x88, 0xd8, 0xcc, 0x99, 0xe2, 0x71, 0xa9,
	0x5a, 0x68, 0x14, 0xf5, 0x04, 0x1d, 0xb5, 0xcf, 0xe0, 0xd6, 0x18, 0xba, 0x54, 0xa1, 0x2b, 0x3b,
	0xcc, 0x00, 0x5e, 0xa6, 0x85, 0xef, 0x64, 0x57, 0x25, 0x84, 0x9e, 0x8d, 0xca, 0xa5, 0xed, 0xc0,
	0xed, 0x61, 0xb5, 0x3e, 0xb1, 0x72, 0xda, 0x1d, 0x50, 0x93, 0x60, 0x64, 0x4d, 0xdb, 0x82, 0x2f,
	0x07, 0x2e, 0x18, 0xac, 0x65, 0x75, 0x0f, 0xed, 0x97, 0x0a, 0x68, 0x17, 0x81, 0x48, 0x83, 0x19,
	0x30, 0x3f, 0x22, 0x72, 0x70, 0xf9, 0xd3, 0x58, 0x6c, 0x2e, 0xaa, 0x2c, 0xd1, 0xfe, 0xa7, 0x80,
	0x7a, 0xec, 0x19, 0x0e, 0xe1, 0xf3, 0x03, 0xfe, 0xb2, 0x44, 0xa3, 0x30, 0xf5, 0x09, 0xff, 0x39,
	0x5c, 0xa3, 0xe1, 0x31, 0xd1, 0x22, 0x74, 0xa9, 0xcb, 0x3d, 0x7c, 0x7e, 0xe3, 0x20, 0x9b, 0x7c,
	0xe9, 0xfc, 0xe5, 0x64, 0x71, 0x71, 0xc8, 0x8a, 0x13, 0x8e, 0x5d, 0xed, 0xdb, 0x89, 0x03, 0xab,
	0x60, 0x2e, 0xa5, 0x8c, 0x4c, 0xa2, 0x0a, 0x91, 0x41, 0x56, 0x51, 0xfb, 0x29, 0x2c, 0x25, 0x32,
	0x94, 0x36, 0xff, 0x18, 0x66, 0xc5, 0xc3, 0x9d, 0xd7, 0x84, 0xaa, 0x6e, 0x0e, 0x3f, 0x36, 0x7e,
	0x7b, 0x07, 0x6e, 0x26, 0xff, 0x1f, 0x00, 0xfa, 0x8d, 0x02, 0x30, 0x6c, 0xd2, 0x51, 0xc6, 0x71,
	0xec, 0xd8, 0x10, 0x41, 0xfd, 0x60, 0x72, 0x00, 0x69, 0x8a, 0x3f, 0x28, 0x30, 0x37, 0xd2, 0xca,
	0xa3, 0x56, 0x46, 0x33, 0x24, 0x8c, 0x0f, 0xd4, 0xad, 0xa9, 0x30, 0xa4, 0x68, 0xbf, 0x50, 0xa0,
	0x22, 0x5b, 0x7e, 0xf4, 0xbd, 0xcc, 0x8a, 0x46, 0x4a, 0x67, 0xf5, 0xfb, 0x13, 0x9e, 0x96, 0x82,
	0xb0, 0x5b, 0x1b, 0x26, 0x8b, 0xac, 0xb7, 0x36, 0x36, 0x89, 0xc8, 0x7a, 0x6b, 0xe3, 0xc3, 0x09,
	0xf4, 0x2f, 0x05, 0xee, 0x5c, 0x34, 0x55, 0x40, 0x1f, 0x66, 0x63, 0x71, 0x85, 0x49, 0x87, 0xaa,
	0xe7, 0x09, 0x29, 0xf5, 0xf8, 0xab, 0x02, 0x37, 0x93, 0xc7, 0x0b, 0xe8, 0x49, 0x36, 0x76, 0x17,
	0x0e, 0x42, 0xd4, 0xbd, 0x7c, 0xc0, 0xa4, 0xd4, 0x7f, 0x56, 0x00, 0x8d, 0xb7, 0xf8, 0x68, 0x37,
	0xa3, 0x97, 0xa5, 0xcd, 0x4c, 0xd4, 0x47, 0xd3, 0x03, 0x49, 0x49, 0x7f, 0xa7, 0x40, 0x3d, 0x32,
	0x0f, 0x40, 0x1f, 0x64, 0xbe, 0xc3, 0xd8, 0xfc, 0x41, 0xdd, 0x9c, 0x02, 0x41, 0x0a, 0xf5, 0xb9,
	0x02, 0xd7, 0x12, 0x66, 0x00, 0x28, 0xa3, 0xda, 0xe9, 0xf3, 0x07, 0xb5, 0x9d, 0x03, 0x52, 0x4c,
	0xd8, 0xd8, 0x1c, 0x60, 0x12, 0x61, 0x93, 0x27, 0x10, 0x93, 0x08, 0x9b, 0x36, 0x94, 0x60, 0x19,
	0x53, 0x16, 0x66, 0x59, 0x33, 0xe6, 0xe8, 0xb0, 0x21, 0x6b, 0xc6, 0x8c, 0xcf, 0x1f, 0xfe, 0xa6,
	0x84, 0x15, 0x62, 0xbc, 0xbb, 0x47, 0x7b, 0x13, 0x41, 0xa7, 0xcc, 0x1f, 0xd4, 0xfd, 0x9c, 0xd0,
	0xc6, 0x05, 0x8f, 0x37, 0xbc, 0x13, 0x0a, 0x9e, 0xd2, 0xb1, 0x4f, 0x28, 0x78, 0x6a, 0x17, 0xfe,
	0x17, 0x05, 0x6e, 0x24, 0xf6, 0x76, 0xe8, 0xf1, 0x34, 0xfe, 0x35, 0xda, 0x83, 0xab, 0x4f, 0x72,
	0xc1, 0x92, 0x22, 0xff, 0x5b, 0x49, 0x68, 0xc1, 0x46, 0xdb, 0x51, 0x74, 0x9c, 0x03, 0xc3, 0xb1,
	0x6e, 0x5b, 0x3d, 0xc9, 0x19, 0x55, 0x2a, 0xf4, 0x0f, 0x45, 0x74, 0xae, 0x49, 0x3d, 0x1e, 0xda,
	0x9f, 0x92, 0x67, 0x4c, 0x85, 0x83, 0xbc, 0xe0, 0xa4, 0xec, 0x7f, 0x52, 0xa0, 0x11, 0xef, 0xba,
	0xd1, 0x4e, 0x76, 0x26, 0x09, 0x6d, 0xbe, 0xfa, 0x70, 0x5a, 0x18, 0x29, 0xe3, 0x1f, 0x95, 0x70,
	0xd2, 0x19, 0xfe, 0xdf, 0xe7, 0xf6, 0x44, 0x61, 0x14, 0xeb, 0x1b, 0xd5, 0x9d, 0x29, 0x51, 0x22,
	0x85, 0xc1, 0x78, 0x57, 0x99, 0xb5, 0x30, 0x48, 0x6d, 0x6f, 0xb3, 0x16, 0x06, 0xe9, 0x0d, 0x2e,
	0xfa, 0xa7, 0x22, 0xa6, 0xe2, 0xc9, 0xcd, 0x29, 0x3a, 0x9c, 0xec, 0xc6, 0x52, 0x7b, 0x65, 0xf5,
	0x28, 0x3f, 0xc0, 0xc8, 0xc3, 0x9c, 0xd0, 0xe3, 0x65, 0x7d, 0x98, 0xd3, 0xfb, 0xd2, 0xac, 0x0f,
	0xf3, 0x05, 0x0d, 0x67, 0xeb, 0xdd, 0x1f, 0xaf, 0x67, 0xfc, 0x4b, 0xb1, 0xe7, 0x33, 0xfc, 0x8f,
	0xc4, 0xde, 0xfb, 0x22, 0x00, 0x00, 0xff, 0xff, 0x98, 0x35, 0xfa, 0xaa, 0x63, 0x26, 0x00, 0x00,
}
