// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/GrandDAdsTwirp/twirp.proto

/*
Package GrandDAdsTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/GrandDAdsTwirp/twirp.proto
*/
package GrandDAdsTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===================
// GrandDAds Interface
// ===================

type GrandDAds interface {
	ShouldDeclineAd(context.Context, *ShouldDeclineAdRequest) (*AdRequestContext, error)

	SetPlayerTypeContext(context.Context, *SetPlayerTypeContextRequest) (*PlayerTypeContext, error)

	BatchSetPlayerTypeContext(context.Context, *BatchSetPlayerTypeContextRequest) (*BatchPlayerTypeContext, error)

	GetEligibleAdFormats(context.Context, *GetEligibleAdFormatsRequest) (*GetEligibleAdFormatsResponse, error)
}

// =========================
// GrandDAds Protobuf Client
// =========================

type grandDAdsProtobufClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewGrandDAdsProtobufClient creates a Protobuf client that implements the GrandDAds interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewGrandDAdsProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) GrandDAds {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + GrandDAdsPathPrefix
	urls := [4]string{
		prefix + "ShouldDeclineAd",
		prefix + "SetPlayerTypeContext",
		prefix + "BatchSetPlayerTypeContext",
		prefix + "GetEligibleAdFormats",
	}

	return &grandDAdsProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *grandDAdsProtobufClient) ShouldDeclineAd(ctx context.Context, in *ShouldDeclineAdRequest) (*AdRequestContext, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithMethodName(ctx, "ShouldDeclineAd")
	out := new(AdRequestContext)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *grandDAdsProtobufClient) SetPlayerTypeContext(ctx context.Context, in *SetPlayerTypeContextRequest) (*PlayerTypeContext, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithMethodName(ctx, "SetPlayerTypeContext")
	out := new(PlayerTypeContext)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *grandDAdsProtobufClient) BatchSetPlayerTypeContext(ctx context.Context, in *BatchSetPlayerTypeContextRequest) (*BatchPlayerTypeContext, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithMethodName(ctx, "BatchSetPlayerTypeContext")
	out := new(BatchPlayerTypeContext)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *grandDAdsProtobufClient) GetEligibleAdFormats(ctx context.Context, in *GetEligibleAdFormatsRequest) (*GetEligibleAdFormatsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithMethodName(ctx, "GetEligibleAdFormats")
	out := new(GetEligibleAdFormatsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =====================
// GrandDAds JSON Client
// =====================

type grandDAdsJSONClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewGrandDAdsJSONClient creates a JSON client that implements the GrandDAds interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewGrandDAdsJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) GrandDAds {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + GrandDAdsPathPrefix
	urls := [4]string{
		prefix + "ShouldDeclineAd",
		prefix + "SetPlayerTypeContext",
		prefix + "BatchSetPlayerTypeContext",
		prefix + "GetEligibleAdFormats",
	}

	return &grandDAdsJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *grandDAdsJSONClient) ShouldDeclineAd(ctx context.Context, in *ShouldDeclineAdRequest) (*AdRequestContext, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithMethodName(ctx, "ShouldDeclineAd")
	out := new(AdRequestContext)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *grandDAdsJSONClient) SetPlayerTypeContext(ctx context.Context, in *SetPlayerTypeContextRequest) (*PlayerTypeContext, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithMethodName(ctx, "SetPlayerTypeContext")
	out := new(PlayerTypeContext)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *grandDAdsJSONClient) BatchSetPlayerTypeContext(ctx context.Context, in *BatchSetPlayerTypeContextRequest) (*BatchPlayerTypeContext, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithMethodName(ctx, "BatchSetPlayerTypeContext")
	out := new(BatchPlayerTypeContext)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *grandDAdsJSONClient) GetEligibleAdFormats(ctx context.Context, in *GetEligibleAdFormatsRequest) (*GetEligibleAdFormatsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithMethodName(ctx, "GetEligibleAdFormats")
	out := new(GetEligibleAdFormatsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ========================
// GrandDAds Server Handler
// ========================

type grandDAdsServer struct {
	GrandDAds
	hooks *twirp.ServerHooks
}

func NewGrandDAdsServer(svc GrandDAds, hooks *twirp.ServerHooks) TwirpServer {
	return &grandDAdsServer{
		GrandDAds: svc,
		hooks:     hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *grandDAdsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// GrandDAdsPathPrefix is used for all URL paths on a twirp GrandDAds server.
// Requests are always: POST GrandDAdsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const GrandDAdsPathPrefix = "/twirp/twitch.fulton.example.granddads.GrandDAds/"

func (s *grandDAdsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.example.granddads")
	ctx = ctxsetters.WithServiceName(ctx, "GrandDAds")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.example.granddads.GrandDAds/ShouldDeclineAd":
		s.serveShouldDeclineAd(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.granddads.GrandDAds/SetPlayerTypeContext":
		s.serveSetPlayerTypeContext(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.granddads.GrandDAds/BatchSetPlayerTypeContext":
		s.serveBatchSetPlayerTypeContext(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.example.granddads.GrandDAds/GetEligibleAdFormats":
		s.serveGetEligibleAdFormats(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *grandDAdsServer) serveShouldDeclineAd(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveShouldDeclineAdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveShouldDeclineAdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *grandDAdsServer) serveShouldDeclineAdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ShouldDeclineAd")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ShouldDeclineAdRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AdRequestContext
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.GrandDAds.ShouldDeclineAd(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AdRequestContext and nil error while calling ShouldDeclineAd. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *grandDAdsServer) serveShouldDeclineAdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ShouldDeclineAd")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ShouldDeclineAdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AdRequestContext
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.GrandDAds.ShouldDeclineAd(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AdRequestContext and nil error while calling ShouldDeclineAd. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *grandDAdsServer) serveSetPlayerTypeContext(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetPlayerTypeContextJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetPlayerTypeContextProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *grandDAdsServer) serveSetPlayerTypeContextJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetPlayerTypeContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetPlayerTypeContextRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PlayerTypeContext
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.GrandDAds.SetPlayerTypeContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PlayerTypeContext and nil error while calling SetPlayerTypeContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *grandDAdsServer) serveSetPlayerTypeContextProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetPlayerTypeContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetPlayerTypeContextRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PlayerTypeContext
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.GrandDAds.SetPlayerTypeContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PlayerTypeContext and nil error while calling SetPlayerTypeContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *grandDAdsServer) serveBatchSetPlayerTypeContext(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBatchSetPlayerTypeContextJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBatchSetPlayerTypeContextProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *grandDAdsServer) serveBatchSetPlayerTypeContextJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchSetPlayerTypeContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BatchSetPlayerTypeContextRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchPlayerTypeContext
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.GrandDAds.BatchSetPlayerTypeContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchPlayerTypeContext and nil error while calling BatchSetPlayerTypeContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *grandDAdsServer) serveBatchSetPlayerTypeContextProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchSetPlayerTypeContext")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BatchSetPlayerTypeContextRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchPlayerTypeContext
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.GrandDAds.BatchSetPlayerTypeContext(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchPlayerTypeContext and nil error while calling BatchSetPlayerTypeContext. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *grandDAdsServer) serveGetEligibleAdFormats(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEligibleAdFormatsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEligibleAdFormatsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *grandDAdsServer) serveGetEligibleAdFormatsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEligibleAdFormats")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEligibleAdFormatsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEligibleAdFormatsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.GrandDAds.GetEligibleAdFormats(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEligibleAdFormatsResponse and nil error while calling GetEligibleAdFormats. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *grandDAdsServer) serveGetEligibleAdFormatsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEligibleAdFormats")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEligibleAdFormatsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEligibleAdFormatsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.GrandDAds.GetEligibleAdFormats(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEligibleAdFormatsResponse and nil error while calling GetEligibleAdFormats. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *grandDAdsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *grandDAdsServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *grandDAdsServer) PathPrefix() string {
	return GrandDAdsPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1629 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x18, 0x5b, 0x6f, 0x1b, 0x4b,
	0x99, 0x4d, 0xe2, 0xd8, 0xfe, 0x7c, 0xc9, 0x66, 0x72, 0xe9, 0x9e, 0x14, 0x74, 0x82, 0xcf, 0x11,
	0x8a, 0xb8, 0x38, 0x22, 0x47, 0xa8, 0x48, 0x80, 0x84, 0x93, 0xb8, 0xd5, 0x8a, 0x26, 0x6b, 0xad,
	0x9d, 0xb4, 0xa7, 0x42, 0x2c, 0xd3, 0x9d, 0x69, 0x32, 0x9c, 0xf5, 0xee, 0x32, 0x33, 0x76, 0x9b,
	0x02, 0x4f, 0x48, 0x80, 0x10, 0x6f, 0x3c, 0xf0, 0x8b, 0x90, 0x78, 0xe7, 0x87, 0x9c, 0x1f, 0xc0,
	0x0b, 0x9a, 0x8b, 0xed, 0xb5, 0xdb, 0x26, 0xa6, 0x7d, 0x42, 0xea, 0xcb, 0x6a, 0xbf, 0xfb, 0x37,
	0xdf, 0x75, 0x76, 0xa1, 0x1d, 0x67, 0x84, 0xb6, 0x7f, 0x33, 0x12, 0x92, 0xa5, 0x6d, 0x39, 0x3e,
	0xc4, 0xc3, 0xd7, 0xe9, 0xe1, 0x23, 0x8e, 0x53, 0x72, 0xda, 0x21, 0x62, 0xf0, 0x92, 0xf1, 0xfc,
	0x50, 0xaa, 0x67, 0x3b, 0xe7, 0x99, 0xcc, 0xd0, 0xa7, 0xf2, 0x25, 0x93, 0xf1, 0x75, 0xfb, 0xc5,
	0x28, 0x91, 0x59, 0xda, 0xa6, 0xaf, 0xf0, 0x30, 0x4f, 0x68, 0xfb, 0x4a, 0x49, 0x10, 0x4c, 0xc4,
	0xde, 0x1b, 0x0a, 0x89, 0x38, 0xd4, 0xa2, 0x71, 0x96, 0x88, 0x43, 0x79, 0x93, 0x53, 0xfb, 0x34,
	0x0a, 0xf7, 0x7e, 0x7e, 0x2b, 0xff, 0x70, 0x94, 0x48, 0x86, 0xc9, 0x8b, 0x8c, 0x0f, 0xb1, 0x5c,
	0x04, 0x8d, 0x86, 0xd6, 0xbf, 0xca, 0xb0, 0xdb, 0xbf, 0xce, 0x46, 0x09, 0x39, 0xa5, 0x71, 0xc2,
	0x52, 0xda, 0x21, 0x21, 0xfd, 0xed, 0x88, 0x0a, 0x89, 0x5a, 0xd0, 0xc0, 0x24, 0x12, 0x54, 0x08,
	0x96, 0xa5, 0x11, 0x23, 0x9e, 0xb3, 0xef, 0x1c, 0x54, 0xc3, 0x1a, 0x26, 0x7d, 0x83, 0xf3, 0x09,
	0xf2, 0xa1, 0xca, 0xb3, 0x24, 0x89, 0x94, 0x53, 0xde, 0xca, 0xbe, 0x73, 0xd0, 0x3c, 0xfa, 0xfe,
	0xc2, 0x21, 0xda, 0x98, 0x58, 0x63, 0xca, 0xa9, 0xb6, 0x71, 0x3f, 0xcc, 0x92, 0x64, 0x70, 0x93,
	0xd3, 0xb0, 0xc2, 0xed, 0x1b, 0xba, 0x80, 0x66, 0x9e, 0xe0, 0x1b, 0xca, 0xa3, 0x38, 0x4b, 0x25,
	0x7d, 0x25, 0xbd, 0xd5, 0x7d, 0xe7, 0xa0, 0x76, 0xd4, 0x6e, 0xdf, 0x11, 0xb5, 0x76, 0x4f, 0x8b,
	0x9d, 0x18, 0xa9, 0xb0, 0x91, 0x17, 0x41, 0xa5, 0x36, 0x4e, 0x18, 0x4d, 0xe5, 0x54, 0xed, 0xda,
	0x92, 0x6a, 0x4f, 0xb4, 0xd8, 0x54, 0x6d, 0x5c, 0x04, 0xd1, 0x3d, 0x28, 0x8f, 0x04, 0xe5, 0x2a,
	0x2c, 0x25, 0x1d, 0x96, 0x75, 0x05, 0xfa, 0x04, 0xdd, 0x87, 0x2a, 0xa1, 0x63, 0x16, 0x53, 0x45,
	0x5a, 0xd7, 0xa4, 0x8a, 0x41, 0x18, 0xa2, 0x75, 0x86, 0x11, 0xaf, 0x6c, 0x88, 0x06, 0xe1, 0x13,
	0xb4, 0x07, 0x15, 0x32, 0xe2, 0x58, 0xb2, 0x2c, 0xf5, 0x2a, 0xfb, 0xce, 0x41, 0x29, 0x9c, 0xc2,
	0xe8, 0x0b, 0xd8, 0x65, 0x22, 0x12, 0x94, 0x8f, 0x29, 0x8f, 0x04, 0x23, 0x34, 0xe2, 0x26, 0x4b,
	0x5e, 0x75, 0xdf, 0x39, 0xa8, 0x84, 0x5b, 0x4c, 0xf4, 0x35, 0xb1, 0xcf, 0x08, 0x9d, 0x24, 0x30,
	0x04, 0x15, 0x0b, 0xa9, 0x12, 0x6e, 0x12, 0x04, 0x3a, 0x41, 0x3f, 0x58, 0x26, 0xa0, 0x5a, 0x4a,
	0x67, 0xa8, 0x9e, 0x17, 0x20, 0xf4, 0x6d, 0xa8, 0xc7, 0xd9, 0x28, 0x95, 0xfc, 0x26, 0x52, 0x69,
	0xf6, 0x6a, 0xa6, 0x26, 0x2c, 0xee, 0x24, 0x23, 0x14, 0xed, 0xc0, 0x3a, 0x13, 0xd1, 0x38, 0x19,
	0x7a, 0x75, 0xed, 0x5b, 0x89, 0x89, 0xcb, 0x64, 0xa8, 0x8e, 0x37, 0xd1, 0xe4, 0x35, 0xcc, 0xd1,
	0x27, 0x30, 0xfa, 0x0c, 0x1a, 0x71, 0x36, 0x1c, 0x52, 0x1e, 0x33, 0x9c, 0xa8, 0xd8, 0x34, 0x35,
	0x43, 0x7d, 0x86, 0xf4, 0x89, 0x62, 0x62, 0x22, 0x1a, 0x32, 0x32, 0x64, 0x44, 0x55, 0x8d, 0xb7,
	0xa1, 0xd5, 0xd7, 0x99, 0x38, 0x9b, 0xe2, 0xac, 0xf1, 0x21, 0x26, 0x9e, 0x3b, 0x31, 0x7e, 0x86,
	0x09, 0x7a, 0x00, 0x1e, 0x13, 0x11, 0x4b, 0x25, 0xe5, 0x7c, 0x94, 0x4b, 0x4a, 0x22, 0x21, 0x39,
	0xc5, 0xc3, 0x08, 0x13, 0x6f, 0x53, 0x33, 0xee, 0x30, 0xe1, 0xcf, 0xc8, 0x7d, 0x4d, 0xed, 0x10,
	0xd4, 0x86, 0x2d, 0x26, 0x22, 0x9b, 0x34, 0xc9, 0xd9, 0xd5, 0x15, 0xe5, 0x94, 0x78, 0x48, 0xcb,
	0x6c, 0x32, 0x61, 0x8a, 0x64, 0x30, 0x21, 0x20, 0x04, 0x6b, 0x57, 0x78, 0x48, 0xbd, 0x2d, 0x7d,
	0x00, 0xfd, 0x8e, 0xbe, 0x07, 0x9b, 0x26, 0xe2, 0x51, 0x9c, 0x71, 0x4e, 0x13, 0x2c, 0x33, 0xee,
	0x6d, 0x6b, 0x06, 0xd7, 0x10, 0x4e, 0xa6, 0x78, 0x55, 0x22, 0x98, 0x44, 0xa6, 0x49, 0xbd, 0x1d,
	0x13, 0x27, 0x4c, 0x1e, 0x6a, 0x58, 0x11, 0xc7, 0x8c, 0xbe, 0x54, 0x75, 0x97, 0x7b, 0xbb, 0x86,
	0x68, 0x10, 0x7e, 0xde, 0xfa, 0xba, 0x0c, 0xf7, 0x1f, 0x51, 0xd9, 0x4d, 0xd8, 0x15, 0x7b, 0x9e,
	0xd0, 0x8e, 0x15, 0x12, 0x1f, 0xfb, 0xf9, 0x63, 0x3f, 0xff, 0xdf, 0xf6, 0xf3, 0x6d, 0x8d, 0xeb,
	0xbe, 0x47, 0xe3, 0x6e, 0xde, 0xd5, 0xb8, 0xe8, 0xae, 0xc6, 0xdd, 0x7a, 0x47, 0xe3, 0x0e, 0x00,
	0xa6, 0x8d, 0x2b, 0xbc, 0xed, 0xfd, 0xd5, 0x83, 0xe6, 0xd1, 0x8f, 0x6e, 0xef, 0x9d, 0x85, 0x8d,
	0x3c, 0xe9, 0xd8, 0xb0, 0x3a, 0x69, 0x78, 0x31, 0xdf, 0xf1, 0x3b, 0x0b, 0x1d, 0xff, 0x47, 0x07,
	0xdc, 0xe9, 0xbe, 0x9e, 0x54, 0xf2, 0x7d, 0xa8, 0x72, 0x4c, 0x22, 0x99, 0x7d, 0x45, 0x53, 0xdb,
	0xe2, 0x15, 0x8e, 0xc9, 0x40, 0xc1, 0xaa, 0x84, 0x88, 0xd9, 0xf3, 0x91, 0x90, 0x58, 0x9a, 0x1e,
	0xaf, 0x2d, 0x51, 0x42, 0xf6, 0x76, 0xd0, 0x57, 0x42, 0x61, 0x9d, 0x14, 0xa0, 0xd6, 0x7f, 0x1c,
	0xf8, 0xe6, 0xdb, 0xe7, 0x8e, 0xc8, 0xb3, 0x54, 0xd0, 0xdb, 0x3d, 0xfa, 0x35, 0xb8, 0xd4, 0x4a,
	0x4e, 0x83, 0xb7, 0xf2, 0x21, 0xc1, 0xdb, 0x98, 0xa8, 0x9b, 0x84, 0xf0, 0x97, 0xe0, 0x5a, 0x7f,
	0x67, 0xe9, 0x59, 0xdd, 0x5f, 0x3d, 0xa8, 0x1d, 0xfd, 0x70, 0xd9, 0x63, 0x93, 0x99, 0xf6, 0x89,
	0x2a, 0xab, 0xbd, 0xf5, 0x57, 0x07, 0xdc, 0x45, 0x2e, 0xf4, 0x2b, 0xd8, 0x58, 0x30, 0xa9, 0xcf,
	0xfd, 0xde, 0x67, 0x6a, 0xce, 0x5b, 0x45, 0xbb, 0xb0, 0xce, 0x29, 0x16, 0x59, 0xaa, 0xf3, 0x57,
	0x0d, 0x2d, 0xd4, 0xfa, 0xf7, 0x2a, 0x34, 0xe6, 0xa6, 0x27, 0xfa, 0x14, 0x6a, 0x29, 0x1e, 0xc9,
	0xeb, 0xb9, 0xe8, 0x83, 0x46, 0x4d, 0x2a, 0xa2, 0xae, 0x07, 0xa9, 0xea, 0x92, 0xd9, 0xd0, 0x3f,
	0x5c, 0x66, 0xe8, 0x9f, 0x18, 0x39, 0x3d, 0x55, 0x6a, 0xf1, 0x0c, 0x50, 0x46, 0x99, 0x88, 0xf0,
	0x48, 0x66, 0x6a, 0x76, 0xeb, 0xb9, 0x5f, 0x09, 0x81, 0x89, 0x8e, 0xc5, 0xa8, 0x8a, 0x30, 0x5e,
	0x09, 0x76, 0xa5, 0xe7, 0x77, 0x35, 0xac, 0x68, 0x44, 0x9f, 0x5d, 0xa1, 0x6f, 0x01, 0xc4, 0xd7,
	0x38, 0x4d, 0x69, 0x32, 0x9b, 0xc6, 0x55, 0x8b, 0xf1, 0x89, 0x52, 0x6e, 0xf7, 0x8a, 0xf6, 0xd7,
	0x8c, 0x64, 0x30, 0x28, 0x6d, 0x7d, 0x07, 0xd6, 0xc7, 0x19, 0x99, 0x4d, 0xe4, 0xd2, 0x38, 0x23,
	0x3e, 0x41, 0x07, 0xe0, 0x8e, 0x19, 0xa1, 0x59, 0x71, 0x03, 0x56, 0x34, 0x43, 0x53, 0xe3, 0x67,
	0x4b, 0xf0, 0x3b, 0xb0, 0xa1, 0xd4, 0x15, 0x19, 0xab, 0x9a, 0x51, 0xaf, 0xa2, 0x19, 0xdf, 0x67,
	0x50, 0xc3, 0x79, 0x1e, 0x8d, 0x29, 0x57, 0x08, 0x3d, 0x8d, 0xab, 0xc7, 0x2b, 0x9e, 0x13, 0x02,
	0xce, 0xf3, 0x4b, 0x83, 0x55, 0x66, 0xad, 0xbb, 0x82, 0xbd, 0xa6, 0xd1, 0x70, 0x36, 0x64, 0xed,
	0x7a, 0xec, 0xb3, 0xd7, 0xf4, 0x4c, 0xcd, 0xd9, 0x7b, 0x50, 0xe6, 0x98, 0x69, 0xc7, 0xeb, 0x36,
	0xab, 0x98, 0x11, 0x9f, 0xb4, 0xbe, 0x76, 0xa0, 0x31, 0xb7, 0xbc, 0xd4, 0x2a, 0xd7, 0x01, 0x26,
	0x2c, 0x8b, 0xb2, 0x34, 0xb9, 0xd1, 0x79, 0xad, 0x84, 0x35, 0x15, 0x62, 0xc2, 0xb2, 0x20, 0x4d,
	0x6e, 0xd0, 0x4f, 0x60, 0x8f, 0x89, 0x68, 0x24, 0x58, 0x7a, 0x15, 0xd1, 0x57, 0x92, 0xf2, 0x14,
	0x27, 0x91, 0x32, 0xf9, 0x1c, 0xc7, 0x5f, 0xe9, 0x34, 0x57, 0xc2, 0x7b, 0x4c, 0x5c, 0x28, 0x86,
	0xae, 0xa5, 0xf7, 0x2c, 0xd9, 0xce, 0xfc, 0x9c, 0xe5, 0x36, 0x79, 0x25, 0x26, 0x7a, 0x2c, 0x57,
	0x91, 0xd1, 0x23, 0x3b, 0x65, 0x91, 0xbc, 0xa6, 0x58, 0x52, 0xae, 0xb3, 0x57, 0x09, 0x1b, 0x6a,
	0x68, 0xa7, 0x6c, 0x60, 0x90, 0x3a, 0x85, 0x66, 0xf2, 0xe2, 0x3c, 0x9f, 0xa6, 0x50, 0x63, 0x3a,
	0x79, 0xae, 0x52, 0x58, 0x0c, 0x9c, 0x4d, 0xe1, 0x2c, 0x68, 0xad, 0x67, 0x50, 0x2f, 0x0e, 0x1c,
	0xf4, 0x39, 0x34, 0x44, 0xf1, 0x23, 0xc5, 0x9e, 0x77, 0x1e, 0xa9, 0xb8, 0x6c, 0x9f, 0x84, 0xc5,
	0xe6, 0x98, 0x47, 0xb6, 0x7e, 0x0f, 0xfb, 0xc7, 0x58, 0xc6, 0xd7, 0x7d, 0x2a, 0x7b, 0xd3, 0xa2,
	0x99, 0xdc, 0x0a, 0xec, 0xa6, 0x7d, 0x0a, 0x15, 0xbb, 0x8f, 0x85, 0xe7, 0xe8, 0x51, 0xf1, 0xd3,
	0x3b, 0x47, 0xc5, 0x2d, 0xfa, 0xc2, 0xa9, 0xb6, 0xd6, 0xdf, 0x1c, 0xb8, 0x7f, 0x9b, 0xe5, 0xf9,
	0xe2, 0x77, 0x16, 0x8b, 0x7f, 0xee, 0x36, 0xb2, 0xb2, 0x70, 0x1b, 0x71, 0x61, 0x55, 0xca, 0x44,
	0x67, 0xac, 0x14, 0xaa, 0xd7, 0xc5, 0x5e, 0x59, 0x5b, 0xec, 0x95, 0xd6, 0x16, 0x6c, 0xbe, 0xe1,
	0x4a, 0xeb, 0xcf, 0x0e, 0xdc, 0xd3, 0x21, 0x9a, 0x1b, 0x25, 0x5d, 0xce, 0x33, 0x8e, 0x2e, 0xa1,
	0x3c, 0xb9, 0xa9, 0x38, 0x7a, 0x75, 0x7c, 0x58, 0x60, 0x26, 0xca, 0xd0, 0x36, 0x94, 0xa8, 0x32,
	0x60, 0x0f, 0x65, 0x80, 0xd6, 0xef, 0x60, 0xb7, 0xe0, 0x48, 0x41, 0x1e, 0x61, 0xd8, 0x78, 0x81,
	0x59, 0x42, 0x49, 0xb4, 0x90, 0xa8, 0x1f, 0xdf, 0xe9, 0xcf, 0x3b, 0x8e, 0x16, 0x36, 0x8d, 0x42,
	0xeb, 0x9a, 0xf8, 0xee, 0x9f, 0x56, 0xa0, 0x5e, 0xbc, 0x39, 0xa1, 0x4f, 0x60, 0xe7, 0xe2, 0x3c,
	0xec, 0x9e, 0x04, 0x8f, 0xce, 0xfd, 0x67, 0xdd, 0xd3, 0xa8, 0xf7, 0xb8, 0x33, 0x78, 0x18, 0x84,
	0x67, 0xee, 0x37, 0x10, 0x82, 0x66, 0xf7, 0xac, 0x37, 0xf8, 0x72, 0x86, 0x73, 0x50, 0x19, 0x56,
	0x9f, 0x74, 0x8f, 0xdd, 0x15, 0xd4, 0x04, 0x38, 0x0b, 0x8e, 0xfd, 0xc7, 0xdd, 0x48, 0xc1, 0xab,
	0x8a, 0xe0, 0x07, 0x7d, 0x77, 0x0d, 0xd5, 0xa0, 0xdc, 0x39, 0x3f, 0x0d, 0x03, 0xff, 0xd4, 0x2d,
	0x29, 0xe0, 0xe9, 0x71, 0xf0, 0x34, 0x38, 0xef, 0xba, 0xeb, 0x8a, 0xe5, 0xe2, 0x49, 0xcf, 0x2d,
	0xa3, 0x0d, 0xa8, 0xf5, 0x1e, 0x77, 0xbe, 0xec, 0x0f, 0x3a, 0x03, 0x3f, 0x38, 0x77, 0x2b, 0x68,
	0x1b, 0xdc, 0x02, 0x22, 0x7a, 0x18, 0x5c, 0x84, 0x6e, 0x55, 0x99, 0xb0, 0x9a, 0xa2, 0xc1, 0xa5,
	0x0b, 0x4a, 0xd9, 0x43, 0x3f, 0xec, 0x2a, 0xa0, 0x86, 0x2a, 0xb0, 0x36, 0xb8, 0x0c, 0xfa, 0x6e,
	0x1d, 0x55, 0xa1, 0xf4, 0xf8, 0x91, 0x42, 0x36, 0x50, 0x1d, 0x2a, 0x97, 0x7e, 0xe8, 0x9f, 0xfa,
	0x9d, 0x73, 0xb7, 0xa9, 0xa0, 0x5e, 0x18, 0xf4, 0x7b, 0xdd, 0x30, 0x70, 0x37, 0x50, 0x03, 0xaa,
	0x4f, 0x82, 0xe0, 0xb4, 0x3f, 0x08, 0x4e, 0x7e, 0xe1, 0xba, 0x47, 0xff, 0x5c, 0x83, 0xea, 0xf4,
	0xaf, 0x06, 0xfa, 0x03, 0x6c, 0x2c, 0xfc, 0x30, 0x40, 0x0f, 0xee, 0xae, 0x81, 0xb7, 0xfe, 0x62,
	0xd8, 0xbb, 0x7b, 0x01, 0xbf, 0x71, 0xbd, 0xf9, 0x8b, 0x03, 0xdb, 0x6f, 0xab, 0x28, 0xf4, 0x41,
	0x85, 0xb8, 0x77, 0xb4, 0xe4, 0x57, 0x49, 0xd1, 0xe2, 0x3f, 0x1c, 0xf8, 0xe4, 0x9d, 0xa3, 0x04,
	0x75, 0x96, 0x2b, 0xc4, 0xdb, 0x9c, 0x7a, 0xf0, 0xbf, 0xd4, 0x72, 0xd1, 0xf6, 0xdf, 0x1d, 0xd8,
	0x7e, 0xdb, 0x95, 0x6c, 0x89, 0x20, 0xdd, 0xf2, 0x05, 0xb9, 0xf7, 0xb3, 0xf7, 0x94, 0x36, 0xf7,
	0xc0, 0xe3, 0xcf, 0x9f, 0xb5, 0xee, 0xfe, 0x61, 0xf6, 0x7c, 0x5d, 0x5f, 0x33, 0xbe, 0xf8, 0x6f,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x44, 0xa2, 0xfb, 0x5e, 0x5d, 0x13, 0x00, 0x00,
}
