// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: main.proto

/*
Package JabbaTwirpGoLang is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	main.proto
*/
package JabbaTwirpGoLang

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ===============
// Jabba Interface
// ===============

type Jabba interface {
	// Brand Settings
	GetBrandSettings(context.Context, *GetBrandSettingsRequest) (*GetBrandSettingsResponse, error)

	SetBrandSettings(context.Context, *SetBrandSettingsRequest) (*SetBrandSettingsResponse, error)

	// Campaign Queries
	GetAvailableCampaigns(context.Context, *GetAvailableCampaignsRequest) (*GetAvailableCampaignsResponse, error)

	GetCampaign(context.Context, *GetCampaignRequest) (*GetCampaignResponse, error)

	GetCampaigns(context.Context, *GetCampaignsRequest) (*GetCampaignsResponse, error)

	GetCampaignsByIds(context.Context, *GetCampaignsByIdsRequest) (*GetCampaignsByIdsResponse, error)

	GetCampaignUploadConfig(context.Context, *GetCampaignUploadConfigRequest) (*GetCampaignUploadConfigResponse, error)

	GetCampaignReporting(context.Context, *GetCampaignReportingRequest) (*GetCampaignReportingResponse, error)

	GetTargetingReach(context.Context, *GetTargetingReachRequest) (*GetTargetingReachResponse, error)

	// Campaign Mutations
	CreateCampaign(context.Context, *CreateCampaignRequest) (*CreateCampaignResponse, error)

	UpdateCampaign(context.Context, *UpdateCampaignRequest) (*UpdateCampaignResponse, error)

	UpdateCampaignBalance(context.Context, *UpdateCampaignBalanceRequest) (*google_protobuf1.Empty, error)

	ApproveCampaign(context.Context, *ApproveCampaignRequest) (*ApproveCampaignResponse, error)

	RefreshCampaign(context.Context, *RefreshCampaignRequest) (*RefreshCampaignResponse, error)

	IngestCampaignKeys(context.Context, *IngestCampaignKeysRequest) (*IngestCampaignKeysResponse, error)

	// Internal Campaign Cleanup
	InternalDeleteCampaign(context.Context, *InternalDeleteCampaignRequest) (*InternalDeleteCampaignResponse, error)

	// Misc
	HandleBountyEvent(context.Context, *HandleBountyEventRequest) (*HandleBountyEventResponse, error)

	GetBountyBoardGames(context.Context, *GetBountyBoardGamesRequest) (*GetBountyBoardGamesResponse, error)
}

// =====================
// Jabba Protobuf Client
// =====================

type jabbaProtobufClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewJabbaProtobufClient creates a Protobuf client that implements the Jabba interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewJabbaProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Jabba {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + JabbaPathPrefix
	urls := [18]string{
		prefix + "GetBrandSettings",
		prefix + "SetBrandSettings",
		prefix + "GetAvailableCampaigns",
		prefix + "GetCampaign",
		prefix + "GetCampaigns",
		prefix + "GetCampaignsByIds",
		prefix + "GetCampaignUploadConfig",
		prefix + "GetCampaignReporting",
		prefix + "GetTargetingReach",
		prefix + "CreateCampaign",
		prefix + "UpdateCampaign",
		prefix + "UpdateCampaignBalance",
		prefix + "ApproveCampaign",
		prefix + "RefreshCampaign",
		prefix + "IngestCampaignKeys",
		prefix + "InternalDeleteCampaign",
		prefix + "HandleBountyEvent",
		prefix + "GetBountyBoardGames",
	}

	return &jabbaProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *jabbaProtobufClient) GetBrandSettings(ctx context.Context, in *GetBrandSettingsRequest) (*GetBrandSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetBrandSettings")
	out := new(GetBrandSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) SetBrandSettings(ctx context.Context, in *SetBrandSettingsRequest) (*SetBrandSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "SetBrandSettings")
	out := new(SetBrandSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) GetAvailableCampaigns(ctx context.Context, in *GetAvailableCampaignsRequest) (*GetAvailableCampaignsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableCampaigns")
	out := new(GetAvailableCampaignsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) GetCampaign(ctx context.Context, in *GetCampaignRequest) (*GetCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaign")
	out := new(GetCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) GetCampaigns(ctx context.Context, in *GetCampaignsRequest) (*GetCampaignsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaigns")
	out := new(GetCampaignsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) GetCampaignsByIds(ctx context.Context, in *GetCampaignsByIdsRequest) (*GetCampaignsByIdsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsByIds")
	out := new(GetCampaignsByIdsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) GetCampaignUploadConfig(ctx context.Context, in *GetCampaignUploadConfigRequest) (*GetCampaignUploadConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignUploadConfig")
	out := new(GetCampaignUploadConfigResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) GetCampaignReporting(ctx context.Context, in *GetCampaignReportingRequest) (*GetCampaignReportingResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignReporting")
	out := new(GetCampaignReportingResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) GetTargetingReach(ctx context.Context, in *GetTargetingReachRequest) (*GetTargetingReachResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetingReach")
	out := new(GetTargetingReachResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) CreateCampaign(ctx context.Context, in *CreateCampaignRequest) (*CreateCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCampaign")
	out := new(CreateCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) UpdateCampaign(ctx context.Context, in *UpdateCampaignRequest) (*UpdateCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaign")
	out := new(UpdateCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) UpdateCampaignBalance(ctx context.Context, in *UpdateCampaignBalanceRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaignBalance")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) ApproveCampaign(ctx context.Context, in *ApproveCampaignRequest) (*ApproveCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "ApproveCampaign")
	out := new(ApproveCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) RefreshCampaign(ctx context.Context, in *RefreshCampaignRequest) (*RefreshCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "RefreshCampaign")
	out := new(RefreshCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) IngestCampaignKeys(ctx context.Context, in *IngestCampaignKeysRequest) (*IngestCampaignKeysResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "IngestCampaignKeys")
	out := new(IngestCampaignKeysResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) InternalDeleteCampaign(ctx context.Context, in *InternalDeleteCampaignRequest) (*InternalDeleteCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "InternalDeleteCampaign")
	out := new(InternalDeleteCampaignResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) HandleBountyEvent(ctx context.Context, in *HandleBountyEventRequest) (*HandleBountyEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "HandleBountyEvent")
	out := new(HandleBountyEventResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaProtobufClient) GetBountyBoardGames(ctx context.Context, in *GetBountyBoardGamesRequest) (*GetBountyBoardGamesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyBoardGames")
	out := new(GetBountyBoardGamesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================
// Jabba JSON Client
// =================

type jabbaJSONClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewJabbaJSONClient creates a JSON client that implements the Jabba interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewJabbaJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Jabba {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + JabbaPathPrefix
	urls := [18]string{
		prefix + "GetBrandSettings",
		prefix + "SetBrandSettings",
		prefix + "GetAvailableCampaigns",
		prefix + "GetCampaign",
		prefix + "GetCampaigns",
		prefix + "GetCampaignsByIds",
		prefix + "GetCampaignUploadConfig",
		prefix + "GetCampaignReporting",
		prefix + "GetTargetingReach",
		prefix + "CreateCampaign",
		prefix + "UpdateCampaign",
		prefix + "UpdateCampaignBalance",
		prefix + "ApproveCampaign",
		prefix + "RefreshCampaign",
		prefix + "IngestCampaignKeys",
		prefix + "InternalDeleteCampaign",
		prefix + "HandleBountyEvent",
		prefix + "GetBountyBoardGames",
	}

	return &jabbaJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *jabbaJSONClient) GetBrandSettings(ctx context.Context, in *GetBrandSettingsRequest) (*GetBrandSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetBrandSettings")
	out := new(GetBrandSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) SetBrandSettings(ctx context.Context, in *SetBrandSettingsRequest) (*SetBrandSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "SetBrandSettings")
	out := new(SetBrandSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) GetAvailableCampaigns(ctx context.Context, in *GetAvailableCampaignsRequest) (*GetAvailableCampaignsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableCampaigns")
	out := new(GetAvailableCampaignsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) GetCampaign(ctx context.Context, in *GetCampaignRequest) (*GetCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaign")
	out := new(GetCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) GetCampaigns(ctx context.Context, in *GetCampaignsRequest) (*GetCampaignsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaigns")
	out := new(GetCampaignsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) GetCampaignsByIds(ctx context.Context, in *GetCampaignsByIdsRequest) (*GetCampaignsByIdsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsByIds")
	out := new(GetCampaignsByIdsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) GetCampaignUploadConfig(ctx context.Context, in *GetCampaignUploadConfigRequest) (*GetCampaignUploadConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignUploadConfig")
	out := new(GetCampaignUploadConfigResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) GetCampaignReporting(ctx context.Context, in *GetCampaignReportingRequest) (*GetCampaignReportingResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignReporting")
	out := new(GetCampaignReportingResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) GetTargetingReach(ctx context.Context, in *GetTargetingReachRequest) (*GetTargetingReachResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetingReach")
	out := new(GetTargetingReachResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) CreateCampaign(ctx context.Context, in *CreateCampaignRequest) (*CreateCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCampaign")
	out := new(CreateCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) UpdateCampaign(ctx context.Context, in *UpdateCampaignRequest) (*UpdateCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaign")
	out := new(UpdateCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) UpdateCampaignBalance(ctx context.Context, in *UpdateCampaignBalanceRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaignBalance")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) ApproveCampaign(ctx context.Context, in *ApproveCampaignRequest) (*ApproveCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "ApproveCampaign")
	out := new(ApproveCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) RefreshCampaign(ctx context.Context, in *RefreshCampaignRequest) (*RefreshCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "RefreshCampaign")
	out := new(RefreshCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) IngestCampaignKeys(ctx context.Context, in *IngestCampaignKeysRequest) (*IngestCampaignKeysResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "IngestCampaignKeys")
	out := new(IngestCampaignKeysResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) InternalDeleteCampaign(ctx context.Context, in *InternalDeleteCampaignRequest) (*InternalDeleteCampaignResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "InternalDeleteCampaign")
	out := new(InternalDeleteCampaignResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) HandleBountyEvent(ctx context.Context, in *HandleBountyEventRequest) (*HandleBountyEventResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "HandleBountyEvent")
	out := new(HandleBountyEventResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jabbaJSONClient) GetBountyBoardGames(ctx context.Context, in *GetBountyBoardGamesRequest) (*GetBountyBoardGamesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyBoardGames")
	out := new(GetBountyBoardGamesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ====================
// Jabba Server Handler
// ====================

type jabbaServer struct {
	Jabba
	hooks *twirp.ServerHooks
}

func NewJabbaServer(svc Jabba, hooks *twirp.ServerHooks) TwirpServer {
	return &jabbaServer{
		Jabba: svc,
		hooks: hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *jabbaServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// JabbaPathPrefix is used for all URL paths on a twirp Jabba server.
// Requests are always: POST JabbaPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const JabbaPathPrefix = "/twirp/twitch.bounty.board.Jabba/"

func (s *jabbaServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board")
	ctx = ctxsetters.WithServiceName(ctx, "Jabba")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.bounty.board.Jabba/GetBrandSettings":
		s.serveGetBrandSettings(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/SetBrandSettings":
		s.serveSetBrandSettings(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/GetAvailableCampaigns":
		s.serveGetAvailableCampaigns(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/GetCampaign":
		s.serveGetCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/GetCampaigns":
		s.serveGetCampaigns(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/GetCampaignsByIds":
		s.serveGetCampaignsByIds(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/GetCampaignUploadConfig":
		s.serveGetCampaignUploadConfig(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/GetCampaignReporting":
		s.serveGetCampaignReporting(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/GetTargetingReach":
		s.serveGetTargetingReach(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/CreateCampaign":
		s.serveCreateCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/UpdateCampaign":
		s.serveUpdateCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/UpdateCampaignBalance":
		s.serveUpdateCampaignBalance(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/ApproveCampaign":
		s.serveApproveCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/RefreshCampaign":
		s.serveRefreshCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/IngestCampaignKeys":
		s.serveIngestCampaignKeys(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/InternalDeleteCampaign":
		s.serveInternalDeleteCampaign(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/HandleBountyEvent":
		s.serveHandleBountyEvent(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.Jabba/GetBountyBoardGames":
		s.serveGetBountyBoardGames(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *jabbaServer) serveGetBrandSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBrandSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBrandSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetBrandSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBrandSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBrandSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBrandSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetBrandSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBrandSettingsResponse and nil error while calling GetBrandSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetBrandSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBrandSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBrandSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBrandSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetBrandSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBrandSettingsResponse and nil error while calling GetBrandSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveSetBrandSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetBrandSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetBrandSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveSetBrandSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetBrandSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetBrandSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetBrandSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.SetBrandSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetBrandSettingsResponse and nil error while calling SetBrandSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveSetBrandSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetBrandSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetBrandSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetBrandSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.SetBrandSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetBrandSettingsResponse and nil error while calling SetBrandSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetAvailableCampaigns(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAvailableCampaignsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAvailableCampaignsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetAvailableCampaignsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableCampaigns")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAvailableCampaignsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAvailableCampaignsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetAvailableCampaigns(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAvailableCampaignsResponse and nil error while calling GetAvailableCampaigns. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetAvailableCampaignsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableCampaigns")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAvailableCampaignsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAvailableCampaignsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetAvailableCampaigns(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAvailableCampaignsResponse and nil error while calling GetAvailableCampaigns. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignResponse and nil error while calling GetCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignResponse and nil error while calling GetCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaigns(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetCampaignsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaigns")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaigns(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignsResponse and nil error while calling GetCampaigns. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaignsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaigns")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaigns(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignsResponse and nil error while calling GetCampaigns. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaignsByIds(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignsByIdsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignsByIdsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetCampaignsByIdsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsByIds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignsByIdsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignsByIdsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaignsByIds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignsByIdsResponse and nil error while calling GetCampaignsByIds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaignsByIdsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignsByIds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignsByIdsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignsByIdsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaignsByIds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignsByIdsResponse and nil error while calling GetCampaignsByIds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaignUploadConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignUploadConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignUploadConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetCampaignUploadConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignUploadConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignUploadConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignUploadConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaignUploadConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignUploadConfigResponse and nil error while calling GetCampaignUploadConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaignUploadConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignUploadConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignUploadConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignUploadConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaignUploadConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignUploadConfigResponse and nil error while calling GetCampaignUploadConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaignReporting(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCampaignReportingJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCampaignReportingProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetCampaignReportingJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignReporting")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCampaignReportingRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignReportingResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaignReporting(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignReportingResponse and nil error while calling GetCampaignReporting. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetCampaignReportingProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCampaignReporting")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetCampaignReportingRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetCampaignReportingResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetCampaignReporting(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCampaignReportingResponse and nil error while calling GetCampaignReporting. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetTargetingReach(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTargetingReachJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTargetingReachProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetTargetingReachJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetingReach")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTargetingReachRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTargetingReachResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetTargetingReach(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTargetingReachResponse and nil error while calling GetTargetingReach. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetTargetingReachProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetingReach")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTargetingReachRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTargetingReachResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetTargetingReach(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTargetingReachResponse and nil error while calling GetTargetingReach. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveCreateCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveCreateCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.CreateCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCampaignResponse and nil error while calling CreateCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveCreateCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.CreateCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateCampaignResponse and nil error while calling CreateCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveUpdateCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveUpdateCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.UpdateCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCampaignResponse and nil error while calling UpdateCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveUpdateCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.UpdateCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateCampaignResponse and nil error while calling UpdateCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveUpdateCampaignBalance(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateCampaignBalanceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateCampaignBalanceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveUpdateCampaignBalanceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaignBalance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateCampaignBalanceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.UpdateCampaignBalance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling UpdateCampaignBalance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveUpdateCampaignBalanceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateCampaignBalance")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateCampaignBalanceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.UpdateCampaignBalance(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling UpdateCampaignBalance. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveApproveCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveApproveCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveApproveCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveApproveCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ApproveCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ApproveCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ApproveCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.ApproveCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ApproveCampaignResponse and nil error while calling ApproveCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveApproveCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ApproveCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ApproveCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ApproveCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.ApproveCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ApproveCampaignResponse and nil error while calling ApproveCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveRefreshCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRefreshCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRefreshCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveRefreshCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefreshCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RefreshCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefreshCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.RefreshCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefreshCampaignResponse and nil error while calling RefreshCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveRefreshCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefreshCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RefreshCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefreshCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.RefreshCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefreshCampaignResponse and nil error while calling RefreshCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveIngestCampaignKeys(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveIngestCampaignKeysJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveIngestCampaignKeysProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveIngestCampaignKeysJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IngestCampaignKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(IngestCampaignKeysRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IngestCampaignKeysResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.IngestCampaignKeys(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IngestCampaignKeysResponse and nil error while calling IngestCampaignKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveIngestCampaignKeysProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "IngestCampaignKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(IngestCampaignKeysRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *IngestCampaignKeysResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.IngestCampaignKeys(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *IngestCampaignKeysResponse and nil error while calling IngestCampaignKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveInternalDeleteCampaign(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInternalDeleteCampaignJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInternalDeleteCampaignProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveInternalDeleteCampaignJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalDeleteCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InternalDeleteCampaignRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *InternalDeleteCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.InternalDeleteCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalDeleteCampaignResponse and nil error while calling InternalDeleteCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveInternalDeleteCampaignProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InternalDeleteCampaign")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(InternalDeleteCampaignRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *InternalDeleteCampaignResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.InternalDeleteCampaign(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InternalDeleteCampaignResponse and nil error while calling InternalDeleteCampaign. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveHandleBountyEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHandleBountyEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHandleBountyEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveHandleBountyEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandleBountyEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HandleBountyEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HandleBountyEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.HandleBountyEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HandleBountyEventResponse and nil error while calling HandleBountyEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveHandleBountyEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandleBountyEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HandleBountyEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *HandleBountyEventResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.HandleBountyEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *HandleBountyEventResponse and nil error while calling HandleBountyEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetBountyBoardGames(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBountyBoardGamesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBountyBoardGamesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jabbaServer) serveGetBountyBoardGamesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyBoardGames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBountyBoardGamesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountyBoardGamesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetBountyBoardGames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountyBoardGamesResponse and nil error while calling GetBountyBoardGames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) serveGetBountyBoardGamesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyBoardGames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBountyBoardGamesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountyBoardGamesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Jabba.GetBountyBoardGames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountyBoardGamesResponse and nil error while calling GetBountyBoardGames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jabbaServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *jabbaServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *jabbaServer) PathPrefix() string {
	return JabbaPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 3588 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x3a, 0xdb, 0x72, 0x1b, 0x47,
	0x76, 0x02, 0x40, 0xf0, 0x72, 0x48, 0x51, 0x60, 0x93, 0x22, 0x47, 0x90, 0x2c, 0xd3, 0xb3, 0x5a,
	0x2d, 0xc5, 0xb5, 0x29, 0x59, 0xb6, 0xd7, 0x5a, 0x67, 0xb3, 0x15, 0xdc, 0x96, 0x0b, 0x0b, 0x24,
	0x91, 0x01, 0x48, 0xdb, 0x9b, 0x0b, 0xd3, 0xc0, 0x34, 0xa1, 0x31, 0x07, 0x33, 0xc8, 0x4c, 0x43,
	0x22, 0x92, 0xca, 0xa6, 0x52, 0xe5, 0xca, 0x53, 0x1e, 0xf2, 0x94, 0xa4, 0x2a, 0x5b, 0x9b, 0x4a,
	0xfe, 0x21, 0x1f, 0x93, 0x87, 0xfc, 0x41, 0xf2, 0x0f, 0x5b, 0x7d, 0x19, 0xcc, 0xad, 0x87, 0x00,
	0x25, 0x3f, 0xf8, 0x6d, 0xfa, 0x5c, 0xfa, 0x9c, 0x3e, 0x97, 0xee, 0xd3, 0xa7, 0x07, 0x60, 0x88,
	0x2d, 0xe7, 0x60, 0xe4, 0xb9, 0xd4, 0x45, 0x9b, 0xf4, 0x8d, 0x45, 0xfb, 0xaf, 0x0e, 0x7a, 0xee,
	0xd8, 0xa1, 0x93, 0x83, 0x9e, 0x8b, 0x3d, 0xb3, 0xfc, 0xfe, 0xc0, 0x75, 0x07, 0x36, 0x79, 0xca,
	0x49, 0x7a, 0xe3, 0x8b, 0xa7, 0xd4, 0x1a, 0x12, 0x9f, 0xe2, 0xe1, 0x48, 0x70, 0x95, 0xef, 0x27,
	0x09, 0xc8, 0x70, 0x44, 0x27, 0x02, 0xa9, 0x7f, 0x97, 0x83, 0x62, 0xd5, 0xc3, 0x8e, 0x89, 0xd6,
	0x21, 0x6f, 0x99, 0x5a, 0x6e, 0x37, 0xb7, 0xb7, 0x62, 0xe4, 0x2d, 0x13, 0x21, 0x58, 0x70, 0xf0,
	0x90, 0x68, 0x79, 0x0e, 0xe1, 0xdf, 0xe8, 0x09, 0x94, 0xb0, 0x69, 0x5a, 0xd4, 0x72, 0x1d, 0x6c,
	0x9f, 0x0f, 0xf0, 0x90, 0xf8, 0x5a, 0x61, 0xb7, 0xb0, 0xb7, 0x62, 0xdc, 0x09, 0xe1, 0x87, 0x0c,
	0x8c, 0x3e, 0x84, 0x0d, 0xcb, 0xaf, 0xd8, 0xb6, 0xfb, 0x86, 0x98, 0x15, 0x5b, 0x00, 0xb5, 0x85,
	0xdd, 0xdc, 0xde, 0xb2, 0x91, 0x46, 0xe8, 0xff, 0x9b, 0x87, 0xb5, 0x1a, 0x1e, 0x8e, 0xb0, 0x35,
	0x70, 0xba, 0xd8, 0xbf, 0x44, 0x7f, 0x02, 0xf7, 0x7b, 0x9e, 0x8b, 0xcd, 0x3e, 0xf6, 0x29, 0xf1,
	0xda, 0x78, 0xe2, 0x8e, 0xe9, 0xd1, 0xd8, 0xa6, 0xd6, 0xc8, 0xb6, 0x88, 0xc7, 0xd5, 0xcc, 0x1b,
	0xd7, 0x91, 0xa0, 0xe7, 0xb0, 0x35, 0xe2, 0xb0, 0x1a, 0x71, 0xa8, 0xdf, 0x26, 0xde, 0x99, 0x45,
	0xde, 0x10, 0x8f, 0xaf, 0x27, 0x6f, 0x28, 0x71, 0xa8, 0x0a, 0xab, 0x02, 0x7e, 0xe4, 0x9a, 0xc4,
	0xd6, 0x0a, 0xbb, 0xb9, 0xbd, 0xf5, 0xe7, 0xbb, 0x07, 0x0a, 0xb3, 0x1f, 0xb4, 0x43, 0x3a, 0x23,
	0xca, 0x84, 0x74, 0x58, 0x13, 0x43, 0x03, 0x53, 0xd2, 0x34, 0xf9, 0x9a, 0x57, 0x8c, 0x18, 0x0c,
	0x7d, 0x0a, 0x9b, 0x3e, 0xf5, 0x08, 0x1e, 0xb6, 0x88, 0x33, 0xa0, 0xaf, 0x8e, 0x2c, 0x67, 0x4c,
	0x89, 0xaf, 0x15, 0x77, 0x73, 0x7b, 0xc5, 0x6a, 0x5e, 0xcb, 0x19, 0x2a, 0x34, 0xfa, 0x39, 0x2c,
	0xd0, 0xc9, 0x88, 0x68, 0x8b, 0x5c, 0xad, 0x1f, 0x2b, 0xd5, 0x8a, 0x1a, 0xb1, 0x3b, 0x19, 0x11,
	0x83, 0xb3, 0xe8, 0xff, 0xbf, 0x09, 0xcb, 0x01, 0x2a, 0xe5, 0xe9, 0x2d, 0x28, 0x52, 0x8b, 0xda,
	0x81, 0xab, 0xc5, 0x00, 0x3d, 0x83, 0x62, 0x8f, 0x05, 0x06, 0xb7, 0xc2, 0xea, 0xf3, 0xb2, 0x52,
	0x1c, 0x0f, 0x1d, 0x43, 0x10, 0xa2, 0x03, 0x40, 0x11, 0x87, 0x1c, 0x11, 0xdf, 0xc7, 0x03, 0x22,
	0xd7, 0xaf, 0xc0, 0xa0, 0x07, 0xb0, 0xd2, 0x77, 0x1d, 0x4a, 0x1c, 0xda, 0x34, 0xf9, 0xda, 0x57,
	0x8c, 0x10, 0x80, 0x76, 0x61, 0x55, 0x0e, 0x8e, 0x59, 0x18, 0x2e, 0x72, 0x7c, 0x14, 0x84, 0xf6,
	0xa1, 0x44, 0x5d, 0x8a, 0xed, 0xea, 0xd8, 0x1c, 0x10, 0xe1, 0x4a, 0x6d, 0x69, 0x37, 0xb7, 0x57,
	0x30, 0x52, 0x70, 0x46, 0xeb, 0x8f, 0x88, 0x43, 0xa3, 0xb4, 0xcb, 0x82, 0x36, 0x09, 0x67, 0xeb,
	0xc0, 0xaf, 0xb1, 0x65, 0xe3, 0x9e, 0x4d, 0xda, 0x36, 0xa6, 0x17, 0xae, 0x37, 0xf4, 0xb5, 0x15,
	0x1e, 0xe7, 0x0a, 0x0c, 0xfa, 0x14, 0x96, 0x7c, 0x8a, 0x3d, 0x5a, 0xa1, 0x1a, 0x48, 0x5b, 0x89,
	0x94, 0x3b, 0x08, 0x52, 0xee, 0xa0, 0x1b, 0xe4, 0xa4, 0x11, 0x90, 0x32, 0xfb, 0x12, 0xc7, 0xac,
	0x50, 0x6d, 0x75, 0x26, 0x8f, 0x20, 0x44, 0x9f, 0xc0, 0xa2, 0x4f, 0x31, 0x1d, 0xfb, 0xda, 0x1a,
	0x8f, 0x80, 0xfb, 0x4a, 0x97, 0x74, 0x38, 0x89, 0x21, 0x49, 0xd9, 0xc2, 0x05, 0x5a, 0xc4, 0x52,
	0x1d, 0x4f, 0x7c, 0xed, 0x36, 0x8b, 0x33, 0x23, 0x05, 0x47, 0x7b, 0x70, 0xc7, 0x23, 0xdf, 0x92,
	0x3e, 0xcb, 0x63, 0x83, 0x60, 0xdf, 0x75, 0xb4, 0x75, 0x6e, 0xf6, 0x24, 0x98, 0xcf, 0x6a, 0xe3,
	0xfe, 0xa5, 0x6d, 0xf9, 0x94, 0x98, 0xa7, 0x3e, 0xf1, 0x7c, 0xed, 0x0e, 0x37, 0x50, 0x0a, 0x8e,
	0x3e, 0x85, 0xbb, 0x94, 0x78, 0x43, 0xbf, 0xe2, 0x98, 0x35, 0xd7, 0x11, 0xbb, 0x84, 0x7f, 0xea,
	0xd9, 0x5a, 0x89, 0xcf, 0xad, 0x46, 0xa2, 0xcf, 0xa1, 0x48, 0xb1, 0x7f, 0xe9, 0x6b, 0x1b, 0xbb,
	0x85, 0xbd, 0xd5, 0xe7, 0x1f, 0xcc, 0x8c, 0x76, 0x43, 0xd0, 0xa3, 0x5f, 0xc0, 0xaa, 0x8d, 0x7d,
	0x7a, 0x3a, 0x32, 0x31, 0x25, 0xa6, 0x86, 0x66, 0x5a, 0x37, 0x4a, 0x8e, 0x1e, 0xc1, 0x6d, 0x8a,
	0xbd, 0x01, 0xa1, 0xc4, 0x14, 0x5b, 0xd6, 0x26, 0x5f, 0x55, 0x1c, 0xc8, 0x97, 0xc4, 0x01, 0x15,
	0xdb, 0xae, 0x86, 0x81, 0xed, 0x6b, 0x5b, 0x7c, 0x83, 0x53, 0x23, 0xd1, 0x2f, 0xe0, 0x9e, 0x40,
	0x9c, 0x61, 0xcf, 0x22, 0x74, 0x12, 0xe3, 0xbc, 0xcb, 0x39, 0xb3, 0x09, 0xd8, 0xde, 0x64, 0x5a,
	0xfe, 0xc8, 0xc6, 0x93, 0xa6, 0x73, 0xe1, 0x6a, 0xdb, 0x7c, 0x5d, 0xea, 0xbd, 0xa9, 0x1e, 0xd2,
	0x19, 0x51, 0x26, 0xf4, 0x2c, 0xbe, 0xef, 0x74, 0x48, 0xdf, 0x75, 0x4c, 0x5f, 0xdb, 0xe1, 0x89,
	0xa0, 0x42, 0xa1, 0x87, 0xb0, 0xfc, 0xda, 0x32, 0x89, 0x7b, 0x6a, 0xb4, 0x34, 0x8d, 0xf9, 0x8b,
	0x6f, 0x4f, 0x53, 0x18, 0xaa, 0xc0, 0x22, 0xff, 0xf6, 0xb5, 0x7b, 0xdc, 0x4f, 0x4f, 0xae, 0xf5,
	0xd3, 0xc1, 0x19, 0xa7, 0x6d, 0x38, 0xd4, 0x9b, 0x18, 0x92, 0x91, 0x9d, 0x14, 0x81, 0x75, 0x6b,
	0x8c, 0xc9, 0xb3, 0x88, 0xaf, 0x95, 0xb9, 0xd9, 0xd3, 0x08, 0x96, 0x9c, 0x53, 0xeb, 0x86, 0xe4,
	0xf7, 0xb9, 0xf5, 0x14, 0x18, 0xf4, 0x18, 0xd6, 0xa7, 0x50, 0xe1, 0xd1, 0x07, 0x9c, 0x36, 0x01,
	0x45, 0x04, 0xd0, 0x25, 0x99, 0x04, 0x49, 0x6d, 0x90, 0x01, 0x0b, 0x44, 0xed, 0x3d, 0xbe, 0xa8,
	0xcf, 0xae, 0x5f, 0xd4, 0xcb, 0x14, 0x9f, 0x58, 0xa0, 0x62, 0x42, 0x16, 0x5f, 0x98, 0x9d, 0x7d,
	0x53, 0x6d, 0x1e, 0x72, 0x6d, 0xe2, 0x40, 0x76, 0x86, 0x60, 0x71, 0x42, 0x0a, 0xa2, 0xf7, 0xb9,
	0x35, 0x62, 0x30, 0x16, 0x0f, 0x97, 0x64, 0x72, 0x44, 0x28, 0x36, 0x31, 0xc5, 0xda, 0xee, 0x35,
	0xf1, 0xf0, 0x32, 0xa4, 0x33, 0xa2, 0x4c, 0xe8, 0x0c, 0x6e, 0xf7, 0xb1, 0x6d, 0xfb, 0x5d, 0xb7,
	0xc2, 0xb3, 0x5b, 0xfb, 0x80, 0xaf, 0xf7, 0xd9, 0xf5, 0xeb, 0xad, 0x45, 0x59, 0xc4, 0x52, 0xe3,
	0xd3, 0xa0, 0xbf, 0x80, 0x2d, 0x06, 0x08, 0xc6, 0x53, 0x25, 0x75, 0xae, 0x64, 0x56, 0x8c, 0xa4,
	0x19, 0x0c, 0xe5, 0x34, 0x6c, 0xf7, 0x79, 0xf3, 0xca, 0xa2, 0x24, 0xba, 0xfb, 0xfc, 0x48, 0xec,
	0x3e, 0x49, 0x38, 0x4f, 0x55, 0x76, 0x18, 0x7c, 0x95, 0x64, 0x78, 0xc4, 0x83, 0x5e, 0x8d, 0x9c,
	0x72, 0x55, 0x93, 0x9b, 0xdc, 0x8f, 0x23, 0x5c, 0x49, 0x24, 0x8b, 0xe4, 0x91, 0xe7, 0x0e, 0x5d,
	0x6e, 0x17, 0xdb, 0x1a, 0x58, 0x3d, 0x9b, 0x68, 0x8f, 0x45, 0xcd, 0x93, 0x42, 0xa0, 0x2a, 0x3c,
	0x10, 0x31, 0xd8, 0x0e, 0x50, 0xd8, 0xe6, 0xf9, 0x51, 0xb3, 0xad, 0xfe, 0xa5, 0xaf, 0xfd, 0x84,
	0x8b, 0xba, 0x96, 0x86, 0x15, 0x39, 0xd3, 0x03, 0x29, 0x7a, 0xb4, 0xed, 0x71, 0x5e, 0x25, 0x0e,
	0x75, 0x60, 0xcd, 0x23, 0x3e, 0xf5, 0x2c, 0x6e, 0x54, 0x5f, 0x7b, 0xc2, 0x7d, 0xfe, 0xf4, 0x7a,
	0x9f, 0x1b, 0x11, 0x0e, 0xe1, 0xf2, 0xd8, 0x24, 0xe5, 0x53, 0x58, 0x8d, 0xe4, 0x36, 0x2a, 0x41,
	0xe1, 0x92, 0x4c, 0x64, 0x8d, 0xc1, 0x3e, 0xd9, 0x71, 0xf7, 0x1a, 0xdb, 0x63, 0x51, 0x64, 0x64,
	0x95, 0x13, 0x7c, 0x0a, 0x43, 0x10, 0x7e, 0x91, 0x7f, 0x91, 0x2b, 0x5f, 0xc0, 0x4e, 0x46, 0x76,
	0x29, 0x44, 0x7c, 0x16, 0x17, 0xf1, 0x7e, 0xc6, 0xf1, 0xe8, 0x59, 0xce, 0xa0, 0x65, 0xf9, 0x34,
	0x2a, 0xa7, 0x0f, 0x28, 0x1d, 0xd5, 0x0a, 0x11, 0x9f, 0xc7, 0x45, 0x7c, 0x30, 0x33, 0x92, 0xa3,
	0x42, 0x2c, 0xd8, 0x48, 0x99, 0x51, 0x21, 0xe3, 0x97, 0x71, 0x19, 0x7b, 0xd7, 0x3a, 0x26, 0x32,
	0x61, 0x44, 0x94, 0x6e, 0xc3, 0x96, 0x2a, 0x9f, 0x58, 0xc9, 0x75, 0xe1, 0x91, 0xbf, 0x1e, 0x13,
	0xa7, 0x2f, 0x64, 0x16, 0x8c, 0x10, 0x80, 0xca, 0xb0, 0xdc, 0x77, 0x5d, 0xdb, 0x74, 0xdf, 0x38,
	0x5c, 0x78, 0xc1, 0x98, 0x8e, 0x19, 0xce, 0x1c, 0x7b, 0x98, 0xef, 0x12, 0x05, 0x81, 0x0b, 0xc6,
	0xfa, 0x3f, 0x17, 0x60, 0xbb, 0x8e, 0x2d, 0x7b, 0x12, 0x6a, 0x35, 0x72, 0x3d, 0x6a, 0x39, 0x83,
	0x68, 0x6d, 0x94, 0x7b, 0x8b, 0xda, 0x28, 0x3f, 0x6f, 0x6d, 0xb4, 0x07, 0x77, 0xfa, 0xee, 0x70,
	0x64, 0xb3, 0xc3, 0xa2, 0xca, 0x0d, 0x25, 0xb5, 0x4c, 0x82, 0xd9, 0xde, 0xca, 0xb3, 0x57, 0x94,
	0xfc, 0xe2, 0x4e, 0x52, 0x30, 0x62, 0x30, 0x7e, 0x24, 0xbd, 0x71, 0x65, 0xdd, 0x1d, 0x10, 0x16,
	0x39, 0x61, 0x1a, 0xc1, 0xf6, 0xf4, 0x21, 0x87, 0x7c, 0x85, 0x69, 0xff, 0x15, 0x31, 0x79, 0xad,
	0x5a, 0x30, 0xe2, 0x40, 0x96, 0xaa, 0xf4, 0x95, 0xe5, 0xd1, 0x89, 0x3c, 0x5a, 0x83, 0x69, 0x45,
	0xc5, 0xaa, 0xc4, 0xa1, 0x17, 0xb0, 0x13, 0xdd, 0x00, 0x5b, 0x96, 0x73, 0xc9, 0x13, 0x9f, 0x98,
	0xb2, 0x78, 0xcd, 0x42, 0xeb, 0xbf, 0x5b, 0x80, 0x8d, 0xb4, 0x37, 0x3e, 0x84, 0x8d, 0x48, 0x1d,
	0xce, 0xa5, 0x98, 0x32, 0x0c, 0xd2, 0x08, 0x56, 0x2d, 0x44, 0x80, 0x8d, 0xab, 0x11, 0x76, 0x4c,
	0x62, 0xca, 0xc8, 0x50, 0xa1, 0x12, 0x37, 0x80, 0x9a, 0x8d, 0xad, 0x21, 0x31, 0xa5, 0x23, 0x14,
	0x18, 0x66, 0x93, 0x28, 0x34, 0xf0, 0x94, 0xf4, 0x89, 0x12, 0xa7, 0xac, 0xfa, 0x8b, 0x19, 0x55,
	0xff, 0x01, 0xa0, 0xbe, 0x10, 0x15, 0xa5, 0x16, 0xee, 0x51, 0x60, 0x94, 0xb7, 0x84, 0xa5, 0x8c,
	0x5b, 0x42, 0x13, 0x56, 0x4c, 0x16, 0xf3, 0x75, 0x76, 0xb0, 0x2d, 0xf3, 0x3d, 0xf4, 0xa7, 0xea,
	0x6a, 0x4c, 0x99, 0x19, 0x46, 0xc8, 0x7d, 0x9d, 0x9b, 0x57, 0xae, 0x75, 0x33, 0xfa, 0x19, 0x6c,
	0x27, 0x51, 0xd2, 0xab, 0xc0, 0x19, 0x33, 0xb0, 0xfa, 0xbf, 0xe5, 0x61, 0xbd, 0xcb, 0x0f, 0x16,
	0xa6, 0x0a, 0xc1, 0xfd, 0x57, 0x09, 0xdf, 0xb5, 0x5d, 0xd7, 0x3e, 0xb2, 0x1c, 0x19, 0x1c, 0x0a,
	0x8c, 0x8a, 0x1e, 0x5f, 0xc9, 0xe0, 0x50, 0x60, 0x58, 0x96, 0xbc, 0xe6, 0x61, 0x1d, 0x4c, 0x2d,
	0xc2, 0x22, 0x0e, 0x4c, 0x50, 0xe1, 0x2b, 0x19, 0x0a, 0x71, 0x20, 0x8b, 0x63, 0x91, 0x5c, 0xbe,
	0xcc, 0x2e, 0x36, 0x9f, 0xcc, 0xcf, 0x14, 0x42, 0x41, 0x8d, 0xaf, 0x64, 0x10, 0xa4, 0x11, 0xba,
	0x05, 0xab, 0x91, 0xfa, 0x99, 0x5d, 0x43, 0x65, 0x05, 0xcd, 0xaf, 0xa1, 0x62, 0x9f, 0x8e, 0x82,
	0xd8, 0x9e, 0xda, 0x73, 0xaf, 0x2a, 0x1e, 0x65, 0x35, 0xb2, 0xb8, 0x42, 0x87, 0x00, 0xb1, 0xa7,
	0xbe, 0x26, 0x1e, 0x43, 0x16, 0x38, 0x72, 0x3a, 0xd6, 0xff, 0x33, 0x07, 0xb7, 0xbb, 0x1e, 0xee,
	0x5f, 0x5a, 0xce, 0xa0, 0x6d, 0x5d, 0x11, 0x1b, 0x7d, 0x21, 0xaf, 0xf8, 0x39, 0x7e, 0xc1, 0x7b,
	0xac, 0x8c, 0xa7, 0x18, 0x47, 0x78, 0xc7, 0x47, 0x0f, 0x01, 0xfa, 0x32, 0xca, 0x9a, 0xa6, 0x54,
	0x24, 0x02, 0x61, 0xd7, 0xfc, 0x11, 0x63, 0x91, 0x6a, 0x88, 0x01, 0xe3, 0xa2, 0xd6, 0x90, 0x9c,
	0x5c, 0x5c, 0xf8, 0x84, 0x72, 0x6b, 0x17, 0x8d, 0x08, 0x44, 0x7f, 0x0a, 0x45, 0x7e, 0x2a, 0xb3,
	0x83, 0x6a, 0xec, 0xd9, 0xc1, 0x41, 0x35, 0xf6, 0x6c, 0x75, 0xdf, 0x40, 0xdf, 0x05, 0x08, 0xcf,
	0x58, 0x84, 0x60, 0x81, 0x55, 0x48, 0x5a, 0x8e, 0x97, 0x67, 0xfc, 0x5b, 0xff, 0x19, 0xac, 0x45,
	0x0f, 0xa7, 0x70, 0x9e, 0x5c, 0xb4, 0xff, 0x20, 0xe5, 0xe5, 0xa7, 0xf2, 0xf4, 0x06, 0x6c, 0x2a,
	0x8e, 0x3d, 0xb4, 0x0d, 0x8b, 0x43, 0xcb, 0xa9, 0xd5, 0x4e, 0x65, 0xb0, 0xca, 0x11, 0x87, 0xe3,
	0x2b, 0x06, 0xcf, 0x4b, 0x38, 0x1f, 0xe9, 0x4f, 0x60, 0xe7, 0x90, 0x50, 0xde, 0xb9, 0xe8, 0x10,
	0xca, 0x12, 0xc0, 0x37, 0xd8, 0x09, 0xe8, 0xd3, 0x64, 0x67, 0x44, 0x6f, 0x81, 0x96, 0x26, 0xf5,
	0x47, 0xae, 0xe3, 0x47, 0xfa, 0x23, 0xb9, 0x39, 0xfb, 0x23, 0xfa, 0x4b, 0xd8, 0xe9, 0x64, 0x08,
	0xbe, 0xf9, 0x64, 0x2d, 0xd0, 0x3a, 0xdf, 0x9f, 0x6a, 0x6d, 0x78, 0x70, 0x48, 0x68, 0x25, 0x28,
	0x17, 0x03, 0x33, 0x47, 0xf4, 0xdb, 0xb4, 0x9c, 0xbe, 0x3d, 0x36, 0xc9, 0xaf, 0xc6, 0xb6, 0xcd,
	0xaa, 0xdd, 0x96, 0xf0, 0x2a, 0xab, 0x6d, 0x55, 0x28, 0xfd, 0xcf, 0xe1, 0xbd, 0x8c, 0x19, 0xa5,
	0x92, 0x7f, 0x04, 0x2b, 0x41, 0x70, 0xfa, 0x3c, 0x3c, 0x56, 0x9f, 0xbf, 0x77, 0x7d, 0xa9, 0x13,
	0xd2, 0xeb, 0xff, 0x94, 0x03, 0x74, 0x48, 0x68, 0x18, 0x0e, 0x42, 0xcd, 0x78, 0x0a, 0xe4, 0x52,
	0x29, 0xa0, 0xc1, 0x12, 0x5f, 0xef, 0x34, 0x3f, 0x82, 0x21, 0x0b, 0x96, 0xb1, 0x4f, 0xbc, 0xa6,
	0x29, 0xb3, 0x43, 0x8e, 0xd8, 0x7e, 0x74, 0x11, 0x59, 0x56, 0xd0, 0xc2, 0x8c, 0x03, 0xf5, 0xdf,
	0xe5, 0x60, 0x33, 0xa6, 0x8e, 0x5c, 0xe3, 0xcf, 0x61, 0x39, 0x90, 0x2e, 0x7d, 0x31, 0x63, 0x89,
	0x53, 0x72, 0xf4, 0x25, 0xac, 0xd3, 0x68, 0xa2, 0xfb, 0x5a, 0x9e, 0xdb, 0x48, 0x9f, 0xbd, 0x27,
	0x18, 0x09, 0x4e, 0xfd, 0xbf, 0xe2, 0xea, 0x4d, 0xbd, 0x1a, 0x31, 0x47, 0x2e, 0x6e, 0x8e, 0xb0,
	0xd5, 0x94, 0x9f, 0xbf, 0xd5, 0xf4, 0x6e, 0x36, 0xec, 0xc0, 0x56, 0x5c, 0xc7, 0xef, 0x23, 0x4e,
	0x7a, 0x3c, 0x81, 0xa7, 0x93, 0x56, 0x27, 0x4d, 0x73, 0xba, 0xfa, 0x5d, 0x58, 0x0d, 0x43, 0xc3,
	0x97, 0x3b, 0x54, 0x14, 0x94, 0x56, 0x3c, 0xaf, 0x52, 0xfc, 0x6b, 0xb8, 0xa7, 0x90, 0xf1, 0x7d,
	0x68, 0xef, 0xc2, 0xc3, 0xc8, 0xcc, 0xa7, 0x23, 0xdb, 0xc5, 0x66, 0xcd, 0x75, 0x2e, 0xac, 0xc1,
	0x3c, 0x1e, 0x14, 0x27, 0x89, 0xf0, 0x9f, 0xfa, 0x2e, 0x24, 0x66, 0x8c, 0xb4, 0x89, 0xc7, 0xf0,
	0x7e, 0xa6, 0x40, 0xb9, 0xa0, 0x32, 0x2c, 0x8f, 0x39, 0x7c, 0x2a, 0x72, 0x3a, 0x66, 0x27, 0xa1,
	0xf8, 0x3e, 0x9d, 0x6e, 0xdc, 0x21, 0x80, 0xe9, 0x6a, 0x0d, 0xf1, 0x80, 0x4c, 0xe3, 0x23, 0x18,
	0xea, 0x7f, 0x0c, 0xf7, 0x63, 0xd9, 0x13, 0x94, 0x48, 0xf3, 0x65, 0xb5, 0x4e, 0xf9, 0xe6, 0xa5,
	0x60, 0x97, 0x2a, 0x77, 0x61, 0xa3, 0x9f, 0x44, 0xca, 0x74, 0x7c, 0x3c, 0xe3, 0x72, 0x15, 0x4c,
	0x95, 0x9e, 0x40, 0xff, 0xc7, 0x02, 0x8f, 0xad, 0x78, 0x15, 0x35, 0xdb, 0x2f, 0xa9, 0x06, 0x63,
	0xfe, 0x46, 0x0d, 0xc6, 0xc2, 0x5b, 0x37, 0x18, 0x17, 0x66, 0x35, 0x18, 0x33, 0x9a, 0x83, 0xc5,
	0xec, 0xe6, 0xa0, 0xb2, 0x73, 0xb7, 0x78, 0xb3, 0xce, 0xdd, 0xd2, 0x0d, 0x3a, 0x77, 0xcb, 0xaa,
	0xce, 0x9d, 0xfe, 0x8a, 0xe7, 0x5f, 0xd2, 0x0f, 0xd2, 0xf7, 0x2f, 0x83, 0x49, 0x02, 0x8c, 0x74,
	0xfc, 0x8f, 0xd4, 0xdb, 0x68, 0x7c, 0x92, 0x04, 0xab, 0xfe, 0xfb, 0x1c, 0xdc, 0xad, 0x79, 0x04,
	0x53, 0x92, 0x3c, 0x78, 0x7e, 0x20, 0x1b, 0xfd, 0x7f, 0xe4, 0x60, 0x3b, 0xa9, 0xe0, 0x0f, 0xeb,
	0x28, 0xfa, 0xbf, 0x05, 0xb8, 0x2b, 0x7a, 0xed, 0x37, 0x3d, 0xbb, 0xdf, 0xea, 0x48, 0x52, 0xbc,
	0x68, 0x14, 0x32, 0x5f, 0x34, 0x52, 0x3d, 0xc5, 0x85, 0xec, 0x9e, 0x62, 0x8f, 0xdf, 0x04, 0x2b,
	0xe6, 0xb7, 0x63, 0x9f, 0x0e, 0x89, 0x13, 0xbb, 0x87, 0xaa, 0x91, 0x8c, 0x8b, 0x15, 0xfe, 0xfe,
	0xb8, 0xe7, 0xf7, 0x3d, 0x6b, 0xc4, 0x64, 0x47, 0xef, 0xa3, 0x6a, 0x24, 0xdb, 0x53, 0x79, 0x57,
	0xa4, 0x8e, 0x29, 0x91, 0x77, 0xd1, 0x10, 0xc0, 0xf6, 0x19, 0xe2, 0x98, 0x1c, 0x27, 0x1a, 0x02,
	0xc1, 0x90, 0x61, 0xb8, 0xe7, 0x5d, 0x8f, 0xdf, 0x21, 0x57, 0x8c, 0x60, 0x88, 0xbe, 0x80, 0xed,
	0x1e, 0xb6, 0xb1, 0xd3, 0x27, 0x49, 0xf5, 0xf9, 0x9d, 0x91, 0x37, 0xf8, 0x33, 0x28, 0xd0, 0xb7,
	0xb0, 0x93, 0xc2, 0x48, 0xbb, 0xae, 0x72, 0xaf, 0x7c, 0xa8, 0xae, 0x35, 0xd5, 0x3c, 0x5c, 0x54,
	0xd6, 0x84, 0x33, 0xfb, 0xa3, 0x6b, 0xb3, 0xfb, 0xa3, 0xfa, 0xdf, 0xc3, 0x76, 0x32, 0xda, 0xde,
	0x3d, 0x1f, 0x54, 0xa1, 0x92, 0x57, 0x87, 0x8a, 0xfe, 0x2f, 0x79, 0x78, 0x10, 0xd7, 0x40, 0xda,
	0x62, 0xde, 0xb0, 0x67, 0xd7, 0x6c, 0xc1, 0x21, 0xa7, 0xe1, 0x9e, 0x0a, 0xae, 0xd9, 0x29, 0x0c,
	0xfa, 0x15, 0xc0, 0x98, 0x0f, 0xd9, 0xb1, 0x2e, 0x5f, 0xb0, 0x1f, 0x5f, 0xe7, 0x94, 0xd3, 0x29,
	0xb5, 0x11, 0xe1, 0x44, 0x7f, 0x09, 0x9b, 0xb1, 0xd9, 0xa5, 0x97, 0x17, 0x6e, 0xee, 0x65, 0x43,
	0x35, 0x91, 0xfe, 0x5b, 0xd8, 0xae, 0x8c, 0x46, 0x9e, 0xfb, 0xfa, 0xc6, 0x1b, 0x41, 0xf2, 0x81,
	0x3d, 0xaf, 0x78, 0x60, 0xdf, 0x0d, 0x1e, 0xf2, 0x85, 0xb9, 0x0a, 0xfc, 0xcd, 0x3f, 0x0a, 0xd2,
	0xbb, 0xb0, 0x93, 0x92, 0xff, 0xce, 0xa1, 0xa1, 0xbf, 0x80, 0x6d, 0x83, 0x5c, 0x78, 0xc4, 0x7f,
	0x75, 0xc3, 0x55, 0x31, 0x7d, 0x52, 0x9c, 0xef, 0xae, 0xcf, 0x7f, 0xe7, 0xe0, 0xbd, 0xa6, 0x43,
	0x89, 0xe7, 0x60, 0xbb, 0x4e, 0x6c, 0x42, 0xdf, 0xc6, 0xda, 0x26, 0x67, 0x14, 0xbd, 0x2f, 0x59,
	0x02, 0xc7, 0x60, 0xac, 0xa6, 0xf1, 0xa9, 0x3b, 0x6a, 0x59, 0x17, 0xa4, 0x3f, 0xe9, 0xdb, 0x44,
	0x56, 0x29, 0x71, 0x20, 0x4b, 0x1b, 0xc9, 0xe5, 0xba, 0x97, 0x97, 0x84, 0x8c, 0x88, 0x27, 0x8b,
	0x92, 0x14, 0x5c, 0xff, 0x33, 0x78, 0x98, 0xa5, 0xf6, 0xbb, 0x1b, 0xc5, 0x83, 0x7b, 0x4d, 0x67,
	0x40, 0xfc, 0x69, 0xc9, 0xf8, 0x92, 0x4c, 0xfc, 0x79, 0xed, 0xf1, 0x19, 0x2c, 0x5d, 0x92, 0x49,
	0x87, 0xd0, 0xe0, 0x14, 0xbc, 0x9f, 0xf5, 0xe4, 0xd6, 0x21, 0xd4, 0x08, 0x68, 0xf5, 0xef, 0x72,
	0xb0, 0x28, 0x60, 0x68, 0x0b, 0x8a, 0x7d, 0xd7, 0x24, 0xc1, 0x8d, 0x43, 0x0c, 0x58, 0x5d, 0x3d,
	0x92, 0xcf, 0x1c, 0x32, 0xa2, 0xa7, 0x63, 0x1e, 0xcd, 0x9e, 0x6b, 0x8e, 0xfb, 0x74, 0x9a, 0xd4,
	0x2b, 0x46, 0x14, 0xc4, 0xae, 0x5e, 0x1e, 0x7f, 0x1c, 0x91, 0xbf, 0x5b, 0xc8, 0x11, 0x5a, 0x87,
	0xfc, 0xf4, 0xdf, 0x8a, 0x7c, 0xd3, 0xd4, 0xff, 0x27, 0x07, 0xab, 0x91, 0xd7, 0x40, 0x76, 0x3e,
	0x5e, 0x92, 0x49, 0x3b, 0x9c, 0x29, 0xd0, 0x2a, 0x09, 0x46, 0x87, 0xc9, 0x75, 0x7f, 0x34, 0xeb,
	0xa9, 0x51, 0xda, 0x40, 0x3e, 0x17, 0x05, 0xdc, 0xe5, 0xaf, 0x60, 0x2d, 0x8a, 0x50, 0x3c, 0x80,
	0x7c, 0x1c, 0x7f, 0x00, 0xb9, 0xd6, 0xc0, 0x91, 0x37, 0x8f, 0x7f, 0xcd, 0x43, 0x59, 0xe5, 0xd7,
	0x77, 0xdf, 0xf0, 0xdf, 0xf0, 0xb7, 0xe1, 0x0e, 0xa1, 0x72, 0x7a, 0x46, 0x1e, 0x98, 0xe1, 0x50,
	0x39, 0x49, 0xb6, 0x1e, 0x52, 0xf1, 0xe8, 0x4c, 0xe1, 0x6b, 0x71, 0x02, 0x51, 0x6e, 0xf0, 0xe7,
	0x2f, 0x15, 0xb9, 0xc2, 0x6c, 0x5b, 0x51, 0xb3, 0x15, 0xa2, 0x96, 0xf9, 0x7d, 0x1e, 0xb4, 0x5f,
	0x63, 0xc7, 0xb4, 0x89, 0x78, 0x03, 0x69, 0xbc, 0xe6, 0x9b, 0xb3, 0x08, 0xf8, 0x2a, 0xac, 0x10,
	0x36, 0xee, 0x86, 0x7d, 0xc7, 0x47, 0xea, 0xed, 0x3d, 0xe4, 0xe5, 0xa7, 0x45, 0xc8, 0x86, 0x5e,
	0x04, 0x73, 0x58, 0x43, 0x32, 0xc7, 0x9b, 0x4d, 0x48, 0x9c, 0x48, 0xb7, 0x42, 0x2a, 0xdd, 0xca,
	0xb0, 0x2c, 0x94, 0x98, 0xfe, 0x49, 0x35, 0x1d, 0x47, 0xfa, 0x0d, 0xc5, 0x58, 0xbf, 0xe1, 0x19,
	0x6c, 0x5a, 0x7e, 0xa4, 0x20, 0x90, 0xef, 0x41, 0x8b, 0xb2, 0x59, 0x95, 0x46, 0xe9, 0xf7, 0xe1,
	0x9e, 0xc2, 0x3e, 0xc2, 0x61, 0xfa, 0x17, 0x50, 0x3e, 0x24, 0x54, 0x60, 0xaa, 0xcc, 0x12, 0xfc,
	0xda, 0x11, 0x98, 0x8f, 0xff, 0xc4, 0x34, 0x1c, 0x61, 0x67, 0x32, 0xdd, 0x2e, 0x42, 0x80, 0xfe,
	0x39, 0xbf, 0xd9, 0xa6, 0x79, 0x65, 0x4c, 0x6a, 0xb0, 0x34, 0xc0, 0x43, 0xd2, 0xac, 0x07, 0x69,
	0x17, 0x0c, 0xf7, 0x3b, 0xb0, 0x28, 0x4a, 0x59, 0xb4, 0x04, 0x85, 0x4a, 0xab, 0x55, 0xba, 0x85,
	0x56, 0x61, 0xa9, 0xdd, 0x38, 0xae, 0x37, 0x8f, 0x0f, 0x4b, 0x39, 0xb4, 0x06, 0xcb, 0x95, 0x76,
	0xdb, 0x38, 0x39, 0x6b, 0xd4, 0x4b, 0x79, 0xb4, 0x0c, 0x0b, 0xad, 0xe6, 0x59, 0xa3, 0x54, 0x40,
	0xb7, 0x61, 0xa5, 0x76, 0x72, 0xd4, 0x6e, 0x35, 0xba, 0x8d, 0x7a, 0x69, 0x81, 0x91, 0x19, 0x8d,
	0x2f, 0x1b, 0x35, 0x36, 0x2a, 0xee, 0x9f, 0x41, 0x29, 0xf9, 0x7f, 0x18, 0x9b, 0xf5, 0xf4, 0xf8,
	0xe5, 0xf1, 0xc9, 0x57, 0xc7, 0xa5, 0x5b, 0x68, 0x03, 0x6e, 0xb7, 0x2b, 0xdf, 0x9c, 0x77, 0x4f,
	0xce, 0x3b, 0x5d, 0xa3, 0x51, 0x39, 0x2a, 0xe5, 0x50, 0x09, 0xd6, 0x0e, 0x2b, 0x47, 0x8d, 0xf3,
	0xae, 0x51, 0x69, 0xb6, 0x1a, 0x46, 0x29, 0xcf, 0x20, 0x47, 0xcd, 0x4e, 0x6d, 0x0a, 0x29, 0xec,
	0x3f, 0x82, 0xd5, 0xc8, 0xef, 0x70, 0xe8, 0x2e, 0x6c, 0x1c, 0xb6, 0x4e, 0xaa, 0x95, 0xd6, 0x79,
	0xbb, 0x61, 0xd4, 0x1a, 0xc7, 0xdd, 0xca, 0x61, 0xa3, 0x74, 0x6b, 0xff, 0x97, 0x70, 0x4f, 0xbe,
	0x9f, 0xb8, 0x8e, 0x3f, 0x1e, 0xf2, 0x1a, 0xb7, 0x43, 0x3d, 0x4c, 0xc9, 0x60, 0x82, 0x10, 0xac,
	0x1f, 0x9d, 0x74, 0xba, 0xe7, 0x95, 0xb3, 0x4a, 0xb3, 0x55, 0xa9, 0xb6, 0x1a, 0xa5, 0x5b, 0x6c,
	0x2d, 0x46, 0xe3, 0x4f, 0x4f, 0x1b, 0x1d, 0xa6, 0x7d, 0x6e, 0xff, 0x4b, 0xb8, 0x93, 0x08, 0x41,
	0xb4, 0x02, 0xc5, 0x4e, 0xb7, 0x62, 0x74, 0x4b, 0xb7, 0x98, 0x09, 0x3a, 0xdd, 0x93, 0x76, 0x29,
	0xc7, 0x80, 0xb5, 0x56, 0xa5, 0x79, 0x54, 0xca, 0x23, 0x80, 0xc5, 0x5a, 0xe5, 0xb8, 0xd6, 0x68,
	0x95, 0x0a, 0x6c, 0xa1, 0xcd, 0xe3, 0xb3, 0x4a, 0xab, 0x59, 0x2f, 0x2d, 0xec, 0xd7, 0x61, 0x23,
	0xd5, 0x46, 0x67, 0xab, 0x97, 0xa6, 0x38, 0x6f, 0x37, 0xbf, 0x6e, 0x30, 0x9b, 0x2f, 0x41, 0xa1,
	0x5e, 0x31, 0x4a, 0x39, 0xfe, 0x51, 0x93, 0x53, 0x76, 0x9a, 0xbf, 0x39, 0x6a, 0xbc, 0x2c, 0x15,
	0xf6, 0x5f, 0x00, 0x84, 0x2d, 0x14, 0xb6, 0x84, 0x80, 0xfd, 0xb4, 0xdd, 0x3a, 0xa9, 0xd4, 0x85,
	0xcf, 0xaa, 0x27, 0x5f, 0x9f, 0x33, 0x15, 0x85, 0x62, 0x27, 0x67, 0xcc, 0x86, 0xfb, 0x7f, 0x07,
	0x3b, 0x19, 0xd5, 0x52, 0x74, 0x1a, 0xa3, 0x51, 0xe9, 0x9c, 0x48, 0xbf, 0x88, 0x75, 0x9c, 0x57,
	0x4f, 0x4e, 0x8f, 0xbb, 0xdf, 0x08, 0xbf, 0xf0, 0x55, 0x06, 0x90, 0x3c, 0xda, 0x84, 0x3b, 0x81,
	0xeb, 0x03, 0x60, 0x01, 0x6d, 0x41, 0xc9, 0x68, 0xd4, 0x4e, 0x8e, 0x6b, 0xcd, 0xd6, 0x14, 0xba,
	0xb0, 0xff, 0x6b, 0xd8, 0x48, 0x55, 0x7f, 0x68, 0x07, 0x36, 0x43, 0xfd, 0xeb, 0x95, 0x6e, 0xe3,
	0xbc, 0xfb, 0x4d, 0x9b, 0xf9, 0x61, 0x0d, 0x96, 0xeb, 0x8d, 0x1a, 0x53, 0xa6, 0x21, 0x22, 0xaf,
	0x79, 0x2c, 0x47, 0xf9, 0xe7, 0xff, 0x5e, 0x82, 0xe2, 0x97, 0xb8, 0xd7, 0xc3, 0xc8, 0x85, 0x52,
	0xb2, 0x57, 0x8e, 0xd4, 0x75, 0x62, 0x46, 0xf7, 0xbd, 0xfc, 0xd1, 0x9c, 0xd4, 0x32, 0x79, 0x5c,
	0x28, 0x75, 0xe6, 0x13, 0xd8, 0xb9, 0x91, 0xc0, 0xcc, 0xb6, 0xfa, 0x6f, 0xe1, 0xae, 0xb2, 0xa5,
	0x8d, 0x3e, 0xce, 0x52, 0x3c, 0xb3, 0xa1, 0x5e, 0x7e, 0x7e, 0x13, 0x16, 0x29, 0xff, 0xaf, 0x60,
	0x35, 0xd2, 0xe7, 0x42, 0x3f, 0xc9, 0x9a, 0x22, 0x51, 0xe2, 0x95, 0xf7, 0x66, 0x13, 0x4a, 0x09,
	0x7d, 0x58, 0x8b, 0xb6, 0x32, 0xd1, 0x4c, 0xce, 0xe9, 0x7a, 0x9e, 0xcc, 0x41, 0x29, 0x85, 0x78,
	0xb0, 0x91, 0xea, 0x97, 0xa2, 0x8f, 0x66, 0xf2, 0x47, 0x7b, 0xb7, 0xe5, 0x83, 0x79, 0xc9, 0xa5,
	0xcc, 0xef, 0x72, 0xfc, 0xd1, 0x47, 0xd5, 0xd9, 0x44, 0x9f, 0xcc, 0x9a, 0x4b, 0xd1, 0x78, 0x2d,
	0x7f, 0x7a, 0x33, 0x26, 0xa9, 0xc6, 0xdf, 0xc6, 0x7a, 0xdc, 0xe1, 0xbb, 0xfc, 0xb3, 0xd9, 0x1e,
	0x8a, 0xf7, 0x44, 0xcb, 0x1f, 0xdf, 0x80, 0x23, 0x66, 0xf7, 0xc4, 0xab, 0x6f, 0xa6, 0xdd, 0x95,
	0x7d, 0xcd, 0x6c, 0xbb, 0x67, 0xb4, 0xdf, 0x2c, 0x58, 0x8f, 0xf7, 0xa3, 0xd0, 0xbe, 0xba, 0xe8,
	0x52, 0x75, 0xd5, 0xca, 0x3f, 0x9d, 0x8b, 0x36, 0x14, 0x15, 0xbf, 0x68, 0x67, 0x88, 0x52, 0x76,
	0x9f, 0x32, 0x44, 0x65, 0xf4, 0x0e, 0x7a, 0xc9, 0x1e, 0x96, 0xdc, 0x4c, 0x33, 0x36, 0x82, 0xeb,
	0xee, 0xff, 0xe5, 0xed, 0x54, 0x9d, 0xd4, 0x18, 0x8e, 0xe8, 0x04, 0xd9, 0x70, 0x27, 0x71, 0x3f,
	0x45, 0x6a, 0x1d, 0xd5, 0xb7, 0xe8, 0xf2, 0x87, 0xf3, 0x11, 0xcb, 0x15, 0xd9, 0x70, 0x27, 0x71,
	0xfb, 0xcc, 0x90, 0xa6, 0xbe, 0xdd, 0x66, 0x48, 0xcb, 0xba, 0xd0, 0x8e, 0x01, 0xa5, 0x0b, 0x64,
	0x74, 0x30, 0x77, 0x25, 0x2d, 0x64, 0x3e, 0xbd, 0x61, 0xe5, 0x8d, 0xfe, 0x21, 0x07, 0xdb, 0xea,
	0x5b, 0x25, 0x7a, 0x9e, 0x31, 0xd7, 0x35, 0x37, 0xe7, 0xf2, 0x27, 0x37, 0xe2, 0x09, 0x93, 0x30,
	0x55, 0x69, 0x66, 0x24, 0x61, 0x56, 0xc5, 0x9e, 0x91, 0x84, 0x99, 0x05, 0x2c, 0xba, 0xe2, 0xaf,
	0x7f, 0xc9, 0x22, 0x14, 0x3d, 0xcd, 0x3c, 0x6e, 0xd5, 0xa5, 0x6e, 0xf9, 0xd9, 0xfc, 0x0c, 0x42,
	0x72, 0xf5, 0xf1, 0x6f, 0x1e, 0xb1, 0xdb, 0xed, 0x01, 0x2b, 0x71, 0x2c, 0xe7, 0x80, 0xbe, 0x7e,
	0x8a, 0x87, 0x7f, 0xe3, 0x3c, 0xe5, 0x05, 0x43, 0xf7, 0x8d, 0xe5, 0x8d, 0x0e, 0xdd, 0x16, 0x76,
	0x06, 0xbd, 0x45, 0x1e, 0xfc, 0x9f, 0xfc, 0x21, 0x00, 0x00, 0xff, 0xff, 0x3c, 0x00, 0xf6, 0xd8,
	0xed, 0x32, 0x00, 0x00,
}
