// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/JaegerLambdaTwirp/twirp.proto

/*
Package JaegerLambdaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/JaegerLambdaTwirp/twirp.proto
*/
package JaegerLambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =======================
// JaegerService Interface
// =======================

type JaegerService interface {
	// Broadcasters APIs
	GetBountiesByStatus(context.Context, *GetBountiesByStatusRequest) (*GetBountiesByStatusResponse, error)

	AllocateKeysForBounty(context.Context, *AllocateKeysForBountyRequest) (*AllocateKeysForBountyResponse, error)

	CancelBounty(context.Context, *CancelBountyRequest) (*CancelBountyResponse, error)

	ClaimBounty(context.Context, *ClaimBountyRequest) (*ClaimBountyResponse, error)

	GetAvailableBounties(context.Context, *GetAvailableBountiesRequest) (*GetAvailableBountiesResponse, error)

	GetBroadcasterSettings(context.Context, *GetBroadcasterSettingsRequest) (*GetBroadcasterSettingsResponse, error)

	StartBounty(context.Context, *StartBountyRequest) (*StartBountyResponse, error)

	StopBounty(context.Context, *StopBountyRequest) (*StopBountyResponse, error)

	// Moderation APIs
	GetBounties(context.Context, *GetBountiesRequest) (*GetBountiesResponse, error)

	ModerateBounty(context.Context, *ModerateBountyRequest) (*ModerateBountyResponse, error)

	// Internal APIs
	FixupBounty(context.Context, *FixupBountyRequest) (*FixupBountyResponse, error)

	GetBountiesReport(context.Context, *GetBountiesReportRequest) (*GetBountiesReportResponse, error)

	GetBountyEarnings(context.Context, *GetBountyEarningsRequest) (*GetBountyEarningsResponse, error)

	GetBountyEarningsByIds(context.Context, *GetBountyEarningsByIdsRequest) (*GetBountyEarningsByIdsResponse, error)

	GetSponsoredSession(context.Context, *GetSponsoredSessionRequest) (*GetSponsoredSessionResponse, error)

	GetTargetedBroadcasters(context.Context, *GetTargetedBroadcastersRequest) (*GetTargetedBroadcastersResponse, error)

	RefreshBroadcasterSettings(context.Context, *RefreshBroadcasterSettingsRequest) (*RefreshBroadcasterSettingsResponse, error)

	TriggerCallToAction(context.Context, *TriggerCallToActionRequest) (*TriggerCallToActionResponse, error)

	UpdateBroadcasterSettings(context.Context, *UpdateBroadcasterSettingsRequest) (*UpdateBroadcasterSettingsResponse, error)

	// Misc
	HandleBountyEvent(context.Context, *HandleBountyEventRequest) (*google_protobuf2.Empty, error)
}

// =============================
// JaegerService Protobuf Client
// =============================

type jaegerServiceProtobufClient struct {
	client HTTPClient
	urls   [20]string
	opts   twirp.ClientOptions
}

// NewJaegerServiceProtobufClient creates a Protobuf client that implements the JaegerService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewJaegerServiceProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) JaegerService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + JaegerServicePathPrefix
	urls := [20]string{
		prefix + "GetBountiesByStatus",
		prefix + "AllocateKeysForBounty",
		prefix + "CancelBounty",
		prefix + "ClaimBounty",
		prefix + "GetAvailableBounties",
		prefix + "GetBroadcasterSettings",
		prefix + "StartBounty",
		prefix + "StopBounty",
		prefix + "GetBounties",
		prefix + "ModerateBounty",
		prefix + "FixupBounty",
		prefix + "GetBountiesReport",
		prefix + "GetBountyEarnings",
		prefix + "GetBountyEarningsByIds",
		prefix + "GetSponsoredSession",
		prefix + "GetTargetedBroadcasters",
		prefix + "RefreshBroadcasterSettings",
		prefix + "TriggerCallToAction",
		prefix + "UpdateBroadcasterSettings",
		prefix + "HandleBountyEvent",
	}

	return &jaegerServiceProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *jaegerServiceProtobufClient) GetBountiesByStatus(ctx context.Context, in *GetBountiesByStatusRequest) (*GetBountiesByStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountiesByStatus")
	out := new(GetBountiesByStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) AllocateKeysForBounty(ctx context.Context, in *AllocateKeysForBountyRequest) (*AllocateKeysForBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "AllocateKeysForBounty")
	out := new(AllocateKeysForBountyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) CancelBounty(ctx context.Context, in *CancelBountyRequest) (*CancelBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "CancelBounty")
	out := new(CancelBountyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) ClaimBounty(ctx context.Context, in *ClaimBountyRequest) (*ClaimBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "ClaimBounty")
	out := new(ClaimBountyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) GetAvailableBounties(ctx context.Context, in *GetAvailableBountiesRequest) (*GetAvailableBountiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableBounties")
	out := new(GetAvailableBountiesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) GetBroadcasterSettings(ctx context.Context, in *GetBroadcasterSettingsRequest) (*GetBroadcasterSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBroadcasterSettings")
	out := new(GetBroadcasterSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) StartBounty(ctx context.Context, in *StartBountyRequest) (*StartBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "StartBounty")
	out := new(StartBountyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) StopBounty(ctx context.Context, in *StopBountyRequest) (*StopBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "StopBounty")
	out := new(StopBountyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) GetBounties(ctx context.Context, in *GetBountiesRequest) (*GetBountiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBounties")
	out := new(GetBountiesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) ModerateBounty(ctx context.Context, in *ModerateBountyRequest) (*ModerateBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "ModerateBounty")
	out := new(ModerateBountyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) FixupBounty(ctx context.Context, in *FixupBountyRequest) (*FixupBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "FixupBounty")
	out := new(FixupBountyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) GetBountiesReport(ctx context.Context, in *GetBountiesReportRequest) (*GetBountiesReportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountiesReport")
	out := new(GetBountiesReportResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) GetBountyEarnings(ctx context.Context, in *GetBountyEarningsRequest) (*GetBountyEarningsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyEarnings")
	out := new(GetBountyEarningsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) GetBountyEarningsByIds(ctx context.Context, in *GetBountyEarningsByIdsRequest) (*GetBountyEarningsByIdsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyEarningsByIds")
	out := new(GetBountyEarningsByIdsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) GetSponsoredSession(ctx context.Context, in *GetSponsoredSessionRequest) (*GetSponsoredSessionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetSponsoredSession")
	out := new(GetSponsoredSessionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) GetTargetedBroadcasters(ctx context.Context, in *GetTargetedBroadcastersRequest) (*GetTargetedBroadcastersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetedBroadcasters")
	out := new(GetTargetedBroadcastersResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) RefreshBroadcasterSettings(ctx context.Context, in *RefreshBroadcasterSettingsRequest) (*RefreshBroadcasterSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "RefreshBroadcasterSettings")
	out := new(RefreshBroadcasterSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) TriggerCallToAction(ctx context.Context, in *TriggerCallToActionRequest) (*TriggerCallToActionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "TriggerCallToAction")
	out := new(TriggerCallToActionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) UpdateBroadcasterSettings(ctx context.Context, in *UpdateBroadcasterSettingsRequest) (*UpdateBroadcasterSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateBroadcasterSettings")
	out := new(UpdateBroadcasterSettingsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceProtobufClient) HandleBountyEvent(ctx context.Context, in *HandleBountyEventRequest) (*google_protobuf2.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "HandleBountyEvent")
	out := new(google_protobuf2.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// JaegerService JSON Client
// =========================

type jaegerServiceJSONClient struct {
	client HTTPClient
	urls   [20]string
	opts   twirp.ClientOptions
}

// NewJaegerServiceJSONClient creates a JSON client that implements the JaegerService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewJaegerServiceJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) JaegerService {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + JaegerServicePathPrefix
	urls := [20]string{
		prefix + "GetBountiesByStatus",
		prefix + "AllocateKeysForBounty",
		prefix + "CancelBounty",
		prefix + "ClaimBounty",
		prefix + "GetAvailableBounties",
		prefix + "GetBroadcasterSettings",
		prefix + "StartBounty",
		prefix + "StopBounty",
		prefix + "GetBounties",
		prefix + "ModerateBounty",
		prefix + "FixupBounty",
		prefix + "GetBountiesReport",
		prefix + "GetBountyEarnings",
		prefix + "GetBountyEarningsByIds",
		prefix + "GetSponsoredSession",
		prefix + "GetTargetedBroadcasters",
		prefix + "RefreshBroadcasterSettings",
		prefix + "TriggerCallToAction",
		prefix + "UpdateBroadcasterSettings",
		prefix + "HandleBountyEvent",
	}

	return &jaegerServiceJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *jaegerServiceJSONClient) GetBountiesByStatus(ctx context.Context, in *GetBountiesByStatusRequest) (*GetBountiesByStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountiesByStatus")
	out := new(GetBountiesByStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) AllocateKeysForBounty(ctx context.Context, in *AllocateKeysForBountyRequest) (*AllocateKeysForBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "AllocateKeysForBounty")
	out := new(AllocateKeysForBountyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) CancelBounty(ctx context.Context, in *CancelBountyRequest) (*CancelBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "CancelBounty")
	out := new(CancelBountyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) ClaimBounty(ctx context.Context, in *ClaimBountyRequest) (*ClaimBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "ClaimBounty")
	out := new(ClaimBountyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) GetAvailableBounties(ctx context.Context, in *GetAvailableBountiesRequest) (*GetAvailableBountiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableBounties")
	out := new(GetAvailableBountiesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) GetBroadcasterSettings(ctx context.Context, in *GetBroadcasterSettingsRequest) (*GetBroadcasterSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBroadcasterSettings")
	out := new(GetBroadcasterSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) StartBounty(ctx context.Context, in *StartBountyRequest) (*StartBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "StartBounty")
	out := new(StartBountyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) StopBounty(ctx context.Context, in *StopBountyRequest) (*StopBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "StopBounty")
	out := new(StopBountyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) GetBounties(ctx context.Context, in *GetBountiesRequest) (*GetBountiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBounties")
	out := new(GetBountiesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) ModerateBounty(ctx context.Context, in *ModerateBountyRequest) (*ModerateBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "ModerateBounty")
	out := new(ModerateBountyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) FixupBounty(ctx context.Context, in *FixupBountyRequest) (*FixupBountyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "FixupBounty")
	out := new(FixupBountyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) GetBountiesReport(ctx context.Context, in *GetBountiesReportRequest) (*GetBountiesReportResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountiesReport")
	out := new(GetBountiesReportResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) GetBountyEarnings(ctx context.Context, in *GetBountyEarningsRequest) (*GetBountyEarningsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyEarnings")
	out := new(GetBountyEarningsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) GetBountyEarningsByIds(ctx context.Context, in *GetBountyEarningsByIdsRequest) (*GetBountyEarningsByIdsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyEarningsByIds")
	out := new(GetBountyEarningsByIdsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) GetSponsoredSession(ctx context.Context, in *GetSponsoredSessionRequest) (*GetSponsoredSessionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetSponsoredSession")
	out := new(GetSponsoredSessionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) GetTargetedBroadcasters(ctx context.Context, in *GetTargetedBroadcastersRequest) (*GetTargetedBroadcastersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetedBroadcasters")
	out := new(GetTargetedBroadcastersResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) RefreshBroadcasterSettings(ctx context.Context, in *RefreshBroadcasterSettingsRequest) (*RefreshBroadcasterSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "RefreshBroadcasterSettings")
	out := new(RefreshBroadcasterSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) TriggerCallToAction(ctx context.Context, in *TriggerCallToActionRequest) (*TriggerCallToActionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "TriggerCallToAction")
	out := new(TriggerCallToActionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) UpdateBroadcasterSettings(ctx context.Context, in *UpdateBroadcasterSettingsRequest) (*UpdateBroadcasterSettingsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateBroadcasterSettings")
	out := new(UpdateBroadcasterSettingsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *jaegerServiceJSONClient) HandleBountyEvent(ctx context.Context, in *HandleBountyEventRequest) (*google_protobuf2.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithMethodName(ctx, "HandleBountyEvent")
	out := new(google_protobuf2.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// JaegerService Server Handler
// ============================

type jaegerServiceServer struct {
	JaegerService
	hooks *twirp.ServerHooks
}

func NewJaegerServiceServer(svc JaegerService, hooks *twirp.ServerHooks) TwirpServer {
	return &jaegerServiceServer{
		JaegerService: svc,
		hooks:         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *jaegerServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// JaegerServicePathPrefix is used for all URL paths on a twirp JaegerService server.
// Requests are always: POST JaegerServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const JaegerServicePathPrefix = "/twirp/twitch.bounty.board.jaeger.JaegerService/"

func (s *jaegerServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.bounty.board.jaeger")
	ctx = ctxsetters.WithServiceName(ctx, "JaegerService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetBountiesByStatus":
		s.serveGetBountiesByStatus(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/AllocateKeysForBounty":
		s.serveAllocateKeysForBounty(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/CancelBounty":
		s.serveCancelBounty(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/ClaimBounty":
		s.serveClaimBounty(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetAvailableBounties":
		s.serveGetAvailableBounties(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetBroadcasterSettings":
		s.serveGetBroadcasterSettings(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/StartBounty":
		s.serveStartBounty(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/StopBounty":
		s.serveStopBounty(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetBounties":
		s.serveGetBounties(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/ModerateBounty":
		s.serveModerateBounty(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/FixupBounty":
		s.serveFixupBounty(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetBountiesReport":
		s.serveGetBountiesReport(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetBountyEarnings":
		s.serveGetBountyEarnings(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetBountyEarningsByIds":
		s.serveGetBountyEarningsByIds(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetSponsoredSession":
		s.serveGetSponsoredSession(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/GetTargetedBroadcasters":
		s.serveGetTargetedBroadcasters(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/RefreshBroadcasterSettings":
		s.serveRefreshBroadcasterSettings(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/TriggerCallToAction":
		s.serveTriggerCallToAction(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/UpdateBroadcasterSettings":
		s.serveUpdateBroadcasterSettings(ctx, resp, req)
		return
	case "/twirp/twitch.bounty.board.jaeger.JaegerService/HandleBountyEvent":
		s.serveHandleBountyEvent(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *jaegerServiceServer) serveGetBountiesByStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBountiesByStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBountiesByStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetBountiesByStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountiesByStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBountiesByStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountiesByStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBountiesByStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountiesByStatusResponse and nil error while calling GetBountiesByStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountiesByStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountiesByStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBountiesByStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountiesByStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBountiesByStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountiesByStatusResponse and nil error while calling GetBountiesByStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveAllocateKeysForBounty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAllocateKeysForBountyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAllocateKeysForBountyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveAllocateKeysForBountyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllocateKeysForBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AllocateKeysForBountyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AllocateKeysForBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.AllocateKeysForBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllocateKeysForBountyResponse and nil error while calling AllocateKeysForBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveAllocateKeysForBountyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllocateKeysForBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AllocateKeysForBountyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AllocateKeysForBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.AllocateKeysForBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AllocateKeysForBountyResponse and nil error while calling AllocateKeysForBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveCancelBounty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCancelBountyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCancelBountyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveCancelBountyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CancelBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CancelBountyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CancelBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.CancelBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelBountyResponse and nil error while calling CancelBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveCancelBountyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CancelBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CancelBountyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CancelBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.CancelBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CancelBountyResponse and nil error while calling CancelBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveClaimBounty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveClaimBountyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveClaimBountyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveClaimBountyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClaimBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ClaimBountyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ClaimBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.ClaimBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClaimBountyResponse and nil error while calling ClaimBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveClaimBountyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ClaimBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ClaimBountyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ClaimBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.ClaimBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ClaimBountyResponse and nil error while calling ClaimBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetAvailableBounties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAvailableBountiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAvailableBountiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetAvailableBountiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableBounties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAvailableBountiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAvailableBountiesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetAvailableBounties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAvailableBountiesResponse and nil error while calling GetAvailableBounties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetAvailableBountiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableBounties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetAvailableBountiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetAvailableBountiesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetAvailableBounties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAvailableBountiesResponse and nil error while calling GetAvailableBounties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBroadcasterSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBroadcasterSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBroadcasterSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetBroadcasterSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBroadcasterSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBroadcasterSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBroadcasterSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBroadcasterSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBroadcasterSettingsResponse and nil error while calling GetBroadcasterSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBroadcasterSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBroadcasterSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBroadcasterSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBroadcasterSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBroadcasterSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBroadcasterSettingsResponse and nil error while calling GetBroadcasterSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveStartBounty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStartBountyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStartBountyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveStartBountyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StartBountyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StartBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.StartBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StartBountyResponse and nil error while calling StartBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveStartBountyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StartBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StartBountyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StartBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.StartBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StartBountyResponse and nil error while calling StartBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveStopBounty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveStopBountyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveStopBountyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveStopBountyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StopBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StopBountyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StopBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.StopBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StopBountyResponse and nil error while calling StopBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveStopBountyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "StopBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StopBountyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StopBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.StopBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StopBountyResponse and nil error while calling StopBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBounties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBountiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBountiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetBountiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBounties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBountiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountiesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBounties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountiesResponse and nil error while calling GetBounties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBounties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBountiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountiesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBounties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountiesResponse and nil error while calling GetBounties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveModerateBounty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveModerateBountyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveModerateBountyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveModerateBountyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ModerateBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ModerateBountyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ModerateBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.ModerateBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ModerateBountyResponse and nil error while calling ModerateBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveModerateBountyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ModerateBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ModerateBountyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ModerateBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.ModerateBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ModerateBountyResponse and nil error while calling ModerateBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveFixupBounty(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveFixupBountyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveFixupBountyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveFixupBountyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FixupBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FixupBountyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FixupBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.FixupBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FixupBountyResponse and nil error while calling FixupBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveFixupBountyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "FixupBounty")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(FixupBountyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *FixupBountyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.FixupBounty(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *FixupBountyResponse and nil error while calling FixupBounty. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountiesReport(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBountiesReportJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBountiesReportProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetBountiesReportJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountiesReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBountiesReportRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountiesReportResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBountiesReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountiesReportResponse and nil error while calling GetBountiesReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountiesReportProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountiesReport")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBountiesReportRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountiesReportResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBountiesReport(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountiesReportResponse and nil error while calling GetBountiesReport. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountyEarnings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBountyEarningsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBountyEarningsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetBountyEarningsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyEarnings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBountyEarningsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountyEarningsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBountyEarnings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountyEarningsResponse and nil error while calling GetBountyEarnings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountyEarningsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyEarnings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBountyEarningsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountyEarningsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBountyEarnings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountyEarningsResponse and nil error while calling GetBountyEarnings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountyEarningsByIds(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetBountyEarningsByIdsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetBountyEarningsByIdsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetBountyEarningsByIdsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyEarningsByIds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetBountyEarningsByIdsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountyEarningsByIdsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBountyEarningsByIds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountyEarningsByIdsResponse and nil error while calling GetBountyEarningsByIds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetBountyEarningsByIdsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetBountyEarningsByIds")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetBountyEarningsByIdsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetBountyEarningsByIdsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetBountyEarningsByIds(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetBountyEarningsByIdsResponse and nil error while calling GetBountyEarningsByIds. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetSponsoredSession(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSponsoredSessionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSponsoredSessionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetSponsoredSessionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSponsoredSession")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSponsoredSessionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetSponsoredSessionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetSponsoredSession(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSponsoredSessionResponse and nil error while calling GetSponsoredSession. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetSponsoredSessionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSponsoredSession")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetSponsoredSessionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetSponsoredSessionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetSponsoredSession(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSponsoredSessionResponse and nil error while calling GetSponsoredSession. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetTargetedBroadcasters(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTargetedBroadcastersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTargetedBroadcastersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveGetTargetedBroadcastersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetedBroadcasters")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTargetedBroadcastersRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTargetedBroadcastersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetTargetedBroadcasters(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTargetedBroadcastersResponse and nil error while calling GetTargetedBroadcasters. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveGetTargetedBroadcastersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTargetedBroadcasters")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTargetedBroadcastersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTargetedBroadcastersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.GetTargetedBroadcasters(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTargetedBroadcastersResponse and nil error while calling GetTargetedBroadcasters. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveRefreshBroadcasterSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRefreshBroadcasterSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRefreshBroadcasterSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveRefreshBroadcasterSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefreshBroadcasterSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RefreshBroadcasterSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefreshBroadcasterSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.RefreshBroadcasterSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefreshBroadcasterSettingsResponse and nil error while calling RefreshBroadcasterSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveRefreshBroadcasterSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefreshBroadcasterSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RefreshBroadcasterSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefreshBroadcasterSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.RefreshBroadcasterSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefreshBroadcasterSettingsResponse and nil error while calling RefreshBroadcasterSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveTriggerCallToAction(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveTriggerCallToActionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveTriggerCallToActionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveTriggerCallToActionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TriggerCallToAction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TriggerCallToActionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TriggerCallToActionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.TriggerCallToAction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TriggerCallToActionResponse and nil error while calling TriggerCallToAction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveTriggerCallToActionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "TriggerCallToAction")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(TriggerCallToActionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *TriggerCallToActionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.TriggerCallToAction(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TriggerCallToActionResponse and nil error while calling TriggerCallToAction. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveUpdateBroadcasterSettings(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateBroadcasterSettingsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateBroadcasterSettingsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveUpdateBroadcasterSettingsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateBroadcasterSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateBroadcasterSettingsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateBroadcasterSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.UpdateBroadcasterSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateBroadcasterSettingsResponse and nil error while calling UpdateBroadcasterSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveUpdateBroadcasterSettingsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateBroadcasterSettings")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateBroadcasterSettingsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateBroadcasterSettingsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.UpdateBroadcasterSettings(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateBroadcasterSettingsResponse and nil error while calling UpdateBroadcasterSettings. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveHandleBountyEvent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHandleBountyEventJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHandleBountyEventProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *jaegerServiceServer) serveHandleBountyEventJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandleBountyEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HandleBountyEventRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf2.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.HandleBountyEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf2.Empty and nil error while calling HandleBountyEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) serveHandleBountyEventProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "HandleBountyEvent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HandleBountyEventRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf2.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.JaegerService.HandleBountyEvent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf2.Empty and nil error while calling HandleBountyEvent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *jaegerServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *jaegerServiceServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *jaegerServiceServer) PathPrefix() string {
	return JaegerServicePathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 3827 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x3b, 0x5d, 0x6f, 0xdb, 0x58,
	0x76, 0xd1, 0x97, 0x63, 0x1f, 0x7f, 0xd1, 0xd7, 0x8e, 0xa3, 0x28, 0xd9, 0x4c, 0x96, 0x48, 0x67,
	0xb2, 0xde, 0x19, 0x3b, 0xeb, 0x99, 0xd9, 0x4d, 0xd2, 0xcc, 0x60, 0x69, 0x89, 0x76, 0xb4, 0xd1,
	0xd7, 0x52, 0x94, 0x67, 0xb3, 0x5d, 0x54, 0xa5, 0xc5, 0x6b, 0x85, 0x63, 0x8a, 0xf4, 0x90, 0x94,
	0x1d, 0x15, 0x28, 0xd0, 0xa7, 0x02, 0x05, 0x8a, 0xb6, 0xe8, 0xd3, 0x02, 0x7d, 0x29, 0x50, 0x14,
	0xed, 0x1f, 0xe8, 0xc3, 0xee, 0x53, 0xff, 0x45, 0xfb, 0x37, 0x8a, 0xfe, 0x81, 0xe2, 0x7e, 0xf0,
	0x4b, 0xa4, 0x28, 0x25, 0xe3, 0x79, 0x31, 0x74, 0xcf, 0xbd, 0xe7, 0xdc, 0x73, 0xcf, 0x39, 0xf7,
	0x7c, 0x5c, 0x1e, 0xc3, 0xcf, 0x06, 0xb6, 0x8e, 0xf7, 0xbf, 0x1d, 0xbb, 0x9e, 0x61, 0xed, 0x7b,
	0x57, 0x07, 0xda, 0xe8, 0x2f, 0xad, 0x83, 0x5f, 0x69, 0x78, 0x88, 0x9d, 0x86, 0x36, 0x3a, 0xd3,
	0x35, 0xf5, 0xda, 0x70, 0x2e, 0x0f, 0x3c, 0xf2, 0x77, 0xff, 0xd2, 0xb1, 0x3d, 0x1b, 0x55, 0xbc,
	0x6b, 0xc3, 0x1b, 0xbc, 0xdd, 0x3f, 0xb3, 0xc7, 0x96, 0x37, 0xd9, 0x3f, 0xb3, 0x35, 0x47, 0xdf,
	0xff, 0x96, 0xa2, 0x54, 0x1e, 0x0e, 0x6d, 0x7b, 0x68, 0xe2, 0x03, 0xba, 0xf2, 0x6c, 0x7c, 0x7e,
	0xa0, 0x8f, 0x1d, 0xcd, 0x33, 0x6c, 0x8b, 0xe1, 0x56, 0x3e, 0x9a, 0x9e, 0xf7, 0x8c, 0x11, 0x76,
	0x3d, 0x6d, 0xc4, 0x89, 0x57, 0xee, 0x4f, 0x2f, 0xc0, 0xa3, 0x4b, 0x6f, 0xc2, 0x26, 0xc5, 0xff,
	0xcb, 0xc1, 0x9d, 0xa6, 0xad, 0x63, 0x47, 0xf3, 0xf0, 0x11, 0xdd, 0x5d, 0xc1, 0xdf, 0x8d, 0xb1,
	0xeb, 0xa1, 0x0a, 0x2c, 0x33, 0x76, 0xea, 0x7a, 0x39, 0xf7, 0x28, 0xf7, 0x64, 0x45, 0x09, 0xc6,
	0xe8, 0x37, 0x20, 0x8c, 0x18, 0x92, 0x61, 0x5b, 0x5d, 0x4f, 0xf3, 0xc6, 0x6e, 0x39, 0xff, 0x28,
	0xf7, 0x64, 0xe3, 0xf0, 0xd3, 0xfd, 0xd9, 0x47, 0xd9, 0x6f, 0x4e, 0xe1, 0x28, 0x09, 0x2a, 0x48,
	0x87, 0x9d, 0x10, 0x76, 0xac, 0x19, 0xa6, 0x82, 0x35, 0xd7, 0xb6, 0xca, 0x05, 0x4a, 0xfd, 0xe9,
	0x62, 0xd4, 0x43, 0x3c, 0x25, 0x95, 0x9a, 0xa8, 0xc2, 0xee, 0xf4, 0xa1, 0xdd, 0x4b, 0xdb, 0x72,
	0x31, 0x7a, 0x01, 0x4b, 0x8c, 0x36, 0x3d, 0xf3, 0xea, 0xa1, 0x98, 0xb5, 0x23, 0xc7, 0xe5, 0x18,
	0xe2, 0x97, 0x70, 0xff, 0x04, 0x7b, 0xd2, 0x95, 0x66, 0x98, 0xda, 0x99, 0xc9, 0x28, 0x1b, 0xd8,
	0xf5, 0x05, 0xba, 0x0b, 0x4b, 0x63, 0x17, 0x3b, 0x81, 0x38, 0xf9, 0x48, 0xfc, 0x73, 0x78, 0x90,
	0x8e, 0xc6, 0x59, 0xfa, 0x9a, 0x2b, 0xc2, 0xc0, 0x6e, 0x39, 0xf7, 0xa8, 0xb0, 0x20, 0x53, 0x01,
	0x8e, 0xf8, 0xf7, 0x79, 0x40, 0x27, 0xd8, 0x9b, 0x66, 0x27, 0x4d, 0x87, 0xb9, 0x1b, 0xd1, 0xe1,
	0x0e, 0x94, 0x4c, 0x63, 0x64, 0x78, 0xd4, 0x24, 0x4a, 0x0a, 0x1b, 0xa0, 0x3d, 0x10, 0x3c, 0xdb,
	0xd3, 0xcc, 0xa3, 0xf1, 0xe0, 0x02, 0x7b, 0x55, 0x42, 0x9a, 0x6a, 0xb5, 0xa4, 0x24, 0xe0, 0xe8,
	0x21, 0xc0, 0x19, 0x1d, 0xb6, 0xb4, 0x11, 0x2e, 0x17, 0xa9, 0xb8, 0x22, 0x10, 0xf4, 0x12, 0x6e,
	0x9f, 0x1b, 0xa6, 0x87, 0x1d, 0xb7, 0x5c, 0x9a, 0x2f, 0x91, 0x63, 0xba, 0x54, 0xf1, 0x51, 0xc4,
	0x1e, 0x6c, 0xc7, 0xe4, 0x71, 0x43, 0x72, 0xfe, 0x97, 0x1c, 0x54, 0x22, 0x74, 0x8f, 0x26, 0x5c,
	0x40, 0x5c, 0xde, 0x08, 0x8a, 0xde, 0xd8, 0xf0, 0x95, 0x4f, 0x7f, 0xa3, 0x5f, 0xc2, 0x92, 0x1b,
	0xbd, 0x3d, 0x4f, 0xe6, 0x6f, 0xc8, 0x89, 0x72, 0x3c, 0x62, 0x54, 0x83, 0xb1, 0xe3, 0xda, 0x0e,
	0x95, 0xe5, 0x8a, 0xc2, 0x47, 0xa1, 0x0e, 0x88, 0xf0, 0x0a, 0x5c, 0x07, 0xe2, 0x5f, 0x51, 0x0b,
	0x4d, 0x72, 0x78, 0x33, 0x12, 0x20, 0x6a, 0xb3, 0xf0, 0x3b, 0xaf, 0xca, 0x18, 0xca, 0x33, 0xb5,
	0x85, 0x10, 0xf1, 0x05, 0x94, 0x63, 0x82, 0xbf, 0xb4, 0x1d, 0xcf, 0x17, 0xcf, 0x43, 0x80, 0x81,
	0x36, 0xba, 0xd4, 0x8c, 0xa1, 0x15, 0xdc, 0x90, 0x08, 0x44, 0x1c, 0xc1, 0xbd, 0x14, 0x5c, 0xce,
	0x78, 0x07, 0x36, 0xce, 0x62, 0x33, 0x9c, 0xfd, 0x05, 0xe4, 0xc9, 0x29, 0x4d, 0xe1, 0x8b, 0x47,
	0x21, 0xab, 0x13, 0x59, 0x73, 0x2c, 0xc3, 0x1a, 0x06, 0x9a, 0xdc, 0x81, 0x92, 0xeb, 0x69, 0x74,
	0x13, 0x2a, 0x5b, 0x3a, 0x40, 0x02, 0x14, 0xb0, 0xa5, 0xd3, 0x53, 0x17, 0x14, 0xf2, 0x53, 0xb4,
	0x42, 0x96, 0x23, 0x34, 0x38, 0xcb, 0xbf, 0x86, 0x0d, 0xcc, 0x61, 0xf2, 0x15, 0xb6, 0x3c, 0x5f,
	0xe2, 0x3f, 0xc9, 0x62, 0x59, 0x8e, 0x62, 0x28, 0x53, 0x04, 0xc4, 0xaf, 0xe0, 0x47, 0x89, 0xfd,
	0x8e, 0x26, 0x75, 0x3d, 0x60, 0xfc, 0x01, 0xac, 0xf8, 0x2e, 0x9c, 0x6d, 0xb7, 0xa2, 0x84, 0x00,
	0xd1, 0x85, 0x87, 0xb3, 0xd0, 0x7f, 0x38, 0x9e, 0x3f, 0x67, 0x3c, 0x3b, 0xb6, 0xa6, 0x0f, 0x34,
	0xd7, 0xc3, 0x4e, 0x17, 0x7b, 0x5e, 0x54, 0xd8, 0x29, 0xd7, 0x46, 0x1c, 0x31, 0x4e, 0xd3, 0x90,
	0x38, 0xa7, 0xaf, 0x61, 0xd9, 0xe5, 0x30, 0xaa, 0x91, 0xd5, 0xc3, 0x83, 0x4c, 0x53, 0x48, 0x21,
	0x15, 0x10, 0x10, 0x7f, 0x9f, 0x03, 0x54, 0x35, 0x35, 0x63, 0x14, 0x0f, 0x90, 0x69, 0x17, 0x3a,
	0x1a, 0x34, 0xf3, 0x53, 0x41, 0x33, 0x6e, 0xe1, 0x85, 0x69, 0x0b, 0x27, 0xb8, 0x97, 0xa6, 0xe6,
	0x9d, 0xdb, 0xce, 0x88, 0xbb, 0xbc, 0x60, 0x4c, 0xae, 0xb9, 0x83, 0x87, 0x86, 0x6d, 0x95, 0x4b,
	0xec, 0x9a, 0xb3, 0x91, 0xf8, 0x6b, 0xd8, 0x8e, 0x71, 0x76, 0x03, 0x51, 0xec, 0x1c, 0x50, 0x97,
	0x18, 0xf4, 0xf7, 0x3b, 0xec, 0x23, 0x58, 0x75, 0x3d, 0x07, 0x6b, 0x23, 0xd5, 0xf0, 0x4c, 0xcc,
	0x4f, 0x1b, 0x05, 0x11, 0xd6, 0x63, 0xfb, 0xdc, 0x00, 0xeb, 0x55, 0xf8, 0xb1, 0x82, 0xcf, 0x1d,
	0xec, 0xbe, 0xcd, 0x30, 0xa8, 0x79, 0x8e, 0x66, 0x02, 0x62, 0x16, 0x11, 0xce, 0x66, 0x17, 0xd6,
	0x7c, 0xfb, 0x68, 0x18, 0xae, 0xef, 0x6f, 0xde, 0xdb, 0xc8, 0x62, 0x44, 0x44, 0x05, 0x1e, 0x48,
	0xa6, 0x69, 0x0f, 0x34, 0x0f, 0xbf, 0xc6, 0x13, 0xf7, 0xd8, 0x76, 0x16, 0x4f, 0xc9, 0xc2, 0xec,
	0x22, 0x1f, 0xcb, 0x2e, 0xfe, 0x0c, 0x7e, 0x34, 0x83, 0xe6, 0x0d, 0x08, 0xbc, 0x03, 0x15, 0xd5,
	0x31, 0x86, 0x43, 0xec, 0x54, 0x35, 0xd3, 0x54, 0x6d, 0x69, 0x40, 0xd2, 0x80, 0xef, 0xc3, 0xee,
	0x1b, 0xb8, 0x9f, 0x4a, 0xf1, 0x06, 0x98, 0xbd, 0x86, 0x47, 0xbd, 0x4b, 0x9d, 0xa4, 0x7c, 0xb3,
	0x8d, 0xe3, 0x07, 0x51, 0xeb, 0x3b, 0xf8, 0x71, 0xc6, 0xc6, 0x3f, 0xa4, 0x41, 0xfd, 0x31, 0x4f,
	0x3d, 0xa5, 0xaa, 0x39, 0x43, 0xec, 0x61, 0x3d, 0x82, 0x10, 0x0d, 0x66, 0x43, 0x6d, 0x84, 0xfd,
	0x78, 0xc0, 0x06, 0x24, 0x52, 0x0c, 0xc8, 0x8e, 0x0e, 0x49, 0x05, 0xf2, 0x2c, 0x52, 0x04, 0x00,
	0x74, 0x0c, 0x0f, 0x0d, 0x97, 0x11, 0x35, 0xac, 0xe1, 0xa9, 0xe6, 0x18, 0xd8, 0x9b, 0x44, 0x89,
	0xd3, 0xfb, 0xbe, 0xac, 0xcc, 0x59, 0x85, 0x9e, 0xc1, 0xdd, 0xc8, 0x0a, 0xc9, 0x34, 0xab, 0xc1,
	0x9e, 0x45, 0x4a, 0x60, 0xd6, 0x34, 0x7a, 0x0a, 0xdb, 0xf1, 0xa9, 0x13, 0x7a, 0x86, 0x12, 0xc5,
	0x4a, 0x9b, 0x22, 0x18, 0xcc, 0xfb, 0x34, 0xb0, 0x35, 0xf4, 0xde, 0x76, 0xf1, 0xc0, 0xb6, 0x74,
	0xb7, 0xbc, 0x44, 0xc3, 0x75, 0xda, 0x94, 0x68, 0xc3, 0x47, 0x33, 0x65, 0xc7, 0x95, 0xb6, 0x07,
	0xc2, 0x59, 0x08, 0x67, 0x39, 0x2d, 0x4b, 0x0a, 0x12, 0x70, 0xe2, 0x11, 0xaf, 0x0c, 0x7c, 0xed,
	0x2f, 0x63, 0x79, 0x42, 0x14, 0x24, 0x3e, 0xa3, 0xf9, 0x63, 0x97, 0x90, 0xb6, 0x1d, 0xac, 0x77,
	0xb1, 0xeb, 0x2e, 0x76, 0x9b, 0xc4, 0xff, 0xcc, 0xd1, 0xc4, 0x2e, 0x89, 0xca, 0xf9, 0x6c, 0xc1,
	0xea, 0x19, 0x76, 0x3d, 0x0e, 0xe6, 0x77, 0x27, 0x33, 0xcd, 0x4f, 0x90, 0x8a, 0x12, 0x40, 0xc7,
	0x20, 0x98, 0x9a, 0xeb, 0xd1, 0x18, 0x2e, 0x5b, 0xba, 0x6a, 0x8c, 0x30, 0x0f, 0xb3, 0x95, 0x7d,
	0x56, 0x6d, 0xee, 0xfb, 0xd5, 0xe6, 0xbe, 0xea, 0x97, 0xa3, 0x4a, 0x02, 0x47, 0xfc, 0xb7, 0x3c,
	0x94, 0x5f, 0x69, 0x96, 0xce, 0xab, 0x9e, 0x09, 0xcb, 0x11, 0xf8, 0x81, 0xeb, 0xb0, 0x82, 0xc9,
	0x58, 0x9d, 0x5c, 0x62, 0x5e, 0x99, 0xfc, 0x74, 0xfe, 0x75, 0x97, 0x7d, 0x14, 0x25, 0xc4, 0x46,
	0xcf, 0x7c, 0x52, 0x8b, 0x31, 0x1a, 0x2e, 0x5e, 0x24, 0x68, 0x07, 0x5a, 0x29, 0xce, 0xf4, 0x71,
	0xa5, 0xa8, 0x8f, 0x63, 0xc6, 0xdb, 0x71, 0xec, 0x91, 0x4d, 0x7c, 0x9b, 0x66, 0x32, 0xc6, 0xa9,
	0x29, 0x52, 0xe3, 0x4d, 0x4c, 0x89, 0xf7, 0xe1, 0x5e, 0x8a, 0x98, 0x98, 0x72, 0xc5, 0x13, 0xd8,
	0xea, 0x7a, 0xf6, 0xe5, 0xf7, 0x0f, 0x15, 0x1d, 0x12, 0xf9, 0x43, 0x42, 0x37, 0xe2, 0x72, 0xb7,
	0xab, 0x9a, 0x35, 0xc0, 0xe6, 0xf7, 0x66, 0x8e, 0x65, 0x40, 0xc1, 0x53, 0x00, 0xcd, 0x80, 0xc8,
	0x88, 0xf8, 0xaf, 0x73, 0xdb, 0x19, 0x60, 0xee, 0x31, 0xd8, 0x40, 0x54, 0x60, 0x27, 0xbe, 0xf1,
	0x0d, 0x1c, 0xe6, 0x0a, 0xd0, 0xb1, 0xf1, 0x6e, 0x3c, 0x25, 0xe8, 0xbf, 0x80, 0x1d, 0x36, 0x5f,
	0xb5, 0x1d, 0x07, 0xd3, 0x68, 0x15, 0xf1, 0xdf, 0x9f, 0xce, 0xa7, 0x1f, 0xe2, 0x29, 0xa9, 0x94,
	0x48, 0xa2, 0x14, 0xdb, 0x37, 0xe5, 0x28, 0x85, 0xf7, 0x3c, 0xca, 0xbf, 0x03, 0x2c, 0x31, 0x10,
	0xda, 0x80, 0x7c, 0x90, 0xd6, 0xe5, 0x69, 0x49, 0xba, 0xec, 0x9b, 0x37, 0xbf, 0x29, 0x8f, 0xb3,
	0x08, 0x57, 0xf9, 0x5a, 0x25, 0xc0, 0x42, 0x22, 0xac, 0x45, 0xf2, 0x3c, 0x97, 0xeb, 0x2b, 0x06,
	0x43, 0x2f, 0xa1, 0xe4, 0x69, 0xee, 0x05, 0xf1, 0xf3, 0x84, 0xf7, 0x8f, 0xe7, 0xf3, 0xae, 0x6a,
	0xee, 0x85, 0xc2, 0x90, 0x52, 0x9f, 0x2e, 0x4a, 0x3f, 0xe8, 0xf3, 0xd3, 0xd2, 0x4d, 0x3e, 0x3f,
	0xa1, 0x4f, 0x61, 0x8b, 0xb8, 0x42, 0xff, 0x09, 0x8a, 0xf9, 0xcf, 0xdb, 0x34, 0x20, 0x24, 0x27,
	0x50, 0x0f, 0x36, 0x23, 0xc1, 0xa4, 0x6e, 0x9d, 0xdb, 0xe5, 0x65, 0xaa, 0x98, 0x9f, 0x2e, 0x98,
	0x1c, 0x10, 0x14, 0x65, 0x9a, 0x46, 0xac, 0xdc, 0x58, 0x99, 0x2a, 0x37, 0x3e, 0x87, 0xe2, 0x05,
	0x9e, 0xb8, 0x65, 0xa0, 0xda, 0xf9, 0x28, 0x6b, 0x9f, 0xd7, 0x78, 0xa2, 0xd0, 0xc5, 0xc4, 0xc9,
	0xd2, 0x4a, 0xb8, 0xa6, 0x79, 0xb8, 0xbc, 0x3a, 0xdf, 0xc9, 0x06, 0x8b, 0xd1, 0x17, 0x70, 0x1b,
	0x5b, 0x3a, 0xc5, 0x5b, 0x9b, 0x8b, 0xe7, 0x2f, 0x45, 0x35, 0xd8, 0x24, 0xc2, 0x62, 0xa9, 0x15,
	0xc3, 0x5e, 0x9f, 0x8b, 0x3d, 0x8d, 0x42, 0x42, 0xf8, 0x48, 0x7b, 0x67, 0x8c, 0xc6, 0xa3, 0x8e,
	0x36, 0xb1, 0xc7, 0x5e, 0xb5, 0xda, 0x2b, 0x6f, 0xb0, 0x10, 0x3e, 0x0d, 0x47, 0xfb, 0x80, 0xe2,
	0x30, 0x5a, 0x03, 0x6f, 0xd2, 0xd5, 0x29, 0x33, 0x94, 0xb6, 0x61, 0xc5, 0x69, 0x0b, 0x9c, 0xf6,
	0x14, 0x9c, 0xdc, 0x1a, 0x6d, 0xe0, 0x8d, 0x35, 0x93, 0x81, 0xca, 0x5b, 0x74, 0x5d, 0x0c, 0x16,
	0x79, 0x2e, 0x42, 0x1f, 0xf8, 0x5c, 0xf4, 0x1c, 0x96, 0xae, 0x0c, 0x1d, 0xdb, 0x6e, 0x79, 0x9b,
	0xaa, 0xf6, 0xc7, 0x59, 0x14, 0x4e, 0xc9, 0x4a, 0x85, 0x23, 0xa0, 0x57, 0xb0, 0x75, 0xe9, 0xd8,
	0x43, 0x07, 0xbb, 0x2e, 0xad, 0xdb, 0xa8, 0xd1, 0xee, 0xcc, 0x15, 0x78, 0x12, 0x09, 0x35, 0x60,
	0x6d, 0x10, 0x49, 0xee, 0xcb, 0x77, 0x28, 0x91, 0x27, 0xd9, 0x6e, 0x26, 0x52, 0x0c, 0xc4, 0xb0,
	0x23, 0xa5, 0xf1, 0x6e, 0xb4, 0x34, 0x26, 0xe6, 0xe1, 0x6f, 0xed, 0xa7, 0x28, 0x77, 0xe7, 0x9b,
	0xc7, 0x14, 0x8a, 0xf8, 0xc7, 0x1c, 0x08, 0xd3, 0x7e, 0x3a, 0x33, 0x7e, 0x7d, 0x0c, 0x1b, 0xd4,
	0xb0, 0xe5, 0x58, 0xbe, 0x51, 0x50, 0xa6, 0xa0, 0x24, 0x1d, 0x0c, 0x6e, 0x64, 0x90, 0x59, 0x44,
	0x41, 0xd3, 0x25, 0x74, 0x31, 0x51, 0x42, 0x93, 0xe4, 0x84, 0xe4, 0x8f, 0x34, 0x7b, 0x64, 0x2f,
	0xa1, 0x05, 0x25, 0x02, 0x11, 0x7f, 0x0e, 0x6b, 0x51, 0xc1, 0x91, 0x58, 0xe9, 0x51, 0x5a, 0x8c,
	0x69, 0x36, 0x40, 0x02, 0x14, 0xc6, 0x8e, 0xc9, 0xc3, 0x2d, 0xf9, 0x29, 0x3e, 0x02, 0x08, 0x9d,
	0x2e, 0x29, 0xfd, 0xaf, 0xec, 0xe0, 0xc1, 0x88, 0xfe, 0x16, 0x6d, 0x28, 0xbc, 0xc6, 0x13, 0x32,
	0x35, 0xb0, 0x75, 0x9f, 0x1e, 0xfd, 0x1d, 0xf3, 0x2b, 0xf9, 0x99, 0xcf, 0x18, 0x85, 0x98, 0xae,
	0x1e, 0xc1, 0xea, 0xa5, 0x63, 0xeb, 0xe3, 0x01, 0x4b, 0xf6, 0xf8, 0x51, 0x23, 0x20, 0xb1, 0x0f,
	0x9b, 0x53, 0x1e, 0x6d, 0xd6, 0x7b, 0x3a, 0x2a, 0xc3, 0x6d, 0x56, 0xaa, 0x4c, 0xf8, 0xfe, 0xfe,
	0x90, 0xb0, 0x66, 0x6a, 0xd6, 0x70, 0xac, 0x0d, 0xfd, 0x17, 0x89, 0x60, 0x2c, 0xfe, 0xf7, 0x0a,
	0x2c, 0xfb, 0xc1, 0x2c, 0x11, 0x14, 0x03, 0xc1, 0xe5, 0xa3, 0x82, 0xfb, 0x05, 0x94, 0xce, 0x1c,
	0xcd, 0x62, 0xca, 0x9b, 0x73, 0x97, 0x8e, 0xc8, 0x42, 0x85, 0xad, 0x27, 0x7e, 0x24, 0xe2, 0x8d,
	0x9b, 0xd8, 0x75, 0x09, 0x47, 0xec, 0xd4, 0x29, 0x33, 0xac, 0x1a, 0xb3, 0x3c, 0x6c, 0x79, 0x41,
	0x2e, 0x19, 0x02, 0x08, 0x35, 0xcd, 0xff, 0x78, 0xd0, 0xe1, 0x92, 0x26, 0x85, 0x0d, 0xd1, 0x56,
	0xca, 0x0c, 0xf1, 0xb6, 0xd4, 0x16, 0x25, 0x8f, 0xc6, 0x9c, 0x39, 0xde, 0x96, 0x2f, 0x45, 0x4f,
	0xa1, 0x84, 0x2d, 0x5d, 0xf2, 0x78, 0xec, 0xc9, 0xc2, 0x61, 0x0b, 0x69, 0x71, 0x44, 0x25, 0xc1,
	0xca, 0xaa, 0x9a, 0x36, 0x71, 0x69, 0xa0, 0x29, 0x29, 0x09, 0x38, 0xfa, 0x02, 0xee, 0x78, 0xd8,
	0x19, 0xb9, 0x92, 0xa5, 0x57, 0x6d, 0x4b, 0x37, 0x88, 0xb9, 0xba, 0x3d, 0xc7, 0x2c, 0x03, 0x3d,
	0x6d, 0xfa, 0x24, 0xfa, 0xda, 0xcf, 0x22, 0x56, 0xe7, 0xbf, 0xf6, 0xfa, 0xba, 0x8d, 0xe6, 0x11,
	0x75, 0x58, 0xd5, 0x0d, 0xf7, 0xd2, 0xd4, 0x26, 0x34, 0xaa, 0xb2, 0xd8, 0xf3, 0x49, 0x16, 0x95,
	0x5a, 0xb8, 0x5c, 0x89, 0xe2, 0xce, 0x2a, 0x2f, 0xd7, 0x67, 0x96, 0x97, 0xe8, 0x55, 0xe0, 0x8a,
	0x37, 0x28, 0xf7, 0x4f, 0x17, 0xe1, 0x9e, 0xf9, 0x64, 0x57, 0x26, 0xe6, 0x1c, 0x78, 0x66, 0x13,
	0xd0, 0x05, 0x9e, 0xf8, 0x0a, 0x56, 0xe8, 0x95, 0x22, 0x61, 0x89, 0x50, 0x7d, 0xb9, 0x10, 0xd5,
	0xd7, 0x09, 0x74, 0xb6, 0x43, 0x0a, 0x5d, 0xf4, 0x2d, 0xec, 0x46, 0xfd, 0x6f, 0x0d, 0x9f, 0x1b,
	0x16, 0x55, 0x09, 0x0d, 0x6d, 0xab, 0x87, 0x87, 0x8b, 0xfa, 0xf1, 0x10, 0x53, 0x99, 0x41, 0x91,
	0x06, 0x45, 0xd3, 0xb4, 0xaf, 0xb1, 0xce, 0xea, 0xfb, 0x2d, 0x6a, 0xd4, 0x31, 0x18, 0x7a, 0x0c,
	0xeb, 0x74, 0x1c, 0x3c, 0x02, 0x20, 0x5a, 0x08, 0xc4, 0x81, 0x24, 0xe5, 0xba, 0xf4, 0xcb, 0x2a,
	0xd9, 0x34, 0x86, 0xc6, 0x99, 0x89, 0xcb, 0xdb, 0x74, 0x65, 0x72, 0xa2, 0xf2, 0x3b, 0x58, 0x8d,
	0x08, 0x9a, 0x78, 0xc8, 0x0b, 0x3c, 0xe1, 0xfe, 0x80, 0xfc, 0x24, 0x57, 0xff, 0x4a, 0x33, 0xc7,
	0x7e, 0x31, 0xb9, 0x40, 0x18, 0x65, 0xeb, 0x5f, 0xe4, 0x9f, 0xe5, 0x2a, 0x23, 0xb8, 0x3b, 0x43,
	0xe0, 0x29, 0x3b, 0xbd, 0x8c, 0xef, 0x94, 0x99, 0x29, 0x77, 0x3d, 0xc7, 0xb0, 0x86, 0xa4, 0x68,
	0x88, 0x6c, 0x27, 0xfe, 0x6f, 0x1e, 0x76, 0xd3, 0xe5, 0x8e, 0x9e, 0xc0, 0xe6, 0x5b, 0xcd, 0x8d,
	0x4e, 0xd2, 0xad, 0x97, 0x95, 0x69, 0x30, 0x71, 0x41, 0xe7, 0x0e, 0x29, 0x79, 0xac, 0xc1, 0x84,
	0x47, 0xb4, 0x10, 0x40, 0x1c, 0xeb, 0xc0, 0xb6, 0x4d, 0xdd, 0xbe, 0x66, 0x9e, 0xbd, 0xa0, 0x04,
	0x63, 0x32, 0xe7, 0x7f, 0xb1, 0xe6, 0x1f, 0xa3, 0x82, 0x31, 0xba, 0x80, 0x75, 0xa2, 0x79, 0x37,
	0xd8, 0x9d, 0x7d, 0xcd, 0x93, 0xdf, 0xdf, 0x84, 0x28, 0x38, 0xa0, 0xc3, 0xac, 0x37, 0x4e, 0xbb,
	0xf2, 0x2d, 0xa0, 0xe4, 0xa2, 0x14, 0x89, 0x7f, 0x1d, 0x97, 0xf8, 0xe2, 0x79, 0x49, 0x44, 0xe6,
	0xa7, 0x50, 0xa2, 0x1e, 0x3f, 0x11, 0x49, 0x10, 0x14, 0x2d, 0x6d, 0xe4, 0x07, 0x12, 0xfa, 0x1b,
	0xfd, 0x04, 0x04, 0x4d, 0x67, 0x6e, 0x4d, 0x33, 0xfb, 0xec, 0x35, 0xae, 0x40, 0x2d, 0x7d, 0x33,
	0x84, 0x53, 0x33, 0x16, 0x0d, 0x58, 0x8d, 0xb8, 0x20, 0x12, 0x37, 0xb9, 0x13, 0xa2, 0x1f, 0x4a,
	0xd9, 0x36, 0x51, 0x10, 0xfb, 0xe4, 0xf3, 0x4e, 0x72, 0xbc, 0x9e, 0xd2, 0xe0, 0x9b, 0x86, 0x00,
	0xa6, 0xb7, 0x2b, 0xec, 0x90, 0x49, 0x1e, 0x10, 0xfd, 0xb1, 0x78, 0x00, 0x25, 0x6a, 0xb9, 0x7e,
	0x7e, 0x90, 0x0b, 0xf2, 0x83, 0xf4, 0x70, 0x48, 0xb2, 0x86, 0xd0, 0x00, 0xc9, 0x41, 0x4d, 0xbf,
	0x0e, 0x5e, 0x51, 0xe8, 0x6f, 0xb1, 0x43, 0xf2, 0x91, 0xd0, 0x0d, 0xa3, 0x5f, 0x42, 0xd1, 0x0b,
	0x1f, 0x77, 0x3e, 0x5d, 0xd4, 0x7d, 0xd3, 0xd7, 0x1d, 0x8a, 0x29, 0xfe, 0x0e, 0x96, 0xd8, 0xd7,
	0x5d, 0xf4, 0x22, 0x46, 0xeb, 0xe3, 0xf9, 0xdf, 0x83, 0x43, 0x2a, 0x24, 0x93, 0xa0, 0xaa, 0xf3,
	0x9f, 0x3a, 0xf9, 0x48, 0x7c, 0x00, 0xc5, 0x23, 0xdb, 0xa6, 0xe7, 0x65, 0x16, 0xc1, 0x2e, 0x07,
	0x1b, 0x88, 0xff, 0x55, 0x84, 0xed, 0x94, 0x27, 0xd8, 0x99, 0x79, 0xc9, 0x03, 0x58, 0x31, 0x5c,
	0xd9, 0x22, 0xc1, 0x98, 0x3d, 0x6e, 0x2c, 0x2b, 0x21, 0x00, 0x3d, 0x83, 0x25, 0xc3, 0x55, 0xb1,
	0xeb, 0xf1, 0x6c, 0xe2, 0x51, 0x76, 0x6e, 0x6f, 0x9b, 0x0a, 0x5f, 0x8f, 0x5e, 0xc2, 0xb2, 0xe1,
	0x1e, 0x69, 0x96, 0x85, 0xd9, 0x13, 0xd4, 0x22, 0xb8, 0x01, 0x06, 0x89, 0xd2, 0xf4, 0x0d, 0x52,
	0xf7, 0x3f, 0xad, 0x4a, 0x1e, 0x4d, 0x31, 0x0a, 0x4a, 0x02, 0x4e, 0xd6, 0x8e, 0x69, 0xe9, 0x14,
	0xc4, 0x7a, 0x96, 0x67, 0x14, 0x94, 0x04, 0x9c, 0xac, 0x75, 0xdf, 0xda, 0xd7, 0x2d, 0xdb, 0x33,
	0xce, 0x8d, 0x01, 0xbb, 0xfe, 0xb7, 0xe9, 0xa1, 0x13, 0x70, 0xb2, 0x96, 0x58, 0x9d, 0x63, 0xe8,
	0x3a, 0xb6, 0xaa, 0x83, 0x71, 0xe7, 0xf0, 0x29, 0x4d, 0x33, 0x0a, 0x4a, 0x02, 0x9e, 0x5c, 0xfb,
	0xfc, 0x29, 0xcd, 0x2a, 0x12, 0x6b, 0x9f, 0x27, 0xd7, 0x4a, 0x57, 0x43, 0x9a, 0x50, 0x4c, 0xaf,
	0x95, 0xae, 0x86, 0x24, 0x40, 0x44, 0x60, 0x3c, 0x7f, 0x5c, 0xa5, 0x0a, 0x4c, 0x4e, 0x20, 0x39,
	0xa8, 0xc4, 0xd6, 0xa8, 0xbd, 0x7d, 0xb6, 0xe8, 0x3b, 0x7d, 0xac, 0x1c, 0x13, 0xff, 0xb1, 0x08,
	0x6b, 0xd1, 0xcf, 0xd0, 0xe8, 0x10, 0x76, 0x58, 0xc5, 0xd7, 0x34, 0xac, 0xb1, 0x87, 0xdd, 0x6f,
	0x34, 0x6f, 0xf0, 0x16, 0xeb, 0xfc, 0x51, 0x39, 0x75, 0x8e, 0xa4, 0x1e, 0x0c, 0xde, 0xb3, 0x8c,
	0xef, 0xc6, 0xb8, 0x86, 0xaf, 0x8c, 0x01, 0x76, 0xb9, 0x93, 0x4e, 0x9b, 0x42, 0xbf, 0x81, 0x4f,
	0x52, 0xc0, 0xea, 0x5b, 0xc3, 0xf1, 0x26, 0x3c, 0x3d, 0xf1, 0x37, 0x66, 0xde, 0x7c, 0xd1, 0xe5,
	0x48, 0x81, 0xc7, 0x69, 0x4b, 0xaf, 0xed, 0xa9, 0xf3, 0xb0, 0x40, 0xb0, 0xd0, 0x5a, 0x72, 0x9f,
	0xce, 0xc6, 0xfa, 0x10, 0xfb, 0x76, 0xc9, 0x47, 0x24, 0x39, 0x30, 0x5c, 0x85, 0xec, 0x3f, 0x30,
	0xc8, 0x95, 0x62, 0xef, 0xa7, 0x31, 0x18, 0xc9, 0x2b, 0xfd, 0x8a, 0xae, 0x6a, 0x8f, 0x2e, 0x4d,
	0xec, 0xbf, 0x14, 0xb0, 0xd7, 0x96, 0xf4, 0xc9, 0x48, 0x9d, 0xbd, 0xfc, 0x81, 0x75, 0xf6, 0x33,
	0xb8, 0x1b, 0x4d, 0x69, 0x1a, 0x86, 0x75, 0x51, 0x35, 0x8d, 0xc1, 0x05, 0xd6, 0xb9, 0xb1, 0xce,
	0x9a, 0x16, 0xff, 0x90, 0x83, 0xf5, 0xd8, 0x27, 0xf3, 0xcc, 0x6a, 0x33, 0xfe, 0x3c, 0x9d, 0x4f,
	0x3c, 0x4f, 0x3f, 0x81, 0x4d, 0xac, 0x39, 0x96, 0x34, 0x22, 0x08, 0xec, 0xb9, 0x82, 0x69, 0x74,
	0x1a, 0x4c, 0x76, 0x21, 0x20, 0x5a, 0xb1, 0xf2, 0x30, 0xed, 0x8f, 0x79, 0x10, 0x2b, 0x05, 0x41,
	0x2c, 0xf4, 0x70, 0x4b, 0xb1, 0x07, 0xe4, 0x7f, 0xcd, 0x83, 0x30, 0xfd, 0xe1, 0x80, 0xb0, 0xa8,
	0x5d, 0x61, 0x47, 0x1b, 0xe2, 0x6a, 0xb5, 0x47, 0x0f, 0x90, 0x53, 0x22, 0x90, 0xe0, 0xd9, 0x68,
	0xd1, 0xb7, 0xf9, 0x60, 0x31, 0x7f, 0x36, 0xa2, 0x78, 0x85, 0x85, 0x9e, 0x8d, 0x28, 0xd6, 0x97,
	0x53, 0xf9, 0xc8, 0xea, 0xe1, 0xbd, 0x04, 0x5a, 0x8d, 0x2f, 0x88, 0xa4, 0x2a, 0x8f, 0x61, 0x3d,
	0xac, 0xcc, 0xea, 0x3a, 0x2b, 0xb7, 0x57, 0x94, 0x38, 0x30, 0xf1, 0xf6, 0xc9, 0xaa, 0xb0, 0x18,
	0x6c, 0xef, 0x8d, 0x7f, 0xe7, 0xf9, 0x9b, 0x23, 0x82, 0x8d, 0x5e, 0xeb, 0x75, 0xab, 0xfd, 0x4d,
	0xab, 0xdf, 0x55, 0x25, 0xb5, 0xd7, 0x15, 0x6e, 0xa1, 0x75, 0x58, 0x91, 0x4e, 0xa5, 0x7a, 0x43,
	0x3a, 0x6a, 0xc8, 0x42, 0x0e, 0x2d, 0x43, 0xb1, 0x51, 0x3f, 0x95, 0x85, 0x3c, 0x99, 0xa8, 0x4a,
	0xad, 0xaa, 0xdc, 0x68, 0xc8, 0x35, 0xa1, 0x40, 0x87, 0xed, 0x66, 0xa7, 0x21, 0xab, 0x72, 0x4d,
	0x28, 0xee, 0x3d, 0x06, 0x08, 0x83, 0x1b, 0xc1, 0x6a, 0xb5, 0x5b, 0xb2, 0x70, 0x0b, 0xad, 0xc1,
	0x72, 0x43, 0x6a, 0x9d, 0xf4, 0xa4, 0x13, 0x59, 0xc8, 0xed, 0x9d, 0x82, 0x30, 0x1d, 0x4e, 0xd1,
	0x2a, 0xdc, 0xe6, 0x4c, 0x08, 0xb7, 0xd0, 0x16, 0xac, 0x77, 0xa4, 0x37, 0x7d, 0xb5, 0xdd, 0xef,
	0xaa, 0x8a, 0x2c, 0x35, 0x85, 0x1c, 0x12, 0x60, 0xed, 0x44, 0x6a, 0xca, 0x7d, 0x55, 0x91, 0xea,
	0x0d, 0x59, 0x11, 0xf2, 0x04, 0xd2, 0xac, 0x77, 0xab, 0x01, 0xa4, 0xb0, 0xf7, 0x02, 0x84, 0xe9,
	0x27, 0x56, 0x72, 0xb8, 0x8e, 0xdc, 0xaa, 0xd5, 0x5b, 0x27, 0x7d, 0x45, 0x3e, 0xad, 0xcb, 0xdf,
	0x08, 0xb7, 0x08, 0x5f, 0x1d, 0xa9, 0xdb, 0x65, 0xe7, 0x3a, 0x96, 0xea, 0x0d, 0x21, 0xbf, 0xf7,
	0x1f, 0x39, 0xd8, 0x49, 0x7b, 0x41, 0x45, 0x2b, 0x50, 0x6a, 0xab, 0xaf, 0x64, 0x45, 0xb8, 0x85,
	0xca, 0xb0, 0xd3, 0xac, 0xb7, 0xea, 0xcd, 0x5e, 0xb3, 0xaf, 0xd6, 0x9b, 0x72, 0xbf, 0xd5, 0x56,
	0xfb, 0x4d, 0x59, 0x15, 0x72, 0xe8, 0x0e, 0x6c, 0xd5, 0x5b, 0xd5, 0xb6, 0xa2, 0xc8, 0x55, 0xb5,
	0x5f, 0x6d, 0xb7, 0x54, 0xb9, 0xa5, 0x0a, 0x79, 0xb4, 0x09, 0xab, 0x47, 0x52, 0xad, 0xd9, 0xee,
	0xa9, 0xaf, 0xea, 0xad, 0x13, 0xa1, 0x80, 0xee, 0xc1, 0x1d, 0x4a, 0xcc, 0x5f, 0xd3, 0x3f, 0xad,
	0x77, 0xeb, 0x44, 0xc4, 0x45, 0xc2, 0x4a, 0xbd, 0xd6, 0x90, 0x85, 0x12, 0x02, 0x58, 0x6a, 0xb5,
	0xfb, 0xa7, 0xed, 0x9a, 0xb0, 0x44, 0xd8, 0x97, 0x7a, 0x6a, 0xbb, 0xdf, 0x6c, 0xd7, 0x64, 0x45,
	0x22, 0x42, 0xbe, 0xbd, 0xf7, 0x19, 0x2c, 0x37, 0xf8, 0xab, 0x01, 0x5a, 0x82, 0xbc, 0x4c, 0x24,
	0xb6, 0x02, 0x25, 0xb9, 0xd5, 0x3f, 0x39, 0x12, 0x72, 0x04, 0x74, 0x4c, 0xe4, 0xb3, 0x04, 0xf9,
	0x9a, 0x2c, 0x14, 0xf6, 0xba, 0xb0, 0x95, 0x08, 0x00, 0x44, 0x6f, 0xad, 0x76, 0xa8, 0xee, 0x55,
	0xb8, 0x5d, 0x6f, 0x9d, 0xd6, 0x09, 0xfd, 0x1c, 0x51, 0x96, 0x54, 0xad, 0xca, 0x1d, 0x32, 0xca,
	0x13, 0x6e, 0x8e, 0xa4, 0x56, 0x8b, 0x6a, 0x7b, 0x19, 0x8a, 0xaa, 0xdc, 0x55, 0x85, 0xe2, 0xde,
	0xaf, 0x60, 0x73, 0xea, 0x73, 0x17, 0xa7, 0x21, 0x35, 0xea, 0x35, 0xc6, 0x4f, 0x57, 0x95, 0x14,
	0x95, 0xc9, 0xb8, 0xab, 0xb6, 0x3b, 0x42, 0x9e, 0x00, 0xab, 0x0d, 0xa9, 0xde, 0x14, 0x0a, 0x84,
	0x2a, 0x33, 0x23, 0xa1, 0xb8, 0x67, 0xc2, 0x9d, 0xe8, 0xb7, 0x12, 0xd9, 0x71, 0x6c, 0xa7, 0x6a,
	0xeb, 0x18, 0x6d, 0xc3, 0xe6, 0x51, 0xbb, 0xd7, 0x52, 0xdf, 0x50, 0x49, 0x53, 0x03, 0xbc, 0xc5,
	0x44, 0x4d, 0xb7, 0xe9, 0xf3, 0xc9, 0x3a, 0x61, 0x7a, 0x1b, 0x36, 0x7d, 0x70, 0xaf, 0x2b, 0x2b,
	0x04, 0x98, 0x27, 0xd2, 0xf3, 0x81, 0x8a, 0x2c, 0x75, 0xdb, 0x2d, 0xa1, 0xb0, 0xf7, 0x3f, 0x39,
	0xd8, 0x89, 0xb4, 0xac, 0x84, 0xbb, 0x55, 0x60, 0x97, 0x13, 0x94, 0x1a, 0x8a, 0x2c, 0xd5, 0xde,
	0xf4, 0x29, 0xb3, 0x72, 0x8d, 0x69, 0x9e, 0xcf, 0x35, 0xea, 0xcd, 0xba, 0x4a, 0xa8, 0x55, 0x5f,
	0x51, 0x61, 0x3d, 0x80, 0xf2, 0x34, 0x56, 0x70, 0x1f, 0xf2, 0x84, 0xd9, 0xaa, 0xd4, 0xec, 0x48,
	0xf5, 0x93, 0x56, 0x78, 0x86, 0x02, 0xda, 0x05, 0xf4, 0x5b, 0x59, 0x69, 0xf7, 0x3b, 0xd2, 0x9b,
	0x76, 0x4f, 0xe5, 0xe7, 0x10, 0x8a, 0xe8, 0x23, 0xb8, 0xaf, 0xc8, 0x27, 0xf5, 0x76, 0xab, 0xdf,
	0x69, 0x48, 0xea, 0x71, 0x5b, 0x69, 0xf6, 0x7b, 0xad, 0x6e, 0xaf, 0xd3, 0x69, 0x2b, 0x84, 0x5e,
	0x29, 0xb2, 0x1b, 0xa1, 0x26, 0xb7, 0xda, 0xbd, 0x93, 0x57, 0xfd, 0xa3, 0x5e, 0xed, 0x44, 0x56,
	0x85, 0xa5, 0xbd, 0xcf, 0x60, 0x27, 0xd2, 0xa2, 0x16, 0x9e, 0xec, 0x0e, 0x6c, 0xb5, 0xda, 0xfd,
	0x6a, 0xb5, 0xd7, 0xaf, 0x49, 0xaa, 0xd4, 0x3f, 0x6e, 0xf7, 0x5a, 0x35, 0xe1, 0xd6, 0xe1, 0x1f,
	0x76, 0x60, 0x9d, 0xb5, 0x05, 0x77, 0xb1, 0x43, 0x62, 0x1f, 0xfa, 0x9b, 0x5c, 0xac, 0x33, 0xd1,
	0xef, 0xcf, 0x43, 0x3f, 0xcf, 0x8a, 0x3f, 0xb3, 0x5b, 0x0e, 0x2b, 0xbf, 0x78, 0x6f, 0x3c, 0xfe,
	0x6d, 0xe9, 0xef, 0x72, 0x70, 0x27, 0xb5, 0x6b, 0x04, 0x3d, 0xcb, 0x22, 0x99, 0xd5, 0xbc, 0x52,
	0x79, 0xfe, 0x01, 0x98, 0x9c, 0x9d, 0xef, 0x48, 0xdd, 0x10, 0x5a, 0x28, 0x3a, 0xc8, 0xae, 0x14,
	0x12, 0x1f, 0x1c, 0x2b, 0x4f, 0x17, 0x47, 0xe0, 0x5b, 0x5a, 0xb0, 0x1a, 0xb1, 0x52, 0xb4, 0x9f,
	0x49, 0x20, 0xd1, 0x1b, 0x56, 0x39, 0x58, 0x78, 0x3d, 0xdf, 0xef, 0x6f, 0x73, 0xd4, 0x78, 0x12,
	0x5d, 0xc0, 0x68, 0x9e, 0x0e, 0x67, 0xb5, 0x1b, 0x57, 0x9e, 0xbd, 0x3f, 0x22, 0xe7, 0xe5, 0x1f,
	0x72, 0xb0, 0x9b, 0xde, 0x5f, 0x87, 0x9e, 0xcf, 0xb3, 0xa8, 0x99, 0xad, 0x35, 0x95, 0x17, 0x1f,
	0x82, 0x1a, 0x6a, 0x23, 0xd2, 0x2b, 0x96, 0xad, 0x8d, 0x64, 0xf3, 0x5a, 0xb6, 0x36, 0xd2, 0x9a,
	0xd0, 0x2e, 0x48, 0x29, 0xeb, 0x7f, 0x09, 0x47, 0x9f, 0x65, 0xa3, 0x4f, 0x7d, 0x7a, 0xaf, 0xec,
	0x2f, 0xba, 0x3c, 0x3c, 0x5c, 0xe4, 0x2e, 0x66, 0x1f, 0x2e, 0xd9, 0xc7, 0x9d, 0x7d, 0xb8, 0xb4,
	0x3e, 0xe7, 0x6b, 0xd8, 0x88, 0x37, 0xbf, 0xa3, 0x9f, 0x2d, 0xf0, 0x5d, 0x33, 0xfe, 0xdf, 0x01,
	0x95, 0xc3, 0xf7, 0x41, 0x09, 0x0f, 0x1a, 0xf9, 0x90, 0x9d, 0x7d, 0xd0, 0xe4, 0x97, 0xf6, 0xec,
	0x83, 0xa6, 0x7d, 0x21, 0xff, 0xeb, 0x1c, 0x6c, 0x25, 0x7a, 0x86, 0xd1, 0x17, 0x0b, 0xcb, 0x2b,
	0xd2, 0x9e, 0x5c, 0xf9, 0xf2, 0x3d, 0xb1, 0x52, 0x58, 0x08, 0x9a, 0x6a, 0x17, 0x63, 0x61, 0xba,
	0xed, 0x78, 0x31, 0x16, 0x92, 0x8d, 0xc6, 0xfe, 0x6d, 0x4e, 0xf6, 0xf5, 0xce, 0xbf, 0xcd, 0x33,
	0x5b, 0x89, 0xe7, 0xdf, 0xe6, 0x8c, 0x36, 0x62, 0x1e, 0xe6, 0x12, 0x95, 0xc2, 0xbc, 0x30, 0x37,
	0xa3, 0x33, 0x6a, 0x6e, 0x98, 0x9b, 0xd9, 0x16, 0xf5, 0x4f, 0x39, 0xb8, 0x3b, 0xa3, 0xc5, 0x0b,
	0xcd, 0x3b, 0x60, 0x46, 0x4f, 0x5d, 0xe5, 0x4f, 0x3f, 0x08, 0x97, 0x33, 0xf5, 0xcf, 0x39, 0xa8,
	0xcc, 0x6e, 0x40, 0x45, 0x5f, 0x65, 0xd1, 0x9e, 0xdb, 0xfd, 0x5a, 0xf9, 0xfa, 0x43, 0xd1, 0x23,
	0xba, 0x4b, 0x69, 0xd0, 0xcc, 0xd6, 0xdd, 0xec, 0x1e, 0xd1, 0x6c, 0xdd, 0x65, 0x75, 0x82, 0xfe,
	0x3e, 0x07, 0xf7, 0x66, 0x76, 0x55, 0xa2, 0xcc, 0xcf, 0x1e, 0xf3, 0xba, 0x40, 0x2b, 0x5f, 0x7d,
	0x20, 0x36, 0x67, 0x4d, 0x83, 0xad, 0x44, 0xb7, 0x56, 0xf6, 0x9d, 0x9f, 0xd5, 0x03, 0x57, 0xd9,
	0x4d, 0x94, 0xa6, 0xf2, 0xe8, 0xd2, 0x9b, 0x1c, 0x7d, 0xf2, 0xdb, 0x3f, 0x59, 0xe8, 0xbf, 0xcc,
	0xce, 0x96, 0x28, 0xe2, 0xe7, 0xff, 0x1f, 0x00, 0x00, 0xff, 0xff, 0xfa, 0x6c, 0x70, 0xba, 0x95,
	0x36, 0x00, 0x00,
}
