// Code generated by protoc-gen-twirp v5.7.0, DO NOT EDIT.
// source: main.proto

package MagnusPipelineLambdaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ===============================
// MagnusPipelineService Interface
// ===============================

type MagnusPipelineService interface {
	// TODO: deprecate this endpoint in arcwarden
	GetRepPkg(context.Context, *GetRepPkgRequest) (*GetRepPkgResponse, error)

	GetRepPkgCurrent(context.Context, *GetRepPkgCurrentRequest) (*GetRepPkgCurrentResponse, error)

	GetRepPkg24Hours(context.Context, *GetRepPkg24HoursRequest) (*GetRepPkg24HoursResponse, error)

	// TODO: deprecate this endpoint in arcwarden
	UpdateRepPkgMonitoringReferenceData(context.Context, *UpdateRepPkgMonitoringReferenceDataRequest) (*UpdateRepPkgMonitoringReferenceDataResponse, error)

	SyncRepPkgMonitoringReferenceData(context.Context, *SyncRepPkgMonitoringReferenceDataRequest) (*SyncRepPkgMonitoringReferenceDataResponse, error)

	GetPopRepPkgDriftMetricAlarms(context.Context, *GetPopRepPkgDriftMetricAlarmsRequest) (*GetPopRepPkgDriftMetricAlarmsResponse, error)
}

// =====================================
// MagnusPipelineService Protobuf Client
// =====================================

type magnusPipelineServiceProtobufClient struct {
	client HTTPClient
	urls   [6]string
}

// NewMagnusPipelineServiceProtobufClient creates a Protobuf client that implements the MagnusPipelineService interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewMagnusPipelineServiceProtobufClient(addr string, client HTTPClient) MagnusPipelineService {
	prefix := urlBase(addr) + MagnusPipelineServicePathPrefix
	urls := [6]string{
		prefix + "GetRepPkg",
		prefix + "GetRepPkgCurrent",
		prefix + "GetRepPkg24Hours",
		prefix + "UpdateRepPkgMonitoringReferenceData",
		prefix + "SyncRepPkgMonitoringReferenceData",
		prefix + "GetPopRepPkgDriftMetricAlarms",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &magnusPipelineServiceProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &magnusPipelineServiceProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *magnusPipelineServiceProtobufClient) GetRepPkg(ctx context.Context, in *GetRepPkgRequest) (*GetRepPkgResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkg")
	out := new(GetRepPkgResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceProtobufClient) GetRepPkgCurrent(ctx context.Context, in *GetRepPkgCurrentRequest) (*GetRepPkgCurrentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkgCurrent")
	out := new(GetRepPkgCurrentResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceProtobufClient) GetRepPkg24Hours(ctx context.Context, in *GetRepPkg24HoursRequest) (*GetRepPkg24HoursResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkg24Hours")
	out := new(GetRepPkg24HoursResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceProtobufClient) UpdateRepPkgMonitoringReferenceData(ctx context.Context, in *UpdateRepPkgMonitoringReferenceDataRequest) (*UpdateRepPkgMonitoringReferenceDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRepPkgMonitoringReferenceData")
	out := new(UpdateRepPkgMonitoringReferenceDataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceProtobufClient) SyncRepPkgMonitoringReferenceData(ctx context.Context, in *SyncRepPkgMonitoringReferenceDataRequest) (*SyncRepPkgMonitoringReferenceDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "SyncRepPkgMonitoringReferenceData")
	out := new(SyncRepPkgMonitoringReferenceDataResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceProtobufClient) GetPopRepPkgDriftMetricAlarms(ctx context.Context, in *GetPopRepPkgDriftMetricAlarmsRequest) (*GetPopRepPkgDriftMetricAlarmsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "GetPopRepPkgDriftMetricAlarms")
	out := new(GetPopRepPkgDriftMetricAlarmsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =================================
// MagnusPipelineService JSON Client
// =================================

type magnusPipelineServiceJSONClient struct {
	client HTTPClient
	urls   [6]string
}

// NewMagnusPipelineServiceJSONClient creates a JSON client that implements the MagnusPipelineService interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewMagnusPipelineServiceJSONClient(addr string, client HTTPClient) MagnusPipelineService {
	prefix := urlBase(addr) + MagnusPipelineServicePathPrefix
	urls := [6]string{
		prefix + "GetRepPkg",
		prefix + "GetRepPkgCurrent",
		prefix + "GetRepPkg24Hours",
		prefix + "UpdateRepPkgMonitoringReferenceData",
		prefix + "SyncRepPkgMonitoringReferenceData",
		prefix + "GetPopRepPkgDriftMetricAlarms",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &magnusPipelineServiceJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &magnusPipelineServiceJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *magnusPipelineServiceJSONClient) GetRepPkg(ctx context.Context, in *GetRepPkgRequest) (*GetRepPkgResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkg")
	out := new(GetRepPkgResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceJSONClient) GetRepPkgCurrent(ctx context.Context, in *GetRepPkgCurrentRequest) (*GetRepPkgCurrentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkgCurrent")
	out := new(GetRepPkgCurrentResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceJSONClient) GetRepPkg24Hours(ctx context.Context, in *GetRepPkg24HoursRequest) (*GetRepPkg24HoursResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkg24Hours")
	out := new(GetRepPkg24HoursResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceJSONClient) UpdateRepPkgMonitoringReferenceData(ctx context.Context, in *UpdateRepPkgMonitoringReferenceDataRequest) (*UpdateRepPkgMonitoringReferenceDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRepPkgMonitoringReferenceData")
	out := new(UpdateRepPkgMonitoringReferenceDataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceJSONClient) SyncRepPkgMonitoringReferenceData(ctx context.Context, in *SyncRepPkgMonitoringReferenceDataRequest) (*SyncRepPkgMonitoringReferenceDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "SyncRepPkgMonitoringReferenceData")
	out := new(SyncRepPkgMonitoringReferenceDataResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *magnusPipelineServiceJSONClient) GetPopRepPkgDriftMetricAlarms(ctx context.Context, in *GetPopRepPkgDriftMetricAlarmsRequest) (*GetPopRepPkgDriftMetricAlarmsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithMethodName(ctx, "GetPopRepPkgDriftMetricAlarms")
	out := new(GetPopRepPkgDriftMetricAlarmsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ====================================
// MagnusPipelineService Server Handler
// ====================================

type magnusPipelineServiceServer struct {
	MagnusPipelineService
	hooks *twirp.ServerHooks
}

func NewMagnusPipelineServiceServer(svc MagnusPipelineService, hooks *twirp.ServerHooks) TwirpServer {
	return &magnusPipelineServiceServer{
		MagnusPipelineService: svc,
		hooks:                 hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *magnusPipelineServiceServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// MagnusPipelineServicePathPrefix is used for all URL paths on a twirp MagnusPipelineService server.
// Requests are always: POST MagnusPipelineServicePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const MagnusPipelineServicePathPrefix = "/twirp/twitch.fulton.magnuspipelineservice.MagnusPipelineService/"

func (s *magnusPipelineServiceServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.magnuspipelineservice")
	ctx = ctxsetters.WithServiceName(ctx, "MagnusPipelineService")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.magnuspipelineservice.MagnusPipelineService/GetRepPkg":
		s.serveGetRepPkg(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.magnuspipelineservice.MagnusPipelineService/GetRepPkgCurrent":
		s.serveGetRepPkgCurrent(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.magnuspipelineservice.MagnusPipelineService/GetRepPkg24Hours":
		s.serveGetRepPkg24Hours(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.magnuspipelineservice.MagnusPipelineService/UpdateRepPkgMonitoringReferenceData":
		s.serveUpdateRepPkgMonitoringReferenceData(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.magnuspipelineservice.MagnusPipelineService/SyncRepPkgMonitoringReferenceData":
		s.serveSyncRepPkgMonitoringReferenceData(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.magnuspipelineservice.MagnusPipelineService/GetPopRepPkgDriftMetricAlarms":
		s.serveGetPopRepPkgDriftMetricAlarms(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *magnusPipelineServiceServer) serveGetRepPkg(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRepPkgJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRepPkgProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *magnusPipelineServiceServer) serveGetRepPkgJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkg")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRepPkgRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *GetRepPkgResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.GetRepPkg(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRepPkgResponse and nil error while calling GetRepPkg. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveGetRepPkgProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkg")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRepPkgRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *GetRepPkgResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.GetRepPkg(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRepPkgResponse and nil error while calling GetRepPkg. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveGetRepPkgCurrent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRepPkgCurrentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRepPkgCurrentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *magnusPipelineServiceServer) serveGetRepPkgCurrentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkgCurrent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRepPkgCurrentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *GetRepPkgCurrentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.GetRepPkgCurrent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRepPkgCurrentResponse and nil error while calling GetRepPkgCurrent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveGetRepPkgCurrentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkgCurrent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRepPkgCurrentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *GetRepPkgCurrentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.GetRepPkgCurrent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRepPkgCurrentResponse and nil error while calling GetRepPkgCurrent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveGetRepPkg24Hours(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRepPkg24HoursJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRepPkg24HoursProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *magnusPipelineServiceServer) serveGetRepPkg24HoursJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkg24Hours")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRepPkg24HoursRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *GetRepPkg24HoursResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.GetRepPkg24Hours(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRepPkg24HoursResponse and nil error while calling GetRepPkg24Hours. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveGetRepPkg24HoursProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRepPkg24Hours")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRepPkg24HoursRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *GetRepPkg24HoursResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.GetRepPkg24Hours(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRepPkg24HoursResponse and nil error while calling GetRepPkg24Hours. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveUpdateRepPkgMonitoringReferenceData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRepPkgMonitoringReferenceDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRepPkgMonitoringReferenceDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *magnusPipelineServiceServer) serveUpdateRepPkgMonitoringReferenceDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRepPkgMonitoringReferenceData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRepPkgMonitoringReferenceDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *UpdateRepPkgMonitoringReferenceDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.UpdateRepPkgMonitoringReferenceData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRepPkgMonitoringReferenceDataResponse and nil error while calling UpdateRepPkgMonitoringReferenceData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveUpdateRepPkgMonitoringReferenceDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRepPkgMonitoringReferenceData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateRepPkgMonitoringReferenceDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *UpdateRepPkgMonitoringReferenceDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.UpdateRepPkgMonitoringReferenceData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRepPkgMonitoringReferenceDataResponse and nil error while calling UpdateRepPkgMonitoringReferenceData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveSyncRepPkgMonitoringReferenceData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSyncRepPkgMonitoringReferenceDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSyncRepPkgMonitoringReferenceDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *magnusPipelineServiceServer) serveSyncRepPkgMonitoringReferenceDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SyncRepPkgMonitoringReferenceData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SyncRepPkgMonitoringReferenceDataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *SyncRepPkgMonitoringReferenceDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.SyncRepPkgMonitoringReferenceData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SyncRepPkgMonitoringReferenceDataResponse and nil error while calling SyncRepPkgMonitoringReferenceData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveSyncRepPkgMonitoringReferenceDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SyncRepPkgMonitoringReferenceData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SyncRepPkgMonitoringReferenceDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *SyncRepPkgMonitoringReferenceDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.SyncRepPkgMonitoringReferenceData(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SyncRepPkgMonitoringReferenceDataResponse and nil error while calling SyncRepPkgMonitoringReferenceData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveGetPopRepPkgDriftMetricAlarms(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPopRepPkgDriftMetricAlarmsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPopRepPkgDriftMetricAlarmsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *magnusPipelineServiceServer) serveGetPopRepPkgDriftMetricAlarmsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPopRepPkgDriftMetricAlarms")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPopRepPkgDriftMetricAlarmsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request json"))
		return
	}

	// Call service method
	var respContent *GetPopRepPkgDriftMetricAlarmsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.GetPopRepPkgDriftMetricAlarms(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPopRepPkgDriftMetricAlarmsResponse and nil error while calling GetPopRepPkgDriftMetricAlarms. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) serveGetPopRepPkgDriftMetricAlarmsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPopRepPkgDriftMetricAlarms")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPopRepPkgDriftMetricAlarmsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to parse request proto"))
		return
	}

	// Call service method
	var respContent *GetPopRepPkgDriftMetricAlarmsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.MagnusPipelineService.GetPopRepPkgDriftMetricAlarms(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPopRepPkgDriftMetricAlarmsResponse and nil error while calling GetPopRepPkgDriftMetricAlarms. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *magnusPipelineServiceServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *magnusPipelineServiceServer) ProtocGenTwirpVersion() string {
	return "v5.7.0"
}

func (s *magnusPipelineServiceServer) PathPrefix() string {
	return MagnusPipelineServicePathPrefix
}

var twirpFileDescriptor1 = []byte{
	// 876 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xdd, 0x8e, 0xdb, 0x44,
	0x14, 0x96, 0xb3, 0xdd, 0x6d, 0xf7, 0xa4, 0x5b, 0xda, 0xd1, 0x02, 0xa9, 0x05, 0x02, 0x5c, 0x40,
	0xcb, 0xa2, 0x3a, 0x22, 0x14, 0xc4, 0xa2, 0x05, 0xa9, 0xd0, 0x28, 0xb4, 0x22, 0x6c, 0xe4, 0x4d,
	0x41, 0xe2, 0x26, 0x9a, 0x38, 0x13, 0x33, 0xc4, 0xf6, 0x4c, 0x67, 0xc6, 0x5b, 0xa5, 0x12, 0x3f,
	0xea, 0x0d, 0x97, 0x3c, 0x00, 0xef, 0xc1, 0x03, 0x70, 0xc5, 0x1d, 0xcf, 0xc1, 0x5b, 0x54, 0x99,
	0x19, 0xa7, 0x4e, 0xbb, 0x69, 0xec, 0x74, 0xb5, 0x57, 0xf1, 0x19, 0x9f, 0xf9, 0xce, 0xef, 0x77,
	0x8e, 0x03, 0x90, 0x60, 0x9a, 0xfa, 0x5c, 0x30, 0xc5, 0xd0, 0x0d, 0xf5, 0x90, 0xaa, 0xf0, 0x27,
	0x7f, 0x9c, 0xc5, 0x8a, 0xa5, 0x7e, 0x82, 0xa3, 0x34, 0x93, 0x9c, 0x72, 0x12, 0xd3, 0x94, 0x48,
	0x22, 0x4e, 0x68, 0x48, 0xdc, 0xb7, 0x22, 0xc6, 0xa2, 0x98, 0x34, 0xf5, 0x95, 0x61, 0x36, 0x6e,
	0x2a, 0x9a, 0x10, 0xa9, 0x70, 0xc2, 0x0d, 0x8a, 0x7b, 0x10, 0xb2, 0x11, 0xf1, 0x7f, 0xce, 0xa4,
	0xa2, 0xa9, 0xaf, 0x4e, 0x9a, 0x38, 0x79, 0x94, 0x36, 0xbb, 0x1a, 0xab, 0x67, 0xb1, 0xbe, 0xc5,
	0xc9, 0x70, 0x84, 0xfb, 0x0f, 0xa9, 0xe0, 0x4d, 0x1c, 0x47, 0x4c, 0x9a, 0xab, 0xde, 0x2f, 0x70,
	0xb5, 0x43, 0x54, 0x40, 0x78, 0x6f, 0x12, 0x05, 0xe4, 0x41, 0x46, 0xa4, 0x42, 0x14, 0x5e, 0x21,
	0xa3, 0x88, 0xc8, 0xc1, 0x70, 0x3a, 0x60, 0x82, 0x46, 0x34, 0x6d, 0x38, 0x6f, 0x6f, 0xec, 0xd5,
	0x5b, 0xb7, 0xfd, 0x12, 0xee, 0xfa, 0xcf, 0xe2, 0xb5, 0x47, 0x11, 0xf9, 0x6a, 0x7a, 0xa4, 0x81,
	0x82, 0x1d, 0x8d, 0x9c, 0x8b, 0xde, 0x1f, 0x0e, 0xbc, 0xf1, 0x22, 0x7d, 0xf4, 0x1a, 0x6c, 0xcd,
	0x5d, 0x70, 0xf6, 0xb6, 0x03, 0x2b, 0xa1, 0x23, 0xd8, 0xd4, 0x48, 0x8d, 0x9a, 0xf6, 0xec, 0x60,
	0x6d, 0xcf, 0x02, 0x83, 0xe3, 0x1d, 0xc2, 0xee, 0x69, 0xaf, 0xd1, 0x55, 0xd8, 0x90, 0x22, 0xb4,
	0xd6, 0x67, 0x8f, 0x08, 0xc1, 0x85, 0x11, 0x91, 0xaa, 0x51, 0xd3, 0x47, 0xfa, 0xd9, 0xfb, 0x15,
	0xae, 0x15, 0x6e, 0x4b, 0xce, 0x52, 0x49, 0x10, 0x85, 0x6b, 0x82, 0xf0, 0x01, 0x9f, 0x44, 0xcf,
	0x65, 0xf2, 0xcb, 0xaa, 0xfe, 0x1a, 0xc8, 0x79, 0x1a, 0xaf, 0x08, 0x7d, 0x3e, 0xcf, 0xe3, 0x63,
	0x07, 0x5e, 0x9f, 0x6b, 0x7f, 0x9d, 0x09, 0x41, 0x52, 0x95, 0x97, 0xf3, 0xdc, 0x52, 0xb8, 0xe0,
	0x44, 0xeb, 0xd6, 0x37, 0x2c, 0x13, 0xf2, 0xdc, 0x9d, 0x60, 0xd0, 0x78, 0x3e, 0x11, 0xb6, 0x20,
	0xc7, 0x50, 0xd7, 0x05, 0xc1, 0xe1, 0x04, 0x47, 0x44, 0x7b, 0x52, 0x6f, 0xb5, 0x4a, 0x99, 0xbc,
	0x9b, 0x46, 0x82, 0x48, 0x69, 0xcd, 0xc2, 0x2c, 0xfd, 0x06, 0xc5, 0x7b, 0x50, 0x30, 0x38, 0x0f,
	0xda, 0x1a, 0xbc, 0x0f, 0x97, 0x0b, 0x06, 0xa5, 0x2d, 0xfe, 0x3a, 0x16, 0xeb, 0x4f, 0x2d, 0x4a,
	0xef, 0x3f, 0x07, 0x76, 0x16, 0x5e, 0xa3, 0x1f, 0xe0, 0xa2, 0x6d, 0xb5, 0x4a, 0x0d, 0xb6, 0x00,
	0xe2, 0x9b, 0x9f, 0x76, 0xaa, 0xc4, 0x34, 0xd8, 0x32, 0x0d, 0x86, 0xf6, 0xa1, 0xa6, 0xa4, 0x6e,
	0xf5, 0x7a, 0xcb, 0xf5, 0xcd, 0x20, 0xf2, 0xf3, 0x41, 0xe4, 0xf7, 0xf3, 0x41, 0x14, 0xd4, 0x94,
	0x74, 0x0f, 0xa0, 0x5e, 0x80, 0x98, 0x31, 0x67, 0x42, 0xa6, 0x39, 0x73, 0x26, 0x64, 0x8a, 0x76,
	0x61, 0xf3, 0x04, 0xc7, 0x19, 0xd1, 0x78, 0x1b, 0x81, 0x11, 0x3e, 0xaf, 0x7d, 0xe6, 0x78, 0xff,
	0x3b, 0x70, 0x7d, 0x69, 0xb7, 0x2f, 0x6d, 0x9e, 0xf0, 0x69, 0xd4, 0xa6, 0x7d, 0xee, 0xbd, 0x1c,
	0xad, 0x4e, 0xcd, 0xc0, 0x2e, 0x6c, 0x2a, 0xa6, 0x70, 0xdc, 0xd8, 0x30, 0x4e, 0x6b, 0xe1, 0x65,
	0x62, 0x7d, 0xec, 0xc0, 0xfe, 0x7d, 0x3e, 0xc2, 0x8a, 0x18, 0x84, 0x2e, 0x4b, 0xa9, 0x62, 0x82,
	0xa6, 0x51, 0x40, 0xc6, 0x44, 0x90, 0x34, 0x24, 0x77, 0xb0, 0xc2, 0x39, 0x73, 0xfa, 0x70, 0x45,
	0x31, 0xce, 0x62, 0x16, 0x4d, 0x07, 0x86, 0x2a, 0xa6, 0xc2, 0x37, 0x4b, 0xc5, 0xda, 0xb7, 0x57,
	0x83, 0x9d, 0x1c, 0xa4, 0xad, 0x69, 0x32, 0x81, 0x4b, 0xf9, 0xab, 0xa5, 0xe9, 0xed, 0x2c, 0x72,
	0xf3, 0xa3, 0x4a, 0x06, 0x8b, 0x9c, 0xbc, 0x05, 0x97, 0x8b, 0xc7, 0x25, 0x67, 0x6a, 0x07, 0x3e,
	0x2c, 0x95, 0x26, 0xcb, 0xb5, 0x06, 0x5c, 0x4c, 0x88, 0x94, 0x39, 0xb1, 0xb7, 0x83, 0x5c, 0xf4,
	0xf6, 0x61, 0xef, 0x78, 0x9a, 0x86, 0x65, 0xb2, 0xed, 0xb5, 0xe1, 0x83, 0x12, 0xba, 0x2b, 0x4d,
	0xbe, 0x0f, 0xef, 0x76, 0x88, 0xea, 0x31, 0x6e, 0x80, 0xee, 0x08, 0x3a, 0x56, 0x5d, 0xa2, 0x04,
	0x0d, 0x6f, 0xc7, 0x58, 0x24, 0xf9, 0x58, 0xf4, 0x7e, 0x83, 0xf7, 0x56, 0xe8, 0x59, 0x53, 0xdf,
	0xc3, 0x16, 0xd6, 0x27, 0x95, 0xf8, 0xbd, 0x14, 0x38, 0xb0, 0x68, 0xde, 0x5f, 0x0e, 0x5c, 0x5f,
	0xaa, 0x35, 0x2b, 0x14, 0x67, 0x3c, 0x2f, 0x14, 0x67, 0x7c, 0xd6, 0x2b, 0x89, 0x56, 0xb0, 0xa5,
	0xb2, 0xd2, 0xec, 0x5c, 0x2a, 0xac, 0x32, 0xa9, 0x69, 0xb2, 0x1d, 0x58, 0x09, 0x1d, 0x42, 0x3d,
	0xc6, 0x52, 0x99, 0x42, 0x8e, 0x1a, 0x17, 0x56, 0x0e, 0x92, 0xa2, 0x7a, 0xeb, 0xf7, 0x4b, 0xf0,
	0xea, 0xe2, 0x77, 0xcc, 0xb1, 0x89, 0x0c, 0x3d, 0x82, 0xed, 0x39, 0x8d, 0xd1, 0x27, 0x6b, 0x6d,
	0x0d, 0xf7, 0xd3, 0xf5, 0xa6, 0x05, 0xfa, 0xd3, 0x29, 0x7c, 0x34, 0xd9, 0x1d, 0x83, 0x0e, 0xab,
	0x81, 0x2d, 0xee, 0x68, 0xf7, 0x8b, 0x35, 0x6f, 0x9f, 0xe6, 0x91, 0x5d, 0x42, 0x55, 0x3d, 0x5a,
	0x5c, 0xd8, 0x55, 0x3d, 0x7a, 0x76, 0xf3, 0xfd, 0xeb, 0xc0, 0x8d, 0x12, 0xec, 0x45, 0x47, 0xa5,
	0xcc, 0x94, 0x1f, 0x97, 0x6e, 0xef, 0xec, 0x00, 0x6d, 0x28, 0xff, 0x38, 0xf0, 0xce, 0xca, 0x99,
	0x80, 0xba, 0xa5, 0xec, 0x96, 0x9d, 0x43, 0xee, 0x77, 0x67, 0x05, 0x67, 0x83, 0xf8, 0xdb, 0x81,
	0x37, 0x5f, 0x38, 0x69, 0xd0, 0xdd, 0xb2, 0x05, 0x5f, 0x39, 0xd5, 0xdc, 0x7b, 0x67, 0x01, 0x65,
	0x57, 0x73, 0xf3, 0xc7, 0x9b, 0x95, 0xfe, 0xdd, 0x0c, 0xb7, 0xf4, 0x50, 0xf9, 0xf8, 0x49, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xbb, 0xfe, 0x4b, 0xb3, 0x67, 0x0d, 0x00, 0x00,
}
