// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/MateriaTwirp/twirp.proto

/*
Package MateriaTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/MateriaTwirp/twirp.proto
*/
package MateriaTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =================
// Materia Interface
// =================

type Materia interface {
	// GetEntitlements returns active entitlements for the following different query patterns:
	// 1) By Domain, Source, OwnerID, OriginID and ItemID
	// 2) By Domain, Source, OwnerID
	// 3) By Domain, Source, OwnerID, ItemID
	// 4) By Domain, ItemID, ItemOwnerID
	// 5) By Domain, OwnerID
	// All query patterns support a type field that can be used for filtering of the dynamo query.
	// All GetEntitlements request require the following fields: 1) Domain 2) Owner
	// all other fields can be left empty and Materia will determine which GSI to use for your query
	GetEntitlements(context.Context, *GetEntitlementsRequest) (*GetEntitlementsResponse, error)

	// GetEntitlementsByKeys returns active entitlements by a domain's partition key
	GetEntitlementsByKeys(context.Context, *GetEntitlementsByKeysRequest) (*GetEntitlementsByKeysResponse, error)

	// CreateEntitlements creates a given list of entitlements. CreateEntitlements is does not guarantee idempotency.
	// Prefer UpsertEntitlements over CreateEntitlements.
	CreateEntitlements(context.Context, *CreateEntitlementsRequest) (*CreateEntitlementsResponse, error)

	// DeleteEntitlements deletes a given list of entitlements.
	DeleteEntitlements(context.Context, *DeleteEntitlementsRequest) (*DeleteEntitlementsResponse, error)

	//  UpdateEndsAtByKeys updates the ends_at field for a given list of entitlement keys
	UpdateEndsAtByKeys(context.Context, *UpdateEndsAtByKeysRequest) (*UpdateEndsAtByKeysResponse, error)

	// UpsertEntitlements creates a given list of entitlements. UpsertEntitlements is idempotent
	UpsertEntitlements(context.Context, *UpsertEntitlementsRequest) (*UpsertEntitlementsResponse, error)
}

// =======================
// Materia Protobuf Client
// =======================

type materiaProtobufClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewMateriaProtobufClient creates a Protobuf client that implements the Materia interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewMateriaProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Materia {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + MateriaPathPrefix
	urls := [6]string{
		prefix + "GetEntitlements",
		prefix + "GetEntitlementsByKeys",
		prefix + "CreateEntitlements",
		prefix + "DeleteEntitlements",
		prefix + "UpdateEndsAtByKeys",
		prefix + "UpsertEntitlements",
	}

	return &materiaProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *materiaProtobufClient) GetEntitlements(ctx context.Context, in *GetEntitlementsRequest) (*GetEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlements")
	out := new(GetEntitlementsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaProtobufClient) GetEntitlementsByKeys(ctx context.Context, in *GetEntitlementsByKeysRequest) (*GetEntitlementsByKeysResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlementsByKeys")
	out := new(GetEntitlementsByKeysResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaProtobufClient) CreateEntitlements(ctx context.Context, in *CreateEntitlementsRequest) (*CreateEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "CreateEntitlements")
	out := new(CreateEntitlementsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaProtobufClient) DeleteEntitlements(ctx context.Context, in *DeleteEntitlementsRequest) (*DeleteEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlements")
	out := new(DeleteEntitlementsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaProtobufClient) UpdateEndsAtByKeys(ctx context.Context, in *UpdateEndsAtByKeysRequest) (*UpdateEndsAtByKeysResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEndsAtByKeys")
	out := new(UpdateEndsAtByKeysResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaProtobufClient) UpsertEntitlements(ctx context.Context, in *UpsertEntitlementsRequest) (*UpsertEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "UpsertEntitlements")
	out := new(UpsertEntitlementsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================
// Materia JSON Client
// ===================

type materiaJSONClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewMateriaJSONClient creates a JSON client that implements the Materia interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewMateriaJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Materia {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + MateriaPathPrefix
	urls := [6]string{
		prefix + "GetEntitlements",
		prefix + "GetEntitlementsByKeys",
		prefix + "CreateEntitlements",
		prefix + "DeleteEntitlements",
		prefix + "UpdateEndsAtByKeys",
		prefix + "UpsertEntitlements",
	}

	return &materiaJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *materiaJSONClient) GetEntitlements(ctx context.Context, in *GetEntitlementsRequest) (*GetEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlements")
	out := new(GetEntitlementsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaJSONClient) GetEntitlementsByKeys(ctx context.Context, in *GetEntitlementsByKeysRequest) (*GetEntitlementsByKeysResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlementsByKeys")
	out := new(GetEntitlementsByKeysResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaJSONClient) CreateEntitlements(ctx context.Context, in *CreateEntitlementsRequest) (*CreateEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "CreateEntitlements")
	out := new(CreateEntitlementsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaJSONClient) DeleteEntitlements(ctx context.Context, in *DeleteEntitlementsRequest) (*DeleteEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlements")
	out := new(DeleteEntitlementsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaJSONClient) UpdateEndsAtByKeys(ctx context.Context, in *UpdateEndsAtByKeysRequest) (*UpdateEndsAtByKeysResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEndsAtByKeys")
	out := new(UpdateEndsAtByKeysResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *materiaJSONClient) UpsertEntitlements(ctx context.Context, in *UpsertEntitlementsRequest) (*UpsertEntitlementsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithMethodName(ctx, "UpsertEntitlements")
	out := new(UpsertEntitlementsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================
// Materia Server Handler
// ======================

type materiaServer struct {
	Materia
	hooks *twirp.ServerHooks
}

func NewMateriaServer(svc Materia, hooks *twirp.ServerHooks) TwirpServer {
	return &materiaServer{
		Materia: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *materiaServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// MateriaPathPrefix is used for all URL paths on a twirp Materia server.
// Requests are always: POST MateriaPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const MateriaPathPrefix = "/twirp/twitch.commerce.materia.Materia/"

func (s *materiaServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.commerce.materia")
	ctx = ctxsetters.WithServiceName(ctx, "Materia")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.commerce.materia.Materia/GetEntitlements":
		s.serveGetEntitlements(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.materia.Materia/GetEntitlementsByKeys":
		s.serveGetEntitlementsByKeys(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.materia.Materia/CreateEntitlements":
		s.serveCreateEntitlements(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.materia.Materia/DeleteEntitlements":
		s.serveDeleteEntitlements(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.materia.Materia/UpdateEndsAtByKeys":
		s.serveUpdateEndsAtByKeys(ctx, resp, req)
		return
	case "/twirp/twitch.commerce.materia.Materia/UpsertEntitlements":
		s.serveUpsertEntitlements(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *materiaServer) serveGetEntitlements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEntitlementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEntitlementsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *materiaServer) serveGetEntitlementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEntitlementsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEntitlementsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.GetEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEntitlementsResponse and nil error while calling GetEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveGetEntitlementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEntitlementsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEntitlementsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.GetEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEntitlementsResponse and nil error while calling GetEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveGetEntitlementsByKeys(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEntitlementsByKeysJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEntitlementsByKeysProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *materiaServer) serveGetEntitlementsByKeysJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlementsByKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEntitlementsByKeysRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEntitlementsByKeysResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.GetEntitlementsByKeys(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEntitlementsByKeysResponse and nil error while calling GetEntitlementsByKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveGetEntitlementsByKeysProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEntitlementsByKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEntitlementsByKeysRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEntitlementsByKeysResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.GetEntitlementsByKeys(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEntitlementsByKeysResponse and nil error while calling GetEntitlementsByKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveCreateEntitlements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateEntitlementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateEntitlementsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *materiaServer) serveCreateEntitlementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateEntitlementsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateEntitlementsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.CreateEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEntitlementsResponse and nil error while calling CreateEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveCreateEntitlementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateEntitlementsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateEntitlementsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.CreateEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateEntitlementsResponse and nil error while calling CreateEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveDeleteEntitlements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteEntitlementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteEntitlementsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *materiaServer) serveDeleteEntitlementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteEntitlementsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteEntitlementsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.DeleteEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEntitlementsResponse and nil error while calling DeleteEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveDeleteEntitlementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteEntitlementsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteEntitlementsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.DeleteEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteEntitlementsResponse and nil error while calling DeleteEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveUpdateEndsAtByKeys(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateEndsAtByKeysJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateEndsAtByKeysProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *materiaServer) serveUpdateEndsAtByKeysJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEndsAtByKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateEndsAtByKeysRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateEndsAtByKeysResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.UpdateEndsAtByKeys(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateEndsAtByKeysResponse and nil error while calling UpdateEndsAtByKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveUpdateEndsAtByKeysProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateEndsAtByKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateEndsAtByKeysRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateEndsAtByKeysResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.UpdateEndsAtByKeys(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateEndsAtByKeysResponse and nil error while calling UpdateEndsAtByKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveUpsertEntitlements(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpsertEntitlementsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpsertEntitlementsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *materiaServer) serveUpsertEntitlementsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpsertEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpsertEntitlementsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpsertEntitlementsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.UpsertEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpsertEntitlementsResponse and nil error while calling UpsertEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) serveUpsertEntitlementsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpsertEntitlements")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpsertEntitlementsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpsertEntitlementsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Materia.UpsertEntitlements(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpsertEntitlementsResponse and nil error while calling UpsertEntitlements. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *materiaServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *materiaServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *materiaServer) PathPrefix() string {
	return MateriaPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1507 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0x5f, 0x6f, 0xdb, 0x46,
	0x12, 0x0f, 0xf5, 0x5f, 0x23, 0x5b, 0x66, 0x16, 0x48, 0x2c, 0xcb, 0x49, 0xac, 0x23, 0x72, 0x88,
	0xcf, 0x38, 0xc8, 0x81, 0x93, 0x73, 0xee, 0x5e, 0x0e, 0xa0, 0x28, 0x3a, 0x26, 0x1c, 0x51, 0xc6,
	0x92, 0xce, 0x21, 0xf7, 0x70, 0x04, 0x43, 0xae, 0x1c, 0xde, 0x99, 0xa4, 0x8e, 0x5c, 0x35, 0x55,
	0x8a, 0x3c, 0xb5, 0x28, 0xfa, 0xd4, 0x8f, 0xd2, 0x3e, 0xf5, 0xa1, 0x2f, 0x05, 0xfa, 0x19, 0xfa,
	0x7d, 0x8a, 0x62, 0x97, 0x94, 0x2d, 0x59, 0xa2, 0x1c, 0x07, 0x6e, 0x8b, 0xbe, 0x24, 0xbb, 0x33,
	0xf3, 0x9b, 0x7f, 0x9c, 0xd9, 0x19, 0x0b, 0xfe, 0xea, 0x84, 0x2e, 0x69, 0xff, 0x77, 0x14, 0x53,
	0x2f, 0x68, 0xd3, 0x4f, 0x76, 0x6d, 0xff, 0x5d, 0xb0, 0xdb, 0xb3, 0x29, 0x89, 0x3c, 0xdb, 0x7c,
	0xeb, 0x45, 0xc3, 0x5d, 0xca, 0xfe, 0x6d, 0x0f, 0xa3, 0x90, 0x86, 0x68, 0x9d, 0xbe, 0xf5, 0xa8,
	0xf3, 0xa6, 0xed, 0x84, 0xbe, 0x4f, 0x22, 0x87, 0xb4, 0xfd, 0x44, 0xb2, 0xb9, 0x75, 0x1a, 0x86,
	0xa7, 0x67, 0x64, 0x97, 0x8b, 0xbd, 0x1e, 0x0d, 0x76, 0xa9, 0xe7, 0x93, 0x98, 0xda, 0x7e, 0x8a,
	0x94, 0xbe, 0x2b, 0x42, 0x4d, 0x0d, 0xa8, 0x47, 0xcf, 0x88, 0x4f, 0x02, 0x8a, 0x9e, 0x41, 0xc9,
	0x0d, 0x7d, 0xdb, 0x0b, 0x1a, 0x42, 0x4b, 0xd8, 0xae, 0xef, 0x6d, 0xb5, 0x33, 0x54, 0xb7, 0xbb,
	0x5c, 0x0c, 0xa7, 0xe2, 0x0c, 0x18, 0x87, 0xa3, 0xc8, 0x21, 0x8d, 0xdc, 0x15, 0x40, 0x83, 0x8b,
	0xe1, 0x54, 0x1c, 0xad, 0x43, 0xd9, 0xa3, 0xc4, 0xb7, 0x3c, 0xb7, 0x91, 0x6f, 0x09, 0xdb, 0x55,
	0x5c, 0x62, 0x57, 0xcd, 0x45, 0x12, 0xac, 0x72, 0x46, 0xf8, 0x36, 0x20, 0x11, 0x63, 0x17, 0x38,
	0xbb, 0xc6, 0x88, 0x7d, 0x46, 0xd3, 0x5c, 0xb4, 0x01, 0x95, 0x73, 0x76, 0x91, 0xb3, 0xcb, 0x61,
	0xca, 0x42, 0x50, 0xa0, 0xe3, 0x21, 0x69, 0x94, 0x38, 0x99, 0x9f, 0xd1, 0x26, 0x54, 0xc3, 0xc8,
	0x3b, 0xf5, 0x02, 0x26, 0x5f, 0xe6, 0x8c, 0x4a, 0x42, 0xd0, 0x5c, 0xf4, 0x0c, 0xaa, 0x31, 0xb5,
	0x23, 0x1a, 0x5b, 0x36, 0x6d, 0x54, 0x5a, 0xc2, 0x76, 0x6d, 0xaf, 0xd9, 0x4e, 0xf2, 0xd7, 0x9e,
	0xe4, 0xaf, 0x6d, 0x4e, 0xf2, 0x87, 0x2b, 0x89, 0xb0, 0x4c, 0xd1, 0x3f, 0xa1, 0x4c, 0x02, 0x97,
	0xc3, 0xaa, 0x1c, 0xf6, 0xe7, 0xcc, 0xd8, 0xb5, 0x60, 0xe0, 0x05, 0x1e, 0x25, 0x4c, 0x0d, 0x2e,
	0x31, 0x94, 0x4c, 0x99, 0xa7, 0x3e, 0xa1, 0x76, 0x03, 0x5a, 0xc2, 0xf6, 0x0a, 0xe6, 0x67, 0xf4,
	0x27, 0x58, 0x19, 0x8e, 0x22, 0xe7, 0x8d, 0x1d, 0x27, 0xc1, 0xd5, 0x92, 0xd8, 0xcf, 0x69, 0x9a,
	0x8b, 0xea, 0x90, 0xf3, 0xdc, 0xc6, 0x0a, 0x67, 0xe4, 0x3c, 0x17, 0xdd, 0x85, 0x92, 0x33, 0x8a,
	0xe2, 0x30, 0x6a, 0xac, 0x26, 0x79, 0x4c, 0x6e, 0xe8, 0x1f, 0x00, 0x4e, 0x44, 0x6c, 0x4a, 0x5c,
	0xe6, 0x61, 0xfd, 0xca, 0xc0, 0xaa, 0xa9, 0xb4, 0x4c, 0x19, 0x74, 0x34, 0x74, 0x27, 0xd0, 0xb5,
	0xab, 0xa1, 0xa9, 0xb4, 0x4c, 0xd1, 0x0b, 0xa8, 0xb9, 0x51, 0x38, 0x8c, 0xad, 0x81, 0xed, 0x10,
	0xda, 0x10, 0x39, 0xf6, 0x2f, 0xd9, 0xd5, 0xc4, 0x64, 0xa7, 0x0a, 0xf1, 0xf0, 0x16, 0x06, 0x8e,
	0x3f, 0x60, 0xf0, 0xce, 0x1a, 0xac, 0x26, 0x75, 0x96, 0xa8, 0x8b, 0x25, 0x0b, 0x56, 0xa6, 0x73,
	0x89, 0xda, 0x50, 0x60, 0xa5, 0xcd, 0xab, 0x76, 0xb9, 0x8f, 0x5c, 0x0e, 0x6d, 0x41, 0xcd, 0x8b,
	0x2d, 0x2f, 0x55, 0xc1, 0x6b, 0xb6, 0x82, 0xc1, 0x8b, 0x27, 0x4a, 0xa5, 0x9f, 0x04, 0xa8, 0x4f,
	0xf9, 0x73, 0x44, 0xc6, 0xbf, 0x43, 0x6f, 0x4c, 0x97, 0x77, 0x7e, 0xb6, 0xbc, 0xa7, 0xda, 0xa6,
	0x30, 0xd3, 0x36, 0x33, 0x35, 0x5e, 0x9c, 0xad, 0x71, 0xe9, 0xab, 0x22, 0xdc, 0x7d, 0x4e, 0xe8,
	0x54, 0x60, 0x31, 0x26, 0xff, 0x1f, 0x91, 0x98, 0xce, 0xd8, 0x12, 0x66, 0x6d, 0x7d, 0xb4, 0xff,
	0x17, 0x19, 0xcb, 0x5f, 0x2f, 0x63, 0x33, 0x41, 0x14, 0x2e, 0x35, 0xea, 0x54, 0xe8, 0xc5, 0x99,
	0xd0, 0x17, 0xb5, 0xfc, 0xdc, 0x2b, 0x52, 0x9e, 0x7f, 0x45, 0x2e, 0x3a, 0xa7, 0x32, 0xd3, 0x39,
	0x9b, 0x50, 0x1d, 0xda, 0xa7, 0xc4, 0x8a, 0xbd, 0x77, 0x84, 0xb7, 0x76, 0x1e, 0x57, 0x18, 0xc1,
	0xf0, 0xde, 0x11, 0xb4, 0x0f, 0xa5, 0x98, 0xda, 0x94, 0xc4, 0x0d, 0x68, 0xe5, 0xb7, 0xeb, 0x7b,
	0x0f, 0xb2, 0x93, 0xc2, 0xc4, 0x70, 0x2a, 0x8d, 0x9e, 0x42, 0x31, 0x8c, 0x5c, 0x12, 0xf1, 0x96,
	0x5e, 0x06, 0xeb, 0x33, 0x29, 0x9c, 0x08, 0xa3, 0xbf, 0x43, 0x39, 0x0e, 0x23, 0x6a, 0xbd, 0x1e,
	0xf3, 0x8e, 0x5f, 0xfe, 0x0d, 0x22, 0xda, 0x19, 0xb3, 0x6f, 0xc0, 0xfe, 0x47, 0x8f, 0x60, 0xcd,
	0x09, 0x83, 0xd8, 0x8b, 0x29, 0x09, 0xa8, 0x15, 0x11, 0xdb, 0xe5, 0xef, 0x43, 0x05, 0xd7, 0x2f,
	0xc8, 0x98, 0xd8, 0x93, 0xf7, 0xa4, 0x7e, 0xfe, 0x9e, 0x5c, 0xea, 0xe0, 0xb5, 0x1b, 0xee, 0xe0,
	0x08, 0xc4, 0xcb, 0x10, 0xf4, 0x1f, 0x40, 0x83, 0xd1, 0xd9, 0xc0, 0x3b, 0x3b, 0x63, 0x57, 0x8b,
	0x65, 0x6c, 0x14, 0xa7, 0xdd, 0xb6, 0xbb, 0xdc, 0xf2, 0xc1, 0x05, 0xce, 0xe0, 0x30, 0x7c, 0x7b,
	0x70, 0x99, 0x24, 0x7d, 0x2f, 0xc0, 0xfa, 0x5c, 0xf9, 0xc7, 0xc3, 0x30, 0x88, 0x09, 0x3a, 0x84,
	0x15, 0x32, 0x45, 0x6f, 0x08, 0xad, 0xfc, 0x76, 0x6d, 0xef, 0x61, 0xa6, 0xd5, 0x29, 0x25, 0x78,
	0x06, 0x39, 0x55, 0x4e, 0xb9, 0x99, 0x72, 0xba, 0x0f, 0xe0, 0x05, 0x2e, 0xf9, 0xd4, 0x0a, 0x6c,
	0x9f, 0xa4, 0xfd, 0x5c, 0xe5, 0x14, 0xdd, 0xf6, 0x09, 0x63, 0x0f, 0xa2, 0xd0, 0xb7, 0x1c, 0xdb,
	0x79, 0x43, 0x78, 0xd1, 0x57, 0x70, 0x95, 0x51, 0x14, 0x46, 0x90, 0x7e, 0x14, 0xe0, 0xde, 0x25,
	0xdf, 0x3b, 0xe3, 0x23, 0x32, 0x3e, 0x6f, 0xe0, 0x97, 0x20, 0x4e, 0xb9, 0x61, 0xfd, 0x8f, 0x8c,
	0x27, 0x41, 0x3c, 0xfa, 0x90, 0x20, 0x8e, 0xc8, 0xb8, 0x93, 0x6b, 0x08, 0x78, 0x8d, 0xcc, 0xd0,
	0x62, 0x24, 0x42, 0xde, 0x73, 0xe3, 0x46, 0xae, 0x95, 0xdf, 0xae, 0x62, 0x76, 0xfc, 0xe8, 0xb6,
	0x96, 0x3c, 0xb8, 0x9f, 0x11, 0xc2, 0x4d, 0x7f, 0x04, 0x89, 0xc0, 0x86, 0xc2, 0xe7, 0xd8, 0xa2,
	0xb7, 0xee, 0xe6, 0xcc, 0x0c, 0xa0, 0xb9, 0xc8, 0xcc, 0x8d, 0x87, 0xf3, 0x83, 0x00, 0x1b, 0x5d,
	0x72, 0x46, 0x16, 0xc7, 0xf3, 0x07, 0xf8, 0xf4, 0xfb, 0xd0, 0x5c, 0xe4, 0x7f, 0x9a, 0xa8, 0x06,
	0x94, 0xe3, 0x91, 0xe3, 0x90, 0x38, 0xe9, 0xf6, 0x0a, 0x9e, 0x5c, 0xa5, 0x9f, 0x05, 0xd8, 0x38,
	0xe1, 0x5b, 0x85, 0xca, 0xb7, 0xa5, 0xdf, 0xa6, 0xe6, 0xa7, 0x56, 0xba, 0xdc, 0xc7, 0xac, 0x74,
	0x69, 0xe2, 0xf2, 0x8b, 0x12, 0x57, 0xb8, 0x5e, 0xe2, 0xee, 0x41, 0x73, 0x51, 0xfc, 0x49, 0xe2,
	0xa4, 0xaf, 0x79, 0x7a, 0x62, 0x12, 0xd1, 0x5f, 0xb5, 0xce, 0xd9, 0x14, 0xf1, 0x5c, 0xe2, 0x0f,
	0x43, 0x4a, 0x02, 0x67, 0xcc, 0x12, 0x9d, 0x3e, 0x6e, 0xf5, 0x29, 0xf2, 0x11, 0x19, 0x4b, 0xdf,
	0x08, 0xcc, 0xdf, 0x79, 0x87, 0x6e, 0xfc, 0x95, 0x3d, 0x80, 0x22, 0x89, 0xa2, 0xf4, 0x91, 0xad,
	0xed, 0x3d, 0xce, 0x54, 0x31, 0xef, 0x8d, 0xca, 0x70, 0x38, 0x81, 0x4b, 0x0e, 0xac, 0x67, 0x48,
	0xa0, 0x43, 0x28, 0xb0, 0x3f, 0xc3, 0xd2, 0xad, 0xe7, 0xe9, 0x75, 0x2d, 0x28, 0xa1, 0x4b, 0x30,
	0xd7, 0xb0, 0xd3, 0x87, 0x52, 0xf2, 0x59, 0xd1, 0x1a, 0xd4, 0xba, 0xfd, 0x9e, 0xac, 0xe9, 0x96,
	0xde, 0xd7, 0x55, 0xf1, 0x16, 0x02, 0x28, 0xa9, 0xbd, 0xbe, 0xa9, 0x1a, 0xa2, 0xc0, 0xce, 0x1d,
	0xb9, 0xfb, 0x5c, 0x35, 0xc4, 0x1c, 0xaa, 0x42, 0xb1, 0x8b, 0xfb, 0xc7, 0x86, 0x98, 0x47, 0xb7,
	0x61, 0xd5, 0x38, 0xe9, 0x18, 0x0a, 0xd6, 0x8e, 0x4d, 0xad, 0xaf, 0x1b, 0x62, 0x61, 0xe7, 0x33,
	0x28, 0x25, 0xbb, 0x16, 0x53, 0x68, 0xf4, 0x4f, 0xb0, 0xa2, 0x4e, 0x14, 0x22, 0xa8, 0x2b, 0x87,
	0xb2, 0xae, 0xab, 0x2f, 0xac, 0xe3, 0xbe, 0xa6, 0x9b, 0x4c, 0x71, 0x05, 0x0a, 0x4c, 0x83, 0x98,
	0x63, 0xa7, 0x8e, 0x66, 0x32, 0xad, 0x75, 0x80, 0xc3, 0x57, 0xc7, 0xaa, 0x65, 0x62, 0x59, 0xd3,
	0xc5, 0x02, 0xe3, 0x30, 0x83, 0x62, 0x11, 0xd5, 0xa0, 0x8c, 0xd5, 0x7f, 0xc9, 0xb8, 0x6b, 0x88,
	0x25, 0x66, 0xbc, 0xa7, 0x3e, 0x97, 0x2d, 0xa5, 0xdf, 0xeb, 0xa9, 0x58, 0x51, 0xc5, 0xf2, 0xce,
	0x3e, 0x14, 0xf9, 0x72, 0xc2, 0x54, 0xf0, 0xc3, 0xc4, 0xf4, 0xf9, 0xbd, 0xab, 0x1a, 0x8a, 0x28,
	0xa0, 0x55, 0xa8, 0x26, 0x77, 0xd9, 0x50, 0xc4, 0xdc, 0x4e, 0x97, 0x39, 0xcd, 0x97, 0x12, 0xe6,
	0x34, 0x3f, 0x59, 0x7a, 0x18, 0x10, 0xf1, 0x16, 0xba, 0x03, 0xb7, 0x53, 0x82, 0x82, 0x55, 0xd9,
	0x54, 0xbb, 0x96, 0x6c, 0x8a, 0x02, 0x8b, 0x25, 0x25, 0xab, 0x7a, 0xd7, 0x60, 0xb4, 0xdc, 0xce,
	0xe7, 0x02, 0xdc, 0x5d, 0x3c, 0xf2, 0xd1, 0x16, 0x6c, 0x2e, 0xe6, 0x4c, 0xcc, 0x48, 0xf0, 0x20,
	0x43, 0x40, 0x39, 0xb3, 0x3d, 0x9f, 0xb8, 0xa2, 0x80, 0x1e, 0x42, 0x2b, 0x43, 0x26, 0xa5, 0x10,
	0x57, 0xcc, 0xed, 0xf4, 0xa1, 0xc8, 0xf7, 0x3a, 0x16, 0xb3, 0x61, 0xca, 0xe6, 0x79, 0xfa, 0x45,
	0x58, 0x49, 0xee, 0xb2, 0x62, 0x6a, 0x2f, 0xd5, 0x34, 0x08, 0x4e, 0xd1, 0xf4, 0x94, 0x96, 0xbb,
	0x90, 0x3a, 0x38, 0x31, 0x4f, 0xb0, 0x2a, 0xe6, 0x77, 0xbe, 0x15, 0x60, 0x73, 0x49, 0x21, 0x31,
	0xb7, 0x96, 0xb0, 0x27, 0xd6, 0x9f, 0xc2, 0xe3, 0x65, 0x52, 0x5a, 0x57, 0xed, 0x1d, 0xf7, 0x4d,
	0x55, 0x57, 0x5e, 0x59, 0x3d, 0xcd, 0xe8, 0xc9, 0xa6, 0x72, 0x28, 0x0a, 0x57, 0xa1, 0x4c, 0x2c,
	0xeb, 0x06, 0x73, 0xbd, 0xaf, 0x5b, 0x8a, 0xac, 0x2b, 0xea, 0x0b, 0xb5, 0x2b, 0xe6, 0xf6, 0xbe,
	0x28, 0x41, 0x39, 0xfd, 0x49, 0x02, 0x51, 0x58, 0xbb, 0x34, 0xd9, 0x51, 0xf6, 0xc2, 0xb6, 0xf8,
	0x2f, 0x90, 0xe6, 0xe3, 0x0f, 0x07, 0xa4, 0xaf, 0xc9, 0x97, 0x02, 0xdc, 0x59, 0xb8, 0x50, 0xa0,
	0xbf, 0x7d, 0xa8, 0xae, 0x99, 0x79, 0xd2, 0xdc, 0xbf, 0x2e, 0x2c, 0x75, 0xe4, 0x3d, 0xa0, 0xf9,
	0x35, 0x00, 0xed, 0x65, 0x6a, 0xcb, 0x5c, 0x4d, 0x9a, 0x4f, 0xae, 0x85, 0xb9, 0x30, 0x3f, 0x3f,
	0x5c, 0x97, 0x98, 0xcf, 0xdc, 0x24, 0x96, 0x98, 0x5f, 0x32, 0xbd, 0xdf, 0x03, 0x9a, 0x1f, 0x51,
	0x4b, 0xcc, 0x67, 0xce, 0xf3, 0x25, 0xe6, 0xb3, 0x67, 0x60, 0x62, 0xfe, 0x72, 0xf5, 0x2e, 0x35,
	0x9f, 0x31, 0x2f, 0x97, 0x9a, 0xcf, 0x1a, 0x69, 0x1d, 0xe9, 0xdf, 0xad, 0xab, 0x7e, 0xac, 0x7b,
	0x5d, 0xe2, 0x3f, 0x44, 0x3c, 0xf9, 0x25, 0x00, 0x00, 0xff, 0xff, 0x7e, 0xc1, 0xab, 0xbd, 0xd7,
	0x13, 0x00, 0x00,
}
