// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/MetapodTwirp/twirp.proto

/*
Package MetapodTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/MetapodTwirp/twirp.proto
*/
package MetapodTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =================
// Metapod Interface
// =================

type Metapod interface {
	RegisterSchema(context.Context, *RegisterSchemaReq) (*SchemaResp, error)

	UpdateSchema(context.Context, *UpdateSchemaReq) (*SchemaResp, error)

	GetSchema(context.Context, *GetSchemaReq) (*SchemaResp, error)

	CreateDocument(context.Context, *CreateDocumentReq) (*DocumentResp, error)

	GetDocument(context.Context, *GetDocumentReq) (*DocumentResp, error)

	GetDocumentForEntity(context.Context, *GetDocumentForEntityReq) (*DocumentResp, error)

	UpdateDocument(context.Context, *UpdateDocumentReq) (*DocumentResp, error)

	PatchDocument(context.Context, *PatchDocumentReq) (*DocumentResp, error)

	DeleteDocument(context.Context, *DeleteDocumentReq) (*DeleteDocumentResp, error)

	QueryDocuments(context.Context, *QueryDocumentsReq) (*QueryDocumentsResp, error)

	GetDocumentHistory(context.Context, *GetHistoryReq) (*QueryDocumentsResp, error)

	GetSchemaHistory(context.Context, *GetHistoryReq) (*SchemasResp, error)

	QueryByEntity(context.Context, *QueryByEntityReq) (*QueryDocumentsResp, error)

	QueryLogEntries(context.Context, *QueryByEntityReq) (*QueryLogEntriesResp, error)
}

// =======================
// Metapod Protobuf Client
// =======================

type metapodProtobufClient struct {
	client HTTPClient
	urls   [14]string
	opts   twirp.ClientOptions
}

// NewMetapodProtobufClient creates a Protobuf client that implements the Metapod interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewMetapodProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Metapod {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + MetapodPathPrefix
	urls := [14]string{
		prefix + "RegisterSchema",
		prefix + "UpdateSchema",
		prefix + "GetSchema",
		prefix + "CreateDocument",
		prefix + "GetDocument",
		prefix + "GetDocumentForEntity",
		prefix + "UpdateDocument",
		prefix + "PatchDocument",
		prefix + "DeleteDocument",
		prefix + "QueryDocuments",
		prefix + "GetDocumentHistory",
		prefix + "GetSchemaHistory",
		prefix + "QueryByEntity",
		prefix + "QueryLogEntries",
	}

	return &metapodProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *metapodProtobufClient) RegisterSchema(ctx context.Context, in *RegisterSchemaReq) (*SchemaResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterSchema")
	out := new(SchemaResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) UpdateSchema(ctx context.Context, in *UpdateSchemaReq) (*SchemaResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSchema")
	out := new(SchemaResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) GetSchema(ctx context.Context, in *GetSchemaReq) (*SchemaResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetSchema")
	out := new(SchemaResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) CreateDocument(ctx context.Context, in *CreateDocumentReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "CreateDocument")
	out := new(DocumentResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) GetDocument(ctx context.Context, in *GetDocumentReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetDocument")
	out := new(DocumentResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) GetDocumentForEntity(ctx context.Context, in *GetDocumentForEntityReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetDocumentForEntity")
	out := new(DocumentResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) UpdateDocument(ctx context.Context, in *UpdateDocumentReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDocument")
	out := new(DocumentResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) PatchDocument(ctx context.Context, in *PatchDocumentReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "PatchDocument")
	out := new(DocumentResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) DeleteDocument(ctx context.Context, in *DeleteDocumentReq) (*DeleteDocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDocument")
	out := new(DeleteDocumentResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) QueryDocuments(ctx context.Context, in *QueryDocumentsReq) (*QueryDocumentsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "QueryDocuments")
	out := new(QueryDocumentsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) GetDocumentHistory(ctx context.Context, in *GetHistoryReq) (*QueryDocumentsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetDocumentHistory")
	out := new(QueryDocumentsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) GetSchemaHistory(ctx context.Context, in *GetHistoryReq) (*SchemasResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetSchemaHistory")
	out := new(SchemasResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) QueryByEntity(ctx context.Context, in *QueryByEntityReq) (*QueryDocumentsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "QueryByEntity")
	out := new(QueryDocumentsResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodProtobufClient) QueryLogEntries(ctx context.Context, in *QueryByEntityReq) (*QueryLogEntriesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "QueryLogEntries")
	out := new(QueryLogEntriesResp)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================
// Metapod JSON Client
// ===================

type metapodJSONClient struct {
	client HTTPClient
	urls   [14]string
	opts   twirp.ClientOptions
}

// NewMetapodJSONClient creates a JSON client that implements the Metapod interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewMetapodJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) Metapod {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + MetapodPathPrefix
	urls := [14]string{
		prefix + "RegisterSchema",
		prefix + "UpdateSchema",
		prefix + "GetSchema",
		prefix + "CreateDocument",
		prefix + "GetDocument",
		prefix + "GetDocumentForEntity",
		prefix + "UpdateDocument",
		prefix + "PatchDocument",
		prefix + "DeleteDocument",
		prefix + "QueryDocuments",
		prefix + "GetDocumentHistory",
		prefix + "GetSchemaHistory",
		prefix + "QueryByEntity",
		prefix + "QueryLogEntries",
	}

	return &metapodJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *metapodJSONClient) RegisterSchema(ctx context.Context, in *RegisterSchemaReq) (*SchemaResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterSchema")
	out := new(SchemaResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) UpdateSchema(ctx context.Context, in *UpdateSchemaReq) (*SchemaResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSchema")
	out := new(SchemaResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) GetSchema(ctx context.Context, in *GetSchemaReq) (*SchemaResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetSchema")
	out := new(SchemaResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) CreateDocument(ctx context.Context, in *CreateDocumentReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "CreateDocument")
	out := new(DocumentResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) GetDocument(ctx context.Context, in *GetDocumentReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetDocument")
	out := new(DocumentResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) GetDocumentForEntity(ctx context.Context, in *GetDocumentForEntityReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetDocumentForEntity")
	out := new(DocumentResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) UpdateDocument(ctx context.Context, in *UpdateDocumentReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDocument")
	out := new(DocumentResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) PatchDocument(ctx context.Context, in *PatchDocumentReq) (*DocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "PatchDocument")
	out := new(DocumentResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) DeleteDocument(ctx context.Context, in *DeleteDocumentReq) (*DeleteDocumentResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDocument")
	out := new(DeleteDocumentResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) QueryDocuments(ctx context.Context, in *QueryDocumentsReq) (*QueryDocumentsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "QueryDocuments")
	out := new(QueryDocumentsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) GetDocumentHistory(ctx context.Context, in *GetHistoryReq) (*QueryDocumentsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetDocumentHistory")
	out := new(QueryDocumentsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) GetSchemaHistory(ctx context.Context, in *GetHistoryReq) (*SchemasResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "GetSchemaHistory")
	out := new(SchemasResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) QueryByEntity(ctx context.Context, in *QueryByEntityReq) (*QueryDocumentsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "QueryByEntity")
	out := new(QueryDocumentsResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *metapodJSONClient) QueryLogEntries(ctx context.Context, in *QueryByEntityReq) (*QueryLogEntriesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithMethodName(ctx, "QueryLogEntries")
	out := new(QueryLogEntriesResp)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================
// Metapod Server Handler
// ======================

type metapodServer struct {
	Metapod
	hooks *twirp.ServerHooks
}

func NewMetapodServer(svc Metapod, hooks *twirp.ServerHooks) TwirpServer {
	return &metapodServer{
		Metapod: svc,
		hooks:   hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *metapodServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// MetapodPathPrefix is used for all URL paths on a twirp Metapod server.
// Requests are always: POST MetapodPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const MetapodPathPrefix = "/twirp/twitch.builderproducts.metapod.Metapod/"

func (s *metapodServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.builderproducts.metapod")
	ctx = ctxsetters.WithServiceName(ctx, "Metapod")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.builderproducts.metapod.Metapod/RegisterSchema":
		s.serveRegisterSchema(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/UpdateSchema":
		s.serveUpdateSchema(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/GetSchema":
		s.serveGetSchema(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/CreateDocument":
		s.serveCreateDocument(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/GetDocument":
		s.serveGetDocument(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/GetDocumentForEntity":
		s.serveGetDocumentForEntity(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/UpdateDocument":
		s.serveUpdateDocument(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/PatchDocument":
		s.servePatchDocument(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/DeleteDocument":
		s.serveDeleteDocument(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/QueryDocuments":
		s.serveQueryDocuments(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/GetDocumentHistory":
		s.serveGetDocumentHistory(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/GetSchemaHistory":
		s.serveGetSchemaHistory(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/QueryByEntity":
		s.serveQueryByEntity(ctx, resp, req)
		return
	case "/twirp/twitch.builderproducts.metapod.Metapod/QueryLogEntries":
		s.serveQueryLogEntries(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *metapodServer) serveRegisterSchema(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterSchemaJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterSchemaProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveRegisterSchemaJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterSchema")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterSchemaReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SchemaResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.RegisterSchema(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SchemaResp and nil error while calling RegisterSchema. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveRegisterSchemaProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterSchema")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RegisterSchemaReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SchemaResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.RegisterSchema(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SchemaResp and nil error while calling RegisterSchema. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveUpdateSchema(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateSchemaJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateSchemaProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveUpdateSchemaJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSchema")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateSchemaReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SchemaResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.UpdateSchema(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SchemaResp and nil error while calling UpdateSchema. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveUpdateSchemaProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateSchema")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateSchemaReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SchemaResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.UpdateSchema(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SchemaResp and nil error while calling UpdateSchema. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetSchema(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSchemaJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSchemaProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveGetSchemaJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSchema")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetSchemaReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SchemaResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetSchema(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SchemaResp and nil error while calling GetSchema. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetSchemaProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSchema")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetSchemaReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SchemaResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetSchema(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SchemaResp and nil error while calling GetSchema. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveCreateDocument(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateDocumentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateDocumentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveCreateDocumentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateDocumentReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.CreateDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling CreateDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveCreateDocumentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateDocumentReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.CreateDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling CreateDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetDocument(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDocumentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDocumentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveGetDocumentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetDocumentReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling GetDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetDocumentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetDocumentReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling GetDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetDocumentForEntity(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDocumentForEntityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDocumentForEntityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveGetDocumentForEntityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDocumentForEntity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetDocumentForEntityReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetDocumentForEntity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling GetDocumentForEntity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetDocumentForEntityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDocumentForEntity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetDocumentForEntityReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetDocumentForEntity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling GetDocumentForEntity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveUpdateDocument(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateDocumentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateDocumentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveUpdateDocumentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateDocumentReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.UpdateDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling UpdateDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveUpdateDocumentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateDocumentReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.UpdateDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling UpdateDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) servePatchDocument(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePatchDocumentJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePatchDocumentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) servePatchDocumentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PatchDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PatchDocumentReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.PatchDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling PatchDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) servePatchDocumentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PatchDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PatchDocumentReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.PatchDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DocumentResp and nil error while calling PatchDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveDeleteDocument(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteDocumentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteDocumentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveDeleteDocumentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteDocumentReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteDocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.DeleteDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteDocumentResp and nil error while calling DeleteDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveDeleteDocumentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteDocument")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteDocumentReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteDocumentResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.DeleteDocument(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteDocumentResp and nil error while calling DeleteDocument. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveQueryDocuments(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueryDocumentsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueryDocumentsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveQueryDocumentsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryDocuments")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueryDocumentsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryDocumentsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.QueryDocuments(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryDocumentsResp and nil error while calling QueryDocuments. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveQueryDocumentsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryDocuments")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueryDocumentsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryDocumentsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.QueryDocuments(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryDocumentsResp and nil error while calling QueryDocuments. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetDocumentHistory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetDocumentHistoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetDocumentHistoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveGetDocumentHistoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDocumentHistory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetHistoryReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryDocumentsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetDocumentHistory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryDocumentsResp and nil error while calling GetDocumentHistory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetDocumentHistoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetDocumentHistory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetHistoryReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryDocumentsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetDocumentHistory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryDocumentsResp and nil error while calling GetDocumentHistory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetSchemaHistory(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSchemaHistoryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSchemaHistoryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveGetSchemaHistoryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSchemaHistory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetHistoryReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SchemasResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetSchemaHistory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SchemasResp and nil error while calling GetSchemaHistory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveGetSchemaHistoryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSchemaHistory")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetHistoryReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SchemasResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.GetSchemaHistory(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SchemasResp and nil error while calling GetSchemaHistory. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveQueryByEntity(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueryByEntityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueryByEntityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveQueryByEntityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryByEntity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueryByEntityReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryDocumentsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.QueryByEntity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryDocumentsResp and nil error while calling QueryByEntity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveQueryByEntityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryByEntity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueryByEntityReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryDocumentsResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.QueryByEntity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryDocumentsResp and nil error while calling QueryByEntity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveQueryLogEntries(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveQueryLogEntriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveQueryLogEntriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *metapodServer) serveQueryLogEntriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryLogEntries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(QueryByEntityReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryLogEntriesResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.QueryLogEntries(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryLogEntriesResp and nil error while calling QueryLogEntries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) serveQueryLogEntriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "QueryLogEntries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(QueryByEntityReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *QueryLogEntriesResp
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.Metapod.QueryLogEntries(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *QueryLogEntriesResp and nil error while calling QueryLogEntries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *metapodServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *metapodServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *metapodServer) PathPrefix() string {
	return MetapodPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1117 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xdf, 0x6e, 0xe3, 0xc4,
	0x17, 0xfe, 0x39, 0x69, 0x9b, 0xe4, 0x24, 0xf1, 0x3a, 0xf3, 0xdb, 0x85, 0x10, 0x04, 0x5b, 0x19,
	0x2e, 0xaa, 0xb2, 0x38, 0xd0, 0x45, 0x42, 0xdc, 0x80, 0x92, 0xc6, 0x2d, 0x11, 0xdb, 0x6c, 0x71,
	0x9c, 0xa2, 0xe5, 0x5f, 0xe4, 0x78, 0xa6, 0xa9, 0xd9, 0xc6, 0x4e, 0xed, 0xf1, 0x76, 0x8d, 0xe0,
	0x01, 0x90, 0x78, 0x0e, 0xae, 0x78, 0x13, 0xee, 0xb9, 0xe3, 0x5d, 0x90, 0x3d, 0x76, 0x62, 0x3b,
	0x51, 0x9c, 0xa4, 0x15, 0x37, 0x95, 0xe7, 0xf8, 0x1c, 0x7f, 0x67, 0xce, 0x77, 0xce, 0xcc, 0xd7,
	0xc0, 0x13, 0xdd, 0xc2, 0x44, 0xfa, 0xc9, 0x75, 0xa8, 0x61, 0x4a, 0xf4, 0x55, 0x53, 0x9b, 0xfc,
	0x6c, 0x36, 0xcf, 0x08, 0xd5, 0xa6, 0x16, 0x56, 0x6f, 0x0d, 0x7b, 0xda, 0xa4, 0xfe, 0x5f, 0x69,
	0x6a, 0x5b, 0xd4, 0x42, 0xef, 0xd2, 0x5b, 0x83, 0xea, 0x57, 0xd2, 0xc8, 0x35, 0xae, 0x31, 0xb1,
	0xa7, 0xb6, 0x85, 0x5d, 0x9d, 0x3a, 0xd2, 0x84, 0x05, 0x34, 0x1e, 0x8f, 0x2d, 0x6b, 0x7c, 0x4d,
	0x9a, 0x81, 0xf7, 0xc8, 0xbd, 0x6c, 0x52, 0x63, 0x42, 0x1c, 0xaa, 0x4d, 0xc2, 0x0f, 0x88, 0xaf,
	0xa1, 0xa6, 0x90, 0xb1, 0xe1, 0x50, 0x62, 0xf7, 0xf5, 0x2b, 0x32, 0xd1, 0x14, 0x72, 0x83, 0xde,
	0x80, 0x3d, 0xc7, 0x5f, 0x90, 0x3a, 0xb7, 0xcf, 0x1d, 0x94, 0x94, 0x70, 0x85, 0xbe, 0x82, 0x32,
	0x31, 0xa9, 0x41, 0xbd, 0x21, 0xf5, 0xa6, 0xa4, 0x9e, 0xdb, 0xe7, 0x0e, 0xf8, 0xa3, 0x43, 0x69,
	0x75, 0x0e, 0x92, 0x1c, 0x84, 0xa8, 0xde, 0x94, 0x28, 0x40, 0x66, 0xcf, 0xe2, 0x6f, 0x1c, 0x3c,
	0x18, 0x4c, 0xb1, 0x46, 0x49, 0x36, 0xf0, 0x8f, 0x80, 0x82, 0x27, 0x6d, 0xe8, 0x06, 0x11, 0x71,
	0xfc, 0x8f, 0xb2, 0xf0, 0xd9, 0xe7, 0x19, 0x54, 0x90, 0x85, 0xe0, 0xa4, 0x2c, 0xe2, 0xdf, 0x1c,
	0x40, 0x94, 0x85, 0x33, 0x45, 0x3c, 0xe4, 0x0c, 0x1c, 0xa6, 0x90, 0x33, 0x30, 0xfa, 0x04, 0x0a,
	0xaf, 0x88, 0xed, 0x18, 0x96, 0x19, 0x60, 0x96, 0x8f, 0x1a, 0x12, 0xab, 0xab, 0x14, 0xd5, 0x55,
	0x52, 0xa3, 0xba, 0x2a, 0x91, 0x6b, 0xba, 0x5a, 0xf9, 0xbb, 0x54, 0x2b, 0x56, 0x99, 0x9d, 0x44,
	0x65, 0xde, 0x01, 0xd0, 0x6d, 0xa2, 0x51, 0x82, 0x87, 0x23, 0xaf, 0xbe, 0x1b, 0xbc, 0x2b, 0x85,
	0x96, 0xb6, 0x27, 0xf6, 0xa1, 0xcc, 0xf6, 0xe5, 0x04, 0x1b, 0xeb, 0x40, 0x81, 0xed, 0xdd, 0xa9,
	0x73, 0xfb, 0xf9, 0x83, 0x72, 0x76, 0x3a, 0xf3, 0xaa, 0x28, 0x51, 0xa8, 0xa8, 0x42, 0xe5, 0x94,
	0xd0, 0x39, 0x6b, 0xf7, 0x52, 0x2e, 0xf1, 0x4f, 0x0e, 0x6a, 0xc7, 0x41, 0xe2, 0x1d, 0x4b, 0x77,
	0x27, 0xc4, 0xa4, 0xfe, 0xb7, 0xdf, 0x86, 0x52, 0xc8, 0xfc, 0x0c, 0xa2, 0xc8, 0x0c, 0x5d, 0x8c,
	0x5a, 0xc0, 0x87, 0x2f, 0xd7, 0xc7, 0xab, 0xb2, 0x88, 0x8b, 0x90, 0xa4, 0x06, 0x14, 0x71, 0x08,
	0x17, 0x30, 0x54, 0x52, 0x66, 0x6b, 0x1f, 0x3b, 0x24, 0xd0, 0xc0, 0x61, 0xd9, 0x8b, 0xcc, 0xd0,
	0xc5, 0xe2, 0x05, 0xf0, 0xa7, 0x84, 0xc6, 0x53, 0xbd, 0x9f, 0x32, 0xf4, 0xe1, 0xcd, 0xd8, 0x77,
	0x4f, 0x2c, 0x9b, 0x35, 0x44, 0x66, 0x2d, 0x12, 0xc9, 0xe6, 0x52, 0xc9, 0xfe, 0x9e, 0x83, 0xca,
	0x3c, 0xd5, 0x7b, 0xeb, 0xf0, 0x44, 0x42, 0xf9, 0x4c, 0x72, 0x76, 0xee, 0x42, 0xce, 0xee, 0x2a,
	0x72, 0xf6, 0x92, 0xfb, 0x4d, 0x4d, 0x45, 0x21, 0x3d, 0x15, 0x5f, 0x40, 0x8d, 0x0d, 0xff, 0x2a,
	0xfa, 0xe2, 0xe0, 0xb9, 0x24, 0xb8, 0xf8, 0x39, 0x08, 0xe7, 0x1a, 0xd5, 0xaf, 0x32, 0xe2, 0x2f,
	0x6d, 0x6d, 0x1c, 0x8f, 0x8f, 0xd6, 0xe2, 0x7b, 0x50, 0xeb, 0x90, 0x6b, 0xb2, 0x32, 0x01, 0xd1,
	0x03, 0x94, 0x76, 0x5a, 0xce, 0x1c, 0x0e, 0xbc, 0xf0, 0x3a, 0xcc, 0x85, 0xae, 0x7e, 0x81, 0xc2,
	0x47, 0xbf, 0x40, 0x8c, 0xba, 0x52, 0x68, 0x69, 0x7b, 0xe2, 0x5f, 0x1c, 0xd4, 0xbe, 0x76, 0x89,
	0xed, 0x45, 0xd0, 0xce, 0x7f, 0x34, 0x8b, 0xba, 0x65, 0x52, 0xcd, 0x30, 0x9d, 0xa8, 0x9b, 0xa2,
	0xf5, 0xca, 0x59, 0xcc, 0x3a, 0x04, 0xbf, 0x07, 0x94, 0xde, 0x8c, 0x33, 0x45, 0x27, 0x50, 0xb0,
	0x89, 0xe3, 0x5e, 0xd3, 0xe8, 0x2c, 0x7c, 0x92, 0x75, 0x16, 0xc6, 0x79, 0x50, 0xa2, 0x60, 0xf1,
	0x31, 0x54, 0x4f, 0x09, 0xfd, 0xd2, 0x70, 0xa8, 0x65, 0x7b, 0xcb, 0x78, 0xfc, 0x05, 0x84, 0x00,
	0xbe, 0xed, 0xcd, 0x47, 0x39, 0x75, 0x37, 0x70, 0x77, 0xba, 0x1b, 0x56, 0x8e, 0xfe, 0x1f, 0x79,
	0xa8, 0x3c, 0xb3, 0xc6, 0xb2, 0x49, 0xfd, 0xec, 0x96, 0x34, 0xd0, 0x7d, 0x5e, 0xea, 0xc9, 0x54,
	0xf2, 0x29, 0x9a, 0x3e, 0x03, 0xd0, 0xaf, 0x34, 0x73, 0x4c, 0xf0, 0x50, 0xa3, 0x6b, 0x9c, 0x06,
	0xa5, 0xd0, 0xbb, 0x45, 0x03, 0x86, 0xc3, 0xd0, 0x18, 0xc3, 0xcc, 0xd2, 0xf6, 0x90, 0x08, 0xd5,
	0xf9, 0xeb, 0xe8, 0x40, 0xa8, 0x2a, 0xe5, 0x99, 0x47, 0x17, 0xa3, 0xf7, 0x81, 0x8f, 0xf9, 0xb8,
	0x06, 0x0e, 0xcf, 0x85, 0xca, 0xcc, 0x69, 0x60, 0x60, 0xff, 0x9e, 0xd5, 0x74, 0xea, 0xb7, 0x6f,
	0x91, 0xdd, 0xb3, 0x6c, 0xe5, 0xdb, 0x47, 0xe4, 0xd2, 0xb2, 0x49, 0xbd, 0xc4, 0xec, 0x6c, 0x85,
	0x1e, 0xc2, 0xae, 0x76, 0x49, 0x89, 0x5d, 0x87, 0xc0, 0xcc, 0x16, 0xe8, 0x11, 0xec, 0x61, 0x4b,
	0xf7, 0x13, 0x29, 0x33, 0x33, 0xb6, 0x74, 0x76, 0x46, 0xcf, 0x07, 0xa8, 0x92, 0x1c, 0x20, 0xf1,
	0x07, 0xf8, 0x7f, 0xd0, 0x26, 0x21, 0x59, 0x06, 0x99, 0xb5, 0x29, 0x61, 0xcb, 0x75, 0xdb, 0x34,
	0xce, 0xb6, 0x12, 0x05, 0x1f, 0x7e, 0x07, 0x30, 0xe7, 0x0c, 0xbd, 0x05, 0x8f, 0x06, 0xbd, 0x8e,
	0x7c, 0xd2, 0xed, 0xc9, 0x9d, 0xa1, 0xdc, 0x53, 0xbb, 0xea, 0x8b, 0xa1, 0xfa, 0xe2, 0x5c, 0x16,
	0xfe, 0x87, 0xca, 0x50, 0xe8, 0xcb, 0xca, 0x45, 0xf7, 0x58, 0x16, 0x38, 0x54, 0x84, 0x1d, 0x55,
	0x6e, 0x9d, 0x09, 0x39, 0xc4, 0x03, 0xb4, 0xbe, 0xe9, 0xb7, 0x8e, 0x8f, 0x9f, 0x0f, 0x7a, 0xaa,
	0x90, 0xf7, 0xdd, 0xba, 0xbd, 0x8b, 0xd6, 0xb3, 0x6e, 0x47, 0xd8, 0x39, 0xec, 0x81, 0x90, 0x56,
	0x59, 0x49, 0x88, 0xc1, 0x79, 0xa7, 0xa5, 0xca, 0x11, 0x44, 0x09, 0x76, 0xcf, 0xba, 0xbd, 0xe7,
	0x0a, 0x03, 0xe8, 0xb7, 0x4e, 0x64, 0x21, 0x87, 0x00, 0xf6, 0x06, 0xbd, 0xe0, 0x39, 0x7f, 0xf4,
	0x4f, 0x05, 0x0a, 0xa1, 0xe6, 0x45, 0x16, 0xf0, 0x49, 0x85, 0x8a, 0x3e, 0xce, 0xaa, 0xc0, 0x82,
	0xa2, 0x6d, 0x6c, 0xa0, 0x73, 0xd0, 0x4b, 0xa8, 0xc4, 0x75, 0x29, 0x6a, 0x66, 0xc5, 0xa6, 0x54,
	0xec, 0x46, 0x60, 0x04, 0x4a, 0x33, 0x2d, 0x85, 0x32, 0xa9, 0x8d, 0xcb, 0xae, 0x8d, 0x60, 0x6e,
	0x80, 0x4f, 0x6a, 0xab, 0xec, 0x22, 0x2e, 0x68, 0xb1, 0xc6, 0x46, 0x07, 0x24, 0x7a, 0x09, 0xe5,
	0x98, 0x90, 0x41, 0xd2, 0x1a, 0x7b, 0xdb, 0x1e, 0xec, 0x57, 0x78, 0xb8, 0x4c, 0x35, 0xa1, 0x4f,
	0x37, 0x40, 0x8d, 0x6b, 0xad, 0x0d, 0xe1, 0x6f, 0x80, 0x4f, 0x0a, 0x8a, 0xec, 0xf2, 0x2e, 0x08,
	0x90, 0x0d, 0x21, 0x2d, 0xa8, 0x26, 0x24, 0x08, 0xca, 0xfc, 0x3f, 0x28, 0xad, 0x58, 0x36, 0x04,
	0xbc, 0x05, 0x3e, 0x29, 0x47, 0xb2, 0xf7, 0xb8, 0xa0, 0x71, 0x1a, 0x47, 0x9b, 0x86, 0x30, 0xe0,
	0xe4, 0xf5, 0x9d, 0x0d, 0xbc, 0xa0, 0x5d, 0xb2, 0x81, 0x97, 0x28, 0x84, 0x5b, 0x40, 0xb1, 0xf6,
	0x08, 0x6f, 0x78, 0xf4, 0xe1, 0x1a, 0x2d, 0x35, 0x57, 0x03, 0x5b, 0x01, 0x9b, 0x20, 0xcc, 0x26,
	0x7d, 0x4b, 0xd8, 0x0f, 0xd6, 0x3b, 0x1c, 0x18, 0x9e, 0x0b, 0xd5, 0x84, 0x42, 0xc9, 0xee, 0xa5,
	0xb4, 0xa0, 0xd9, 0x6a, 0x9b, 0xaf, 0xe1, 0x41, 0xea, 0xc6, 0xdb, 0x02, 0xf8, 0xe9, 0x5a, 0x11,
	0xc9, 0x4b, 0xb5, 0x2d, 0x7e, 0xbb, 0x9f, 0xf5, 0x33, 0xcb, 0x68, 0x2f, 0x50, 0x24, 0x4f, 0xff,
	0x0d, 0x00, 0x00, 0xff, 0xff, 0x6c, 0xa8, 0xf2, 0xd5, 0x91, 0x11, 0x00, 0x00,
}
