# PDMS Upload Schema 
This is the PDMS Service Upload Schema. 

[Read the docs here!](https://git.xarth.tv/pages/privacy/pdms-docs/pdms/delete_and_access/#access-requests)

Docker is required to build this. (If someone knows how to add docker to the brazil-tooling, please do).

### TLDR
1. Create Schema .proto file in /datasets 
2. `brazil-build`
3. Update information.go   
4. Open a cr `cr --new-review`


### Multifile Client Example 
Below is an example of using the upload client in Owl's eventbus subscriber 
```go

func (s *Subscriber) ProcessAccessEvent(ctx context.Context, h *eventbus.Header, event *user_data_request.UserDataRequestCreate) error {
    // get list of auth proto messages by userID
	//func getAuthorizations(ctx context.Context, userID string) ([]*authorizationsv1.Authorization, error)
	authList, authErr := s.getAuthorizations(ctx, event.UserId)
    if authErr != nil {
    	return err 
    }
    // create map of fileName
    uploadMap := make(map[string]proto.Message)
    for _, authMessage := range authList {
    	uploadMap[fmt.Sprintf("%s-%s", auth.ClientID, auth.ClientName)] = authMessage
    }
    
    // preform upload to PDMS
    return s.uploadClinet.ReportMultipleFiles(ctx, pdmsUploadClient.ReportMultipleFilesRequest{
    	RequestID: event.RequestID,
    	DataID: information.OwlAuthorization
    	Payloads: uploadMap
   })
    
}

```
Note: if there are no auths returns by `getAuthorizations`, the client will report data as false
