package information

import (
	"testing"

	"github.com/golang/protobuf/proto"
	"github.com/golang/protobuf/ptypes/timestamp"
	"github.com/stretchr/testify/assert"

	"code.justin.tv/amzn/PDMSLambdaUploadSchema/generated/datasets/example/examplev1"
)

// attempt to load it into

func TestDecode(t *testing.T) {
	expected := "{\n  \"id\": \"hello\",\n  \"name\": \"test-person\",\n  \"email\": \"email@me.you\",\n  \"phones\": [\n    {\n      \"number\": \"8675309\",\n      \"type\": \"Home Phone\"\n    }\n  ],\n  \"last_updated_time\": {\n    \"seconds\": 1577869261\n  }\n}"
	// create a proto example
	ts := &timestamp.Timestamp{Seconds: 1577869261}
	p := &examplev1.Person{
		Id:    "hello",
		Name:  "test-person",
		Email: "email@me.you",
		Phones: []*examplev1.Person_PhoneNumber{
			{
				Type:   "Home Phone",
				Number: "8675309",
			},
		},
		LastUpdatedTime: ts,
	}

	// encode it
	b, err := proto.Marshal(p)
	assert.NoError(t, err)

	// decode it
	info, b, err := GetInfo().Decode("example-data-id", b)
	assert.NoError(t, err)
	assert.Equal(t, expected, string(b))
	assert.Equal(t, "Example Title", info.Title)
}
