package information

import (
	"fmt"
	"testing"

	"code.justin.tv/amzn/PDMSLambdaUploadSchema/generated/datasets/example/examplev1"

	"github.com/golang/protobuf/proto"
)

// used during unit tests in PDMS to create an example service
func GetTestingInformation(t *testing.T) *MetaInfo {
	m := make(map[DataID]MetaInformation)
	// data id
	dataID := DataID(fmt.Sprintf("%s-DataID", t.Name()))
	m[dataID] = MetaInformation{
		// Service RequestID that owns the data
		ServiceID: fmt.Sprintf("%s-ServiceID", t.Name()),
		// a title for the piece of data
		Title: "title",
		// a long description for the data to inform the data on individual fields and how they are used
		Description: "description",
		// the proto message type so we know what to deserilize it into
		MessageFactory: func() proto.Message { return &examplev1.Person{} },
	}

	return &MetaInfo{m}
}
