// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: code.justin.tv/amzn/PollpatineTwirp/twirp.proto

package PollpatineTwirp

import (
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Status of a poll, describing its lifecycle state.
type PollStatus int32

const (
	// Something went wrong determining the state :monkaS:.
	PollStatus_INVALID PollStatus = 0
	// Poll is ACTIVE and users can vote.
	PollStatus_ACTIVE PollStatus = 1
	// Poll ran its entire duration and "naturally" completed. Users cannot vote, but results are publicly visible.
	PollStatus_COMPLETED PollStatus = 2
	// Poll was manually terminated by owner before it ran its entire duration. Users cannot vote, but results are publicly visible.
	PollStatus_TERMINATED PollStatus = 3
	// Poll is no longer publicly visible to users.
	PollStatus_ARCHIVED PollStatus = 4
	// Poll is no longer visible to any user on Twitch.
	PollStatus_MODERATED PollStatus = 5
)

// Enum value maps for PollStatus.
var (
	PollStatus_name = map[int32]string{
		0: "INVALID",
		1: "ACTIVE",
		2: "COMPLETED",
		3: "TERMINATED",
		4: "ARCHIVED",
		5: "MODERATED",
	}
	PollStatus_value = map[string]int32{
		"INVALID":    0,
		"ACTIVE":     1,
		"COMPLETED":  2,
		"TERMINATED": 3,
		"ARCHIVED":   4,
		"MODERATED":  5,
	}
)

func (x PollStatus) Enum() *PollStatus {
	p := new(PollStatus)
	*p = x
	return p
}

func (x PollStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PollStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_enumTypes[0].Descriptor()
}

func (PollStatus) Type() protoreflect.EnumType {
	return &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_enumTypes[0]
}

func (x PollStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PollStatus.Descriptor instead.
func (PollStatus) EnumDescriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{0}
}

// Errors that can occur when voting.
type VoteErrorCode int32

const (
	// Voter tried to vote in a poll that doesn't exist i.e. there is no poll running at all).
	VoteErrorCode_POLL_NOT_FOUND VoteErrorCode = 0
	// Voter tried to vote in a poll that is not active.
	VoteErrorCode_POLL_NOT_ACTIVE VoteErrorCode = 1
	// Request has a vote ID that has already been submitted.
	VoteErrorCode_VOTE_ID_CONFLICT VoteErrorCode = 2
	// Voter is trying to vote for another choice in a poll that only allows one choice.
	VoteErrorCode_MULTI_CHOICE_VOTE_FORBIDDEN VoteErrorCode = 3
	// Request is for a choice ID that invalid.
	VoteErrorCode_INVALID_CHOICE_ID VoteErrorCode = 4
	// Voter is trying to vote more times than the maximum number of times that the poll allows.
	VoteErrorCode_MAX_VOTE_LIMIT_ERROR VoteErrorCode = 5
)

// Enum value maps for VoteErrorCode.
var (
	VoteErrorCode_name = map[int32]string{
		0: "POLL_NOT_FOUND",
		1: "POLL_NOT_ACTIVE",
		2: "VOTE_ID_CONFLICT",
		3: "MULTI_CHOICE_VOTE_FORBIDDEN",
		4: "INVALID_CHOICE_ID",
		5: "MAX_VOTE_LIMIT_ERROR",
	}
	VoteErrorCode_value = map[string]int32{
		"POLL_NOT_FOUND":              0,
		"POLL_NOT_ACTIVE":             1,
		"VOTE_ID_CONFLICT":            2,
		"MULTI_CHOICE_VOTE_FORBIDDEN": 3,
		"INVALID_CHOICE_ID":           4,
		"MAX_VOTE_LIMIT_ERROR":        5,
	}
)

func (x VoteErrorCode) Enum() *VoteErrorCode {
	p := new(VoteErrorCode)
	*p = x
	return p
}

func (x VoteErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VoteErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_enumTypes[1].Descriptor()
}

func (VoteErrorCode) Type() protoreflect.EnumType {
	return &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_enumTypes[1]
}

func (x VoteErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VoteErrorCode.Descriptor instead.
func (VoteErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{1}
}

// Errors that can occur when doing poll operation.
type PollErrorCode int32

const (
	// When trying to create a new poll but there is still an active poll.
	PollErrorCode_ALREADY_HAVE_AN_ACTIVE_POLL PollErrorCode = 0
)

// Enum value maps for PollErrorCode.
var (
	PollErrorCode_name = map[int32]string{
		0: "ALREADY_HAVE_AN_ACTIVE_POLL",
	}
	PollErrorCode_value = map[string]int32{
		"ALREADY_HAVE_AN_ACTIVE_POLL": 0,
	}
)

func (x PollErrorCode) Enum() *PollErrorCode {
	p := new(PollErrorCode)
	*p = x
	return p
}

func (x PollErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PollErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_enumTypes[2].Descriptor()
}

func (PollErrorCode) Type() protoreflect.EnumType {
	return &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_enumTypes[2]
}

func (x PollErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PollErrorCode.Descriptor instead.
func (PollErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{2}
}

// Request to CreatePoll API.
type CreatePollRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The owner of the poll.
	OwnedBy  string                                `protobuf:"bytes,1,opt,name=owned_by,json=ownedBy,proto3" json:"owned_by,omitempty"`
	Title    string                                `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	Duration *duration.Duration                    `protobuf:"bytes,3,opt,name=duration,proto3" json:"duration,omitempty"`
	Choices  []*CreatePollRequest_CreatePollChoice `protobuf:"bytes,4,rep,name=choices,proto3" json:"choices,omitempty"`
	Settings *PollSettings                         `protobuf:"bytes,5,opt,name=settings,proto3" json:"settings,omitempty"`
	PollId   string                                `protobuf:"bytes,6,opt,name=poll_id,json=pollId,proto3" json:"poll_id,omitempty"`
	Ttl      *timestamp.Timestamp                  `protobuf:"bytes,7,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (x *CreatePollRequest) Reset() {
	*x = CreatePollRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePollRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePollRequest) ProtoMessage() {}

func (x *CreatePollRequest) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePollRequest.ProtoReflect.Descriptor instead.
func (*CreatePollRequest) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{0}
}

func (x *CreatePollRequest) GetOwnedBy() string {
	if x != nil {
		return x.OwnedBy
	}
	return ""
}

func (x *CreatePollRequest) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *CreatePollRequest) GetDuration() *duration.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *CreatePollRequest) GetChoices() []*CreatePollRequest_CreatePollChoice {
	if x != nil {
		return x.Choices
	}
	return nil
}

func (x *CreatePollRequest) GetSettings() *PollSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *CreatePollRequest) GetPollId() string {
	if x != nil {
		return x.PollId
	}
	return ""
}

func (x *CreatePollRequest) GetTtl() *timestamp.Timestamp {
	if x != nil {
		return x.Ttl
	}
	return nil
}

// Request to GetPoll API.
type GetPollRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the poll to request
	PollId string `protobuf:"bytes,2,opt,name=poll_id,json=pollId,proto3" json:"poll_id,omitempty"`
}

func (x *GetPollRequest) Reset() {
	*x = GetPollRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPollRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPollRequest) ProtoMessage() {}

func (x *GetPollRequest) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPollRequest.ProtoReflect.Descriptor instead.
func (*GetPollRequest) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{1}
}

func (x *GetPollRequest) GetPollId() string {
	if x != nil {
		return x.PollId
	}
	return ""
}

// Request to GetVotesForVoter API.
type GetVotesForVoterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// UserID of the voter to get information for
	VoterId string `protobuf:"bytes,1,opt,name=voter_id,json=voterId,proto3" json:"voter_id,omitempty"`
	// ID of the poll
	PollId string `protobuf:"bytes,2,opt,name=poll_id,json=pollId,proto3" json:"poll_id,omitempty"`
}

func (x *GetVotesForVoterRequest) Reset() {
	*x = GetVotesForVoterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVotesForVoterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVotesForVoterRequest) ProtoMessage() {}

func (x *GetVotesForVoterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVotesForVoterRequest.ProtoReflect.Descriptor instead.
func (*GetVotesForVoterRequest) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{2}
}

func (x *GetVotesForVoterRequest) GetVoterId() string {
	if x != nil {
		return x.VoterId
	}
	return ""
}

func (x *GetVotesForVoterRequest) GetPollId() string {
	if x != nil {
		return x.PollId
	}
	return ""
}

type VoteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID representing this vote
	VoteId string `protobuf:"bytes,1,opt,name=vote_id,json=voteId,proto3" json:"vote_id,omitempty"`
	// ID of the poll
	PollId string `protobuf:"bytes,2,opt,name=poll_id,json=pollId,proto3" json:"poll_id,omitempty"`
	// UserID of the user performing the vote request
	VoterId string `protobuf:"bytes,3,opt,name=voter_id,json=voterId,proto3" json:"voter_id,omitempty"`
	// ID of the choice
	ChoiceId string `protobuf:"bytes,4,opt,name=choice_id,json=choiceId,proto3" json:"choice_id,omitempty"`
	// The number of votes to cast
	Count int64 `protobuf:"varint,5,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *VoteRequest) Reset() {
	*x = VoteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VoteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoteRequest) ProtoMessage() {}

func (x *VoteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoteRequest.ProtoReflect.Descriptor instead.
func (*VoteRequest) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{3}
}

func (x *VoteRequest) GetVoteId() string {
	if x != nil {
		return x.VoteId
	}
	return ""
}

func (x *VoteRequest) GetPollId() string {
	if x != nil {
		return x.PollId
	}
	return ""
}

func (x *VoteRequest) GetVoterId() string {
	if x != nil {
		return x.VoterId
	}
	return ""
}

func (x *VoteRequest) GetChoiceId() string {
	if x != nil {
		return x.ChoiceId
	}
	return ""
}

func (x *VoteRequest) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Response from CreatePoll API.
type CreatePollResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Poll *Poll `protobuf:"bytes,1,opt,name=poll,proto3" json:"poll,omitempty"`
}

func (x *CreatePollResponse) Reset() {
	*x = CreatePollResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePollResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePollResponse) ProtoMessage() {}

func (x *CreatePollResponse) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePollResponse.ProtoReflect.Descriptor instead.
func (*CreatePollResponse) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{4}
}

func (x *CreatePollResponse) GetPoll() *Poll {
	if x != nil {
		return x.Poll
	}
	return nil
}

// Response from GetPoll API.
type GetPollResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Poll *Poll `protobuf:"bytes,1,opt,name=poll,proto3" json:"poll,omitempty"`
}

func (x *GetPollResponse) Reset() {
	*x = GetPollResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPollResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPollResponse) ProtoMessage() {}

func (x *GetPollResponse) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPollResponse.ProtoReflect.Descriptor instead.
func (*GetPollResponse) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{5}
}

func (x *GetPollResponse) GetPoll() *Poll {
	if x != nil {
		return x.Poll
	}
	return nil
}

// Response to GetVoter API.
type GetVotesForVoterResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Votes      []*Vote `protobuf:"bytes,1,rep,name=votes,proto3" json:"votes,omitempty"`
	TotalCount int64   `protobuf:"varint,2,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
}

func (x *GetVotesForVoterResponse) Reset() {
	*x = GetVotesForVoterResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVotesForVoterResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVotesForVoterResponse) ProtoMessage() {}

func (x *GetVotesForVoterResponse) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVotesForVoterResponse.ProtoReflect.Descriptor instead.
func (*GetVotesForVoterResponse) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{6}
}

func (x *GetVotesForVoterResponse) GetVotes() []*Vote {
	if x != nil {
		return x.Votes
	}
	return nil
}

func (x *GetVotesForVoterResponse) GetTotalCount() int64 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

type VoteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Vote *Vote `protobuf:"bytes,1,opt,name=vote,proto3" json:"vote,omitempty"`
}

func (x *VoteResponse) Reset() {
	*x = VoteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VoteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoteResponse) ProtoMessage() {}

func (x *VoteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoteResponse.ProtoReflect.Descriptor instead.
func (*VoteResponse) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{7}
}

func (x *VoteResponse) GetVote() *Vote {
	if x != nil {
		return x.Vote
	}
	return nil
}

// Controls settings on the poll.
type PollSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MultiChoice  *PollSettings_MultiChoicePollSetting `protobuf:"bytes,1,opt,name=multi_choice,json=multiChoice,proto3" json:"multi_choice,omitempty"`
	MaxUserVotes *PollSettings_MaxUserVotesSetting    `protobuf:"bytes,2,opt,name=max_user_votes,json=maxUserVotes,proto3" json:"max_user_votes,omitempty"`
}

func (x *PollSettings) Reset() {
	*x = PollSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollSettings) ProtoMessage() {}

func (x *PollSettings) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollSettings.ProtoReflect.Descriptor instead.
func (*PollSettings) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{8}
}

func (x *PollSettings) GetMultiChoice() *PollSettings_MultiChoicePollSetting {
	if x != nil {
		return x.MultiChoice
	}
	return nil
}

func (x *PollSettings) GetMaxUserVotes() *PollSettings_MaxUserVotesSetting {
	if x != nil {
		return x.MaxUserVotes
	}
	return nil
}

// Information about a choice in a poll.
type Choice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChoiceId string `protobuf:"bytes,1,opt,name=choice_id,json=choiceId,proto3" json:"choice_id,omitempty"`
	Title    string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	ImageUrl string `protobuf:"bytes,3,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
	// A breakdown of how many votes were cast for the choice.
	TotalVotes int64 `protobuf:"varint,4,opt,name=total_votes,json=totalVotes,proto3" json:"total_votes,omitempty"`
	// Total number of unique voters for the choice.
	TotalVoters int64 `protobuf:"varint,5,opt,name=total_voters,json=totalVoters,proto3" json:"total_voters,omitempty"`
}

func (x *Choice) Reset() {
	*x = Choice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Choice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Choice) ProtoMessage() {}

func (x *Choice) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Choice.ProtoReflect.Descriptor instead.
func (*Choice) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{9}
}

func (x *Choice) GetChoiceId() string {
	if x != nil {
		return x.ChoiceId
	}
	return ""
}

func (x *Choice) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Choice) GetImageUrl() string {
	if x != nil {
		return x.ImageUrl
	}
	return ""
}

func (x *Choice) GetTotalVotes() int64 {
	if x != nil {
		return x.TotalVotes
	}
	return 0
}

func (x *Choice) GetTotalVoters() int64 {
	if x != nil {
		return x.TotalVoters
	}
	return 0
}

// Information about a poll.
type Poll struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PollId string `protobuf:"bytes,1,opt,name=poll_id,json=pollId,proto3" json:"poll_id,omitempty"`
	// User who owns the poll.
	OwnedBy   string               `protobuf:"bytes,2,opt,name=owned_by,json=ownedBy,proto3" json:"owned_by,omitempty"`
	Title     string               `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	StartTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	EndTime   *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	Duration  *duration.Duration   `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
	Settings  *PollSettings        `protobuf:"bytes,7,opt,name=settings,proto3" json:"settings,omitempty"`
	Status    PollStatus           `protobuf:"varint,8,opt,name=status,proto3,enum=twitch.polls.pollpatine.PollStatus" json:"status,omitempty"`
	// Information about the choices.
	Choices []*Choice `protobuf:"bytes,9,rep,name=choices,proto3" json:"choices,omitempty"`
	// A breakdown of how many tokens were spent in the poll.
	TotalVotes int64 `protobuf:"varint,10,opt,name=total_votes,json=totalVotes,proto3" json:"total_votes,omitempty"`
	// Total number of unique voters in the poll.
	TotalVoters int64 `protobuf:"varint,11,opt,name=total_voters,json=totalVoters,proto3" json:"total_voters,omitempty"`
	// Duration remaining before poll completes.
	// Due to how protobuf serializes durations, this value will be nil when the duration is 0
	// Please account for this in your client code with a nil check, as any poll that is ended will have remaining_duration == 0
	RemainingDuration *duration.Duration `protobuf:"bytes,12,opt,name=remaining_duration,json=remainingDuration,proto3" json:"remaining_duration,omitempty"`
}

func (x *Poll) Reset() {
	*x = Poll{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Poll) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Poll) ProtoMessage() {}

func (x *Poll) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Poll.ProtoReflect.Descriptor instead.
func (*Poll) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{10}
}

func (x *Poll) GetPollId() string {
	if x != nil {
		return x.PollId
	}
	return ""
}

func (x *Poll) GetOwnedBy() string {
	if x != nil {
		return x.OwnedBy
	}
	return ""
}

func (x *Poll) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Poll) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Poll) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Poll) GetDuration() *duration.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Poll) GetSettings() *PollSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *Poll) GetStatus() PollStatus {
	if x != nil {
		return x.Status
	}
	return PollStatus_INVALID
}

func (x *Poll) GetChoices() []*Choice {
	if x != nil {
		return x.Choices
	}
	return nil
}

func (x *Poll) GetTotalVotes() int64 {
	if x != nil {
		return x.TotalVotes
	}
	return 0
}

func (x *Poll) GetTotalVoters() int64 {
	if x != nil {
		return x.TotalVoters
	}
	return 0
}

func (x *Poll) GetRemainingDuration() *duration.Duration {
	if x != nil {
		return x.RemainingDuration
	}
	return nil
}

// A vote in a poll.
type Vote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the vote
	VoteId string `protobuf:"bytes,1,opt,name=vote_id,json=voteId,proto3" json:"vote_id,omitempty"`
	// ID of poll voter voted in
	PollId string `protobuf:"bytes,2,opt,name=poll_id,json=pollId,proto3" json:"poll_id,omitempty"`
	// UserID of voter
	VoterId string `protobuf:"bytes,3,opt,name=voter_id,json=voterId,proto3" json:"voter_id,omitempty"`
	// Choices the voter voted for
	ChoiceId string `protobuf:"bytes,4,opt,name=choice_id,json=choiceId,proto3" json:"choice_id,omitempty"`
	// The number of votes that were cast
	Count int64 `protobuf:"varint,5,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *Vote) Reset() {
	*x = Vote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vote) ProtoMessage() {}

func (x *Vote) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vote.ProtoReflect.Descriptor instead.
func (*Vote) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{11}
}

func (x *Vote) GetVoteId() string {
	if x != nil {
		return x.VoteId
	}
	return ""
}

func (x *Vote) GetPollId() string {
	if x != nil {
		return x.PollId
	}
	return ""
}

func (x *Vote) GetVoterId() string {
	if x != nil {
		return x.VoterId
	}
	return ""
}

func (x *Vote) GetChoiceId() string {
	if x != nil {
		return x.ChoiceId
	}
	return ""
}

func (x *Vote) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

// Information about choices in the poll.
type CreatePollRequest_CreatePollChoice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Title    string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	ImageUrl string `protobuf:"bytes,2,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
}

func (x *CreatePollRequest_CreatePollChoice) Reset() {
	*x = CreatePollRequest_CreatePollChoice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePollRequest_CreatePollChoice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePollRequest_CreatePollChoice) ProtoMessage() {}

func (x *CreatePollRequest_CreatePollChoice) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePollRequest_CreatePollChoice.ProtoReflect.Descriptor instead.
func (*CreatePollRequest_CreatePollChoice) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{0, 0}
}

func (x *CreatePollRequest_CreatePollChoice) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *CreatePollRequest_CreatePollChoice) GetImageUrl() string {
	if x != nil {
		return x.ImageUrl
	}
	return ""
}

// Controls whether users can vote for multiple choices.
type PollSettings_MultiChoicePollSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *PollSettings_MultiChoicePollSetting) Reset() {
	*x = PollSettings_MultiChoicePollSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollSettings_MultiChoicePollSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollSettings_MultiChoicePollSetting) ProtoMessage() {}

func (x *PollSettings_MultiChoicePollSetting) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollSettings_MultiChoicePollSetting.ProtoReflect.Descriptor instead.
func (*PollSettings_MultiChoicePollSetting) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{8, 0}
}

func (x *PollSettings_MultiChoicePollSetting) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Controls max votes per user settings.
type PollSettings_MaxUserVotesSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled  bool  `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	NumVotes int64 `protobuf:"varint,2,opt,name=num_votes,json=numVotes,proto3" json:"num_votes,omitempty"`
}

func (x *PollSettings_MaxUserVotesSetting) Reset() {
	*x = PollSettings_MaxUserVotesSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PollSettings_MaxUserVotesSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PollSettings_MaxUserVotesSetting) ProtoMessage() {}

func (x *PollSettings_MaxUserVotesSetting) ProtoReflect() protoreflect.Message {
	mi := &file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PollSettings_MaxUserVotesSetting.ProtoReflect.Descriptor instead.
func (*PollSettings_MaxUserVotesSetting) Descriptor() ([]byte, []int) {
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP(), []int{8, 1}
}

func (x *PollSettings_MaxUserVotesSetting) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *PollSettings_MaxUserVotesSetting) GetNumVotes() int64 {
	if x != nil {
		return x.NumVotes
	}
	return 0
}

var File_code_justin_tv_amzn_PollpatineTwirp_twirp_proto protoreflect.FileDescriptor

var file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x6e, 0x2e, 0x74, 0x76,
	0x2f, 0x61, 0x6d, 0x7a, 0x6e, 0x2f, 0x50, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65,
	0x54, 0x77, 0x69, 0x72, 0x70, 0x2f, 0x74, 0x77, 0x69, 0x72, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x17, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e,
	0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa3, 0x03, 0x0a, 0x11,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x42, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x07, 0x63, 0x68, 0x6f,
	0x69, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x74, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61,
	0x74, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c,
	0x6c, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x07, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x41, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c,
	0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x50, 0x6f, 0x6c,
	0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x6c, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x03,
	0x74, 0x74, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x1a, 0x45, 0x0a, 0x10, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72,
	0x6c, 0x22, 0x29, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x6c, 0x49, 0x64, 0x22, 0x4d, 0x0a, 0x17,
	0x47, 0x65, 0x74, 0x56, 0x6f, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x56, 0x6f, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x76, 0x6f, 0x74, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x6f, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x6c, 0x49, 0x64, 0x22, 0x8d, 0x01, 0x0a, 0x0b,
	0x56, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x76,
	0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6f,
	0x74, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x6c, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x76, 0x6f, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x6f, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x68, 0x6f, 0x69,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x6f,
	0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x47, 0x0a, 0x12, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x31, 0x0a, 0x04, 0x70, 0x6f, 0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70,
	0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x04,
	0x70, 0x6f, 0x6c, 0x6c, 0x22, 0x44, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x6c, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x04, 0x70, 0x6f, 0x6c, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70,
	0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e,
	0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x04, 0x70, 0x6f, 0x6c, 0x6c, 0x22, 0x70, 0x0a, 0x18, 0x47, 0x65,
	0x74, 0x56, 0x6f, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x56, 0x6f, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x05, 0x76, 0x6f, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70,
	0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e,
	0x56, 0x6f, 0x74, 0x65, 0x52, 0x05, 0x76, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x41, 0x0a, 0x0c,
	0x56, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x04,
	0x76, 0x6f, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x74, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61,
	0x74, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x6f, 0x74, 0x65, 0x52, 0x04, 0x76, 0x6f, 0x74, 0x65, 0x22,
	0xd2, 0x02, 0x0a, 0x0c, 0x50, 0x6f, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x5f, 0x0a, 0x0c, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65,
	0x2e, 0x50, 0x6f, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x68, 0x6f, 0x69, 0x63,
	0x65, 0x12, 0x5f, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x76, 0x6f,
	0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x74, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74,
	0x69, 0x6e, 0x65, 0x2e, 0x50, 0x6f, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x4d, 0x61, 0x78, 0x55, 0x73, 0x65, 0x72, 0x56, 0x6f, 0x74, 0x65, 0x73, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x55, 0x73, 0x65, 0x72, 0x56, 0x6f, 0x74,
	0x65, 0x73, 0x1a, 0x32, 0x0a, 0x16, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x68, 0x6f, 0x69, 0x63,
	0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0x4c, 0x0a, 0x13, 0x4d, 0x61, 0x78, 0x55, 0x73, 0x65,
	0x72, 0x56, 0x6f, 0x74, 0x65, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x75, 0x6d, 0x5f, 0x76,
	0x6f, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x6e, 0x75, 0x6d, 0x56,
	0x6f, 0x74, 0x65, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x06, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x6c, 0x12,
	0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x76, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x56, 0x6f, 0x74, 0x65, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x76, 0x6f, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x56, 0x6f, 0x74,
	0x65, 0x72, 0x73, 0x22, 0xc2, 0x04, 0x0a, 0x04, 0x50, 0x6f, 0x6c, 0x6c, 0x12, 0x17, 0x0a, 0x07,
	0x70, 0x6f, 0x6c, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70,
	0x6f, 0x6c, 0x6c, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x5f, 0x62,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x42, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x41, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73,
	0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x50, 0x6f, 0x6c, 0x6c,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x3b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x23, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c,
	0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x50, 0x6f, 0x6c,
	0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x39, 0x0a, 0x07, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e,
	0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x68, 0x6f, 0x69, 0x63,
	0x65, 0x52, 0x07, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x76, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x56, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x76, 0x6f, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x56, 0x6f, 0x74, 0x65, 0x72, 0x73, 0x12, 0x48,
	0x0a, 0x12, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x86, 0x01, 0x0a, 0x04, 0x56, 0x6f, 0x74,
	0x65, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x76, 0x6f, 0x74, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x70, 0x6f,
	0x6c, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x6c,
	0x6c, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x76, 0x6f, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x6f, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x09, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x2a, 0x61, 0x0a, 0x0a, 0x50, 0x6f, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50,
	0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45, 0x52, 0x4d, 0x49,
	0x4e, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x52, 0x43, 0x48, 0x49,
	0x56, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x4f, 0x44, 0x45, 0x52, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x05, 0x2a, 0xa0, 0x01, 0x0a, 0x0d, 0x56, 0x6f, 0x74, 0x65, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x4f, 0x4c, 0x4c, 0x5f, 0x4e,
	0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x4f,
	0x4c, 0x4c, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x14, 0x0a, 0x10, 0x56, 0x4f, 0x54, 0x45, 0x5f, 0x49, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c,
	0x49, 0x43, 0x54, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x43,
	0x48, 0x4f, 0x49, 0x43, 0x45, 0x5f, 0x56, 0x4f, 0x54, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x42, 0x49,
	0x44, 0x44, 0x45, 0x4e, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x5f, 0x43, 0x48, 0x4f, 0x49, 0x43, 0x45, 0x5f, 0x49, 0x44, 0x10, 0x04, 0x12, 0x18, 0x0a,
	0x14, 0x4d, 0x41, 0x58, 0x5f, 0x56, 0x4f, 0x54, 0x45, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x2a, 0x30, 0x0a, 0x0d, 0x50, 0x6f, 0x6c, 0x6c, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x4c, 0x52, 0x45,
	0x41, 0x44, 0x59, 0x5f, 0x48, 0x41, 0x56, 0x45, 0x5f, 0x41, 0x4e, 0x5f, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x4c, 0x10, 0x00, 0x32, 0x9f, 0x03, 0x0a, 0x0a, 0x50, 0x6f,
	0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x12, 0x65, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x12, 0x2a, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e,
	0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c,
	0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5c, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x6c, 0x12, 0x27, 0x2e, 0x74, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61,
	0x74, 0x69, 0x6e, 0x65, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c,
	0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x6f, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x77, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x56, 0x6f, 0x74, 0x65,
	0x72, 0x12, 0x30, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73,
	0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x47, 0x65, 0x74, 0x56,
	0x6f, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x56, 0x6f, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c,
	0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x47, 0x65,
	0x74, 0x56, 0x6f, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x72, 0x56, 0x6f, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x04, 0x56, 0x6f, 0x74, 0x65, 0x12, 0x24,
	0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f,
	0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x6f, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x74, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2e, 0x70, 0x6f,
	0x6c, 0x6c, 0x73, 0x2e, 0x70, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x2e, 0x56,
	0x6f, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x25, 0x5a, 0x23, 0x63,
	0x6f, 0x64, 0x65, 0x2e, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x6e, 0x2e, 0x74, 0x76, 0x2f, 0x61, 0x6d,
	0x7a, 0x6e, 0x2f, 0x50, 0x6f, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x54, 0x77, 0x69,
	0x72, 0x70, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescOnce sync.Once
	file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescData = file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDesc
)

func file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescGZIP() []byte {
	file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescOnce.Do(func() {
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescData = protoimpl.X.CompressGZIP(file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescData)
	})
	return file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDescData
}

var file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_goTypes = []interface{}{
	(PollStatus)(0),                             // 0: twitch.polls.pollpatine.PollStatus
	(VoteErrorCode)(0),                          // 1: twitch.polls.pollpatine.VoteErrorCode
	(PollErrorCode)(0),                          // 2: twitch.polls.pollpatine.PollErrorCode
	(*CreatePollRequest)(nil),                   // 3: twitch.polls.pollpatine.CreatePollRequest
	(*GetPollRequest)(nil),                      // 4: twitch.polls.pollpatine.GetPollRequest
	(*GetVotesForVoterRequest)(nil),             // 5: twitch.polls.pollpatine.GetVotesForVoterRequest
	(*VoteRequest)(nil),                         // 6: twitch.polls.pollpatine.VoteRequest
	(*CreatePollResponse)(nil),                  // 7: twitch.polls.pollpatine.CreatePollResponse
	(*GetPollResponse)(nil),                     // 8: twitch.polls.pollpatine.GetPollResponse
	(*GetVotesForVoterResponse)(nil),            // 9: twitch.polls.pollpatine.GetVotesForVoterResponse
	(*VoteResponse)(nil),                        // 10: twitch.polls.pollpatine.VoteResponse
	(*PollSettings)(nil),                        // 11: twitch.polls.pollpatine.PollSettings
	(*Choice)(nil),                              // 12: twitch.polls.pollpatine.Choice
	(*Poll)(nil),                                // 13: twitch.polls.pollpatine.Poll
	(*Vote)(nil),                                // 14: twitch.polls.pollpatine.Vote
	(*CreatePollRequest_CreatePollChoice)(nil),  // 15: twitch.polls.pollpatine.CreatePollRequest.CreatePollChoice
	(*PollSettings_MultiChoicePollSetting)(nil), // 16: twitch.polls.pollpatine.PollSettings.MultiChoicePollSetting
	(*PollSettings_MaxUserVotesSetting)(nil),    // 17: twitch.polls.pollpatine.PollSettings.MaxUserVotesSetting
	(*duration.Duration)(nil),                   // 18: google.protobuf.Duration
	(*timestamp.Timestamp)(nil),                 // 19: google.protobuf.Timestamp
}
var file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_depIdxs = []int32{
	18, // 0: twitch.polls.pollpatine.CreatePollRequest.duration:type_name -> google.protobuf.Duration
	15, // 1: twitch.polls.pollpatine.CreatePollRequest.choices:type_name -> twitch.polls.pollpatine.CreatePollRequest.CreatePollChoice
	11, // 2: twitch.polls.pollpatine.CreatePollRequest.settings:type_name -> twitch.polls.pollpatine.PollSettings
	19, // 3: twitch.polls.pollpatine.CreatePollRequest.ttl:type_name -> google.protobuf.Timestamp
	13, // 4: twitch.polls.pollpatine.CreatePollResponse.poll:type_name -> twitch.polls.pollpatine.Poll
	13, // 5: twitch.polls.pollpatine.GetPollResponse.poll:type_name -> twitch.polls.pollpatine.Poll
	14, // 6: twitch.polls.pollpatine.GetVotesForVoterResponse.votes:type_name -> twitch.polls.pollpatine.Vote
	14, // 7: twitch.polls.pollpatine.VoteResponse.vote:type_name -> twitch.polls.pollpatine.Vote
	16, // 8: twitch.polls.pollpatine.PollSettings.multi_choice:type_name -> twitch.polls.pollpatine.PollSettings.MultiChoicePollSetting
	17, // 9: twitch.polls.pollpatine.PollSettings.max_user_votes:type_name -> twitch.polls.pollpatine.PollSettings.MaxUserVotesSetting
	19, // 10: twitch.polls.pollpatine.Poll.start_time:type_name -> google.protobuf.Timestamp
	19, // 11: twitch.polls.pollpatine.Poll.end_time:type_name -> google.protobuf.Timestamp
	18, // 12: twitch.polls.pollpatine.Poll.duration:type_name -> google.protobuf.Duration
	11, // 13: twitch.polls.pollpatine.Poll.settings:type_name -> twitch.polls.pollpatine.PollSettings
	0,  // 14: twitch.polls.pollpatine.Poll.status:type_name -> twitch.polls.pollpatine.PollStatus
	12, // 15: twitch.polls.pollpatine.Poll.choices:type_name -> twitch.polls.pollpatine.Choice
	18, // 16: twitch.polls.pollpatine.Poll.remaining_duration:type_name -> google.protobuf.Duration
	3,  // 17: twitch.polls.pollpatine.Pollpatine.CreatePoll:input_type -> twitch.polls.pollpatine.CreatePollRequest
	4,  // 18: twitch.polls.pollpatine.Pollpatine.GetPoll:input_type -> twitch.polls.pollpatine.GetPollRequest
	5,  // 19: twitch.polls.pollpatine.Pollpatine.GetVotesForVoter:input_type -> twitch.polls.pollpatine.GetVotesForVoterRequest
	6,  // 20: twitch.polls.pollpatine.Pollpatine.Vote:input_type -> twitch.polls.pollpatine.VoteRequest
	7,  // 21: twitch.polls.pollpatine.Pollpatine.CreatePoll:output_type -> twitch.polls.pollpatine.CreatePollResponse
	8,  // 22: twitch.polls.pollpatine.Pollpatine.GetPoll:output_type -> twitch.polls.pollpatine.GetPollResponse
	9,  // 23: twitch.polls.pollpatine.Pollpatine.GetVotesForVoter:output_type -> twitch.polls.pollpatine.GetVotesForVoterResponse
	10, // 24: twitch.polls.pollpatine.Pollpatine.Vote:output_type -> twitch.polls.pollpatine.VoteResponse
	21, // [21:25] is the sub-list for method output_type
	17, // [17:21] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_init() }
func file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_init() {
	if File_code_justin_tv_amzn_PollpatineTwirp_twirp_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePollRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPollRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVotesForVoterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VoteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePollResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPollResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVotesForVoterResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VoteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Choice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Poll); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePollRequest_CreatePollChoice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollSettings_MultiChoicePollSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PollSettings_MaxUserVotesSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_goTypes,
		DependencyIndexes: file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_depIdxs,
		EnumInfos:         file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_enumTypes,
		MessageInfos:      file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_msgTypes,
	}.Build()
	File_code_justin_tv_amzn_PollpatineTwirp_twirp_proto = out.File
	file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_rawDesc = nil
	file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_goTypes = nil
	file_code_justin_tv_amzn_PollpatineTwirp_twirp_proto_depIdxs = nil
}
