// Code generated by cmd/generator/main.go, DO NOT EDIT.
// source: code.justin.tv/amzn/SiosaTwirp/twirp.pb.go
package SiosaTwirp

import (
	"encoding/json"
	"fmt"
	"reflect"
)

type ChannelPropertiesDynamoRecord struct {
	AdExperimentBucketsStr                     string                        `json:"ad_experiment_buckets"`
	AdExperimentBuckets                        *AdExperimentBuckets          `json:"_ad_experiment_buckets"`
	AdServerDefault                            string                        `json:"ad_server_default"`
	AutoAdsEnabled                             bool                          `json:"auto_ads_enabled"`
	AutoAdsLength                              int32                         `json:"auto_ads_length"`
	CampaignType                               string                        `json:"campaign_type"`
	CommunityBoostAllDisabled                  bool                          `json:"community_boost_all_disabled"`
	CommunityBoostEarnedDisabled               bool                          `json:"community_boost_earned_disabled"`
	CommunityBoostPaidDisabled                 bool                          `json:"community_boost_paid_disabled"`
	CommunityBoostProductEligible              bool                          `json:"community_boost_product_eligible"`
	CostreamersStr                             string                        `json:"costreamers"`
	Costreamers                                *Costreamers                  `json:"_costreamers"`
	DisablePrerollsFeatureAdminEnabled         bool                          `json:"disable_prerolls_feature_admin_enabled"`
	DisablePrerollsFeatureEnabled              bool                          `json:"disable_prerolls_feature_enabled"`
	DisablePrerollsFeatureMaxCapacity          int32                         `json:"disable_prerolls_feature_max_capacity"`
	DisablePrerollsFeatureNotificationsEnabled bool                          `json:"disable_prerolls_feature_notifications_enabled"`
	DisablePrerollsFeatureValuesStr            string                        `json:"disable_prerolls_feature_values"`
	DisablePrerollsFeatureValues               *DisablePrerollsFeatureValues `json:"_disable_prerolls_feature_values"`
	ForceClientAds                             bool                          `json:"force_client_ads"`
	ForceServerAds                             bool                          `json:"force_server_ads"`
	Frequency                                  int32                         `json:"frequency"`
	GuaranteeAds                               bool                          `json:"guarantee_ads"`
	MaxAdBreakLength                           int32                         `json:"max_ad_break_length"`
	PbypDisabled                               bool                          `json:"pbyp_disabled"`
	PostrollsDisabled                          bool                          `json:"postrolls_disabled"`
	PrerollsDisabled                           bool                          `json:"prerolls_disabled"`
	RequiredAge                                int32                         `json:"required_age"`
	ShowMultiplayerAdsToSubs                   bool                          `json:"show_multiplayer_ads_to_subs"`
	StreamDisplayAdsDisabled                   bool                          `json:"stream_display_ads_disabled"`
	StreamDisplayAdsProductEligible            bool                          `json:"stream_display_ads_product_eligible"`
	TrackingPixelsStr                          string                        `json:"tracking_pixels"`
	TrackingPixels                             *TrackingPixels               `json:"_tracking_pixels"`
	TurboDisabled                              bool                          `json:"turbo_disabled"`
	VodAdsEnabled                              bool                          `json:"vod_ads_enabled"`
	VodArchiveMidrolls                         string                        `json:"vod_archive_midrolls"`
	VodArchiveMidrollsBreakLength              int32                         `json:"vod_archive_midrolls_break_length"`
	VodArchiveMidrollsFrequency                int32                         `json:"vod_archive_midrolls_frequency"`
}

func DynamoRecordToAdProps(props *ChannelPropertiesDynamoRecord, fields []string) ([]*AdProperty, error) {
	adProps := []*AdProperty{}
	for _, key := range fields {
		switch key {
		case "ad_experiment_buckets":
			if props.AdExperimentBucketsStr != "" && props.AdExperimentBuckets == nil {
				return nil, fmt.Errorf("%s cannot be empty. Set defaults by calling FillDefaults", key)
			}
			var res *AdExperimentBuckets
			if props.AdExperimentBucketsStr != "" {
				err := json.Unmarshal([]byte(props.AdExperimentBucketsStr), &res)
				if err != nil {
					return nil, err
				}
				adProps = append(adProps, &AdProperty{Property: &AdProperty_AdExperimentBuckets{AdExperimentBuckets: res}})
				continue
			}
			adProps = append(adProps, &AdProperty{Property: &AdProperty_AdExperimentBuckets{AdExperimentBuckets: props.AdExperimentBuckets}})
		case "ad_server_default":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_AdServerDefault{AdServerDefault: props.AdServerDefault}})
		case "auto_ads_enabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_AutoAdsEnabled{AutoAdsEnabled: props.AutoAdsEnabled}})
		case "auto_ads_length":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_AutoAdsLength{AutoAdsLength: props.AutoAdsLength}})
		case "campaign_type":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_CampaignType{CampaignType: props.CampaignType}})
		case "community_boost_all_disabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_CommunityBoostAllDisabled{CommunityBoostAllDisabled: props.CommunityBoostAllDisabled}})
		case "community_boost_earned_disabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_CommunityBoostEarnedDisabled{CommunityBoostEarnedDisabled: props.CommunityBoostEarnedDisabled}})
		case "community_boost_paid_disabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_CommunityBoostPaidDisabled{CommunityBoostPaidDisabled: props.CommunityBoostPaidDisabled}})
		case "community_boost_product_eligible":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_CommunityBoostProductEligible{CommunityBoostProductEligible: props.CommunityBoostProductEligible}})
		case "costreamers":
			if props.CostreamersStr != "" && props.Costreamers == nil {
				return nil, fmt.Errorf("%s cannot be empty. Set defaults by calling FillDefaults", key)
			}
			var res *Costreamers
			if props.CostreamersStr != "" {
				err := json.Unmarshal([]byte(props.CostreamersStr), &res)
				if err != nil {
					return nil, err
				}
				adProps = append(adProps, &AdProperty{Property: &AdProperty_Costreamers{Costreamers: res}})
				continue
			}
			adProps = append(adProps, &AdProperty{Property: &AdProperty_Costreamers{Costreamers: props.Costreamers}})
		case "disable_prerolls_feature_admin_enabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_DisablePrerollsFeatureAdminEnabled{DisablePrerollsFeatureAdminEnabled: props.DisablePrerollsFeatureAdminEnabled}})
		case "disable_prerolls_feature_enabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_DisablePrerollsFeatureEnabled{DisablePrerollsFeatureEnabled: props.DisablePrerollsFeatureEnabled}})
		case "disable_prerolls_feature_max_capacity":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_DisablePrerollsFeatureMaxCapacity{DisablePrerollsFeatureMaxCapacity: props.DisablePrerollsFeatureMaxCapacity}})
		case "disable_prerolls_feature_notifications_enabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_DisablePrerollsFeatureNotificationsEnabled{DisablePrerollsFeatureNotificationsEnabled: props.DisablePrerollsFeatureNotificationsEnabled}})
		case "disable_prerolls_feature_values":
			if props.DisablePrerollsFeatureValuesStr != "" && props.DisablePrerollsFeatureValues == nil {
				return nil, fmt.Errorf("%s cannot be empty. Set defaults by calling FillDefaults", key)
			}
			var res *DisablePrerollsFeatureValues
			if props.DisablePrerollsFeatureValuesStr != "" {
				err := json.Unmarshal([]byte(props.DisablePrerollsFeatureValuesStr), &res)
				if err != nil {
					return nil, err
				}
				adProps = append(adProps, &AdProperty{Property: &AdProperty_DisablePrerollsFeatureValues{DisablePrerollsFeatureValues: res}})
				continue
			}
			adProps = append(adProps, &AdProperty{Property: &AdProperty_DisablePrerollsFeatureValues{DisablePrerollsFeatureValues: props.DisablePrerollsFeatureValues}})
		case "force_client_ads":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_ForceClientAds{ForceClientAds: props.ForceClientAds}})
		case "force_server_ads":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_ForceServerAds{ForceServerAds: props.ForceServerAds}})
		case "frequency":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_Frequency{Frequency: props.Frequency}})
		case "guarantee_ads":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_GuaranteeAds{GuaranteeAds: props.GuaranteeAds}})
		case "max_ad_break_length":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_MaxAdBreakLength{MaxAdBreakLength: props.MaxAdBreakLength}})
		case "pbyp_disabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_PbypDisabled{PbypDisabled: props.PbypDisabled}})
		case "postrolls_disabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_PostrollsDisabled{PostrollsDisabled: props.PostrollsDisabled}})
		case "prerolls_disabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_PrerollsDisabled{PrerollsDisabled: props.PrerollsDisabled}})
		case "required_age":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_RequiredAge{RequiredAge: props.RequiredAge}})
		case "show_multiplayer_ads_to_subs":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_ShowMultiplayerAdsToSubs{ShowMultiplayerAdsToSubs: props.ShowMultiplayerAdsToSubs}})
		case "stream_display_ads_disabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_StreamDisplayAdsDisabled{StreamDisplayAdsDisabled: props.StreamDisplayAdsDisabled}})
		case "stream_display_ads_product_eligible":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_StreamDisplayAdsProductEligible{StreamDisplayAdsProductEligible: props.StreamDisplayAdsProductEligible}})
		case "tracking_pixels":
			if props.TrackingPixelsStr != "" && props.TrackingPixels == nil {
				return nil, fmt.Errorf("%s cannot be empty. Set defaults by calling FillDefaults", key)
			}
			var res *TrackingPixels
			if props.TrackingPixelsStr != "" {
				err := json.Unmarshal([]byte(props.TrackingPixelsStr), &res)
				if err != nil {
					return nil, err
				}
				adProps = append(adProps, &AdProperty{Property: &AdProperty_TrackingPixels{TrackingPixels: res}})
				continue
			}
			adProps = append(adProps, &AdProperty{Property: &AdProperty_TrackingPixels{TrackingPixels: props.TrackingPixels}})
		case "turbo_disabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_TurboDisabled{TurboDisabled: props.TurboDisabled}})
		case "vod_ads_enabled":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_VodAdsEnabled{VodAdsEnabled: props.VodAdsEnabled}})
		case "vod_archive_midrolls":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_VodArchiveMidrolls{VodArchiveMidrolls: props.VodArchiveMidrolls}})
		case "vod_archive_midrolls_break_length":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_VodArchiveMidrollsBreakLength{VodArchiveMidrollsBreakLength: props.VodArchiveMidrollsBreakLength}})
		case "vod_archive_midrolls_frequency":
			adProps = append(adProps, &AdProperty{Property: &AdProperty_VodArchiveMidrollsFrequency{VodArchiveMidrollsFrequency: props.VodArchiveMidrollsFrequency}})

		default:
			return nil, fmt.Errorf("key %s not found", key)
		}
	}

	return adProps, nil
}

// InitAdPropertyFuncs returns a map of functions that can parse each column into the corresponding AdProperty type
func InitAdPropertyFuncs() map[string]func(interface{}) (isAdProperty_Property, error) {
	return map[string]func(interface{}) (isAdProperty_Property, error){
		"ad_experiment_buckets": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(*AdExperimentBuckets)
			if ok {
				return &AdProperty_AdExperimentBuckets{AdExperimentBuckets: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type *AdExperimentBuckets or complex JSON string")
			}
			var res *AdExperimentBuckets
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_AdExperimentBuckets{AdExperimentBuckets: res}, nil
		},
		"ad_server_default": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(string)
			if ok {
				return &AdProperty_AdServerDefault{AdServerDefault: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type string or complex JSON string")
			}
			var res string
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_AdServerDefault{AdServerDefault: res}, nil
		},
		"auto_ads_enabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_AutoAdsEnabled{AutoAdsEnabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_AutoAdsEnabled{AutoAdsEnabled: res}, nil
		},
		"auto_ads_length": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(int32)
			if ok {
				return &AdProperty_AutoAdsLength{AutoAdsLength: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type int32 or complex JSON string")
			}
			var res int32
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_AutoAdsLength{AutoAdsLength: res}, nil
		},
		"campaign_type": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(string)
			if ok {
				return &AdProperty_CampaignType{CampaignType: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type string or complex JSON string")
			}
			var res string
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_CampaignType{CampaignType: res}, nil
		},
		"community_boost_all_disabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_CommunityBoostAllDisabled{CommunityBoostAllDisabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_CommunityBoostAllDisabled{CommunityBoostAllDisabled: res}, nil
		},
		"community_boost_earned_disabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_CommunityBoostEarnedDisabled{CommunityBoostEarnedDisabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_CommunityBoostEarnedDisabled{CommunityBoostEarnedDisabled: res}, nil
		},
		"community_boost_paid_disabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_CommunityBoostPaidDisabled{CommunityBoostPaidDisabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_CommunityBoostPaidDisabled{CommunityBoostPaidDisabled: res}, nil
		},
		"community_boost_product_eligible": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_CommunityBoostProductEligible{CommunityBoostProductEligible: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_CommunityBoostProductEligible{CommunityBoostProductEligible: res}, nil
		},
		"costreamers": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(*Costreamers)
			if ok {
				return &AdProperty_Costreamers{Costreamers: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type *Costreamers or complex JSON string")
			}
			var res *Costreamers
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_Costreamers{Costreamers: res}, nil
		},
		"disable_prerolls_feature_admin_enabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_DisablePrerollsFeatureAdminEnabled{DisablePrerollsFeatureAdminEnabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_DisablePrerollsFeatureAdminEnabled{DisablePrerollsFeatureAdminEnabled: res}, nil
		},
		"disable_prerolls_feature_enabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_DisablePrerollsFeatureEnabled{DisablePrerollsFeatureEnabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_DisablePrerollsFeatureEnabled{DisablePrerollsFeatureEnabled: res}, nil
		},
		"disable_prerolls_feature_max_capacity": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(int32)
			if ok {
				return &AdProperty_DisablePrerollsFeatureMaxCapacity{DisablePrerollsFeatureMaxCapacity: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type int32 or complex JSON string")
			}
			var res int32
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_DisablePrerollsFeatureMaxCapacity{DisablePrerollsFeatureMaxCapacity: res}, nil
		},
		"disable_prerolls_feature_notifications_enabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_DisablePrerollsFeatureNotificationsEnabled{DisablePrerollsFeatureNotificationsEnabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_DisablePrerollsFeatureNotificationsEnabled{DisablePrerollsFeatureNotificationsEnabled: res}, nil
		},
		"disable_prerolls_feature_values": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(*DisablePrerollsFeatureValues)
			if ok {
				return &AdProperty_DisablePrerollsFeatureValues{DisablePrerollsFeatureValues: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type *DisablePrerollsFeatureValues or complex JSON string")
			}
			var res *DisablePrerollsFeatureValues
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_DisablePrerollsFeatureValues{DisablePrerollsFeatureValues: res}, nil
		},
		"force_client_ads": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_ForceClientAds{ForceClientAds: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_ForceClientAds{ForceClientAds: res}, nil
		},
		"force_server_ads": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_ForceServerAds{ForceServerAds: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_ForceServerAds{ForceServerAds: res}, nil
		},
		"frequency": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(int32)
			if ok {
				return &AdProperty_Frequency{Frequency: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type int32 or complex JSON string")
			}
			var res int32
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_Frequency{Frequency: res}, nil
		},
		"guarantee_ads": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_GuaranteeAds{GuaranteeAds: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_GuaranteeAds{GuaranteeAds: res}, nil
		},
		"max_ad_break_length": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(int32)
			if ok {
				return &AdProperty_MaxAdBreakLength{MaxAdBreakLength: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type int32 or complex JSON string")
			}
			var res int32
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_MaxAdBreakLength{MaxAdBreakLength: res}, nil
		},
		"pbyp_disabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_PbypDisabled{PbypDisabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_PbypDisabled{PbypDisabled: res}, nil
		},
		"postrolls_disabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_PostrollsDisabled{PostrollsDisabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_PostrollsDisabled{PostrollsDisabled: res}, nil
		},
		"prerolls_disabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_PrerollsDisabled{PrerollsDisabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_PrerollsDisabled{PrerollsDisabled: res}, nil
		},
		"required_age": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(int32)
			if ok {
				return &AdProperty_RequiredAge{RequiredAge: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type int32 or complex JSON string")
			}
			var res int32
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_RequiredAge{RequiredAge: res}, nil
		},
		"show_multiplayer_ads_to_subs": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_ShowMultiplayerAdsToSubs{ShowMultiplayerAdsToSubs: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_ShowMultiplayerAdsToSubs{ShowMultiplayerAdsToSubs: res}, nil
		},
		"stream_display_ads_disabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_StreamDisplayAdsDisabled{StreamDisplayAdsDisabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_StreamDisplayAdsDisabled{StreamDisplayAdsDisabled: res}, nil
		},
		"stream_display_ads_product_eligible": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_StreamDisplayAdsProductEligible{StreamDisplayAdsProductEligible: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_StreamDisplayAdsProductEligible{StreamDisplayAdsProductEligible: res}, nil
		},
		"tracking_pixels": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(*TrackingPixels)
			if ok {
				return &AdProperty_TrackingPixels{TrackingPixels: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type *TrackingPixels or complex JSON string")
			}
			var res *TrackingPixels
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_TrackingPixels{TrackingPixels: res}, nil
		},
		"turbo_disabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_TurboDisabled{TurboDisabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_TurboDisabled{TurboDisabled: res}, nil
		},
		"vod_ads_enabled": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(bool)
			if ok {
				return &AdProperty_VodAdsEnabled{VodAdsEnabled: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type bool or complex JSON string")
			}
			var res bool
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_VodAdsEnabled{VodAdsEnabled: res}, nil
		},
		"vod_archive_midrolls": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(string)
			if ok {
				return &AdProperty_VodArchiveMidrolls{VodArchiveMidrolls: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type string or complex JSON string")
			}
			var res string
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_VodArchiveMidrolls{VodArchiveMidrolls: res}, nil
		},
		"vod_archive_midrolls_break_length": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(int32)
			if ok {
				return &AdProperty_VodArchiveMidrollsBreakLength{VodArchiveMidrollsBreakLength: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type int32 or complex JSON string")
			}
			var res int32
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_VodArchiveMidrollsBreakLength{VodArchiveMidrollsBreakLength: res}, nil
		},
		"vod_archive_midrolls_frequency": func(i interface{}) (isAdProperty_Property, error) {
			val, ok := i.(int32)
			if ok {
				return &AdProperty_VodArchiveMidrollsFrequency{VodArchiveMidrollsFrequency: val}, nil
			}
			str, ok := i.(string)
			if !ok {
				return nil, fmt.Errorf("input is not of type int32 or complex JSON string")
			}
			var res int32
			err := json.Unmarshal([]byte(str), &res)
			if err != nil {
				return nil, fmt.Errorf("failed to unmarshal complex type: %v", err)
			}
			return &AdProperty_VodArchiveMidrollsFrequency{VodArchiveMidrollsFrequency: res}, nil
		},
	}
}

// MarshalJSON marshals an AdProperties struct to JSON bytes
func (p *AdProperties) MarshalJSON() ([]byte, error) {
	m := map[string]interface{}{}
	for _, adProperty := range p.Properties {
		switch t := adProperty.Property.(type) {
		case *AdProperty_AdExperimentBuckets:
			m["ad_experiment_buckets"] = t.AdExperimentBuckets
		case *AdProperty_AdServerDefault:
			m["ad_server_default"] = t.AdServerDefault
		case *AdProperty_AutoAdsEnabled:
			m["auto_ads_enabled"] = t.AutoAdsEnabled
		case *AdProperty_AutoAdsLength:
			m["auto_ads_length"] = t.AutoAdsLength
		case *AdProperty_CampaignType:
			m["campaign_type"] = t.CampaignType
		case *AdProperty_CommunityBoostAllDisabled:
			m["community_boost_all_disabled"] = t.CommunityBoostAllDisabled
		case *AdProperty_CommunityBoostEarnedDisabled:
			m["community_boost_earned_disabled"] = t.CommunityBoostEarnedDisabled
		case *AdProperty_CommunityBoostPaidDisabled:
			m["community_boost_paid_disabled"] = t.CommunityBoostPaidDisabled
		case *AdProperty_CommunityBoostProductEligible:
			m["community_boost_product_eligible"] = t.CommunityBoostProductEligible
		case *AdProperty_Costreamers:
			m["costreamers"] = t.Costreamers
		case *AdProperty_DisablePrerollsFeatureAdminEnabled:
			m["disable_prerolls_feature_admin_enabled"] = t.DisablePrerollsFeatureAdminEnabled
		case *AdProperty_DisablePrerollsFeatureEnabled:
			m["disable_prerolls_feature_enabled"] = t.DisablePrerollsFeatureEnabled
		case *AdProperty_DisablePrerollsFeatureMaxCapacity:
			m["disable_prerolls_feature_max_capacity"] = t.DisablePrerollsFeatureMaxCapacity
		case *AdProperty_DisablePrerollsFeatureNotificationsEnabled:
			m["disable_prerolls_feature_notifications_enabled"] = t.DisablePrerollsFeatureNotificationsEnabled
		case *AdProperty_DisablePrerollsFeatureValues:
			m["disable_prerolls_feature_values"] = t.DisablePrerollsFeatureValues
		case *AdProperty_ForceClientAds:
			m["force_client_ads"] = t.ForceClientAds
		case *AdProperty_ForceServerAds:
			m["force_server_ads"] = t.ForceServerAds
		case *AdProperty_Frequency:
			m["frequency"] = t.Frequency
		case *AdProperty_GuaranteeAds:
			m["guarantee_ads"] = t.GuaranteeAds
		case *AdProperty_MaxAdBreakLength:
			m["max_ad_break_length"] = t.MaxAdBreakLength
		case *AdProperty_PbypDisabled:
			m["pbyp_disabled"] = t.PbypDisabled
		case *AdProperty_PostrollsDisabled:
			m["postrolls_disabled"] = t.PostrollsDisabled
		case *AdProperty_PrerollsDisabled:
			m["prerolls_disabled"] = t.PrerollsDisabled
		case *AdProperty_RequiredAge:
			m["required_age"] = t.RequiredAge
		case *AdProperty_ShowMultiplayerAdsToSubs:
			m["show_multiplayer_ads_to_subs"] = t.ShowMultiplayerAdsToSubs
		case *AdProperty_StreamDisplayAdsDisabled:
			m["stream_display_ads_disabled"] = t.StreamDisplayAdsDisabled
		case *AdProperty_StreamDisplayAdsProductEligible:
			m["stream_display_ads_product_eligible"] = t.StreamDisplayAdsProductEligible
		case *AdProperty_TrackingPixels:
			m["tracking_pixels"] = t.TrackingPixels
		case *AdProperty_TurboDisabled:
			m["turbo_disabled"] = t.TurboDisabled
		case *AdProperty_VodAdsEnabled:
			m["vod_ads_enabled"] = t.VodAdsEnabled
		case *AdProperty_VodArchiveMidrolls:
			m["vod_archive_midrolls"] = t.VodArchiveMidrolls
		case *AdProperty_VodArchiveMidrollsBreakLength:
			m["vod_archive_midrolls_break_length"] = t.VodArchiveMidrollsBreakLength
		case *AdProperty_VodArchiveMidrollsFrequency:
			m["vod_archive_midrolls_frequency"] = t.VodArchiveMidrollsFrequency
		}
	}
	return json.Marshal(m)
}

func AdPropertiesToMapInterface(props []*AdProperty) (map[string]interface{}, error) {
	mapProps := map[string]interface{}{}
	for _, prop := range props {
		switch prop.Property.(type) {
		case *AdProperty_AdExperimentBuckets:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["ad_experiment_buckets"] = interfaceVal
		case *AdProperty_AdServerDefault:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["ad_server_default"] = interfaceVal
		case *AdProperty_AutoAdsEnabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["auto_ads_enabled"] = interfaceVal
		case *AdProperty_AutoAdsLength:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["auto_ads_length"] = interfaceVal
		case *AdProperty_CampaignType:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["campaign_type"] = interfaceVal
		case *AdProperty_CommunityBoostAllDisabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["community_boost_all_disabled"] = interfaceVal
		case *AdProperty_CommunityBoostEarnedDisabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["community_boost_earned_disabled"] = interfaceVal
		case *AdProperty_CommunityBoostPaidDisabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["community_boost_paid_disabled"] = interfaceVal
		case *AdProperty_CommunityBoostProductEligible:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["community_boost_product_eligible"] = interfaceVal
		case *AdProperty_Costreamers:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["costreamers"] = interfaceVal
		case *AdProperty_DisablePrerollsFeatureAdminEnabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["disable_prerolls_feature_admin_enabled"] = interfaceVal
		case *AdProperty_DisablePrerollsFeatureEnabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["disable_prerolls_feature_enabled"] = interfaceVal
		case *AdProperty_DisablePrerollsFeatureMaxCapacity:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["disable_prerolls_feature_max_capacity"] = interfaceVal
		case *AdProperty_DisablePrerollsFeatureNotificationsEnabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["disable_prerolls_feature_notifications_enabled"] = interfaceVal
		case *AdProperty_DisablePrerollsFeatureValues:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["disable_prerolls_feature_values"] = interfaceVal
		case *AdProperty_ForceClientAds:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["force_client_ads"] = interfaceVal
		case *AdProperty_ForceServerAds:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["force_server_ads"] = interfaceVal
		case *AdProperty_Frequency:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["frequency"] = interfaceVal
		case *AdProperty_GuaranteeAds:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["guarantee_ads"] = interfaceVal
		case *AdProperty_MaxAdBreakLength:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["max_ad_break_length"] = interfaceVal
		case *AdProperty_PbypDisabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["pbyp_disabled"] = interfaceVal
		case *AdProperty_PostrollsDisabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["postrolls_disabled"] = interfaceVal
		case *AdProperty_PrerollsDisabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["prerolls_disabled"] = interfaceVal
		case *AdProperty_RequiredAge:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["required_age"] = interfaceVal
		case *AdProperty_ShowMultiplayerAdsToSubs:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["show_multiplayer_ads_to_subs"] = interfaceVal
		case *AdProperty_StreamDisplayAdsDisabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["stream_display_ads_disabled"] = interfaceVal
		case *AdProperty_StreamDisplayAdsProductEligible:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["stream_display_ads_product_eligible"] = interfaceVal
		case *AdProperty_TrackingPixels:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["tracking_pixels"] = interfaceVal
		case *AdProperty_TurboDisabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["turbo_disabled"] = interfaceVal
		case *AdProperty_VodAdsEnabled:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["vod_ads_enabled"] = interfaceVal
		case *AdProperty_VodArchiveMidrolls:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["vod_archive_midrolls"] = interfaceVal
		case *AdProperty_VodArchiveMidrollsBreakLength:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["vod_archive_midrolls_break_length"] = interfaceVal
		case *AdProperty_VodArchiveMidrollsFrequency:
			interfaceVal, err := prop.ConvertToInterface()
			if err != nil {
				return nil, err
			}
			mapProps["vod_archive_midrolls_frequency"] = interfaceVal
		default:
			return nil, fmt.Errorf("%v not a valid property", prop)
		}
	}
	return mapProps, nil
}

// ConvertToInterface converts an AdProperty struct to underlying data types
func (adProperty *AdProperty) ConvertToInterface() (interface{}, error) {
	val := reflect.ValueOf(adProperty.Property).Elem().Field(0)
	switch val.Kind() {
	case reflect.Int:
		return val.Int(), nil
	case reflect.Int32:
		return int32(val.Int()), nil
	case reflect.String:
		return val.String(), nil
	case reflect.Bool:
		return val.Bool(), nil
	case reflect.Ptr:
		// If the value is a pointer, switch on its struct type
		switch val.Type() {
		case reflect.TypeOf(&AdExperimentBuckets{}):
			ptr, _ := val.Interface().(*AdExperimentBuckets)
			res, err := json.Marshal(ptr)
			if err != nil {
				return nil, err
			}
			return string(res), nil
		case reflect.TypeOf(&Costreamers{}):
			ptr, _ := val.Interface().(*Costreamers)
			res, err := json.Marshal(ptr)
			if err != nil {
				return nil, err
			}
			return string(res), nil
		case reflect.TypeOf(&DisablePrerollsFeatureValues{}):
			ptr, _ := val.Interface().(*DisablePrerollsFeatureValues)
			res, err := json.Marshal(ptr)
			if err != nil {
				return nil, err
			}
			return string(res), nil
		case reflect.TypeOf(&TrackingPixels{}):
			ptr, _ := val.Interface().(*TrackingPixels)
			res, err := json.Marshal(ptr)
			if err != nil {
				return nil, err
			}
			return string(res), nil
		default:
			return nil, fmt.Errorf("unknown pointer type")
		}
	default:
		return nil, fmt.Errorf("unsupported column type")
	}
}
