// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/SoundtrackPlaylistTwirp/twirp.proto

/*
Package SoundtrackPlaylistTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/SoundtrackPlaylistTwirp/twirp.proto
*/
package SoundtrackPlaylistTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ============================
// SoundtrackPlaylist Interface
// ============================

type SoundtrackPlaylist interface {
	GetPlaylist(context.Context, *GetPlaylistRequest) (*GetPlaylistResponse, error)

	GetPlaylists(context.Context, *GetPlaylistsRequest) (*GetPlaylistsResponse, error)

	CreatePlaylist(context.Context, *CreatePlaylistRequest) (*CreatePlaylistResponse, error)

	UpdatePlaylist(context.Context, *UpdatePlaylistRequest) (*UpdatePlaylistResponse, error)

	DeletePlaylists(context.Context, *DeletePlaylistsRequest) (*DeletePlaylistsResponse, error)

	AddTrackToPlaylist(context.Context, *AddTrackToPlaylistRequest) (*AddTrackToPlaylistResponse, error)

	MoveTrackInPlaylist(context.Context, *MoveTrackInPlaylistRequest) (*MoveTrackInPlaylistResponse, error)

	RemoveTrackFromPlaylist(context.Context, *RemoveTrackFromPlaylistRequest) (*RemoveTrackFromPlaylistResponse, error)

	AddTracksToPlaylist(context.Context, *AddTracksToPlaylistRequest) (*AddTracksToPlaylistResponse, error)

	MoveTracksInPlaylist(context.Context, *MoveTracksInPlaylistRequest) (*MoveTracksInPlaylistResponse, error)

	RemoveTracksFromPlaylist(context.Context, *RemoveTracksFromPlaylistRequest) (*RemoveTracksFromPlaylistResponse, error)
}

// ==================================
// SoundtrackPlaylist Protobuf Client
// ==================================

type soundtrackPlaylistProtobufClient struct {
	client HTTPClient
	urls   [11]string
	opts   twirp.ClientOptions
}

// NewSoundtrackPlaylistProtobufClient creates a Protobuf client that implements the SoundtrackPlaylist interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewSoundtrackPlaylistProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) SoundtrackPlaylist {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + SoundtrackPlaylistPathPrefix
	urls := [11]string{
		prefix + "GetPlaylist",
		prefix + "GetPlaylists",
		prefix + "CreatePlaylist",
		prefix + "UpdatePlaylist",
		prefix + "DeletePlaylists",
		prefix + "AddTrackToPlaylist",
		prefix + "MoveTrackInPlaylist",
		prefix + "RemoveTrackFromPlaylist",
		prefix + "AddTracksToPlaylist",
		prefix + "MoveTracksInPlaylist",
		prefix + "RemoveTracksFromPlaylist",
	}

	return &soundtrackPlaylistProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *soundtrackPlaylistProtobufClient) GetPlaylist(ctx context.Context, in *GetPlaylistRequest) (*GetPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylist")
	out := new(GetPlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) GetPlaylists(ctx context.Context, in *GetPlaylistsRequest) (*GetPlaylistsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylists")
	out := new(GetPlaylistsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) CreatePlaylist(ctx context.Context, in *CreatePlaylistRequest) (*CreatePlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "CreatePlaylist")
	out := new(CreatePlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) UpdatePlaylist(ctx context.Context, in *UpdatePlaylistRequest) (*UpdatePlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePlaylist")
	out := new(UpdatePlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) DeletePlaylists(ctx context.Context, in *DeletePlaylistsRequest) (*DeletePlaylistsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "DeletePlaylists")
	out := new(DeletePlaylistsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) AddTrackToPlaylist(ctx context.Context, in *AddTrackToPlaylistRequest) (*AddTrackToPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "AddTrackToPlaylist")
	out := new(AddTrackToPlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) MoveTrackInPlaylist(ctx context.Context, in *MoveTrackInPlaylistRequest) (*MoveTrackInPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "MoveTrackInPlaylist")
	out := new(MoveTrackInPlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) RemoveTrackFromPlaylist(ctx context.Context, in *RemoveTrackFromPlaylistRequest) (*RemoveTrackFromPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveTrackFromPlaylist")
	out := new(RemoveTrackFromPlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) AddTracksToPlaylist(ctx context.Context, in *AddTracksToPlaylistRequest) (*AddTracksToPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "AddTracksToPlaylist")
	out := new(AddTracksToPlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) MoveTracksInPlaylist(ctx context.Context, in *MoveTracksInPlaylistRequest) (*MoveTracksInPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "MoveTracksInPlaylist")
	out := new(MoveTracksInPlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistProtobufClient) RemoveTracksFromPlaylist(ctx context.Context, in *RemoveTracksFromPlaylistRequest) (*RemoveTracksFromPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveTracksFromPlaylist")
	out := new(RemoveTracksFromPlaylistResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// SoundtrackPlaylist JSON Client
// ==============================

type soundtrackPlaylistJSONClient struct {
	client HTTPClient
	urls   [11]string
	opts   twirp.ClientOptions
}

// NewSoundtrackPlaylistJSONClient creates a JSON client that implements the SoundtrackPlaylist interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewSoundtrackPlaylistJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) SoundtrackPlaylist {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + SoundtrackPlaylistPathPrefix
	urls := [11]string{
		prefix + "GetPlaylist",
		prefix + "GetPlaylists",
		prefix + "CreatePlaylist",
		prefix + "UpdatePlaylist",
		prefix + "DeletePlaylists",
		prefix + "AddTrackToPlaylist",
		prefix + "MoveTrackInPlaylist",
		prefix + "RemoveTrackFromPlaylist",
		prefix + "AddTracksToPlaylist",
		prefix + "MoveTracksInPlaylist",
		prefix + "RemoveTracksFromPlaylist",
	}

	return &soundtrackPlaylistJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *soundtrackPlaylistJSONClient) GetPlaylist(ctx context.Context, in *GetPlaylistRequest) (*GetPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylist")
	out := new(GetPlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) GetPlaylists(ctx context.Context, in *GetPlaylistsRequest) (*GetPlaylistsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylists")
	out := new(GetPlaylistsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) CreatePlaylist(ctx context.Context, in *CreatePlaylistRequest) (*CreatePlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "CreatePlaylist")
	out := new(CreatePlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) UpdatePlaylist(ctx context.Context, in *UpdatePlaylistRequest) (*UpdatePlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePlaylist")
	out := new(UpdatePlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) DeletePlaylists(ctx context.Context, in *DeletePlaylistsRequest) (*DeletePlaylistsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "DeletePlaylists")
	out := new(DeletePlaylistsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) AddTrackToPlaylist(ctx context.Context, in *AddTrackToPlaylistRequest) (*AddTrackToPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "AddTrackToPlaylist")
	out := new(AddTrackToPlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) MoveTrackInPlaylist(ctx context.Context, in *MoveTrackInPlaylistRequest) (*MoveTrackInPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "MoveTrackInPlaylist")
	out := new(MoveTrackInPlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) RemoveTrackFromPlaylist(ctx context.Context, in *RemoveTrackFromPlaylistRequest) (*RemoveTrackFromPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveTrackFromPlaylist")
	out := new(RemoveTrackFromPlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) AddTracksToPlaylist(ctx context.Context, in *AddTracksToPlaylistRequest) (*AddTracksToPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "AddTracksToPlaylist")
	out := new(AddTracksToPlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) MoveTracksInPlaylist(ctx context.Context, in *MoveTracksInPlaylistRequest) (*MoveTracksInPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "MoveTracksInPlaylist")
	out := new(MoveTracksInPlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *soundtrackPlaylistJSONClient) RemoveTracksFromPlaylist(ctx context.Context, in *RemoveTracksFromPlaylistRequest) (*RemoveTracksFromPlaylistResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveTracksFromPlaylist")
	out := new(RemoveTracksFromPlaylistResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// SoundtrackPlaylist Server Handler
// =================================

type soundtrackPlaylistServer struct {
	SoundtrackPlaylist
	hooks *twirp.ServerHooks
}

func NewSoundtrackPlaylistServer(svc SoundtrackPlaylist, hooks *twirp.ServerHooks) TwirpServer {
	return &soundtrackPlaylistServer{
		SoundtrackPlaylist: svc,
		hooks:              hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *soundtrackPlaylistServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// SoundtrackPlaylistPathPrefix is used for all URL paths on a twirp SoundtrackPlaylist server.
// Requests are always: POST SoundtrackPlaylistPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const SoundtrackPlaylistPathPrefix = "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/"

func (s *soundtrackPlaylistServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.soundtrackplaylist")
	ctx = ctxsetters.WithServiceName(ctx, "SoundtrackPlaylist")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/GetPlaylist":
		s.serveGetPlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/GetPlaylists":
		s.serveGetPlaylists(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/CreatePlaylist":
		s.serveCreatePlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/UpdatePlaylist":
		s.serveUpdatePlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/DeletePlaylists":
		s.serveDeletePlaylists(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/AddTrackToPlaylist":
		s.serveAddTrackToPlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/MoveTrackInPlaylist":
		s.serveMoveTrackInPlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/RemoveTrackFromPlaylist":
		s.serveRemoveTrackFromPlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/AddTracksToPlaylist":
		s.serveAddTracksToPlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/MoveTracksInPlaylist":
		s.serveMoveTracksInPlaylist(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.soundtrackplaylist.SoundtrackPlaylist/RemoveTracksFromPlaylist":
		s.serveRemoveTracksFromPlaylist(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *soundtrackPlaylistServer) serveGetPlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveGetPlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.GetPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPlaylistResponse and nil error while calling GetPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveGetPlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.GetPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPlaylistResponse and nil error while calling GetPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveGetPlaylists(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPlaylistsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPlaylistsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveGetPlaylistsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPlaylistsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPlaylistsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.GetPlaylists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPlaylistsResponse and nil error while calling GetPlaylists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveGetPlaylistsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaylists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPlaylistsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPlaylistsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.GetPlaylists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPlaylistsResponse and nil error while calling GetPlaylists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveCreatePlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreatePlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreatePlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveCreatePlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreatePlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreatePlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreatePlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.CreatePlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePlaylistResponse and nil error while calling CreatePlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveCreatePlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreatePlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreatePlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreatePlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.CreatePlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreatePlaylistResponse and nil error while calling CreatePlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveUpdatePlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdatePlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdatePlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveUpdatePlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdatePlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdatePlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.UpdatePlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdatePlaylistResponse and nil error while calling UpdatePlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveUpdatePlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdatePlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdatePlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.UpdatePlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdatePlaylistResponse and nil error while calling UpdatePlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveDeletePlaylists(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeletePlaylistsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeletePlaylistsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveDeletePlaylistsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeletePlaylists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeletePlaylistsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeletePlaylistsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.DeletePlaylists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeletePlaylistsResponse and nil error while calling DeletePlaylists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveDeletePlaylistsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeletePlaylists")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeletePlaylistsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeletePlaylistsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.DeletePlaylists(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeletePlaylistsResponse and nil error while calling DeletePlaylists. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveAddTrackToPlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddTrackToPlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddTrackToPlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveAddTrackToPlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddTrackToPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddTrackToPlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddTrackToPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.AddTrackToPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddTrackToPlaylistResponse and nil error while calling AddTrackToPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveAddTrackToPlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddTrackToPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddTrackToPlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddTrackToPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.AddTrackToPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddTrackToPlaylistResponse and nil error while calling AddTrackToPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveMoveTrackInPlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMoveTrackInPlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMoveTrackInPlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveMoveTrackInPlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MoveTrackInPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MoveTrackInPlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *MoveTrackInPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.MoveTrackInPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MoveTrackInPlaylistResponse and nil error while calling MoveTrackInPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveMoveTrackInPlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MoveTrackInPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(MoveTrackInPlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *MoveTrackInPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.MoveTrackInPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MoveTrackInPlaylistResponse and nil error while calling MoveTrackInPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveRemoveTrackFromPlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveTrackFromPlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveTrackFromPlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveRemoveTrackFromPlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveTrackFromPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveTrackFromPlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveTrackFromPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.RemoveTrackFromPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveTrackFromPlaylistResponse and nil error while calling RemoveTrackFromPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveRemoveTrackFromPlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveTrackFromPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveTrackFromPlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveTrackFromPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.RemoveTrackFromPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveTrackFromPlaylistResponse and nil error while calling RemoveTrackFromPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveAddTracksToPlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddTracksToPlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddTracksToPlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveAddTracksToPlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddTracksToPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AddTracksToPlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddTracksToPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.AddTracksToPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddTracksToPlaylistResponse and nil error while calling AddTracksToPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveAddTracksToPlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddTracksToPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AddTracksToPlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *AddTracksToPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.AddTracksToPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *AddTracksToPlaylistResponse and nil error while calling AddTracksToPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveMoveTracksInPlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMoveTracksInPlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMoveTracksInPlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveMoveTracksInPlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MoveTracksInPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MoveTracksInPlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *MoveTracksInPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.MoveTracksInPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MoveTracksInPlaylistResponse and nil error while calling MoveTracksInPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveMoveTracksInPlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MoveTracksInPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(MoveTracksInPlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *MoveTracksInPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.MoveTracksInPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MoveTracksInPlaylistResponse and nil error while calling MoveTracksInPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveRemoveTracksFromPlaylist(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveTracksFromPlaylistJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveTracksFromPlaylistProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *soundtrackPlaylistServer) serveRemoveTracksFromPlaylistJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveTracksFromPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemoveTracksFromPlaylistRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveTracksFromPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.RemoveTracksFromPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveTracksFromPlaylistResponse and nil error while calling RemoveTracksFromPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) serveRemoveTracksFromPlaylistProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveTracksFromPlaylist")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemoveTracksFromPlaylistRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RemoveTracksFromPlaylistResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.SoundtrackPlaylist.RemoveTracksFromPlaylist(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RemoveTracksFromPlaylistResponse and nil error while calling RemoveTracksFromPlaylist. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *soundtrackPlaylistServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *soundtrackPlaylistServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *soundtrackPlaylistServer) PathPrefix() string {
	return SoundtrackPlaylistPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1777 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xdf, 0x6f, 0xe3, 0x58,
	0x15, 0x5e, 0xc7, 0x4d, 0x9a, 0x9c, 0xb4, 0x25, 0xba, 0x33, 0x3b, 0x63, 0xb2, 0xd5, 0x10, 0x59,
	0x2b, 0xa8, 0x0a, 0xdb, 0x91, 0x0a, 0xec, 0x82, 0x60, 0x56, 0xe3, 0x36, 0xee, 0x4e, 0x34, 0x99,
	0x64, 0x74, 0x9b, 0xce, 0x00, 0x42, 0xaa, 0x9c, 0xf8, 0xb6, 0x7b, 0x59, 0xc7, 0x0e, 0xbe, 0xd7,
	0x1d, 0x66, 0x25, 0x58, 0x09, 0x10, 0x08, 0x09, 0x84, 0x40, 0x9a, 0x57, 0x7e, 0xfd, 0x0f, 0x3c,
	0xf0, 0xc0, 0x0b, 0x0f, 0xbc, 0xc3, 0x23, 0x7f, 0x0d, 0xba, 0xd7, 0xd7, 0x8e, 0x9d, 0xdf, 0xe9,
	0x0c, 0xa8, 0x2f, 0x95, 0xcf, 0x89, 0xcf, 0x77, 0xbf, 0xf3, 0x9d, 0x73, 0xae, 0x7d, 0x5d, 0xf8,
	0x60, 0x10, 0xb8, 0xe4, 0xe0, 0x07, 0x11, 0xe3, 0xd4, 0x3f, 0xe0, 0x57, 0xf7, 0x9d, 0xe1, 0xa7,
	0xfe, 0xfd, 0xd3, 0x20, 0xf2, 0x5d, 0x1e, 0x3a, 0x83, 0x4f, 0x9e, 0x7a, 0xce, 0x4b, 0x8f, 0x32,
	0xde, 0x7b, 0x41, 0xc3, 0xd1, 0x7d, 0x2e, 0xfe, 0x1e, 0x8c, 0xc2, 0x80, 0x07, 0xa8, 0xc1, 0x5f,
	0x50, 0x3e, 0xf8, 0xf8, 0xe0, 0x22, 0xf2, 0x78, 0xe0, 0x1f, 0xb0, 0x34, 0x64, 0xa4, 0x42, 0xcc,
	0xef, 0x43, 0xc9, 0x0a, 0x39, 0x65, 0x1c, 0x21, 0xd8, 0x70, 0x18, 0xf5, 0x0d, 0xad, 0xa1, 0xed,
	0x55, 0xb0, 0xbc, 0x16, 0x3e, 0xdf, 0x19, 0x12, 0xa3, 0x10, 0xfb, 0xc4, 0x35, 0xda, 0x87, 0xda,
	0x20, 0x24, 0x0e, 0x0f, 0xc2, 0xe3, 0x8f, 0x1d, 0xdf, 0x27, 0x5e, 0xab, 0x69, 0xe8, 0xf2, 0xf7,
	0x29, 0xbf, 0xf9, 0x18, 0x8a, 0x96, 0xd7, 0x8f, 0x86, 0x2b, 0x83, 0xd7, 0xa1, 0x4c, 0x87, 0xce,
	0x25, 0x39, 0xc3, 0x6d, 0x05, 0x9a, 0xda, 0xe6, 0x3f, 0x0a, 0x50, 0xec, 0x09, 0xf2, 0xe8, 0x08,
	0x36, 0x1d, 0x49, 0x9a, 0x19, 0x5a, 0x43, 0xdf, 0xab, 0x1e, 0xee, 0x1d, 0x2c, 0x4b, 0xf4, 0x20,
	0xce, 0x12, 0x27, 0x81, 0x29, 0xa3, 0x42, 0x86, 0x51, 0x1d, 0xca, 0x6e, 0x14, 0x3a, 0x9c, 0x06,
	0xbe, 0x5c, 0xbd, 0x88, 0x53, 0x1b, 0xbd, 0x0b, 0xdb, 0x2c, 0xea, 0xb3, 0x41, 0x48, 0x47, 0xc2,
	0x66, 0xc6, 0x46, 0x43, 0xdf, 0xab, 0xe0, 0xbc, 0x13, 0xdd, 0x86, 0x22, 0xa7, 0xdc, 0x23, 0x46,
	0x51, 0xc2, 0xc6, 0x06, 0x6a, 0x40, 0x55, 0x92, 0xe9, 0x44, 0xc3, 0x3e, 0x09, 0x8d, 0x92, 0x84,
	0xce, 0xba, 0xd0, 0x03, 0x28, 0x3a, 0x42, 0x28, 0x63, 0xb3, 0xa1, 0xed, 0x55, 0x0f, 0xbf, 0xb4,
	0x42, 0x3e, 0xe2, 0x76, 0x1c, 0x47, 0x89, 0x64, 0x28, 0x0b, 0x07, 0x46, 0x39, 0x4e, 0x46, 0x5c,
	0x0b, 0x2a, 0x97, 0xc4, 0x0f, 0x89, 0x51, 0x89, 0xa9, 0x48, 0xc3, 0xfc, 0x67, 0x01, 0x36, 0xa5,
	0x88, 0xcf, 0x0e, 0x91, 0x09, 0x5b, 0x92, 0x1f, 0x23, 0xdc, 0x1a, 0x17, 0x27, 0xe7, 0x9b, 0x29,
	0xd3, 0x03, 0x28, 0x4a, 0x2e, 0x52, 0xa3, 0x95, 0xc8, 0xca, 0x15, 0x71, 0x1c, 0x25, 0x88, 0x51,
	0xd6, 0x21, 0x2f, 0x8c, 0x8d, 0x86, 0xb6, 0x57, 0xc6, 0xb1, 0x81, 0xee, 0x01, 0x50, 0x76, 0x42,
	0x1c, 0x1e, 0x85, 0xc4, 0x95, 0xf2, 0x95, 0x71, 0xc6, 0x23, 0x88, 0x70, 0xe7, 0x92, 0x19, 0x25,
	0x29, 0xbb, 0xbc, 0x46, 0xbb, 0x50, 0xa1, 0xcc, 0xf6, 0x9d, 0xbe, 0x47, 0x5c, 0xa9, 0x5c, 0x19,
	0x8f, 0x1d, 0x02, 0xf1, 0x8a, 0x32, 0xda, 0xa7, 0x1e, 0xe5, 0x2f, 0x95, 0x34, 0x19, 0x8f, 0x88,
	0x1e, 0x45, 0xfd, 0x53, 0xee, 0xf0, 0x88, 0x29, 0x91, 0xc6, 0x8e, 0x98, 0x8f, 0xed, 0xd1, 0x4b,
	0xda, 0xf7, 0x88, 0x01, 0x09, 0x9f, 0xc4, 0x63, 0xfe, 0x4a, 0x87, 0x72, 0x32, 0x78, 0xe3, 0xb2,
	0x6b, 0xd9, 0xb2, 0xef, 0x40, 0x81, 0xba, 0x4a, 0xb9, 0x02, 0x75, 0x17, 0x35, 0x37, 0x7a, 0x02,
	0xdb, 0x03, 0x87, 0x3b, 0x5e, 0x70, 0x29, 0xb5, 0x8a, 0xdb, 0x6b, 0x0d, 0x6d, 0xf3, 0xd1, 0x4b,
	0xd5, 0x6c, 0x40, 0xd5, 0x25, 0x69, 0xdf, 0xca, 0x8e, 0xac, 0xe0, 0xac, 0x0b, 0x19, 0xb0, 0x39,
	0x10, 0xbd, 0x1f, 0x84, 0x52, 0xd9, 0x0a, 0x4e, 0x4c, 0xa5, 0xcc, 0x8f, 0x46, 0x1e, 0x1d, 0x50,
	0x2e, 0x75, 0x8d, 0x95, 0x51, 0x1e, 0x99, 0x26, 0x7b, 0x1a, 0xf5, 0x3d, 0x3a, 0x90, 0xb2, 0x96,
	0x71, 0x6a, 0xc7, 0x15, 0x7b, 0x26, 0x6a, 0x90, 0x8a, 0x3a, 0x76, 0x88, 0x5f, 0x59, 0x10, 0xf2,
	0x6e, 0xe8, 0x92, 0xd0, 0xa8, 0xca, 0x29, 0x19, 0x3b, 0x24, 0x23, 0xc7, 0xb7, 0x5d, 0xca, 0x8d,
	0x2d, 0x19, 0x99, 0x98, 0xe6, 0x77, 0x00, 0x7d, 0x44, 0x78, 0x52, 0x0d, 0x4c, 0x7e, 0x18, 0x11,
	0xc6, 0xd1, 0x1d, 0x28, 0x45, 0x8c, 0x84, 0xad, 0xa6, 0xaa, 0x8a, 0xb2, 0x04, 0x3f, 0x2f, 0x18,
	0xc4, 0x53, 0x1e, 0x17, 0x27, 0xb5, 0x55, 0xc9, 0xf4, 0xa4, 0x64, 0xe6, 0x67, 0x70, 0x2b, 0x87,
	0xcc, 0x46, 0x81, 0xcf, 0x08, 0x3a, 0x81, 0x72, 0xa2, 0xbf, 0x04, 0xaf, 0x1e, 0xee, 0x2f, 0x2f,
	0x54, 0x8a, 0x92, 0xc6, 0x8a, 0x32, 0xf8, 0xd1, 0xb0, 0x7b, 0xa1, 0x6a, 0x5e, 0x88, 0x37, 0x86,
	0x8c, 0xcb, 0xfc, 0x9b, 0x96, 0x63, 0xc0, 0x32, 0xc9, 0x0d, 0xa2, 0x90, 0x05, 0x61, 0x92, 0x5c,
	0x6c, 0xa1, 0x87, 0x50, 0xba, 0xa0, 0x1e, 0x27, 0xa1, 0x04, 0xdb, 0x59, 0x65, 0x67, 0x3c, 0x91,
	0xf7, 0x63, 0x15, 0x27, 0x7a, 0xd9, 0xa3, 0x43, 0xca, 0xa5, 0x0a, 0x3a, 0x8e, 0x8d, 0x9c, 0x68,
	0x1b, 0x13, 0xa2, 0x8d, 0x85, 0x2e, 0x66, 0x85, 0x36, 0xff, 0xa4, 0xc1, 0xed, 0x3c, 0x77, 0x25,
	0xdf, 0x23, 0xa8, 0x24, 0xab, 0x27, 0x3b, 0xf8, 0x3a, 0xfa, 0x8d, 0x83, 0x33, 0x32, 0x14, 0x72,
	0x32, 0x7c, 0x11, 0x76, 0xa4, 0x8a, 0xe9, 0xda, 0x6a, 0x3f, 0x9f, 0xf0, 0x9a, 0x9f, 0xc1, 0xdb,
	0xc7, 0xe2, 0xa1, 0x45, 0x26, 0x9b, 0x67, 0xf6, 0x44, 0x8f, 0x33, 0x2d, 0xe4, 0x5a, 0x6a, 0x62,
	0x9c, 0xf4, 0xe9, 0x71, 0xba, 0x03, 0x25, 0x3e, 0x1e, 0xec, 0x0a, 0x56, 0x96, 0xf9, 0x13, 0xb8,
	0x33, 0x49, 0xe0, 0x0d, 0xf7, 0xd8, 0x2e, 0x54, 0x5a, 0xec, 0x34, 0x1a, 0x0c, 0x08, 0x8b, 0x3b,
	0xac, 0x8c, 0xc7, 0x0e, 0xf3, 0x97, 0x1a, 0xbc, 0x7d, 0x36, 0x72, 0x67, 0x28, 0x30, 0x6f, 0x7c,
	0x26, 0x77, 0xb5, 0x2c, 0x4f, 0xfd, 0xfa, 0x3c, 0x85, 0x12, 0x93, 0x44, 0xfe, 0xaf, 0x4a, 0x1c,
	0xc1, 0x9d, 0x26, 0xf1, 0xc8, 0x78, 0x7d, 0xb6, 0x4c, 0x89, 0x1a, 0xe8, 0xd4, 0x15, 0x48, 0xa2,
	0xa0, 0xe2, 0xd2, 0xbc, 0x84, 0xbb, 0x53, 0x18, 0x2a, 0x09, 0x75, 0xb3, 0x96, 0xde, 0x2c, 0xe8,
	0x5c, 0x38, 0xd4, 0x23, 0x6e, 0x2b, 0x05, 0x19, 0x3b, 0xf2, 0x64, 0xf5, 0x49, 0xb2, 0x8f, 0x00,
	0xe4, 0x06, 0xd1, 0x0b, 0x2c, 0xd7, 0x15, 0x3b, 0xa3, 0x4c, 0xbe, 0xe5, 0x2a, 0x86, 0x89, 0x29,
	0x1a, 0x93, 0xfa, 0x8c, 0x84, 0xdc, 0xba, 0x48, 0xf6, 0x84, 0x22, 0xce, 0xba, 0xcc, 0x4f, 0xa0,
	0x1a, 0x6f, 0x35, 0x33, 0xa0, 0xf4, 0xb5, 0xa0, 0x32, 0x77, 0x70, 0xdb, 0x77, 0x15, 0xe9, 0xac,
	0xcb, 0xfc, 0x9d, 0x06, 0x9f, 0xb7, 0x5c, 0x57, 0x51, 0x9f, 0xec, 0xb8, 0xb8, 0xb3, 0xb4, 0xb4,
	0xb3, 0xda, 0x00, 0x3c, 0x4d, 0x52, 0x2e, 0x58, 0x3d, 0xfc, 0xca, 0x8a, 0x0f, 0x44, 0x19, 0x83,
	0x33, 0xf1, 0x99, 0x2a, 0xea, 0xb9, 0x5d, 0xea, 0x5f, 0x1a, 0xd4, 0x67, 0x71, 0x52, 0x75, 0x9b,
	0x24, 0x75, 0x4f, 0x91, 0xb2, 0x5c, 0x97, 0x24, 0x63, 0x90, 0xf1, 0xa0, 0x9f, 0x6a, 0xb0, 0x4b,
	0x5c, 0xca, 0x25, 0x5e, 0xcb, 0x4f, 0xf0, 0xec, 0x30, 0x0c, 0xc2, 0xe3, 0xc0, 0x25, 0x72, 0xf5,
	0x9d, 0xc3, 0x0f, 0x97, 0xe7, 0x61, 0x2f, 0x40, 0xc1, 0x0b, 0xd7, 0x30, 0x5f, 0x65, 0x72, 0x62,
	0xcb, 0x85, 0xee, 0xaa, 0xf7, 0x53, 0x96, 0x55, 0xfa, 0xbd, 0x15, 0x95, 0x8e, 0x83, 0x70, 0x16,
	0x61, 0xae, 0xd6, 0xbf, 0x2e, 0xc0, 0x3b, 0x33, 0x79, 0xbd, 0xf9, 0xe7, 0x6a, 0x4c, 0x27, 0xa9,
	0x92, 0xe8, 0xe4, 0xac, 0xeb, 0x66, 0x94, 0x69, 0xa0, 0x66, 0xaf, 0x17, 0x3c, 0x09, 0xae, 0xc8,
	0x82, 0x31, 0x16, 0xaf, 0x54, 0x6a, 0x8c, 0xd4, 0xe0, 0xa5, 0xb6, 0x68, 0xc8, 0x90, 0x0c, 0x83,
	0x2b, 0x72, 0x12, 0x06, 0x43, 0xf5, 0x98, 0xcb, 0x78, 0xcc, 0x47, 0xb0, 0x95, 0xe8, 0xbd, 0x64,
	0x95, 0x3c, 0x52, 0x61, 0x0a, 0x49, 0x74, 0x95, 0x80, 0x98, 0xc8, 0x67, 0x59, 0x57, 0xc5, 0xeb,
	0xae, 0xd9, 0x55, 0x71, 0x10, 0xce, 0x22, 0xcc, 0xed, 0xaa, 0x7f, 0x6b, 0xf0, 0xce, 0x4c, 0x5e,
	0x4b, 0x46, 0x58, 0xc4, 0xe4, 0x47, 0x58, 0x7a, 0x6e, 0x46, 0x6f, 0xfc, 0x35, 0x9b, 0x14, 0x5b,
	0xae, 0x36, 0x86, 0x2d, 0x9e, 0x29, 0xb3, 0xec, 0xf9, 0xea, 0xe1, 0xc1, 0xea, 0x43, 0x2c, 0xf5,
	0xce, 0x61, 0xcc, 0x13, 0x3c, 0xd7, 0x8e, 0x1b, 0xf9, 0x76, 0x34, 0x7f, 0x53, 0x80, 0xdd, 0xd9,
	0xbc, 0xff, 0x57, 0x33, 0x9e, 0x94, 0x31, 0x33, 0xe3, 0x37, 0xa8, 0x8e, 0x36, 0x6c, 0xab, 0x86,
	0x8e, 0xdf, 0x0c, 0x16, 0x4f, 0xb9, 0x2b, 0xef, 0x19, 0x4f, 0x79, 0x62, 0x9b, 0x7f, 0xd4, 0xe0,
	0x1e, 0x96, 0xa3, 0x28, 0xd1, 0xc4, 0x3c, 0x2e, 0xeb, 0x88, 0x33, 0xd8, 0xe6, 0xd9, 0x95, 0xd5,
	0x04, 0xde, 0x5f, 0x79, 0x02, 0xe3, 0x30, 0x9c, 0x47, 0x99, 0x3b, 0x85, 0xff, 0xd1, 0xe0, 0x0b,
	0x73, 0x19, 0xce, 0x99, 0x44, 0x53, 0x35, 0x6d, 0x0c, 0x9d, 0xcc, 0x62, 0xce, 0x77, 0x33, 0xaa,
	0xf8, 0x97, 0x7c, 0x72, 0x6c, 0x15, 0xfd, 0x9f, 0xc3, 0x4e, 0x32, 0x4d, 0x69, 0x01, 0xf4, 0xeb,
	0x14, 0x60, 0x02, 0x66, 0x6e, 0x05, 0x5e, 0x15, 0xa0, 0x31, 0x9f, 0xe4, 0x1b, 0x1e, 0xbf, 0x77,
	0x55, 0x77, 0xb1, 0x71, 0xed, 0xe4, 0xf7, 0xb0, 0x9c, 0xf3, 0x46, 0x14, 0x6f, 0xff, 0x21, 0x54,
	0x8f, 0x03, 0x9f, 0x13, 0x9f, 0xf7, 0x5e, 0x8e, 0x08, 0xaa, 0xc2, 0xe6, 0x59, 0xe7, 0x71, 0xa7,
	0xfb, 0xbc, 0x53, 0x7b, 0x0b, 0x6d, 0x41, 0xf9, 0x69, 0xdb, 0xfa, 0x6e, 0xbb, 0x75, 0xda, 0xab,
	0x69, 0xe2, 0xa7, 0xd3, 0x9e, 0xd5, 0x6b, 0x75, 0x3b, 0xb5, 0x02, 0xaa, 0x40, 0xb1, 0x87, 0xad,
	0xe3, 0xc7, 0x35, 0x7d, 0xff, 0x7d, 0x28, 0xc5, 0xa7, 0x64, 0xb4, 0x09, 0xba, 0xd5, 0x6e, 0xc7,
	0x81, 0x27, 0xb6, 0xd5, 0x3b, 0xc3, 0x76, 0xb3, 0xa6, 0x89, 0x7b, 0xbb, 0xcf, 0x3b, 0x76, 0xb3,
	0x56, 0x40, 0x00, 0xa5, 0xa7, 0x67, 0x47, 0xed, 0xd6, 0x71, 0x4d, 0xdf, 0xff, 0xb9, 0x06, 0xbb,
	0x8b, 0x88, 0xa3, 0x32, 0x6c, 0x74, 0xba, 0x1d, 0xbb, 0xf6, 0x16, 0xda, 0x86, 0x4a, 0xa7, 0x7b,
	0x8e, 0xed, 0xe3, 0x2e, 0x16, 0x80, 0xb7, 0xa1, 0xd6, 0xea, 0x3c, 0xb3, 0xda, 0xad, 0xe6, 0xb9,
	0x85, 0x3f, 0x3a, 0x7b, 0x62, 0x77, 0x7a, 0xb5, 0x82, 0xb8, 0xe9, 0xa4, 0x8b, 0x8f, 0x5a, 0xcd,
	0xa6, 0xdd, 0xa9, 0xe9, 0x71, 0x4c, 0xef, 0xfc, 0xa4, 0x7b, 0xd6, 0x69, 0xd6, 0x36, 0xd0, 0x5d,
	0xb8, 0x25, 0x09, 0x9f, 0xb7, 0x5b, 0x4f, 0x5a, 0xbd, 0x73, 0x6c, 0x5b, 0xc7, 0x8f, 0xec, 0x66,
	0xad, 0x78, 0xf8, 0xf7, 0x2d, 0x40, 0xd3, 0x9f, 0x8b, 0xd1, 0xa7, 0x50, 0xcd, 0x1c, 0xcf, 0xd1,
	0xd7, 0x96, 0x17, 0x61, 0xfa, 0x2b, 0x4b, 0xfd, 0xeb, 0x6b, 0x46, 0xa9, 0x36, 0xfc, 0x31, 0x6c,
	0x65, 0x3f, 0x0d, 0xa0, 0xf5, 0x60, 0x92, 0xa3, 0x59, 0xfd, 0xfd, 0x75, 0xc3, 0xd4, 0xf2, 0x3f,
	0xd3, 0x60, 0x27, 0x7f, 0xee, 0x46, 0x1f, 0x2c, 0x87, 0x9a, 0xf9, 0xa9, 0xa0, 0xfe, 0x8d, 0xf5,
	0x03, 0x33, 0x2c, 0xf2, 0x67, 0xde, 0x55, 0x58, 0xcc, 0x3c, 0xae, 0xaf, 0xc2, 0x62, 0xce, 0xf1,
	0xfa, 0x17, 0x1a, 0x7c, 0x6e, 0xe2, 0xd4, 0x8a, 0x56, 0x40, 0x9b, 0x7d, 0x58, 0xae, 0x7f, 0xf3,
	0x1a, 0x91, 0x8a, 0xc8, 0x6f, 0x35, 0x40, 0xd3, 0x27, 0x31, 0xf4, 0xad, 0x15, 0x3e, 0x86, 0xcf,
	0x3b, 0x53, 0xd6, 0xbf, 0x7d, 0xbd, 0x60, 0xc5, 0xe8, 0xf7, 0x1a, 0xdc, 0x9a, 0xf1, 0x66, 0x89,
	0x56, 0x40, 0x9d, 0xff, 0xa2, 0x5c, 0x7f, 0x70, 0xcd, 0x68, 0x45, 0xea, 0x0f, 0x1a, 0xdc, 0x9d,
	0xf3, 0xa0, 0x45, 0x0f, 0x97, 0x43, 0x2f, 0x7e, 0x8b, 0xa8, 0x5b, 0xaf, 0x81, 0x90, 0x51, 0x6d,
	0xc6, 0x29, 0x0f, 0xad, 0x51, 0x8b, 0xe9, 0x43, 0xeb, 0x2a, 0xaa, 0x2d, 0x3a, 0x5a, 0xbe, 0xd2,
	0xe0, 0xf6, 0xac, 0xf7, 0x52, 0xb4, 0x4e, 0x35, 0xa6, 0xdf, 0xc3, 0xeb, 0x1f, 0x5e, 0x37, 0x5c,
	0xf1, 0xfa, 0xb3, 0x06, 0xc6, 0xbc, 0x87, 0x36, 0x5a, 0xaf, 0x18, 0xb3, 0xde, 0x4a, 0xea, 0x47,
	0xaf, 0x03, 0x11, 0x73, 0x3c, 0x7a, 0xef, 0x7b, 0x5f, 0x5e, 0xe3, 0x3f, 0x90, 0xfd, 0x92, 0xfc,
	0xe7, 0xe3, 0x57, 0xff, 0x1b, 0x00, 0x00, 0xff, 0xff, 0xf7, 0xc4, 0x73, 0xab, 0xb7, 0x1c, 0x00,
	0x00,
}
