// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StagedDeploy2Twirp/twirp.proto

/*
Package StagedDeploy2Twirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/StagedDeploy2Twirp/twirp.proto
*/
package StagedDeploy2Twirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =======================
// StagedDeploy2 Interface
// =======================

type StagedDeploy2 interface {
	// DeployRevision declares a new application revision in the Revision Management System (if the specified revision
	// is not already declared) and starts a deployment. It takes an application name, a comment, and a source URI and
	// uploads the revision to the RMS (if it has not already been uploaded), generating a revision ID in the process.
	// It returns revision metadata and a pipeline execution ID.
	DeployRevision(context.Context, *DeployRevisionRequest) (*DeployRevisionResponse, error)

	// DeclareRevision takes an application name, revision ID, and comment and returns metadata for the revision.
	DeclareRevision(context.Context, *DeclareRevisionRequest) (*DeclareRevisionResponse, error)

	// GetRevisions takes an application name and returns a revision ID for each revision declared for the application.
	GetRevisions(context.Context, *GetRevisionsRequest) (*GetRevisionsResponse, error)

	// GetRevisionMetadata takes an application name and a revision ID and returns metadata for the revision.
	GetRevisionMetadata(context.Context, *GetRevisionMetadataRequest) (*GetRevisionMetadataResponse, error)

	// GetApplications returns a name for each application with at least one declared revision.
	GetApplications(context.Context, *GetApplicationsRequest) (*GetApplicationsResponse, error)

	// Staged Pipeline API
	// InitiatePipelineExecution takes an application name, a revision ID, and a pipeline name. It verifies that the
	// specified application can be deployed via the specified pipeline, and if so, starts an execution. It returns the
	// pipeline execution ID for the new pipeline execution.
	InitiatePipelineExecution(context.Context, *InitiatePipelineExecutionRequest) (*InitiatePipelineExecutionResponse, error)

	// Application Revision Database API
	// GetIntendedRevisionsForMCK takes an MCK struct and returns a list of IntendedState structs. An IntendedState
	// struct contains an application name, a revision ID, and the pipeline execution ID.
	GetIntendedRevisionsForMCK(context.Context, *GetIntendedRevisionsForMCKRequest) (*GetIntendedRevisionsForMCKResponse, error)

	// SetIntendedRevisionForMCK takes an MCK struct, an application name, a revision ID, a pipeline execution ID, and a
	// deployment concurrency limit and returns an IntendedState struct.
	SetIntendedRevisionForMCK(context.Context, *SetIntendedRevisionForMCKRequest) (*SetIntendedRevisionForMCKResponse, error)

	// GetActualStatesForMCKP takes an MCK struct and returns a list of ActualState structs. An ActualState struct
	// contains an application name, the revision IDs for the last attempted and successful deployments, a timestamp,
	// and the pipeline execution ID of the last pipeline execution to affect the host.
	GetActualStatesForMCKP(context.Context, *GetActualStatesForMCKPRequest) (*GetActualStatesForMCKPResponse, error)

	// GetActualStatesForHost takes a hostname and returns a list of ActualState structs.
	GetActualStatesForHost(context.Context, *GetActualStatesForHostRequest) (*GetActualStatesForHostResponse, error)

	// SetActualStateForHost takes a hostname, an MCK, and an ActualState struct. A host calls this once per installed
	// application.
	SetActualStateForHost(context.Context, *SetActualStateForHostRequest) (*SetActualStateForHostResponse, error)

	// MapAppsToPipeline takes a pipeline name and a list of application names.
	MapAppsToPipeline(context.Context, *MapAppsToPipelineRequest) (*MapAppsToPipelineResponse, error)

	// UnmapAppsFromPipeline takes a pipeline name and a list of application names.
	UnmapAppsFromPipeline(context.Context, *UnmapAppsFromPipelineRequest) (*UnmapAppsFromPipelineResponse, error)

	// ListAppsForPipeline takes a pipeline name and returns a list of application names.
	ListAppsForPipeline(context.Context, *ListAppsForPipelineRequest) (*ListAppsForPipelineResponse, error)

	// ListPipelinesForApp takes an application name and returns a list of pipeline names.
	ListPipelinesForApp(context.Context, *ListPipelinesForAppRequest) (*ListPipelinesForAppResponse, error)
}

// =============================
// StagedDeploy2 Protobuf Client
// =============================

type stagedDeploy2ProtobufClient struct {
	client HTTPClient
	urls   [15]string
	opts   twirp.ClientOptions
}

// NewStagedDeploy2ProtobufClient creates a Protobuf client that implements the StagedDeploy2 interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStagedDeploy2ProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StagedDeploy2 {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StagedDeploy2PathPrefix
	urls := [15]string{
		prefix + "DeployRevision",
		prefix + "DeclareRevision",
		prefix + "GetRevisions",
		prefix + "GetRevisionMetadata",
		prefix + "GetApplications",
		prefix + "InitiatePipelineExecution",
		prefix + "GetIntendedRevisionsForMCK",
		prefix + "SetIntendedRevisionForMCK",
		prefix + "GetActualStatesForMCKP",
		prefix + "GetActualStatesForHost",
		prefix + "SetActualStateForHost",
		prefix + "MapAppsToPipeline",
		prefix + "UnmapAppsFromPipeline",
		prefix + "ListAppsForPipeline",
		prefix + "ListPipelinesForApp",
	}

	return &stagedDeploy2ProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *stagedDeploy2ProtobufClient) DeployRevision(ctx context.Context, in *DeployRevisionRequest) (*DeployRevisionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "DeployRevision")
	out := new(DeployRevisionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) DeclareRevision(ctx context.Context, in *DeclareRevisionRequest) (*DeclareRevisionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "DeclareRevision")
	out := new(DeclareRevisionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) GetRevisions(ctx context.Context, in *GetRevisionsRequest) (*GetRevisionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetRevisions")
	out := new(GetRevisionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) GetRevisionMetadata(ctx context.Context, in *GetRevisionMetadataRequest) (*GetRevisionMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetRevisionMetadata")
	out := new(GetRevisionMetadataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) GetApplications(ctx context.Context, in *GetApplicationsRequest) (*GetApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetApplications")
	out := new(GetApplicationsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) InitiatePipelineExecution(ctx context.Context, in *InitiatePipelineExecutionRequest) (*InitiatePipelineExecutionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "InitiatePipelineExecution")
	out := new(InitiatePipelineExecutionResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) GetIntendedRevisionsForMCK(ctx context.Context, in *GetIntendedRevisionsForMCKRequest) (*GetIntendedRevisionsForMCKResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetIntendedRevisionsForMCK")
	out := new(GetIntendedRevisionsForMCKResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) SetIntendedRevisionForMCK(ctx context.Context, in *SetIntendedRevisionForMCKRequest) (*SetIntendedRevisionForMCKResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "SetIntendedRevisionForMCK")
	out := new(SetIntendedRevisionForMCKResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) GetActualStatesForMCKP(ctx context.Context, in *GetActualStatesForMCKPRequest) (*GetActualStatesForMCKPResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetActualStatesForMCKP")
	out := new(GetActualStatesForMCKPResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) GetActualStatesForHost(ctx context.Context, in *GetActualStatesForHostRequest) (*GetActualStatesForHostResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetActualStatesForHost")
	out := new(GetActualStatesForHostResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) SetActualStateForHost(ctx context.Context, in *SetActualStateForHostRequest) (*SetActualStateForHostResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "SetActualStateForHost")
	out := new(SetActualStateForHostResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) MapAppsToPipeline(ctx context.Context, in *MapAppsToPipelineRequest) (*MapAppsToPipelineResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "MapAppsToPipeline")
	out := new(MapAppsToPipelineResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) UnmapAppsFromPipeline(ctx context.Context, in *UnmapAppsFromPipelineRequest) (*UnmapAppsFromPipelineResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "UnmapAppsFromPipeline")
	out := new(UnmapAppsFromPipelineResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) ListAppsForPipeline(ctx context.Context, in *ListAppsForPipelineRequest) (*ListAppsForPipelineResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "ListAppsForPipeline")
	out := new(ListAppsForPipelineResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2ProtobufClient) ListPipelinesForApp(ctx context.Context, in *ListPipelinesForAppRequest) (*ListPipelinesForAppResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "ListPipelinesForApp")
	out := new(ListPipelinesForAppResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// StagedDeploy2 JSON Client
// =========================

type stagedDeploy2JSONClient struct {
	client HTTPClient
	urls   [15]string
	opts   twirp.ClientOptions
}

// NewStagedDeploy2JSONClient creates a JSON client that implements the StagedDeploy2 interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStagedDeploy2JSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StagedDeploy2 {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StagedDeploy2PathPrefix
	urls := [15]string{
		prefix + "DeployRevision",
		prefix + "DeclareRevision",
		prefix + "GetRevisions",
		prefix + "GetRevisionMetadata",
		prefix + "GetApplications",
		prefix + "InitiatePipelineExecution",
		prefix + "GetIntendedRevisionsForMCK",
		prefix + "SetIntendedRevisionForMCK",
		prefix + "GetActualStatesForMCKP",
		prefix + "GetActualStatesForHost",
		prefix + "SetActualStateForHost",
		prefix + "MapAppsToPipeline",
		prefix + "UnmapAppsFromPipeline",
		prefix + "ListAppsForPipeline",
		prefix + "ListPipelinesForApp",
	}

	return &stagedDeploy2JSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *stagedDeploy2JSONClient) DeployRevision(ctx context.Context, in *DeployRevisionRequest) (*DeployRevisionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "DeployRevision")
	out := new(DeployRevisionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) DeclareRevision(ctx context.Context, in *DeclareRevisionRequest) (*DeclareRevisionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "DeclareRevision")
	out := new(DeclareRevisionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) GetRevisions(ctx context.Context, in *GetRevisionsRequest) (*GetRevisionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetRevisions")
	out := new(GetRevisionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) GetRevisionMetadata(ctx context.Context, in *GetRevisionMetadataRequest) (*GetRevisionMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetRevisionMetadata")
	out := new(GetRevisionMetadataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) GetApplications(ctx context.Context, in *GetApplicationsRequest) (*GetApplicationsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetApplications")
	out := new(GetApplicationsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) InitiatePipelineExecution(ctx context.Context, in *InitiatePipelineExecutionRequest) (*InitiatePipelineExecutionResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "InitiatePipelineExecution")
	out := new(InitiatePipelineExecutionResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) GetIntendedRevisionsForMCK(ctx context.Context, in *GetIntendedRevisionsForMCKRequest) (*GetIntendedRevisionsForMCKResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetIntendedRevisionsForMCK")
	out := new(GetIntendedRevisionsForMCKResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) SetIntendedRevisionForMCK(ctx context.Context, in *SetIntendedRevisionForMCKRequest) (*SetIntendedRevisionForMCKResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "SetIntendedRevisionForMCK")
	out := new(SetIntendedRevisionForMCKResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) GetActualStatesForMCKP(ctx context.Context, in *GetActualStatesForMCKPRequest) (*GetActualStatesForMCKPResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetActualStatesForMCKP")
	out := new(GetActualStatesForMCKPResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) GetActualStatesForHost(ctx context.Context, in *GetActualStatesForHostRequest) (*GetActualStatesForHostResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "GetActualStatesForHost")
	out := new(GetActualStatesForHostResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) SetActualStateForHost(ctx context.Context, in *SetActualStateForHostRequest) (*SetActualStateForHostResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "SetActualStateForHost")
	out := new(SetActualStateForHostResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) MapAppsToPipeline(ctx context.Context, in *MapAppsToPipelineRequest) (*MapAppsToPipelineResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "MapAppsToPipeline")
	out := new(MapAppsToPipelineResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) UnmapAppsFromPipeline(ctx context.Context, in *UnmapAppsFromPipelineRequest) (*UnmapAppsFromPipelineResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "UnmapAppsFromPipeline")
	out := new(UnmapAppsFromPipelineResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) ListAppsForPipeline(ctx context.Context, in *ListAppsForPipelineRequest) (*ListAppsForPipelineResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "ListAppsForPipeline")
	out := new(ListAppsForPipelineResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *stagedDeploy2JSONClient) ListPipelinesForApp(ctx context.Context, in *ListPipelinesForAppRequest) (*ListPipelinesForAppResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithMethodName(ctx, "ListPipelinesForApp")
	out := new(ListPipelinesForAppResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// StagedDeploy2 Server Handler
// ============================

type stagedDeploy2Server struct {
	StagedDeploy2
	hooks *twirp.ServerHooks
}

func NewStagedDeploy2Server(svc StagedDeploy2, hooks *twirp.ServerHooks) TwirpServer {
	return &stagedDeploy2Server{
		StagedDeploy2: svc,
		hooks:         hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *stagedDeploy2Server) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StagedDeploy2PathPrefix is used for all URL paths on a twirp StagedDeploy2 server.
// Requests are always: POST StagedDeploy2PathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StagedDeploy2PathPrefix = "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/"

func (s *stagedDeploy2Server) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.fulton.stageddeploy2")
	ctx = ctxsetters.WithServiceName(ctx, "StagedDeploy2")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/DeployRevision":
		s.serveDeployRevision(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/DeclareRevision":
		s.serveDeclareRevision(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/GetRevisions":
		s.serveGetRevisions(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/GetRevisionMetadata":
		s.serveGetRevisionMetadata(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/GetApplications":
		s.serveGetApplications(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/InitiatePipelineExecution":
		s.serveInitiatePipelineExecution(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/GetIntendedRevisionsForMCK":
		s.serveGetIntendedRevisionsForMCK(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/SetIntendedRevisionForMCK":
		s.serveSetIntendedRevisionForMCK(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/GetActualStatesForMCKP":
		s.serveGetActualStatesForMCKP(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/GetActualStatesForHost":
		s.serveGetActualStatesForHost(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/SetActualStateForHost":
		s.serveSetActualStateForHost(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/MapAppsToPipeline":
		s.serveMapAppsToPipeline(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/UnmapAppsFromPipeline":
		s.serveUnmapAppsFromPipeline(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/ListAppsForPipeline":
		s.serveListAppsForPipeline(ctx, resp, req)
		return
	case "/twirp/twitch.fulton.stageddeploy2.StagedDeploy2/ListPipelinesForApp":
		s.serveListPipelinesForApp(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *stagedDeploy2Server) serveDeployRevision(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeployRevisionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeployRevisionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveDeployRevisionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeployRevision")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeployRevisionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeployRevisionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.DeployRevision(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeployRevisionResponse and nil error while calling DeployRevision. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveDeployRevisionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeployRevision")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeployRevisionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeployRevisionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.DeployRevision(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeployRevisionResponse and nil error while calling DeployRevision. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveDeclareRevision(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeclareRevisionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeclareRevisionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveDeclareRevisionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeclareRevision")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeclareRevisionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeclareRevisionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.DeclareRevision(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeclareRevisionResponse and nil error while calling DeclareRevision. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveDeclareRevisionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeclareRevision")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeclareRevisionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeclareRevisionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.DeclareRevision(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeclareRevisionResponse and nil error while calling DeclareRevision. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetRevisions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRevisionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRevisionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveGetRevisionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRevisions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRevisionsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRevisionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetRevisions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRevisionsResponse and nil error while calling GetRevisions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetRevisionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRevisions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRevisionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRevisionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetRevisions(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRevisionsResponse and nil error while calling GetRevisions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetRevisionMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRevisionMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRevisionMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveGetRevisionMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRevisionMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRevisionMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRevisionMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetRevisionMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRevisionMetadataResponse and nil error while calling GetRevisionMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetRevisionMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRevisionMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRevisionMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRevisionMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetRevisionMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRevisionMetadataResponse and nil error while calling GetRevisionMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetApplications(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetApplicationsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetApplicationsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveGetApplicationsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetApplicationsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetApplicationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetApplicationsResponse and nil error while calling GetApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetApplicationsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetApplications")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetApplicationsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetApplicationsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetApplications(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetApplicationsResponse and nil error while calling GetApplications. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveInitiatePipelineExecution(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveInitiatePipelineExecutionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveInitiatePipelineExecutionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveInitiatePipelineExecutionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InitiatePipelineExecution")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(InitiatePipelineExecutionRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *InitiatePipelineExecutionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.InitiatePipelineExecution(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InitiatePipelineExecutionResponse and nil error while calling InitiatePipelineExecution. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveInitiatePipelineExecutionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "InitiatePipelineExecution")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(InitiatePipelineExecutionRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *InitiatePipelineExecutionResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.InitiatePipelineExecution(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *InitiatePipelineExecutionResponse and nil error while calling InitiatePipelineExecution. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetIntendedRevisionsForMCK(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetIntendedRevisionsForMCKJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetIntendedRevisionsForMCKProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveGetIntendedRevisionsForMCKJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIntendedRevisionsForMCK")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetIntendedRevisionsForMCKRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetIntendedRevisionsForMCKResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetIntendedRevisionsForMCK(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIntendedRevisionsForMCKResponse and nil error while calling GetIntendedRevisionsForMCK. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetIntendedRevisionsForMCKProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetIntendedRevisionsForMCK")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetIntendedRevisionsForMCKRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetIntendedRevisionsForMCKResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetIntendedRevisionsForMCK(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetIntendedRevisionsForMCKResponse and nil error while calling GetIntendedRevisionsForMCK. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveSetIntendedRevisionForMCK(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetIntendedRevisionForMCKJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetIntendedRevisionForMCKProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveSetIntendedRevisionForMCKJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetIntendedRevisionForMCK")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetIntendedRevisionForMCKRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetIntendedRevisionForMCKResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.SetIntendedRevisionForMCK(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetIntendedRevisionForMCKResponse and nil error while calling SetIntendedRevisionForMCK. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveSetIntendedRevisionForMCKProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetIntendedRevisionForMCK")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetIntendedRevisionForMCKRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetIntendedRevisionForMCKResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.SetIntendedRevisionForMCK(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetIntendedRevisionForMCKResponse and nil error while calling SetIntendedRevisionForMCK. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetActualStatesForMCKP(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetActualStatesForMCKPJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetActualStatesForMCKPProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveGetActualStatesForMCKPJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActualStatesForMCKP")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetActualStatesForMCKPRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetActualStatesForMCKPResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetActualStatesForMCKP(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActualStatesForMCKPResponse and nil error while calling GetActualStatesForMCKP. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetActualStatesForMCKPProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActualStatesForMCKP")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetActualStatesForMCKPRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetActualStatesForMCKPResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetActualStatesForMCKP(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActualStatesForMCKPResponse and nil error while calling GetActualStatesForMCKP. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetActualStatesForHost(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetActualStatesForHostJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetActualStatesForHostProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveGetActualStatesForHostJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActualStatesForHost")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetActualStatesForHostRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetActualStatesForHostResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetActualStatesForHost(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActualStatesForHostResponse and nil error while calling GetActualStatesForHost. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveGetActualStatesForHostProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetActualStatesForHost")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetActualStatesForHostRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetActualStatesForHostResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.GetActualStatesForHost(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetActualStatesForHostResponse and nil error while calling GetActualStatesForHost. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveSetActualStateForHost(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetActualStateForHostJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetActualStateForHostProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveSetActualStateForHostJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetActualStateForHost")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetActualStateForHostRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetActualStateForHostResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.SetActualStateForHost(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetActualStateForHostResponse and nil error while calling SetActualStateForHost. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveSetActualStateForHostProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetActualStateForHost")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetActualStateForHostRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetActualStateForHostResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.SetActualStateForHost(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetActualStateForHostResponse and nil error while calling SetActualStateForHost. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveMapAppsToPipeline(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveMapAppsToPipelineJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveMapAppsToPipelineProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveMapAppsToPipelineJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MapAppsToPipeline")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(MapAppsToPipelineRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *MapAppsToPipelineResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.MapAppsToPipeline(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MapAppsToPipelineResponse and nil error while calling MapAppsToPipeline. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveMapAppsToPipelineProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "MapAppsToPipeline")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(MapAppsToPipelineRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *MapAppsToPipelineResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.MapAppsToPipeline(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *MapAppsToPipelineResponse and nil error while calling MapAppsToPipeline. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveUnmapAppsFromPipeline(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUnmapAppsFromPipelineJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUnmapAppsFromPipelineProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveUnmapAppsFromPipelineJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UnmapAppsFromPipeline")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UnmapAppsFromPipelineRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UnmapAppsFromPipelineResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.UnmapAppsFromPipeline(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UnmapAppsFromPipelineResponse and nil error while calling UnmapAppsFromPipeline. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveUnmapAppsFromPipelineProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UnmapAppsFromPipeline")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UnmapAppsFromPipelineRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UnmapAppsFromPipelineResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.UnmapAppsFromPipeline(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UnmapAppsFromPipelineResponse and nil error while calling UnmapAppsFromPipeline. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveListAppsForPipeline(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListAppsForPipelineJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListAppsForPipelineProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveListAppsForPipelineJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAppsForPipeline")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListAppsForPipelineRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListAppsForPipelineResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.ListAppsForPipeline(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAppsForPipelineResponse and nil error while calling ListAppsForPipeline. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveListAppsForPipelineProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListAppsForPipeline")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListAppsForPipelineRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListAppsForPipelineResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.ListAppsForPipeline(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListAppsForPipelineResponse and nil error while calling ListAppsForPipeline. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveListPipelinesForApp(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListPipelinesForAppJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListPipelinesForAppProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *stagedDeploy2Server) serveListPipelinesForAppJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPipelinesForApp")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListPipelinesForAppRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPipelinesForAppResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.ListPipelinesForApp(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPipelinesForAppResponse and nil error while calling ListPipelinesForApp. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) serveListPipelinesForAppProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPipelinesForApp")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListPipelinesForAppRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPipelinesForAppResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StagedDeploy2.ListPipelinesForApp(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPipelinesForAppResponse and nil error while calling ListPipelinesForApp. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *stagedDeploy2Server) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *stagedDeploy2Server) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *stagedDeploy2Server) PathPrefix() string {
	return StagedDeploy2PathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1558 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x4b, 0x6f, 0x14, 0xc7,
	0x16, 0x56, 0x7b, 0x78, 0xd8, 0xc7, 0x33, 0xd8, 0x14, 0x7e, 0x34, 0x6d, 0x03, 0xe3, 0x46, 0x42,
	0xe6, 0x5e, 0x5d, 0xc3, 0xb5, 0x09, 0x24, 0x58, 0x90, 0x18, 0x13, 0x8c, 0x63, 0x1c, 0xc1, 0x8c,
	0x51, 0xa4, 0x6c, 0x5a, 0xe5, 0xee, 0x82, 0x69, 0xe8, 0x57, 0xba, 0x6a, 0x8c, 0x89, 0x22, 0x25,
	0xca, 0x0a, 0x65, 0x91, 0x28, 0xab, 0x48, 0x91, 0xb2, 0xc8, 0x3e, 0xcb, 0xfc, 0x85, 0xfc, 0xa7,
	0x28, 0xab, 0xa8, 0xab, 0xaa, 0x1f, 0x33, 0xd3, 0x0f, 0xcf, 0xd8, 0xc9, 0x06, 0x31, 0xa7, 0xce,
	0xe3, 0x3b, 0x5f, 0x9d, 0x3a, 0x75, 0xaa, 0x0d, 0xab, 0xa6, 0x6f, 0x91, 0x95, 0x57, 0x5d, 0xca,
	0x6c, 0x6f, 0x85, 0x1d, 0xdc, 0xc0, 0xee, 0x97, 0xde, 0x8d, 0x36, 0xc3, 0x2f, 0x89, 0xf5, 0x90,
	0x04, 0x8e, 0xff, 0x76, 0x75, 0xef, 0x8d, 0x1d, 0x06, 0x37, 0x58, 0xf4, 0xef, 0x4a, 0x10, 0xfa,
	0xcc, 0x47, 0x0b, 0xec, 0x8d, 0xcd, 0xcc, 0xce, 0xca, 0x8b, 0xae, 0xc3, 0x7c, 0x6f, 0x85, 0x72,
	0x6d, 0x4b, 0x68, 0xeb, 0xbf, 0x8d, 0xc1, 0x74, 0x8b, 0x1c, 0xd8, 0xd4, 0xf6, 0xbd, 0x5d, 0xc2,
	0xb0, 0x85, 0x19, 0x46, 0x4d, 0x98, 0xc4, 0x41, 0xe0, 0xd8, 0x26, 0x66, 0xb6, 0xef, 0xa9, 0x4a,
	0x53, 0x59, 0x9e, 0x68, 0x65, 0x45, 0xe8, 0x0a, 0x4c, 0x86, 0xd2, 0xca, 0xb0, 0x2d, 0x75, 0x8c,
	0x6b, 0x40, 0x2c, 0xda, 0xb6, 0xd0, 0x75, 0x98, 0x4e, 0x14, 0x4c, 0xdf, 0x75, 0x89, 0xc7, 0xd4,
	0x1a, 0xd7, 0x9a, 0x8a, 0xe5, 0x9b, 0x42, 0x8c, 0x6e, 0xc1, 0x5c, 0xaa, 0x1a, 0x12, 0x1e, 0xc0,
	0x60, 0xb6, 0x4b, 0xd4, 0x53, 0xdc, 0x60, 0x26, 0x31, 0x90, 0x8b, 0x7b, 0xb6, 0x4b, 0xd0, 0x12,
	0xd4, 0x13, 0xab, 0x6e, 0x68, 0xab, 0xa7, 0x05, 0xc8, 0x58, 0xf6, 0x3c, 0xb4, 0xd1, 0x33, 0xa8,
	0x5b, 0x24, 0x20, 0x9e, 0x45, 0x3c, 0xd3, 0x26, 0x54, 0x3d, 0xd3, 0xac, 0x2d, 0x4f, 0xae, 0xfe,
	0x6f, 0xa5, 0x84, 0x8f, 0x95, 0x7e, 0x2e, 0x5a, 0x3d, 0x2e, 0xf4, 0x5f, 0x15, 0xa8, 0xef, 0x6e,
	0xee, 0x3c, 0xc5, 0x21, 0xb3, 0x39, 0x11, 0x57, 0xa1, 0xe1, 0x62, 0xb3, 0x63, 0x7b, 0xc4, 0x30,
	0x1d, 0x4c, 0xa9, 0x24, 0xab, 0x2e, 0x85, 0x9b, 0x91, 0x0c, 0x4d, 0x43, 0x2d, 0xf0, 0x03, 0xc9,
	0x52, 0xf4, 0xdf, 0x88, 0x61, 0xe2, 0x1d, 0xd8, 0xa1, 0xef, 0x65, 0x98, 0xc9, 0x8a, 0x90, 0x06,
	0xe3, 0xb4, 0xbb, 0xcf, 0xc1, 0x49, 0x1e, 0x92, 0xdf, 0x68, 0x11, 0x26, 0x82, 0x18, 0x81, 0x4c,
	0x3c, 0x15, 0xe8, 0x5f, 0xc3, 0xac, 0xa8, 0x85, 0x38, 0x97, 0x16, 0xf9, 0xa2, 0x4b, 0x28, 0x3b,
	0x89, 0x6d, 0xbd, 0x0a, 0x8d, 0xc0, 0x0e, 0x88, 0x13, 0xe5, 0xeb, 0x61, 0x97, 0x48, 0xe4, 0xf5,
	0x58, 0xf8, 0x29, 0x76, 0x89, 0xfe, 0x93, 0x02, 0x73, 0xfd, 0x08, 0x68, 0xe0, 0x7b, 0x94, 0xa0,
	0x55, 0x98, 0x4d, 0xec, 0xc9, 0x21, 0x31, 0xbb, 0x4c, 0x86, 0x12, 0x60, 0x2e, 0xc4, 0x8b, 0x1f,
	0xc7, 0x6b, 0xdb, 0x16, 0xda, 0x86, 0xf1, 0x18, 0x01, 0x47, 0x34, 0xf4, 0x16, 0x26, 0xe6, 0x3a,
	0x89, 0x80, 0x99, 0x0e, 0x0e, 0xc9, 0xf0, 0xdc, 0xe4, 0x55, 0xf4, 0x58, 0x6e, 0x45, 0xeb, 0xef,
	0x14, 0x98, 0x1f, 0x88, 0x23, 0x19, 0xd0, 0xa1, 0x41, 0xd7, 0x8c, 0x6e, 0xe0, 0xf8, 0xd8, 0xe2,
	0x85, 0x2b, 0x43, 0xd1, 0xb5, 0xe7, 0x5c, 0x16, 0x15, 0xee, 0x09, 0x66, 0x7c, 0x07, 0x2e, 0x6c,
	0x11, 0x16, 0x2b, 0xd0, 0x23, 0xa7, 0xab, 0xdf, 0x81, 0x99, 0x5e, 0x43, 0x89, 0xbf, 0xaf, 0x44,
	0x94, 0x66, 0xad, 0xb7, 0x44, 0x74, 0x03, 0xb4, 0x8c, 0x61, 0x02, 0xe9, 0xc4, 0x6a, 0x50, 0xef,
	0xc0, 0x42, 0x6e, 0x00, 0x09, 0x30, 0x4b, 0x9e, 0x72, 0x3c, 0xf2, 0x54, 0x98, 0xdb, 0x22, 0x6c,
	0x23, 0x05, 0x17, 0xf3, 0xa7, 0xaf, 0xc3, 0xfc, 0xc0, 0x8a, 0x8c, 0x3f, 0x90, 0x61, 0xad, 0x9f,
	0xda, 0xef, 0x14, 0x68, 0x6e, 0x7b, 0x36, 0xb3, 0x31, 0x23, 0x4f, 0xfb, 0x0b, 0xfe, 0xdf, 0x3e,
	0xac, 0x9f, 0xc1, 0x52, 0x09, 0x96, 0xd1, 0x8f, 0xad, 0xfe, 0x57, 0x0d, 0x1a, 0xdb, 0x1e, 0x8b,
	0x7a, 0xa7, 0xd5, 0x66, 0x98, 0x91, 0x93, 0x48, 0xa9, 0x10, 0x48, 0xad, 0xb8, 0x7f, 0x7c, 0x04,
	0x8b, 0x39, 0x36, 0xd1, 0x05, 0x43, 0x19, 0x76, 0x03, 0xd9, 0x5d, 0xb5, 0x01, 0xd3, 0xbd, 0x58,
	0x03, 0x5d, 0x83, 0xa9, 0xc4, 0xc3, 0x2b, 0x7f, 0x3f, 0x8a, 0x27, 0xba, 0x6e, 0xc2, 0xef, 0x27,
	0xfe, 0xfe, 0xb6, 0x15, 0xdd, 0x64, 0x3d, 0x7a, 0x69, 0x8c, 0x33, 0xe2, 0x26, 0xcb, 0xa8, 0xa7,
	0xde, 0x6f, 0xc1, 0x9c, 0x8b, 0x0f, 0x0d, 0x51, 0x8f, 0x86, 0xe9, 0x7b, 0x66, 0x37, 0x0c, 0x89,
	0x67, 0xbe, 0x55, 0xcf, 0x36, 0x95, 0xe5, 0xd3, 0xad, 0x19, 0x17, 0x1f, 0x8a, 0x76, 0xba, 0x99,
	0xae, 0xa1, 0x9b, 0x10, 0xc9, 0x0d, 0xca, 0xfc, 0x90, 0x58, 0x46, 0x4c, 0x11, 0x55, 0xc7, 0xb9,
	0x0d, 0x72, 0xf1, 0x61, 0x9b, 0x2f, 0x25, 0x27, 0x38, 0x8a, 0x43, 0xa3, 0x7d, 0x30, 0xcc, 0x0e,
	0xf6, 0x5e, 0x92, 0x0c, 0xba, 0x09, 0x81, 0x8e, 0xaf, 0x6e, 0xf2, 0xc5, 0x1e, 0x74, 0x1d, 0x4c,
	0xf3, 0xd0, 0x41, 0x53, 0x59, 0x1e, 0x6f, 0xcd, 0x74, 0x30, 0x1d, 0x40, 0xa7, 0xff, 0x79, 0x1a,
	0x26, 0x37, 0x4c, 0xd6, 0xc5, 0x8e, 0xd8, 0x7a, 0x0d, 0xc6, 0x3b, 0x3e, 0x65, 0xbc, 0x0a, 0xc5,
	0xbe, 0x27, 0xbf, 0xfb, 0xcb, 0x62, 0x6c, 0xb0, 0x2c, 0x10, 0x9c, 0x72, 0xcd, 0xd7, 0x81, 0xdc,
	0x64, 0xfe, 0x7f, 0xb4, 0x0e, 0x9a, 0x83, 0x29, 0x33, 0x30, 0x63, 0xc4, 0x0d, 0x58, 0x86, 0x83,
	0x68, 0x7b, 0xc4, 0x9e, 0xce, 0x47, 0x1a, 0x1b, 0xb1, 0x42, 0x2b, 0x2d, 0xa3, 0x6d, 0x58, 0x2a,
	0x32, 0x4e, 0x59, 0x11, 0x5b, 0x7c, 0x39, 0xd7, 0x47, 0xca, 0xcf, 0x3d, 0x58, 0xe0, 0xae, 0x68,
	0xd7, 0x34, 0x09, 0xa5, 0x2f, 0xba, 0x4e, 0x0f, 0x10, 0xb1, 0xf1, 0x6a, 0xa4, 0xd2, 0x4e, 0x34,
	0x32, 0x48, 0x76, 0x40, 0x2f, 0x34, 0x4f, 0xa1, 0x9c, 0xe5, 0x5e, 0xae, 0xe4, 0x7b, 0x49, 0xb1,
	0x14, 0x9e, 0x8e, 0xf1, 0xd1, 0x4f, 0xc7, 0xc4, 0x28, 0xa7, 0x03, 0x86, 0x3b, 0x1d, 0x93, 0x25,
	0xa7, 0xe3, 0x3a, 0x4c, 0x77, 0x08, 0x0e, 0xd9, 0x3e, 0xc1, 0xcc, 0x70, 0x30, 0x23, 0x94, 0xa9,
	0x75, 0x71, 0xed, 0x26, 0xf2, 0x27, 0x5c, 0x8c, 0xfe, 0x0b, 0xe7, 0x53, 0x55, 0x9b, 0x37, 0x35,
	0x47, 0x6d, 0x70, 0xdd, 0xd4, 0x87, 0x68, 0x76, 0x4e, 0xd4, 0x6a, 0xa2, 0x0a, 0x34, 0xa2, 0xa2,
	0xef, 0x52, 0xf5, 0x9c, 0x68, 0x35, 0x91, 0xa8, 0xcd, 0x25, 0xe8, 0x36, 0xcc, 0x8b, 0x83, 0x62,
	0x19, 0x56, 0x37, 0xb4, 0xbd, 0x97, 0x46, 0x8c, 0x4f, 0x9d, 0xe2, 0x95, 0x3f, 0x2b, 0x97, 0x1f,
	0xf2, 0xd5, 0xb8, 0x79, 0xea, 0xfb, 0xb0, 0xb4, 0x45, 0x58, 0xdc, 0xf9, 0x92, 0xe3, 0xf7, 0xc8,
	0x0f, 0x77, 0x37, 0x77, 0xe2, 0xee, 0x7e, 0x4f, 0x56, 0xb4, 0xb8, 0xa0, 0xae, 0x97, 0x5e, 0x50,
	0xd9, 0x79, 0x53, 0x14, 0xbf, 0xfe, 0x06, 0xf4, 0xb2, 0x18, 0xb2, 0x6b, 0x3f, 0x83, 0x73, 0xb6,
	0x54, 0xe1, 0x69, 0x12, 0x7e, 0x19, 0x4d, 0xae, 0xfe, 0xa7, 0x34, 0x5c, 0x4f, 0xcf, 0x6e, 0x35,
	0xec, 0xec, 0x4f, 0xfd, 0x77, 0x05, 0x9a, 0xed, 0xc1, 0xc8, 0x27, 0x99, 0x5c, 0x0e, 0x6c, 0x31,
	0x03, 0x1d, 0x03, 0xf6, 0x01, 0x2c, 0x95, 0xa0, 0x2e, 0xa1, 0xeb, 0x98, 0x71, 0xbf, 0x51, 0xe0,
	0x52, 0x34, 0x27, 0xa4, 0x9d, 0x50, 0xee, 0xd1, 0xd3, 0x13, 0xe2, 0xaa, 0xb2, 0x77, 0xea, 0x3f,
	0x28, 0x70, 0xb9, 0x08, 0x82, 0x4c, 0x7c, 0x07, 0xea, 0x98, 0x2f, 0xf7, 0x54, 0xc9, 0x72, 0x29,
	0x96, 0x8c, 0xbf, 0xd6, 0x24, 0xce, 0x74, 0xfa, 0x6a, 0x44, 0xeb, 0x79, 0x9c, 0x3c, 0xf6, 0x29,
	0x8b, 0x39, 0x29, 0xb9, 0x2c, 0x74, 0x3f, 0x2f, 0x1b, 0x61, 0x2c, 0xb3, 0xd9, 0x85, 0x46, 0x36,
	0x1b, 0x3a, 0x74, 0x3a, 0xf5, 0x4c, 0x3a, 0x54, 0x7f, 0x0d, 0x8b, 0xed, 0x9e, 0x80, 0x7d, 0x60,
	0x07, 0xc9, 0x53, 0x46, 0x26, 0x4f, 0x77, 0xe0, 0x52, 0x41, 0xb0, 0xc2, 0xad, 0x3a, 0x46, 0xb4,
	0x57, 0xa0, 0xee, 0xe2, 0x60, 0x23, 0x08, 0xe8, 0x9e, 0x1f, 0xb7, 0xaf, 0x38, 0xad, 0x81, 0xd9,
	0x51, 0x19, 0x9c, 0x1d, 0xa3, 0xde, 0x9c, 0xd9, 0x58, 0xa1, 0x37, 0xc6, 0xe7, 0xdd, 0xa9, 0x8c,
	0x9c, 0x8f, 0x99, 0x0b, 0x70, 0x31, 0x27, 0x96, 0xc8, 0x4a, 0xf7, 0x60, 0xf1, 0xb9, 0xe7, 0x8a,
	0xe5, 0x47, 0xa1, 0xef, 0xfe, 0xd3, 0x60, 0xae, 0xc0, 0xa5, 0x82, 0x78, 0x12, 0xd0, 0x06, 0x68,
	0x4f, 0x6c, 0xca, 0xf8, 0xba, 0x1f, 0x8e, 0x02, 0x47, 0x7f, 0x0c, 0x0b, 0xb9, 0x2e, 0xe4, 0x46,
	0xe6, 0xa1, 0x55, 0xf2, 0xd1, 0x6e, 0x09, 0x30, 0xb1, 0x8b, 0xc8, 0xdd, 0x46, 0x10, 0xc4, 0x60,
	0xf2, 0x1d, 0x29, 0x79, 0x8e, 0x1e, 0x08, 0x48, 0x03, 0x8e, 0x24, 0xa4, 0x9c, 0xb4, 0x6a, 0xfd,
	0x69, 0xad, 0xfe, 0x31, 0x0d, 0x8d, 0x9e, 0xef, 0x4d, 0xe8, 0x2d, 0x9c, 0xeb, 0x7d, 0xec, 0xa3,
	0xd5, 0xd2, 0x72, 0xcc, 0xfd, 0x36, 0xa1, 0xad, 0x0d, 0x65, 0x23, 0x11, 0x7f, 0x05, 0x53, 0x7d,
	0xcf, 0x6c, 0x54, 0xe5, 0x27, 0xef, 0xf1, 0xaf, 0xdd, 0x1a, 0xce, 0x48, 0x46, 0xa7, 0x50, 0xcf,
	0xbe, 0x90, 0xd1, 0xcd, 0x52, 0x2f, 0x39, 0xaf, 0x70, 0xed, 0xff, 0x43, 0x58, 0xc8, 0xa0, 0xef,
	0x94, 0x9e, 0x07, 0x7d, 0xf2, 0xc9, 0xee, 0xce, 0x51, 0x5d, 0xf5, 0x3d, 0xc8, 0xb5, 0xf7, 0x87,
	0x37, 0x4c, 0xd9, 0xef, 0x7b, 0x03, 0x57, 0xb0, 0x9f, 0xff, 0x96, 0xae, 0x60, 0xbf, 0xe8, 0x99,
	0xfd, 0xb3, 0x02, 0x17, 0x0b, 0x1f, 0xae, 0xe8, 0x5e, 0xc5, 0x9d, 0x5d, 0xfe, 0xf8, 0xd6, 0xee,
	0x8f, 0x6a, 0x2e, 0xc1, 0xfd, 0xa2, 0xf0, 0x8f, 0x20, 0x05, 0x03, 0x1a, 0xba, 0x5f, 0x95, 0x71,
	0xf9, 0xf4, 0xa8, 0x7d, 0x38, 0xb2, 0x7d, 0x86, 0xbc, 0xc2, 0x81, 0xa8, 0x82, 0xbc, 0xaa, 0xf1,
	0xaf, 0x82, 0xbc, 0xea, 0x39, 0xec, 0x47, 0x45, 0x7c, 0x76, 0x19, 0x9c, 0x58, 0xd0, 0xdd, 0xca,
	0x52, 0x29, 0x9c, 0xb4, 0xb4, 0xf5, 0x91, 0x6c, 0x4b, 0x31, 0x45, 0x57, 0xf3, 0xd0, 0x98, 0x32,
	0xc3, 0xc3, 0xd0, 0x98, 0x7a, 0x66, 0x81, 0xef, 0x15, 0x98, 0xcd, 0x9d, 0x16, 0xd0, 0x07, 0x55,
	0x3b, 0x50, 0x38, 0xce, 0x68, 0x77, 0x47, 0x31, 0x95, 0x80, 0xbe, 0x55, 0xe0, 0xfc, 0xc0, 0x25,
	0x8f, 0xde, 0x2b, 0x9f, 0x69, 0x0b, 0x06, 0x10, 0xed, 0xf6, 0xb0, 0x66, 0x19, 0x56, 0x72, 0x2f,
	0xf7, 0x0a, 0x56, 0xca, 0x06, 0x90, 0x0a, 0x56, 0x4a, 0x67, 0x09, 0xde, 0xb1, 0x73, 0x26, 0x81,
	0x8a, 0x8e, 0x5d, 0x3c, 0x7e, 0x54, 0x74, 0xec, 0xb2, 0xa1, 0x23, 0x86, 0xd2, 0x37, 0x01, 0x1c,
	0x01, 0x4a, 0xfe, 0xf0, 0x71, 0x04, 0x28, 0x05, 0xc3, 0xc6, 0x83, 0xe5, 0xcf, 0xaf, 0x1d, 0xed,
	0x4f, 0x59, 0xfb, 0x67, 0xf8, 0x5f, 0xb1, 0xd6, 0xfe, 0x0e, 0x00, 0x00, 0xff, 0xff, 0xa9, 0x29,
	0x60, 0xc4, 0xfb, 0x1a, 0x00, 0x00,
}
