# Contributing

This is a copy of code from
[GoAmzn-StarfruitAbyss](https://code.amazon.com/packages/GoAmzn-StarfruitAbyss/trees/mainline/--/)
to provide our client to github repositories.

## Updating this mirror

This is a mirror. Update it with git. Your first time after cloning this repo, do this:
```
git remote add amazon ssh://git.amazon.com/pkg/GoAmzn-StarfruitAbyss
```

Then, to update, do this:
```
git fetch amazon
git checkout mainline
git pull
git checkout mainline-mirror
git merge mainline
git push
```

### Why not use BrazilArtifactGHEUploadScript?

At the time of writing, [BrazilArtifactGHEUploadScript](https://git-aws.internal.justin.tv/cioc/BrazilArtifactGHEUploadScript/commit/ac597645d874d1598a40cd80e81b62bec014c354) didn't work with our package. Since our package build requires python due to `cfn-build`, overlay mode is needed. When overlay support was added to the script, the github package was checked out with reports pointing to the amazon package instead of github repository. This caused the [push to go to our amazon repo](https://code.amazon.com/packages/GoAmzn-StarfruitAbyss/commits/ca143c305c3c3578464c60c7620ba473c19a3b47#). [Slack conversation is here](https://twitch.slack.com/archives/C9BUPDUC8/p1571359346420400)

Overlay support was added with:
```
--- a/uploadArtifactsToTwitch.py
+++ b/uploadArtifactsToTwitch.py
@@ -17,6 +17,8 @@ def createAndBuildBrazilWS(originalPath, brazilWSPath, brazilWSName, versionSet,
         print 'Cloning desired package in the newly created workspace'
         subprocess.check_output(['brazil', 'workspace', 'use', '--package', brazilPackageName], cwd=brazilWSPath)
         brazilPackagePath = brazilWSPath + '/src/' + brazilPackageName
+        print 'Performing brazil setup platform-support --mode overlay intended package'
+        subprocess.check_output(['brazil', 'setup', 'platform-support', '--mode', 'overlay', '-f'], cwd=brazilPackagePath)
         print 'Performing a brazil-build on the intended package'
         subprocess.check_output(['brazil-build'], cwd=brazilPackagePath)
         return brazilPackagePath
```
