# Starfruit Abyss

Companion package to StarfruitAbyss, which exports a CloudFormation resource representing the Abyss input stream (Kinesis Firehose).

## Development

* Template based on GoAmzn-HawkeyeUserAlarmLambda
* https://code.amazon.com/packages/GoAmzn-Github-Aws-AwsLambdaGo/trees/mainline
* https://docs.aws.amazon.com/lambda/latest/dg/go-programming-model.html
* https://docs.aws.amazon.com/lambda/latest/dg/deploying-lambda-apps.html

On MacOS, run this once in your workspace

```bash
brazil setup platform-support
brazil-recursive-cmd --allPackages brazil-build
```

Ensure that you have the following environment variables configured (e.g. in your .zshrc file)

```bash
export SAM_ASSUME_ACCOUNT_ID=<your personal AWS account>
export SAM_ISENGARD_ROLE_NAME=<any Isengard role on that account with sufficient permissions to deploy this stack>
```

To build and deploy:

```bash
brazil-build release
./sam package
./sam deploy
```

You can view data flowing at `sam-${USER}-goamzn-starfruitabyss` cloudwatch dashboard.

### Developing CloudFormation

You can use `make cfn` to build and validate your CloudFormation. This is faster than `brazil-build release` because that command compiles a lot and typically fails to cache brazil paths leading to longer run times.