package main

import (
	"log"
	"os"
	"strings"

	"code.justin.tv/amzn/StarfruitAbyss/internal/cloudwatch"
	"code.justin.tv/amzn/StarfruitAbyss/internal/dummy"
	"code.justin.tv/amzn/StarfruitAbyss/internal/logger"
)

func main() {
	handler := os.Getenv("HANDLER")
	switch strings.ToLower(handler) {
	case "dummy":
		dummy.Run()
	case "logger":
		logger.Run()
	case "cloudwatch":
		cloudwatch.Run()
	default:
		log.Fatalf("unknown handler: %q", handler)
	}
}
