package main

import (
	"context"
	"fmt"
	"log"
	"os"
	"testing"

	abyss "code.justin.tv/amzn/AwsStarfruitAbyssCollectorTwirp"
	"code.justin.tv/amzn/StarfruitAbyss/producer"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sqs"
	"github.com/stretchr/testify/require"
)

var (
	homeRegions = []string{"us-west-2", "us-east-2"}
)

func TestIntegrationSQS(t *testing.T) {
	if os.Getenv("HYDRA") == "" {
		// Noop since this means we are likely trying to run integration tests as part of unit testing
		log.Println("Not running integration tests under HYDRA, terminate")
		os.Exit(0)
	}

	sqsClient := sqs.New(session.New(aws.NewConfig()))
	pdr, err := producer.NewAbyssProducer(os.Getenv("STAGE"), os.Getenv("ORIGIN"), sqsClient)
	require.NoError(t, err)
	require.NotNil(t, pdr)

	ctx := context.Background()

	arnFormat := "arn:aws:starfruit:%s:123456780000:channel:testdata"

	for _, region := range homeRegions {
		t.Run(region, func(t *testing.T) {
			require.NoError(t, pdr.RecordContentContributed(ctx, &abyss.ContentContributed{
				Stream: &abyss.ContributionStream{
					Stream: &abyss.StreamResource{
						ChannelArn: fmt.Sprintf(arnFormat, region),
					},
				},
			}))
			require.NoError(t, pdr.RecordContentTranscoded(ctx, &abyss.ContentTranscoded{
				Stream: &abyss.ContributionStream{
					Stream: &abyss.StreamResource{
						ChannelArn: fmt.Sprintf(arnFormat, region),
					},
				}}))
			require.NoError(t, pdr.RecordContentDelivered(ctx, &abyss.ContentDelivered{
				Stream: &abyss.StreamResource{
					ChannelArn: fmt.Sprintf(arnFormat, region),
				},
			}))
			require.NoError(t, pdr.RecordContentDeliveredBatch(ctx, region, &abyss.RecordContentDeliveredRequest{
				Data: []*abyss.ContentDelivered{
					&abyss.ContentDelivered{
						Stream: &abyss.StreamResource{
							ChannelArn: fmt.Sprintf(arnFormat, region),
						},
					},
				},
			}))
		})
	}

}
