import boto3
import logging
import cfnresponse

log = logging.getLogger()
log.setLevel(logging.INFO)

client = boto3.client("kinesisanalytics")

def handler(event, context):
  if event["RequestType"] == "Update":
    cfnresponse.send(event, context, cfnresponse.SUCCESS, {})
  if event["RequestType"] == "Delete":
    cfnresponse.send(event, context, cfnresponse.SUCCESS, {})
  if event["RequestType"] == "Create":
    analytics_app_name = event["ResourceProperties"]["AnalyticsAppName"]
    log.info("Received App name: {}".format(analytics_app_name))
    try:
      response = client.describe_application(ApplicationName=analytics_app_name)
      app_status = response["ApplicationDetail"]["ApplicationStatus"]
      if app_status == "RUNNING":
        log.info("App is already RUNNING")
        cfnresponse.send(event, context, cfnresponse.SUCCESS, {})
        return
      for input in response["ApplicationDetail"]["InputDescriptions"]:
        input_id = input["InputId"] # this is an ID like "1.1", not an ARN or stream name
        log.info("Starting input {} on application {}".format(input_id, analytics_app_name))
        client.start_application(
            ApplicationName=analytics_app_name,
            InputConfigurations=[
                {
                    "Id": input_id,
                    "InputStartingPositionConfiguration": {
                        "InputStartingPosition": "LAST_STOPPED_POINT"
                    }
                },
            ]
        )
      cfnresponse.send(event, context, cfnresponse.SUCCESS, {})
    except Exception as e:
      log.error("Failed to start application: " + str(e))
      cfnresponse.send(event, context, cfnresponse.FAILED, {})
