import boto3
import logging
import cfnresponse

log = logging.getLogger()
log.setLevel(logging.INFO)

client = boto3.client("s3")

def handler(event, context):
  log.info("Called with event = {}".format(event))
  if event["RequestType"] == "Create":
    cfnresponse.send(event, context, cfnresponse.SUCCESS, {})
  if event["RequestType"] == "Update":
    cfnresponse.send(event, context, cfnresponse.SUCCESS, {})
  if event["RequestType"] == "Delete":
    bucket_name = event["ResourceProperties"]["BucketName"]
    # Access logging would generate new objects in target bucket while the existing objects are being deleted.
    # For now, access logs are written to the bucket itself.
    log.info("Disabling access logging on bucket {}".format(bucket_name))
    client.put_bucket_logging(
      Bucket=bucket_name,
      BucketLoggingStatus={},
    )
    log.info("Disabling write access by external services on bucket {}".format(bucket_name))
    client.put_bucket_acl(
      ACL="private",
      Bucket=bucket_name,
    )
    log.info("Deleting all objects in bucket {}".format(bucket_name))
    # This can take quite a long time if there are many objects
    bucket = boto3.resource('s3').Bucket(bucket_name)
    bucket.objects.all().delete()
    log.info("Finished deleting objects in bucket {}".format(bucket_name))
    cfnresponse.send(event, context, cfnresponse.SUCCESS, {})