package dummy

import (
	"time"

	"code.justin.tv/amzn/StarfruitAbyss/internal/models"
)

type broadcast struct {
	channelARN         string
	broadcastSessionID string
	broadcasterCountry string
	ingestPOP          string
	redundantIngest    bool

	transcodeType string
	originDC      string
}

func newIngest() *broadcast {
	return &broadcast{
		channelARN:         randomChannelARN(),
		broadcastSessionID: randomUUID(),
		redundantIngest:    false,
		broadcasterCountry: randomStr(countries),
		ingestPOP:          randomEdgePoP(),
		transcodeType:      randomStr(transcoders),
		originDC:           randomStr(originDCs),
	}
}

func nowUtcMillis() string {
	return time.Now().UTC().Format("2006-01-02 15:04:05")
}

func (b broadcast) contribute() *models.ContentContributed {
	return &models.ContentContributed{
		Metadata: models.Metadata{
			EventID:    randomUUID(),
			Time:       nowUtcMillis(),
			ChannelARN: b.channelARN,
		},
		IngestPOP:          b.ingestPOP,
		BroadcastSessionID: b.broadcastSessionID,
		NumBytes:           rxBytesRange.Sample(),
		ContentLength:      2000,
		RedundantIngest:    b.redundantIngest,
		BroadcasterCountry: b.broadcasterCountry,
	}
}

func (b broadcast) transcode() *models.ContentTranscoded {
	return &models.ContentTranscoded{
		Metadata: models.Metadata{
			EventID:    randomUUID(),
			Time:       nowUtcMillis(),
			ChannelARN: b.channelARN,
		},
		BroadcastSessionID: b.broadcastSessionID,
		ContentLength:      2000,
		TranscoderType:     b.transcodeType,
		OriginDC:           b.originDC,
	}
}

func (b broadcast) delivered(period time.Duration) *models.ContentDelivered {
	return &models.ContentDelivered{
		Metadata: models.Metadata{
			EventID:    randomUUID(),
			Time:       nowUtcMillis(),
			ChannelARN: b.channelARN,
		},
		Rendition:     randomStr(renditions),
		LatencyTier:   randomStr(latencyTiers),
		EdgePoP:       randomEdgePoP(),
		NumBytes:      bytesDeliveredRange.Sample(),
		ContentLength: int(period.Nanoseconds() / 1e6),
		ViewerCountry: randomStr(countries),
	}
}
