package dummy

import (
	"fmt"
	"math/rand"
	"os"
	"time"
)

var (
	countries    = []string{"AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BS", "BH", "BD", "BB", "BY", "BE", "BZ", "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "CV", "KH", "CM", "CA", "KY", "CF", "TD", "CL", "CN", "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER", "EE", "SZ", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG", "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ", "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MG", "MW", "MY", "MV", "ML", "MT", "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE", "NG", "NU", "NF", "MK", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW", "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS", "SS", "ES", "LK", "SD", "SR", "SJ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC", "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW"}
	transcoders  = []string{"quicksync", "event", "x264", "vp9"}
	originDCs    = []string{"cmh01", "sjc01"}
	latencyTiers = []string{"Low", "UltraLow"}
	renditions   = []string{"chunked", "720p60", "720p30", "480p30", "360p30", "160p30"}
)

func init() {
	rand.Seed(time.Now().UnixNano())
}

func randomStr(a []string) string {
	return a[rand.Intn((len(a)))]
}

func randomBytes(n int) []byte {
	b := make([]byte, n)
	f, _ := os.Open("/dev/urandom")
	f.Read(b)
	f.Close()
	return b
}

func randomIP() string {
	b := randomBytes(4)
	return fmt.Sprintf("%d.%d.%d.%d", b[0], b[1], b[2], b[3])
}

func randomUUID() string {
	b := randomBytes(16)
	return fmt.Sprintf("%x-%x-%x-%x-%x", b[0:4], b[4:6], b[6:8], b[8:10], b[10:])
}

type intRange struct {
	min, max int
}

func (ir *intRange) Sample() int {
	return rand.Intn(ir.max-ir.min) + ir.min
}

func randomCustomerID() string {
	const len = 12
	const asciiZero = 48
	b := make([]byte, len)
	for i := 0; i < len; i++ {
		b[i] = byte(rand.Intn(10) + asciiZero)
	}
	return string(b)
}

func randomChannelID() string {
	prefixes := []string{
		"bob",
		"ross",
		"bob-ross",
	}
	p := prefixes[rand.Intn(len(prefixes))]
	idx := rand.Intn(100)
	return fmt.Sprintf("%s-%02d", p, idx)
}

func randomStreamID() string {
	return randomUUID()
}

func randomEdgePoP() string {
	dcs := []string{
		"ord",
		"sjc",
		"dub",
	}
	dc := dcs[rand.Intn(len(dcs))]
	idx := rand.Intn(100)
	return fmt.Sprintf("%s%02d", dc, idx)
}

func randomChannelARN() string {
	return "arn:aws:starfruit:us-west-2:" + randomCustomerID() + ":channel:" + randomChannelID()
}
