package models

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/cloudwatch"
)

type arner interface {
	Account() string
	Channel() string
}

func arnerDimensions(a arner) [][]*cloudwatch.Dimension {
	accountDim := &cloudwatch.Dimension{
		Name:  aws.String("Account"),
		Value: aws.String(a.Account()),
	}
	channelDim := &cloudwatch.Dimension{
		Name:  aws.String("Channel"),
		Value: aws.String(a.Channel()),
	}

	return [][]*cloudwatch.Dimension{
		{},
		{
			accountDim,
		}, {
			accountDim,
			channelDim,
		},
	}
}

func (c ContentContributed) MetricDatum() ([]*cloudwatch.MetricDatum, error) {
	allDimensions := arnerDimensions(c)

	timestamp, err := c.EventTime()
	if err != nil {
		return nil, err
	}

	var metricDatums []*cloudwatch.MetricDatum

	for _, dimensions := range allDimensions {
		metricDatums = append(metricDatums, &cloudwatch.MetricDatum{
			MetricName: aws.String("BytesIngested"),
			Dimensions: dimensions,
			Value:      aws.Float64(float64(c.NumBytes)),
			Timestamp:  aws.Time(timestamp),
			Unit:       aws.String(cloudwatch.StandardUnitBytes),
		}, &cloudwatch.MetricDatum{
			MetricName: aws.String("SecondsIngested"),
			Dimensions: dimensions,
			Value:      aws.Float64(float64(c.ContentLength)),
			Timestamp:  aws.Time(timestamp),
			Unit:       aws.String(cloudwatch.StandardUnitMilliseconds),
		})
	}

	return metricDatums, nil
}

func (t ContentTranscoded) MetricDatum() ([]*cloudwatch.MetricDatum, error) {
	allDimensions := arnerDimensions(t)

	timestamp, err := t.EventTime()
	if err != nil {
		return nil, err
	}

	var metricDatums []*cloudwatch.MetricDatum

	for _, dimensions := range allDimensions {
		metricDatums = append(metricDatums, &cloudwatch.MetricDatum{
			MetricName: aws.String("SecondsTranscoded"),
			Dimensions: dimensions,
			Value:      aws.Float64(float64(t.ContentLength)),
			Timestamp:  aws.Time(timestamp),
			Unit:       aws.String(cloudwatch.StandardUnitMilliseconds),
		})
	}

	return metricDatums, nil
}

func (d ContentDelivered) MetricDatum() ([]*cloudwatch.MetricDatum, error) {
	allDimensions := arnerDimensions(d)

	timestamp, err := d.EventTime()
	if err != nil {
		return nil, err
	}

	var metricDatums []*cloudwatch.MetricDatum

	for _, dimensions := range allDimensions {
		metricDatums = append(metricDatums, &cloudwatch.MetricDatum{
			MetricName: aws.String("BytesDelivered"),
			Dimensions: dimensions,
			Value:      aws.Float64(float64(d.NumBytes)),
			Timestamp:  aws.Time(timestamp),
			Unit:       aws.String(cloudwatch.StandardUnitBytes),
		}, &cloudwatch.MetricDatum{
			MetricName: aws.String("SecondsDelivered"),
			Dimensions: dimensions,
			Value:      aws.Float64(float64(d.ContentLength)),
			Timestamp:  aws.Time(timestamp),
			Unit:       aws.String(cloudwatch.StandardUnitMilliseconds),
		})
	}

	return metricDatums, nil
}
