package models

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestArnerDimensions(t *testing.T) {
	m := Metadata{
		ChannelARN: "arn:aws:starfruit:us-west-2:444469429746:channel:bob-ross-95",
	}

	allDimensions := arnerDimensions(m)
	require.Len(t, allDimensions, 3)
	require.Len(t, allDimensions[0], 0)
	require.Len(t, allDimensions[1], 1)
	require.Len(t, allDimensions[2], 2)
}
