package models

import (
	"strings"
	"time"
)

var (
	timeFormat = "2006-01-02 15:04:05.000"
)

type Metadata struct {
	EventID    string `json:"event_id"`
	Time       string `json:"event_time"`
	ChannelARN string `json:"channel_arn"`
}

func (m Metadata) EventTime() (time.Time, error) {
	return time.Parse(timeFormat, m.Time)
}

func (m Metadata) Account() string {
	parts := strings.Split(m.ChannelARN, ":")
	if len(parts) < 5 {
		return ""
	}
	return parts[4]
}

func (m Metadata) Channel() string {
	parts := strings.Split(m.ChannelARN, ":")
	if len(parts) < 7 {
		return ""
	}
	return parts[6]
}

type ContentContributed struct {
	Metadata

	BroadcastSessionID string `json:"broadcast_session_id"`

	ContentLength      int    `json:"content_length"`
	RedundantIngest    bool   `json:"redundant_ingest"`
	IngestPOP          string `json:"ingest_pop"`
	BroadcasterCountry string `json:"broadcaster_country"`
	NumBytes           int    `json:"num_bytes"`
}

type ContentTranscoded struct {
	Metadata

	BroadcastSessionID string `json:"broadcast_session_id"`

	ContentLength  int    `json:"content_length"`
	TranscoderType string `json:"transcoder_type"`
	OriginDC       string `json:"origin_dc"`
}

type ContentDelivered struct {
	Metadata
	Rendition     string `json:"rendition"`
	LatencyTier   string `json:"latency_tier"`
	EdgePoP       string `json:"edge_pop"`
	ViewerCountry string `json:"viewer_country"`
	NumBytes      int    `json:"num_bytes"`
	ContentLength int    `json:"content_length"`
}
