// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitDigestionTwirp/twirp.proto

/*
Package StarfruitDigestionTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/StarfruitDigestionTwirp/twirp.proto
*/
package StarfruitDigestionTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =====================
// DigestionV1 Interface
// =====================

// Digestion is an internal service that is responsible
// for tracking the state of live ingests. Major use cases
// include: authorizing a RTMP stream and finding where to
// connect to a live stream to start a transcode
type DigestionV1 interface {
	// Returning without error = a healthy service
	GetHealth(context.Context, *HealthRequest) (*Health, error)

	// Perform stream authorization and store a stream under the channel
	CreateStream(context.Context, *StreamAuthRequest) (*Stream, error)

	// Call TSM to create transcode
	CreateTranscode(context.Context, *CreateTranscodeRequest) (*Stream, error)

	// Get a stream by the channel and stream (i.e. "lirik", "live")
	// this has a bit of an odd-looking url pattern - Streams are uniquely identified
	// by a channel (hash key) and a stream (range key)
	GetStream(context.Context, *StreamRequest) (*Stream, error)

	// Delete a stream from the digestion DB.
	DeleteStream(context.Context, *StreamRequest) (*Stream, error)

	// Disconnect all streams for a channel at the ingest, and delete it from digestion DB
	DisconnectChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Get all streams associated with a channel
	GetChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Delete all streams associated with a channel from the digestion DB.
	DeleteChannel(context.Context, *ChannelRequest) (*Channel, error)

	// Basically a scan on the streams table
	AllStreams(context.Context, *AllStreamsRequest) (*StreamList, error)

	// Update RTMP Metadata for a given stream
	UpdateStreamMetadata(context.Context, *UpdateMetadataRequest) (*UpdateMetadataResponse, error)

	// Contacts ingest over twirp to check health of a stream
	CheckIngestHealth(context.Context, *StreamRequest) (*CheckIngestHealthResponse, error)

	UpdateRedundancySource(context.Context, *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error)

	// Puts arbitrary metadata into a stream.
	PutIngestMetadata(context.Context, *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error)

	// Re-fires the broadcast in the transcode system for a live stream tracked by digestion DB.
	RefireStream(context.Context, *RefireStreamRequest) (*Stream, error)

	// Gets refreshed SLR credentials from IOCP
	GetRecordingConfigurationWithCredentials(context.Context, *GetRecordingConfigurationWithCredentialsRequest) (*RecordingConfigurationWithCredentialsResponse, error)
}

// ===========================
// DigestionV1 Protobuf Client
// ===========================

type digestionV1ProtobufClient struct {
	client HTTPClient
	urls   [15]string
	opts   twirp.ClientOptions
}

// NewDigestionV1ProtobufClient creates a Protobuf client that implements the DigestionV1 interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewDigestionV1ProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) DigestionV1 {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + DigestionV1PathPrefix
	urls := [15]string{
		prefix + "GetHealth",
		prefix + "CreateStream",
		prefix + "CreateTranscode",
		prefix + "GetStream",
		prefix + "DeleteStream",
		prefix + "DisconnectChannel",
		prefix + "GetChannel",
		prefix + "DeleteChannel",
		prefix + "AllStreams",
		prefix + "UpdateStreamMetadata",
		prefix + "CheckIngestHealth",
		prefix + "UpdateRedundancySource",
		prefix + "PutIngestMetadata",
		prefix + "RefireStream",
		prefix + "GetRecordingConfigurationWithCredentials",
	}

	return &digestionV1ProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *digestionV1ProtobufClient) GetHealth(ctx context.Context, in *HealthRequest) (*Health, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	out := new(Health)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) CreateStream(ctx context.Context, in *StreamAuthRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	out := new(Stream)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) CreateTranscode(ctx context.Context, in *CreateTranscodeRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTranscode")
	out := new(Stream)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) GetStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	out := new(Stream)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) DeleteStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	out := new(Stream)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) DisconnectChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) GetChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) DeleteChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) AllStreams(ctx context.Context, in *AllStreamsRequest) (*StreamList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	out := new(StreamList)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) UpdateStreamMetadata(ctx context.Context, in *UpdateMetadataRequest) (*UpdateMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	out := new(UpdateMetadataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) CheckIngestHealth(ctx context.Context, in *StreamRequest) (*CheckIngestHealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	out := new(CheckIngestHealthResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) UpdateRedundancySource(ctx context.Context, in *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	out := new(UpdateRedundancySourceResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) PutIngestMetadata(ctx context.Context, in *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	out := new(PutIngestMetadataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) RefireStream(ctx context.Context, in *RefireStreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "RefireStream")
	out := new(Stream)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1ProtobufClient) GetRecordingConfigurationWithCredentials(ctx context.Context, in *GetRecordingConfigurationWithCredentialsRequest) (*RecordingConfigurationWithCredentialsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfigurationWithCredentials")
	out := new(RecordingConfigurationWithCredentialsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================
// DigestionV1 JSON Client
// =======================

type digestionV1JSONClient struct {
	client HTTPClient
	urls   [15]string
	opts   twirp.ClientOptions
}

// NewDigestionV1JSONClient creates a JSON client that implements the DigestionV1 interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewDigestionV1JSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) DigestionV1 {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + DigestionV1PathPrefix
	urls := [15]string{
		prefix + "GetHealth",
		prefix + "CreateStream",
		prefix + "CreateTranscode",
		prefix + "GetStream",
		prefix + "DeleteStream",
		prefix + "DisconnectChannel",
		prefix + "GetChannel",
		prefix + "DeleteChannel",
		prefix + "AllStreams",
		prefix + "UpdateStreamMetadata",
		prefix + "CheckIngestHealth",
		prefix + "UpdateRedundancySource",
		prefix + "PutIngestMetadata",
		prefix + "RefireStream",
		prefix + "GetRecordingConfigurationWithCredentials",
	}

	return &digestionV1JSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *digestionV1JSONClient) GetHealth(ctx context.Context, in *HealthRequest) (*Health, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	out := new(Health)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) CreateStream(ctx context.Context, in *StreamAuthRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	out := new(Stream)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) CreateTranscode(ctx context.Context, in *CreateTranscodeRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTranscode")
	out := new(Stream)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) GetStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	out := new(Stream)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) DeleteStream(ctx context.Context, in *StreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	out := new(Stream)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) DisconnectChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) GetChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) DeleteChannel(ctx context.Context, in *ChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) AllStreams(ctx context.Context, in *AllStreamsRequest) (*StreamList, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	out := new(StreamList)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) UpdateStreamMetadata(ctx context.Context, in *UpdateMetadataRequest) (*UpdateMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	out := new(UpdateMetadataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) CheckIngestHealth(ctx context.Context, in *StreamRequest) (*CheckIngestHealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	out := new(CheckIngestHealthResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) UpdateRedundancySource(ctx context.Context, in *UpdateRedundancySourceRequest) (*UpdateRedundancySourceResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	out := new(UpdateRedundancySourceResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) PutIngestMetadata(ctx context.Context, in *PutIngestMetadataRequest) (*PutIngestMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	out := new(PutIngestMetadataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) RefireStream(ctx context.Context, in *RefireStreamRequest) (*Stream, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "RefireStream")
	out := new(Stream)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *digestionV1JSONClient) GetRecordingConfigurationWithCredentials(ctx context.Context, in *GetRecordingConfigurationWithCredentialsRequest) (*RecordingConfigurationWithCredentialsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfigurationWithCredentials")
	out := new(RecordingConfigurationWithCredentialsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================
// DigestionV1 Server Handler
// ==========================

type digestionV1Server struct {
	DigestionV1
	hooks *twirp.ServerHooks
}

func NewDigestionV1Server(svc DigestionV1, hooks *twirp.ServerHooks) TwirpServer {
	return &digestionV1Server{
		DigestionV1: svc,
		hooks:       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *digestionV1Server) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// DigestionV1PathPrefix is used for all URL paths on a twirp DigestionV1 server.
// Requests are always: POST DigestionV1PathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const DigestionV1PathPrefix = "/twirp/dgn.DigestionV1/"

func (s *digestionV1Server) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "DigestionV1")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/dgn.DigestionV1/GetHealth":
		s.serveGetHealth(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/CreateStream":
		s.serveCreateStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/CreateTranscode":
		s.serveCreateTranscode(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/GetStream":
		s.serveGetStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DeleteStream":
		s.serveDeleteStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DisconnectChannel":
		s.serveDisconnectChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/GetChannel":
		s.serveGetChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/DeleteChannel":
		s.serveDeleteChannel(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/AllStreams":
		s.serveAllStreams(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/UpdateStreamMetadata":
		s.serveUpdateStreamMetadata(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/CheckIngestHealth":
		s.serveCheckIngestHealth(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/UpdateRedundancySource":
		s.serveUpdateRedundancySource(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/PutIngestMetadata":
		s.servePutIngestMetadata(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/RefireStream":
		s.serveRefireStream(ctx, resp, req)
		return
	case "/twirp/dgn.DigestionV1/GetRecordingConfigurationWithCredentials":
		s.serveGetRecordingConfigurationWithCredentials(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *digestionV1Server) serveGetHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(HealthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Health
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Health and nil error while calling GetHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(HealthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Health
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Health and nil error while calling GetHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCreateStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveCreateStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamAuthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CreateStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling CreateStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCreateStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamAuthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CreateStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling CreateStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCreateTranscode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateTranscodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateTranscodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveCreateTranscodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateTranscodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CreateTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling CreateTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCreateTranscodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateTranscodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CreateTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling CreateTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling GetStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDeleteStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DeleteStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling DeleteStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DeleteStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling DeleteStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDisconnectChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDisconnectChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDisconnectChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDisconnectChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DisconnectChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DisconnectChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDisconnectChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DisconnectChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DisconnectChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DisconnectChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveDeleteChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DeleteChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DeleteChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveDeleteChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.DeleteChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling DeleteChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveAllStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAllStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAllStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveAllStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(AllStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.AllStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamList and nil error while calling AllStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveAllStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AllStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(AllStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamList
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.AllStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamList and nil error while calling AllStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateStreamMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateStreamMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateStreamMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveUpdateStreamMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.UpdateStreamMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateMetadataResponse and nil error while calling UpdateStreamMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateStreamMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.UpdateStreamMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateMetadataResponse and nil error while calling UpdateStreamMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCheckIngestHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCheckIngestHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCheckIngestHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveCheckIngestHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CheckIngestHealthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CheckIngestHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckIngestHealthResponse and nil error while calling CheckIngestHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveCheckIngestHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CheckIngestHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CheckIngestHealthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.CheckIngestHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CheckIngestHealthResponse and nil error while calling CheckIngestHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateRedundancySource(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateRedundancySourceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateRedundancySourceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveUpdateRedundancySourceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateRedundancySourceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRedundancySourceResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.UpdateRedundancySource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRedundancySourceResponse and nil error while calling UpdateRedundancySource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveUpdateRedundancySourceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateRedundancySource")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateRedundancySourceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateRedundancySourceResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.UpdateRedundancySource(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateRedundancySourceResponse and nil error while calling UpdateRedundancySource. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) servePutIngestMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutIngestMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutIngestMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) servePutIngestMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutIngestMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutIngestMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.PutIngestMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutIngestMetadataResponse and nil error while calling PutIngestMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) servePutIngestMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutIngestMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PutIngestMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutIngestMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.PutIngestMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutIngestMetadataResponse and nil error while calling PutIngestMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveRefireStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRefireStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRefireStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveRefireStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefireStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RefireStreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.RefireStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling RefireStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveRefireStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefireStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RefireStreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Stream
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.RefireStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Stream and nil error while calling RefireStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetRecordingConfigurationWithCredentials(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecordingConfigurationWithCredentialsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecordingConfigurationWithCredentialsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *digestionV1Server) serveGetRecordingConfigurationWithCredentialsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfigurationWithCredentials")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRecordingConfigurationWithCredentialsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecordingConfigurationWithCredentialsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetRecordingConfigurationWithCredentials(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecordingConfigurationWithCredentialsResponse and nil error while calling GetRecordingConfigurationWithCredentials. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) serveGetRecordingConfigurationWithCredentialsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfigurationWithCredentials")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRecordingConfigurationWithCredentialsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecordingConfigurationWithCredentialsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.DigestionV1.GetRecordingConfigurationWithCredentials(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecordingConfigurationWithCredentialsResponse and nil error while calling GetRecordingConfigurationWithCredentials. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *digestionV1Server) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *digestionV1Server) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *digestionV1Server) PathPrefix() string {
	return DigestionV1PathPrefix
}

// ============================
// StarfruitDigestion Interface
// ============================

type StarfruitDigestion interface {
	GetPrice(context.Context, *GetPriceRequest) (*Price, error)

	UpdatePrice(context.Context, *UpdatePriceRequest) (*Price, error)
}

// ==================================
// StarfruitDigestion Protobuf Client
// ==================================

type starfruitDigestionProtobufClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewStarfruitDigestionProtobufClient creates a Protobuf client that implements the StarfruitDigestion interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStarfruitDigestionProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StarfruitDigestion {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StarfruitDigestionPathPrefix
	urls := [2]string{
		prefix + "GetPrice",
		prefix + "UpdatePrice",
	}

	return &starfruitDigestionProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *starfruitDigestionProtobufClient) GetPrice(ctx context.Context, in *GetPriceRequest) (*Price, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitDigestion")
	ctx = ctxsetters.WithMethodName(ctx, "GetPrice")
	out := new(Price)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitDigestionProtobufClient) UpdatePrice(ctx context.Context, in *UpdatePriceRequest) (*Price, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitDigestion")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePrice")
	out := new(Price)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// StarfruitDigestion JSON Client
// ==============================

type starfruitDigestionJSONClient struct {
	client HTTPClient
	urls   [2]string
	opts   twirp.ClientOptions
}

// NewStarfruitDigestionJSONClient creates a JSON client that implements the StarfruitDigestion interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStarfruitDigestionJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StarfruitDigestion {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StarfruitDigestionPathPrefix
	urls := [2]string{
		prefix + "GetPrice",
		prefix + "UpdatePrice",
	}

	return &starfruitDigestionJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *starfruitDigestionJSONClient) GetPrice(ctx context.Context, in *GetPriceRequest) (*Price, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitDigestion")
	ctx = ctxsetters.WithMethodName(ctx, "GetPrice")
	out := new(Price)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitDigestionJSONClient) UpdatePrice(ctx context.Context, in *UpdatePriceRequest) (*Price, error) {
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitDigestion")
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePrice")
	out := new(Price)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// StarfruitDigestion Server Handler
// =================================

type starfruitDigestionServer struct {
	StarfruitDigestion
	hooks *twirp.ServerHooks
}

func NewStarfruitDigestionServer(svc StarfruitDigestion, hooks *twirp.ServerHooks) TwirpServer {
	return &starfruitDigestionServer{
		StarfruitDigestion: svc,
		hooks:              hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *starfruitDigestionServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StarfruitDigestionPathPrefix is used for all URL paths on a twirp StarfruitDigestion server.
// Requests are always: POST StarfruitDigestionPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StarfruitDigestionPathPrefix = "/twirp/dgn.StarfruitDigestion/"

func (s *starfruitDigestionServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "dgn")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitDigestion")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/dgn.StarfruitDigestion/GetPrice":
		s.serveGetPrice(ctx, resp, req)
		return
	case "/twirp/dgn.StarfruitDigestion/UpdatePrice":
		s.serveUpdatePrice(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *starfruitDigestionServer) serveGetPrice(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPriceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPriceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitDigestionServer) serveGetPriceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPrice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPriceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Price
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitDigestion.GetPrice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Price and nil error while calling GetPrice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitDigestionServer) serveGetPriceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPrice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPriceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Price
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitDigestion.GetPrice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Price and nil error while calling GetPrice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitDigestionServer) serveUpdatePrice(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdatePriceJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdatePriceProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitDigestionServer) serveUpdatePriceJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePrice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdatePriceRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Price
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitDigestion.UpdatePrice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Price and nil error while calling UpdatePrice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitDigestionServer) serveUpdatePriceProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdatePrice")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdatePriceRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Price
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitDigestion.UpdatePrice(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Price and nil error while calling UpdatePrice. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitDigestionServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 1
}

func (s *starfruitDigestionServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *starfruitDigestionServer) PathPrefix() string {
	return StarfruitDigestionPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2166 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xdd, 0x76, 0xdb, 0xb8,
	0x11, 0x5e, 0xc9, 0x6b, 0x5b, 0x1a, 0x49, 0xb6, 0x8c, 0xf8, 0x87, 0x56, 0x36, 0x5e, 0x87, 0x4e,
	0x5a, 0x37, 0x9b, 0x95, 0x53, 0x27, 0xdb, 0x74, 0xbb, 0xe7, 0x6c, 0x8f, 0xff, 0xea, 0x78, 0xe3,
	0x38, 0x2a, 0xad, 0x34, 0xa7, 0x7b, 0xc3, 0x03, 0x91, 0x90, 0xcc, 0x9a, 0x22, 0x59, 0x00, 0x72,
	0x56, 0xfd, 0x79, 0x87, 0x5e, 0xf4, 0xa2, 0x77, 0x7d, 0x89, 0xde, 0xb5, 0xcf, 0xd3, 0xd7, 0x68,
	0x0f, 0x06, 0xa0, 0x44, 0xc9, 0x52, 0x62, 0x37, 0xbd, 0xd1, 0x11, 0xbe, 0x99, 0x01, 0x06, 0x83,
	0xc1, 0x37, 0x43, 0xc0, 0x73, 0x2f, 0xf6, 0x59, 0xfd, 0x77, 0x3d, 0x21, 0x83, 0xa8, 0x2e, 0xaf,
	0x76, 0x68, 0xf7, 0x0f, 0xd1, 0xce, 0xb9, 0xa4, 0xbc, 0xcd, 0x7b, 0x81, 0x3c, 0x0c, 0x3a, 0x4c,
	0xc8, 0x20, 0x8e, 0x9a, 0xef, 0x02, 0x9e, 0xec, 0x48, 0xf5, 0x5b, 0x4f, 0x78, 0x2c, 0x63, 0x32,
	0xe3, 0x77, 0xa2, 0xda, 0x46, 0x27, 0x8e, 0x3b, 0x21, 0xdb, 0x41, 0xa8, 0xd5, 0x6b, 0xef, 0xf8,
	0x3d, 0x4e, 0x95, 0xbe, 0x56, 0xaa, 0x3d, 0x19, 0x9b, 0xfd, 0x2a, 0xf0, 0x59, 0xac, 0xb5, 0xbd,
	0x38, 0x14, 0xea, 0x5f, 0x8b, 0xe9, 0x5f, 0x6d, 0x61, 0x3f, 0x81, 0xf9, 0x83, 0x0b, 0x1a, 0x45,
	0x2c, 0x24, 0x0f, 0x61, 0x5e, 0x48, 0xce, 0x68, 0x57, 0x58, 0xb9, 0xcd, 0x99, 0xed, 0xd2, 0x6e,
	0xa9, 0xee, 0x77, 0xa2, 0xfa, 0x39, 0x62, 0x4e, 0x2a, 0xb3, 0xff, 0x96, 0x87, 0x65, 0x87, 0xf9,
	0xbd, 0xc8, 0xa7, 0x91, 0xd7, 0x6f, 0xf0, 0x38, 0x61, 0x5c, 0x06, 0x4c, 0x90, 0xe7, 0x60, 0xd1,
	0x30, 0x8c, 0xdf, 0xb9, 0x6d, 0x1a, 0x84, 0xf1, 0x15, 0xe3, 0xae, 0x8c, 0xdd, 0x16, 0xf5, 0x2e,
	0x7b, 0x89, 0x95, 0xdb, 0xcc, 0x6d, 0x17, 0x9c, 0x15, 0x94, 0xff, 0xca, 0x88, 0x9b, 0xf1, 0x3e,
	0x0a, 0xc9, 0x1b, 0x58, 0xf7, 0x03, 0xe1, 0xc5, 0x51, 0xc4, 0x3c, 0xe9, 0x8a, 0x90, 0x4a, 0xe6,
	0xa6, 0x1b, 0xb3, 0xf2, 0x9b, 0xb9, 0xed, 0xd2, 0xee, 0x7a, 0x5d, 0xef, 0xbc, 0x9e, 0xee, 0xbc,
	0x7e, 0x68, 0x14, 0x9c, 0xb5, 0xa1, 0xed, 0xb9, 0x32, 0x4d, 0x05, 0xe4, 0x08, 0x4a, 0x7a, 0xae,
	0x16, 0xa7, 0x91, 0x6f, 0xcd, 0x6c, 0xe6, 0xb6, 0x17, 0x76, 0x1f, 0xe0, 0x9e, 0x26, 0xf9, 0x5f,
	0x47, 0xeb, 0x7d, 0xa5, 0xeb, 0x80, 0x18, 0xfc, 0xb7, 0x7f, 0x02, 0x30, 0x94, 0x90, 0x45, 0x28,
	0xbd, 0x7d, 0x71, 0xd2, 0x3c, 0x72, 0x4f, 0xf7, 0xf6, 0x8f, 0x4e, 0xab, 0x9f, 0x10, 0x80, 0xb9,
	0xc6, 0x1b, 0xa7, 0x71, 0x7a, 0x54, 0xcd, 0xd9, 0xdf, 0xc3, 0x42, 0x93, 0xd3, 0x48, 0xa8, 0x53,
	0x38, 0x97, 0xd4, 0xbb, 0x24, 0x0f, 0x61, 0x41, 0xa6, 0x88, 0x2b, 0xfb, 0x09, 0xc3, 0x48, 0x14,
	0x9d, 0xca, 0x00, 0x6d, 0xf6, 0x13, 0x46, 0xee, 0x43, 0x99, 0x45, 0x6a, 0xc4, 0xb5, 0x52, 0x1e,
	0x95, 0x4a, 0x06, 0x53, 0x2a, 0x36, 0x87, 0x95, 0x83, 0x9e, 0x90, 0x71, 0x97, 0xf1, 0x7d, 0x1e,
	0x53, 0xdf, 0xa3, 0x42, 0x9e, 0x44, 0xed, 0x98, 0x7c, 0x0e, 0x25, 0xaf, 0xc7, 0x39, 0x8b, 0xa4,
	0xeb, 0x79, 0x2d, 0x9c, 0x7f, 0xc6, 0x01, 0x03, 0x1d, 0x78, 0x2d, 0x72, 0x17, 0x8a, 0x61, 0xd0,
	0x0d, 0xb4, 0x38, 0x8f, 0xe2, 0x02, 0x02, 0x63, 0xc2, 0x2b, 0x0c, 0xd1, 0x50, 0x78, 0x65, 0xff,
	0xb3, 0x02, 0x73, 0xfa, 0xf8, 0x89, 0x05, 0xf3, 0x9e, 0xce, 0x13, 0xb3, 0x83, 0x74, 0x48, 0x56,
	0x61, 0xae, 0x1d, 0xf3, 0x2e, 0x95, 0xc6, 0x6b, 0x33, 0x22, 0x5b, 0x50, 0x71, 0x9a, 0xaf, 0x1a,
	0x2e, 0x8b, 0xfc, 0x24, 0x0e, 0x22, 0x89, 0xb3, 0x17, 0x9d, 0xb2, 0x02, 0x8f, 0x0c, 0x86, 0xf1,
	0x51, 0x49, 0x3e, 0xd4, 0x2a, 0x99, 0xf8, 0x28, 0x74, 0xa0, 0xf6, 0x19, 0x14, 0x05, 0x13, 0x22,
	0x88, 0xa3, 0x93, 0x43, 0x6b, 0x0e, 0x35, 0x86, 0x00, 0xd9, 0x81, 0xb9, 0x84, 0x72, 0x95, 0xb7,
	0xf3, 0x98, 0xb7, 0x6b, 0x99, 0xbc, 0xad, 0x37, 0x50, 0x72, 0x14, 0x49, 0xde, 0x77, 0x8c, 0x9a,
	0xda, 0xcc, 0x05, 0xa3, 0xa1, 0xbc, 0xe8, 0x5b, 0x05, 0x4c, 0xcc, 0x74, 0x88, 0xe1, 0xa0, 0x42,
	0xba, 0x82, 0xb1, 0xc8, 0x2a, 0x9a, 0x70, 0x50, 0x21, 0xcf, 0x19, 0x8b, 0xd4, 0x29, 0xf9, 0x2c,
	0xa4, 0x7d, 0x37, 0x64, 0x51, 0x47, 0x5e, 0x58, 0xb0, 0x99, 0xdb, 0xae, 0x38, 0x25, 0xc4, 0x4e,
	0x11, 0x22, 0xfb, 0x50, 0xe1, 0xb2, 0x9b, 0xb8, 0x5d, 0x26, 0xa9, 0x4f, 0x25, 0xb5, 0xca, 0xe8,
	0xd1, 0xbd, 0xac, 0x47, 0x8e, 0xec, 0x26, 0xaf, 0x8c, 0x5c, 0xfb, 0x55, 0xe6, 0x19, 0x88, 0xdc,
	0x03, 0x30, 0xb1, 0x75, 0x03, 0xdf, 0x5a, 0xd0, 0xbb, 0x35, 0xc8, 0x89, 0xaf, 0x5c, 0xf4, 0xc2,
	0x40, 0x1d, 0x77, 0x90, 0x58, 0x8b, 0x28, 0x2d, 0x68, 0xe0, 0x24, 0x51, 0x42, 0xf1, 0xd4, 0x6d,
	0xf5, 0xbc, 0x4b, 0x26, 0xad, 0xaa, 0x16, 0x8a, 0xa7, 0xfb, 0x38, 0x56, 0xfe, 0x8b, 0x48, 0x0c,
	0x43, 0xbd, 0xa4, 0xb3, 0x4c, 0x44, 0x62, 0x10, 0x68, 0x6d, 0x9f, 0x70, 0xd6, 0x0e, 0x7e, 0xb0,
	0x48, 0x6a, 0xdf, 0xc0, 0xb1, 0x72, 0x4c, 0x48, 0xca, 0xa5, 0x2b, 0x83, 0x2e, 0xb3, 0xee, 0x60,
	0x74, 0x8a, 0x88, 0x34, 0x83, 0x2e, 0x23, 0xeb, 0x50, 0xc0, 0xbd, 0xf7, 0x78, 0x68, 0x2d, 0xeb,
	0x1c, 0x51, 0xe3, 0x37, 0x3c, 0x24, 0x6b, 0x30, 0xef, 0xf9, 0x11, 0x4a, 0x56, 0x74, 0x92, 0x78,
	0x7e, 0xa4, 0x04, 0x9f, 0x43, 0x49, 0x31, 0x86, 0xba, 0x5f, 0x91, 0xd7, 0xb7, 0x56, 0xf1, 0x34,
	0x20, 0x8c, 0xdf, 0x9d, 0x6a, 0x84, 0x3c, 0x81, 0x65, 0x45, 0x27, 0xcc, 0x77, 0xf5, 0x11, 0xb9,
	0xde, 0x05, 0xf3, 0x2e, 0x85, 0xb5, 0x86, 0xab, 0x13, 0x2d, 0x7b, 0x81, 0xa2, 0x03, 0x94, 0x90,
	0x33, 0x58, 0xe1, 0x83, 0xeb, 0xed, 0x26, 0x83, 0xfb, 0x6d, 0x59, 0x86, 0x49, 0xa6, 0x11, 0x80,
	0xb3, 0xcc, 0x27, 0xd1, 0xda, 0x7d, 0x28, 0x1b, 0xf7, 0xdc, 0x6e, 0xec, 0x33, 0x6b, 0x5d, 0x47,
	0xcd, 0x60, 0xaf, 0x62, 0x9f, 0x91, 0x53, 0xb0, 0x32, 0x4b, 0x8a, 0xb8, 0xc7, 0x3d, 0xe6, 0x6a,
	0xbe, 0xb4, 0x6a, 0xb8, 0x2a, 0xc9, 0x52, 0x29, 0xfb, 0x7d, 0x8f, 0x09, 0xe9, 0xac, 0x0e, 0x6d,
	0xce, 0xd1, 0xc4, 0x5c, 0xb5, 0x6f, 0xa1, 0x3a, 0xe4, 0x0c, 0xa1, 0x68, 0x44, 0x58, 0x77, 0x31,
	0x8d, 0xee, 0xe0, 0x2c, 0xa3, 0x14, 0xe3, 0x2c, 0xca, 0x91, 0xb1, 0xd0, 0x84, 0xa0, 0x99, 0x42,
	0x25, 0xd0, 0x67, 0xe8, 0x2f, 0xa4, 0xd0, 0x89, 0x8f, 0x09, 0x16, 0x47, 0x12, 0x53, 0xc8, 0xb7,
	0xee, 0x99, 0x04, 0xd3, 0xc8, 0x89, 0xaf, 0xec, 0x7d, 0xde, 0x75, 0x59, 0x44, 0x5b, 0x21, 0xf3,
	0xad, 0x0d, 0x7d, 0x26, 0x3e, 0xef, 0x1e, 0x69, 0x84, 0x7c, 0x01, 0x4b, 0xb4, 0x27, 0x63, 0x41,
	0xaf, 0x98, 0x4b, 0xb9, 0x77, 0x11, 0x5c, 0x31, 0x61, 0x7d, 0x8e, 0x6a, 0xd5, 0x54, 0xb0, 0x67,
	0x70, 0xa5, 0x6c, 0x02, 0xc2, 0x99, 0x90, 0x3c, 0xf0, 0x24, 0xf3, 0xad, 0x4d, 0xad, 0xac, 0x05,
	0xce, 0x00, 0x57, 0xca, 0x09, 0x8f, 0x3d, 0x75, 0xb3, 0xa3, 0x8e, 0x1b, 0x27, 0x58, 0x01, 0xee,
	0xa3, 0x83, 0xd5, 0xa1, 0xe0, 0x35, 0xe2, 0xe4, 0x19, 0xac, 0x72, 0xe6, 0xc5, 0xdc, 0x57, 0xba,
	0x5e, 0x1c, 0xb5, 0x83, 0x8e, 0xdb, 0xea, 0x4b, 0x26, 0x2c, 0x7b, 0x33, 0xb7, 0x5d, 0x56, 0xc7,
	0x69, 0xa4, 0x07, 0x28, 0xdc, 0x57, 0x32, 0xe2, 0xc0, 0xda, 0x20, 0x3a, 0xad, 0x94, 0x48, 0xdd,
	0x20, 0x6a, 0xc7, 0xd6, 0x16, 0x1e, 0x55, 0x0d, 0x83, 0x3c, 0x91, 0x6b, 0x9d, 0x15, 0x6f, 0x22,
	0x05, 0x3f, 0x07, 0x4b, 0x5d, 0x09, 0x7f, 0x70, 0xed, 0x5d, 0x99, 0x08, 0x17, 0x69, 0xd4, 0x7a,
	0xb0, 0x99, 0xdb, 0x9e, 0x75, 0x56, 0x50, 0x9e, 0x5e, 0xf1, 0x66, 0x22, 0x4e, 0x95, 0x90, 0x7c,
	0x07, 0xf6, 0x98, 0x61, 0x42, 0xfb, 0x61, 0x4c, 0x7d, 0xbd, 0x11, 0x33, 0xc5, 0x43, 0x9c, 0x62,
	0x63, 0x64, 0x8a, 0x86, 0xd6, 0xc3, 0x3d, 0xe9, 0xb9, 0x9e, 0xc1, 0x6a, 0x27, 0x0e, 0x22, 0xd5,
	0x40, 0xb8, 0x58, 0xe1, 0x07, 0x27, 0xf8, 0x23, 0x8c, 0xf6, 0x72, 0x2a, 0x6d, 0x28, 0x61, 0x7a,
	0x96, 0x4f, 0xa1, 0xac, 0x95, 0x85, 0xa4, 0xb2, 0x27, 0xac, 0x1f, 0x63, 0x95, 0xac, 0x62, 0x0c,
	0x50, 0xf1, 0x1c, 0x71, 0xa7, 0x94, 0x0c, 0x07, 0x64, 0x1b, 0xaa, 0xda, 0x08, 0x5d, 0xd6, 0x31,
	0xdf, 0xc6, 0x98, 0x2f, 0x20, 0x7e, 0x48, 0x25, 0x45, 0xcf, 0x6a, 0x5f, 0x43, 0x29, 0x43, 0xc0,
	0xa4, 0x0a, 0x33, 0x97, 0xac, 0x6f, 0x2a, 0x88, 0xfa, 0x4b, 0x96, 0x61, 0xf6, 0x8a, 0x86, 0xbd,
	0xb4, 0xe4, 0xe9, 0xc1, 0x2f, 0xf2, 0x3f, 0xcf, 0xd5, 0x7e, 0x09, 0x4b, 0xd7, 0x98, 0xf2, 0x36,
	0x13, 0xd8, 0xff, 0xca, 0xc3, 0x92, 0xbe, 0x52, 0x7b, 0x3d, 0x79, 0x61, 0x6e, 0x1d, 0x79, 0x00,
	0x95, 0x76, 0x2f, 0x0c, 0xb5, 0xe0, 0xe5, 0x60, 0xae, 0x51, 0x50, 0xf1, 0x20, 0x16, 0xaf, 0x88,
	0x76, 0xd3, 0x99, 0x0b, 0x0a, 0x38, 0xa3, 0x5d, 0x76, 0xb3, 0xca, 0xb6, 0x05, 0x95, 0xef, 0xce,
	0x5f, 0x9f, 0x0d, 0x95, 0x3e, 0xd5, 0x4a, 0x0a, 0xcc, 0x2a, 0x1d, 0x3b, 0x8d, 0x83, 0xa1, 0xd2,
	0xac, 0x56, 0x52, 0xe0, 0x7b, 0x6a, 0xe4, 0xdc, 0xa4, 0x1a, 0x49, 0xe0, 0xd3, 0x5e, 0x2f, 0xf0,
	0xad, 0x79, 0x14, 0xe2, 0xff, 0xd1, 0x5a, 0x51, 0x18, 0xab, 0x15, 0xf7, 0x00, 0x12, 0x1e, 0xff,
	0xd0, 0x77, 0x93, 0x98, 0x4b, 0x2c, 0x76, 0x45, 0xa7, 0x88, 0x48, 0x23, 0xe6, 0xd2, 0x7e, 0x04,
	0x0b, 0xa6, 0x33, 0x4c, 0x43, 0x37, 0xb5, 0x07, 0xb0, 0x5d, 0xa8, 0x8c, 0x70, 0xdb, 0xff, 0xd0,
	0x2e, 0x8c, 0x94, 0xf8, 0x99, 0xb1, 0x12, 0x6f, 0xff, 0x19, 0x56, 0x0f, 0x38, 0xa3, 0x92, 0x0d,
	0xc8, 0x2f, 0x5d, 0xe9, 0x6b, 0x58, 0xd0, 0x4c, 0xeb, 0x72, 0x8d, 0xe0, 0x82, 0x93, 0x19, 0xb7,
	0x22, 0x46, 0x9c, 0x9c, 0x94, 0xc6, 0xf9, 0x49, 0x69, 0x6c, 0x2f, 0x42, 0x45, 0xd7, 0x18, 0x63,
	0x6a, 0x7f, 0x06, 0x73, 0x1a, 0x50, 0x61, 0x47, 0xf2, 0xd0, 0xdb, 0xc4, 0xff, 0x76, 0x13, 0x96,
	0xf6, 0xd2, 0x6c, 0x12, 0x99, 0x90, 0x08, 0xd6, 0xe9, 0xb2, 0x48, 0x9a, 0x1e, 0x2d, 0x1d, 0xe2,
	0x01, 0xc7, 0x92, 0x86, 0xae, 0x01, 0x84, 0xe9, 0xd2, 0x2a, 0x88, 0x9e, 0x1b, 0xd0, 0x7e, 0x0a,
	0xa0, 0xa7, 0x3c, 0x0d, 0x84, 0xbc, 0x69, 0xb7, 0xfe, 0xf7, 0x1c, 0xac, 0x9e, 0x33, 0xa9, 0xe1,
	0x91, 0x3d, 0x7c, 0x4c, 0xe4, 0x32, 0x0d, 0x54, 0x7e, 0xb4, 0x81, 0x9a, 0x56, 0xaf, 0x67, 0xa6,
	0xd5, 0x6b, 0x7b, 0x1d, 0xd6, 0xae, 0x39, 0x28, 0x92, 0x38, 0x12, 0xcc, 0xfe, 0x77, 0x0e, 0x56,
	0xde, 0x24, 0x3e, 0x95, 0x2c, 0x65, 0x81, 0xff, 0x83, 0xef, 0xbf, 0x1e, 0x6f, 0xd1, 0xf2, 0x18,
	0xbe, 0xc7, 0x68, 0x39, 0x71, 0xb5, 0x0f, 0x75, 0x6c, 0x1f, 0x4f, 0x55, 0x16, 0xac, 0x8e, 0xaf,
	0x6c, 0x42, 0xf0, 0x47, 0xb8, 0xa7, 0x25, 0xce, 0x58, 0xb3, 0x90, 0x6e, 0xa7, 0x0e, 0x05, 0x21,
	0x03, 0xe9, 0x5d, 0x30, 0xfe, 0x9e, 0x18, 0x0c, 0x74, 0xc8, 0x23, 0x98, 0xd3, 0x65, 0xd7, 0x7c,
	0x59, 0x4d, 0xd2, 0x36, 0x1a, 0xf6, 0x26, 0x6c, 0x4c, 0x5b, 0xdc, 0xb8, 0xf7, 0x27, 0x58, 0xc7,
	0x63, 0x3c, 0xc1, 0xca, 0x32, 0x7a, 0x7c, 0x64, 0x0b, 0xe6, 0x4c, 0x13, 0xa4, 0x1d, 0x1b, 0xc9,
	0x50, 0x23, 0x22, 0x35, 0x28, 0xe8, 0xb2, 0xf4, 0xfa, 0xa5, 0xc9, 0xa5, 0xc1, 0x98, 0x6c, 0x40,
	0x29, 0x10, 0x6e, 0x10, 0xe9, 0x6f, 0x42, 0xcc, 0xa1, 0x82, 0x53, 0x0c, 0xc4, 0x49, 0x84, 0x5f,
	0x64, 0xf6, 0x3f, 0x72, 0x60, 0x35, 0x7a, 0x52, 0x2f, 0x3e, 0x9e, 0x22, 0xd3, 0x29, 0xa8, 0x06,
	0x85, 0xcc, 0xe1, 0x23, 0x29, 0xa6, 0x63, 0xd5, 0xed, 0x99, 0x8c, 0x62, 0xbe, 0x4b, 0x53, 0x6a,
	0x2f, 0x0d, 0xb0, 0x3d, 0x49, 0x36, 0x75, 0x1b, 0x2d, 0xe3, 0x24, 0xf0, 0x54, 0x03, 0xa5, 0x89,
	0x1d, 0x44, 0x24, 0x9a, 0x0a, 0xd2, 0x0d, 0x16, 0x57, 0x1f, 0x9e, 0xba, 0x7c, 0xcf, 0xe2, 0x67,
	0x42, 0x51, 0x21, 0x58, 0xa9, 0xed, 0xbb, 0xb0, 0x3e, 0xc1, 0x6b, 0x13, 0xd1, 0xbf, 0xe4, 0xe0,
	0x8e, 0xc3, 0xda, 0x01, 0x67, 0xa3, 0x8c, 0xfa, 0x11, 0x19, 0x3f, 0xa9, 0xa1, 0xcc, 0xdf, 0xbc,
	0xa1, 0xb4, 0x13, 0xd8, 0x39, 0x66, 0xd2, 0x19, 0xed, 0xa6, 0xcc, 0x57, 0xf6, 0xdb, 0x40, 0x5e,
	0x1c, 0x70, 0xe6, 0xb3, 0x48, 0x06, 0x34, 0x14, 0x1f, 0x0e, 0xfe, 0x16, 0x54, 0x38, 0x6b, 0x73,
	0x26, 0x2e, 0x5c, 0x19, 0x5f, 0xb2, 0xc8, 0x9c, 0x40, 0xd9, 0x80, 0x4d, 0x85, 0xd9, 0x0c, 0xbe,
	0xbc, 0xe1, 0x72, 0x26, 0xd5, 0xa6, 0xf7, 0x82, 0xf9, 0xe9, 0xbd, 0xa0, 0xfd, 0x0d, 0xcc, 0x36,
	0x78, 0xe0, 0x31, 0x55, 0x7c, 0xae, 0x58, 0x87, 0x49, 0xd5, 0x13, 0x19, 0x87, 0x87, 0x80, 0xba,
	0xb7, 0x89, 0x52, 0xc3, 0xb9, 0x66, 0x1d, 0x3d, 0xb0, 0x77, 0x60, 0xf1, 0x98, 0x49, 0xb4, 0x4f,
	0x77, 0xfd, 0xde, 0x69, 0xec, 0x17, 0x40, 0xf4, 0x6d, 0xba, 0xb9, 0xcd, 0xe4, 0xa5, 0x1f, 0x7d,
	0x0b, 0xa5, 0x4c, 0x6f, 0x46, 0xd6, 0xe0, 0x4e, 0x66, 0xe8, 0xbe, 0x39, 0x7b, 0x79, 0xf6, 0xfa,
	0xed, 0x59, 0xf5, 0x13, 0x52, 0x82, 0xf9, 0xc6, 0xd1, 0xd9, 0xe1, 0xc9, 0xd9, 0x71, 0x35, 0x47,
	0x8a, 0x30, 0xeb, 0x1c, 0xed, 0x1d, 0xfe, 0xb6, 0x9a, 0xdf, 0xfd, 0xcf, 0x3c, 0x94, 0x06, 0x4f,
	0x4d, 0xbf, 0xf9, 0x29, 0x79, 0x0c, 0xc5, 0x63, 0x26, 0xd3, 0x82, 0x86, 0x39, 0x31, 0x52, 0x2a,
	0x6a, 0xa5, 0x0c, 0xa6, 0x5a, 0x46, 0x5d, 0x8b, 0xcd, 0xf7, 0xca, 0x6a, 0x26, 0x03, 0x33, 0x9d,
	0x56, 0x2d, 0x7b, 0xdd, 0xc9, 0x37, 0xb0, 0x38, 0x56, 0xc0, 0xc9, 0x5d, 0xdd, 0x68, 0x4f, 0x2c,
	0xeb, 0xa3, 0xc6, 0xda, 0x3f, 0x33, 0x98, 0x90, 0xf0, 0xa3, 0xda, 0x3b, 0x50, 0x3e, 0x64, 0x21,
	0x1b, 0xf8, 0xf7, 0x41, 0x83, 0x9f, 0xc1, 0xd2, 0xe1, 0xe0, 0x0d, 0x29, 0x7d, 0x0d, 0xd3, 0x57,
	0x63, 0xb4, 0x03, 0xaa, 0x95, 0xb3, 0x20, 0xd9, 0x01, 0x38, 0x66, 0xb7, 0x31, 0xd8, 0x85, 0x8a,
	0xf6, 0xec, 0x16, 0x36, 0x5f, 0x01, 0x0c, 0x7b, 0x09, 0x13, 0xeb, 0x6b, 0xcd, 0x45, 0x6d, 0x31,
	0xb3, 0x1f, 0x6c, 0x0f, 0x5e, 0xc3, 0xb2, 0x4e, 0x36, 0x8d, 0x0d, 0x1e, 0x17, 0x6a, 0xd3, 0xcb,
	0x5c, 0xed, 0xee, 0x44, 0x99, 0xb9, 0x61, 0xc7, 0xb0, 0x74, 0x8d, 0xe9, 0x27, 0x86, 0x76, 0xc3,
	0xb8, 0x3f, 0xad, 0x2a, 0xd0, 0xb4, 0xd6, 0x8d, 0x17, 0x15, 0x62, 0x67, 0xd6, 0x9f, 0x52, 0xee,
	0x6a, 0x5b, 0xef, 0xd5, 0x31, 0x4b, 0x38, 0xb0, 0x74, 0x8d, 0x60, 0x89, 0x7e, 0x83, 0x99, 0x56,
	0x2e, 0x8c, 0xdb, 0x53, 0x79, 0x99, 0x7c, 0x05, 0xe5, 0x2c, 0x2d, 0x13, 0xcb, 0xbc, 0x23, 0x5c,
	0x63, 0xea, 0xd1, 0xdc, 0xfa, 0x6b, 0x0e, 0xb6, 0x6f, 0x4a, 0x9e, 0xe4, 0x19, 0x5a, 0xde, 0x92,
	0x6b, 0x6b, 0xbb, 0xc6, 0x93, 0x5b, 0xf0, 0xe5, 0xee, 0x15, 0x90, 0xeb, 0x8f, 0xce, 0xe4, 0x31,
	0x14, 0x52, 0x4a, 0x23, 0xcb, 0xa9, 0x2f, 0x59, 0xb6, 0xaa, 0x81, 0xf9, 0x30, 0x54, 0x1a, 0xbb,
	0x50, 0xca, 0xf0, 0x19, 0x59, 0xcb, 0x9c, 0xcc, 0x34, 0x9b, 0xfd, 0x2f, 0xbf, 0xff, 0xe2, 0x16,
	0x0f, 0xe0, 0xad, 0x39, 0x7c, 0xee, 0x7d, 0xfa, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa9, 0x32,
	0x35, 0x8b, 0x36, 0x17, 0x00, 0x00,
}
