// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitIOCPTwirp/recording_config_api.proto

package StarfruitIOCPTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ============================
// RecordingConfigAPI Interface
// ============================

// RecordingConfigAPI handles RecordingConfig metadata
type RecordingConfigAPI interface {
	// Create a RecordingConfig, which is a persistent configuration profile for recording live streams to S3.
	CreateRecordingConfig(context.Context, *CreateRecordingConfigRequest) (*RecordingConfig, error)

	// Read a RecordingConfig’s properties.
	GetRecordingConfig(context.Context, *GetRecordingConfigRequest) (*RecordingConfig, error)

	// Delete a RecordingConfig. A warning will be raised for RecordingConfigs with channel associations
	DeleteRecordingConfig(context.Context, *DeleteRecordingConfigRequest) (*DeleteRecordingConfigResponse, error)

	// Get a paginated list of RecordingConfigSummary objects.
	ListRecordingConfigs(context.Context, *ListRecordingConfigsRequest) (*ListRecordingConfigsResponse, error)
}

// ==================================
// RecordingConfigAPI Protobuf Client
// ==================================

type recordingConfigAPIProtobufClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewRecordingConfigAPIProtobufClient creates a Protobuf client that implements the RecordingConfigAPI interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewRecordingConfigAPIProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) RecordingConfigAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + RecordingConfigAPIPathPrefix
	urls := [4]string{
		prefix + "CreateRecordingConfig",
		prefix + "GetRecordingConfig",
		prefix + "DeleteRecordingConfig",
		prefix + "ListRecordingConfigs",
	}

	return &recordingConfigAPIProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *recordingConfigAPIProtobufClient) CreateRecordingConfig(ctx context.Context, in *CreateRecordingConfigRequest) (*RecordingConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRecordingConfig")
	out := new(RecordingConfig)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *recordingConfigAPIProtobufClient) GetRecordingConfig(ctx context.Context, in *GetRecordingConfigRequest) (*RecordingConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfig")
	out := new(RecordingConfig)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *recordingConfigAPIProtobufClient) DeleteRecordingConfig(ctx context.Context, in *DeleteRecordingConfigRequest) (*DeleteRecordingConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRecordingConfig")
	out := new(DeleteRecordingConfigResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *recordingConfigAPIProtobufClient) ListRecordingConfigs(ctx context.Context, in *ListRecordingConfigsRequest) (*ListRecordingConfigsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListRecordingConfigs")
	out := new(ListRecordingConfigsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// RecordingConfigAPI JSON Client
// ==============================

type recordingConfigAPIJSONClient struct {
	client HTTPClient
	urls   [4]string
	opts   twirp.ClientOptions
}

// NewRecordingConfigAPIJSONClient creates a JSON client that implements the RecordingConfigAPI interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewRecordingConfigAPIJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) RecordingConfigAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + RecordingConfigAPIPathPrefix
	urls := [4]string{
		prefix + "CreateRecordingConfig",
		prefix + "GetRecordingConfig",
		prefix + "DeleteRecordingConfig",
		prefix + "ListRecordingConfigs",
	}

	return &recordingConfigAPIJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *recordingConfigAPIJSONClient) CreateRecordingConfig(ctx context.Context, in *CreateRecordingConfigRequest) (*RecordingConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRecordingConfig")
	out := new(RecordingConfig)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *recordingConfigAPIJSONClient) GetRecordingConfig(ctx context.Context, in *GetRecordingConfigRequest) (*RecordingConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfig")
	out := new(RecordingConfig)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *recordingConfigAPIJSONClient) DeleteRecordingConfig(ctx context.Context, in *DeleteRecordingConfigRequest) (*DeleteRecordingConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRecordingConfig")
	out := new(DeleteRecordingConfigResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *recordingConfigAPIJSONClient) ListRecordingConfigs(ctx context.Context, in *ListRecordingConfigsRequest) (*ListRecordingConfigsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListRecordingConfigs")
	out := new(ListRecordingConfigsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =================================
// RecordingConfigAPI Server Handler
// =================================

type recordingConfigAPIServer struct {
	RecordingConfigAPI
	hooks *twirp.ServerHooks
}

func NewRecordingConfigAPIServer(svc RecordingConfigAPI, hooks *twirp.ServerHooks) TwirpServer {
	return &recordingConfigAPIServer{
		RecordingConfigAPI: svc,
		hooks:              hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *recordingConfigAPIServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// RecordingConfigAPIPathPrefix is used for all URL paths on a twirp RecordingConfigAPI server.
// Requests are always: POST RecordingConfigAPIPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const RecordingConfigAPIPathPrefix = "/twirp/twitch.video.starfruitiocp.RecordingConfigAPI/"

func (s *recordingConfigAPIServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "RecordingConfigAPI")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.starfruitiocp.RecordingConfigAPI/CreateRecordingConfig":
		s.serveCreateRecordingConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.RecordingConfigAPI/GetRecordingConfig":
		s.serveGetRecordingConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.RecordingConfigAPI/DeleteRecordingConfig":
		s.serveDeleteRecordingConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.RecordingConfigAPI/ListRecordingConfigs":
		s.serveListRecordingConfigs(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *recordingConfigAPIServer) serveCreateRecordingConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateRecordingConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateRecordingConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *recordingConfigAPIServer) serveCreateRecordingConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateRecordingConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecordingConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.RecordingConfigAPI.CreateRecordingConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecordingConfig and nil error while calling CreateRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *recordingConfigAPIServer) serveCreateRecordingConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateRecordingConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecordingConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.RecordingConfigAPI.CreateRecordingConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecordingConfig and nil error while calling CreateRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *recordingConfigAPIServer) serveGetRecordingConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecordingConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecordingConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *recordingConfigAPIServer) serveGetRecordingConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRecordingConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecordingConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.RecordingConfigAPI.GetRecordingConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecordingConfig and nil error while calling GetRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *recordingConfigAPIServer) serveGetRecordingConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRecordingConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RecordingConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.RecordingConfigAPI.GetRecordingConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RecordingConfig and nil error while calling GetRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *recordingConfigAPIServer) serveDeleteRecordingConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteRecordingConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteRecordingConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *recordingConfigAPIServer) serveDeleteRecordingConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteRecordingConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteRecordingConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.RecordingConfigAPI.DeleteRecordingConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRecordingConfigResponse and nil error while calling DeleteRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *recordingConfigAPIServer) serveDeleteRecordingConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteRecordingConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteRecordingConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.RecordingConfigAPI.DeleteRecordingConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteRecordingConfigResponse and nil error while calling DeleteRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *recordingConfigAPIServer) serveListRecordingConfigs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListRecordingConfigsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListRecordingConfigsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *recordingConfigAPIServer) serveListRecordingConfigsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRecordingConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListRecordingConfigsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListRecordingConfigsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.RecordingConfigAPI.ListRecordingConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRecordingConfigsResponse and nil error while calling ListRecordingConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *recordingConfigAPIServer) serveListRecordingConfigsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRecordingConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListRecordingConfigsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListRecordingConfigsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.RecordingConfigAPI.ListRecordingConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListRecordingConfigsResponse and nil error while calling ListRecordingConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *recordingConfigAPIServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor1, 0
}

func (s *recordingConfigAPIServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *recordingConfigAPIServer) PathPrefix() string {
	return RecordingConfigAPIPathPrefix
}

var twirpFileDescriptor1 = []byte{
	// 662 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0x41, 0x4f, 0x13, 0x41,
	0x14, 0xc7, 0xdd, 0x16, 0xb0, 0x7d, 0x05, 0x29, 0x23, 0x24, 0xeb, 0x02, 0xd2, 0xf4, 0x80, 0x8d,
	0x26, 0xdb, 0x04, 0x63, 0xc4, 0x78, 0xaa, 0xa5, 0x92, 0x4d, 0x88, 0x92, 0xa5, 0x31, 0xc6, 0xcb,
	0x66, 0xd8, 0x9d, 0xd6, 0x91, 0x76, 0x67, 0x9d, 0x99, 0x02, 0xe9, 0xc1, 0x3b, 0x09, 0x1f, 0xc2,
	0xab, 0x9f, 0xc0, 0xaf, 0x67, 0x76, 0xc6, 0x25, 0x65, 0xd9, 0x5d, 0xc1, 0x70, 0x9c, 0x37, 0x6f,
	0xde, 0xfb, 0xff, 0x7f, 0x79, 0x6f, 0x17, 0x3a, 0x3e, 0x0b, 0x88, 0xfd, 0x6d, 0x22, 0x24, 0x0d,
	0x6d, 0x79, 0xda, 0xc6, 0xe3, 0x69, 0xd8, 0x3e, 0x92, 0x98, 0x0f, 0xf8, 0x84, 0x4a, 0xe7, 0x63,
	0xf7, 0xb0, 0x7f, 0x46, 0x79, 0xd4, 0xe6, 0xc4, 0x67, 0x3c, 0xa0, 0xe1, 0xd0, 0xf3, 0x59, 0x38,
	0xa0, 0x43, 0x0f, 0x47, 0xd4, 0x8e, 0x38, 0x93, 0x0c, 0x59, 0xf2, 0x8c, 0x4a, 0xff, 0xab, 0x7d,
	0x4a, 0x03, 0xc2, 0x6c, 0x91, 0xbc, 0xa5, 0xcc, 0x8f, 0xac, 0xa7, 0x43, 0xc6, 0x86, 0x23, 0xd2,
	0x56, 0x99, 0xc7, 0x93, 0x41, 0xfb, 0x8c, 0xe3, 0x28, 0x22, 0x5c, 0xe8, 0xb7, 0xd6, 0x56, 0xfa,
	0x5e, 0xd2, 0x31, 0x11, 0x12, 0x8f, 0x23, 0x9d, 0xd0, 0xfc, 0x5d, 0x82, 0x65, 0x37, 0xe9, 0xdd,
	0x55, 0xad, 0xd1, 0x16, 0xd4, 0xfc, 0x89, 0x90, 0x6c, 0x4c, 0xb8, 0x47, 0x03, 0xd3, 0x68, 0x18,
	0xad, 0xaa, 0x0b, 0x49, 0xc8, 0x09, 0x90, 0x0d, 0x8f, 0x6f, 0xe8, 0xa5, 0x81, 0x59, 0x52, 0x89,
	0x2b, 0xfc, 0x7a, 0x39, 0x27, 0x40, 0xcf, 0x60, 0x39, 0x20, 0x31, 0x01, 0x2c, 0x29, 0x0b, 0x3d,
	0xcc, 0x43, 0xb3, 0xac, 0x72, 0x1f, 0xcd, 0x84, 0x3b, 0x3c, 0x44, 0x16, 0x54, 0x42, 0xea, 0x9f,
	0x84, 0x78, 0x4c, 0xcc, 0x39, 0x95, 0x71, 0x75, 0x46, 0x6f, 0xa1, 0xe6, 0x73, 0x82, 0x25, 0xf1,
	0x62, 0x0f, 0xe6, 0x7c, 0xc3, 0x68, 0xd5, 0x76, 0x2c, 0x5b, 0x1b, 0xb4, 0x13, 0x83, 0x76, 0x3f,
	0x31, 0xe8, 0x82, 0x4e, 0x8f, 0x03, 0x68, 0x15, 0xe6, 0x85, 0xc4, 0x92, 0x98, 0x0b, 0xaa, 0xaa,
	0x3e, 0xc4, 0x25, 0x27, 0x51, 0x70, 0x55, 0xf2, 0xe1, 0xbf, 0x4b, 0xea, 0xf4, 0x38, 0xd0, 0xbc,
	0x28, 0xc1, 0x46, 0x57, 0x75, 0x48, 0xf1, 0x73, 0xc9, 0xf7, 0x09, 0x11, 0xf2, 0xfe, 0x31, 0xce,
	0xd2, 0x29, 0xa7, 0xe8, 0x64, 0x20, 0x9e, 0xcb, 0x44, 0xdc, 0x80, 0xc5, 0x01, 0x16, 0x9e, 0x64,
	0x27, 0x24, 0x8c, 0xbb, 0x69, 0x20, 0x30, 0xc0, 0xa2, 0x1f, 0x87, 0x9c, 0x00, 0xad, 0x43, 0xf5,
	0x2a, 0x43, 0x31, 0xa9, 0xba, 0x95, 0xe4, 0x3a, 0x06, 0x39, 0xa2, 0x63, 0x2a, 0xcd, 0x4a, 0xc3,
	0x68, 0x95, 0x5d, 0x7d, 0x68, 0x8e, 0xe0, 0xc9, 0x3e, 0x91, 0x39, 0x1c, 0x72, 0x6c, 0x1a, 0x79,
	0x36, 0x53, 0xdc, 0x4a, 0x69, 0x6e, 0xcd, 0x4b, 0x03, 0x36, 0xf6, 0xc8, 0x88, 0xe4, 0x92, 0xbf,
	0xef, 0x8e, 0xd7, 0x91, 0x94, 0xaf, 0x23, 0x69, 0x6e, 0xc1, 0x66, 0x8e, 0x1a, 0x11, 0xb1, 0x50,
	0x90, 0xe6, 0x14, 0xd6, 0x0f, 0xa8, 0x48, 0xe3, 0x11, 0xb7, 0x9e, 0x93, 0x75, 0xa8, 0x46, 0x78,
	0x48, 0x3c, 0x41, 0xa7, 0x44, 0x89, 0x5b, 0x72, 0x2b, 0x71, 0xe0, 0x88, 0x4e, 0x09, 0xda, 0x04,
	0x50, 0x97, 0xb3, 0xda, 0x54, 0xba, 0x16, 0xf7, 0xd3, 0x80, 0x8d, 0xec, 0xe6, 0x5a, 0x1c, 0xfa,
	0x0c, 0x2b, 0x69, 0x56, 0xc2, 0x34, 0x1a, 0xe5, 0x56, 0x6d, 0xe7, 0x85, 0x9d, 0xff, 0xe5, 0xb1,
	0xd3, 0x66, 0xeb, 0x29, 0xac, 0x02, 0x6d, 0xc3, 0x72, 0x48, 0xce, 0xa5, 0x37, 0x23, 0x4f, 0x93,
	0x5d, 0x8a, 0xc3, 0x87, 0x89, 0xc4, 0xe7, 0x5d, 0x58, 0x4d, 0x15, 0x3b, 0x52, 0xdb, 0xb9, 0x08,
	0x95, 0xae, 0xdb, 0xeb, 0xf4, 0x9d, 0x0f, 0xfb, 0xf5, 0x07, 0x68, 0x05, 0x96, 0xd4, 0xa9, 0xe7,
	0xbd, 0xef, 0x38, 0x07, 0xbd, 0xbd, 0xba, 0x81, 0x00, 0x16, 0x3a, 0xdd, 0xbe, 0xf3, 0xa9, 0x57,
	0x2f, 0xed, 0xfc, 0x9a, 0x03, 0x94, 0xaa, 0xd2, 0x39, 0x74, 0xd0, 0x0f, 0x58, 0xcb, 0xdc, 0x51,
	0xb4, 0x5b, 0xe4, 0xad, 0x68, 0xad, 0xad, 0xbb, 0x50, 0x41, 0xe7, 0x80, 0x6e, 0x2e, 0x06, 0x7a,
	0x55, 0x54, 0x22, 0x77, 0x91, 0xee, 0xd6, 0xf9, 0xd2, 0x80, 0xb5, 0xcc, 0xb1, 0x2c, 0xb6, 0x5e,
	0xb4, 0x57, 0xd6, 0x9b, 0xff, 0x78, 0xf9, 0x77, 0xcc, 0x2e, 0x0c, 0x58, 0xcd, 0x9a, 0x43, 0xf4,
	0xba, 0xa8, 0x66, 0xc1, 0xda, 0x58, 0xbb, 0x77, 0x7f, 0xa8, 0xb5, 0xbc, 0x6b, 0x7d, 0xd9, 0xbe,
	0xdd, 0x5f, 0xf9, 0x78, 0x41, 0xfd, 0x03, 0x5e, 0xfe, 0x09, 0x00, 0x00, 0xff, 0xff, 0xb6, 0x1f,
	0x87, 0x21, 0xc6, 0x07, 0x00, 0x00,
}
