// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitIOCPTwirp/stream_config_api.proto

package StarfruitIOCPTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// =========================
// StreamConfigAPI Interface
// =========================

type StreamConfigAPI interface {
	CreateStreamConfig(context.Context, *CreateStreamConfigRequest) (*StreamConfig, error)

	GetStreamConfig(context.Context, *GetStreamConfigRequest) (*StreamConfig, error)

	DeleteStreamConfig(context.Context, *DeleteStreamConfigRequest) (*DeleteStreamConfigResponse, error)

	UpdateStreamConfig(context.Context, *UpdateStreamConfigRequest) (*StreamConfig, error)

	BatchGetStreamConfig(context.Context, *BatchGetStreamConfigRequest) (*BatchGetStreamConfigResponse, error)

	ListStreamConfigs(context.Context, *ListStreamConfigsRequest) (*ListStreamConfigsResponse, error)

	ListStreamConfigsByRecordingConfig(context.Context, *ListStreamConfigsByRecordingConfigRequest) (*ListStreamConfigsByRecordingConfigResponse, error)

	ListStreamConfigsByNickname(context.Context, *ListStreamConfigsByNicknameRequest) (*ListStreamConfigsByNicknameResponse, error)
}

// ===============================
// StreamConfigAPI Protobuf Client
// ===============================

type streamConfigAPIProtobufClient struct {
	client HTTPClient
	urls   [8]string
	opts   twirp.ClientOptions
}

// NewStreamConfigAPIProtobufClient creates a Protobuf client that implements the StreamConfigAPI interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStreamConfigAPIProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StreamConfigAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StreamConfigAPIPathPrefix
	urls := [8]string{
		prefix + "CreateStreamConfig",
		prefix + "GetStreamConfig",
		prefix + "DeleteStreamConfig",
		prefix + "UpdateStreamConfig",
		prefix + "BatchGetStreamConfig",
		prefix + "ListStreamConfigs",
		prefix + "ListStreamConfigsByRecordingConfig",
		prefix + "ListStreamConfigsByNickname",
	}

	return &streamConfigAPIProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *streamConfigAPIProtobufClient) CreateStreamConfig(ctx context.Context, in *CreateStreamConfigRequest) (*StreamConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamConfig")
	out := new(StreamConfig)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIProtobufClient) GetStreamConfig(ctx context.Context, in *GetStreamConfigRequest) (*StreamConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamConfig")
	out := new(StreamConfig)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIProtobufClient) DeleteStreamConfig(ctx context.Context, in *DeleteStreamConfigRequest) (*DeleteStreamConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStreamConfig")
	out := new(DeleteStreamConfigResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIProtobufClient) UpdateStreamConfig(ctx context.Context, in *UpdateStreamConfigRequest) (*StreamConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamConfig")
	out := new(StreamConfig)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIProtobufClient) BatchGetStreamConfig(ctx context.Context, in *BatchGetStreamConfigRequest) (*BatchGetStreamConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetStreamConfig")
	out := new(BatchGetStreamConfigResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIProtobufClient) ListStreamConfigs(ctx context.Context, in *ListStreamConfigsRequest) (*ListStreamConfigsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigs")
	out := new(ListStreamConfigsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIProtobufClient) ListStreamConfigsByRecordingConfig(ctx context.Context, in *ListStreamConfigsByRecordingConfigRequest) (*ListStreamConfigsByRecordingConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByRecordingConfig")
	out := new(ListStreamConfigsByRecordingConfigResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIProtobufClient) ListStreamConfigsByNickname(ctx context.Context, in *ListStreamConfigsByNicknameRequest) (*ListStreamConfigsByNicknameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByNickname")
	out := new(ListStreamConfigsByNicknameResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===========================
// StreamConfigAPI JSON Client
// ===========================

type streamConfigAPIJSONClient struct {
	client HTTPClient
	urls   [8]string
	opts   twirp.ClientOptions
}

// NewStreamConfigAPIJSONClient creates a JSON client that implements the StreamConfigAPI interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStreamConfigAPIJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StreamConfigAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StreamConfigAPIPathPrefix
	urls := [8]string{
		prefix + "CreateStreamConfig",
		prefix + "GetStreamConfig",
		prefix + "DeleteStreamConfig",
		prefix + "UpdateStreamConfig",
		prefix + "BatchGetStreamConfig",
		prefix + "ListStreamConfigs",
		prefix + "ListStreamConfigsByRecordingConfig",
		prefix + "ListStreamConfigsByNickname",
	}

	return &streamConfigAPIJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *streamConfigAPIJSONClient) CreateStreamConfig(ctx context.Context, in *CreateStreamConfigRequest) (*StreamConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamConfig")
	out := new(StreamConfig)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIJSONClient) GetStreamConfig(ctx context.Context, in *GetStreamConfigRequest) (*StreamConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamConfig")
	out := new(StreamConfig)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIJSONClient) DeleteStreamConfig(ctx context.Context, in *DeleteStreamConfigRequest) (*DeleteStreamConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStreamConfig")
	out := new(DeleteStreamConfigResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIJSONClient) UpdateStreamConfig(ctx context.Context, in *UpdateStreamConfigRequest) (*StreamConfig, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamConfig")
	out := new(StreamConfig)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIJSONClient) BatchGetStreamConfig(ctx context.Context, in *BatchGetStreamConfigRequest) (*BatchGetStreamConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetStreamConfig")
	out := new(BatchGetStreamConfigResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIJSONClient) ListStreamConfigs(ctx context.Context, in *ListStreamConfigsRequest) (*ListStreamConfigsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigs")
	out := new(ListStreamConfigsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIJSONClient) ListStreamConfigsByRecordingConfig(ctx context.Context, in *ListStreamConfigsByRecordingConfigRequest) (*ListStreamConfigsByRecordingConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByRecordingConfig")
	out := new(ListStreamConfigsByRecordingConfigResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamConfigAPIJSONClient) ListStreamConfigsByNickname(ctx context.Context, in *ListStreamConfigsByNicknameRequest) (*ListStreamConfigsByNicknameResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByNickname")
	out := new(ListStreamConfigsByNicknameResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==============================
// StreamConfigAPI Server Handler
// ==============================

type streamConfigAPIServer struct {
	StreamConfigAPI
	hooks *twirp.ServerHooks
}

func NewStreamConfigAPIServer(svc StreamConfigAPI, hooks *twirp.ServerHooks) TwirpServer {
	return &streamConfigAPIServer{
		StreamConfigAPI: svc,
		hooks:           hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *streamConfigAPIServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StreamConfigAPIPathPrefix is used for all URL paths on a twirp StreamConfigAPI server.
// Requests are always: POST StreamConfigAPIPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StreamConfigAPIPathPrefix = "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/"

func (s *streamConfigAPIServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamConfigAPI")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/CreateStreamConfig":
		s.serveCreateStreamConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/GetStreamConfig":
		s.serveGetStreamConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/DeleteStreamConfig":
		s.serveDeleteStreamConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/UpdateStreamConfig":
		s.serveUpdateStreamConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/BatchGetStreamConfig":
		s.serveBatchGetStreamConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/ListStreamConfigs":
		s.serveListStreamConfigs(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/ListStreamConfigsByRecordingConfig":
		s.serveListStreamConfigsByRecordingConfig(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamConfigAPI/ListStreamConfigsByNickname":
		s.serveListStreamConfigsByNickname(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *streamConfigAPIServer) serveCreateStreamConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateStreamConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateStreamConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamConfigAPIServer) serveCreateStreamConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateStreamConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.CreateStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamConfig and nil error while calling CreateStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveCreateStreamConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateStreamConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.CreateStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamConfig and nil error while calling CreateStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveGetStreamConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamConfigAPIServer) serveGetStreamConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetStreamConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.GetStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamConfig and nil error while calling GetStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveGetStreamConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetStreamConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.GetStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamConfig and nil error while calling GetStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveDeleteStreamConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteStreamConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteStreamConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamConfigAPIServer) serveDeleteStreamConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteStreamConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteStreamConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.DeleteStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteStreamConfigResponse and nil error while calling DeleteStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveDeleteStreamConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteStreamConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteStreamConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.DeleteStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteStreamConfigResponse and nil error while calling DeleteStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveUpdateStreamConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateStreamConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateStreamConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamConfigAPIServer) serveUpdateStreamConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateStreamConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.UpdateStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamConfig and nil error while calling UpdateStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveUpdateStreamConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateStreamConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamConfig
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.UpdateStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamConfig and nil error while calling UpdateStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveBatchGetStreamConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBatchGetStreamConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBatchGetStreamConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamConfigAPIServer) serveBatchGetStreamConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BatchGetStreamConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchGetStreamConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.BatchGetStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchGetStreamConfigResponse and nil error while calling BatchGetStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveBatchGetStreamConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BatchGetStreamConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchGetStreamConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.BatchGetStreamConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchGetStreamConfigResponse and nil error while calling BatchGetStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveListStreamConfigs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamConfigsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamConfigsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamConfigAPIServer) serveListStreamConfigsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListStreamConfigsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamConfigsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.ListStreamConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamConfigsResponse and nil error while calling ListStreamConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveListStreamConfigsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListStreamConfigsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamConfigsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.ListStreamConfigs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamConfigsResponse and nil error while calling ListStreamConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveListStreamConfigsByRecordingConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamConfigsByRecordingConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamConfigsByRecordingConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamConfigAPIServer) serveListStreamConfigsByRecordingConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListStreamConfigsByRecordingConfigRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamConfigsByRecordingConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.ListStreamConfigsByRecordingConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamConfigsByRecordingConfigResponse and nil error while calling ListStreamConfigsByRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveListStreamConfigsByRecordingConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListStreamConfigsByRecordingConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamConfigsByRecordingConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.ListStreamConfigsByRecordingConfig(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamConfigsByRecordingConfigResponse and nil error while calling ListStreamConfigsByRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveListStreamConfigsByNickname(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamConfigsByNicknameJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamConfigsByNicknameProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamConfigAPIServer) serveListStreamConfigsByNicknameJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByNickname")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListStreamConfigsByNicknameRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamConfigsByNicknameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.ListStreamConfigsByNickname(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamConfigsByNicknameResponse and nil error while calling ListStreamConfigsByNickname. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) serveListStreamConfigsByNicknameProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByNickname")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListStreamConfigsByNicknameRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamConfigsByNicknameResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamConfigAPI.ListStreamConfigsByNickname(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamConfigsByNicknameResponse and nil error while calling ListStreamConfigsByNickname. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamConfigAPIServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor4, 0
}

func (s *streamConfigAPIServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *streamConfigAPIServer) PathPrefix() string {
	return StreamConfigAPIPathPrefix
}

var twirpFileDescriptor4 = []byte{
	// 1026 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x58, 0x3f, 0x6f, 0xdb, 0x46,
	0x14, 0x0f, 0x25, 0xdb, 0x91, 0x9e, 0x9c, 0x58, 0x3e, 0xdb, 0x01, 0x4d, 0xbb, 0x8d, 0xca, 0x02,
	0x06, 0xab, 0x81, 0x02, 0xe4, 0xa4, 0x09, 0x50, 0x20, 0x81, 0x24, 0x27, 0x85, 0x00, 0xc5, 0x16,
	0x28, 0xa7, 0x05, 0xba, 0x10, 0x14, 0x79, 0x92, 0x2e, 0x96, 0x48, 0x96, 0x77, 0x8c, 0x6b, 0x4f,
	0x05, 0x3a, 0x75, 0xef, 0xda, 0x6c, 0x05, 0x8a, 0xae, 0x5d, 0x3a, 0xf6, 0x3b, 0x74, 0xed, 0x87,
	0x29, 0x78, 0x94, 0x54, 0xfd, 0x21, 0x29, 0x29, 0xa9, 0x11, 0x14, 0xc8, 0xc8, 0xf7, 0xf7, 0x77,
	0xef, 0xfd, 0xee, 0xdd, 0x03, 0xe1, 0x89, 0xe9, 0x58, 0x58, 0x7d, 0xe5, 0x53, 0x46, 0x6c, 0x95,
	0xbd, 0x2e, 0x19, 0x83, 0x6b, 0xbb, 0xd4, 0x62, 0x86, 0xd7, 0xf1, 0x7c, 0xc2, 0xea, 0x67, 0xb5,
	0xe6, 0xf9, 0x25, 0xf1, 0xdc, 0x12, 0x65, 0x1e, 0x36, 0x06, 0xba, 0xe9, 0xd8, 0x1d, 0xd2, 0xd5,
	0x0d, 0x97, 0xa8, 0xae, 0xe7, 0x30, 0x07, 0x49, 0xec, 0x92, 0x30, 0xb3, 0xa7, 0xbe, 0x26, 0x16,
	0x76, 0x54, 0x3a, 0x72, 0x24, 0x8e, 0xe9, 0x4a, 0xf7, 0xbb, 0x8e, 0xd3, 0xed, 0xe3, 0x12, 0xb7,
	0x6c, 0xfb, 0x9d, 0x12, 0x23, 0x03, 0x4c, 0x99, 0x31, 0x70, 0x43, 0x67, 0xe9, 0xe3, 0x59, 0x83,
	0x4b, 0xcf, 0x70, 0x5d, 0xec, 0xd1, 0x50, 0x2f, 0xff, 0x9a, 0x86, 0xcd, 0x16, 0x4f, 0x5c, 0xe3,
	0x79, 0xd1, 0x7d, 0xc8, 0x99, 0x3e, 0x65, 0xce, 0x00, 0x7b, 0x3a, 0xb1, 0x44, 0xa1, 0x20, 0x28,
	0x59, 0x0d, 0x46, 0xa2, 0xba, 0x85, 0x14, 0xc8, 0x4f, 0x23, 0x25, 0x96, 0x98, 0xe2, 0x56, 0x77,
	0xe9, 0x44, 0xa0, 0xba, 0x85, 0x24, 0xc8, 0xd8, 0xc4, 0xbc, 0xb0, 0x8d, 0x01, 0x16, 0xd7, 0xb8,
	0xc5, 0xf8, 0x1b, 0x3d, 0x80, 0x7b, 0x6e, 0xdf, 0xb8, 0x6a, 0x1b, 0xe6, 0x85, 0x6e, 0xf8, 0xac,
	0xa7, 0x7b, 0xf8, 0x5b, 0x9f, 0x78, 0xd8, 0x12, 0xd7, 0x0b, 0x82, 0x92, 0xd1, 0x76, 0x47, 0xda,
	0x8a, 0xcf, 0x7a, 0xda, 0x50, 0x87, 0x54, 0xd8, 0xf1, 0xb0, 0xe9, 0x78, 0x16, 0xb1, 0xbb, 0x13,
	0xe9, 0x37, 0x78, 0xf0, 0xed, 0xb1, 0x6a, 0x8c, 0xe0, 0x11, 0x88, 0xff, 0xda, 0xd3, 0x63, 0xbd,
	0xed, 0x9b, 0x17, 0x98, 0xe9, 0x1c, 0xd1, 0x6d, 0xee, 0xb4, 0x37, 0xd6, 0xb7, 0x8e, 0xab, 0x5c,
	0x7b, 0x1a, 0xc0, 0xfb, 0x04, 0x36, 0x5d, 0x8f, 0x98, 0x81, 0xdb, 0xc0, 0xb1, 0xb0, 0x98, 0xe1,
	0xc6, 0xb9, 0xa1, 0xec, 0x85, 0x63, 0x61, 0x54, 0x86, 0xbd, 0xf1, 0x09, 0xfa, 0x06, 0xc3, 0xb6,
	0x79, 0x15, 0xda, 0x66, 0xb9, 0xed, 0xce, 0x48, 0xd9, 0x08, 0x75, 0xdc, 0xe7, 0x0b, 0xc8, 0x99,
	0x1e, 0x36, 0x18, 0xd6, 0x83, 0x3e, 0x89, 0x50, 0x10, 0x94, 0x5c, 0x59, 0x52, 0xc3, 0x1e, 0xa9,
	0xa3, 0x1e, 0xa9, 0xe7, 0xa3, 0x26, 0x6a, 0x10, 0x9a, 0x07, 0x02, 0xf9, 0xcf, 0x35, 0xd8, 0xaf,
	0xf1, 0xcf, 0xc9, 0x86, 0x05, 0xb5, 0xc1, 0x94, 0xfd, 0x97, 0x7d, 0xdb, 0x85, 0xf5, 0x3e, 0x19,
	0x10, 0x26, 0xa6, 0x0b, 0x82, 0x92, 0xd6, 0xc2, 0x0f, 0xf4, 0x78, 0xa6, 0x9b, 0xb9, 0xf2, 0xe1,
	0x1c, 0xf0, 0x16, 0xf3, 0x88, 0xdd, 0xfd, 0xca, 0xe8, 0xfb, 0x78, 0xa2, 0xd7, 0xcd, 0xc4, 0x5e,
	0x47, 0x15, 0xa0, 0xea, 0x38, 0xfd, 0x30, 0x4a, 0x34, 0x0f, 0x1a, 0xf1, 0x3c, 0x58, 0x04, 0x2b,
	0x82, 0x25, 0x2f, 0x17, 0xb0, 0x64, 0x51, 0xc8, 0x18, 0x0e, 0x3d, 0x8d, 0xe0, 0xd0, 0xa2, 0x50,
	0x53, 0x0c, 0x6b, 0x26, 0x31, 0x6c, 0x51, 0xa4, 0x28, 0xfe, 0xc9, 0x26, 0xdc, 0xfb, 0x12, 0xb3,
	0x9b, 0xa5, 0x8f, 0xfc, 0x0a, 0x0e, 0xaa, 0x06, 0x33, 0x7b, 0x6f, 0x9b, 0xa9, 0x08, 0xdb, 0xb3,
	0x99, 0xa8, 0x98, 0x2a, 0xa4, 0x95, 0xac, 0xb6, 0x35, 0x9d, 0x8a, 0xca, 0x3d, 0x40, 0xcf, 0x0d,
	0xd2, 0xc7, 0xd6, 0xd4, 0x0c, 0x8b, 0xc2, 0x2a, 0x44, 0x52, 0x5d, 0x81, 0x3c, 0x0b, 0x86, 0xaf,
	0x8e, 0x3d, 0xcf, 0xf1, 0xf4, 0x60, 0x52, 0x8f, 0x4e, 0xc5, 0xe5, 0xcf, 0x02, 0x71, 0x2d, 0x28,
	0xdd, 0x5f, 0x02, 0x1c, 0x46, 0x1f, 0x8b, 0xba, 0x8e, 0x4d, 0x31, 0x3a, 0x83, 0xbb, 0x53, 0x49,
	0xa9, 0x28, 0x14, 0xd2, 0x4a, 0xae, 0xac, 0xa8, 0xf1, 0xf3, 0x5b, 0x9d, 0x8a, 0x74, 0x67, 0x12,
	0x1c, 0x45, 0x6d, 0xd8, 0xeb, 0xf0, 0xb3, 0xe9, 0x33, 0x71, 0x53, 0x3c, 0xae, 0x9a, 0x14, 0x77,
	0xbe, 0x28, 0xda, 0x4e, 0x67, 0x4e, 0x46, 0xe5, 0x0e, 0xec, 0x9f, 0xe0, 0x3e, 0xbe, 0xe9, 0x91,
	0x22, 0x1f, 0x82, 0x14, 0x95, 0x27, 0x2c, 0x9d, 0xfc, 0xdb, 0x1a, 0xec, 0xbf, 0x74, 0xad, 0x9b,
	0x9f, 0x6c, 0x1f, 0x66, 0xd8, 0xff, 0x7f, 0x86, 0x5d, 0x82, 0xd8, 0x20, 0x74, 0xea, 0x0e, 0xd2,
	0xa5, 0xa9, 0x72, 0x00, 0x59, 0xd7, 0xe8, 0x62, 0x9d, 0x92, 0xeb, 0xf0, 0xa2, 0xaf, 0x6b, 0x99,
	0x40, 0xd0, 0x22, 0xd7, 0x18, 0x7d, 0x04, 0xc0, 0x95, 0xcc, 0xb9, 0xc0, 0x36, 0x7f, 0xfc, 0xb2,
	0x1a, 0x37, 0x3f, 0x0f, 0x04, 0xf2, 0x4f, 0x02, 0xec, 0x47, 0x64, 0xbe, 0xa9, 0xeb, 0x7f, 0x04,
	0x5b, 0x36, 0xfe, 0x8e, 0xe9, 0x13, 0x90, 0x42, 0x52, 0xdf, 0x09, 0xc4, 0xcd, 0x31, 0xac, 0x3f,
	0x04, 0xf8, 0x6c, 0x0e, 0x56, 0xf5, 0x4a, 0x9b, 0xa6, 0xc8, 0xd2, 0x15, 0x8a, 0x59, 0xb1, 0x52,
	0x71, 0x2b, 0xd6, 0x54, 0x45, 0xd3, 0x89, 0x15, 0x5d, 0x9b, 0xad, 0xe8, 0x2f, 0x02, 0x14, 0x97,
	0x81, 0xfe, 0xbe, 0x4b, 0xfc, 0xb3, 0x00, 0x72, 0x04, 0xce, 0xd3, 0xe1, 0x70, 0x58, 0xba, 0xb6,
	0x93, 0x0b, 0x71, 0x6a, 0x66, 0x21, 0x7e, 0x97, 0x3a, 0xbe, 0x11, 0xe0, 0xd3, 0x44, 0x7c, 0xef,
	0xb9, 0x80, 0xc5, 0x23, 0xc8, 0x35, 0x27, 0x86, 0xc2, 0x26, 0x64, 0x5a, 0xe7, 0x95, 0xd3, 0x93,
	0x8a, 0x76, 0x92, 0xbf, 0x85, 0xb2, 0xb0, 0x5e, 0xad, 0xb4, 0xea, 0xb5, 0xbc, 0x50, 0x2c, 0xc2,
	0x4e, 0x33, 0x62, 0x6d, 0xbe, 0x0d, 0xe9, 0xc6, 0xd9, 0xd7, 0xf9, 0x5b, 0x08, 0x60, 0xe3, 0xf4,
	0x4c, 0x7b, 0x51, 0x69, 0xe4, 0x85, 0xf2, 0xdf, 0x19, 0xd8, 0x9a, 0xc4, 0x56, 0x69, 0xd6, 0x91,
	0x0f, 0x68, 0x7e, 0x43, 0x46, 0x0f, 0x93, 0x8e, 0x17, 0xbb, 0x51, 0x4b, 0x4b, 0x57, 0x05, 0x39,
	0xb0, 0x35, 0xb3, 0x15, 0xa0, 0x72, 0x92, 0x73, 0xf4, 0x66, 0xb4, 0x42, 0xc2, 0x1f, 0x04, 0x40,
	0xf3, 0xef, 0x69, 0xf2, 0x41, 0x63, 0xdf, 0x79, 0xe9, 0xf3, 0x55, 0xdd, 0x86, 0x74, 0xf2, 0x01,
	0xcd, 0xbf, 0xda, 0xc9, 0x20, 0x62, 0x5f, 0xf9, 0x15, 0x0e, 0xff, 0xa3, 0x00, 0xbb, 0x51, 0x9b,
	0x18, 0x7a, 0x94, 0x14, 0x22, 0x61, 0x25, 0x95, 0x1e, 0xaf, 0xee, 0x38, 0x2c, 0xc1, 0xf7, 0x02,
	0x6c, 0xcf, 0xdd, 0x3c, 0xf4, 0x20, 0x29, 0x5e, 0xdc, 0xe3, 0x25, 0x3d, 0x5c, 0xd1, 0x6b, 0x08,
	0xe1, 0xf7, 0xe8, 0xe1, 0x34, 0x33, 0x44, 0xd1, 0xb3, 0x95, 0xa2, 0xc7, 0xbd, 0x1f, 0xd2, 0xf3,
	0x77, 0x0d, 0x33, 0x44, 0xfd, 0x46, 0x80, 0x83, 0x84, 0x91, 0x85, 0x9e, 0xac, 0x98, 0x67, 0x66,
	0x16, 0x4b, 0x4f, 0xdf, 0xda, 0x3f, 0x04, 0x58, 0x55, 0xbe, 0x39, 0x5a, 0xee, 0xbf, 0x4d, 0x7b,
	0x83, 0xef, 0x2e, 0xc7, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0xa4, 0x0e, 0xf7, 0xb1, 0xe8, 0x11,
	0x00, 0x00,
}
