// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitIOCPTwirp/stream_key_api.proto

package StarfruitIOCPTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ======================
// StreamKeyAPI Interface
// ======================

type StreamKeyAPI interface {
	CreateStreamKey(context.Context, *CreateStreamKeyRequest) (*StreamKey, error)

	GetStreamKey(context.Context, *GetStreamKeyRequest) (*StreamKey, error)

	DeleteStreamKey(context.Context, *DeleteStreamKeyRequest) (*DeleteStreamKeyResponse, error)

	ListStreamKeysForContent(context.Context, *ListStreamKeysForContentRequest) (*ListStreamKeysForContentResponse, error)

	BatchGetStreamKey(context.Context, *BatchGetStreamKeyRequest) (*BatchGetStreamKeyResponse, error)
}

// ============================
// StreamKeyAPI Protobuf Client
// ============================

type streamKeyAPIProtobufClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewStreamKeyAPIProtobufClient creates a Protobuf client that implements the StreamKeyAPI interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStreamKeyAPIProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StreamKeyAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StreamKeyAPIPathPrefix
	urls := [5]string{
		prefix + "CreateStreamKey",
		prefix + "GetStreamKey",
		prefix + "DeleteStreamKey",
		prefix + "ListStreamKeysForContent",
		prefix + "BatchGetStreamKey",
	}

	return &streamKeyAPIProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *streamKeyAPIProtobufClient) CreateStreamKey(ctx context.Context, in *CreateStreamKeyRequest) (*StreamKey, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamKey")
	out := new(StreamKey)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamKeyAPIProtobufClient) GetStreamKey(ctx context.Context, in *GetStreamKeyRequest) (*StreamKey, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamKey")
	out := new(StreamKey)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamKeyAPIProtobufClient) DeleteStreamKey(ctx context.Context, in *DeleteStreamKeyRequest) (*DeleteStreamKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStreamKey")
	out := new(DeleteStreamKeyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamKeyAPIProtobufClient) ListStreamKeysForContent(ctx context.Context, in *ListStreamKeysForContentRequest) (*ListStreamKeysForContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamKeysForContent")
	out := new(ListStreamKeysForContentResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamKeyAPIProtobufClient) BatchGetStreamKey(ctx context.Context, in *BatchGetStreamKeyRequest) (*BatchGetStreamKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetStreamKey")
	out := new(BatchGetStreamKeyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ========================
// StreamKeyAPI JSON Client
// ========================

type streamKeyAPIJSONClient struct {
	client HTTPClient
	urls   [5]string
	opts   twirp.ClientOptions
}

// NewStreamKeyAPIJSONClient creates a JSON client that implements the StreamKeyAPI interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStreamKeyAPIJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StreamKeyAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StreamKeyAPIPathPrefix
	urls := [5]string{
		prefix + "CreateStreamKey",
		prefix + "GetStreamKey",
		prefix + "DeleteStreamKey",
		prefix + "ListStreamKeysForContent",
		prefix + "BatchGetStreamKey",
	}

	return &streamKeyAPIJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *streamKeyAPIJSONClient) CreateStreamKey(ctx context.Context, in *CreateStreamKeyRequest) (*StreamKey, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamKey")
	out := new(StreamKey)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamKeyAPIJSONClient) GetStreamKey(ctx context.Context, in *GetStreamKeyRequest) (*StreamKey, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamKey")
	out := new(StreamKey)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamKeyAPIJSONClient) DeleteStreamKey(ctx context.Context, in *DeleteStreamKeyRequest) (*DeleteStreamKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStreamKey")
	out := new(DeleteStreamKeyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamKeyAPIJSONClient) ListStreamKeysForContent(ctx context.Context, in *ListStreamKeysForContentRequest) (*ListStreamKeysForContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamKeysForContent")
	out := new(ListStreamKeysForContentResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamKeyAPIJSONClient) BatchGetStreamKey(ctx context.Context, in *BatchGetStreamKeyRequest) (*BatchGetStreamKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetStreamKey")
	out := new(BatchGetStreamKeyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===========================
// StreamKeyAPI Server Handler
// ===========================

type streamKeyAPIServer struct {
	StreamKeyAPI
	hooks *twirp.ServerHooks
}

func NewStreamKeyAPIServer(svc StreamKeyAPI, hooks *twirp.ServerHooks) TwirpServer {
	return &streamKeyAPIServer{
		StreamKeyAPI: svc,
		hooks:        hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *streamKeyAPIServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StreamKeyAPIPathPrefix is used for all URL paths on a twirp StreamKeyAPI server.
// Requests are always: POST StreamKeyAPIPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StreamKeyAPIPathPrefix = "/twirp/twitch.video.starfruitiocp.StreamKeyAPI/"

func (s *streamKeyAPIServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAPI")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.starfruitiocp.StreamKeyAPI/CreateStreamKey":
		s.serveCreateStreamKey(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamKeyAPI/GetStreamKey":
		s.serveGetStreamKey(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamKeyAPI/DeleteStreamKey":
		s.serveDeleteStreamKey(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamKeyAPI/ListStreamKeysForContent":
		s.serveListStreamKeysForContent(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamKeyAPI/BatchGetStreamKey":
		s.serveBatchGetStreamKey(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *streamKeyAPIServer) serveCreateStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamKeyAPIServer) serveCreateStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateStreamKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamKey
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.CreateStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamKey and nil error while calling CreateStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveCreateStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamKey
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.CreateStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamKey and nil error while calling CreateStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveGetStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamKeyAPIServer) serveGetStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetStreamKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamKey
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.GetStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamKey and nil error while calling GetStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveGetStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamKey
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.GetStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamKey and nil error while calling GetStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveDeleteStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamKeyAPIServer) serveDeleteStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteStreamKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteStreamKeyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.DeleteStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteStreamKeyResponse and nil error while calling DeleteStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveDeleteStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *DeleteStreamKeyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.DeleteStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteStreamKeyResponse and nil error while calling DeleteStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveListStreamKeysForContent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamKeysForContentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamKeysForContentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamKeyAPIServer) serveListStreamKeysForContentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamKeysForContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListStreamKeysForContentRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamKeysForContentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.ListStreamKeysForContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamKeysForContentResponse and nil error while calling ListStreamKeysForContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveListStreamKeysForContentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamKeysForContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListStreamKeysForContentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamKeysForContentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.ListStreamKeysForContent(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamKeysForContentResponse and nil error while calling ListStreamKeysForContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveBatchGetStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveBatchGetStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveBatchGetStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamKeyAPIServer) serveBatchGetStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BatchGetStreamKeyRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchGetStreamKeyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.BatchGetStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchGetStreamKeyResponse and nil error while calling BatchGetStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) serveBatchGetStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "BatchGetStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(BatchGetStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *BatchGetStreamKeyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAPI.BatchGetStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BatchGetStreamKeyResponse and nil error while calling BatchGetStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAPIServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor5, 0
}

func (s *streamKeyAPIServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *streamKeyAPIServer) PathPrefix() string {
	return StreamKeyAPIPathPrefix
}

var twirpFileDescriptor5 = []byte{
	// 519 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xdf, 0x6b, 0xd3, 0x50,
	0x14, 0x26, 0xcd, 0x1c, 0xf4, 0x74, 0xac, 0xdb, 0x55, 0x6a, 0x16, 0x90, 0x95, 0x80, 0x12, 0x10,
	0x52, 0xe8, 0xf4, 0x69, 0xbe, 0xb8, 0x6a, 0x25, 0x4c, 0x71, 0x64, 0x82, 0xe0, 0x4b, 0x88, 0xb9,
	0xa7, 0xec, 0xce, 0x36, 0x37, 0xde, 0x7b, 0xbb, 0xb1, 0x3d, 0x88, 0xff, 0x84, 0xff, 0x8d, 0xff,
	0x99, 0x2f, 0x92, 0x1f, 0x6d, 0x5d, 0x9a, 0x64, 0x9d, 0xeb, 0x5b, 0xee, 0x39, 0x9c, 0xf3, 0x7d,
	0xdf, 0x39, 0xe7, 0x23, 0x70, 0x18, 0x72, 0x8a, 0xce, 0xf9, 0x54, 0x2a, 0x16, 0x39, 0xea, 0xa2,
	0x17, 0x4c, 0xae, 0xa3, 0xde, 0xa9, 0x0a, 0xc4, 0x48, 0x4c, 0x99, 0x72, 0x3f, 0x0e, 0x4e, 0x3e,
	0x5d, 0x32, 0x11, 0xf7, 0xa4, 0x12, 0x18, 0x4c, 0xfc, 0x6f, 0x78, 0xe5, 0x07, 0x31, 0x73, 0x62,
	0xc1, 0x15, 0x27, 0xa6, 0xba, 0x64, 0x2a, 0x3c, 0x73, 0x2e, 0x18, 0x45, 0xee, 0xc8, 0x59, 0x15,
	0xe3, 0x61, 0x6c, 0x49, 0x68, 0x9e, 0xa6, 0x35, 0xc7, 0x78, 0x45, 0xb6, 0xa1, 0xc1, 0xa8, 0xa1,
	0x75, 0x35, 0xbb, 0xe9, 0x35, 0x18, 0x25, 0xfb, 0xd0, 0x0a, 0xa7, 0x52, 0xf1, 0x09, 0x0a, 0x9f,
	0x51, 0xa3, 0x91, 0x26, 0x60, 0x16, 0x72, 0x29, 0x79, 0x02, 0x10, 0xf2, 0x48, 0x61, 0xa4, 0x92,
	0xbc, 0x9e, 0xe6, 0x9b, 0x79, 0xc4, 0xa5, 0xa4, 0x03, 0x9b, 0x12, 0x43, 0x81, 0xca, 0xd8, 0x48,
	0x53, 0xf9, 0xcb, 0xfa, 0x01, 0x9d, 0x81, 0xc0, 0x40, 0xe1, 0x1c, 0xda, 0xc3, 0xef, 0x53, 0x94,
	0x6a, 0xed, 0x0c, 0x1e, 0xc1, 0x83, 0x31, 0x9b, 0xb0, 0x8c, 0x80, 0xee, 0x65, 0x0f, 0x6b, 0x08,
	0x0f, 0xdf, 0xa1, 0xba, 0x37, 0xb8, 0xe5, 0x42, 0xe7, 0x0d, 0x8e, 0x71, 0x0d, 0x3a, 0xac, 0x3d,
	0x78, 0xbc, 0xd4, 0x4a, 0xc6, 0x3c, 0x92, 0x68, 0x05, 0xb0, 0xff, 0x9e, 0xc9, 0x05, 0x5d, 0x39,
	0xe4, 0x62, 0x90, 0x29, 0x9c, 0xc1, 0xdd, 0x9c, 0x82, 0x56, 0x9c, 0xc2, 0xad, 0xe8, 0xe7, 0xd0,
	0xad, 0x86, 0xc8, 0x68, 0x90, 0x21, 0xb4, 0x16, 0xd7, 0x25, 0x0d, 0xad, 0xab, 0xdb, 0xad, 0xfe,
	0x53, 0xa7, 0xfa, 0xb6, 0x9c, 0x85, 0x14, 0x90, 0xf3, 0xce, 0xd6, 0x07, 0x30, 0x8e, 0x02, 0x15,
	0x9e, 0x95, 0x6d, 0xa0, 0x40, 0x54, 0x5b, 0x5a, 0xf7, 0x0e, 0xe8, 0x8c, 0x4a, 0xa3, 0xd1, 0xd5,
	0xed, 0xa6, 0x97, 0x7c, 0x5a, 0xc7, 0xd0, 0x1e, 0x06, 0x6c, 0x8c, 0xb4, 0xfa, 0x8c, 0x6d, 0xd8,
	0x51, 0x89, 0x3b, 0x7c, 0x14, 0x82, 0x0b, 0x3f, 0xb1, 0x52, 0x3e, 0x83, 0xed, 0x34, 0xfe, 0x36,
	0x09, 0x0f, 0x38, 0x45, 0xeb, 0xb7, 0x06, 0x7b, 0x25, 0xe4, 0xd6, 0x3b, 0x01, 0xf2, 0x19, 0x76,
	0x47, 0x29, 0x65, 0x7f, 0xd1, 0x2e, 0x95, 0xd4, 0xea, 0x3f, 0xaf, 0xeb, 0x56, 0xd0, 0xe9, 0xb5,
	0x47, 0x37, 0x03, 0xfd, 0x3f, 0x1b, 0xb0, 0x35, 0x7f, 0xbd, 0x3e, 0x71, 0xc9, 0x18, 0xda, 0x05,
	0xa3, 0x91, 0x7e, 0x1d, 0x42, 0xb9, 0x2b, 0xcd, 0xd5, 0x34, 0x92, 0x11, 0x6c, 0xfd, 0x3b, 0x37,
	0xd2, 0xab, 0x2b, 0x2b, 0x59, 0xff, 0xaa, 0x38, 0xd7, 0xd0, 0x2e, 0x78, 0xa5, 0x5e, 0x55, 0xb9,
	0x47, 0xcd, 0x83, 0x3b, 0xd5, 0xe4, 0x37, 0xf0, 0x4b, 0x03, 0xa3, 0xca, 0x2a, 0xe4, 0xb0, 0xae,
	0xe3, 0x2d, 0x1e, 0x36, 0x5f, 0xfd, 0x5f, 0x71, 0xce, 0xeb, 0xa7, 0x06, 0xbb, 0x4b, 0x97, 0x4b,
	0x5e, 0xd4, 0xf5, 0xac, 0x72, 0xa1, 0xf9, 0xf2, 0x8e, 0x55, 0x19, 0x85, 0x23, 0xfb, 0xcb, 0xb3,
	0xd5, 0xfe, 0x52, 0x5f, 0x37, 0xd3, 0xff, 0xd2, 0xc1, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb4,
	0xa7, 0x57, 0x97, 0xd6, 0x06, 0x00, 0x00,
}
