// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitIOCPTwirp/stream_key_auth_api.proto

package StarfruitIOCPTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ==========================
// StreamKeyAuthAPI Interface
// ==========================

type StreamKeyAuthAPI interface {
	AuthenticateStreamKey(context.Context, *StreamKeyAuthRequest) (*StreamKeyAuthResponse, error)
}

// ================================
// StreamKeyAuthAPI Protobuf Client
// ================================

type streamKeyAuthAPIProtobufClient struct {
	client HTTPClient
	urls   [1]string
	opts   twirp.ClientOptions
}

// NewStreamKeyAuthAPIProtobufClient creates a Protobuf client that implements the StreamKeyAuthAPI interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStreamKeyAuthAPIProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StreamKeyAuthAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StreamKeyAuthAPIPathPrefix
	urls := [1]string{
		prefix + "AuthenticateStreamKey",
	}

	return &streamKeyAuthAPIProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *streamKeyAuthAPIProtobufClient) AuthenticateStreamKey(ctx context.Context, in *StreamKeyAuthRequest) (*StreamKeyAuthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAuthAPI")
	ctx = ctxsetters.WithMethodName(ctx, "AuthenticateStreamKey")
	out := new(StreamKeyAuthResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// StreamKeyAuthAPI JSON Client
// ============================

type streamKeyAuthAPIJSONClient struct {
	client HTTPClient
	urls   [1]string
	opts   twirp.ClientOptions
}

// NewStreamKeyAuthAPIJSONClient creates a JSON client that implements the StreamKeyAuthAPI interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStreamKeyAuthAPIJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StreamKeyAuthAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StreamKeyAuthAPIPathPrefix
	urls := [1]string{
		prefix + "AuthenticateStreamKey",
	}

	return &streamKeyAuthAPIJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *streamKeyAuthAPIJSONClient) AuthenticateStreamKey(ctx context.Context, in *StreamKeyAuthRequest) (*StreamKeyAuthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAuthAPI")
	ctx = ctxsetters.WithMethodName(ctx, "AuthenticateStreamKey")
	out := new(StreamKeyAuthResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===============================
// StreamKeyAuthAPI Server Handler
// ===============================

type streamKeyAuthAPIServer struct {
	StreamKeyAuthAPI
	hooks *twirp.ServerHooks
}

func NewStreamKeyAuthAPIServer(svc StreamKeyAuthAPI, hooks *twirp.ServerHooks) TwirpServer {
	return &streamKeyAuthAPIServer{
		StreamKeyAuthAPI: svc,
		hooks:            hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *streamKeyAuthAPIServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StreamKeyAuthAPIPathPrefix is used for all URL paths on a twirp StreamKeyAuthAPI server.
// Requests are always: POST StreamKeyAuthAPIPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StreamKeyAuthAPIPathPrefix = "/twirp/twitch.video.starfruitiocp.StreamKeyAuthAPI/"

func (s *streamKeyAuthAPIServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamKeyAuthAPI")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.starfruitiocp.StreamKeyAuthAPI/AuthenticateStreamKey":
		s.serveAuthenticateStreamKey(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *streamKeyAuthAPIServer) serveAuthenticateStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAuthenticateStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAuthenticateStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamKeyAuthAPIServer) serveAuthenticateStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AuthenticateStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamKeyAuthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamKeyAuthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAuthAPI.AuthenticateStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamKeyAuthResponse and nil error while calling AuthenticateStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAuthAPIServer) serveAuthenticateStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AuthenticateStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(StreamKeyAuthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *StreamKeyAuthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamKeyAuthAPI.AuthenticateStreamKey(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamKeyAuthResponse and nil error while calling AuthenticateStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamKeyAuthAPIServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor6, 0
}

func (s *streamKeyAuthAPIServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *streamKeyAuthAPIServer) PathPrefix() string {
	return StreamKeyAuthAPIPathPrefix
}

var twirpFileDescriptor6 = []byte{
	// 498 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0x5d, 0x6f, 0xd3, 0x30,
	0x14, 0x55, 0x36, 0xf6, 0x65, 0xc6, 0x54, 0x85, 0x75, 0x44, 0x45, 0x42, 0x55, 0x1f, 0x50, 0x84,
	0x50, 0x0a, 0x2b, 0x12, 0x6f, 0x88, 0x36, 0x4f, 0x83, 0x55, 0x54, 0x69, 0xc5, 0x03, 0x2f, 0x96,
	0xe3, 0xdc, 0xad, 0xa6, 0x8d, 0x1d, 0xec, 0x9b, 0x4c, 0x41, 0xfc, 0x08, 0xfe, 0x02, 0x7f, 0x84,
	0xdf, 0x86, 0xe2, 0xb4, 0x63, 0xe9, 0xc4, 0xc7, 0xde, 0x72, 0x73, 0xee, 0x39, 0x3e, 0xc7, 0xbe,
	0x97, 0xbc, 0xe5, 0x2a, 0x81, 0xe0, 0x73, 0x6e, 0x50, 0xc8, 0x00, 0x8b, 0x3e, 0x4b, 0xbf, 0xca,
	0xfe, 0x14, 0x99, 0xbe, 0xd0, 0xb9, 0xc0, 0xb3, 0x0f, 0xe1, 0x64, 0x76, 0x25, 0x74, 0xd6, 0x37,
	0xa8, 0x81, 0xa5, 0x74, 0x01, 0x25, 0x65, 0x39, 0xce, 0x29, 0xcb, 0x44, 0x90, 0x69, 0x85, 0xca,
	0xed, 0xe0, 0x95, 0x40, 0x3e, 0x0f, 0x0a, 0x91, 0x80, 0x0a, 0xcc, 0x9a, 0x2a, 0x14, 0xcf, 0x3a,
	0x6f, 0xee, 0xa6, 0xce, 0x95, 0xbc, 0x10, 0x97, 0xbf, 0xb5, 0x7b, 0x03, 0x72, 0x3c, 0xb5, 0xd0,
	0x7b, 0x28, 0x87, 0x39, 0xce, 0x23, 0xf8, 0x92, 0x83, 0x41, 0xf7, 0x31, 0x39, 0xa8, 0x9c, 0x14,
	0x6c, 0x99, 0x83, 0xe7, 0x74, 0x1d, 0xff, 0x20, 0xda, 0x5f, 0x40, 0xf9, 0xb1, 0xaa, 0x7b, 0x3f,
	0xb7, 0x49, 0x7b, 0x83, 0x65, 0x32, 0x25, 0x0d, 0xb8, 0x63, 0xf2, 0xa0, 0x71, 0x92, 0xa5, 0xde,
	0x3f, 0xf5, 0x83, 0x3f, 0x47, 0x08, 0x6a, 0xa5, 0xd0, 0xf6, 0x47, 0x87, 0xe6, 0x46, 0xe5, 0x3e,
	0x22, 0x7b, 0xf6, 0x3e, 0xb4, 0xf4, 0xb6, 0xac, 0x87, 0xdd, 0x05, 0x94, 0x43, 0x2d, 0xdd, 0x57,
	0xe4, 0x44, 0x03, 0x57, 0x3a, 0x11, 0xf2, 0x72, 0x1d, 0x2a, 0x2e, 0x11, 0x8c, 0xb7, 0xdd, 0x75,
	0xfc, 0xc3, 0xe8, 0xf8, 0x1a, 0xad, 0x95, 0x46, 0x15, 0xe6, 0xce, 0x48, 0x8b, 0xf3, 0x98, 0x2e,
	0x45, 0x2a, 0x90, 0x1a, 0x64, 0x98, 0x1b, 0xef, 0x9e, 0x35, 0xf8, 0xec, 0x6f, 0x06, 0xc3, 0x70,
	0x74, 0x5e, 0x51, 0xa6, 0x96, 0x11, 0x1d, 0x71, 0x1e, 0xdf, 0xa8, 0xdd, 0xe7, 0xc4, 0xe5, 0xb9,
	0x41, 0x95, 0x82, 0xa6, 0x9c, 0x17, 0xb5, 0xbc, 0xb7, 0xd3, 0x75, 0xfc, 0xed, 0xa8, 0xb5, 0x46,
	0x42, 0x5e, 0x58, 0x8e, 0xfb, 0x9a, 0x78, 0x28, 0x52, 0x48, 0x68, 0x0a, 0xc8, 0x12, 0x86, 0x8c,
	0x62, 0x66, 0x56, 0x9c, 0xdd, 0xae, 0xe3, 0xef, 0x44, 0x6d, 0x8b, 0x8f, 0x57, 0xf0, 0x2c, 0x33,
	0x35, 0xf1, 0x1d, 0xe9, 0x6d, 0x10, 0x33, 0x56, 0x2e, 0x15, 0x4b, 0xea, 0xe0, 0x2b, 0x89, 0x3d,
	0x2b, 0xf1, 0xa4, 0x21, 0x31, 0xa9, 0xfb, 0xec, 0x1d, 0x58, 0xad, 0xde, 0x0f, 0x87, 0x1c, 0x35,
	0x53, 0x6d, 0xa4, 0x88, 0x29, 0x57, 0xb9, 0x44, 0xfb, 0x7c, 0x8d, 0x14, 0x71, 0x58, 0xfd, 0xbf,
	0xd5, 0x5d, 0x1f, 0xbe, 0x75, 0xab, 0xbb, 0xb6, 0x3e, 0x20, 0x27, 0x7c, 0xce, 0xa4, 0x84, 0x25,
	0x4d, 0x99, 0x5e, 0x40, 0x42, 0x59, 0xe5, 0xb7, 0x00, 0xfb, 0x5a, 0xfb, 0xd1, 0xc3, 0x15, 0x3a,
	0xb6, 0xe0, 0xd0, 0x9c, 0x8b, 0x02, 0x4e, 0xbf, 0x3b, 0xa4, 0xd5, 0x18, 0xb2, 0xe1, 0xe4, 0xcc,
	0xfd, 0x46, 0xda, 0xd5, 0x27, 0x48, 0x14, 0x9c, 0x21, 0x5c, 0xe3, 0xee, 0x8b, 0x7f, 0x4f, 0x58,
	0x73, 0xc2, 0x3b, 0x2f, 0xef, 0xc0, 0xa8, 0xa7, 0x7b, 0xe4, 0x7f, 0x7a, 0xfa, 0x7f, 0xeb, 0x16,
	0xef, 0xda, 0xed, 0x1a, 0xfc, 0x0a, 0x00, 0x00, 0xff, 0xff, 0x8b, 0xbf, 0xad, 0x66, 0xfd, 0x03,
	0x00, 0x00,
}
