// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitIOCPTwirp/stream_management_api.proto

package StarfruitIOCPTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import twitch_video_starfruitsec "code.justin.tv/amzn/StarfruitSECTwirp"

// =============================
// StreamManagementAPI Interface
// =============================

type StreamManagementAPI interface {
	KillStream(context.Context, *KillStreamRequest) (*KillStreamResponse, error)

	PutTimedMetadata(context.Context, *PutTimedMetadataRequest) (*PutTimedMetadataResponse, error)

	GetChannelState(context.Context, *twitch_video_starfruitsec.GetChannelStateRequest) (*twitch_video_starfruitsec.GetChannelStateResponse, error)

	ListActiveChannels(context.Context, *twitch_video_starfruitsec.ListActiveChannelsRequest) (*twitch_video_starfruitsec.ListActiveChannelsResponse, error)

	GetStreamDetails(context.Context, *twitch_video_starfruitsec.GetStreamDetailsRequest) (*twitch_video_starfruitsec.GetStreamDetailsResponse, error)

	ListStreamDetails(context.Context, *twitch_video_starfruitsec.ListStreamDetailsRequest) (*twitch_video_starfruitsec.ListStreamDetailsResponse, error)

	ListStreamEvents(context.Context, *twitch_video_starfruitsec.ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error)

	ListLimitBreachEvents(context.Context, *twitch_video_starfruitsec.ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error)

	CountActiveChannels(context.Context, *twitch_video_starfruitsec.CountActiveChannelsRequest) (*twitch_video_starfruitsec.CountActiveChannelsResponse, error)

	ScanCCBCount(context.Context, *twitch_video_starfruitsec.ScanCCBCountRequest) (*twitch_video_starfruitsec.ScanCCBCountResponse, error)

	ScanActiveStreams(context.Context, *twitch_video_starfruitsec.ScanActiveStreamsRequest) (*twitch_video_starfruitsec.ScanActiveStreamsResponse, error)
}

// ===================================
// StreamManagementAPI Protobuf Client
// ===================================

type streamManagementAPIProtobufClient struct {
	client HTTPClient
	urls   [11]string
	opts   twirp.ClientOptions
}

// NewStreamManagementAPIProtobufClient creates a Protobuf client that implements the StreamManagementAPI interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStreamManagementAPIProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StreamManagementAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StreamManagementAPIPathPrefix
	urls := [11]string{
		prefix + "KillStream",
		prefix + "PutTimedMetadata",
		prefix + "GetChannelState",
		prefix + "ListActiveChannels",
		prefix + "GetStreamDetails",
		prefix + "ListStreamDetails",
		prefix + "ListStreamEvents",
		prefix + "ListLimitBreachEvents",
		prefix + "CountActiveChannels",
		prefix + "ScanCCBCount",
		prefix + "ScanActiveStreams",
	}

	return &streamManagementAPIProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *streamManagementAPIProtobufClient) KillStream(ctx context.Context, in *KillStreamRequest) (*KillStreamResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "KillStream")
	out := new(KillStreamResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) PutTimedMetadata(ctx context.Context, in *PutTimedMetadataRequest) (*PutTimedMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "PutTimedMetadata")
	out := new(PutTimedMetadataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) GetChannelState(ctx context.Context, in *twitch_video_starfruitsec.GetChannelStateRequest) (*twitch_video_starfruitsec.GetChannelStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelState")
	out := new(twitch_video_starfruitsec.GetChannelStateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) ListActiveChannels(ctx context.Context, in *twitch_video_starfruitsec.ListActiveChannelsRequest) (*twitch_video_starfruitsec.ListActiveChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveChannels")
	out := new(twitch_video_starfruitsec.ListActiveChannelsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) GetStreamDetails(ctx context.Context, in *twitch_video_starfruitsec.GetStreamDetailsRequest) (*twitch_video_starfruitsec.GetStreamDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamDetails")
	out := new(twitch_video_starfruitsec.GetStreamDetailsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) ListStreamDetails(ctx context.Context, in *twitch_video_starfruitsec.ListStreamDetailsRequest) (*twitch_video_starfruitsec.ListStreamDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamDetails")
	out := new(twitch_video_starfruitsec.ListStreamDetailsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) ListStreamEvents(ctx context.Context, in *twitch_video_starfruitsec.ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	out := new(twitch_video_starfruitsec.ListStreamEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) ListLimitBreachEvents(ctx context.Context, in *twitch_video_starfruitsec.ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	out := new(twitch_video_starfruitsec.ListLimitBreachEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) CountActiveChannels(ctx context.Context, in *twitch_video_starfruitsec.CountActiveChannelsRequest) (*twitch_video_starfruitsec.CountActiveChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CountActiveChannels")
	out := new(twitch_video_starfruitsec.CountActiveChannelsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) ScanCCBCount(ctx context.Context, in *twitch_video_starfruitsec.ScanCCBCountRequest) (*twitch_video_starfruitsec.ScanCCBCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ScanCCBCount")
	out := new(twitch_video_starfruitsec.ScanCCBCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIProtobufClient) ScanActiveStreams(ctx context.Context, in *twitch_video_starfruitsec.ScanActiveStreamsRequest) (*twitch_video_starfruitsec.ScanActiveStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ScanActiveStreams")
	out := new(twitch_video_starfruitsec.ScanActiveStreamsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===============================
// StreamManagementAPI JSON Client
// ===============================

type streamManagementAPIJSONClient struct {
	client HTTPClient
	urls   [11]string
	opts   twirp.ClientOptions
}

// NewStreamManagementAPIJSONClient creates a JSON client that implements the StreamManagementAPI interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStreamManagementAPIJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StreamManagementAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StreamManagementAPIPathPrefix
	urls := [11]string{
		prefix + "KillStream",
		prefix + "PutTimedMetadata",
		prefix + "GetChannelState",
		prefix + "ListActiveChannels",
		prefix + "GetStreamDetails",
		prefix + "ListStreamDetails",
		prefix + "ListStreamEvents",
		prefix + "ListLimitBreachEvents",
		prefix + "CountActiveChannels",
		prefix + "ScanCCBCount",
		prefix + "ScanActiveStreams",
	}

	return &streamManagementAPIJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *streamManagementAPIJSONClient) KillStream(ctx context.Context, in *KillStreamRequest) (*KillStreamResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "KillStream")
	out := new(KillStreamResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) PutTimedMetadata(ctx context.Context, in *PutTimedMetadataRequest) (*PutTimedMetadataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "PutTimedMetadata")
	out := new(PutTimedMetadataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) GetChannelState(ctx context.Context, in *twitch_video_starfruitsec.GetChannelStateRequest) (*twitch_video_starfruitsec.GetChannelStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelState")
	out := new(twitch_video_starfruitsec.GetChannelStateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) ListActiveChannels(ctx context.Context, in *twitch_video_starfruitsec.ListActiveChannelsRequest) (*twitch_video_starfruitsec.ListActiveChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveChannels")
	out := new(twitch_video_starfruitsec.ListActiveChannelsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) GetStreamDetails(ctx context.Context, in *twitch_video_starfruitsec.GetStreamDetailsRequest) (*twitch_video_starfruitsec.GetStreamDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamDetails")
	out := new(twitch_video_starfruitsec.GetStreamDetailsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) ListStreamDetails(ctx context.Context, in *twitch_video_starfruitsec.ListStreamDetailsRequest) (*twitch_video_starfruitsec.ListStreamDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamDetails")
	out := new(twitch_video_starfruitsec.ListStreamDetailsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) ListStreamEvents(ctx context.Context, in *twitch_video_starfruitsec.ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	out := new(twitch_video_starfruitsec.ListStreamEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) ListLimitBreachEvents(ctx context.Context, in *twitch_video_starfruitsec.ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	out := new(twitch_video_starfruitsec.ListLimitBreachEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) CountActiveChannels(ctx context.Context, in *twitch_video_starfruitsec.CountActiveChannelsRequest) (*twitch_video_starfruitsec.CountActiveChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CountActiveChannels")
	out := new(twitch_video_starfruitsec.CountActiveChannelsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) ScanCCBCount(ctx context.Context, in *twitch_video_starfruitsec.ScanCCBCountRequest) (*twitch_video_starfruitsec.ScanCCBCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ScanCCBCount")
	out := new(twitch_video_starfruitsec.ScanCCBCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *streamManagementAPIJSONClient) ScanActiveStreams(ctx context.Context, in *twitch_video_starfruitsec.ScanActiveStreamsRequest) (*twitch_video_starfruitsec.ScanActiveStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ScanActiveStreams")
	out := new(twitch_video_starfruitsec.ScanActiveStreamsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==================================
// StreamManagementAPI Server Handler
// ==================================

type streamManagementAPIServer struct {
	StreamManagementAPI
	hooks *twirp.ServerHooks
}

func NewStreamManagementAPIServer(svc StreamManagementAPI, hooks *twirp.ServerHooks) TwirpServer {
	return &streamManagementAPIServer{
		StreamManagementAPI: svc,
		hooks:               hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *streamManagementAPIServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StreamManagementAPIPathPrefix is used for all URL paths on a twirp StreamManagementAPI server.
// Requests are always: POST StreamManagementAPIPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StreamManagementAPIPathPrefix = "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/"

func (s *streamManagementAPIServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitiocp")
	ctx = ctxsetters.WithServiceName(ctx, "StreamManagementAPI")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/KillStream":
		s.serveKillStream(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/PutTimedMetadata":
		s.servePutTimedMetadata(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/GetChannelState":
		s.serveGetChannelState(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/ListActiveChannels":
		s.serveListActiveChannels(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/GetStreamDetails":
		s.serveGetStreamDetails(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/ListStreamDetails":
		s.serveListStreamDetails(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/ListStreamEvents":
		s.serveListStreamEvents(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/ListLimitBreachEvents":
		s.serveListLimitBreachEvents(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/CountActiveChannels":
		s.serveCountActiveChannels(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/ScanCCBCount":
		s.serveScanCCBCount(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitiocp.StreamManagementAPI/ScanActiveStreams":
		s.serveScanActiveStreams(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *streamManagementAPIServer) serveKillStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveKillStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveKillStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveKillStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "KillStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(KillStreamRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *KillStreamResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.KillStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *KillStreamResponse and nil error while calling KillStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveKillStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "KillStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(KillStreamRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *KillStreamResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.KillStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *KillStreamResponse and nil error while calling KillStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) servePutTimedMetadata(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.servePutTimedMetadataJSON(ctx, resp, req)
	case "application/protobuf":
		s.servePutTimedMetadataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) servePutTimedMetadataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutTimedMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PutTimedMetadataRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutTimedMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.PutTimedMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutTimedMetadataResponse and nil error while calling PutTimedMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) servePutTimedMetadataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "PutTimedMetadata")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(PutTimedMetadataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *PutTimedMetadataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.PutTimedMetadata(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PutTimedMetadataResponse and nil error while calling PutTimedMetadata. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveGetChannelState(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelStateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelStateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveGetChannelStateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.GetChannelStateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.GetChannelStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.GetChannelState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.GetChannelStateResponse and nil error while calling GetChannelState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveGetChannelStateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.GetChannelStateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.GetChannelStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.GetChannelState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.GetChannelStateResponse and nil error while calling GetChannelState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveListActiveChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListActiveChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListActiveChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveListActiveChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.ListActiveChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListActiveChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ListActiveChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListActiveChannelsResponse and nil error while calling ListActiveChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveListActiveChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.ListActiveChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListActiveChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ListActiveChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListActiveChannelsResponse and nil error while calling ListActiveChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveGetStreamDetails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamDetailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamDetailsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveGetStreamDetailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.GetStreamDetailsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.GetStreamDetailsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.GetStreamDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.GetStreamDetailsResponse and nil error while calling GetStreamDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveGetStreamDetailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.GetStreamDetailsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.GetStreamDetailsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.GetStreamDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.GetStreamDetailsResponse and nil error while calling GetStreamDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveListStreamDetails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamDetailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamDetailsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveListStreamDetailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.ListStreamDetailsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListStreamDetailsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ListStreamDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListStreamDetailsResponse and nil error while calling ListStreamDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveListStreamDetailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.ListStreamDetailsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListStreamDetailsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ListStreamDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListStreamDetailsResponse and nil error while calling ListStreamDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveListStreamEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveListStreamEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.ListStreamEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListStreamEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ListStreamEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListStreamEventsResponse and nil error while calling ListStreamEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveListStreamEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.ListStreamEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListStreamEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ListStreamEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListStreamEventsResponse and nil error while calling ListStreamEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveListLimitBreachEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListLimitBreachEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListLimitBreachEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveListLimitBreachEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.ListLimitBreachEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListLimitBreachEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ListLimitBreachEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListLimitBreachEventsResponse and nil error while calling ListLimitBreachEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveListLimitBreachEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.ListLimitBreachEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListLimitBreachEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ListLimitBreachEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListLimitBreachEventsResponse and nil error while calling ListLimitBreachEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveCountActiveChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCountActiveChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCountActiveChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveCountActiveChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CountActiveChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.CountActiveChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.CountActiveChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.CountActiveChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.CountActiveChannelsResponse and nil error while calling CountActiveChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveCountActiveChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CountActiveChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.CountActiveChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.CountActiveChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.CountActiveChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.CountActiveChannelsResponse and nil error while calling CountActiveChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveScanCCBCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveScanCCBCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveScanCCBCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveScanCCBCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanCCBCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.ScanCCBCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ScanCCBCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ScanCCBCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ScanCCBCountResponse and nil error while calling ScanCCBCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveScanCCBCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanCCBCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.ScanCCBCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ScanCCBCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ScanCCBCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ScanCCBCountResponse and nil error while calling ScanCCBCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveScanActiveStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveScanActiveStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveScanActiveStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *streamManagementAPIServer) serveScanActiveStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanActiveStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(twitch_video_starfruitsec.ScanActiveStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ScanActiveStreamsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ScanActiveStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ScanActiveStreamsResponse and nil error while calling ScanActiveStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) serveScanActiveStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanActiveStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(twitch_video_starfruitsec.ScanActiveStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ScanActiveStreamsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StreamManagementAPI.ScanActiveStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ScanActiveStreamsResponse and nil error while calling ScanActiveStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *streamManagementAPIServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor7, 0
}

func (s *streamManagementAPIServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *streamManagementAPIServer) PathPrefix() string {
	return StreamManagementAPIPathPrefix
}

var twirpFileDescriptor7 = []byte{
	// 583 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0x4d, 0x6f, 0xd3, 0x4c,
	0x10, 0x96, 0xdf, 0x17, 0x2a, 0x3a, 0x0d, 0x90, 0x6e, 0x41, 0x44, 0x96, 0x10, 0x21, 0x07, 0x94,
	0x0b, 0x8e, 0xda, 0x84, 0x8f, 0x6b, 0x62, 0xaa, 0x2a, 0xa2, 0x15, 0x51, 0x92, 0x13, 0x07, 0xac,
	0xc5, 0xde, 0x36, 0x0b, 0xf1, 0xda, 0x78, 0xc7, 0x29, 0x02, 0x81, 0x84, 0xc4, 0x89, 0xdf, 0xc9,
	0xef, 0x40, 0xc8, 0xde, 0x75, 0xd2, 0xc6, 0x89, 0x13, 0x4b, 0x5c, 0x22, 0x65, 0xf6, 0xf9, 0x9a,
	0x9d, 0xb1, 0x16, 0x7a, 0x6e, 0xe0, 0x31, 0xeb, 0x43, 0x2c, 0x91, 0x0b, 0x0b, 0x67, 0x2d, 0xea,
	0x7f, 0x11, 0xad, 0x11, 0xd2, 0xe8, 0x3c, 0x8a, 0x39, 0xf6, 0xdf, 0xd8, 0x83, 0xf1, 0x25, 0x8f,
	0xc2, 0x96, 0xc4, 0x88, 0x51, 0xdf, 0xf1, 0xa9, 0xa0, 0x17, 0xcc, 0x67, 0x02, 0x1d, 0x1a, 0x72,
	0x2b, 0x8c, 0x02, 0x0c, 0x88, 0x89, 0x97, 0x1c, 0xdd, 0x89, 0x35, 0xe3, 0x1e, 0x0b, 0x2c, 0x99,
	0x91, 0x79, 0xe0, 0x86, 0xe6, 0x61, 0xa1, 0xfe, 0xe8, 0xd8, 0x56, 0xf2, 0x98, 0xfc, 0x2a, 0xb9,
	0xc6, 0x3b, 0xd8, 0x7f, 0xcd, 0xa7, 0xd3, 0x51, 0xea, 0x38, 0x64, 0x9f, 0x62, 0x26, 0x91, 0x3c,
	0x82, 0x3d, 0x37, 0x96, 0x18, 0xf8, 0x2c, 0x72, 0xb8, 0x57, 0x33, 0xea, 0x46, 0x73, 0x77, 0x08,
	0x59, 0xa9, 0xef, 0x91, 0x26, 0x54, 0x75, 0x46, 0x37, 0x10, 0xe7, 0xfc, 0x22, 0x41, 0xfd, 0x97,
	0xa2, 0xee, 0xa8, 0xba, 0x9d, 0x96, 0xfb, 0x5e, 0xe3, 0x1e, 0x90, 0xab, 0xfa, 0x32, 0x0c, 0x84,
	0x64, 0x8d, 0xdf, 0x06, 0x3c, 0x18, 0xc4, 0x38, 0xe6, 0x3e, 0xf3, 0xce, 0x18, 0x52, 0x8f, 0x22,
	0xfd, 0xf7, 0xe6, 0xc4, 0x84, 0x5b, 0xbe, 0x56, 0xaf, 0xfd, 0x9f, 0x22, 0xe6, 0xff, 0xc9, 0x63,
	0xa8, 0x44, 0xca, 0x91, 0x79, 0x0e, 0xc5, 0xda, 0x8d, 0xf4, 0x7c, 0x6f, 0x5e, 0xeb, 0x22, 0xa9,
	0x43, 0x45, 0x0a, 0xe9, 0x60, 0x10, 0x72, 0x37, 0x31, 0xb9, 0xa9, 0xa2, 0x48, 0x21, 0xc7, 0x49,
	0xa9, 0xef, 0x91, 0x87, 0x00, 0x11, 0x45, 0xe6, 0x4c, 0xb9, 0xcf, 0xb1, 0xb6, 0x53, 0x37, 0x9a,
	0xb7, 0x87, 0xbb, 0x49, 0xe5, 0x34, 0x29, 0x34, 0x4c, 0xa8, 0xe5, 0xbb, 0x54, 0x57, 0x70, 0xf4,
	0x07, 0xe0, 0x40, 0xdd, 0xca, 0xd9, 0x7c, 0xcc, 0xdd, 0x41, 0x9f, 0x7c, 0x04, 0x58, 0x5c, 0x18,
	0x79, 0x6a, 0xad, 0x1f, 0xb7, 0x95, 0x1b, 0x9c, 0x69, 0x6d, 0x0b, 0x57, 0x21, 0xc8, 0x37, 0xa8,
	0x2e, 0x07, 0x24, 0xed, 0x22, 0x8d, 0x35, 0x43, 0x33, 0x3b, 0xe5, 0x48, 0xda, 0xfe, 0x33, 0xdc,
	0x3d, 0x61, 0x68, 0x4f, 0xa8, 0x10, 0x6c, 0x3a, 0x42, 0x8a, 0x8c, 0x1c, 0xae, 0x11, 0x92, 0xcc,
	0xb5, 0x96, 0xb0, 0x99, 0xf7, 0x51, 0x19, 0x8a, 0x76, 0xfe, 0x61, 0x00, 0x39, 0xe5, 0x12, 0xbb,
	0x2e, 0xf2, 0x19, 0xd3, 0x10, 0x49, 0x3a, 0x05, 0x52, 0x79, 0x78, 0x16, 0xe0, 0x59, 0x49, 0x96,
	0xce, 0xf0, 0x15, 0xaa, 0x27, 0x0c, 0xd5, 0x44, 0x5e, 0x31, 0xa4, 0x7c, 0x2a, 0xc9, 0x86, 0x5e,
	0xae, 0x81, 0x33, 0xfb, 0x76, 0x29, 0x8e, 0x36, 0xff, 0x0e, 0xfb, 0x49, 0xb4, 0xeb, 0xee, 0xed,
	0x0d, 0x8d, 0xac, 0xb4, 0xef, 0x94, 0x23, 0x2d, 0x9a, 0x5f, 0x1c, 0x1e, 0xcf, 0x98, 0xc0, 0xe2,
	0xe6, 0x97, 0xc1, 0xdb, 0x34, 0x9f, 0xe7, 0x68, 0xf3, 0x5f, 0x06, 0xdc, 0x4f, 0x0e, 0xd3, 0xaf,
	0xb4, 0x17, 0x31, 0xea, 0x4e, 0x74, 0x84, 0x17, 0x1b, 0xe4, 0x72, 0x8c, 0x2c, 0xc7, 0xcb, 0xf2,
	0x44, 0x1d, 0xe6, 0xa7, 0x01, 0x07, 0x76, 0x10, 0x8b, 0xe5, 0x5d, 0x2c, 0xda, 0xaa, 0x15, 0xf8,
	0x2c, 0xc8, 0xf3, 0xb2, 0x34, 0x1d, 0x23, 0x80, 0xca, 0xc8, 0xa5, 0xc2, 0xb6, 0x7b, 0x29, 0x8a,
	0x58, 0x05, 0x3a, 0x57, 0x81, 0x99, 0x6f, 0x6b, 0x6b, 0xfc, 0x62, 0x03, 0x93, 0xba, 0x8a, 0xa3,
	0xc6, 0x54, 0xbc, 0x81, 0x39, 0xf4, 0x36, 0x1b, 0xb8, 0x82, 0xa4, 0xfc, 0x7b, 0xcd, 0xb7, 0x4f,
	0xb6, 0x7b, 0x8e, 0xdf, 0xef, 0xa4, 0x4f, 0x65, 0xfb, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x61,
	0xfa, 0x4a, 0xc1, 0xbf, 0x07, 0x00, 0x00,
}
