// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitLiveProxyAPITwirp/liveproxyapi.proto

/*
Package StarfruitLiveProxyAPITwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/StarfruitLiveProxyAPITwirp/liveproxyapi.proto
*/
package StarfruitLiveProxyAPITwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ======================
// LiveProxyAPI Interface
// ======================

type LiveProxyAPI interface {
	// ListDisabledNodes lists ingest proxy nodes which are disabled.
	ListDisabledNodes(context.Context, *google_protobuf1.Empty) (*ListDisabledNodesResponse, error)

	// GetNodeHealth returns the health status of a given proxy node.
	GetNodeHealth(context.Context, *GetNodeHealthRequest) (*Node, error)

	// ListHostsInDNS lists hosts behind a DNS.
	ListHostsInDNS(context.Context, *ListHostsInDNSRequest) (*ListHostsInDNSResponse, error)

	// ListPOPs lists all tracked POPs.
	ListPOPs(context.Context, *google_protobuf1.Empty) (*ListPOPsResponse, error)

	// ListPublicIngests lists ingest proxy nodes which are healthy.
	ListPublicIngests(context.Context, *google_protobuf1.Empty) (*ListPublicIngestsResponse, error)

	// GetPOPHealth returns the health status of a given POP.
	GetPOPHealth(context.Context, *GetPOPHealthRequest) (*POP, error)

	// GetPOPHealthList returns basic health information from all ingest pops
	GetPOPHealthList(context.Context, *google_protobuf1.Empty) (*GetPOPHealthListResponse, error)

	// CreatePOP creates a POP and stores it in DynamoDB.
	CreatePOP(context.Context, *CreatePOPRequest) (*google_protobuf1.Empty, error)

	// RemovePOP removes a POP from DynamoDB.
	RemovePOP(context.Context, *RemovePOPRequest) (*google_protobuf1.Empty, error)

	// RemovePOPDNS removes DNS records for a given POP.
	RemovePOPDNS(context.Context, *RemovePOPDNSRequest) (*google_protobuf1.Empty, error)

	// RedirectPOP adds a redirect POP to a given POP.
	RedirectPOP(context.Context, *RedirectPOPRequest) (*google_protobuf1.Empty, error)

	// Set the origin for a given POP
	SetOrigin(context.Context, *SetOriginRequest) (*google_protobuf1.Empty, error)

	// RegisterIngest registers an IP in the DNS.
	RegisterIngest(context.Context, *RegisterIngestRequest) (*google_protobuf1.Empty, error)

	// DeregisterIngest removes an IP from the DNS.
	DeregisterIngest(context.Context, *DeregisterIngestRequest) (*google_protobuf1.Empty, error)

	// UptimeScan invokes the Scan and auto-manage procedures.
	UptimeScan(context.Context, *google_protobuf1.Empty) (*google_protobuf1.Empty, error)

	// Health performs a health check on the service.
	Health(context.Context, *google_protobuf1.Empty) (*google_protobuf1.Empty, error)

	// List all the IPLBs
	GetLBs(context.Context, *google_protobuf1.Empty) (*GetLBsResponse, error)

	// List IPs that are currently registered in LPA
	GetEdgeIPs(context.Context, *GetEdgeIPsRequest) (*GetEdgeIPsResponse, error)
}

// ============================
// LiveProxyAPI Protobuf Client
// ============================

type liveProxyAPIProtobufClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewLiveProxyAPIProtobufClient creates a Protobuf client that implements the LiveProxyAPI interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewLiveProxyAPIProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) LiveProxyAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + LiveProxyAPIPathPrefix
	urls := [18]string{
		prefix + "ListDisabledNodes",
		prefix + "GetNodeHealth",
		prefix + "ListHostsInDNS",
		prefix + "ListPOPs",
		prefix + "ListPublicIngests",
		prefix + "GetPOPHealth",
		prefix + "GetPOPHealthList",
		prefix + "CreatePOP",
		prefix + "RemovePOP",
		prefix + "RemovePOPDNS",
		prefix + "RedirectPOP",
		prefix + "SetOrigin",
		prefix + "RegisterIngest",
		prefix + "DeregisterIngest",
		prefix + "UptimeScan",
		prefix + "Health",
		prefix + "GetLBs",
		prefix + "GetEdgeIPs",
	}

	return &liveProxyAPIProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *liveProxyAPIProtobufClient) ListDisabledNodes(ctx context.Context, in *google_protobuf1.Empty) (*ListDisabledNodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListDisabledNodes")
	out := new(ListDisabledNodesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) GetNodeHealth(ctx context.Context, in *GetNodeHealthRequest) (*Node, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetNodeHealth")
	out := new(Node)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) ListHostsInDNS(ctx context.Context, in *ListHostsInDNSRequest) (*ListHostsInDNSResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListHostsInDNS")
	out := new(ListHostsInDNSResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) ListPOPs(ctx context.Context, in *google_protobuf1.Empty) (*ListPOPsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListPOPs")
	out := new(ListPOPsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) ListPublicIngests(ctx context.Context, in *google_protobuf1.Empty) (*ListPublicIngestsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListPublicIngests")
	out := new(ListPublicIngestsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) GetPOPHealth(ctx context.Context, in *GetPOPHealthRequest) (*POP, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetPOPHealth")
	out := new(POP)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) GetPOPHealthList(ctx context.Context, in *google_protobuf1.Empty) (*GetPOPHealthListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetPOPHealthList")
	out := new(GetPOPHealthListResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) CreatePOP(ctx context.Context, in *CreatePOPRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CreatePOP")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) RemovePOP(ctx context.Context, in *RemovePOPRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "RemovePOP")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) RemovePOPDNS(ctx context.Context, in *RemovePOPDNSRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "RemovePOPDNS")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) RedirectPOP(ctx context.Context, in *RedirectPOPRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "RedirectPOP")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) SetOrigin(ctx context.Context, in *SetOriginRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "SetOrigin")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) RegisterIngest(ctx context.Context, in *RegisterIngestRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterIngest")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) DeregisterIngest(ctx context.Context, in *DeregisterIngestRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterIngest")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) UptimeScan(ctx context.Context, in *google_protobuf1.Empty) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "UptimeScan")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) Health(ctx context.Context, in *google_protobuf1.Empty) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "Health")
	out := new(google_protobuf1.Empty)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) GetLBs(ctx context.Context, in *google_protobuf1.Empty) (*GetLBsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetLBs")
	out := new(GetLBsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIProtobufClient) GetEdgeIPs(ctx context.Context, in *GetEdgeIPsRequest) (*GetEdgeIPsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetEdgeIPs")
	out := new(GetEdgeIPsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ========================
// LiveProxyAPI JSON Client
// ========================

type liveProxyAPIJSONClient struct {
	client HTTPClient
	urls   [18]string
	opts   twirp.ClientOptions
}

// NewLiveProxyAPIJSONClient creates a JSON client that implements the LiveProxyAPI interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewLiveProxyAPIJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) LiveProxyAPI {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + LiveProxyAPIPathPrefix
	urls := [18]string{
		prefix + "ListDisabledNodes",
		prefix + "GetNodeHealth",
		prefix + "ListHostsInDNS",
		prefix + "ListPOPs",
		prefix + "ListPublicIngests",
		prefix + "GetPOPHealth",
		prefix + "GetPOPHealthList",
		prefix + "CreatePOP",
		prefix + "RemovePOP",
		prefix + "RemovePOPDNS",
		prefix + "RedirectPOP",
		prefix + "SetOrigin",
		prefix + "RegisterIngest",
		prefix + "DeregisterIngest",
		prefix + "UptimeScan",
		prefix + "Health",
		prefix + "GetLBs",
		prefix + "GetEdgeIPs",
	}

	return &liveProxyAPIJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *liveProxyAPIJSONClient) ListDisabledNodes(ctx context.Context, in *google_protobuf1.Empty) (*ListDisabledNodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListDisabledNodes")
	out := new(ListDisabledNodesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) GetNodeHealth(ctx context.Context, in *GetNodeHealthRequest) (*Node, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetNodeHealth")
	out := new(Node)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) ListHostsInDNS(ctx context.Context, in *ListHostsInDNSRequest) (*ListHostsInDNSResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListHostsInDNS")
	out := new(ListHostsInDNSResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) ListPOPs(ctx context.Context, in *google_protobuf1.Empty) (*ListPOPsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListPOPs")
	out := new(ListPOPsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) ListPublicIngests(ctx context.Context, in *google_protobuf1.Empty) (*ListPublicIngestsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "ListPublicIngests")
	out := new(ListPublicIngestsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) GetPOPHealth(ctx context.Context, in *GetPOPHealthRequest) (*POP, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetPOPHealth")
	out := new(POP)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) GetPOPHealthList(ctx context.Context, in *google_protobuf1.Empty) (*GetPOPHealthListResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetPOPHealthList")
	out := new(GetPOPHealthListResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) CreatePOP(ctx context.Context, in *CreatePOPRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "CreatePOP")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) RemovePOP(ctx context.Context, in *RemovePOPRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "RemovePOP")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) RemovePOPDNS(ctx context.Context, in *RemovePOPDNSRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "RemovePOPDNS")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) RedirectPOP(ctx context.Context, in *RedirectPOPRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "RedirectPOP")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) SetOrigin(ctx context.Context, in *SetOriginRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "SetOrigin")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) RegisterIngest(ctx context.Context, in *RegisterIngestRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "RegisterIngest")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) DeregisterIngest(ctx context.Context, in *DeregisterIngestRequest) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterIngest")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) UptimeScan(ctx context.Context, in *google_protobuf1.Empty) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "UptimeScan")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) Health(ctx context.Context, in *google_protobuf1.Empty) (*google_protobuf1.Empty, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "Health")
	out := new(google_protobuf1.Empty)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) GetLBs(ctx context.Context, in *google_protobuf1.Empty) (*GetLBsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetLBs")
	out := new(GetLBsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *liveProxyAPIJSONClient) GetEdgeIPs(ctx context.Context, in *GetEdgeIPsRequest) (*GetEdgeIPsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithMethodName(ctx, "GetEdgeIPs")
	out := new(GetEdgeIPsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===========================
// LiveProxyAPI Server Handler
// ===========================

type liveProxyAPIServer struct {
	LiveProxyAPI
	hooks *twirp.ServerHooks
}

func NewLiveProxyAPIServer(svc LiveProxyAPI, hooks *twirp.ServerHooks) TwirpServer {
	return &liveProxyAPIServer{
		LiveProxyAPI: svc,
		hooks:        hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *liveProxyAPIServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// LiveProxyAPIPathPrefix is used for all URL paths on a twirp LiveProxyAPI server.
// Requests are always: POST LiveProxyAPIPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const LiveProxyAPIPathPrefix = "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/"

func (s *liveProxyAPIServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.ingest.liveproxyapi")
	ctx = ctxsetters.WithServiceName(ctx, "LiveProxyAPI")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/ListDisabledNodes":
		s.serveListDisabledNodes(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/GetNodeHealth":
		s.serveGetNodeHealth(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/ListHostsInDNS":
		s.serveListHostsInDNS(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/ListPOPs":
		s.serveListPOPs(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/ListPublicIngests":
		s.serveListPublicIngests(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/GetPOPHealth":
		s.serveGetPOPHealth(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/GetPOPHealthList":
		s.serveGetPOPHealthList(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/CreatePOP":
		s.serveCreatePOP(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/RemovePOP":
		s.serveRemovePOP(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/RemovePOPDNS":
		s.serveRemovePOPDNS(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/RedirectPOP":
		s.serveRedirectPOP(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/SetOrigin":
		s.serveSetOrigin(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/RegisterIngest":
		s.serveRegisterIngest(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/DeregisterIngest":
		s.serveDeregisterIngest(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/UptimeScan":
		s.serveUptimeScan(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/Health":
		s.serveHealth(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/GetLBs":
		s.serveGetLBs(ctx, resp, req)
		return
	case "/twirp/twitch.video.ingest.liveproxyapi.LiveProxyAPI/GetEdgeIPs":
		s.serveGetEdgeIPs(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *liveProxyAPIServer) serveListDisabledNodes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListDisabledNodesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListDisabledNodesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveListDisabledNodesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListDisabledNodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(google_protobuf1.Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListDisabledNodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.ListDisabledNodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListDisabledNodesResponse and nil error while calling ListDisabledNodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveListDisabledNodesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListDisabledNodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(google_protobuf1.Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListDisabledNodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.ListDisabledNodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListDisabledNodesResponse and nil error while calling ListDisabledNodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetNodeHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetNodeHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetNodeHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveGetNodeHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetNodeHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetNodeHealthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Node
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetNodeHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Node and nil error while calling GetNodeHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetNodeHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetNodeHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetNodeHealthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Node
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetNodeHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Node and nil error while calling GetNodeHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveListHostsInDNS(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListHostsInDNSJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListHostsInDNSProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveListHostsInDNSJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListHostsInDNS")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListHostsInDNSRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListHostsInDNSResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.ListHostsInDNS(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListHostsInDNSResponse and nil error while calling ListHostsInDNS. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveListHostsInDNSProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListHostsInDNS")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListHostsInDNSRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListHostsInDNSResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.ListHostsInDNS(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListHostsInDNSResponse and nil error while calling ListHostsInDNS. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveListPOPs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListPOPsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListPOPsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveListPOPsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPOPs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(google_protobuf1.Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPOPsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.ListPOPs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPOPsResponse and nil error while calling ListPOPs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveListPOPsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPOPs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(google_protobuf1.Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPOPsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.ListPOPs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPOPsResponse and nil error while calling ListPOPs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveListPublicIngests(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListPublicIngestsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListPublicIngestsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveListPublicIngestsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPublicIngests")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(google_protobuf1.Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPublicIngestsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.ListPublicIngests(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPublicIngestsResponse and nil error while calling ListPublicIngests. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveListPublicIngestsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPublicIngests")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(google_protobuf1.Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListPublicIngestsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.ListPublicIngests(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListPublicIngestsResponse and nil error while calling ListPublicIngests. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetPOPHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPOPHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPOPHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveGetPOPHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPOPHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetPOPHealthRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *POP
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetPOPHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *POP and nil error while calling GetPOPHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetPOPHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPOPHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetPOPHealthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *POP
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetPOPHealth(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *POP and nil error while calling GetPOPHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetPOPHealthList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPOPHealthListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPOPHealthListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveGetPOPHealthListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPOPHealthList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(google_protobuf1.Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPOPHealthListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetPOPHealthList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPOPHealthListResponse and nil error while calling GetPOPHealthList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetPOPHealthListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPOPHealthList")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(google_protobuf1.Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetPOPHealthListResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetPOPHealthList(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetPOPHealthListResponse and nil error while calling GetPOPHealthList. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveCreatePOP(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreatePOPJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreatePOPProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveCreatePOPJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreatePOP")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreatePOPRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.CreatePOP(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling CreatePOP. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveCreatePOPProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreatePOP")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreatePOPRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.CreatePOP(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling CreatePOP. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveRemovePOP(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemovePOPJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemovePOPProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveRemovePOPJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemovePOP")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemovePOPRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.RemovePOP(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling RemovePOP. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveRemovePOPProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemovePOP")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemovePOPRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.RemovePOP(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling RemovePOP. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveRemovePOPDNS(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemovePOPDNSJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemovePOPDNSProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveRemovePOPDNSJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemovePOPDNS")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RemovePOPDNSRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.RemovePOPDNS(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling RemovePOPDNS. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveRemovePOPDNSProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemovePOPDNS")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RemovePOPDNSRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.RemovePOPDNS(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling RemovePOPDNS. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveRedirectPOP(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRedirectPOPJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRedirectPOPProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveRedirectPOPJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RedirectPOP")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RedirectPOPRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.RedirectPOP(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling RedirectPOP. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveRedirectPOPProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RedirectPOP")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RedirectPOPRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.RedirectPOP(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling RedirectPOP. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveSetOrigin(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetOriginJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetOriginProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveSetOriginJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetOrigin")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetOriginRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.SetOrigin(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling SetOrigin. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveSetOriginProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetOrigin")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetOriginRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.SetOrigin(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling SetOrigin. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveRegisterIngest(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegisterIngestJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegisterIngestProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveRegisterIngestJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterIngest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RegisterIngestRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.RegisterIngest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling RegisterIngest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveRegisterIngestProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegisterIngest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RegisterIngestRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.RegisterIngest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling RegisterIngest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveDeregisterIngest(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeregisterIngestJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeregisterIngestProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveDeregisterIngestJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterIngest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeregisterIngestRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.DeregisterIngest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling DeregisterIngest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveDeregisterIngestProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeregisterIngest")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeregisterIngestRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.DeregisterIngest(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling DeregisterIngest. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveUptimeScan(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUptimeScanJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUptimeScanProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveUptimeScanJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UptimeScan")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(google_protobuf1.Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.UptimeScan(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling UptimeScan. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveUptimeScanProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UptimeScan")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(google_protobuf1.Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.UptimeScan(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling UptimeScan. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Health")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(google_protobuf1.Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.Health(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling Health. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Health")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(google_protobuf1.Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *google_protobuf1.Empty
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.Health(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *google_protobuf1.Empty and nil error while calling Health. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetLBs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetLBsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetLBsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveGetLBsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLBs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(google_protobuf1.Empty)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLBsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetLBs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLBsResponse and nil error while calling GetLBs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetLBsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetLBs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(google_protobuf1.Empty)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetLBsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetLBs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetLBsResponse and nil error while calling GetLBs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetEdgeIPs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetEdgeIPsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetEdgeIPsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *liveProxyAPIServer) serveGetEdgeIPsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEdgeIPs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetEdgeIPsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEdgeIPsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetEdgeIPs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEdgeIPsResponse and nil error while calling GetEdgeIPs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) serveGetEdgeIPsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetEdgeIPs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetEdgeIPsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetEdgeIPsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.LiveProxyAPI.GetEdgeIPs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetEdgeIPsResponse and nil error while calling GetEdgeIPs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *liveProxyAPIServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *liveProxyAPIServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *liveProxyAPIServer) PathPrefix() string {
	return LiveProxyAPIPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1323 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x6f, 0x6f, 0xdb, 0x44,
	0x18, 0x97, 0xf3, 0x3f, 0x4f, 0xd2, 0x92, 0xdd, 0xfe, 0xe0, 0x65, 0x20, 0x82, 0xd1, 0xaa, 0x20,
	0x4d, 0xee, 0x94, 0x8e, 0x31, 0xd6, 0x21, 0xd4, 0x6e, 0xa3, 0x2b, 0xaa, 0xda, 0xc8, 0x1d, 0x9b,
	0x00, 0xa1, 0xc8, 0x8d, 0xaf, 0xe9, 0x81, 0xed, 0x33, 0xf6, 0x39, 0x23, 0xbc, 0xe5, 0xfb, 0xf0,
	0x86, 0x57, 0x7c, 0x06, 0xf8, 0x0a, 0xfb, 0x2e, 0xe8, 0xee, 0xec, 0xd8, 0x4e, 0xea, 0xc5, 0xa1,
	0xe2, 0xdd, 0xf9, 0xb9, 0x7b, 0x7e, 0xf7, 0xfc, 0x9e, 0x3f, 0x3f, 0x3b, 0x81, 0xbd, 0x31, 0xb5,
	0xb0, 0xfe, 0x53, 0x18, 0x30, 0xe2, 0xea, 0x6c, 0xba, 0x6d, 0x3a, 0xbf, 0xb9, 0xdb, 0xa7, 0xcc,
	0xf4, 0xcf, 0xfd, 0x90, 0xb0, 0x23, 0x32, 0xc5, 0x43, 0x9f, 0xfe, 0x3a, 0xdb, 0x1b, 0x1e, 0xbe,
	0x7c, 0x43, 0x7c, 0x6f, 0xdb, 0x26, 0x53, 0xec, 0x71, 0x8b, 0xe9, 0x11, 0xdd, 0xf3, 0x29, 0xa3,
	0xa8, 0xc7, 0xde, 0x10, 0x36, 0xbe, 0xd0, 0xa7, 0xc4, 0xc2, 0x54, 0x27, 0xee, 0x04, 0x07, 0x4c,
	0x4f, 0x9f, 0xeb, 0x7e, 0x34, 0xa1, 0x74, 0x62, 0xe3, 0x6d, 0x71, 0xfe, 0x2c, 0x3c, 0xdf, 0x66,
	0xc4, 0xc1, 0x01, 0x33, 0x1d, 0x4f, 0x42, 0x74, 0xef, 0x2c, 0x1e, 0xc0, 0x8e, 0xc7, 0x66, 0x72,
	0x53, 0x7b, 0x5b, 0x82, 0xca, 0x31, 0xb5, 0x30, 0xda, 0x85, 0x56, 0xe8, 0x59, 0x26, 0xc3, 0x23,
	0xee, 0xaf, 0x2a, 0x3d, 0xa5, 0xdf, 0x1a, 0x74, 0x75, 0xe9, 0xab, 0xc7, 0xbe, 0xfa, 0xcb, 0x18,
	0xdc, 0x00, 0x79, 0x9c, 0x1b, 0xd0, 0x0d, 0xa8, 0x8e, 0xcd, 0x30, 0xc0, 0x6a, 0xa9, 0xa7, 0xf4,
	0x9b, 0x86, 0x7c, 0x40, 0xb7, 0xa0, 0x76, 0x81, 0x4d, 0x9b, 0x5d, 0xa8, 0x65, 0x61, 0x8e, 0x9e,
	0xd0, 0xc7, 0xd0, 0xbe, 0xa0, 0x01, 0x1b, 0x99, 0x96, 0xe5, 0xe3, 0x20, 0x50, 0x2b, 0x62, 0xb7,
	0xc5, 0x6d, 0x7b, 0xd2, 0x84, 0xee, 0x40, 0x53, 0x1c, 0x71, 0x4d, 0x07, 0xab, 0x55, 0xb1, 0xdf,
	0xe0, 0x86, 0x63, 0xd3, 0xc1, 0x08, 0x41, 0x65, 0x4c, 0x5d, 0x57, 0xad, 0xf5, 0x94, 0xfe, 0x86,
	0x21, 0xd6, 0xa8, 0x03, 0xe5, 0xb1, 0x17, 0xaa, 0xf5, 0x9e, 0xd2, 0x57, 0x0c, 0xbe, 0xe4, 0x16,
	0x07, 0x3b, 0x6a, 0x43, 0x5a, 0x1c, 0xec, 0xa0, 0xdb, 0xd0, 0x20, 0xee, 0xe8, 0x6c, 0xc6, 0x70,
	0xa0, 0x36, 0x85, 0xb9, 0x4e, 0xdc, 0x7d, 0xfe, 0xc8, 0xef, 0xa3, 0x21, 0x8b, 0xf6, 0x40, 0xec,
	0x35, 0x68, 0xc8, 0xe4, 0x26, 0x82, 0x8a, 0x47, 0xbd, 0x40, 0x6d, 0xf5, 0xca, 0xfd, 0xa6, 0x21,
	0xd6, 0x68, 0x0b, 0xde, 0x4b, 0x73, 0x18, 0x4d, 0x1f, 0xaa, 0x6d, 0x11, 0xe6, 0x46, 0x8a, 0xc6,
	0xab, 0x87, 0xda, 0x0e, 0x54, 0x5e, 0xd0, 0x80, 0x65, 0x09, 0x29, 0x0b, 0x84, 0x36, 0xa1, 0x44,
	0xbc, 0x28, 0x77, 0x25, 0xe2, 0x69, 0x7f, 0x2a, 0x50, 0x3b, 0x14, 0xa5, 0x16, 0x5b, 0x56, 0xe4,
	0x50, 0x22, 0x16, 0x67, 0x65, 0x9b, 0x4c, 0x9c, 0x55, 0x0c, 0xbe, 0xe4, 0xd1, 0xd9, 0xd4, 0x9d,
	0x88, 0x1c, 0x2b, 0x86, 0x58, 0x23, 0x0d, 0xda, 0xe6, 0xd4, 0x24, 0xb6, 0x79, 0x46, 0x6c, 0xc2,
	0x66, 0x22, 0xc3, 0x8a, 0x91, 0xb1, 0x21, 0x15, 0xea, 0x16, 0x3e, 0x37, 0x43, 0x9b, 0x89, 0x04,
	0x37, 0x8c, 0xf8, 0x91, 0x23, 0x8a, 0x30, 0x6b, 0xe2, 0x56, 0xb1, 0xe6, 0x35, 0x0b, 0x7d, 0x7b,
	0xc4, 0xb0, 0xe3, 0xd9, 0x26, 0xc3, 0x22, 0xd1, 0x4d, 0xa3, 0x15, 0xfa, 0xf6, 0xcb, 0xc8, 0xa4,
	0xfd, 0xad, 0x40, 0x79, 0x78, 0x32, 0x5c, 0x0a, 0x39, 0x69, 0x83, 0x52, 0xa6, 0x0d, 0x3a, 0x50,
	0xb6, 0xdc, 0x20, 0xea, 0x0d, 0xbe, 0x44, 0x1f, 0x40, 0xd3, 0xc7, 0x16, 0xf1, 0xf1, 0x98, 0xc5,
	0x5d, 0x91, 0x18, 0x92, 0x26, 0xab, 0xa6, 0x9b, 0xec, 0x09, 0x54, 0x5d, 0x6a, 0xe1, 0x40, 0xad,
	0xf5, 0xca, 0xfd, 0xd6, 0x60, 0x4b, 0x5f, 0x35, 0x30, 0x3a, 0x6f, 0x77, 0x43, 0x3a, 0xf1, 0x24,
	0x78, 0x3e, 0x99, 0xc6, 0x8c, 0x1a, 0x46, 0xfc, 0xa8, 0xed, 0xc2, 0xb5, 0x03, 0xcc, 0x9e, 0x5b,
	0x13, 0x7c, 0x38, 0x0c, 0x0c, 0xfc, 0x4b, 0xc8, 0xab, 0xb1, 0x05, 0x9b, 0x9c, 0xeb, 0x39, 0xf5,
	0x9d, 0xaf, 0x89, 0xcd, 0xb0, 0xaf, 0x2a, 0xa2, 0x27, 0x16, 0xac, 0xda, 0x0e, 0xa0, 0xb4, 0x73,
	0xe0, 0x51, 0x37, 0xc0, 0xe8, 0x43, 0x00, 0xe2, 0x4d, 0x1f, 0x88, 0x9e, 0x09, 0x22, 0xcf, 0x26,
	0xb7, 0xf0, 0x76, 0x09, 0xb4, 0xa7, 0x50, 0x3e, 0xda, 0x0f, 0x12, 0x42, 0xca, 0x7f, 0x20, 0xa4,
	0xfd, 0xa3, 0xc0, 0xe6, 0x01, 0x66, 0x47, 0xfb, 0xc9, 0xb5, 0xaf, 0xa1, 0x4e, 0x7d, 0x32, 0x21,
	0x6e, 0x0c, 0xf9, 0xe5, 0x6a, 0xc8, 0x2c, 0x84, 0x7e, 0x22, 0xfd, 0x9f, 0xbb, 0xcc, 0x9f, 0x19,
	0x31, 0x5a, 0xd7, 0x84, 0x76, 0x7a, 0x83, 0x17, 0xf4, 0x67, 0x3c, 0x8b, 0x2a, 0xcf, 0x97, 0x68,
	0x17, 0xaa, 0x53, 0xd3, 0x0e, 0xa5, 0x2e, 0xb4, 0x06, 0x77, 0x57, 0x5f, 0xcc, 0x6f, 0x95, 0x3e,
	0x8f, 0x4b, 0x8f, 0x14, 0xed, 0x3b, 0xb8, 0x7d, 0x44, 0x02, 0xf6, 0x8c, 0x04, 0xe6, 0x99, 0x8d,
	0x2d, 0xce, 0x34, 0x21, 0x76, 0xb5, 0x4c, 0x0d, 0xe0, 0x26, 0x87, 0xe6, 0xd3, 0x19, 0x1c, 0xba,
	0xcf, 0x8e, 0x4f, 0xe3, 0x22, 0xdf, 0x86, 0x86, 0xe5, 0x06, 0xe9, 0x49, 0xad, 0x5b, 0x6e, 0xc0,
	0x07, 0x55, 0x7b, 0x05, 0xb7, 0x16, 0x7d, 0x92, 0x58, 0xf8, 0x38, 0xaf, 0x11, 0x0b, 0x07, 0x31,
	0xa4, 0x93, 0xb6, 0x05, 0x1d, 0x8e, 0x3b, 0x3c, 0x49, 0x75, 0x4b, 0xac, 0x3a, 0x4a, 0xa2, 0x3a,
	0xda, 0x48, 0xa6, 0x63, 0x18, 0x9e, 0xd9, 0x64, 0x2c, 0x15, 0x22, 0x71, 0xd8, 0x87, 0xba, 0xbc,
	0x27, 0x0e, 0xa2, 0xbf, 0x3a, 0x08, 0x89, 0x61, 0xc4, 0x8e, 0xda, 0x0e, 0xdc, 0x38, 0xc0, 0x8c,
	0xa7, 0xe9, 0x85, 0x18, 0xd2, 0x38, 0x27, 0xef, 0x92, 0x2f, 0xed, 0x1e, 0x5c, 0x3f, 0xc0, 0x3c,
	0xf8, 0xac, 0xcf, 0x4d, 0xa8, 0x79, 0xd4, 0x1b, 0xcd, 0xb5, 0xa0, 0xea, 0x51, 0xef, 0xd0, 0xd2,
	0xfe, 0x52, 0xe0, 0xda, 0xfc, 0x2c, 0x67, 0x73, 0xc8, 0xb0, 0xf3, 0xbf, 0x89, 0x46, 0xac, 0x65,
	0xd5, 0x94, 0x96, 0x21, 0xa8, 0xb0, 0x99, 0x37, 0xd7, 0x37, 0xbe, 0x8e, 0x75, 0xb5, 0xbe, 0xac,
	0xab, 0x8d, 0x44, 0x57, 0xb5, 0x31, 0xa8, 0x69, 0xa6, 0x3c, 0xfa, 0x79, 0xfa, 0x0f, 0x52, 0xf5,
	0x6a, 0x0d, 0x76, 0x56, 0xe7, 0x7e, 0x29, 0x09, 0x51, 0x91, 0xff, 0x50, 0xa0, 0xf3, 0xd4, 0xc7,
	0x26, 0xc3, 0xc3, 0x93, 0x61, 0x9c, 0xcc, 0x88, 0xb7, 0x92, 0xf0, 0x8e, 0x59, 0x94, 0x96, 0x59,
	0x94, 0x97, 0x59, 0x54, 0x52, 0x6f, 0x87, 0xcb, 0x72, 0x92, 0x14, 0xab, 0x96, 0x2a, 0x16, 0xfa,
	0x04, 0x36, 0x98, 0xe9, 0x4f, 0x30, 0x1b, 0xc9, 0xa1, 0x8f, 0x74, 0xbf, 0x2d, 0x8d, 0x72, 0xfa,
	0xb5, 0x4f, 0xa1, 0x63, 0x60, 0x87, 0x4e, 0xd3, 0xf1, 0xe6, 0x14, 0xff, 0x1e, 0x5c, 0x9f, 0x1f,
	0x4d, 0x8d, 0x5c, 0xce, 0xe9, 0x6f, 0x00, 0x19, 0x51, 0x25, 0x57, 0x42, 0x73, 0x75, 0x8d, 0x42,
	0xf5, 0x68, 0xfc, 0x32, 0x6d, 0x4a, 0xcb, 0x90, 0x7a, 0xda, 0x31, 0x74, 0x4e, 0xe3, 0x88, 0x57,
	0x20, 0x2d, 0x91, 0x2e, 0x5d, 0x42, 0xfa, 0x2b, 0xb8, 0x69, 0xe0, 0x09, 0x09, 0x18, 0xf6, 0xa3,
	0x21, 0x8a, 0x40, 0x2f, 0xe9, 0x64, 0xe9, 0x18, 0x77, 0xb2, 0x7c, 0xd2, 0xf6, 0xe0, 0xfd, 0x67,
	0xd8, 0xbf, 0x0a, 0xc4, 0xe0, 0xed, 0x06, 0xb4, 0xd3, 0x5f, 0x91, 0xe8, 0x02, 0xae, 0x2d, 0xc9,
	0x25, 0xba, 0xb5, 0xf4, 0x11, 0xf7, 0x9c, 0x7f, 0x00, 0x76, 0x77, 0x0b, 0xa8, 0x71, 0xae, 0xf6,
	0x52, 0xd8, 0xc8, 0x08, 0x05, 0x7a, 0x58, 0xe8, 0xa5, 0xb2, 0xa4, 0x2c, 0xdd, 0x82, 0xaa, 0x8d,
	0x7e, 0x57, 0x60, 0x33, 0xab, 0xbd, 0xe8, 0xf3, 0x62, 0x04, 0x96, 0x14, 0xbe, 0xfb, 0x68, 0x7d,
	0xc7, 0x88, 0xf6, 0x2b, 0x68, 0xc4, 0x42, 0x9d, 0x9b, 0xd7, 0x41, 0x31, 0xf4, 0x8c, 0xd8, 0x47,
	0x85, 0xcb, 0x08, 0xfb, 0x55, 0x0b, 0x77, 0xf9, 0x5b, 0xc2, 0x86, 0x76, 0x5a, 0xc2, 0xd0, 0x67,
	0x85, 0xea, 0xb6, 0x28, 0xee, 0xdd, 0xbb, 0x85, 0xf4, 0x0d, 0x9d, 0x43, 0x67, 0x51, 0x30, 0x73,
	0x69, 0x3d, 0x5e, 0x2f, 0x92, 0x8c, 0xf8, 0xbe, 0x86, 0xe6, 0x5c, 0x32, 0x51, 0x81, 0x02, 0x2c,
	0xea, 0x6b, 0x37, 0x27, 0x28, 0x0e, 0x3c, 0x17, 0xac, 0x22, 0xc0, 0x8b, 0x42, 0x98, 0x0b, 0xfc,
	0x23, 0xb4, 0xd3, 0x4a, 0x58, 0xa4, 0x0e, 0x97, 0x28, 0x67, 0x2e, 0xfc, 0x0f, 0xd0, 0x4a, 0x49,
	0x27, 0x7a, 0x50, 0x04, 0x7d, 0x51, 0x69, 0xdf, 0x95, 0x94, 0xb9, 0x96, 0x16, 0x49, 0xca, 0xa2,
	0xf0, 0xe6, 0x02, 0x9b, 0xb0, 0x99, 0x15, 0xd5, 0x22, 0x33, 0x7e, 0xa9, 0x0c, 0xe7, 0x5e, 0x81,
	0xa1, 0xb3, 0x28, 0xbb, 0xe8, 0x8b, 0xd5, 0x97, 0xe4, 0x48, 0x75, 0xee, 0x35, 0x4f, 0x00, 0xbe,
	0xf5, 0xf8, 0x2f, 0xe9, 0xd3, 0xb1, 0xe9, 0xe6, 0xb6, 0x7c, 0x9e, 0xf7, 0x23, 0xa8, 0x45, 0xe3,
	0xb9, 0xae, 0xa7, 0x01, 0x35, 0xf9, 0xed, 0x9e, 0xeb, 0x79, 0x7f, 0xdd, 0xaf, 0x7f, 0xf4, 0x06,
	0x20, 0xf9, 0x35, 0x83, 0x76, 0x0a, 0xf9, 0x67, 0x7f, 0x38, 0x75, 0x1f, 0xac, 0xe7, 0x24, 0x2f,
	0xde, 0xbf, 0xff, 0xbd, 0xbe, 0xde, 0x3f, 0x28, 0x67, 0x35, 0x41, 0x76, 0xe7, 0xdf, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xf9, 0x53, 0x94, 0x7c, 0x7a, 0x11, 0x00, 0x00,
}
