package consumer

import (
	"testing"
	"time"

	"github.com/pkg/errors"
)

func TestBackoff(t *testing.T) {
	// just testing the configuration of the ExponentialBackOff
	backoff := newBackoffWaiter().backoff

	var last time.Duration
	for i := 0; i < 5; i++ {
		dt := backoff.NextBackOff()
		if dt < last {
			t.Fatalf("unexpected backoff %v < last backoff %v", dt, last)
		}

		if dt > 20*time.Second {
			t.Fatalf("unexpected backoff %v > 20s", dt)
		}

		last = dt
	}

	for i := 0; i < 20; i++ {
		backoff.NextBackOff()
	}

	max := backoff.NextBackOff()
	if max != 20*time.Second {
		t.Fatalf("unexpected backoff %v != 20s", max)
	}

	backoff.Reset()

	dt := backoff.NextBackOff()
	if dt >= max {
		t.Fatalf("unexpected backoff %v not smaller after reset", dt)
	}
}

func TestNonRetryable(t *testing.T) {
	err := errors.New("inner")
	if isNonRetryable(err) {
		t.Error("plain error shouldn't be NonRetryable")
	}

	err = NonRetryable(err)
	if !isNonRetryable(err) {
		t.Error("wrapped error should be NonRetryable")
	}

	err = errors.Wrap(err, "outer")
	if !isNonRetryable(err) {
		t.Error("nested/wrapped error should be NonRetryable")
	}
}
