package StarfruitSECProducer

import "testing"

func TestGetChannelArn(t *testing.T) {
	type args struct {
		channel string
	}
	tests := []struct {
		name string
		args args
		want string
	}{
		{
			name: "TestGetChannelArnStarfruit",
			args: args{channel: "aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			want: "arn:aws:svs:us-west-2:956482054022:channel/65ce4cbf-fab9-4d4f-9aa1-0843a3256234",
		},
		{
			name: "TestGetChannelArnLVS",
			args: args{channel: "lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			want: "arn:aws:lvs:us-west-2:amazon-live:channel/65ce4cbf-fab9-4d4f-9aa1-0843a3256234",
		},
		{
			name: "TestGetChannelArnTwitch",
			args: args{channel: "twitch_test"},
			want: "arn:aws:twitch:us-west-2:twitch:channel/twitch_test",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := GetChannelArn(tt.args.channel); got != tt.want {
				t.Errorf("GetChannelArn() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestGetCustomerIdContentIdFromChannel(t *testing.T) {
	type args struct {
		channel string
	}
	tests := []struct {
		name       string
		args       args
		customerId string
		contentId  string
	}{
		{
			name:       "TestGetChannelArnStarfruit",
			args:       args{channel: "aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			customerId: "956482054022",
			contentId:  "65ce4cbf-fab9-4d4f-9aa1-0843a3256234",
		},
		{
			name:       "TestGetChannelArnLVS",
			args:       args{channel: "lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			customerId: "amazon-live",
			contentId:  "65ce4cbf-fab9-4d4f-9aa1-0843a3256234",
		},
		{
			name:       "TestGetChannelArnTwitch",
			args:       args{channel: "twitch_test"},
			customerId: "",
			contentId:  "",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			gotCustomerId, gotContentId := GetCustomerIdContentIdFromChannel(tt.args.channel)
			if gotCustomerId != tt.customerId {
				t.Errorf("GetCustomerIdContentIdFromChannel() got = %v, want %v", gotCustomerId, tt.customerId)
			}
			if gotContentId != tt.contentId {
				t.Errorf("GetCustomerIdContentIdFromChannel() got1 = %v, want %v", gotContentId, tt.contentId)
			}
		})
	}
}

func TestIsLvsChannel(t *testing.T) {
	type args struct {
		channel string
	}
	tests := []struct {
		name string
		args args
		want bool
	}{
		{
			name: "TestIsLvsChannelStarfruit",
			args: args{channel: "aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			want: false,
		},
		{
			name: "TestIsLvsChannelLVS",
			args: args{channel: "lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			want: true,
		},
		{
			name: "TestIsLvsChannelTwitch",
			args: args{channel: "twitch_test"},
			want: false,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := IsLvsChannel(tt.args.channel); got != tt.want {
				t.Errorf("IsLvsChannel() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestIsStarfruitChannel(t *testing.T) {
	type args struct {
		channel string
	}
	tests := []struct {
		name string
		args args
		want bool
	}{
		{
			name: "TestIsStarfruitChannelStarfruit",
			args: args{channel: "aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			want: true,
		},
		{
			name: "TestIsStarfruitChannelLVS",
			args: args{channel: "lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			want: false,
		},
		{
			name: "TestIsStarfruitChannelTwitch",
			args: args{channel: "twitch_test"},
			want: false,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := IsStarfruitChannel(tt.args.channel); got != tt.want {
				t.Errorf("IsStarfruitChannel() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestGetChannelPartsCount(t *testing.T) {
	type args struct {
		channel string
	}
	tests := []struct {
		name string
		args args
		want int
	}{
		{
			name: "TestGetChannelPartsCountStarfruit",
			args: args{channel: "aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			want: 6,
		},
		{
			name: "TestGetChannelPartsCountLVS",
			args: args{channel: "lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			want: 3,
		},
		{
			name: "TestGetChannelPartsCountTwitch",
			args: args{channel: "twitch_test"},
			want: 1,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := getChannelPartsCount(tt.args.channel); got != tt.want {
				t.Errorf("getChannelPartsCount() = %v, want %v", got, tt.want)
			}
		})
	}
}

func TestIsChannelPrefixed(t *testing.T) {
	type args struct {
		channel string
		prefix  string
	}
	tests := []struct {
		name string
		args args
		want bool
	}{
		{
			name: "TestIsChannelPrefixedStarfruit",
			args: args{channel: "aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234", prefix: channelPrefixStarfruit},
			want: true,
		},
		{
			name: "TestIsChannelPrefixedLVS",
			args: args{channel: "lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234", prefix: channelPrefixLVS},
			want: true,
		},
		{
			name: "TestIsChannelPrefixedStarfruitLVS",
			args: args{channel: "aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234", prefix: channelPrefixLVS},
			want: false,
		},
		{
			name: "TestIsChannelPrefixedLVSStarfruit",
			args: args{channel: "lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234", prefix: channelPrefixStarfruit},
			want: false,
		},
		{
			name: "TestIsChannelPrefixedTwitchSF",
			args: args{channel: "twitch_test", prefix: channelPrefixStarfruit},
			want: false,
		},
		{
			name: "TestIsChannelPrefixedTwitchLVS",
			args: args{channel: "twitch_test", prefix: channelPrefixLVS},
			want: false,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if got := isChannelPrefixed(tt.args.channel, tt.args.prefix); got != tt.want {
				t.Errorf("isChannelPrefixed() = %v, want %v", got, tt.want)
			}
		})
	}
}
