package StarfruitSECProducer

import (
	"testing"
)

func TestShouldSendEventsToSEC(t *testing.T) {
	type args struct {
		channel string
	}
	tests := []struct {
		name    string
		args    args
		enable  bool
		message string
	}{
		{
			name:    "TestShouldSendEventsToSECStarfruit",
			args:    args{channel: "aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			enable:  true,
			message: "SEC event processing enabled for Starfruit Channel:aws.svs.us-west-2.956482054022.channel.65ce4cbf-fab9-4d4f-9aa1-0843a3256234",
		},
		{
			name:    "TestShouldSendEventsToSECLVS",
			args:    args{channel: "lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234"},
			enable:  false,
			message: "SEC event processing disabled for LVS Channel:lvs.amazon-live.65ce4cbf-fab9-4d4f-9aa1-0843a3256234",
		},
		{
			name:    "TestShouldSendEventsToSECTwitch",
			args:    args{channel: "twitch_test"},
			enable:  false,
			message: "SEC event processing is disabled for Twitch channels",
			// message: "SEC event processing enabled for all channels including Twitch channels",
		},
		{
			name:    "TestShouldSendEventsToSECTwitchWithDot",
			args:    args{channel: "twitch.test"},
			enable:  false,
			message: "SEC event processing disabled. Unrecognized Channel:twitch.test",
		},
		{
			name:    "TestShouldSendEventsToSECTwitchWithDot",
			args:    args{channel: ""},
			enable:  false,
			message: "SEC event processing is disabled. Channel name is empty",
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			gotEnabled, gotMessage := shouldSendEventsToSEC(tt.args.channel)
			if gotEnabled != tt.enable {
				t.Errorf("shouldSendEventsToSEC() gotEnabled = %v, want %v", gotEnabled, tt.enable)
			}
			if gotMessage != tt.message {
				t.Errorf("shouldSendEventsToSEC() gotMessage = %v, want %v", gotMessage, tt.message)
			}
		})
	}
}
