package StarfruitSECProducer

import (
	"context"

	"code.justin.tv/amzn/StarfruitSECTwirp"
)

// SEC interface containing all the events the SEC client supports
type SEC interface {
	SetStreamId(streamId string)
	// GoIngest events
	SendStarvationStartEvent(ctx context.Context, reason string, extra string) error
	SendStarvationEndEvent(ctx context.Context, reason string, extra string) error
	SendStarvationStatusEvent(ctx context.Context, reason string, extra string) error
	// GoTranscoder events
	SendTranscodeStartedEvent(ctx context.Context, reason string, extra string) error
	SendTranscodeEndedEvent(ctx context.Context, reason string, extra string) error
	SendTranscodeHealthEvent(ctx context.Context, reason string, extra string) error
	// VOD Recording events
	SendVODStartedEvent(ctx context.Context, reason string, extra string) error
	SendVODEndedEvent(ctx context.Context, reason string, extra string) error
	SendRecordingStartedEvent(ctx context.Context, reason string, extra string) error
	SendRecordingStartFailedEvent(ctx context.Context, reason string, extra string) error
	SendRecordingEndedEvent(ctx context.Context, reason string, extra string) error
	SendRecordingEndedWithFailureEvent(ctx context.Context, reason string, extra string) error
	// TCV events
	SendTranscodeRestartedEvent(ctx context.Context, channel string, sessionId string, reason string, extra string) error
	// Limit breach events
	SendCCBLimitExceededEvent(ctx context.Context, customerId string, homeRegion string, limitThreshold int, exceededBy int) error
	SendCCVLimitExceededEvent(ctx context.Context, customerId string, homeRegion string, limitThreshold int, exceededBy int) error
	SendBitrateLimitExceededEvent(ctx context.Context, limitThreshold int, exceededBy int) error
	SendDimensionLimitExceededEvent(ctx context.Context, limitThreshold int, exceededBy int) error
	SendPixelLimitExceededEvent(ctx context.Context, limitThreshold int, exceededBy int) error
	// Digestion events
	SendStreamCreatedEvent(ctx context.Context, channel string, sessionId string, reason string, extra string) error
	SendStreamAuthenticationEvent(ctx context.Context, channel string, sessionId string, reason string, extra string) error
	SendTranscodeCreatedEvent(ctx context.Context, channel string, sessionId string, reason string, extra string) error
	SendStreamDisconnectedEvent(ctx context.Context, channel string, sessionId string, reason string, extra string) error
	SendStreamDeletedEvent(ctx context.Context, channel string, sessionId string, reason string, extra string) error
	// Heartbeat events
	SendTranscodeHeartbeatEvent(ctx context.Context, reason string, extra string) error
	SendStarvationHeartbeatEvent(ctx context.Context, reason string, extra string) error
	SendPerodicTranscodeHeartbeat(ctx context.Context, reason string, extra string)
	// Digestion Events V2
	SendStreamAuthenticationEventV2(ctx context.Context, channel string, sessionId string, reason string, extra string, customerChannelName string) error
	// Stream detail / health details
	SendStreamDetails(ctx context.Context, sds *StarfruitSECTwirp.StreamDetails, reason string) error
	// Stream detail V2 specifically for digestion
	SendStreamDetailsV2(ctx context.Context, channel, sessionId string, sds *StarfruitSECTwirp.StreamDetails, reason string) error
}
