package sdc

import (
	"encoding/json"
	"log"
	"sync"
)

// Struct used for holding the current values from SDC for the application
type sdcConfigs struct {
	enablePublishTranscodeHeartbeat  *bool
	enablePublishStarvationHeartbeat *bool
	forcePublishEventsForTwitch      *bool
	forcePublishEventsForLvs         *bool
	enablePublishEventsToSec         *bool
	transcodeHeartbeatInterval       *int32
	starvationHeartbeatInterval      *int32

	// There are no float64 operations, usually there are no intrinsics for such. Use a mutex
	mu sync.RWMutex
}

func (s *sdcConfigs) Update(update []byte) error {
	var config Configs
	if err := json.Unmarshal(update, &config); err != nil {
		return err
	}
	log.Printf("Updating SDC Config, new config: %v", config)

	s.mu.Lock()
	defer s.mu.Unlock()
	s.enablePublishTranscodeHeartbeat = config.EnablePublishTranscodeHeartbeat
	s.enablePublishStarvationHeartbeat = config.EnablePublishStarvationHeartbeat
	s.enablePublishEventsToSec = config.EnablePublishEventsToSec
	s.forcePublishEventsForLvs = config.ForcePublishEventsForLvs
	s.forcePublishEventsForTwitch = config.ForcePublishEventsForTwitch
	s.starvationHeartbeatInterval = config.StarvationHeartbeatInterval
	s.transcodeHeartbeatInterval = config.TranscodeHeartbeatInterval
	return nil
}
