// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitSECTwirp/twirp.proto

/*
Package StarfruitSECTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/StarfruitSECTwirp/twirp.proto
*/
package StarfruitSECTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ======================
// StarfruitSEC Interface
// ======================

type StarfruitSEC interface {
	GetChannelState(context.Context, *GetChannelStateRequest) (*GetChannelStateResponse, error)

	ListActiveChannels(context.Context, *ListActiveChannelsRequest) (*ListActiveChannelsResponse, error)

	ListStreamEvents(context.Context, *ListStreamEventsRequest) (*ListStreamEventsResponse, error)

	CountActiveChannels(context.Context, *CountActiveChannelsRequest) (*CountActiveChannelsResponse, error)

	ListLimitBreachEvents(context.Context, *ListLimitBreachEventsRequest) (*ListLimitBreachEventsResponse, error)

	ScanCCBCount(context.Context, *ScanCCBCountRequest) (*ScanCCBCountResponse, error)

	ScanActiveStreams(context.Context, *ScanActiveStreamsRequest) (*ScanActiveStreamsResponse, error)

	GetStreamDetails(context.Context, *GetStreamDetailsRequest) (*GetStreamDetailsResponse, error)

	ListStreamDetails(context.Context, *ListStreamDetailsRequest) (*ListStreamDetailsResponse, error)
}

// ============================
// StarfruitSEC Protobuf Client
// ============================

type starfruitSECProtobufClient struct {
	client HTTPClient
	urls   [9]string
	opts   twirp.ClientOptions
}

// NewStarfruitSECProtobufClient creates a Protobuf client that implements the StarfruitSEC interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStarfruitSECProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StarfruitSEC {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StarfruitSECPathPrefix
	urls := [9]string{
		prefix + "GetChannelState",
		prefix + "ListActiveChannels",
		prefix + "ListStreamEvents",
		prefix + "CountActiveChannels",
		prefix + "ListLimitBreachEvents",
		prefix + "ScanCCBCount",
		prefix + "ScanActiveStreams",
		prefix + "GetStreamDetails",
		prefix + "ListStreamDetails",
	}

	return &starfruitSECProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *starfruitSECProtobufClient) GetChannelState(ctx context.Context, in *GetChannelStateRequest) (*GetChannelStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelState")
	out := new(GetChannelStateResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECProtobufClient) ListActiveChannels(ctx context.Context, in *ListActiveChannelsRequest) (*ListActiveChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveChannels")
	out := new(ListActiveChannelsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECProtobufClient) ListStreamEvents(ctx context.Context, in *ListStreamEventsRequest) (*ListStreamEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	out := new(ListStreamEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECProtobufClient) CountActiveChannels(ctx context.Context, in *CountActiveChannelsRequest) (*CountActiveChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "CountActiveChannels")
	out := new(CountActiveChannelsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECProtobufClient) ListLimitBreachEvents(ctx context.Context, in *ListLimitBreachEventsRequest) (*ListLimitBreachEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	out := new(ListLimitBreachEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECProtobufClient) ScanCCBCount(ctx context.Context, in *ScanCCBCountRequest) (*ScanCCBCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ScanCCBCount")
	out := new(ScanCCBCountResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECProtobufClient) ScanActiveStreams(ctx context.Context, in *ScanActiveStreamsRequest) (*ScanActiveStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ScanActiveStreams")
	out := new(ScanActiveStreamsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECProtobufClient) GetStreamDetails(ctx context.Context, in *GetStreamDetailsRequest) (*GetStreamDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamDetails")
	out := new(GetStreamDetailsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECProtobufClient) ListStreamDetails(ctx context.Context, in *ListStreamDetailsRequest) (*ListStreamDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamDetails")
	out := new(ListStreamDetailsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ========================
// StarfruitSEC JSON Client
// ========================

type starfruitSECJSONClient struct {
	client HTTPClient
	urls   [9]string
	opts   twirp.ClientOptions
}

// NewStarfruitSECJSONClient creates a JSON client that implements the StarfruitSEC interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStarfruitSECJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StarfruitSEC {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StarfruitSECPathPrefix
	urls := [9]string{
		prefix + "GetChannelState",
		prefix + "ListActiveChannels",
		prefix + "ListStreamEvents",
		prefix + "CountActiveChannels",
		prefix + "ListLimitBreachEvents",
		prefix + "ScanCCBCount",
		prefix + "ScanActiveStreams",
		prefix + "GetStreamDetails",
		prefix + "ListStreamDetails",
	}

	return &starfruitSECJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *starfruitSECJSONClient) GetChannelState(ctx context.Context, in *GetChannelStateRequest) (*GetChannelStateResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelState")
	out := new(GetChannelStateResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECJSONClient) ListActiveChannels(ctx context.Context, in *ListActiveChannelsRequest) (*ListActiveChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveChannels")
	out := new(ListActiveChannelsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECJSONClient) ListStreamEvents(ctx context.Context, in *ListStreamEventsRequest) (*ListStreamEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	out := new(ListStreamEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECJSONClient) CountActiveChannels(ctx context.Context, in *CountActiveChannelsRequest) (*CountActiveChannelsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "CountActiveChannels")
	out := new(CountActiveChannelsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECJSONClient) ListLimitBreachEvents(ctx context.Context, in *ListLimitBreachEventsRequest) (*ListLimitBreachEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	out := new(ListLimitBreachEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECJSONClient) ScanCCBCount(ctx context.Context, in *ScanCCBCountRequest) (*ScanCCBCountResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ScanCCBCount")
	out := new(ScanCCBCountResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECJSONClient) ScanActiveStreams(ctx context.Context, in *ScanActiveStreamsRequest) (*ScanActiveStreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ScanActiveStreams")
	out := new(ScanActiveStreamsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECJSONClient) GetStreamDetails(ctx context.Context, in *GetStreamDetailsRequest) (*GetStreamDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamDetails")
	out := new(GetStreamDetailsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitSECJSONClient) ListStreamDetails(ctx context.Context, in *ListStreamDetailsRequest) (*ListStreamDetailsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamDetails")
	out := new(ListStreamDetailsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===========================
// StarfruitSEC Server Handler
// ===========================

type starfruitSECServer struct {
	StarfruitSEC
	hooks *twirp.ServerHooks
}

func NewStarfruitSECServer(svc StarfruitSEC, hooks *twirp.ServerHooks) TwirpServer {
	return &starfruitSECServer{
		StarfruitSEC: svc,
		hooks:        hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *starfruitSECServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StarfruitSECPathPrefix is used for all URL paths on a twirp StarfruitSEC server.
// Requests are always: POST StarfruitSECPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StarfruitSECPathPrefix = "/twirp/twitch.video.starfruitsec.StarfruitSEC/"

func (s *starfruitSECServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruitsec")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitSEC")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/GetChannelState":
		s.serveGetChannelState(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/ListActiveChannels":
		s.serveListActiveChannels(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/ListStreamEvents":
		s.serveListStreamEvents(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/CountActiveChannels":
		s.serveCountActiveChannels(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/ListLimitBreachEvents":
		s.serveListLimitBreachEvents(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/ScanCCBCount":
		s.serveScanCCBCount(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/ScanActiveStreams":
		s.serveScanActiveStreams(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/GetStreamDetails":
		s.serveGetStreamDetails(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruitsec.StarfruitSEC/ListStreamDetails":
		s.serveListStreamDetails(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *starfruitSECServer) serveGetChannelState(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelStateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelStateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveGetChannelStateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetChannelStateRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.GetChannelState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelStateResponse and nil error while calling GetChannelState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveGetChannelStateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelState")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetChannelStateRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetChannelStateResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.GetChannelState(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelStateResponse and nil error while calling GetChannelState. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveListActiveChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListActiveChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListActiveChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveListActiveChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListActiveChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ListActiveChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveChannelsResponse and nil error while calling ListActiveChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveListActiveChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListActiveChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListActiveChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListActiveChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ListActiveChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListActiveChannelsResponse and nil error while calling ListActiveChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveListStreamEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveListStreamEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListStreamEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ListStreamEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamEventsResponse and nil error while calling ListStreamEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveListStreamEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListStreamEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ListStreamEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamEventsResponse and nil error while calling ListStreamEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveCountActiveChannels(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCountActiveChannelsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCountActiveChannelsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveCountActiveChannelsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CountActiveChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CountActiveChannelsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CountActiveChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.CountActiveChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CountActiveChannelsResponse and nil error while calling CountActiveChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveCountActiveChannelsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CountActiveChannels")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CountActiveChannelsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CountActiveChannelsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.CountActiveChannels(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CountActiveChannelsResponse and nil error while calling CountActiveChannels. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveListLimitBreachEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListLimitBreachEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListLimitBreachEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveListLimitBreachEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListLimitBreachEventsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListLimitBreachEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ListLimitBreachEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListLimitBreachEventsResponse and nil error while calling ListLimitBreachEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveListLimitBreachEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListLimitBreachEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListLimitBreachEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ListLimitBreachEvents(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListLimitBreachEventsResponse and nil error while calling ListLimitBreachEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveScanCCBCount(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveScanCCBCountJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveScanCCBCountProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveScanCCBCountJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanCCBCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ScanCCBCountRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanCCBCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ScanCCBCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanCCBCountResponse and nil error while calling ScanCCBCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveScanCCBCountProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanCCBCount")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ScanCCBCountRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanCCBCountResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ScanCCBCount(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanCCBCountResponse and nil error while calling ScanCCBCount. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveScanActiveStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveScanActiveStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveScanActiveStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveScanActiveStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanActiveStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ScanActiveStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanActiveStreamsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ScanActiveStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanActiveStreamsResponse and nil error while calling ScanActiveStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveScanActiveStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanActiveStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ScanActiveStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanActiveStreamsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ScanActiveStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanActiveStreamsResponse and nil error while calling ScanActiveStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveGetStreamDetails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamDetailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamDetailsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveGetStreamDetailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetStreamDetailsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetStreamDetailsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.GetStreamDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetStreamDetailsResponse and nil error while calling GetStreamDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveGetStreamDetailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetStreamDetailsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetStreamDetailsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.GetStreamDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetStreamDetailsResponse and nil error while calling GetStreamDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveListStreamDetails(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamDetailsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamDetailsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitSECServer) serveListStreamDetailsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListStreamDetailsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamDetailsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ListStreamDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamDetailsResponse and nil error while calling ListStreamDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) serveListStreamDetailsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamDetails")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ListStreamDetailsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ListStreamDetailsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitSEC.ListStreamDetails(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListStreamDetailsResponse and nil error while calling ListStreamDetails. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitSECServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *starfruitSECServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *starfruitSECServer) PathPrefix() string {
	return StarfruitSECPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 3068 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x3a, 0xcb, 0x8e, 0xdb, 0xd6,
	0xd9, 0xe6, 0x68, 0x2e, 0xd2, 0xa7, 0x1b, 0xe7, 0x68, 0x2e, 0xb2, 0x6c, 0xc7, 0x0e, 0xff, 0xdf,
	0x71, 0x32, 0x45, 0x67, 0x9c, 0x19, 0x27, 0x8d, 0x81, 0x26, 0x81, 0x2e, 0xb4, 0x47, 0x88, 0x2c,
	0x0d, 0x28, 0x79, 0x9c, 0xb8, 0x05, 0x08, 0x8a, 0x3c, 0x33, 0x62, 0x47, 0x43, 0x2a, 0x24, 0x35,
	0xb6, 0x52, 0x20, 0x68, 0x81, 0xa2, 0x8b, 0x74, 0xd1, 0x65, 0x81, 0xa2, 0x40, 0x17, 0xdd, 0x74,
	0xd9, 0x4d, 0xfb, 0x08, 0x5d, 0x14, 0x79, 0x86, 0xbe, 0x40, 0x5f, 0xa0, 0x5d, 0x14, 0x28, 0xce,
	0x85, 0x14, 0x49, 0x5d, 0xc7, 0xcd, 0xa6, 0x9b, 0xc1, 0xf0, 0xbb, 0x9d, 0xef, 0x7e, 0xbe, 0x73,
	0x8e, 0xe0, 0x7d, 0xdd, 0x36, 0xf0, 0xfe, 0x4f, 0x86, 0xae, 0x67, 0x5a, 0xfb, 0xde, 0xd5, 0x81,
	0x76, 0xf9, 0x95, 0x75, 0xd0, 0xf6, 0x34, 0xe7, 0xcc, 0x19, 0x9a, 0x5e, 0x5b, 0xae, 0x76, 0x5e,
	0x99, 0xce, 0xe0, 0xc0, 0x23, 0x7f, 0xf7, 0x07, 0x8e, 0xed, 0xd9, 0xe8, 0xa6, 0xf7, 0xca, 0xf4,
	0xf4, 0xde, 0xfe, 0x95, 0x69, 0x60, 0x7b, 0xdf, 0xf5, 0x69, 0x5d, 0xac, 0x97, 0xee, 0x9e, 0xdb,
	0xf6, 0x79, 0x1f, 0x1f, 0x50, 0xc2, 0xee, 0xf0, 0xec, 0xc0, 0x33, 0x2f, 0xb1, 0xeb, 0x69, 0x97,
	0x9c, 0xb7, 0xf4, 0x56, 0x9c, 0xe0, 0x95, 0xa3, 0x0d, 0x06, 0xd8, 0x71, 0x19, 0x5e, 0x7a, 0x09,
	0xb9, 0x86, 0x79, 0x69, 0x7a, 0xf2, 0x6b, 0xcf, 0xd1, 0x6a, 0x9a, 0xa7, 0xa1, 0x07, 0x90, 0xef,
	0x13, 0x88, 0xea, 0xf5, 0x1c, 0xec, 0xf6, 0xec, 0xbe, 0x51, 0x14, 0xee, 0x09, 0xef, 0x26, 0x94,
	0x1c, 0x05, 0x77, 0x7c, 0x28, 0xba, 0x0b, 0x69, 0xfc, 0x5a, 0xc7, 0xd8, 0xc0, 0x86, 0xda, 0x1d,
	0x15, 0x57, 0x28, 0x11, 0xf8, 0xa0, 0xca, 0x48, 0xfa, 0x7b, 0x02, 0xf2, 0x6d, 0xcf, 0xc1, 0xda,
	0xa5, 0x7c, 0x85, 0x2d, 0x8f, 0x4a, 0xbf, 0x03, 0x80, 0xc9, 0x87, 0x3a, 0x1c, 0x9a, 0x4c, 0x70,
	0x46, 0x49, 0x51, 0xc8, 0xf3, 0xa1, 0x69, 0xa0, 0xc7, 0x3e, 0x9a, 0xd8, 0x41, 0x45, 0xa6, 0x0f,
	0x4b, 0xfb, 0xcc, 0x86, 0x7d, 0xdf, 0x86, 0xfd, 0x8e, 0x6f, 0x24, 0x67, 0x25, 0xdf, 0x44, 0x1d,
	0xbd, 0xa7, 0x59, 0x16, 0xee, 0xab, 0x9a, 0x63, 0x15, 0x13, 0xf7, 0x84, 0x77, 0x53, 0x0a, 0x70,
	0x50, 0xd9, 0xb1, 0xd0, 0xdb, 0x90, 0xf1, 0x09, 0x2c, 0xed, 0x12, 0x17, 0x57, 0x29, 0x85, 0xcf,
	0xd4, 0xd4, 0xb8, 0x8c, 0xa1, 0xeb, 0xd9, 0x97, 0xd8, 0x51, 0x4d, 0xa3, 0xb8, 0xc6, 0x65, 0x70,
	0x50, 0xdd, 0x40, 0x0f, 0x61, 0xab, 0xeb, 0xd8, 0x9a, 0xa1, 0x6b, 0xae, 0xa7, 0xba, 0xd8, 0x75,
	0x4d, 0xdb, 0x22, 0x94, 0xeb, 0x94, 0x12, 0x05, 0xb8, 0x36, 0x43, 0xd5, 0x0d, 0x74, 0x0b, 0x52,
	0xb6, 0x63, 0x9e, 0x9b, 0x96, 0x6a, 0xe8, 0xc5, 0x0d, 0x4a, 0x96, 0x64, 0x80, 0x9a, 0x3e, 0xf6,
	0x06, 0x55, 0x28, 0x49, 0xb1, 0xcc, 0x24, 0x5f, 0x1d, 0x86, 0x3e, 0x77, 0xec, 0xe1, 0xa0, 0x98,
	0x62, 0xea, 0x50, 0xd0, 0x53, 0x02, 0x41, 0x3b, 0xb0, 0xee, 0x60, 0xcd, 0xb5, 0xad, 0x22, 0x50,
	0x1c, 0xff, 0x42, 0x5b, 0xb0, 0x86, 0x49, 0x40, 0x8b, 0x69, 0x0a, 0x66, 0x1f, 0x44, 0x15, 0x97,
	0x86, 0x83, 0x68, 0x9c, 0x61, 0xaa, 0x30, 0x40, 0xdd, 0x40, 0x87, 0xb0, 0x1d, 0x98, 0x1e, 0x71,
	0x53, 0x96, 0x12, 0x16, 0x7c, 0x64, 0x75, 0xec, 0x2e, 0xe9, 0xd7, 0x02, 0xa0, 0x50, 0x80, 0xdb,
	0xc3, 0xcb, 0x4b, 0xcd, 0x19, 0xc5, 0xac, 0x12, 0x16, 0x58, 0xb5, 0x32, 0x61, 0x55, 0x34, 0x09,
	0x12, 0xd7, 0x48, 0x02, 0xe9, 0xdb, 0x55, 0x10, 0xb9, 0x86, 0x6d, 0x4f, 0xf3, 0x30, 0xcd, 0xb9,
	0x58, 0x66, 0x08, 0x13, 0x99, 0xf1, 0x04, 0x36, 0xb9, 0x63, 0x48, 0x71, 0x2d, 0x9d, 0x7c, 0x79,
	0xc6, 0x44, 0x8a, 0x97, 0xa5, 0xe0, 0xdb, 0x90, 0x19, 0xcb, 0xf1, 0x30, 0xcf, 0xc1, 0x74, 0x40,
	0xe6, 0x61, 0x74, 0x0c, 0x28, 0x4c, 0xa2, 0xba, 0xa6, 0xa5, 0xb3, 0x54, 0x9c, 0xbf, 0x96, 0x18,
	0x12, 0xd2, 0x26, 0x3c, 0x64, 0xb1, 0x1e, 0xd6, 0xfa, 0x5e, 0x8f, 0x2f, 0xc6, 0x92, 0x35, 0xcd,
	0x60, 0xc1, 0x62, 0x61, 0x12, 0xbe, 0xd8, 0xfa, 0xe2, 0xc5, 0x42, 0x42, 0xd8, 0x62, 0x15, 0xc8,
	0x5f, 0xd9, 0x46, 0x44, 0x4c, 0x72, 0xa1, 0x98, 0xec, 0x95, 0x6d, 0x84, 0x64, 0xdc, 0x82, 0x54,
	0x20, 0x83, 0xe7, 0x72, 0xd2, 0xa7, 0x88, 0xe6, 0x26, 0xc4, 0x72, 0xb3, 0x09, 0xdb, 0x0e, 0xd6,
	0x6d, 0xc7, 0x30, 0xad, 0xf3, 0x88, 0x0e, 0xe9, 0x85, 0x3a, 0x14, 0x02, 0xc6, 0x90, 0x26, 0x0f,
	0x20, 0x1f, 0x93, 0xc7, 0xcb, 0x21, 0x17, 0xa5, 0x96, 0x4e, 0x61, 0x2b, 0xd6, 0xc0, 0x2a, 0x9a,
	0xa7, 0xf7, 0xd0, 0x27, 0xb0, 0x6a, 0x68, 0x9e, 0x56, 0x14, 0xee, 0x25, 0xde, 0x4d, 0x1f, 0xee,
	0xed, 0xcf, 0x6c, 0xd0, 0xfb, 0x31, 0x76, 0x85, 0xf2, 0x49, 0x7f, 0x15, 0xe0, 0x66, 0xc3, 0x74,
	0xbd, 0xb2, 0xee, 0x99, 0x57, 0x98, 0x27, 0xac, 0xab, 0xe0, 0x2f, 0x87, 0xd8, 0xf5, 0xe2, 0x5d,
	0x48, 0x98, 0xe8, 0x42, 0x77, 0x00, 0x06, 0xda, 0x39, 0x56, 0x3d, 0xfb, 0x02, 0x5b, 0xbc, 0x80,
	0x52, 0x04, 0xd2, 0x21, 0x00, 0xe2, 0x4b, 0x8a, 0x76, 0xcd, 0xaf, 0x58, 0x0e, 0xae, 0x29, 0x49,
	0x02, 0x68, 0x9b, 0x5f, 0x61, 0xd4, 0x80, 0x2c, 0x77, 0x34, 0x0b, 0x32, 0xcd, 0xbd, 0xdc, 0xe1,
	0x83, 0x85, 0x36, 0x1c, 0x53, 0x72, 0x85, 0x67, 0x38, 0xfb, 0x92, 0xfe, 0x28, 0x40, 0x69, 0x9a,
	0x21, 0xee, 0xc0, 0xb6, 0x5c, 0x8c, 0xba, 0xb0, 0xeb, 0x57, 0x1e, 0x0b, 0x1b, 0xb1, 0x5e, 0xed,
	0x9b, 0xae, 0xc7, 0x5d, 0xf7, 0xbd, 0x39, 0xcb, 0xc6, 0xeb, 0x58, 0xd9, 0xd2, 0x63, 0x10, 0xb2,
	0x32, 0x7a, 0x07, 0xf2, 0x16, 0x7e, 0xed, 0xa9, 0x13, 0x1e, 0xc9, 0x12, 0xf0, 0x89, 0xef, 0x15,
	0xe9, 0x31, 0xec, 0x3c, 0xc5, 0x5e, 0x58, 0x68, 0xd8, 0xdf, 0xf3, 0xfa, 0x83, 0xe4, 0xc1, 0xee,
	0x04, 0x2b, 0xb7, 0xf0, 0x0b, 0x40, 0x93, 0x16, 0x52, 0x11, 0xd7, 0x34, 0x4e, 0x8c, 0x1b, 0x27,
	0xf5, 0x61, 0x97, 0x18, 0x18, 0xca, 0x20, 0x77, 0x59, 0x8d, 0x67, 0xee, 0x53, 0x2b, 0xb3, 0xf6,
	0x29, 0xe9, 0x02, 0x8a, 0x93, 0xab, 0x71, 0x23, 0x5b, 0x41, 0xce, 0xd0, 0x4e, 0xeb, 0xbe, 0x41,
	0xde, 0xf3, 0xb4, 0x61, 0x82, 0xa5, 0x8f, 0xa1, 0x54, 0xb5, 0x87, 0xd6, 0x1b, 0xe6, 0xbf, 0xd4,
	0x82, 0x5b, 0x53, 0xd9, 0xb9, 0xba, 0x0f, 0x61, 0x4b, 0xa3, 0x98, 0x60, 0x23, 0xd3, 0x09, 0x35,
	0x1f, 0x63, 0x90, 0x16, 0xe6, 0xa2, 0x72, 0xa4, 0xdf, 0x0a, 0x70, 0x9b, 0x58, 0x4f, 0x47, 0xa1,
	0x8a, 0x83, 0x35, 0xbd, 0x37, 0xe9, 0xf0, 0xef, 0xb4, 0x24, 0x13, 0xa1, 0x92, 0xbc, 0x03, 0x10,
	0x0a, 0x11, 0x1b, 0x4b, 0x52, 0x6e, 0x10, 0x99, 0x3f, 0x08, 0x70, 0x67, 0x86, 0x72, 0xdc, 0xe0,
	0x97, 0x50, 0x60, 0x23, 0x5b, 0x97, 0x62, 0xdf, 0x3c, 0x4a, 0x9b, 0xfd, 0xf8, 0x1a, 0x4b, 0x97,
	0xd7, 0x6f, 0x04, 0xd8, 0x55, 0x22, 0xdd, 0x73, 0x3c, 0x52, 0xfe, 0x3f, 0xe4, 0xdc, 0x23, 0xb5,
	0x3b, 0xd4, 0x2f, 0x70, 0x64, 0x28, 0xc8, 0xb8, 0x47, 0x15, 0x0a, 0xa4, 0x73, 0x81, 0x04, 0x59,
	0xf7, 0x48, 0xbd, 0xc0, 0x23, 0x75, 0xe0, 0xe0, 0x33, 0xf3, 0x35, 0x5f, 0x27, 0xed, 0x1e, 0x7d,
	0x86, 0x47, 0x27, 0x14, 0x44, 0xa6, 0x14, 0xf7, 0x48, 0x1d, 0x37, 0x6f, 0x63, 0xe8, 0x68, 0x9e,
	0x69, 0x5b, 0xdc, 0xa7, 0x05, 0xf7, 0x28, 0xd0, 0xa1, 0xc6, 0x51, 0xd2, 0x29, 0x14, 0xda, 0xba,
	0x66, 0x55, 0xab, 0x15, 0x1a, 0x6c, 0x3f, 0xa4, 0x45, 0xd8, 0x70, 0xf1, 0xf9, 0x25, 0x0e, 0x12,
	0xc3, 0xff, 0x44, 0xf7, 0x21, 0xe7, 0xd9, 0x9e, 0xd6, 0x57, 0x39, 0xc0, 0xe5, 0xb3, 0x6d, 0x96,
	0x42, 0xdb, 0x1c, 0x28, 0x61, 0xd8, 0x8a, 0xca, 0xe5, 0xd1, 0x78, 0x06, 0x49, 0x5d, 0xef, 0xaa,
	0xa6, 0x75, 0x66, 0xf3, 0x10, 0x1c, 0xce, 0x09, 0x41, 0xc5, 0x2f, 0xc5, 0xba, 0x75, 0x66, 0x9f,
	0x60, 0xa7, 0xac, 0xd3, 0x64, 0x55, 0x36, 0x74, 0xbd, 0x4b, 0x40, 0xd2, 0xef, 0x57, 0x60, 0x77,
	0x06, 0xd1, 0xe2, 0xb4, 0xbc, 0x05, 0x29, 0x66, 0x8a, 0xae, 0x77, 0xb9, 0x15, 0x49, 0x0a, 0xa8,
	0xea, 0x5d, 0xa4, 0x42, 0x81, 0x28, 0xda, 0x1d, 0x05, 0x75, 0xe2, 0x8d, 0x06, 0xfe, 0xc0, 0xf5,
	0x70, 0x5e, 0xf3, 0xaa, 0x56, 0x2a, 0x23, 0x5e, 0x40, 0x9d, 0xd1, 0x00, 0x33, 0xfb, 0x45, 0x5d,
	0xef, 0x46, 0xc0, 0x08, 0xc3, 0x76, 0x6c, 0x81, 0xd0, 0x9e, 0x33, 0xdf, 0x2d, 0xe1, 0x25, 0xd8,
	0x5e, 0xc3, 0x16, 0x41, 0xe1, 0x45, 0xf8, 0x26, 0xa4, 0xc2, 0xf6, 0x54, 0x8d, 0x88, 0x7b, 0xba,
	0x9a, 0x6b, 0xea, 0x91, 0xfa, 0x07, 0x0a, 0x62, 0x04, 0xf7, 0x21, 0xe7, 0x7a, 0x9a, 0x65, 0x68,
	0x8e, 0xc1, 0x69, 0x78, 0xa4, 0x7d, 0x28, 0x6b, 0x0f, 0xdf, 0x08, 0xb0, 0x3b, 0x43, 0x21, 0xf4,
	0x7f, 0x90, 0x1d, 0x5a, 0x17, 0x96, 0xfd, 0xca, 0x8a, 0xac, 0x92, 0xe1, 0xc0, 0xf0, 0x3a, 0xce,
	0x15, 0x49, 0xd9, 0xf8, 0x3a, 0x14, 0x1a, 0xc8, 0x62, 0x0e, 0x1a, 0x71, 0x2a, 0x96, 0xd5, 0x7c,
	0xce, 0x1b, 0x31, 0x65, 0x2c, 0xd8, 0x2e, 0x1b, 0x86, 0x49, 0x52, 0x5b, 0xeb, 0x73, 0x85, 0x48,
	0x5a, 0x90, 0x81, 0x70, 0xe0, 0x98, 0x3a, 0x59, 0xe3, 0xd2, 0x36, 0xfc, 0x1a, 0x4b, 0x73, 0xd8,
	0x33, 0xdb, 0xc0, 0xa4, 0x7c, 0x06, 0x7d, 0x6d, 0xd4, 0xd5, 0xf4, 0x0b, 0xb5, 0xaf, 0x79, 0xd8,
	0xd2, 0x47, 0x8c, 0x96, 0x95, 0x5a, 0xc1, 0x47, 0x36, 0x18, 0x8e, 0xf0, 0x48, 0x3f, 0x82, 0x22,
	0x49, 0x73, 0xd6, 0x6b, 0x59, 0xc3, 0x70, 0xbf, 0xb3, 0x1a, 0xb2, 0xe1, 0xe6, 0x14, 0xe1, 0xbc,
	0x90, 0x14, 0xc8, 0xf1, 0x3e, 0xce, 0x36, 0x0f, 0x77, 0x89, 0xa1, 0x21, 0x2c, 0x89, 0xb6, 0xb4,
	0xac, 0x16, 0x96, 0x2d, 0xfd, 0x43, 0x00, 0x31, 0x4e, 0xb3, 0xb8, 0x8c, 0x62, 0xfb, 0xed, 0xca,
	0xc4, 0x7e, 0xfb, 0x1e, 0x88, 0xc1, 0xa1, 0xc9, 0xd4, 0x2f, 0x68, 0x8f, 0x63, 0xd3, 0x7f, 0xde,
	0x3f, 0x5f, 0x72, 0x30, 0x69, 0x73, 0xe6, 0x95, 0xab, 0x8e, 0xa7, 0x5d, 0x7e, 0x0e, 0x35, 0xaf,
	0xdc, 0xb6, 0x3f, 0xf0, 0x4e, 0x3d, 0x90, 0xac, 0x5d, 0xfb, 0x40, 0x22, 0xfd, 0x79, 0x05, 0xb6,
	0x82, 0x8d, 0xce, 0x3a, 0x33, 0xcf, 0x79, 0x4f, 0x44, 0x9f, 0x4e, 0xc9, 0x95, 0xf4, 0xe1, 0xed,
	0x09, 0xd9, 0x6d, 0xcf, 0x31, 0xad, 0xf3, 0x53, 0xad, 0x3f, 0xc4, 0xd1, 0x4c, 0x3a, 0x99, 0x97,
	0x49, 0x8b, 0x24, 0x4d, 0xcb, 0x33, 0x74, 0x02, 0x3b, 0x81, 0x44, 0x6d, 0xe8, 0xf5, 0x54, 0x07,
	0x7f, 0x39, 0x34, 0x1d, 0x6c, 0xcc, 0x3c, 0x01, 0x56, 0x6c, 0xbb, 0xcf, 0x04, 0x6e, 0xf9, 0x9c,
	0xe5, 0xa1, 0xd7, 0x53, 0x38, 0x1f, 0xfa, 0x08, 0x92, 0x41, 0x30, 0x56, 0x97, 0x50, 0x2b, 0xa0,
	0x96, 0xfe, 0xb9, 0x0e, 0x85, 0xba, 0x75, 0x8e, 0x5d, 0x2f, 0xea, 0xb6, 0x0f, 0x61, 0x03, 0x5b,
	0xba, 0x6d, 0x60, 0x67, 0x29, 0x8f, 0xf9, 0xc4, 0xe8, 0x63, 0x48, 0x6b, 0x57, 0xba, 0x3a, 0x70,
	0xec, 0x33, 0xb3, 0xbf, 0x9c, 0x8f, 0x40, 0xbb, 0xd2, 0x4f, 0x18, 0x3d, 0x7a, 0x0c, 0x29, 0xc2,
	0xde, 0xc7, 0x57, 0xb8, 0xcf, 0xbd, 0xb1, 0xc0, 0x12, 0xed, 0x4a, 0x6f, 0x10, 0x6a, 0xf4, 0x09,
	0x64, 0x68, 0x95, 0xa8, 0x3d, 0x6c, 0x9e, 0xf7, 0x3c, 0xee, 0x87, 0x5b, 0x13, 0xdc, 0x75, 0xcb,
	0xfb, 0xf0, 0x11, 0x8f, 0x33, 0x65, 0x38, 0xa6, 0xf4, 0xe8, 0x87, 0xc0, 0x3e, 0xd5, 0x57, 0xa6,
	0xe1, 0xf5, 0x78, 0x0e, 0xce, 0x65, 0x07, 0x4a, 0xff, 0x82, 0x90, 0xa3, 0x2a, 0xe4, 0x3c, 0xcd,
	0x39, 0xc7, 0x9e, 0xda, 0x35, 0x3d, 0x87, 0x9c, 0xb3, 0xd6, 0x97, 0xd0, 0x3e, 0xcb, 0x78, 0x2a,
	0x8c, 0x05, 0x3d, 0x01, 0x91, 0x0b, 0x39, 0x73, 0xb4, 0x4b, 0x4c, 0xc5, 0x6c, 0x2c, 0xd6, 0x23,
	0xcf, 0x98, 0x9e, 0xf8, 0x3c, 0x24, 0x08, 0xcc, 0x14, 0x12, 0x13, 0x9d, 0x9f, 0x5f, 0x17, 0x04,
	0x81, 0x32, 0x54, 0x09, 0x3d, 0x8d, 0xe1, 0xd0, 0x30, 0x7d, 0xf6, 0xd4, 0x52, 0x31, 0x24, 0x0c,
	0x8c, 0xbd, 0x09, 0x5b, 0xdc, 0x0a, 0x26, 0xc5, 0x77, 0x08, 0x2c, 0x21, 0x07, 0x31, 0xce, 0x32,
	0x61, 0xf4, 0xbd, 0xf2, 0x14, 0x36, 0x99, 0x20, 0x57, 0xbb, 0x1c, 0xf4, 0xb1, 0x4a, 0x85, 0xa5,
	0x97, 0x70, 0x0b, 0xe5, 0x6a, 0x53, 0x26, 0x85, 0x5d, 0x12, 0x44, 0x05, 0xd1, 0x11, 0x35, 0xb3,
	0x84, 0x56, 0x61, 0x49, 0x74, 0x8e, 0xad, 0x42, 0x8e, 0x7b, 0x88, 0x4f, 0xe4, 0xf4, 0xee, 0x68,
	0x61, 0xb4, 0x99, 0x93, 0x38, 0x8b, 0xa4, 0xc2, 0x4e, 0x30, 0xc2, 0x45, 0x8b, 0x4f, 0x86, 0xbc,
	0x81, 0x5d, 0xcf, 0xb4, 0xe8, 0x67, 0x70, 0xf0, 0x59, 0x24, 0x3f, 0x17, 0x62, 0x22, 0x87, 0xb9,
	0xbf, 0x25, 0x20, 0xcb, 0x7b, 0x3f, 0xf6, 0x34, 0xb3, 0xef, 0x2e, 0x3e, 0x4d, 0x45, 0x2e, 0x27,
	0x56, 0x62, 0x97, 0x13, 0x8f, 0x01, 0x42, 0x4d, 0x7a, 0x89, 0xdb, 0x2a, 0x37, 0xb8, 0x2f, 0xfa,
	0x00, 0x92, 0xd8, 0x32, 0x18, 0xe3, 0xe2, 0x2b, 0xa0, 0x0d, 0x6c, 0x19, 0x94, 0xed, 0x14, 0x72,
	0xe3, 0x83, 0x0d, 0xf1, 0x10, 0x2f, 0xcb, 0x83, 0xc5, 0xe7, 0xcd, 0x88, 0x47, 0x95, 0xac, 0x1e,
	0x86, 0xa2, 0x36, 0x64, 0x4d, 0xda, 0xf4, 0x7c, 0xb1, 0xac, 0x58, 0xf7, 0xe7, 0x88, 0x9d, 0xd2,
	0x24, 0x95, 0x8c, 0x19, 0x02, 0xa2, 0x1f, 0x83, 0x38, 0x1e, 0xd7, 0xb9, 0x5c, 0x56, 0xbd, 0xef,
	0xcf, 0x91, 0x3b, 0x3d, 0x05, 0x94, 0xf1, 0xb5, 0x0d, 0x83, 0x4b, 0xff, 0x5e, 0x87, 0x62, 0x24,
	0x98, 0xe5, 0x93, 0x7a, 0x30, 0x3f, 0xfc, 0xaf, 0xc5, 0x35, 0x3e, 0xc0, 0xad, 0x5d, 0x63, 0x80,
	0x5b, 0x9f, 0x39, 0xc0, 0xa1, 0x47, 0x33, 0x37, 0x56, 0x12, 0x87, 0xe4, 0x8c, 0xcd, 0xb3, 0x14,
	0xda, 0x3c, 0xd9, 0xc5, 0x74, 0xf0, 0x4d, 0xc6, 0x3e, 0x7f, 0x1b, 0x64, 0xf7, 0x78, 0xc1, 0x46,
	0x77, 0x37, 0xba, 0xd1, 0xb1, 0x8b, 0xbc, 0xf0, 0x56, 0x76, 0x2b, 0xbc, 0x95, 0xb1, 0xdb, 0xe9,
	0xf1, 0x66, 0xf5, 0x76, 0x6c, 0xb3, 0xca, 0xd0, 0x91, 0x31, 0xb2, 0x1f, 0xdd, 0x8d, 0xee, 0x47,
	0x59, 0x36, 0xd2, 0x87, 0xb6, 0x9c, 0xfb, 0x13, 0x5b, 0x4e, 0x8e, 0x1d, 0x57, 0xa3, 0x9b, 0xca,
	0x7b, 0x53, 0x36, 0x95, 0x3c, 0x15, 0x36, 0xb1, 0x6f, 0xdc, 0x8d, 0xee, 0x1b, 0x22, 0xb3, 0x29,
	0xb4, 0x33, 0xdc, 0x8d, 0xee, 0x0c, 0x9b, 0xdc, 0xe8, 0x71, 0xef, 0x7f, 0x38, 0xa3, 0xf7, 0x23,
	0x76, 0x1b, 0x33, 0xa5, 0xbb, 0xef, 0x4d, 0xeb, 0xee, 0x05, 0xa6, 0x5f, 0xbc, 0x81, 0xef, 0x4d,
	0x6b, 0xe0, 0x5b, 0x6c, 0xf8, 0x8c, 0xb7, 0xe8, 0xfb, 0x13, 0x2d, 0x7a, 0x9b, 0x79, 0x27, 0xd2,
	0x84, 0xd1, 0x83, 0xc9, 0x56, 0xbb, 0xc3, 0x2e, 0x48, 0x63, 0xcd, 0xf4, 0x05, 0xbd, 0x19, 0x8b,
	0x54, 0xe0, 0xd2, 0x77, 0x54, 0xf3, 0xaa, 0x4f, 0xfa, 0x93, 0x00, 0xc5, 0x49, 0xc9, 0xbc, 0xb0,
	0x65, 0x58, 0x8f, 0x5c, 0x71, 0x7c, 0x7f, 0xb9, 0x2b, 0x0e, 0xfe, 0x3e, 0xa1, 0x70, 0x66, 0xf4,
	0x0c, 0x36, 0x0c, 0x26, 0x99, 0x4f, 0x64, 0x47, 0x0b, 0xe5, 0x4c, 0x76, 0x19, 0xc5, 0x97, 0x21,
	0x7d, 0x2b, 0x40, 0x21, 0x4c, 0xe5, 0x3f, 0x87, 0x44, 0xec, 0x14, 0xe6, 0x76, 0x99, 0x95, 0x37,
	0xed, 0x32, 0x89, 0xe5, 0xbb, 0xcc, 0x3b, 0x90, 0xef, 0x69, 0xae, 0x8a, 0x1d, 0xc7, 0x76, 0xd8,
	0x4d, 0x11, 0xed, 0x51, 0x49, 0x25, 0xdb, 0xd3, 0x5c, 0x99, 0x40, 0xa9, 0xb3, 0xa4, 0x57, 0xe1,
	0x0b, 0xc1, 0xeb, 0xc6, 0xf6, 0xbf, 0xb8, 0x0e, 0x93, 0x7e, 0xc7, 0x2f, 0xc7, 0xa7, 0xc7, 0xfe,
	0x05, 0xe4, 0x5d, 0xe6, 0x58, 0xd5, 0x0f, 0x1e, 0x4b, 0x82, 0xfd, 0x25, 0x83, 0xe7, 0x67, 0x41,
	0x8e, 0x8b, 0xf1, 0xa7, 0x80, 0x25, 0x2f, 0xba, 0xf6, 0x7e, 0xb9, 0x06, 0x29, 0x39, 0x78, 0xcc,
	0xda, 0x84, 0xec, 0xf3, 0xe6, 0x67, 0xcd, 0xd6, 0x8b, 0xa6, 0x2a, 0x9f, 0xca, 0xcd, 0x8e, 0x78,
	0x03, 0xed, 0x00, 0x6a, 0x77, 0xca, 0xca, 0x69, 0xb9, 0x53, 0x6f, 0x35, 0x55, 0xf2, 0x6f, 0x47,
	0xae, 0x89, 0x02, 0xda, 0x02, 0x31, 0x04, 0x97, 0x9b, 0x35, 0xb9, 0x26, 0xae, 0xa0, 0x9b, 0xb0,
	0xdd, 0xee, 0x28, 0x72, 0xf9, 0x99, 0x5a, 0x7e, 0xde, 0x39, 0x96, 0x9b, 0x9d, 0x7a, 0x95, 0x12,
	0x88, 0x09, 0x84, 0x20, 0xc7, 0x51, 0x55, 0x45, 0x2e, 0x13, 0x21, 0xab, 0x68, 0x17, 0x0a, 0x1c,
	0x56, 0xab, 0xb7, 0xab, 0xad, 0x66, 0x53, 0xae, 0x12, 0xc4, 0x5a, 0x88, 0xb8, 0x26, 0x37, 0x64,
	0x02, 0x5b, 0x47, 0x79, 0x48, 0x9f, 0xb6, 0x6a, 0x81, 0x0a, 0x1b, 0x28, 0x0b, 0x29, 0x02, 0x60,
	0x6b, 0x27, 0xd1, 0x36, 0x6c, 0x76, 0x94, 0x72, 0xb3, 0x5d, 0x6d, 0xd5, 0xe4, 0x60, 0x8d, 0x54,
	0x14, 0xec, 0x33, 0x03, 0x2a, 0x40, 0x7e, 0x0c, 0x66, 0x22, 0xd2, 0x44, 0x9f, 0x31, 0x50, 0x91,
	0x7d, 0xea, 0x0c, 0xf1, 0x42, 0xb5, 0x5a, 0x51, 0x1b, 0xf5, 0x67, 0xf5, 0x8e, 0x2a, 0x7f, 0x5e,
	0x95, 0x65, 0xc2, 0x90, 0x65, 0xf0, 0xd3, 0x38, 0x3c, 0x87, 0x4a, 0xb0, 0x53, 0xa9, 0x77, 0x94,
	0x72, 0x47, 0x8e, 0xe3, 0xf2, 0xc4, 0x73, 0xe3, 0x45, 0x8e, 0xe5, 0x72, 0xa3, 0x73, 0x2c, 0x8a,
	0x44, 0xcd, 0xa8, 0x9f, 0x3b, 0xcf, 0xdb, 0xe2, 0x26, 0x01, 0x2b, 0x72, 0xb5, 0xa5, 0xd4, 0xea,
	0xcd, 0xa7, 0x81, 0xf6, 0x88, 0x68, 0x3f, 0x06, 0x33, 0xed, 0x0b, 0x64, 0xd1, 0x18, 0xad, 0xfa,
	0xa4, 0x5c, 0x6f, 0xc8, 0x35, 0x71, 0x0b, 0xdd, 0x83, 0xdb, 0x31, 0x06, 0xf5, 0x45, 0xbd, 0x73,
	0x4c, 0x09, 0x9e, 0x2b, 0xb2, 0xb8, 0x1d, 0xb5, 0xfd, 0x58, 0x2e, 0x2b, 0x9d, 0x8a, 0x5c, 0xee,
	0x88, 0x3b, 0xa8, 0x08, 0x5b, 0x21, 0xcd, 0xc6, 0x98, 0x5d, 0x74, 0x1b, 0x8a, 0xb5, 0xfa, 0x33,
	0xb9, 0xd9, 0x26, 0x88, 0x98, 0x9d, 0x45, 0xc2, 0x77, 0x52, 0xff, 0x5c, 0x6e, 0xc4, 0x31, 0x37,
	0x23, 0xd1, 0xed, 0x94, 0xeb, 0x8d, 0xb6, 0x58, 0xda, 0xfb, 0x97, 0x00, 0x20, 0x8f, 0x5f, 0x4d,
	0x77, 0xa1, 0x10, 0xc9, 0x44, 0xf5, 0xa9, 0xd2, 0x7a, 0x7e, 0x22, 0xde, 0x20, 0x19, 0x16, 0x8a,
	0x5b, 0x08, 0x25, 0x10, 0xfb, 0xc3, 0x29, 0x19, 0xc2, 0xad, 0xd0, 0x4c, 0x93, 0xdb, 0xed, 0x38,
	0x22, 0x41, 0x3c, 0x49, 0x93, 0x28, 0x04, 0x5c, 0x45, 0x6f, 0x41, 0x29, 0xaa, 0x74, 0x04, 0xbf,
	0x46, 0x94, 0x08, 0x79, 0x33, 0x84, 0x5a, 0x27, 0xa8, 0xc0, 0x45, 0x11, 0xd4, 0x46, 0x38, 0xdb,
	0xa9, 0xd9, 0x1c, 0x91, 0xdc, 0xfb, 0xcb, 0x2a, 0x64, 0xc2, 0x4f, 0x28, 0x44, 0x48, 0xf5, 0xb8,
	0xdc, 0x6c, 0xca, 0x0d, 0x9a, 0x09, 0xb2, 0xca, 0x7d, 0x21, 0xde, 0x20, 0x42, 0x7c, 0x54, 0xa3,
	0x7e, 0x2a, 0xab, 0xad, 0x66, 0xa3, 0xde, 0x94, 0x45, 0x81, 0xb8, 0x3b, 0x8a, 0x78, 0xf2, 0x84,
	0x62, 0x56, 0xc2, 0xd2, 0x88, 0xa9, 0x81, 0xe6, 0x62, 0x22, 0x2c, 0x8d, 0xd5, 0x56, 0xeb, 0xe4,
	0x84, 0x56, 0x66, 0x48, 0x1a, 0x41, 0xd4, 0xea, 0xed, 0x72, 0xa5, 0x41, 0x4b, 0x33, 0xc6, 0xe2,
	0x6b, 0xb6, 0x8e, 0x6e, 0xc1, 0xae, 0x8f, 0x60, 0x59, 0x4d, 0x73, 0xf0, 0x94, 0x2c, 0xb4, 0x11,
	0xe6, 0xe2, 0xc8, 0xa7, 0xad, 0x16, 0xa9, 0xda, 0x12, 0xec, 0xc4, 0x10, 0xbe, 0xc4, 0x14, 0xba,
	0x03, 0x37, 0x03, 0x37, 0xf0, 0xe0, 0x8d, 0x9b, 0x04, 0x90, 0x9c, 0x8e, 0xa3, 0x23, 0x6d, 0x24,
	0x1d, 0x56, 0x29, 0xa0, 0xe0, 0xfd, 0x24, 0x13, 0x96, 0x3e, 0x59, 0x62, 0xd9, 0x59, 0x68, 0xe6,
	0xa0, 0x1c, 0x49, 0x91, 0x49, 0x74, 0xe0, 0xa6, 0xfc, 0x74, 0x76, 0xdf, 0x34, 0x11, 0x49, 0xf0,
	0xd6, 0x94, 0x30, 0xd2, 0xae, 0xd9, 0x52, 0xea, 0x2f, 0xe5, 0x9a, 0xb8, 0x19, 0xb6, 0xcf, 0x87,
	0xb3, 0xd4, 0xe6, 0x55, 0x8d, 0xf6, 0x7e, 0x26, 0x44, 0x7f, 0x20, 0x40, 0xef, 0xa9, 0x43, 0x4d,
	0x9c, 0x26, 0x8f, 0x78, 0x03, 0x89, 0x90, 0xe1, 0x99, 0xc7, 0x20, 0x02, 0x81, 0x8c, 0x83, 0xd4,
	0x21, 0x59, 0xc2, 0xbb, 0x29, 0xfb, 0x4c, 0x10, 0x29, 0xbe, 0xcb, 0x18, 0x68, 0x35, 0xda, 0x74,
	0x18, 0x70, 0x6d, 0xef, 0x53, 0xc8, 0x84, 0x5f, 0x54, 0xd1, 0x06, 0x24, 0xca, 0x8d, 0x86, 0x78,
	0x03, 0x65, 0x20, 0x19, 0xc4, 0x5f, 0x40, 0x69, 0xd8, 0x60, 0xeb, 0x7d, 0x21, 0xae, 0x90, 0x0f,
	0xdf, 0x13, 0x89, 0xc3, 0x5f, 0xa5, 0x88, 0x84, 0xf1, 0x2f, 0x86, 0xd0, 0x6b, 0xc8, 0xc7, 0xde,
	0x27, 0xd1, 0xbc, 0xc3, 0xd5, 0xf4, 0x67, 0xd0, 0xd2, 0xe1, 0x75, 0x58, 0xf8, 0x6e, 0xfc, 0x73,
	0x01, 0xd0, 0xe4, 0xfb, 0x2f, 0x7a, 0x34, 0x47, 0xd4, 0xcc, 0x77, 0xef, 0xd2, 0x07, 0xd7, 0xe4,
	0xe2, 0x3a, 0xfc, 0x14, 0xc4, 0xf8, 0xcb, 0x25, 0x3a, 0x5c, 0x20, 0x6a, 0xca, 0xa3, 0x6a, 0xe9,
	0xe8, 0x5a, 0x3c, 0x7c, 0xf1, 0x5f, 0x08, 0x50, 0x98, 0xf2, 0x16, 0x89, 0xe6, 0xd9, 0x32, 0xfb,
	0xe9, 0xb3, 0xf4, 0xe1, 0x75, 0xd9, 0xb8, 0x1a, 0xdf, 0x08, 0xb0, 0x3d, 0xf5, 0x8d, 0x10, 0xfd,
	0x60, 0x81, 0x55, 0xb3, 0x9e, 0x3c, 0x4b, 0x1f, 0x5d, 0x9f, 0x91, 0x2b, 0x63, 0x43, 0x26, 0xfc,
	0x30, 0x86, 0xe6, 0x4e, 0x66, 0x93, 0x2f, 0x73, 0xa5, 0x83, 0xa5, 0xe9, 0xf9, 0x82, 0x5f, 0xc3,
	0xe6, 0xc4, 0x2b, 0x02, 0x3a, 0x5a, 0x20, 0x65, 0xda, 0x83, 0x46, 0xe9, 0xd1, 0xf5, 0x98, 0xc6,
	0x19, 0x18, 0x3f, 0xab, 0xa0, 0x05, 0xd5, 0x34, 0x6d, 0xac, 0x9e, 0x9b, 0x81, 0x33, 0x0f, 0x43,
	0x5f, 0xc3, 0xe6, 0xc4, 0xb4, 0x8c, 0x96, 0xcb, 0xe5, 0xd8, 0xf2, 0x8f, 0xae, 0xc7, 0xc4, 0xd6,
	0xaf, 0x3c, 0x78, 0x79, 0x7f, 0xa9, 0x9f, 0x34, 0x76, 0xd7, 0xe9, 0xa9, 0xe4, 0xe8, 0x3f, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x6e, 0xe6, 0x91, 0xd1, 0x02, 0x29, 0x00, 0x00,
}
