package errorbucket_test

import (
	"sync"
	"sync/atomic"
	"testing"

	"code.justin.tv/amzn/StarfruitTSMClient/internal/errorbucket"
	"github.com/stretchr/testify/assert"
)

func TestAllow(t *testing.T) {
	t.Run("with many consumers, only Count tokens are allowed", func(t *testing.T) {
		b := &errorbucket.Bucket{
			Count: 3,
		}

		have := uint64(0)
		want := uint64(3)

		wg := &sync.WaitGroup{}
		for i := 0; i < 1000; i++ {
			wg.Add(1)
			go func() {
				if b.Allow() {
					atomic.AddUint64(&have, 1)
				}
				wg.Done()
			}()
		}

		wg.Wait()
		assert.Equal(t, have, want)
	})
}
