// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitTranscodeCapacitorTwirp/twirp.proto

/*
Package StarfruitTranscodeCapacitorTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/StarfruitTranscodeCapacitorTwirp/twirp.proto
*/
package StarfruitTranscodeCapacitorTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// =====================================
// StarfruitTranscodeCapacitor Interface
// =====================================

type StarfruitTranscodeCapacitor interface {
	// Used by GoTranscoderMaster to update STC with the host's current capacity
	UpdateHostCapacity(context.Context, *UpdateHostCapacityRequest) (*UpdateHostCapacityResponse, error)

	// Retrieves the current host details
	GetHost(context.Context, *GetHostRequest) (*Host, error)

	// Retrieves all hosts and host details
	ScanHosts(context.Context, *ScanHostsRequest) (*ScanHostsResponse, error)

	// Retrieves aggregated origin capacities by transcode type / customer type
	ScanOriginCapacities(context.Context, *ScanOriginCapacitiesRequest) (*ScanOriginCapacitiesResponse, error)

	// Set Host's desire status
	SetHostStatus(context.Context, *SetHostStatusRequest) (*SetHostStatusResponse, error)

	// Get all hosts by status
	GetHostsByStatus(context.Context, *GetHostsByStatusRequest) (*GetHostsByStatusResponse, error)
}

// ===========================================
// StarfruitTranscodeCapacitor Protobuf Client
// ===========================================

type starfruitTranscodeCapacitorProtobufClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewStarfruitTranscodeCapacitorProtobufClient creates a Protobuf client that implements the StarfruitTranscodeCapacitor interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStarfruitTranscodeCapacitorProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StarfruitTranscodeCapacitor {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StarfruitTranscodeCapacitorPathPrefix
	urls := [6]string{
		prefix + "UpdateHostCapacity",
		prefix + "GetHost",
		prefix + "ScanHosts",
		prefix + "ScanOriginCapacities",
		prefix + "SetHostStatus",
		prefix + "GetHostsByStatus",
	}

	return &starfruitTranscodeCapacitorProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *starfruitTranscodeCapacitorProtobufClient) UpdateHostCapacity(ctx context.Context, in *UpdateHostCapacityRequest) (*UpdateHostCapacityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateHostCapacity")
	out := new(UpdateHostCapacityResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorProtobufClient) GetHost(ctx context.Context, in *GetHostRequest) (*Host, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "GetHost")
	out := new(Host)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorProtobufClient) ScanHosts(ctx context.Context, in *ScanHostsRequest) (*ScanHostsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "ScanHosts")
	out := new(ScanHostsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorProtobufClient) ScanOriginCapacities(ctx context.Context, in *ScanOriginCapacitiesRequest) (*ScanOriginCapacitiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "ScanOriginCapacities")
	out := new(ScanOriginCapacitiesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorProtobufClient) SetHostStatus(ctx context.Context, in *SetHostStatusRequest) (*SetHostStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "SetHostStatus")
	out := new(SetHostStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorProtobufClient) GetHostsByStatus(ctx context.Context, in *GetHostsByStatusRequest) (*GetHostsByStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "GetHostsByStatus")
	out := new(GetHostsByStatusResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================================
// StarfruitTranscodeCapacitor JSON Client
// =======================================

type starfruitTranscodeCapacitorJSONClient struct {
	client HTTPClient
	urls   [6]string
	opts   twirp.ClientOptions
}

// NewStarfruitTranscodeCapacitorJSONClient creates a JSON client that implements the StarfruitTranscodeCapacitor interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStarfruitTranscodeCapacitorJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StarfruitTranscodeCapacitor {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StarfruitTranscodeCapacitorPathPrefix
	urls := [6]string{
		prefix + "UpdateHostCapacity",
		prefix + "GetHost",
		prefix + "ScanHosts",
		prefix + "ScanOriginCapacities",
		prefix + "SetHostStatus",
		prefix + "GetHostsByStatus",
	}

	return &starfruitTranscodeCapacitorJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *starfruitTranscodeCapacitorJSONClient) UpdateHostCapacity(ctx context.Context, in *UpdateHostCapacityRequest) (*UpdateHostCapacityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateHostCapacity")
	out := new(UpdateHostCapacityResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorJSONClient) GetHost(ctx context.Context, in *GetHostRequest) (*Host, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "GetHost")
	out := new(Host)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorJSONClient) ScanHosts(ctx context.Context, in *ScanHostsRequest) (*ScanHostsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "ScanHosts")
	out := new(ScanHostsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorJSONClient) ScanOriginCapacities(ctx context.Context, in *ScanOriginCapacitiesRequest) (*ScanOriginCapacitiesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "ScanOriginCapacities")
	out := new(ScanOriginCapacitiesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorJSONClient) SetHostStatus(ctx context.Context, in *SetHostStatusRequest) (*SetHostStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "SetHostStatus")
	out := new(SetHostStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeCapacitorJSONClient) GetHostsByStatus(ctx context.Context, in *GetHostsByStatusRequest) (*GetHostsByStatusResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithMethodName(ctx, "GetHostsByStatus")
	out := new(GetHostsByStatusResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================================
// StarfruitTranscodeCapacitor Server Handler
// ==========================================

type starfruitTranscodeCapacitorServer struct {
	StarfruitTranscodeCapacitor
	hooks *twirp.ServerHooks
}

func NewStarfruitTranscodeCapacitorServer(svc StarfruitTranscodeCapacitor, hooks *twirp.ServerHooks) TwirpServer {
	return &starfruitTranscodeCapacitorServer{
		StarfruitTranscodeCapacitor: svc,
		hooks:                       hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *starfruitTranscodeCapacitorServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StarfruitTranscodeCapacitorPathPrefix is used for all URL paths on a twirp StarfruitTranscodeCapacitor server.
// Requests are always: POST StarfruitTranscodeCapacitorPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StarfruitTranscodeCapacitorPathPrefix = "/twirp/twitch.video.capacitor.StarfruitTranscodeCapacitor/"

func (s *starfruitTranscodeCapacitorServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.capacitor")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeCapacitor")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.capacitor.StarfruitTranscodeCapacitor/UpdateHostCapacity":
		s.serveUpdateHostCapacity(ctx, resp, req)
		return
	case "/twirp/twitch.video.capacitor.StarfruitTranscodeCapacitor/GetHost":
		s.serveGetHost(ctx, resp, req)
		return
	case "/twirp/twitch.video.capacitor.StarfruitTranscodeCapacitor/ScanHosts":
		s.serveScanHosts(ctx, resp, req)
		return
	case "/twirp/twitch.video.capacitor.StarfruitTranscodeCapacitor/ScanOriginCapacities":
		s.serveScanOriginCapacities(ctx, resp, req)
		return
	case "/twirp/twitch.video.capacitor.StarfruitTranscodeCapacitor/SetHostStatus":
		s.serveSetHostStatus(ctx, resp, req)
		return
	case "/twirp/twitch.video.capacitor.StarfruitTranscodeCapacitor/GetHostsByStatus":
		s.serveGetHostsByStatus(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *starfruitTranscodeCapacitorServer) serveUpdateHostCapacity(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateHostCapacityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateHostCapacityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeCapacitorServer) serveUpdateHostCapacityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateHostCapacity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateHostCapacityRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateHostCapacityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.UpdateHostCapacity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateHostCapacityResponse and nil error while calling UpdateHostCapacity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveUpdateHostCapacityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateHostCapacity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateHostCapacityRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *UpdateHostCapacityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.UpdateHostCapacity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateHostCapacityResponse and nil error while calling UpdateHostCapacity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveGetHost(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetHostJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetHostProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeCapacitorServer) serveGetHostJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHost")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetHostRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Host
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.GetHost(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Host and nil error while calling GetHost. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveGetHostProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHost")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetHostRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Host
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.GetHost(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Host and nil error while calling GetHost. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveScanHosts(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveScanHostsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveScanHostsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeCapacitorServer) serveScanHostsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanHosts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ScanHostsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanHostsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.ScanHosts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanHostsResponse and nil error while calling ScanHosts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveScanHostsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanHosts")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ScanHostsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanHostsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.ScanHosts(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanHostsResponse and nil error while calling ScanHosts. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveScanOriginCapacities(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveScanOriginCapacitiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveScanOriginCapacitiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeCapacitorServer) serveScanOriginCapacitiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanOriginCapacities")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ScanOriginCapacitiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanOriginCapacitiesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.ScanOriginCapacities(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanOriginCapacitiesResponse and nil error while calling ScanOriginCapacities. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveScanOriginCapacitiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanOriginCapacities")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ScanOriginCapacitiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanOriginCapacitiesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.ScanOriginCapacities(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanOriginCapacitiesResponse and nil error while calling ScanOriginCapacities. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveSetHostStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveSetHostStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveSetHostStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeCapacitorServer) serveSetHostStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetHostStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(SetHostStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetHostStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.SetHostStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetHostStatusResponse and nil error while calling SetHostStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveSetHostStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "SetHostStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(SetHostStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *SetHostStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.SetHostStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SetHostStatusResponse and nil error while calling SetHostStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveGetHostsByStatus(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetHostsByStatusJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetHostsByStatusProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeCapacitorServer) serveGetHostsByStatusJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHostsByStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetHostsByStatusRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetHostsByStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.GetHostsByStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetHostsByStatusResponse and nil error while calling GetHostsByStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) serveGetHostsByStatusProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHostsByStatus")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetHostsByStatusRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetHostsByStatusResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeCapacitor.GetHostsByStatus(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetHostsByStatusResponse and nil error while calling GetHostsByStatus. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeCapacitorServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *starfruitTranscodeCapacitorServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *starfruitTranscodeCapacitorServer) PathPrefix() string {
	return StarfruitTranscodeCapacitorPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1116 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xdd, 0x52, 0xdb, 0x46,
	0x14, 0xae, 0xfc, 0x03, 0xf6, 0x31, 0x4e, 0xc5, 0x02, 0x89, 0x10, 0x74, 0xe2, 0x2a, 0x6d, 0xc7,
	0x81, 0x54, 0x6e, 0x1c, 0x86, 0x49, 0x72, 0x55, 0xa0, 0x94, 0x7a, 0x92, 0x18, 0x2a, 0xdb, 0x84,
	0xf4, 0x46, 0x15, 0xf2, 0x02, 0x6a, 0xac, 0x9f, 0x68, 0x57, 0x06, 0xb5, 0x17, 0x9d, 0xde, 0xf5,
	0x4d, 0xfa, 0x06, 0xbd, 0xea, 0x0b, 0xf4, 0x85, 0x7a, 0xdb, 0x8e, 0xa4, 0x95, 0xb1, 0x8c, 0xad,
	0xd8, 0xb4, 0xd3, 0x1b, 0xc6, 0xbb, 0xe7, 0x3b, 0x7b, 0xfe, 0xbe, 0x73, 0x8e, 0x80, 0x2f, 0x75,
	0xbb, 0x8b, 0xe5, 0x1f, 0x3c, 0x42, 0x0d, 0x4b, 0xa6, 0xfd, 0x9a, 0x66, 0xfe, 0x68, 0xd5, 0x5a,
	0x54, 0x73, 0xcf, 0x5c, 0xcf, 0xa0, 0x6d, 0x57, 0xb3, 0x48, 0x80, 0xd8, 0xd3, 0x1c, 0x4d, 0x37,
	0xa8, 0xed, 0xb6, 0x2f, 0x0d, 0xd7, 0xa9, 0xd1, 0xe0, 0xaf, 0xec, 0xb8, 0x36, 0xb5, 0xd1, 0x5d,
	0x7a, 0x69, 0x50, 0xfd, 0x42, 0xee, 0x1b, 0x5d, 0x6c, 0xcb, 0x7a, 0x0c, 0x14, 0xef, 0x9f, 0xdb,
	0xf6, 0x79, 0x0f, 0xd7, 0x42, 0xd4, 0xa9, 0x77, 0x56, 0xa3, 0x86, 0x89, 0x09, 0xd5, 0x4c, 0xa6,
	0x28, 0xfd, 0x95, 0x03, 0xfe, 0x1b, 0x9b, 0x50, 0xf6, 0xb6, 0xdf, 0xb0, 0xce, 0x6c, 0x24, 0x42,
	0xe1, 0xc2, 0x26, 0xd4, 0xd2, 0x4c, 0x2c, 0x70, 0x15, 0xae, 0x5a, 0x54, 0x06, 0x67, 0xf4, 0x12,
	0xee, 0xd0, 0xd8, 0x21, 0x95, 0xfa, 0x0e, 0x16, 0x32, 0x15, 0xae, 0x7a, 0xa7, 0xfe, 0xa9, 0x3c,
	0xde, 0x05, 0x79, 0xe0, 0x7e, 0xdb, 0x77, 0xb0, 0x52, 0xa6, 0xc3, 0x47, 0xf4, 0x1c, 0xe6, 0x08,
	0xd5, 0xa8, 0x47, 0x84, 0x6c, 0xf8, 0x8a, 0x34, 0xe9, 0x95, 0xc0, 0xc7, 0x56, 0x88, 0x54, 0x98,
	0x06, 0x7a, 0x06, 0xe0, 0x39, 0x5d, 0x8d, 0xe2, 0xae, 0x6a, 0x5b, 0x42, 0xae, 0xc2, 0x55, 0x4b,
	0x75, 0x51, 0x8e, 0x02, 0x96, 0xe3, 0x80, 0xe5, 0x76, 0x1c, 0xb0, 0x52, 0x64, 0xe8, 0x43, 0x0b,
	0x3d, 0x05, 0x21, 0xb2, 0xa3, 0xba, 0x9e, 0x65, 0x19, 0xd6, 0xb9, 0xea, 0xb8, 0xb6, 0x8e, 0x09,
	0xc1, 0x44, 0xc8, 0x57, 0xb8, 0x6a, 0x4e, 0x61, 0x09, 0x55, 0x22, 0xf1, 0x51, 0x2c, 0x45, 0x75,
	0x58, 0x31, 0xfa, 0x64, 0x8c, 0xda, 0x5c, 0xa8, 0xb6, 0x64, 0xf4, 0xc9, 0x0d, 0x9d, 0x4d, 0x58,
	0x34, 0xb5, 0x2b, 0xc3, 0xf4, 0xcc, 0x21, 0xfc, 0x7c, 0x88, 0xe7, 0x99, 0xe0, 0x1a, 0xbc, 0x06,
	0x45, 0xdd, 0xf1, 0x54, 0x8f, 0x68, 0xe7, 0x58, 0x28, 0x54, 0xb8, 0x2a, 0xa7, 0x14, 0x74, 0xc7,
	0xeb, 0x04, 0x67, 0xf4, 0x31, 0x2c, 0xf4, 0x6c, 0xad, 0xab, 0x6a, 0x7d, 0xec, 0x06, 0xf2, 0x62,
	0x28, 0x2f, 0x05, 0x77, 0x3b, 0xd1, 0x15, 0xda, 0x06, 0xc1, 0xc2, 0xf4, 0xd2, 0x76, 0xdf, 0xaa,
	0xee, 0x95, 0x7a, 0xea, 0x53, 0x4c, 0x54, 0x07, 0xbb, 0x2a, 0xc1, 0xba, 0x00, 0xa1, 0xcd, 0x65,
	0x26, 0x57, 0xae, 0x76, 0x03, 0xe9, 0x11, 0x76, 0x5b, 0x58, 0x1f, 0xd6, 0xa3, 0xa3, 0x7a, 0xa5,
	0x84, 0x5e, 0x3b, 0xa1, 0xb7, 0x06, 0x45, 0x13, 0x9b, 0x2a, 0xb5, 0xa9, 0xd6, 0x13, 0x16, 0x42,
	0x60, 0xc1, 0xc4, 0x66, 0x3b, 0x38, 0xa3, 0x55, 0x08, 0x7e, 0xab, 0x67, 0x2e, 0xc6, 0x42, 0x39,
	0x94, 0xcd, 0x9b, 0xd8, 0xfc, 0xda, 0xc5, 0x58, 0x7a, 0x07, 0xb9, 0xa0, 0xa6, 0xa9, 0x5c, 0x7b,
	0x05, 0x65, 0xc6, 0x00, 0x5f, 0x35, 0xac, 0x33, 0x5b, 0xc8, 0x54, 0xb2, 0xd5, 0x52, 0xbd, 0x9a,
	0x46, 0x92, 0x61, 0x22, 0x2b, 0x0b, 0xfa, 0xd0, 0x49, 0x7a, 0x04, 0x77, 0x0e, 0x30, 0x0d, 0x40,
	0x0a, 0x7e, 0xe7, 0xe1, 0x74, 0xe3, 0xd2, 0xaf, 0x39, 0x58, 0xed, 0x84, 0x8c, 0x19, 0x7e, 0x76,
	0x0a, 0xcd, 0xff, 0xb8, 0x45, 0xd2, 0xb8, 0x9a, 0xbd, 0x1d, 0x57, 0x73, 0x33, 0x72, 0x35, 0x3f,
	0x0d, 0x57, 0xe7, 0xde, 0xc3, 0xd5, 0xf9, 0xd9, 0xb8, 0x5a, 0xb8, 0x25, 0x57, 0x8b, 0xd3, 0x72,
	0x15, 0x52, 0xb8, 0x5a, 0x4a, 0x72, 0x75, 0x1d, 0xc4, 0x71, 0x4c, 0x20, 0x8e, 0x6d, 0x11, 0x2c,
	0x21, 0xe0, 0x5b, 0xba, 0x66, 0x05, 0x32, 0xc2, 0xe8, 0x21, 0x1d, 0xc0, 0xe2, 0xd0, 0x5d, 0x04,
	0x44, 0x75, 0xc8, 0x07, 0x1c, 0x21, 0x02, 0x17, 0xd2, 0x78, 0x3d, 0x8d, 0xc6, 0x4a, 0x04, 0x95,
	0xfe, 0xe0, 0x60, 0xb9, 0x15, 0x91, 0x96, 0x8d, 0xbf, 0xff, 0x9d, 0x80, 0xff, 0x62, 0x46, 0x4b,
	0xf7, 0x60, 0x65, 0xc4, 0x7b, 0x96, 0xb4, 0x8f, 0x60, 0x2d, 0x48, 0xd0, 0xa1, 0x6b, 0x9c, 0x1b,
	0x16, 0x4b, 0xa9, 0x81, 0x07, 0xf9, 0xfb, 0x33, 0x03, 0xeb, 0xe3, 0xe5, 0x2c, 0x97, 0xbf, 0x71,
	0xf0, 0xc0, 0x0e, 0x85, 0xaa, 0x3e, 0x90, 0xaa, 0xa7, 0xbe, 0x3a, 0x12, 0x78, 0x94, 0xea, 0x37,
	0x93, 0x5c, 0x4e, 0xb3, 0x21, 0x8f, 0x0a, 0x76, 0xfd, 0x44, 0x9e, 0xf6, 0x2d, 0xea, 0xfa, 0xca,
	0x7d, 0x3b, 0x1d, 0x25, 0xfe, 0x0c, 0x9f, 0x4c, 0xf3, 0x10, 0xe2, 0x21, 0xfb, 0x16, 0xfb, 0xac,
	0x96, 0xc1, 0x4f, 0xb4, 0x03, 0xf9, 0xbe, 0xd6, 0xf3, 0xa2, 0xea, 0x95, 0xea, 0x9b, 0x93, 0x82,
	0x48, 0x3c, 0x1f, 0x8e, 0x3a, 0xa2, 0x44, 0x9a, 0xcf, 0x33, 0x4f, 0x39, 0xc9, 0x82, 0xa5, 0x31,
	0x08, 0xf4, 0x1a, 0x16, 0x6f, 0x24, 0x90, 0xa5, 0x6b, 0x63, 0x7a, 0x4b, 0x0a, 0x3f, 0x1a, 0xbf,
	0xf4, 0x37, 0x07, 0xe8, 0x26, 0x10, 0x3d, 0x80, 0xb2, 0xee, 0x11, 0x6a, 0x9b, 0xd8, 0x8d, 0x4b,
	0x13, 0x44, 0xba, 0x10, 0x5f, 0x86, 0x5c, 0x4b, 0xee, 0xf4, 0xcc, 0x2c, 0x3b, 0xfd, 0x21, 0xc4,
	0x03, 0x2a, 0x0e, 0xc8, 0x0f, 0x09, 0x5b, 0x56, 0x3e, 0x64, 0xf7, 0xb1, 0x3b, 0xe8, 0x31, 0x2c,
	0x6b, 0xdd, 0xae, 0x8b, 0x09, 0xd1, 0x4e, 0x7b, 0xf8, 0x1a, 0x9e, 0x0b, 0xe1, 0x4b, 0x43, 0xb2,
	0x81, 0xca, 0x26, 0x2c, 0x8e, 0xff, 0x54, 0x28, 0x2b, 0xbc, 0x3b, 0x32, 0x44, 0xa5, 0x0e, 0xdc,
	0x63, 0x8b, 0x86, 0xec, 0xfa, 0xc9, 0xb6, 0xbd, 0x6e, 0x26, 0x6e, 0xe6, 0x66, 0xa2, 0x20, 0xdc,
	0x7c, 0x96, 0xf5, 0xc3, 0x09, 0x2c, 0x05, 0xed, 0xaf, 0x26, 0xf6, 0x65, 0x5c, 0xcf, 0xe9, 0x17,
	0xe6, 0xe2, 0xc5, 0xc8, 0x0d, 0xd9, 0xc0, 0x50, 0x4e, 0xb0, 0x15, 0xad, 0xc2, 0x4a, 0xe2, 0x42,
	0xed, 0x34, 0x5f, 0x34, 0x0f, 0x5f, 0x37, 0xf9, 0x0f, 0xd0, 0x02, 0x14, 0xda, 0xca, 0x4e, 0xb3,
	0xf5, 0xaa, 0x73, 0xc2, 0x73, 0xa8, 0x0c, 0xc5, 0x6f, 0x3b, 0x8d, 0xbd, 0x17, 0xad, 0x37, 0xcd,
	0x3d, 0x3e, 0x83, 0x0a, 0x90, 0x3b, 0xa9, 0x6f, 0x6f, 0xf1, 0x59, 0x54, 0x84, 0xfc, 0xfe, 0xf1,
	0x7e, 0xb3, 0xcd, 0xe7, 0xd0, 0x3c, 0x64, 0x8f, 0x8f, 0x9e, 0xf1, 0xf9, 0x8d, 0x97, 0x00, 0xd7,
	0x21, 0xa3, 0xbb, 0x80, 0xae, 0x4f, 0x49, 0x03, 0x8d, 0xe6, 0xce, 0x5e, 0xbb, 0x71, 0xbc, 0xcf,
	0x73, 0xc1, 0xe9, 0x2b, 0x65, 0xa7, 0xd1, 0x6c, 0x34, 0x0f, 0xf8, 0x0c, 0x02, 0x98, 0x63, 0x92,
	0x6c, 0xfd, 0xf7, 0x3c, 0xac, 0xa5, 0x7c, 0x40, 0xa3, 0x9f, 0x00, 0xdd, 0x9c, 0xe8, 0xe8, 0xf1,
	0xa4, 0x3c, 0x4d, 0xfc, 0x0e, 0x10, 0xeb, 0xb3, 0xa8, 0xb0, 0x5a, 0x1d, 0xc2, 0x3c, 0xab, 0x23,
	0xfa, 0x6c, 0x92, 0x7a, 0xf2, 0x43, 0x45, 0x4c, 0xdd, 0x15, 0xe8, 0x7b, 0x28, 0x0e, 0xb6, 0x0d,
	0xaa, 0xa6, 0xcd, 0xba, 0xe1, 0x25, 0x25, 0x3e, 0x9c, 0x02, 0xc9, 0x5c, 0xfe, 0x25, 0x58, 0x43,
	0x63, 0x66, 0x25, 0x7a, 0x32, 0xdb, 0x64, 0x8d, 0x0c, 0x6f, 0xdd, 0x66, 0x1c, 0xa3, 0x1e, 0x94,
	0x13, 0xbb, 0x04, 0x3d, 0x9a, 0xf8, 0xcc, 0x98, 0x85, 0x29, 0x7e, 0x3e, 0x25, 0x9a, 0x59, 0xf3,
	0x80, 0x1f, 0x6d, 0x36, 0x54, 0x7b, 0x4f, 0xb5, 0x46, 0xbb, 0x5d, 0xfc, 0x62, 0x7a, 0x85, 0xc8,
	0xec, 0xee, 0xf6, 0x77, 0x5b, 0xb7, 0xf9, 0x67, 0xf0, 0x74, 0x2e, 0x1c, 0x8e, 0x4f, 0xfe, 0x09,
	0x00, 0x00, 0xff, 0xff, 0x3a, 0x67, 0x42, 0x44, 0x4b, 0x0e, 0x00, 0x00,
}
