// Code generated by protoc-gen-twirp v5.12.1, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitTranscodeStateMgrTwirp/twirp.proto

/*
Package StarfruitTranscodeStateMgrTwirp is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.12.1.

It is generated from these files:
	code.justin.tv/amzn/StarfruitTranscodeStateMgrTwirp/twirp.proto
*/
package StarfruitTranscodeStateMgrTwirp

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"
import strconv "strconv"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import json "encoding/json"
import url "net/url"

// ====================================
// StarfruitTranscodeStateMgr Interface
// ====================================

type StarfruitTranscodeStateMgr interface {
	// CreateTranscode creates one or more transcodes.
	CreateTranscode(context.Context, *CreateTranscodeRequest) (*CreateTranscodeResponse, error)

	// CreateTwitchTranscode creates one or more transcodes for Twitch customers
	CreateTwitchTranscode(context.Context, *CreateTwitchTranscodeRequest) (*CreateTranscodeResponse, error)

	// GetTranscodeByID will return one transcode for a given transcode id.
	GetTranscodeByID(context.Context, *GetTranscodeByIDRequest) (*GetTranscodeResponse, error)

	// GetTranscodesByCustomerIDParallel will return one or more transcodes for a given customer id and DynamoDB partition.
	GetTranscodesByCustomerIDParallel(context.Context, *GetTranscodesByCustomerIDParallelRequest) (*GetTranscodesByCustomerIDParallelResponse, error)

	// GetTranscodesByContentID will return one or more transcodes for a given content id.
	GetTranscodesByContentID(context.Context, *GetTranscodesByContentIDRequest) (*GetTranscodesResponse, error)

	// GetTranscodesByChannel will return one or more transcodes for a given channel name.
	GetTranscodesByChannel(context.Context, *GetTranscodesByChannelRequest) (*GetTranscodesResponse, error)

	// GetTranscodesByOriginFQDN will return one or more transcodes that are processing on a specific origin datacenter host.
	GetTranscodesByOriginFQDN(context.Context, *GetTranscodesByOriginFQDNRequest) (*GetTranscodesResponse, error)

	// DeleteTranscode deletes one transcode row.
	DeleteTranscode(context.Context, *DeleteTranscodeRequest) (*Transcode, error)

	// UpdateTranscode updates a single transcode entry.
	UpdateTranscode(context.Context, *UpdateTranscodeRequest) (*Transcode, error)

	// UpdateTranscodeSourceProperties updates a transcode entry's source properties.
	UpdateTranscodeSourceProperties(context.Context, *UpdateTranscodeSourcePropertiesRequest) (*Transcode, error)

	// Re-Creates a transcode and forces it to be of a certain type
	RecreateTranscode(context.Context, *RecreateTranscodeRequest) (*Transcode, error)

	// GetRecordingConfiguration will return updated recording_config_bytes for a given transcode.
	GetRecordingConfigurationWithCredentials(context.Context, *GetRecordingConfigurationWithCredentialsRequest) (*GetRecordingConfigurationWithCredentialsResponse, error)

	// RefreshCapacity triggers TSM to look over the entries in the database and re-calculate the current utilized capacity
	RefreshCapacity(context.Context, *RefreshCapacityRequest) (*RefreshCapacityResponse, error)

	// Internal use only. Performs a paginated parallel Scan against the Transcodes table.
	// Callers must be whitelisted in order to use this RPC.
	ScanTranscodes(context.Context, *ScanTranscodesRequest) (*ScanTranscodesResponse, error)
}

// ==========================================
// StarfruitTranscodeStateMgr Protobuf Client
// ==========================================

type starfruitTranscodeStateMgrProtobufClient struct {
	client HTTPClient
	urls   [14]string
	opts   twirp.ClientOptions
}

// NewStarfruitTranscodeStateMgrProtobufClient creates a Protobuf client that implements the StarfruitTranscodeStateMgr interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStarfruitTranscodeStateMgrProtobufClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StarfruitTranscodeStateMgr {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StarfruitTranscodeStateMgrPathPrefix
	urls := [14]string{
		prefix + "CreateTranscode",
		prefix + "CreateTwitchTranscode",
		prefix + "GetTranscodeByID",
		prefix + "GetTranscodesByCustomerIDParallel",
		prefix + "GetTranscodesByContentID",
		prefix + "GetTranscodesByChannel",
		prefix + "GetTranscodesByOriginFQDN",
		prefix + "DeleteTranscode",
		prefix + "UpdateTranscode",
		prefix + "UpdateTranscodeSourceProperties",
		prefix + "RecreateTranscode",
		prefix + "GetRecordingConfigurationWithCredentials",
		prefix + "RefreshCapacity",
		prefix + "ScanTranscodes",
	}

	return &starfruitTranscodeStateMgrProtobufClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *starfruitTranscodeStateMgrProtobufClient) CreateTranscode(ctx context.Context, in *CreateTranscodeRequest) (*CreateTranscodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTranscode")
	out := new(CreateTranscodeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) CreateTwitchTranscode(ctx context.Context, in *CreateTwitchTranscodeRequest) (*CreateTranscodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTwitchTranscode")
	out := new(CreateTranscodeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) GetTranscodeByID(ctx context.Context, in *GetTranscodeByIDRequest) (*GetTranscodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodeByID")
	out := new(GetTranscodeResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) GetTranscodesByCustomerIDParallel(ctx context.Context, in *GetTranscodesByCustomerIDParallelRequest) (*GetTranscodesByCustomerIDParallelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByCustomerIDParallel")
	out := new(GetTranscodesByCustomerIDParallelResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) GetTranscodesByContentID(ctx context.Context, in *GetTranscodesByContentIDRequest) (*GetTranscodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByContentID")
	out := new(GetTranscodesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) GetTranscodesByChannel(ctx context.Context, in *GetTranscodesByChannelRequest) (*GetTranscodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByChannel")
	out := new(GetTranscodesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) GetTranscodesByOriginFQDN(ctx context.Context, in *GetTranscodesByOriginFQDNRequest) (*GetTranscodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByOriginFQDN")
	out := new(GetTranscodesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) DeleteTranscode(ctx context.Context, in *DeleteTranscodeRequest) (*Transcode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTranscode")
	out := new(Transcode)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) UpdateTranscode(ctx context.Context, in *UpdateTranscodeRequest) (*Transcode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTranscode")
	out := new(Transcode)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) UpdateTranscodeSourceProperties(ctx context.Context, in *UpdateTranscodeSourcePropertiesRequest) (*Transcode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTranscodeSourceProperties")
	out := new(Transcode)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) RecreateTranscode(ctx context.Context, in *RecreateTranscodeRequest) (*Transcode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "RecreateTranscode")
	out := new(Transcode)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) GetRecordingConfigurationWithCredentials(ctx context.Context, in *GetRecordingConfigurationWithCredentialsRequest) (*GetRecordingConfigurationWithCredentialsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfigurationWithCredentials")
	out := new(GetRecordingConfigurationWithCredentialsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) RefreshCapacity(ctx context.Context, in *RefreshCapacityRequest) (*RefreshCapacityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "RefreshCapacity")
	out := new(RefreshCapacityResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrProtobufClient) ScanTranscodes(ctx context.Context, in *ScanTranscodesRequest) (*ScanTranscodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "ScanTranscodes")
	out := new(ScanTranscodesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ======================================
// StarfruitTranscodeStateMgr JSON Client
// ======================================

type starfruitTranscodeStateMgrJSONClient struct {
	client HTTPClient
	urls   [14]string
	opts   twirp.ClientOptions
}

// NewStarfruitTranscodeStateMgrJSONClient creates a JSON client that implements the StarfruitTranscodeStateMgr interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStarfruitTranscodeStateMgrJSONClient(addr string, client HTTPClient, opts ...twirp.ClientOption) StarfruitTranscodeStateMgr {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	prefix := urlBase(addr) + StarfruitTranscodeStateMgrPathPrefix
	urls := [14]string{
		prefix + "CreateTranscode",
		prefix + "CreateTwitchTranscode",
		prefix + "GetTranscodeByID",
		prefix + "GetTranscodesByCustomerIDParallel",
		prefix + "GetTranscodesByContentID",
		prefix + "GetTranscodesByChannel",
		prefix + "GetTranscodesByOriginFQDN",
		prefix + "DeleteTranscode",
		prefix + "UpdateTranscode",
		prefix + "UpdateTranscodeSourceProperties",
		prefix + "RecreateTranscode",
		prefix + "GetRecordingConfigurationWithCredentials",
		prefix + "RefreshCapacity",
		prefix + "ScanTranscodes",
	}

	return &starfruitTranscodeStateMgrJSONClient{
		client: client,
		urls:   urls,
		opts:   clientOpts,
	}
}

func (c *starfruitTranscodeStateMgrJSONClient) CreateTranscode(ctx context.Context, in *CreateTranscodeRequest) (*CreateTranscodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTranscode")
	out := new(CreateTranscodeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) CreateTwitchTranscode(ctx context.Context, in *CreateTwitchTranscodeRequest) (*CreateTranscodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "CreateTwitchTranscode")
	out := new(CreateTranscodeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) GetTranscodeByID(ctx context.Context, in *GetTranscodeByIDRequest) (*GetTranscodeResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodeByID")
	out := new(GetTranscodeResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) GetTranscodesByCustomerIDParallel(ctx context.Context, in *GetTranscodesByCustomerIDParallelRequest) (*GetTranscodesByCustomerIDParallelResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByCustomerIDParallel")
	out := new(GetTranscodesByCustomerIDParallelResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) GetTranscodesByContentID(ctx context.Context, in *GetTranscodesByContentIDRequest) (*GetTranscodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByContentID")
	out := new(GetTranscodesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) GetTranscodesByChannel(ctx context.Context, in *GetTranscodesByChannelRequest) (*GetTranscodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByChannel")
	out := new(GetTranscodesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) GetTranscodesByOriginFQDN(ctx context.Context, in *GetTranscodesByOriginFQDNRequest) (*GetTranscodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByOriginFQDN")
	out := new(GetTranscodesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) DeleteTranscode(ctx context.Context, in *DeleteTranscodeRequest) (*Transcode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTranscode")
	out := new(Transcode)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) UpdateTranscode(ctx context.Context, in *UpdateTranscodeRequest) (*Transcode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTranscode")
	out := new(Transcode)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) UpdateTranscodeSourceProperties(ctx context.Context, in *UpdateTranscodeSourcePropertiesRequest) (*Transcode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTranscodeSourceProperties")
	out := new(Transcode)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) RecreateTranscode(ctx context.Context, in *RecreateTranscodeRequest) (*Transcode, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "RecreateTranscode")
	out := new(Transcode)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) GetRecordingConfigurationWithCredentials(ctx context.Context, in *GetRecordingConfigurationWithCredentialsRequest) (*GetRecordingConfigurationWithCredentialsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfigurationWithCredentials")
	out := new(GetRecordingConfigurationWithCredentialsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) RefreshCapacity(ctx context.Context, in *RefreshCapacityRequest) (*RefreshCapacityResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "RefreshCapacity")
	out := new(RefreshCapacityResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTranscodeStateMgrJSONClient) ScanTranscodes(ctx context.Context, in *ScanTranscodesRequest) (*ScanTranscodesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithMethodName(ctx, "ScanTranscodes")
	out := new(ScanTranscodesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================================
// StarfruitTranscodeStateMgr Server Handler
// =========================================

type starfruitTranscodeStateMgrServer struct {
	StarfruitTranscodeStateMgr
	hooks *twirp.ServerHooks
}

func NewStarfruitTranscodeStateMgrServer(svc StarfruitTranscodeStateMgr, hooks *twirp.ServerHooks) TwirpServer {
	return &starfruitTranscodeStateMgrServer{
		StarfruitTranscodeStateMgr: svc,
		hooks:                      hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *starfruitTranscodeStateMgrServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// StarfruitTranscodeStateMgrPathPrefix is used for all URL paths on a twirp StarfruitTranscodeStateMgr server.
// Requests are always: POST StarfruitTranscodeStateMgrPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const StarfruitTranscodeStateMgrPathPrefix = "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/"

func (s *starfruitTranscodeStateMgrServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittranscodestatemgr")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTranscodeStateMgr")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/CreateTranscode":
		s.serveCreateTranscode(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/CreateTwitchTranscode":
		s.serveCreateTwitchTranscode(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/GetTranscodeByID":
		s.serveGetTranscodeByID(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/GetTranscodesByCustomerIDParallel":
		s.serveGetTranscodesByCustomerIDParallel(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/GetTranscodesByContentID":
		s.serveGetTranscodesByContentID(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/GetTranscodesByChannel":
		s.serveGetTranscodesByChannel(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/GetTranscodesByOriginFQDN":
		s.serveGetTranscodesByOriginFQDN(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/DeleteTranscode":
		s.serveDeleteTranscode(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/UpdateTranscode":
		s.serveUpdateTranscode(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/UpdateTranscodeSourceProperties":
		s.serveUpdateTranscodeSourceProperties(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/RecreateTranscode":
		s.serveRecreateTranscode(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/GetRecordingConfigurationWithCredentials":
		s.serveGetRecordingConfigurationWithCredentials(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/RefreshCapacity":
		s.serveRefreshCapacity(ctx, resp, req)
		return
	case "/twirp/twitch.video.starfruittranscodestatemgr.StarfruitTranscodeStateMgr/ScanTranscodes":
		s.serveScanTranscodes(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *starfruitTranscodeStateMgrServer) serveCreateTranscode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateTranscodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateTranscodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveCreateTranscodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateTranscodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateTranscodeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.CreateTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTranscodeResponse and nil error while calling CreateTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveCreateTranscodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateTranscodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateTranscodeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.CreateTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTranscodeResponse and nil error while calling CreateTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveCreateTwitchTranscode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateTwitchTranscodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateTwitchTranscodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveCreateTwitchTranscodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTwitchTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateTwitchTranscodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateTranscodeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.CreateTwitchTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTranscodeResponse and nil error while calling CreateTwitchTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveCreateTwitchTranscodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateTwitchTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(CreateTwitchTranscodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *CreateTranscodeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.CreateTwitchTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateTranscodeResponse and nil error while calling CreateTwitchTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodeByID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTranscodeByIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTranscodeByIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodeByIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodeByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTranscodeByIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodeByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodeResponse and nil error while calling GetTranscodeByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodeByIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodeByID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTranscodeByIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodeResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodeByID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodeResponse and nil error while calling GetTranscodeByID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByCustomerIDParallel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTranscodesByCustomerIDParallelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTranscodesByCustomerIDParallelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByCustomerIDParallelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByCustomerIDParallel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTranscodesByCustomerIDParallelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodesByCustomerIDParallelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodesByCustomerIDParallel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodesByCustomerIDParallelResponse and nil error while calling GetTranscodesByCustomerIDParallel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByCustomerIDParallelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByCustomerIDParallel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTranscodesByCustomerIDParallelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodesByCustomerIDParallelResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodesByCustomerIDParallel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodesByCustomerIDParallelResponse and nil error while calling GetTranscodesByCustomerIDParallel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByContentID(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTranscodesByContentIDJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTranscodesByContentIDProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByContentIDJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByContentID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTranscodesByContentIDRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodesByContentID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodesResponse and nil error while calling GetTranscodesByContentID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByContentIDProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByContentID")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTranscodesByContentIDRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodesByContentID(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodesResponse and nil error while calling GetTranscodesByContentID. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTranscodesByChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTranscodesByChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTranscodesByChannelRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodesByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodesResponse and nil error while calling GetTranscodesByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTranscodesByChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodesByChannel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodesResponse and nil error while calling GetTranscodesByChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByOriginFQDN(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetTranscodesByOriginFQDNJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetTranscodesByOriginFQDNProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByOriginFQDNJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByOriginFQDN")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetTranscodesByOriginFQDNRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodesByOriginFQDN(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodesResponse and nil error while calling GetTranscodesByOriginFQDN. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetTranscodesByOriginFQDNProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetTranscodesByOriginFQDN")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetTranscodesByOriginFQDNRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetTranscodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetTranscodesByOriginFQDN(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetTranscodesResponse and nil error while calling GetTranscodesByOriginFQDN. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveDeleteTranscode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteTranscodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteTranscodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveDeleteTranscodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteTranscodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Transcode
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.DeleteTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Transcode and nil error while calling DeleteTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveDeleteTranscodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(DeleteTranscodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Transcode
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.DeleteTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Transcode and nil error while calling DeleteTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveUpdateTranscode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateTranscodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateTranscodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveUpdateTranscodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateTranscodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Transcode
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.UpdateTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Transcode and nil error while calling UpdateTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveUpdateTranscodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateTranscodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Transcode
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.UpdateTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Transcode and nil error while calling UpdateTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveUpdateTranscodeSourceProperties(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateTranscodeSourcePropertiesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateTranscodeSourcePropertiesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveUpdateTranscodeSourcePropertiesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTranscodeSourceProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateTranscodeSourcePropertiesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Transcode
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.UpdateTranscodeSourceProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Transcode and nil error while calling UpdateTranscodeSourceProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveUpdateTranscodeSourcePropertiesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateTranscodeSourceProperties")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(UpdateTranscodeSourcePropertiesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Transcode
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.UpdateTranscodeSourceProperties(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Transcode and nil error while calling UpdateTranscodeSourceProperties. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveRecreateTranscode(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRecreateTranscodeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRecreateTranscodeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveRecreateTranscodeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RecreateTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RecreateTranscodeRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Transcode
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.RecreateTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Transcode and nil error while calling RecreateTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveRecreateTranscodeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RecreateTranscode")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RecreateTranscodeRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *Transcode
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.RecreateTranscode(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Transcode and nil error while calling RecreateTranscode. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetRecordingConfigurationWithCredentials(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRecordingConfigurationWithCredentialsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRecordingConfigurationWithCredentialsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveGetRecordingConfigurationWithCredentialsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfigurationWithCredentials")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetRecordingConfigurationWithCredentialsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRecordingConfigurationWithCredentialsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetRecordingConfigurationWithCredentials(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRecordingConfigurationWithCredentialsResponse and nil error while calling GetRecordingConfigurationWithCredentials. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveGetRecordingConfigurationWithCredentialsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRecordingConfigurationWithCredentials")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(GetRecordingConfigurationWithCredentialsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *GetRecordingConfigurationWithCredentialsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.GetRecordingConfigurationWithCredentials(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetRecordingConfigurationWithCredentialsResponse and nil error while calling GetRecordingConfigurationWithCredentials. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveRefreshCapacity(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRefreshCapacityJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRefreshCapacityProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveRefreshCapacityJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefreshCapacity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RefreshCapacityRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefreshCapacityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.RefreshCapacity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefreshCapacityResponse and nil error while calling RefreshCapacity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveRefreshCapacityProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RefreshCapacity")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(RefreshCapacityRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *RefreshCapacityResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.RefreshCapacity(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RefreshCapacityResponse and nil error while calling RefreshCapacity. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveScanTranscodes(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveScanTranscodesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveScanTranscodesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTranscodeStateMgrServer) serveScanTranscodesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanTranscodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ScanTranscodesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the json request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanTranscodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.ScanTranscodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanTranscodesResponse and nil error while calling ScanTranscodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	respBytes := buf.Bytes()
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) serveScanTranscodesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ScanTranscodes")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to read request body"))
		return
	}
	reqContent := new(ScanTranscodesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	// Call service method
	var respContent *ScanTranscodesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = s.StarfruitTranscodeStateMgr.ScanTranscodes(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ScanTranscodesResponse and nil error while calling ScanTranscodes. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTranscodeStateMgrServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *starfruitTranscodeStateMgrServer) ProtocGenTwirpVersion() string {
	return "v5.12.1"
}

func (s *starfruitTranscodeStateMgrServer) PathPrefix() string {
	return StarfruitTranscodeStateMgrPathPrefix
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route twirp requests
	// alongside non-twirp requests on one HTTP listener.
	PathPrefix() string
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.12.1")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 3319 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5b, 0xcb, 0x73, 0x1b, 0xc7,
	0xd1, 0xff, 0x96, 0x14, 0x08, 0xa0, 0xc1, 0x07, 0x38, 0x92, 0x40, 0x10, 0x92, 0x4d, 0x1a, 0xf2,
	0x83, 0x9f, 0x3e, 0x17, 0xa8, 0x8f, 0x94, 0xed, 0xf8, 0x21, 0xcb, 0x7c, 0x49, 0x86, 0x25, 0x52,
	0xf4, 0x92, 0xa2, 0x62, 0x5d, 0xd6, 0x8b, 0xdd, 0x01, 0xb8, 0xe2, 0x62, 0x77, 0xbd, 0x3b, 0x80,
	0x04, 0xdf, 0x72, 0x71, 0xa5, 0x72, 0xcb, 0xab, 0x92, 0x53, 0x92, 0x43, 0xca, 0x55, 0xa9, 0xfc,
	0x0d, 0xf9, 0x07, 0x5c, 0xb9, 0xe6, 0x9c, 0xbf, 0x20, 0x97, 0x54, 0xe5, 0x94, 0x4b, 0x6a, 0x1e,
	0xbb, 0xd8, 0x5d, 0x2c, 0x84, 0x05, 0x44, 0x56, 0xe5, 0xa2, 0xe2, 0xf4, 0x76, 0xf7, 0xf4, 0xf4,
	0xf4, 0x74, 0xf7, 0xfc, 0x30, 0x82, 0xbb, 0x9a, 0xad, 0xe3, 0xda, 0xb3, 0x8e, 0x47, 0x0c, 0xab,
	0x46, 0xba, 0xeb, 0x6a, 0xfb, 0x5b, 0x6b, 0xfd, 0x88, 0xa8, 0x6e, 0xd3, 0xed, 0x18, 0xe4, 0xd8,
	0x55, 0x2d, 0x8f, 0x72, 0x1c, 0x11, 0x95, 0xe0, 0xfd, 0x96, 0x7b, 0xfc, 0xdc, 0x70, 0x9d, 0x75,
	0x42, 0xff, 0xad, 0x39, 0xae, 0x4d, 0x6c, 0xf4, 0x0e, 0x79, 0x6e, 0x10, 0xed, 0xb4, 0xd6, 0x35,
	0x74, 0x6c, 0xd7, 0x3c, 0x5f, 0x92, 0xf8, 0x92, 0x1e, 0x95, 0x6c, 0xb7, 0xdc, 0xca, 0x4a, 0xcb,
	0xb6, 0x5b, 0x26, 0x5e, 0x67, 0x62, 0x8d, 0x4e, 0x73, 0x9d, 0x18, 0x6d, 0xfa, 0xb5, 0x2d, 0x34,
	0x55, 0x5e, 0x8f, 0x33, 0x3c, 0x77, 0x55, 0xc7, 0xc1, 0xae, 0x27, 0xbe, 0xdf, 0x8a, 0x99, 0xca,
	0x66, 0xe4, 0xdc, 0x9a, 0x6d, 0x7a, 0xf4, 0xaf, 0x06, 0xe6, 0xff, 0x72, 0x89, 0xea, 0xbf, 0xa6,
	0xa0, 0x78, 0x64, 0x77, 0x5c, 0x0d, 0x1f, 0xba, 0xb6, 0x83, 0x5d, 0x62, 0x60, 0x0f, 0xad, 0x40,
	0x81, 0x49, 0x2a, 0x54, 0x9d, 0x56, 0x96, 0x56, 0xa5, 0xb5, 0xbc, 0x0c, 0x8c, 0xb4, 0x43, 0x29,
	0x94, 0x41, 0xed, 0xe8, 0x86, 0xcf, 0x30, 0xc5, 0x19, 0x18, 0xa9, 0xcf, 0xd0, 0xd5, 0x14, 0xc7,
	0xb5, 0x9b, 0x86, 0x89, 0xcb, 0xd3, 0x82, 0xa1, 0xab, 0x1d, 0x72, 0x0a, 0xba, 0x06, 0x79, 0xca,
	0x60, 0xe2, 0x2e, 0x36, 0xcb, 0x97, 0xd8, 0xe7, 0x9c, 0xda, 0xd5, 0x1e, 0xd2, 0x31, 0x7a, 0x03,
	0x66, 0x9f, 0x1b, 0x3a, 0x39, 0x55, 0x1c, 0xe3, 0x05, 0x36, 0xbd, 0x72, 0x66, 0x55, 0x5a, 0xcb,
	0xc8, 0x05, 0x46, 0x3b, 0x64, 0x24, 0x74, 0x03, 0xe6, 0x4e, 0xb1, 0xd1, 0x3a, 0x25, 0x3e, 0xcf,
	0x0c, 0xe3, 0x99, 0xe5, 0x44, 0xc1, 0xf4, 0x26, 0xcc, 0x7b, 0x6a, 0xdb, 0x31, 0xb1, 0xe2, 0xaa,
	0x04, 0x2b, 0xa7, 0xdf, 0x96, 0xb3, 0xab, 0xd2, 0x9a, 0x24, 0xcf, 0x72, 0xaa, 0xac, 0x12, 0xfc,
	0xf9, 0xb7, 0xdc, 0x56, 0xec, 0xaa, 0x2d, 0xac, 0x34, 0x1d, 0xaf, 0x9c, 0x63, 0x2c, 0x20, 0x48,
	0xf7, 0x1c, 0x8f, 0x9a, 0xe3, 0x33, 0x9c, 0x35, 0x1c, 0xaf, 0x9c, 0x67, 0x1c, 0xbe, 0xd0, 0x83,
	0x86, 0xe3, 0xa1, 0x75, 0xb8, 0xd2, 0x56, 0x5f, 0x28, 0x86, 0xee, 0x2a, 0x3a, 0x36, 0x89, 0xaa,
	0xb4, 0x0d, 0xd3, 0x34, 0xbc, 0x32, 0x30, 0xd6, 0xc5, 0xb6, 0xfa, 0xa2, 0xae, 0xbb, 0xbb, 0xf4,
	0xcb, 0x3e, 0xfb, 0x50, 0x7d, 0x01, 0x85, 0x87, 0x27, 0x47, 0xfb, 0x98, 0xa8, 0xba, 0x4a, 0x54,
	0x3a, 0x85, 0x67, 0x79, 0x0a, 0xb6, 0x74, 0xc7, 0x36, 0x2c, 0x22, 0x5c, 0x5e, 0xf0, 0x2c, 0x6f,
	0x4f, 0x90, 0xd0, 0x75, 0x00, 0x6f, 0x53, 0xe9, 0xda, 0xba, 0xd2, 0x71, 0x4d, 0xe1, 0xf2, 0x9c,
	0xb7, 0x79, 0x62, 0xeb, 0x8f, 0x5d, 0x13, 0xad, 0x41, 0x91, 0x7e, 0x6a, 0xab, 0x96, 0xd1, 0xc4,
	0x1e, 0x61, 0x3c, 0xdc, 0xeb, 0xf3, 0x5d, 0x5b, 0xdf, 0x17, 0xe4, 0xc7, 0xae, 0x59, 0xfd, 0x6e,
	0x0a, 0x16, 0x65, 0x6c, 0xe9, 0x06, 0x31, 0x6c, 0x2b, 0x30, 0x60, 0x19, 0x72, 0x2d, 0xd7, 0xee,
	0x38, 0x8a, 0xa1, 0x8b, 0xc9, 0xb3, 0x6c, 0x5c, 0xd7, 0xa9, 0xab, 0x75, 0xc3, 0x73, 0x4c, 0xb5,
	0xa7, 0x98, 0x6a, 0x03, 0xfb, 0x73, 0xcf, 0x0a, 0xe2, 0x43, 0x4a, 0xa3, 0xf2, 0xed, 0xce, 0x0b,
	0xe6, 0x67, 0x36, 0x6f, 0x46, 0xce, 0xb6, 0x3b, 0x2f, 0xa8, 0x87, 0xe9, 0xda, 0x78, 0x34, 0xf1,
	0xbd, 0x61, 0xbb, 0x9d, 0x91, 0x79, 0x84, 0x7d, 0xce, 0x48, 0xfd, 0x80, 0x63, 0x5b, 0x2c, 0xf6,
	0x9b, 0x07, 0xdc, 0x13, 0x4a, 0x41, 0x25, 0x98, 0x61, 0xa1, 0x46, 0xf7, 0x79, 0x7a, 0x2d, 0x2f,
	0x8b, 0x11, 0x2a, 0xc2, 0x34, 0xdd, 0xb3, 0x2c, 0x13, 0xa0, 0x7f, 0x52, 0x47, 0xf8, 0x3b, 0x61,
	0x58, 0x04, 0xbb, 0x5d, 0xd5, 0x64, 0x5b, 0x9a, 0x91, 0xe7, 0xf9, 0x2e, 0xd4, 0x05, 0xb5, 0xfa,
	0xfd, 0x34, 0x2c, 0x6e, 0xbb, 0xb6, 0xaa, 0x6b, 0xaa, 0x47, 0x02, 0x47, 0xac, 0x42, 0xa1, 0xe1,
	0x13, 0xb1, 0xeb, 0x6f, 0x44, 0x88, 0x84, 0xe6, 0x61, 0xca, 0xf6, 0x84, 0x13, 0xa6, 0x6c, 0x8f,
	0x86, 0xb2, 0x66, 0x1a, 0xd8, 0x22, 0xd4, 0x77, 0xdc, 0xe7, 0x39, 0x4e, 0xa8, 0xeb, 0x74, 0x65,
	0x9e, 0x7e, 0xa6, 0x74, 0xb1, 0xeb, 0x19, 0xb6, 0x25, 0x22, 0x1d, 0x3c, 0xfd, 0xec, 0x84, 0x53,
	0xa8, 0x77, 0xf9, 0xd2, 0xb1, 0x45, 0xd7, 0xe4, 0xb2, 0xc5, 0xe7, 0x65, 0xee, 0xb2, 0x3d, 0x4e,
	0x43, 0xaf, 0x01, 0x58, 0xb6, 0xa2, 0xba, 0xda, 0xa9, 0xd1, 0xc5, 0x2c, 0xd4, 0x73, 0x72, 0xde,
	0xb2, 0xb7, 0x38, 0x01, 0xbd, 0x05, 0xf3, 0x0d, 0xd5, 0xd2, 0xf9, 0x99, 0x21, 0xd8, 0x23, 0xcc,
	0x21, 0x39, 0x79, 0x2e, 0xa0, 0x1e, 0x63, 0x8f, 0xd0, 0xa9, 0x9a, 0xb6, 0xab, 0x61, 0x45, 0x3b,
	0x55, 0x2d, 0x0b, 0x73, 0xbf, 0xe4, 0xe5, 0x59, 0x46, 0xdc, 0xe1, 0x34, 0xca, 0x14, 0x2c, 0x56,
	0x21, 0x6a, 0x8b, 0x45, 0x7b, 0x5e, 0x9e, 0x0d, 0x88, 0xc7, 0x6a, 0x8b, 0x2e, 0xd9, 0x25, 0x6d,
	0x47, 0x69, 0x9a, 0x6a, 0x8b, 0xc5, 0x78, 0x5e, 0xce, 0x51, 0xc2, 0x3d, 0x53, 0x6d, 0xa1, 0x0a,
	0xe4, 0x5c, 0xac, 0xd9, 0x2e, 0x5d, 0x4c, 0x41, 0x7c, 0x13, 0x63, 0xba, 0x8f, 0x0d, 0x55, 0x3b,
	0xeb, 0x38, 0xe5, 0x59, 0xf6, 0x45, 0x8c, 0xc2, 0x3e, 0x74, 0xca, 0x73, 0x11, 0x1f, 0x3a, 0xd5,
	0xa7, 0x30, 0x1f, 0xce, 0xb2, 0xda, 0x19, 0x5d, 0x70, 0x90, 0x3d, 0x15, 0xd2, 0x73, 0xb0, 0xd8,
	0xa7, 0xb9, 0x80, 0x7a, 0xdc, 0x73, 0x58, 0xe4, 0x09, 0xaf, 0x72, 0x26, 0xbe, 0x67, 0x05, 0x41,
	0xa3, 0x2c, 0xd5, 0x5f, 0x4c, 0xc3, 0xfc, 0x21, 0xcd, 0x87, 0x27, 0xd4, 0xdf, 0xbb, 0x34, 0x02,
	0xde, 0x83, 0x6c, 0xc3, 0x20, 0x2c, 0x92, 0xa9, 0xd6, 0xc2, 0xc6, 0xb5, 0x1a, 0x4f, 0xbb, 0x35,
	0x3f, 0xed, 0xd6, 0xea, 0x16, 0xd9, 0xdc, 0x38, 0x51, 0xcd, 0x0e, 0x96, 0x7d, 0x5e, 0xb4, 0x97,
	0x10, 0x78, 0x53, 0xa3, 0xe5, 0x63, 0x51, 0x89, 0x36, 0x61, 0x46, 0x9c, 0x93, 0xe9, 0xd1, 0xc2,
	0x82, 0x15, 0xfd, 0x3f, 0x64, 0xf8, 0xc9, 0xb9, 0x34, 0x5a, 0x86, 0x73, 0xa2, 0x1a, 0x3f, 0x39,
	0x19, 0x26, 0x70, 0x7d, 0x40, 0x60, 0xd7, 0xee, 0x34, 0x4c, 0xcc, 0x25, 0xd8, 0xb9, 0x7a, 0x1f,
	0xb2, 0x7e, 0x36, 0x9f, 0x19, 0x22, 0x73, 0x44, 0x5c, 0xc3, 0x6a, 0x09, 0xb7, 0x08, 0x66, 0xb4,
	0x01, 0x19, 0x5e, 0x24, 0xb2, 0x29, 0xa4, 0x38, 0x6b, 0xf5, 0x9f, 0x92, 0xd8, 0x94, 0x2d, 0x5a,
	0x51, 0x5e, 0x65, 0x53, 0x3e, 0x81, 0x42, 0xa8, 0x02, 0xa4, 0xd9, 0x0f, 0xe8, 0xd7, 0x06, 0xf4,
	0x01, 0xe4, 0xc4, 0x51, 0xf1, 0xd2, 0xec, 0x46, 0xc0, 0xdc, 0x5f, 0xf4, 0xa5, 0xf4, 0x8b, 0xfe,
	0x9b, 0x04, 0x79, 0xb6, 0x68, 0xb6, 0xde, 0x13, 0xe0, 0xe9, 0x4f, 0xa1, 0x49, 0x49, 0x2c, 0xf9,
	0x83, 0x5a, 0xca, 0x46, 0xa2, 0x16, 0x8d, 0x68, 0x39, 0xdf, 0x0d, 0x82, 0xfb, 0x04, 0x78, 0x99,
	0xe6, 0x7a, 0xa7, 0x26, 0xd1, 0x1b, 0x6c, 0x8a, 0x9c, 0x57, 0x83, 0xfd, 0x29, 0x43, 0x56, 0xc7,
	0x4d, 0xb5, 0x63, 0xf2, 0xb8, 0xcd, 0xc9, 0xfe, 0xb0, 0xfa, 0xbb, 0x22, 0xe4, 0x83, 0xe3, 0x4b,
	0x8f, 0x64, 0xff, 0xe4, 0x06, 0xb5, 0xa6, 0x10, 0xd0, 0x78, 0xca, 0xd4, 0x3a, 0x1e, 0xb1, 0xdb,
	0xd8, 0xa5, 0x1c, 0xa2, 0xb9, 0xf0, 0x49, 0x75, 0x9d, 0x66, 0x43, 0xcd, 0xb6, 0x48, 0x24, 0xe3,
	0xe6, 0x05, 0xa5, 0xae, 0x53, 0x53, 0xfc, 0x04, 0xc7, 0xd3, 0xad, 0x3f, 0xa4, 0x59, 0xc6, 0x23,
	0x2e, 0x56, 0xdb, 0x54, 0x8e, 0x46, 0xfe, 0xb4, 0x9c, 0xe3, 0x84, 0xba, 0x8e, 0x3e, 0x86, 0x82,
	0xe6, 0x62, 0xda, 0x27, 0xd0, 0xae, 0x4b, 0x04, 0x79, 0x65, 0x60, 0xe7, 0x8e, 0xfd, 0x96, 0x4c,
	0x06, 0xce, 0x4e, 0x09, 0x54, 0xb8, 0xe3, 0xe8, 0x81, 0x70, 0x76, 0xb4, 0x30, 0x67, 0x67, 0xc2,
	0xf7, 0x60, 0x51, 0x98, 0x45, 0x5d, 0x4f, 0xb8, 0x8a, 0xdc, 0x48, 0x15, 0x0b, 0x5c, 0x88, 0x76,
	0xa2, 0x84, 0xe9, 0x39, 0x84, 0x19, 0xba, 0x53, 0x1d, 0xde, 0xa1, 0xcc, 0x6f, 0xfc, 0x28, 0xf5,
	0xbe, 0x46, 0x9a, 0xd8, 0x8e, 0x27, 0x0b, 0x3d, 0xd4, 0xd3, 0x1e, 0xf6, 0x68, 0x9d, 0xa2, 0x1e,
	0xe3, 0x89, 0x3e, 0x2f, 0x28, 0x75, 0x9d, 0x56, 0xdf, 0x8e, 0x6b, 0x88, 0x24, 0x4f, 0xff, 0xa4,
	0x7b, 0x67, 0xbb, 0x46, 0xcb, 0xb0, 0x94, 0xe6, 0x37, 0xba, 0x25, 0x92, 0x3c, 0x70, 0xd2, 0xbd,
	0x6f, 0x74, 0x0b, 0x19, 0x80, 0x5c, 0xbf, 0xf9, 0x50, 0xda, 0xa2, 0xe8, 0x96, 0xe7, 0x56, 0xa7,
	0xd7, 0x0a, 0x1b, 0x1f, 0xa5, 0xb6, 0x77, 0xa0, 0x7f, 0x91, 0x17, 0xdd, 0x81, 0x96, 0xe6, 0x01,
	0xe4, 0x9e, 0xd9, 0x0d, 0x9e, 0xf9, 0xe7, 0x99, 0x43, 0x6e, 0xa5, 0x9e, 0xe0, 0x0b, 0xbb, 0x41,
	0xcb, 0x83, 0x9c, 0x7d, 0xc6, 0xff, 0x40, 0x4b, 0x40, 0xff, 0x54, 0xce, 0x70, 0xaf, 0xbc, 0xc0,
	0xba, 0x89, 0x99, 0x67, 0x76, 0xe3, 0x01, 0xee, 0xa1, 0x27, 0x30, 0x6b, 0xaa, 0x04, 0x5b, 0x5a,
	0x4f, 0x69, 0xdb, 0x3a, 0x2e, 0x17, 0xd9, 0x4c, 0xb7, 0x53, 0xcf, 0xf4, 0x90, 0x0b, 0xef, 0xdb,
	0x3a, 0x96, 0x0b, 0x66, 0x7f, 0xc0, 0x14, 0x77, 0xbd, 0xbe, 0x8f, 0x16, 0x59, 0x40, 0x8c, 0xa1,
	0xb8, 0xdf, 0x5e, 0xca, 0x05, 0xb3, 0xeb, 0x05, 0x7e, 0x59, 0x01, 0x51, 0x01, 0xb9, 0x6b, 0x10,
	0xdf, 0x23, 0x4e, 0x62, 0x6b, 0xfd, 0x3f, 0x58, 0xec, 0x9f, 0x51, 0x3f, 0xe9, 0x5f, 0x66, 0x6c,
	0xc5, 0xe0, 0x83, 0xdf, 0xc8, 0xbf, 0x03, 0x0b, 0x01, 0x8d, 0x56, 0xbe, 0xa6, 0x5d, 0xbe, 0xc2,
	0xfb, 0xce, 0x3e, 0xb9, 0x6e, 0x35, 0x6d, 0xf4, 0x2e, 0x20, 0x6c, 0x69, 0x6e, 0xcf, 0x61, 0x5b,
	0x7f, 0x86, 0x7b, 0x8a, 0xa1, 0x7b, 0xe5, 0xab, 0xac, 0x9d, 0x2b, 0xf6, 0xbf, 0x3c, 0xc0, 0xbd,
	0xba, 0xee, 0xd1, 0x7e, 0x92, 0x75, 0x18, 0xb4, 0x8f, 0x2d, 0xf1, 0x53, 0x4c, 0xc7, 0xb4, 0xd5,
	0x35, 0x00, 0xf5, 0x3b, 0x94, 0xc0, 0x3d, 0x4b, 0xcc, 0x3d, 0xe9, 0x43, 0x68, 0xa0, 0xf3, 0x93,
	0x17, 0x1b, 0x03, 0xcd, 0x60, 0x13, 0x16, 0x3d, 0x76, 0x39, 0xa2, 0x6e, 0x10, 0xb7, 0xa3, 0x72,
	0x99, 0xcd, 0xf4, 0x61, 0xea, 0x99, 0xe2, 0xd7, 0x2b, 0xb9, 0xe8, 0xc5, 0x2f, 0x5c, 0x37, 0x60,
	0x8e, 0x9c, 0x76, 0xda, 0x0d, 0x4b, 0x35, 0x4c, 0x85, 0x1e, 0xa9, 0x65, 0xde, 0x74, 0x05, 0xc4,
	0xc7, 0xae, 0x81, 0xbe, 0x04, 0x60, 0x37, 0x37, 0x9e, 0xba, 0x2b, 0xcc, 0x8a, 0x8d, 0xf1, 0x52,
	0x37, 0xcf, 0xda, 0x4e, 0x50, 0x65, 0xca, 0x90, 0xf5, 0x3b, 0xd3, 0x6b, 0xbc, 0x69, 0x17, 0x43,
	0x1a, 0x24, 0xba, 0xdb, 0x56, 0xb0, 0xa5, 0x36, 0x4c, 0xac, 0x97, 0xaf, 0xb3, 0x9c, 0x0e, 0xba,
	0xdb, 0xde, 0xe3, 0x14, 0xd6, 0xb2, 0xdb, 0x7a, 0xd0, 0x93, 0xbe, 0xc6, 0x19, 0xba, 0xb6, 0xee,
	0x37, 0xa5, 0x9f, 0xc2, 0x35, 0xe1, 0xbb, 0xfe, 0x81, 0x77, 0xb1, 0x47, 0x5c, 0x43, 0x23, 0x58,
	0x2f, 0xbf, 0xce, 0x04, 0x96, 0x39, 0x4b, 0x70, 0x9e, 0xe5, 0x80, 0x81, 0x9e, 0x38, 0x4d, 0xb7,
	0x58, 0x00, 0xac, 0xf0, 0x5e, 0x51, 0xd3, 0x2d, 0xba, 0xff, 0x83, 0xcd, 0xdf, 0x6a, 0x52, 0xf3,
	0xf7, 0x36, 0x2c, 0x88, 0xf9, 0xed, 0xa6, 0x42, 0xdc, 0x0e, 0x39, 0x2d, 0xbf, 0xc1, 0xbb, 0x62,
	0x4e, 0x7e, 0xd4, 0x3c, 0xa6, 0x44, 0xf4, 0x35, 0x2c, 0x38, 0xae, 0xad, 0xd1, 0xa4, 0x66, 0xb5,
	0xf8, 0x19, 0xae, 0xb2, 0x33, 0x3c, 0x56, 0x59, 0x14, 0xf2, 0xec, 0x18, 0xcf, 0x3b, 0x91, 0x31,
	0xfa, 0x10, 0x96, 0x83, 0x7a, 0x65, 0x11, 0xdc, 0x72, 0x0d, 0xd2, 0x53, 0x9c, 0x0e, 0xcf, 0x26,
	0x37, 0x98, 0xed, 0x25, 0xbf, 0x7c, 0xf9, 0xdf, 0x0f, 0x3b, 0x2c, 0xbb, 0x3c, 0x80, 0xea, 0xa0,
	0xa8, 0x67, 0xb4, 0x2c, 0x6a, 0x6b, 0xd0, 0x66, 0xbe, 0xb9, 0x2a, 0xad, 0x5d, 0x92, 0x57, 0xe2,
	0x3a, 0x8e, 0x38, 0x5f, 0xd0, 0x5a, 0x2a, 0x70, 0xb9, 0x65, 0x1b, 0x56, 0x8b, 0xde, 0x0f, 0x43,
	0x91, 0xf4, 0x16, 0x8b, 0xa4, 0xf5, 0x5a, 0x14, 0x3b, 0x10, 0xab, 0x0e, 0xb0, 0x83, 0x1a, 0x47,
	0x0d, 0xfa, 0x61, 0xb4, 0xe8, 0xeb, 0xea, 0x37, 0x2d, 0xb7, 0xa1, 0x14, 0x9b, 0xc0, 0x8f, 0x9f,
	0xb7, 0x99, 0xe7, 0xaf, 0x44, 0x44, 0x44, 0x24, 0x55, 0xff, 0x9a, 0x83, 0xd2, 0x0e, 0x2f, 0xa5,
	0xbe, 0x67, 0x65, 0xfc, 0x4d, 0x87, 0xde, 0x58, 0xa2, 0x95, 0x5e, 0x8a, 0x57, 0xfa, 0x91, 0x9d,
	0x42, 0xa8, 0x15, 0x98, 0x8e, 0xb6, 0x02, 0x89, 0x35, 0xf7, 0xd2, 0xf8, 0x35, 0x37, 0x9c, 0xa7,
	0x32, 0xd1, 0x3c, 0x15, 0x2d, 0x9e, 0x33, 0xf1, 0xe2, 0x19, 0x8a, 0xef, 0x6c, 0x24, 0xbe, 0x1b,
	0xd0, 0xcf, 0xb2, 0xd4, 0x3a, 0xed, 0xcc, 0x2b, 0xe7, 0x58, 0x81, 0xfc, 0x60, 0xa2, 0x82, 0xae,
	0x9d, 0xc9, 0xfd, 0x14, 0xcd, 0xc6, 0xec, 0xce, 0xea, 0x6d, 0x2a, 0x8d, 0x8e, 0x76, 0x86, 0x89,
	0xb8, 0xe1, 0xe5, 0xbc, 0xcd, 0x6d, 0x36, 0x16, 0x1f, 0x1d, 0x17, 0x37, 0x8d, 0x17, 0xfe, 0xed,
	0xce, 0xdb, 0x3c, 0x64, 0xe3, 0x01, 0xa4, 0xa2, 0x30, 0x88, 0x54, 0xc4, 0x4b, 0xe2, 0xec, 0x79,
	0x95, 0xc4, 0x15, 0x28, 0x88, 0x7c, 0xa3, 0x74, 0x6d, 0x9d, 0xdd, 0x13, 0x73, 0x32, 0x08, 0xd2,
	0x89, 0xcd, 0x3a, 0x43, 0x1e, 0x71, 0x8a, 0xee, 0xb6, 0x59, 0xd1, 0xcf, 0xc9, 0x79, 0x4e, 0xd9,
	0x75, 0xdb, 0xe8, 0x23, 0x58, 0xf6, 0x33, 0x90, 0x12, 0xcf, 0x4d, 0xac, 0xac, 0xe7, 0xe4, 0x25,
	0x9f, 0xe1, 0x28, 0x9a, 0x98, 0x86, 0x54, 0x9d, 0xe2, 0x45, 0x54, 0x9d, 0x12, 0xcc, 0x50, 0x5f,
	0xbb, 0x98, 0xd5, 0xfc, 0x9c, 0x2c, 0x46, 0x49, 0x19, 0x0d, 0xa5, 0xcc, 0x68, 0x97, 0xcf, 0x37,
	0xa3, 0xdd, 0x86, 0x12, 0xbf, 0xd2, 0xd3, 0x09, 0x34, 0xdb, 0x6a, 0x1a, 0x2d, 0xa5, 0xd1, 0x23,
	0xd8, 0x63, 0xb5, 0x7f, 0x56, 0xbe, 0x12, 0x7c, 0xdd, 0x61, 0x1f, 0xb7, 0xe9, 0x37, 0x54, 0x4b,
	0xce, 0x3f, 0x57, 0x99, 0xc8, 0x58, 0xe9, 0xa4, 0xf4, 0x92, 0x74, 0xf2, 0xef, 0x0c, 0x5c, 0x17,
	0xe9, 0x84, 0x2d, 0x76, 0xdc, 0xa4, 0x12, 0xca, 0x19, 0x53, 0x29, 0x72, 0xc6, 0xf4, 0xab, 0xe5,
	0x8c, 0x4b, 0x2f, 0xcb, 0x19, 0x99, 0x78, 0xce, 0x48, 0x4a, 0x0d, 0x33, 0xe7, 0x9c, 0x1a, 0xe2,
	0xa7, 0x37, 0x7b, 0x41, 0xa7, 0x37, 0x37, 0xe2, 0xf4, 0xe6, 0xc7, 0x3a, 0xbd, 0x30, 0xc9, 0xe9,
	0x2d, 0x5c, 0xec, 0xe9, 0x9d, 0x8d, 0x9c, 0xde, 0x21, 0xd1, 0x3f, 0x37, 0x7e, 0xf4, 0xcf, 0xbf,
	0x24, 0xfa, 0xdb, 0xb0, 0x34, 0x50, 0x4b, 0x3d, 0xc7, 0xb6, 0x3c, 0x8c, 0x64, 0x80, 0xfe, 0x92,
	0xca, 0x12, 0x0b, 0x9b, 0x8d, 0xf1, 0xc3, 0x46, 0x0e, 0x69, 0xa9, 0xfe, 0x5e, 0x82, 0xb2, 0x8c,
	0xb5, 0xe4, 0xea, 0x9d, 0xe2, 0xae, 0xff, 0x75, 0xe8, 0xf6, 0xc0, 0x03, 0x7a, 0x6c, 0x4c, 0x22,
	0x16, 0xcf, 0xf3, 0xd1, 0x78, 0xae, 0x7e, 0x02, 0x4b, 0xf7, 0x71, 0xff, 0x57, 0x9a, 0xed, 0x5e,
	0x7d, 0x37, 0xbd, 0x7d, 0xd5, 0x53, 0xb8, 0x12, 0x96, 0x0e, 0x7c, 0x79, 0x08, 0xf9, 0x80, 0x4d,
	0xa0, 0x33, 0x93, 0xb8, 0xb2, 0xaf, 0xa4, 0xfa, 0x6b, 0x09, 0xd6, 0xc2, 0x53, 0x79, 0xdb, 0xbd,
	0x1d, 0xbf, 0x91, 0xd9, 0x3d, 0x54, 0x5d, 0xd5, 0x34, 0xb1, 0xe9, 0x5b, 0x1e, 0x6b, 0x7c, 0xa4,
	0x81, 0xc6, 0xe7, 0x3a, 0xe4, 0x1d, 0xd5, 0x25, 0xfc, 0x6c, 0x4c, 0x31, 0xa4, 0xa3, 0x4f, 0x40,
	0x37, 0x61, 0xd1, 0x64, 0xf0, 0x6e, 0x78, 0xf5, 0xbc, 0x41, 0x5a, 0xa0, 0x1f, 0x8e, 0x43, 0x1e,
	0xf8, 0xb3, 0x04, 0xff, 0x9b, 0xc2, 0xae, 0x8b, 0x8b, 0xb1, 0x64, 0x6b, 0xa7, 0x92, 0xad, 0xfd,
	0x0c, 0x56, 0xe2, 0xc6, 0x8a, 0xc4, 0xbe, 0x9b, 0x2e, 0xfd, 0x57, 0x5b, 0xf0, 0x5a, 0x5c, 0x03,
	0x4f, 0xff, 0xbe, 0x7c, 0xa8, 0x3e, 0x48, 0xd1, 0xfa, 0xf0, 0x2e, 0xa0, 0x16, 0x26, 0x8a, 0x6a,
	0x9a, 0x4a, 0xc8, 0x09, 0x53, 0xec, 0xb4, 0x16, 0x5b, 0x98, 0x6c, 0x99, 0x66, 0x5f, 0x6f, 0x75,
	0x07, 0x56, 0x63, 0x13, 0x3d, 0xe2, 0x30, 0xc9, 0x97, 0xbb, 0x07, 0xa1, 0x7d, 0x0e, 0xc3, 0x29,
	0x52, 0x1c, 0x4e, 0xa9, 0x9e, 0xc1, 0xd5, 0x88, 0x92, 0x0b, 0x3d, 0xec, 0x1f, 0x43, 0x69, 0x17,
	0x9b, 0x78, 0xa2, 0x93, 0x5e, 0xfd, 0x8d, 0x04, 0xa5, 0xc7, 0x1c, 0xf3, 0x9a, 0x20, 0x4f, 0x3c,
	0x0d, 0x9f, 0x37, 0x9e, 0x21, 0x3e, 0x19, 0x7f, 0x35, 0x7c, 0x7e, 0x7e, 0x09, 0xee, 0x9f, 0xbc,
	0x9f, 0x4a, 0x70, 0x6d, 0x00, 0x50, 0xea, 0xb3, 0x0e, 0x81, 0xac, 0xa4, 0x0b, 0x80, 0xac, 0xaa,
	0x5f, 0x40, 0x65, 0x2f, 0x86, 0x84, 0x84, 0x0c, 0x49, 0x46, 0x50, 0xa4, 0x64, 0x04, 0xa5, 0xda,
	0x86, 0xe5, 0x18, 0xac, 0x17, 0x52, 0xd5, 0x87, 0x0a, 0xa5, 0xf3, 0x81, 0x0a, 0xab, 0xff, 0xc8,
	0xc2, 0xe5, 0x04, 0x47, 0xa3, 0x1a, 0xc7, 0x08, 0xa5, 0x14, 0x40, 0x38, 0x43, 0x10, 0x75, 0x80,
	0xc0, 0x2f, 0x9e, 0xd8, 0xea, 0xdd, 0xc9, 0xbd, 0x1c, 0xda, 0xf2, 0x90, 0xde, 0x01, 0x70, 0x6d,
	0xfa, 0xbc, 0xc0, 0xb5, 0x7a, 0x12, 0x76, 0x96, 0xe6, 0x57, 0x80, 0x41, 0x64, 0x6d, 0x6f, 0x10,
	0x59, 0xcb, 0xa4, 0x50, 0x14, 0xc7, 0xdd, 0x4c, 0x58, 0x88, 0x46, 0x8d, 0x27, 0xb0, 0xed, 0x9d,
	0xd4, 0xab, 0x1d, 0x1e, 0x93, 0xf2, 0x7c, 0x24, 0xee, 0x3c, 0xf4, 0x34, 0x08, 0x2c, 0x8e, 0x81,
	0x6f, 0x4f, 0x1a, 0x58, 0xa1, 0x39, 0x7c, 0x34, 0xfa, 0xbd, 0x3e, 0x5a, 0x95, 0x4b, 0xf1, 0x1b,
	0x90, 0x0f, 0x65, 0xdd, 0x89, 0x26, 0xd1, 0x7c, 0x0a, 0x1f, 0x86, 0x11, 0xeb, 0x28, 0xec, 0x56,
	0x38, 0x0f, 0xd8, 0xed, 0xc9, 0xcb, 0x00, 0xa1, 0xd9, 0x14, 0xf6, 0x0d, 0x83, 0x8b, 0x8c, 0x54,
	0x70, 0xd1, 0xdc, 0x90, 0x19, 0x1e, 0xd7, 0x2d, 0xf2, 0xfe, 0x6d, 0x3e, 0xc3, 0x28, 0x30, 0xa9,
	0xfa, 0xa7, 0x0c, 0x54, 0xe2, 0xc8, 0x66, 0xe8, 0xd8, 0xdf, 0x19, 0x7c, 0x42, 0x32, 0xd2, 0xe9,
	0xa1, 0x07, 0x26, 0x77, 0x06, 0x1f, 0x98, 0x8c, 0x14, 0x0f, 0x3d, 0x3f, 0xb9, 0x33, 0xf8, 0xfc,
	0x64, 0xb4, 0x78, 0xff, 0x71, 0xca, 0x87, 0xf1, 0xc7, 0x29, 0xa3, 0x84, 0xfb, 0x4f, 0x57, 0x3e,
	0x4d, 0x78, 0xba, 0x32, 0x22, 0x50, 0x23, 0xef, 0x5a, 0x3e, 0x4b, 0x7a, 0xd7, 0x32, 0x42, 0x41,
	0xf4, 0xd1, 0xcb, 0x76, 0xe2, 0xa3, 0x97, 0x51, 0xbf, 0xf1, 0x46, 0x9f, 0xc4, 0xdc, 0x19, 0x7c,
	0x12, 0x33, 0x4a, 0x41, 0xf8, 0xc1, 0xcc, 0xdd, 0x84, 0x07, 0x33, 0xa3, 0xe4, 0x23, 0xcf, 0x69,
	0xf6, 0x5f, 0xf2, 0x9c, 0x66, 0x94, 0xa2, 0x84, 0xc7, 0x36, 0x7f, 0x91, 0xe0, 0xed, 0x58, 0xef,
	0x31, 0x00, 0xca, 0xa7, 0xef, 0x45, 0x9c, 0xa4, 0x1f, 0x05, 0xb2, 0x63, 0xa6, 0xd4, 0xe1, 0x47,
	0x67, 0xf0, 0xe7, 0x81, 0xea, 0x0f, 0x12, 0x5c, 0x3d, 0xd2, 0x54, 0x2b, 0xdc, 0xe7, 0x71, 0x73,
	0x4b, 0x30, 0xa3, 0xd1, 0x0e, 0xdc, 0x7f, 0xa8, 0x22, 0x46, 0xb4, 0x49, 0xf5, 0x70, 0xab, 0x8d,
	0x2d, 0x22, 0xba, 0x7f, 0x7f, 0xc8, 0xd0, 0x73, 0x9b, 0xa8, 0xa6, 0x22, 0x08, 0xfc, 0x97, 0xed,
	0x69, 0x79, 0x8e, 0x51, 0x8f, 0x04, 0x31, 0xb9, 0xe9, 0xbe, 0x94, 0xd8, 0x74, 0x0f, 0xe9, 0x7b,
	0x33, 0x43, 0xfa, 0xde, 0xdf, 0x4a, 0x50, 0x8a, 0x2f, 0xe6, 0xbf, 0xe4, 0xf6, 0xd0, 0x83, 0xf5,
	0xfb, 0x98, 0xc8, 0x51, 0xec, 0xaa, 0xe3, 0xaa, 0xb4, 0xba, 0x3d, 0x31, 0xc8, 0xe9, 0x8e, 0x8b,
	0x75, 0x6c, 0x11, 0x43, 0x35, 0xc7, 0x89, 0x97, 0x1b, 0x30, 0xe7, 0xe2, 0xa6, 0x8b, 0xbd, 0x53,
	0x85, 0xd8, 0x67, 0xd8, 0xf2, 0xdf, 0x4f, 0x09, 0xe2, 0x31, 0xa5, 0x55, 0x4f, 0xe1, 0x56, 0xfa,
	0xa9, 0x85, 0xbb, 0x86, 0xa3, 0x70, 0xd2, 0x70, 0x14, 0xae, 0x7a, 0x0b, 0x4a, 0x32, 0x9f, 0x79,
	0x47, 0x75, 0x54, 0xcd, 0x20, 0xbd, 0x11, 0xc1, 0x54, 0x5d, 0x86, 0xa5, 0x01, 0x09, 0x6e, 0xc2,
	0xcd, 0x8f, 0x20, 0x2b, 0x7e, 0x2a, 0x45, 0x97, 0x61, 0x41, 0xfc, 0xa9, 0x3c, 0x3e, 0x78, 0x70,
	0xf0, 0xe8, 0xc9, 0x41, 0xf1, 0x7f, 0x50, 0x01, 0xb2, 0x87, 0x72, 0x7d, 0x7f, 0x4b, 0xfe, 0xaa,
	0x28, 0xa1, 0x39, 0xc8, 0x1f, 0xed, 0xed, 0x3c, 0x3a, 0xd8, 0xa5, 0xc3, 0xa9, 0x9b, 0x3b, 0x50,
	0x08, 0x61, 0x45, 0x68, 0x09, 0x2e, 0x87, 0x86, 0x21, 0x1d, 0x00, 0x33, 0x07, 0x8f, 0xe4, 0xfd,
	0xad, 0x87, 0x45, 0x09, 0x2d, 0x40, 0xe1, 0xe1, 0xa3, 0x27, 0xca, 0xc3, 0xad, 0xe3, 0xbd, 0x83,
	0x1d, 0xaa, 0xe4, 0x3e, 0x2c, 0xc4, 0x1a, 0x07, 0x74, 0x0d, 0x96, 0x62, 0xa4, 0x98, 0x41, 0x7b,
	0x07, 0xbb, 0xf5, 0x83, 0xfb, 0x45, 0x89, 0x6a, 0xde, 0xda, 0x39, 0xae, 0x9f, 0xec, 0x15, 0xa7,
	0x6e, 0xee, 0xb1, 0x27, 0x27, 0x61, 0x90, 0xb3, 0x02, 0xa5, 0x28, 0x25, 0xa4, 0x26, 0x0f, 0x99,
	0xed, 0xad, 0xa3, 0xfa, 0x4e, 0x51, 0x42, 0xb3, 0x90, 0x3b, 0x3a, 0xde, 0xa2, 0x8b, 0xda, 0x2d,
	0x4e, 0x6d, 0xfc, 0x04, 0x41, 0x65, 0xf8, 0xdb, 0x50, 0xf4, 0x2b, 0x09, 0x16, 0x62, 0xf8, 0x0c,
	0xba, 0x9b, 0x3a, 0xc2, 0x93, 0x7f, 0x25, 0xa9, 0x7c, 0x36, 0xb9, 0x02, 0x11, 0x49, 0x7f, 0x90,
	0xe0, 0x6a, 0x22, 0x66, 0x8a, 0xf6, 0xc6, 0xd5, 0x9d, 0x88, 0xb9, 0x9e, 0x83, 0x89, 0xbf, 0x94,
	0xa0, 0x18, 0x07, 0x72, 0x50, 0x7a, 0xb5, 0x43, 0x30, 0xa0, 0xca, 0x9d, 0x89, 0x34, 0x04, 0x56,
	0xfd, 0x20, 0xc1, 0x1b, 0x23, 0xd1, 0x11, 0xf4, 0xe5, 0x44, 0x93, 0xbc, 0x0c, 0x01, 0xaa, 0xc8,
	0xe7, 0xa9, 0x52, 0x2c, 0xe6, 0x8f, 0x12, 0x94, 0x87, 0xa1, 0x27, 0xe8, 0xf3, 0x89, 0x27, 0x8c,
	0x01, 0x30, 0x95, 0x4f, 0x27, 0xd3, 0x14, 0x0e, 0xd6, 0x52, 0x32, 0x44, 0x83, 0xee, 0x4d, 0x6c,
	0x64, 0x04, 0xe3, 0x79, 0x65, 0x13, 0xbf, 0x97, 0x60, 0x79, 0x28, 0xb8, 0x83, 0xea, 0x93, 0x5a,
	0x39, 0x00, 0x10, 0xbd, 0xb2, 0xa1, 0xdf, 0x49, 0xb0, 0x10, 0xc3, 0x74, 0xc6, 0xc8, 0x47, 0xc9,
	0x68, 0x50, 0x65, 0x82, 0x92, 0xcd, 0x0c, 0x89, 0xb5, 0x68, 0x63, 0x18, 0x92, 0x0c, 0x2c, 0x4d,
	0x64, 0xc8, 0xf7, 0x12, 0xac, 0x8c, 0xe8, 0x15, 0xd1, 0xa3, 0x49, 0x0d, 0x1b, 0xd2, 0x75, 0x4e,
	0x64, 0xe8, 0xcf, 0x24, 0x58, 0x1c, 0x80, 0xde, 0xd1, 0xd6, 0x18, 0x50, 0x49, 0x32, 0x6c, 0x3f,
	0x91, 0x31, 0x7f, 0xe7, 0xe8, 0x75, 0xaa, 0xfe, 0x05, 0xfd, 0x78, 0x9c, 0xa0, 0x1d, 0xa7, 0x1b,
	0xab, 0x7c, 0x75, 0x01, 0x9a, 0xc5, 0x49, 0xa1, 0x95, 0x3b, 0xd6, 0x05, 0x8d, 0x11, 0xa0, 0xc9,
	0x1d, 0xd7, 0x18, 0x65, 0x71, 0x48, 0x03, 0x86, 0x7e, 0x2e, 0xc1, 0x7c, 0xb4, 0x9b, 0x46, 0xe9,
	0x73, 0x42, 0xe2, 0x9d, 0xa2, 0x72, 0x77, 0x62, 0x79, 0x6e, 0xd3, 0xf6, 0x7b, 0x4f, 0x37, 0x27,
	0xf8, 0x2f, 0x33, 0x8d, 0x19, 0x76, 0x9d, 0xdb, 0xfc, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x41,
	0x63, 0x1b, 0xdb, 0x70, 0x33, 0x00, 0x00,
}
