// Code generated by protoc-gen-twirp v8.1.0, DO NOT EDIT.
// source: code.justin.tv/amzn/StarfruitTwitchChannelPropsTwirp/service.proto

package StarfruitTwitchChannelPropsTwirp

import context "context"
import fmt "fmt"
import http "net/http"
import ioutil "io/ioutil"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import bytes "bytes"
import errors "errors"
import io "io"
import path "path"
import url "net/url"

// Version compatibility assertion.
// If the constant is not defined in the package, that likely means
// the package needs to be updated to work with this generated code.
// See https://twitchtv.github.io/twirp/docs/version_matrix.html
const _ = twirp.TwirpPackageMinVersion_8_1_0

// =====================================
// StarfruitTwitchChannelProps Interface
// =====================================

type StarfruitTwitchChannelProps interface {
	// Create a channel with the given id and name.
	//
	// Currently, the name and id must match a user id/name pair in SiteDB's users table.
	// If that user already has a stream_key, this returns a resource-already-exists error.
	// Creating the channel also assigns a new stream_key to the channel (via the users table in SiteDB).
	//
	// Returns [`Channel`](#channel)
	CreateChannel(context.Context, *CreateChannelRequest) (*Channel, error)

	// Update a channel with the given properties
	//
	// Only the properties you specify will be updated. Validation for integers, strings and boolean values is applied.
	//
	// You may update any of the following properties
	// hls_transcode_stack
	// instant_replicate
	// delay_length
	// hls_segment_duration
	// source_restricted
	// autosave_archives
	// delay_controls_enabled
	// latency
	//
	// Returns [`Channel`](#channel)
	UpdateChannel(context.Context, *UpdateChannelRequest) (*Channel, error)

	// Regenerate the stream_key for a channel
	//
	// This may be helpful if it is suspected that a channel's stream_key may have been leaked.
	//
	// Returns an error if there is no channel with the specified id.
	//
	// Returns [`Channel`](#channel) on success.
	RegenerateStreamKey(context.Context, *RegenerateStreamKeyRequest) (*Channel, error)

	// Find a channel with a given id
	//
	// Returns an error if a channel cannot be found.
	//
	// Returns [`Channel`](#channel) on success.
	GetChannelById(context.Context, *GetChannelByIdRequest) (*Channel, error)

	// Find a channel with a given id
	//
	// Returns an error if a channel cannot be found.
	//
	// Returns a translated error message if the broadcaster is not allow to stream
	//
	// Returns [`GetChannelByIdForClientResponse`](#GetChannelByIdForClientResponse) on success.
	GetChannelByIdForClient(context.Context, *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error)

	// Verify a user's stream_key
	//
	// This returns an error if the stream_key is not associated with any user.
	//
	// Returns the [`Channel`](#channel) that stream_key is associated with on success.
	GetChannelByStreamKey(context.Context, *GetChannelByStreamKeyRequest) (*Channel, error)

	// Verify an authorized user's stream_key
	//
	// This returns an error if the stream_key is not associated with any authorized user.
	//
	// Returns the [`Channel`](#channel) that stream_key is authorized for on success.
	GetChannelByAuthorizedStreamKey(context.Context, *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error)

	// Add an authorized user by email address to a channel
	//
	// Currently there is no validation for the email address, and this writes to the authorized_stream_keys
	// table in site_db.
	//
	// This returns an error if the email is blank, or if the channel cannot be found.
	//
	// Returns [`Channel`](#channel) on success.
	AddAuthorizedStreamKey(context.Context, *AddAuthorizedStreamKeyRequest) (*Channel, error)

	// Remove an authorized stream_key by channel id and email address
	//
	// This returns an error if the channel does not exist.
	// This action is idempotent -- performing this action multiple times is safe.
	//
	// Returns [`Channel`](#channel) on success.
	RemoveAuthorizedStreamKey(context.Context, *RemoveAuthorizedStreamKeyRequest) (*Channel, error)

	// Return the health of the service
	GetHealth(context.Context, *GetHealthRequest) (*Health, error)

	// Fetch all waiting partner upgrades from SQS, and upgrade them
	UpgradePartners(context.Context, *UpgradePartnersRequest) (*UpgradePartnersResponse, error)

	// Get a channel info using a stream key.
	GetChannelInfoByStreamKey(context.Context, *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error)

	// Get a channel info using an authorized stream key.
	GetChannelInfoByAuthorizedStreamKey(context.Context, *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error)
}

// ===========================================
// StarfruitTwitchChannelProps Protobuf Client
// ===========================================

type starfruitTwitchChannelPropsProtobufClient struct {
	client      HTTPClient
	urls        [13]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewStarfruitTwitchChannelPropsProtobufClient creates a Protobuf client that implements the StarfruitTwitchChannelProps interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewStarfruitTwitchChannelPropsProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) StarfruitTwitchChannelProps {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "twitch.video.starfruittwitchchannelprops", "StarfruitTwitchChannelProps")
	urls := [13]string{
		serviceURL + "CreateChannel",
		serviceURL + "UpdateChannel",
		serviceURL + "RegenerateStreamKey",
		serviceURL + "GetChannelById",
		serviceURL + "GetChannelByIdForClient",
		serviceURL + "GetChannelByStreamKey",
		serviceURL + "GetChannelByAuthorizedStreamKey",
		serviceURL + "AddAuthorizedStreamKey",
		serviceURL + "RemoveAuthorizedStreamKey",
		serviceURL + "GetHealth",
		serviceURL + "UpgradePartners",
		serviceURL + "GetChannelInfoByStreamKey",
		serviceURL + "GetChannelInfoByAuthorizedStreamKey",
	}

	return &starfruitTwitchChannelPropsProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *starfruitTwitchChannelPropsProtobufClient) CreateChannel(ctx context.Context, in *CreateChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannel")
	caller := c.callCreateChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateChannelRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateChannelRequest) when calling interceptor")
					}
					return c.callCreateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callCreateChannel(ctx context.Context, in *CreateChannelRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) UpdateChannel(ctx context.Context, in *UpdateChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannel")
	caller := c.callUpdateChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateChannelRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateChannelRequest) when calling interceptor")
					}
					return c.callUpdateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callUpdateChannel(ctx context.Context, in *UpdateChannelRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) RegenerateStreamKey(ctx context.Context, in *RegenerateStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "RegenerateStreamKey")
	caller := c.callRegenerateStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RegenerateStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RegenerateStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RegenerateStreamKeyRequest) when calling interceptor")
					}
					return c.callRegenerateStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callRegenerateStreamKey(ctx context.Context, in *RegenerateStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) GetChannelById(ctx context.Context, in *GetChannelByIdRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelById")
	caller := c.callGetChannelById
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelByIdRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByIdRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByIdRequest) when calling interceptor")
					}
					return c.callGetChannelById(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callGetChannelById(ctx context.Context, in *GetChannelByIdRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) GetChannelByIdForClient(ctx context.Context, in *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByIdForClient")
	caller := c.callGetChannelByIdForClient
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByIdForClientRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByIdForClientRequest) when calling interceptor")
					}
					return c.callGetChannelByIdForClient(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelByIdForClientResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelByIdForClientResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callGetChannelByIdForClient(ctx context.Context, in *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error) {
	out := new(GetChannelByIdForClientResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) GetChannelByStreamKey(ctx context.Context, in *GetChannelByStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByStreamKey")
	caller := c.callGetChannelByStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelByStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByStreamKeyRequest) when calling interceptor")
					}
					return c.callGetChannelByStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callGetChannelByStreamKey(ctx context.Context, in *GetChannelByStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) GetChannelByAuthorizedStreamKey(ctx context.Context, in *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByAuthorizedStreamKey")
	caller := c.callGetChannelByAuthorizedStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return c.callGetChannelByAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callGetChannelByAuthorizedStreamKey(ctx context.Context, in *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) AddAuthorizedStreamKey(ctx context.Context, in *AddAuthorizedStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "AddAuthorizedStreamKey")
	caller := c.callAddAuthorizedStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *AddAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AddAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AddAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return c.callAddAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callAddAuthorizedStreamKey(ctx context.Context, in *AddAuthorizedStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) RemoveAuthorizedStreamKey(ctx context.Context, in *RemoveAuthorizedStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAuthorizedStreamKey")
	caller := c.callRemoveAuthorizedStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RemoveAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RemoveAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RemoveAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return c.callRemoveAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callRemoveAuthorizedStreamKey(ctx context.Context, in *RemoveAuthorizedStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) GetHealth(ctx context.Context, in *GetHealthRequest) (*Health, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	caller := c.callGetHealth
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetHealthRequest) (*Health, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetHealthRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetHealthRequest) when calling interceptor")
					}
					return c.callGetHealth(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Health)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Health) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callGetHealth(ctx context.Context, in *GetHealthRequest) (*Health, error) {
	out := new(Health)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) UpgradePartners(ctx context.Context, in *UpgradePartnersRequest) (*UpgradePartnersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "UpgradePartners")
	caller := c.callUpgradePartners
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpgradePartnersRequest) (*UpgradePartnersResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpgradePartnersRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpgradePartnersRequest) when calling interceptor")
					}
					return c.callUpgradePartners(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpgradePartnersResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpgradePartnersResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callUpgradePartners(ctx context.Context, in *UpgradePartnersRequest) (*UpgradePartnersResponse, error) {
	out := new(UpgradePartnersResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) GetChannelInfoByStreamKey(ctx context.Context, in *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelInfoByStreamKey")
	caller := c.callGetChannelInfoByStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelInfoByStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelInfoByStreamKeyRequest) when calling interceptor")
					}
					return c.callGetChannelInfoByStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callGetChannelInfoByStreamKey(ctx context.Context, in *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsProtobufClient) GetChannelInfoByAuthorizedStreamKey(ctx context.Context, in *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelInfoByAuthorizedStreamKey")
	caller := c.callGetChannelInfoByAuthorizedStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelInfoByAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelInfoByAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return c.callGetChannelInfoByAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsProtobufClient) callGetChannelInfoByAuthorizedStreamKey(ctx context.Context, in *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =======================================
// StarfruitTwitchChannelProps JSON Client
// =======================================

type starfruitTwitchChannelPropsJSONClient struct {
	client      HTTPClient
	urls        [13]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewStarfruitTwitchChannelPropsJSONClient creates a JSON client that implements the StarfruitTwitchChannelProps interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewStarfruitTwitchChannelPropsJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) StarfruitTwitchChannelProps {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "twitch.video.starfruittwitchchannelprops", "StarfruitTwitchChannelProps")
	urls := [13]string{
		serviceURL + "CreateChannel",
		serviceURL + "UpdateChannel",
		serviceURL + "RegenerateStreamKey",
		serviceURL + "GetChannelById",
		serviceURL + "GetChannelByIdForClient",
		serviceURL + "GetChannelByStreamKey",
		serviceURL + "GetChannelByAuthorizedStreamKey",
		serviceURL + "AddAuthorizedStreamKey",
		serviceURL + "RemoveAuthorizedStreamKey",
		serviceURL + "GetHealth",
		serviceURL + "UpgradePartners",
		serviceURL + "GetChannelInfoByStreamKey",
		serviceURL + "GetChannelInfoByAuthorizedStreamKey",
	}

	return &starfruitTwitchChannelPropsJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *starfruitTwitchChannelPropsJSONClient) CreateChannel(ctx context.Context, in *CreateChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannel")
	caller := c.callCreateChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateChannelRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateChannelRequest) when calling interceptor")
					}
					return c.callCreateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callCreateChannel(ctx context.Context, in *CreateChannelRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) UpdateChannel(ctx context.Context, in *UpdateChannelRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannel")
	caller := c.callUpdateChannel
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpdateChannelRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateChannelRequest) when calling interceptor")
					}
					return c.callUpdateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callUpdateChannel(ctx context.Context, in *UpdateChannelRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) RegenerateStreamKey(ctx context.Context, in *RegenerateStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "RegenerateStreamKey")
	caller := c.callRegenerateStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RegenerateStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RegenerateStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RegenerateStreamKeyRequest) when calling interceptor")
					}
					return c.callRegenerateStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callRegenerateStreamKey(ctx context.Context, in *RegenerateStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) GetChannelById(ctx context.Context, in *GetChannelByIdRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelById")
	caller := c.callGetChannelById
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelByIdRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByIdRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByIdRequest) when calling interceptor")
					}
					return c.callGetChannelById(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callGetChannelById(ctx context.Context, in *GetChannelByIdRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) GetChannelByIdForClient(ctx context.Context, in *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByIdForClient")
	caller := c.callGetChannelByIdForClient
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByIdForClientRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByIdForClientRequest) when calling interceptor")
					}
					return c.callGetChannelByIdForClient(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelByIdForClientResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelByIdForClientResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callGetChannelByIdForClient(ctx context.Context, in *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error) {
	out := new(GetChannelByIdForClientResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) GetChannelByStreamKey(ctx context.Context, in *GetChannelByStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByStreamKey")
	caller := c.callGetChannelByStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelByStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByStreamKeyRequest) when calling interceptor")
					}
					return c.callGetChannelByStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callGetChannelByStreamKey(ctx context.Context, in *GetChannelByStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) GetChannelByAuthorizedStreamKey(ctx context.Context, in *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByAuthorizedStreamKey")
	caller := c.callGetChannelByAuthorizedStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return c.callGetChannelByAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callGetChannelByAuthorizedStreamKey(ctx context.Context, in *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) AddAuthorizedStreamKey(ctx context.Context, in *AddAuthorizedStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "AddAuthorizedStreamKey")
	caller := c.callAddAuthorizedStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *AddAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AddAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AddAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return c.callAddAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callAddAuthorizedStreamKey(ctx context.Context, in *AddAuthorizedStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) RemoveAuthorizedStreamKey(ctx context.Context, in *RemoveAuthorizedStreamKeyRequest) (*Channel, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAuthorizedStreamKey")
	caller := c.callRemoveAuthorizedStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *RemoveAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RemoveAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RemoveAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return c.callRemoveAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callRemoveAuthorizedStreamKey(ctx context.Context, in *RemoveAuthorizedStreamKeyRequest) (*Channel, error) {
	out := new(Channel)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) GetHealth(ctx context.Context, in *GetHealthRequest) (*Health, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	caller := c.callGetHealth
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetHealthRequest) (*Health, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetHealthRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetHealthRequest) when calling interceptor")
					}
					return c.callGetHealth(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Health)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Health) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callGetHealth(ctx context.Context, in *GetHealthRequest) (*Health, error) {
	out := new(Health)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) UpgradePartners(ctx context.Context, in *UpgradePartnersRequest) (*UpgradePartnersResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "UpgradePartners")
	caller := c.callUpgradePartners
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *UpgradePartnersRequest) (*UpgradePartnersResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpgradePartnersRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpgradePartnersRequest) when calling interceptor")
					}
					return c.callUpgradePartners(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpgradePartnersResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpgradePartnersResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callUpgradePartners(ctx context.Context, in *UpgradePartnersRequest) (*UpgradePartnersResponse, error) {
	out := new(UpgradePartnersResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) GetChannelInfoByStreamKey(ctx context.Context, in *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelInfoByStreamKey")
	caller := c.callGetChannelInfoByStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelInfoByStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelInfoByStreamKeyRequest) when calling interceptor")
					}
					return c.callGetChannelInfoByStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callGetChannelInfoByStreamKey(ctx context.Context, in *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *starfruitTwitchChannelPropsJSONClient) GetChannelInfoByAuthorizedStreamKey(ctx context.Context, in *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelInfoByAuthorizedStreamKey")
	caller := c.callGetChannelInfoByAuthorizedStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelInfoByAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelInfoByAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return c.callGetChannelInfoByAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *starfruitTwitchChannelPropsJSONClient) callGetChannelInfoByAuthorizedStreamKey(ctx context.Context, in *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error) {
	out := new(ChannelInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==========================================
// StarfruitTwitchChannelProps Server Handler
// ==========================================

type starfruitTwitchChannelPropsServer struct {
	StarfruitTwitchChannelProps
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
	jsonCamelCase    bool   // JSON fields are serialized as lowerCamelCase rather than keeping the original proto names
}

// NewStarfruitTwitchChannelPropsServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewStarfruitTwitchChannelPropsServer(svc StarfruitTwitchChannelProps, opts ...interface{}) TwirpServer {
	serverOpts := newServerOpts(opts)

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	jsonSkipDefaults := false
	_ = serverOpts.ReadOpt("jsonSkipDefaults", &jsonSkipDefaults)
	jsonCamelCase := false
	_ = serverOpts.ReadOpt("jsonCamelCase", &jsonCamelCase)
	var pathPrefix string
	if ok := serverOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	return &starfruitTwitchChannelPropsServer{
		StarfruitTwitchChannelProps: svc,
		hooks:                       serverOpts.Hooks,
		interceptor:                 twirp.ChainInterceptors(serverOpts.Interceptors...),
		pathPrefix:                  pathPrefix,
		jsonSkipDefaults:            jsonSkipDefaults,
		jsonCamelCase:               jsonCamelCase,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *starfruitTwitchChannelPropsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *starfruitTwitchChannelPropsServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// StarfruitTwitchChannelPropsPathPrefix is a convenience constant that may identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// with the default "/twirp" prefix and default CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const StarfruitTwitchChannelPropsPathPrefix = "/twirp/twitch.video.starfruittwitchchannelprops.StarfruitTwitchChannelProps/"

func (s *starfruitTwitchChannelPropsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twitch.video.starfruittwitchchannelprops")
	ctx = ctxsetters.WithServiceName(ctx, "StarfruitTwitchChannelProps")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "twitch.video.starfruittwitchchannelprops.StarfruitTwitchChannelProps" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "CreateChannel":
		s.serveCreateChannel(ctx, resp, req)
		return
	case "UpdateChannel":
		s.serveUpdateChannel(ctx, resp, req)
		return
	case "RegenerateStreamKey":
		s.serveRegenerateStreamKey(ctx, resp, req)
		return
	case "GetChannelById":
		s.serveGetChannelById(ctx, resp, req)
		return
	case "GetChannelByIdForClient":
		s.serveGetChannelByIdForClient(ctx, resp, req)
		return
	case "GetChannelByStreamKey":
		s.serveGetChannelByStreamKey(ctx, resp, req)
		return
	case "GetChannelByAuthorizedStreamKey":
		s.serveGetChannelByAuthorizedStreamKey(ctx, resp, req)
		return
	case "AddAuthorizedStreamKey":
		s.serveAddAuthorizedStreamKey(ctx, resp, req)
		return
	case "RemoveAuthorizedStreamKey":
		s.serveRemoveAuthorizedStreamKey(ctx, resp, req)
		return
	case "GetHealth":
		s.serveGetHealth(ctx, resp, req)
		return
	case "UpgradePartners":
		s.serveUpgradePartners(ctx, resp, req)
		return
	case "GetChannelInfoByStreamKey":
		s.serveGetChannelInfoByStreamKey(ctx, resp, req)
		return
	case "GetChannelInfoByAuthorizedStreamKey":
		s.serveGetChannelInfoByAuthorizedStreamKey(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *starfruitTwitchChannelPropsServer) serveCreateChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveCreateChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CreateChannelRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.CreateChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateChannelRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateChannelRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.CreateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling CreateChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveCreateChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CreateChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.CreateChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateChannelRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateChannelRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.CreateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling CreateChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveUpdateChannel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateChannelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateChannelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveUpdateChannelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(UpdateChannelRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.UpdateChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateChannelRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateChannelRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.UpdateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling UpdateChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveUpdateChannelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateChannel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(UpdateChannelRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.UpdateChannel
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpdateChannelRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpdateChannelRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpdateChannelRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.UpdateChannel(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling UpdateChannel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveRegenerateStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRegenerateStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRegenerateStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveRegenerateStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegenerateStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(RegenerateStreamKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.RegenerateStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RegenerateStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RegenerateStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RegenerateStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.RegenerateStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling RegenerateStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveRegenerateStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RegenerateStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(RegenerateStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.RegenerateStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RegenerateStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RegenerateStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RegenerateStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.RegenerateStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling RegenerateStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelById(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelByIdJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelByIdProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByIdJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelById")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetChannelByIdRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelById
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelByIdRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByIdRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByIdRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelById(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannelById. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByIdProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelById")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetChannelByIdRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelById
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelByIdRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByIdRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByIdRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelById(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannelById. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByIdForClient(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelByIdForClientJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelByIdForClientProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByIdForClientJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByIdForClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetChannelByIdForClientRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelByIdForClient
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByIdForClientRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByIdForClientRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelByIdForClient(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelByIdForClientResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelByIdForClientResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetChannelByIdForClientResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelByIdForClientResponse and nil error while calling GetChannelByIdForClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByIdForClientProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByIdForClient")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetChannelByIdForClientRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelByIdForClient
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelByIdForClientRequest) (*GetChannelByIdForClientResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByIdForClientRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByIdForClientRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelByIdForClient(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelByIdForClientResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelByIdForClientResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetChannelByIdForClientResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelByIdForClientResponse and nil error while calling GetChannelByIdForClient. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelByStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelByStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetChannelByStreamKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelByStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelByStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelByStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannelByStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetChannelByStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelByStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelByStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelByStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannelByStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByAuthorizedStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelByAuthorizedStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelByAuthorizedStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByAuthorizedStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByAuthorizedStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetChannelByAuthorizedStreamKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelByAuthorizedStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelByAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannelByAuthorizedStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelByAuthorizedStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelByAuthorizedStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetChannelByAuthorizedStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelByAuthorizedStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelByAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelByAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelByAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelByAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling GetChannelByAuthorizedStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveAddAuthorizedStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveAddAuthorizedStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveAddAuthorizedStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveAddAuthorizedStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddAuthorizedStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(AddAuthorizedStreamKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.AddAuthorizedStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *AddAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AddAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AddAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.AddAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling AddAuthorizedStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveAddAuthorizedStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "AddAuthorizedStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(AddAuthorizedStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.AddAuthorizedStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *AddAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*AddAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*AddAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.AddAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling AddAuthorizedStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveRemoveAuthorizedStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRemoveAuthorizedStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRemoveAuthorizedStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveRemoveAuthorizedStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAuthorizedStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(RemoveAuthorizedStreamKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.RemoveAuthorizedStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RemoveAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RemoveAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RemoveAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.RemoveAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling RemoveAuthorizedStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveRemoveAuthorizedStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RemoveAuthorizedStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(RemoveAuthorizedStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.RemoveAuthorizedStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *RemoveAuthorizedStreamKeyRequest) (*Channel, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*RemoveAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*RemoveAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.RemoveAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Channel)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Channel) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Channel
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Channel and nil error while calling RemoveAuthorizedStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveGetHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetHealthRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetHealth
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetHealthRequest) (*Health, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetHealthRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetHealthRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetHealth(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Health)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Health) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Health
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Health and nil error while calling GetHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetHealthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetHealth
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetHealthRequest) (*Health, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetHealthRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetHealthRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetHealth(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*Health)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*Health) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *Health
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Health and nil error while calling GetHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveUpgradePartners(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpgradePartnersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpgradePartnersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveUpgradePartnersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpgradePartners")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(UpgradePartnersRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.UpgradePartners
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpgradePartnersRequest) (*UpgradePartnersResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpgradePartnersRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpgradePartnersRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.UpgradePartners(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpgradePartnersResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpgradePartnersResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *UpgradePartnersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpgradePartnersResponse and nil error while calling UpgradePartners. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveUpgradePartnersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpgradePartners")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(UpgradePartnersRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.UpgradePartners
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *UpgradePartnersRequest) (*UpgradePartnersResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*UpgradePartnersRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*UpgradePartnersRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.UpgradePartners(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*UpgradePartnersResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*UpgradePartnersResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *UpgradePartnersResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpgradePartnersResponse and nil error while calling UpgradePartners. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelInfoByStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelInfoByStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelInfoByStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelInfoByStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelInfoByStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetChannelInfoByStreamKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelInfoByStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelInfoByStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelInfoByStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelInfoByStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling GetChannelInfoByStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelInfoByStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelInfoByStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetChannelInfoByStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelInfoByStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelInfoByStreamKeyRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelInfoByStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelInfoByStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelInfoByStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling GetChannelInfoByStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelInfoByAuthorizedStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelInfoByAuthorizedStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelInfoByAuthorizedStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelInfoByAuthorizedStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelInfoByAuthorizedStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetChannelInfoByAuthorizedStreamKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelInfoByAuthorizedStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelInfoByAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelInfoByAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelInfoByAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling GetChannelInfoByAuthorizedStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) serveGetChannelInfoByAuthorizedStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelInfoByAuthorizedStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetChannelInfoByAuthorizedStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.StarfruitTwitchChannelProps.GetChannelInfoByAuthorizedStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelInfoByAuthorizedStreamKeyRequest) (*ChannelInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelInfoByAuthorizedStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelInfoByAuthorizedStreamKeyRequest) when calling interceptor")
					}
					return s.StarfruitTwitchChannelProps.GetChannelInfoByAuthorizedStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ChannelInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ChannelInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ChannelInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ChannelInfo and nil error while calling GetChannelInfoByAuthorizedStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *starfruitTwitchChannelPropsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *starfruitTwitchChannelPropsServer) ProtocGenTwirpVersion() string {
	return "v8.1.0"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *starfruitTwitchChannelPropsServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "twitch.video.starfruittwitchchannelprops", "StarfruitTwitchChannelProps")
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler

	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// google.golang.org/protobuf/types/descriptorpb.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)

	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string

	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route Twirp requests.
	// The path prefix is in the form: "/<prefix>/<package>.<Service>/"
	// that is, everything in a Twirp route except for the <Method> at the end.
	PathPrefix() string
}

func newServerOpts(opts []interface{}) *twirp.ServerOptions {
	serverOpts := &twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T, please use a twirp.ServerOption", o))
		}
	}
	return serverOpts
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Convert to a twirp.Error. Non-twirp errors are converted to internal errors.
	var twerr twirp.Error
	if !errors.As(err, &twerr) {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// sanitizeBaseURL parses the the baseURL, and adds the "http" scheme if needed.
// If the URL is unparsable, the baseURL is returned unchaged.
func sanitizeBaseURL(baseURL string) string {
	u, err := url.Parse(baseURL)
	if err != nil {
		return baseURL // invalid URL will fail later when making requests
	}
	if u.Scheme == "" {
		u.Scheme = "http"
	}
	return u.String()
}

// baseServicePath composes the path prefix for the service (without <Method>).
// e.g.: baseServicePath("/twirp", "my.pkg", "MyService")
//       returns => "/twirp/my.pkg.MyService/"
// e.g.: baseServicePath("", "", "MyService")
//       returns => "/MyService/"
func baseServicePath(prefix, pkg, service string) string {
	fullServiceName := service
	if pkg != "" {
		fullServiceName = pkg + "." + service
	}
	return path.Join("/", prefix, fullServiceName) + "/"
}

// parseTwirpPath extracts path components form a valid Twirp route.
// Expected format: "[<prefix>]/<package>.<Service>/<Method>"
// e.g.: prefix, pkgService, method := parseTwirpPath("/twirp/pkg.Svc/MakeHat")
func parseTwirpPath(path string) (string, string, string) {
	parts := strings.Split(path, "/")
	if len(parts) < 2 {
		return "", "", ""
	}
	method := parts[len(parts)-1]
	pkgService := parts[len(parts)-2]
	prefix := strings.Join(parts[0:len(parts)-2], "/")
	return prefix, pkgService, method
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v8.1.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429: // Too Many Requests
			code = twirp.ResourceExhausted
		case 502, 503, 504: // Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	marshaler := &protojson.MarshalOptions{UseProtoNames: true}
	reqBytes, err := marshaler.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, bytes.NewReader(reqBytes), "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	d := json.NewDecoder(resp.Body)
	rawRespBody := json.RawMessage{}
	if err := d.Decode(&rawRespBody); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawRespBody, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 472 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x96, 0xbf, 0x6f, 0xd3, 0x40,
	0x14, 0xc7, 0x73, 0x0b, 0x12, 0x27, 0x41, 0xa5, 0x43, 0x80, 0x1a, 0x06, 0x24, 0xb3, 0x30, 0x39,
	0xfc, 0x1e, 0x18, 0x80, 0xc4, 0x55, 0xd3, 0x94, 0x25, 0x4a, 0xd3, 0x85, 0xed, 0xf0, 0xbd, 0xd6,
	0x87, 0x92, 0x3b, 0x73, 0xf7, 0xec, 0xaa, 0x65, 0x45, 0xcc, 0x0c, 0x08, 0x31, 0x30, 0x30, 0x32,
	0x32, 0xf0, 0x37, 0xf1, 0x77, 0xa0, 0xe6, 0xe2, 0x26, 0xae, 0xdc, 0xca, 0x3e, 0x77, 0xcc, 0xe9,
	0xbe, 0x9f, 0xf7, 0x89, 0xde, 0x7b, 0xd6, 0xd1, 0x41, 0xac, 0x05, 0x84, 0x1f, 0x32, 0x8b, 0x52,
	0x85, 0x98, 0xf7, 0xf8, 0xfc, 0x44, 0xf5, 0xf6, 0x90, 0x9b, 0x03, 0x93, 0x49, 0x9c, 0x1e, 0x49,
	0x8c, 0x93, 0x28, 0xe1, 0x4a, 0xc1, 0x6c, 0x6c, 0x74, 0x6a, 0xa7, 0x47, 0xd2, 0xa4, 0x3d, 0x0b,
	0x26, 0x97, 0x31, 0x84, 0xa9, 0xd1, 0xa8, 0xd9, 0x43, 0x5c, 0x5c, 0x0b, 0x73, 0x29, 0x40, 0x87,
	0xb6, 0x08, 0xbb, 0xd3, 0xd8, 0x85, 0xd3, 0xd3, 0x70, 0x37, 0xf2, 0xaa, 0x66, 0xe0, 0x63, 0x06,
	0x16, 0xad, 0x2b, 0xd7, 0xdd, 0xf2, 0x84, 0xd8, 0x54, 0x2b, 0x0b, 0x4b, 0xca, 0x93, 0x7f, 0x1b,
	0xf4, 0xde, 0x25, 0x21, 0xf6, 0x99, 0xd0, 0x1b, 0x91, 0x01, 0x8e, 0xb0, 0x3c, 0x66, 0xaf, 0xc2,
	0xba, 0xff, 0x33, 0x2c, 0x05, 0x27, 0x4e, 0xbf, 0xfb, 0xb8, 0x41, 0xde, 0xfd, 0x08, 0x3a, 0x0b,
	0x8d, 0xfd, 0x54, 0xf8, 0x69, 0x94, 0x82, 0xad, 0x34, 0xbe, 0x12, 0x7a, 0x6b, 0x02, 0x87, 0xa0,
	0xc0, 0x70, 0x84, 0x3d, 0x34, 0xc0, 0xe7, 0x6f, 0xe1, 0x98, 0x6d, 0xd5, 0x87, 0x55, 0xc4, 0x5b,
	0x29, 0x7d, 0x21, 0xf4, 0xe6, 0x10, 0x70, 0x79, 0x30, 0x38, 0x1e, 0x09, 0xf6, 0xba, 0x3e, 0xa7,
	0x9c, 0x6c, 0x25, 0xf2, 0x87, 0xd0, 0xbb, 0x65, 0xdc, 0xb6, 0x36, 0xd1, 0x4c, 0x82, 0x42, 0xb6,
	0xe3, 0x6b, 0x74, 0x86, 0x28, 0xd4, 0x46, 0x57, 0x40, 0x72, 0x1b, 0x10, 0x74, 0xd8, 0x37, 0x42,
	0x6f, 0xaf, 0xdf, 0x5a, 0x35, 0x74, 0xdb, 0xaf, 0xcc, 0xd5, 0xb4, 0xf4, 0x37, 0xa1, 0xf7, 0xd7,
	0xa9, 0xfd, 0x0c, 0x13, 0x6d, 0xe4, 0x09, 0x88, 0x95, 0xe0, 0xd8, 0x4f, 0xb0, 0x02, 0xd5, 0x4a,
	0xf5, 0x3b, 0xa1, 0x77, 0xfa, 0x42, 0x54, 0x19, 0x0e, 0xeb, 0xf3, 0xaa, 0x09, 0xad, 0xc4, 0x7e,
	0x12, 0xba, 0x39, 0x81, 0xb9, 0xce, 0xa1, 0xca, 0x6d, 0xb7, 0xc9, 0xbe, 0x5e, 0x00, 0x69, 0xa5,
	0xf7, 0x89, 0x5e, 0x1f, 0x02, 0xee, 0x00, 0x9f, 0x61, 0xc2, 0x5e, 0x36, 0xea, 0xa5, 0x0b, 0x15,
	0xd5, 0x1f, 0xd5, 0xcf, 0xba, 0x60, 0xd0, 0x61, 0x3f, 0x08, 0xdd, 0xd8, 0x4f, 0x0f, 0x0d, 0x17,
	0x30, 0xe6, 0x06, 0x15, 0x18, 0xcb, 0xde, 0x34, 0xf9, 0x9c, 0x96, 0xa2, 0x85, 0x49, 0xbf, 0x05,
	0xe1, 0x6c, 0x23, 0x7f, 0x11, 0xba, 0xb9, 0x9a, 0xd7, 0x91, 0x3a, 0xd0, 0xeb, 0x5b, 0xb9, 0xeb,
	0x33, 0xf4, 0xe7, 0x20, 0x85, 0xee, 0xf3, 0xc6, 0x6d, 0x3b, 0x05, 0x05, 0x1d, 0xf6, 0x97, 0xd0,
	0x07, 0xe7, 0xe9, 0x55, 0x33, 0x36, 0xf5, 0x97, 0xbd, 0x64, 0xda, 0x7c, 0xb5, 0x07, 0x2f, 0xde,
	0x3d, 0xf3, 0x79, 0x30, 0xbc, 0xbf, 0xb6, 0x78, 0x27, 0x3c, 0xfd, 0x1f, 0x00, 0x00, 0xff, 0xff,
	0xe4, 0x13, 0xee, 0x93, 0x22, 0x09, 0x00, 0x00,
}
