# `StarfruitVault`

This is the primary library for vault. A library to help rotate and distribute secrets to client services of the video platform.


## Onboarding

- Services MUST alert if Maximum Fetch Age is greater than threshold (recommendation: 2 hours)
- Service API handling requests passed via the user SHOULD validate providerID is allowed to produce token in an application aware context
    i.e. Video Origin in ProducerID matches the application data

### Producer
```go
	encodeVault, err := vault.NewEncodeVault(&vault.EncodeVaultConfig{})
	if err != nil { return err }

	encodeHooks := provider.NewHooks()
	encodeHooks.RegisterOnFetch(encodeVault.OnKeys)

	metricReporter := metrics.NewMetricReporter(twitchTelemetry)
	metricReporter.RegisterProviderHooks(encodeHooks)

	encodeProvider, err := NewAWSProvider(&Config{
		Session:        awsSession,,
		SecretIDs:      []string{"secret_arn"},
		Hooks:          encodeHooks,
	})
	if err != nil { return err }
    
	err = encodeProvider.Fetch(ctx)   
	if err != nil { return err }

	runInBackground(encodeProvider.Run(ctx))
```

# Consumer
```go
	decodeVault, err := vault.NewDecodeVault(&vault.DecodeVaultConfig{
		V1ProducerID: "weaver-legacy",
	})
	if err != nil { return err }

	decodeHooks := provider.NewHooks()
	decodeHooks.RegisterOnFetch(decodeVault.OnKeys)

	metricReporter := metrics.NewMetricReporter(twitchTelemetry)
	metricReporter.RegisterProviderHooks(decodeHooks)

	decodeProvider, err := NewAWSProvider(&Config{
		Session:        awsSession,,
		SecretIDs:      []string{"secret_arn"},
		Hooks:          encodeHooks,
	})
	if err != nil { return err }

	err = decodeProvider.Fetch(ctx)   
	if err != nil { return err }

	runInBackground(decodeProvider.Run(ctx))
```
