package key

type noopKey struct{}

var (
	_ EncryptionKey = (*noopKey)(nil)
	_ SignatureKey  = (*noopKey)(nil)
)

func (k noopKey) KeyType() KeyType {
	return KeyTypeNoop
}

func (k noopKey) Key() []byte {
	return nil
}

func (k noopKey) NonceSize() int {
	return 0
}

func (k noopKey) Encrypt(_, in []byte) ([]byte, error) {
	return in, nil
}

func (k noopKey) Decrypt(_, in []byte) ([]byte, error) {
	return in, nil
}

func (k noopKey) Sign(_ []byte) ([]byte, error) {
	return []byte{}, nil
}

func (k noopKey) Verify(_, _ []byte) (bool, error) {
	return true, nil
}

func (k noopKey) Public() (SignatureKey, error) {
	return k, nil
}
