package metrics

import (
	"time"

	"code.justin.tv/amzn/StarfruitVault/provider"

	"code.justin.tv/amzn/StarfruitVault/key"
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
)

type metricReporter struct {
	reporter telemetry.SampleReporter
}

func cloneDimensions(in map[string]string) map[string]string {
	out := make(map[string]string, len(in)+1)
	for k, v := range in {
		out[k] = v
	}
	return out
}

func NewMetricReporter(reporter *telemetry.SampleReporter) *metricReporter {
	return &metricReporter{*reporter}
}

func (m *metricReporter) ReportFetchSuccess(secretID string, set *key.KeySet) {
	// Report rolled up metric
	reporter := m.reporter
	reporter.Report("VaultFetchSuccess", 1, telemetry.UnitCount)

	reporter.Dimensions = cloneDimensions(reporter.Dimensions)
	reporter.Dimensions["SecretID"] = secretID
	reporter.SkipUnrecognizedDimensionsInRollup = true
	reporter.Report("VaultFetchSuccess", 1, telemetry.UnitCount)
}

func (m *metricReporter) ReportFetchError(secretID string, err error) {
	// Report rolled up metric
	reporter := m.reporter
	reporter.Report("VaultFetchError", 1, telemetry.UnitCount)

	// Report metrics per `SecretID`
	reporter.Dimensions = cloneDimensions(reporter.Dimensions)
	reporter.Dimensions["SecretID"] = secretID
	reporter.SkipUnrecognizedDimensionsInRollup = true
	reporter.Report("VaultFetchError", 1, telemetry.UnitCount)
}

func (m *metricReporter) ReportFetchAge(secretID string, age time.Duration) {
	// Report rolled up metric
	reporter := m.reporter
	reporter.Report("VaultFetchAge", age.Seconds(), telemetry.UnitSeconds)

	// Report metrics per `SecretID`
	reporter.Dimensions = cloneDimensions(reporter.Dimensions)
	reporter.Dimensions["SecretID"] = secretID
	reporter.SkipUnrecognizedDimensionsInRollup = true
	reporter.Report("VaultFetchAge", age.Seconds(), telemetry.UnitSeconds)
}

func (m *metricReporter) RegisterProviderHooks(hooks provider.Hooks) {
	hooks.RegisterOnFetch(m.ReportFetchSuccess)
	hooks.RegisterOnAge(m.ReportFetchAge)
	hooks.RegisterOnError(m.ReportFetchError)
}
